#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdio.h>


int DisplaySyntax(void)
{
  printf("Syntax:  proxysig [-update | -shutdown | -reload]\n");
  return 1;
}

int main(int argc, char *argv[])
{
  HANDLE hEvent;
  LPCSTR szEventName;


  if (argc != 2) {
    return DisplaySyntax();
  }
  if (lstrcmpi(argv[1], "-update") == 0) {
    szEventName = "ProxyperConnectEvent";
  } else if (lstrcmpi(argv[1], "-shutdown") == 0) {
    szEventName = "ProxyperShutdownEvent";
  } else if (lstrcmpi(argv[1], "-reload") == 0) {
    szEventName = "ProxyperReloadEvent";
  } else {
    return DisplaySyntax();
  }


  hEvent = OpenEvent(EVENT_MODIFY_STATE, FALSE, szEventName);
  if (!hEvent) {
    printf("Unable to open the requested event.  Ensure proxy is running.\n");
    return 2;
  }
  if (!SetEvent(hEvent)) {
    printf("Unable to signal the requested event.  Ensure proxy is running.\n");
    return 3;
  }
  printf("Successfully sent signal.\n");
  return 0;
}



