import { TalerFormAttributes } from "@gnu-taler/taler-util";
import {
  DoubleColumnFormDesign,
  FormMetadata,
  InternationalizationAPI,
} from "../../index.browser.js";

export const form_gls_wallet_confirmation = (
  i18n: InternationalizationAPI,
): FormMetadata => ({
  config: gls_wallet_confirmation(i18n, {}),
  id: "gls-wallet-confirmation",
  label: "GLS Wallet Confirmation",
  version: 1,
});

export function gls_wallet_confirmation(
  i18n: InternationalizationAPI,
  context?: any,
): DoubleColumnFormDesign {
  return {
    type: "double-column",
    title: "GLS Wallet Confirmation",
    sections: [
      {
        title: i18n.str`Confirmation`,
        description: i18n.str`Confirmation of private customer / wallet.`,
        fields: [
          {
            id: TalerFormAttributes.WALLET_USER_IS_PRIVATE_CUSTOMER,
            label: i18n.str`Please confirm that you are a private customer that wants to redeem their wallet balance.`,
            type: "choiceHorizontal",
            required: true,
            choices: [
              {
                label: "Yes",
                value: true,
              },
              {
                label: "No",
                value: false,
              },
            ],
          },
        ],
      },
    ],
  };
}
