/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.constructors.LineConstructor;
import rene.zirkel.expression.Expression;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.SegmentObject;

public class SegmentConstructor
extends LineConstructor {
    boolean Fixed = false;

    public SegmentConstructor() {
        this(false);
    }

    public SegmentConstructor(boolean bl) {
        this.Fixed = bl;
    }

    public ConstructionObject create(Construction construction, PointObject pointObject, PointObject pointObject2) {
        return new SegmentObject(construction, pointObject, pointObject2);
    }

    public boolean isFixed() {
        return this.Fixed;
    }

    public void setFixed(ZirkelCanvas zirkelCanvas, ConstructionObject constructionObject) {
        if (constructionObject instanceof SegmentObject) {
            SegmentObject segmentObject = (SegmentObject)constructionObject;
            if (segmentObject.canFix()) {
                try {
                    segmentObject.validate();
                    segmentObject.setFixed(true, "" + segmentObject.getLength());
                    segmentObject.edit(zirkelCanvas);
                    segmentObject.validate();
                    zirkelCanvas.repaint();
                }
                catch (Exception exception) {}
            } else {
                zirkelCanvas.warning(Zirkel.name("error.fixedsegment"));
            }
        }
    }

    public void showStatus(ZirkelCanvas zirkelCanvas) {
        if (!this.Fixed) {
            if (this.P1 == null) {
                zirkelCanvas.showStatus(Zirkel.name("message.segment.first"));
            } else {
                zirkelCanvas.showStatus(Zirkel.name("message.segment.second"));
            }
        } else if (this.P1 == null) {
            zirkelCanvas.showStatus(Zirkel.name("message.fixedsegment.first"));
        } else {
            zirkelCanvas.showStatus(Zirkel.name("message.fixedsegment.second"));
        }
    }

    public boolean construct(XmlTree xmlTree, Construction construction) throws ConstructionException {
        block7: {
            if (!this.testTree(xmlTree, "Segment")) {
                return false;
            }
            XmlTag xmlTag = xmlTree.getTag();
            if (!xmlTag.hasParam("from") || !xmlTag.hasParam("to")) {
                throw new ConstructionException("Segment endpoints missing!");
            }
            try {
                PointObject pointObject = (PointObject)construction.find(xmlTag.getValue("from"));
                PointObject pointObject2 = (PointObject)construction.find(xmlTag.getValue("to"));
                SegmentObject segmentObject = new SegmentObject(construction, pointObject, pointObject2);
                this.setName(xmlTag, segmentObject);
                this.set(xmlTree, segmentObject);
                construction.add(segmentObject);
                this.setConditionals(xmlTree, construction, segmentObject);
                segmentObject.setArrow(xmlTag.hasParam("arrow"));
                if (!xmlTag.hasParam("fixed")) break block7;
                try {
                    segmentObject.setFixed(true, xmlTag.getValue("fixed"));
                }
                catch (Exception exception) {
                    throw new ConstructionException("Fixed value illegal!");
                }
            }
            catch (ConstructionException constructionException) {
                throw constructionException;
            }
            catch (Exception exception) {
                throw new ConstructionException("Segment endpoints illegal!");
            }
        }
        return true;
    }

    public String getPrompt() {
        return Zirkel.name("prompt.segment");
    }

    public String getTag() {
        return "Segment";
    }

    public void construct(Construction construction, String string, String[] stringArray, int n) throws ConstructionException {
        if (n != 2 && n != 3) {
            throw new ConstructionException(Zirkel.name("exception.nparams"));
        }
        ConstructionObject constructionObject = construction.find(stringArray[0]);
        if (constructionObject == null) {
            throw new ConstructionException(Zirkel.name("exception.notfound") + " " + stringArray[0]);
        }
        if (!(constructionObject instanceof PointObject)) {
            throw new ConstructionException(Zirkel.name("exception.type") + " " + stringArray[0]);
        }
        ConstructionObject constructionObject2 = construction.find(stringArray[1]);
        if (constructionObject2 == null) {
            Expression expression = new Expression(stringArray[1], construction, null);
            if (!expression.isValid()) {
                throw new ConstructionException(Zirkel.name("exception.expression"));
            }
            double d2 = expression.getValue();
            constructionObject2 = new PointObject(construction, ((PointObject)constructionObject).getX() + d2, ((PointObject)constructionObject).getY());
            construction.add(constructionObject2);
            constructionObject2.setDefaults();
            SegmentObject segmentObject = new SegmentObject(construction, (PointObject)constructionObject, (PointObject)constructionObject2);
            segmentObject.setDefaults();
            segmentObject.setFixed(true, stringArray[1]);
            construction.add(segmentObject);
            if (!string.equals("")) {
                segmentObject.setNameCheck(string);
            }
            return;
        }
        if (!(constructionObject2 instanceof PointObject)) {
            throw new ConstructionException(Zirkel.name("exception.type") + " " + stringArray[1]);
        }
        SegmentObject segmentObject = new SegmentObject(construction, (PointObject)constructionObject, (PointObject)constructionObject2);
        if (n == 3) {
            if (!segmentObject.canFix()) {
                throw new ConstructionException(Zirkel.name("exception.canfix"));
            }
            segmentObject.setFixed(true, stringArray[2]);
            if (!segmentObject.isValidFix()) {
                throw new ConstructionException(Zirkel.name("exception.fix") + " " + stringArray[2]);
            }
            segmentObject.validate();
        }
        construction.add(segmentObject);
        segmentObject.setDefaults();
        if (!string.equals("")) {
            segmentObject.setNameCheck(string);
        }
    }
}

