//===----------------------------------------------------------------------===//
//
// This source file is part of the Swift.org open source project
//
// Copyright (c) 2022 Apple Inc. and the Swift project authors
// Licensed under Apache License v2.0 with Runtime Library Exception
//
// See https://swift.org/LICENSE.txt for license information
// See https://swift.org/CONTRIBUTORS.txt for the list of Swift project authors
//
//===----------------------------------------------------------------------===//

// This was auto-generated by utils/gen-unicode-data/GenScripts,
// please do not edit this file yourself!

#ifndef SCRIPT_DATA_H
#define SCRIPT_DATA_H

#include "stdint.h"

#define SCRIPTS_COUNT 1639

static const uint32_t _swift_stdlib_scripts[1639] = {
  0x3000000, 0x8C00041, 0x300005B, 0x8C00061, 0x300007B, 0x8C000AA, 0x30000AB, 0x8C000BA, 0x30000BB,
  0x8C000C0, 0x30000D7, 0x8C000D8, 0x30000F7, 0x8C000F8, 0x30002B9, 0x8C002E0, 0x30002E5, 0x18002EA,
  0x30002EC, 0x6E00300, 0x5600370, 0x3000374, 0x5600375, 0x13600378, 0x560037A, 0x300037E,
  0x560037F, 0x13600380, 0x5600384, 0x3000385, 0x5600386, 0x3000387, 0x5600388, 0x1360038B,
  0x560038C, 0x1360038D, 0x560038E, 0x136003A2, 0x56003A3, 0x32003E2, 0x56003F0, 0x3800400,
  0x6E00485, 0x3800487, 0x13600530, 0x800531, 0x13600557, 0x800559, 0x1360058B, 0x80058D,
  0x13600590, 0x6800591, 0x136005C8, 0x68005D0, 0x136005EB, 0x68005EF, 0x136005F5, 0x600600,
  0x3000605, 0x600606, 0x300060C, 0x60060D, 0x300061B, 0x60061C, 0x300061F, 0x600620, 0x3000640,
  0x600641, 0x6E0064B, 0x600656, 0x6E00670, 0x600671, 0x30006DD, 0x6006DE, 0x11200700, 0x1360070E,
  0x1120070F, 0x1360074B, 0x1120074D, 0x600750, 0x12800780, 0x136007B2, 0xC8007C0, 0x136007FB,
  0xC8007FD, 0xFA00800, 0x1360082E, 0xFA00830, 0x1360083F, 0xA200840, 0x1360085C, 0xA20085E,
  0x1360085F, 0x11200860, 0x1360086B, 0x600870, 0x1360088F, 0x600890, 0x13600892, 0x600898,
  0x30008E2, 0x6008E3, 0x3E00900, 0x6E00951, 0x3E00955, 0x3000964, 0x3E00966, 0x1400980, 0x13600984,
  0x1400985, 0x1360098D, 0x140098F, 0x13600991, 0x1400993, 0x136009A9, 0x14009AA, 0x136009B1,
  0x14009B2, 0x136009B3, 0x14009B6, 0x136009BA, 0x14009BC, 0x136009C5, 0x14009C7, 0x136009C9,
  0x14009CB, 0x136009CF, 0x14009D7, 0x136009D8, 0x14009DC, 0x136009DE, 0x14009DF, 0x136009E4,
  0x14009E6, 0x136009FF, 0x5C00A01, 0x13600A04, 0x5C00A05, 0x13600A0B, 0x5C00A0F, 0x13600A11,
  0x5C00A13, 0x13600A29, 0x5C00A2A, 0x13600A31, 0x5C00A32, 0x13600A34, 0x5C00A35, 0x13600A37,
  0x5C00A38, 0x13600A3A, 0x5C00A3C, 0x13600A3D, 0x5C00A3E, 0x13600A43, 0x5C00A47, 0x13600A49,
  0x5C00A4B, 0x13600A4E, 0x5C00A51, 0x13600A52, 0x5C00A59, 0x13600A5D, 0x5C00A5E, 0x13600A5F,
  0x5C00A66, 0x13600A77, 0x5800A81, 0x13600A84, 0x5800A85, 0x13600A8E, 0x5800A8F, 0x13600A92,
  0x5800A93, 0x13600AA9, 0x5800AAA, 0x13600AB1, 0x5800AB2, 0x13600AB4, 0x5800AB5, 0x13600ABA,
  0x5800ABC, 0x13600AC6, 0x5800AC7, 0x13600ACA, 0x5800ACB, 0x13600ACE, 0x5800AD0, 0x13600AD1,
  0x5800AE0, 0x13600AE4, 0x5800AE6, 0x13600AF2, 0x5800AF9, 0x13600B00, 0xE400B01, 0x13600B04,
  0xE400B05, 0x13600B0D, 0xE400B0F, 0x13600B11, 0xE400B13, 0x13600B29, 0xE400B2A, 0x13600B31,
  0xE400B32, 0x13600B34, 0xE400B35, 0x13600B3A, 0xE400B3C, 0x13600B45, 0xE400B47, 0x13600B49,
  0xE400B4B, 0x13600B4E, 0xE400B55, 0x13600B58, 0xE400B5C, 0x13600B5E, 0xE400B5F, 0x13600B64,
  0xE400B66, 0x13600B78, 0x12000B82, 0x13600B84, 0x12000B85, 0x13600B8B, 0x12000B8E, 0x13600B91,
  0x12000B92, 0x13600B96, 0x12000B99, 0x13600B9B, 0x12000B9C, 0x13600B9D, 0x12000B9E, 0x13600BA0,
  0x12000BA3, 0x13600BA5, 0x12000BA8, 0x13600BAB, 0x12000BAE, 0x13600BBA, 0x12000BBE, 0x13600BC3,
  0x12000BC6, 0x13600BC9, 0x12000BCA, 0x13600BCE, 0x12000BD0, 0x13600BD1, 0x12000BD7, 0x13600BD8,
  0x12000BE6, 0x13600BFB, 0x12600C00, 0x13600C0D, 0x12600C0E, 0x13600C11, 0x12600C12, 0x13600C29,
  0x12600C2A, 0x13600C3A, 0x12600C3C, 0x13600C45, 0x12600C46, 0x13600C49, 0x12600C4A, 0x13600C4E,
  0x12600C55, 0x13600C57, 0x12600C58, 0x13600C5B, 0x12600C5D, 0x13600C5E, 0x12600C60, 0x13600C64,
  0x12600C66, 0x13600C70, 0x12600C77, 0x7800C80, 0x13600C8D, 0x7800C8E, 0x13600C91, 0x7800C92,
  0x13600CA9, 0x7800CAA, 0x13600CB4, 0x7800CB5, 0x13600CBA, 0x7800CBC, 0x13600CC5, 0x7800CC6,
  0x13600CC9, 0x7800CCA, 0x13600CCE, 0x7800CD5, 0x13600CD7, 0x7800CDD, 0x13600CDF, 0x7800CE0,
  0x13600CE4, 0x7800CE6, 0x13600CF0, 0x7800CF1, 0x13600CF3, 0xA000D00, 0x13600D0D, 0xA000D0E,
  0x13600D11, 0xA000D12, 0x13600D45, 0xA000D46, 0x13600D49, 0xA000D4A, 0x13600D50, 0xA000D54,
  0x13600D64, 0xA000D66, 0x13600D80, 0x10600D81, 0x13600D84, 0x10600D85, 0x13600D97, 0x10600D9A,
  0x13600DB2, 0x10600DB3, 0x13600DBC, 0x10600DBD, 0x13600DBE, 0x10600DC0, 0x13600DC7, 0x10600DCA,
  0x13600DCB, 0x10600DCF, 0x13600DD5, 0x10600DD6, 0x13600DD7, 0x10600DD8, 0x13600DE0, 0x10600DE6,
  0x13600DF0, 0x10600DF2, 0x13600DF5, 0x12A00E01, 0x13600E3B, 0x3000E3F, 0x12A00E40, 0x13600E5C,
  0x8A00E81, 0x13600E83, 0x8A00E84, 0x13600E85, 0x8A00E86, 0x13600E8B, 0x8A00E8C, 0x13600EA4,
  0x8A00EA5, 0x13600EA6, 0x8A00EA7, 0x13600EBE, 0x8A00EC0, 0x13600EC5, 0x8A00EC6, 0x13600EC7,
  0x8A00EC8, 0x13600ECE, 0x8A00ED0, 0x13600EDA, 0x8A00EDC, 0x13600EE0, 0x12C00F00, 0x13600F48,
  0x12C00F49, 0x13600F6D, 0x12C00F71, 0x13600F98, 0x12C00F99, 0x13600FBD, 0x12C00FBE, 0x13600FCD,
  0x12C00FCE, 0x3000FD5, 0x12C00FD9, 0x13600FDB, 0xBE01000, 0x4E010A0, 0x136010C6, 0x4E010C7,
  0x136010C8, 0x4E010CD, 0x136010CE, 0x4E010D0, 0x30010FB, 0x4E010FC, 0x6001100, 0x4C01200,
  0x13601249, 0x4C0124A, 0x1360124E, 0x4C01250, 0x13601257, 0x4C01258, 0x13601259, 0x4C0125A,
  0x1360125E, 0x4C01260, 0x13601289, 0x4C0128A, 0x1360128E, 0x4C01290, 0x136012B1, 0x4C012B2,
  0x136012B6, 0x4C012B8, 0x136012BF, 0x4C012C0, 0x136012C1, 0x4C012C2, 0x136012C6, 0x4C012C8,
  0x136012D7, 0x4C012D8, 0x13601311, 0x4C01312, 0x13601316, 0x4C01318, 0x1360135B, 0x4C0135D,
  0x1360137D, 0x4C01380, 0x1360139A, 0x2C013A0, 0x136013F6, 0x2C013F8, 0x136013FE, 0x2201400,
  0xCE01680, 0x1360169D, 0xF8016A0, 0x30016EB, 0xF8016EE, 0x136016F9, 0x11401700, 0x13601716,
  0x1140171F, 0x6401720, 0x3001735, 0x13601737, 0x2001740, 0x13601754, 0x11601760, 0x1360176D,
  0x1160176E, 0x13601771, 0x11601772, 0x13601774, 0x8401780, 0x136017DE, 0x84017E0, 0x136017EA,
  0x84017F0, 0x136017FA, 0xB801800, 0x3001802, 0xB801804, 0x3001805, 0xB801806, 0x1360181A,
  0xB801820, 0x13601879, 0xB801880, 0x136018AB, 0x22018B0, 0x136018F6, 0x9001900, 0x1360191F,
  0x9001920, 0x1360192C, 0x9001930, 0x1360193C, 0x9001940, 0x13601941, 0x9001944, 0x11801950,
  0x1360196E, 0x11801970, 0x13601975, 0xC601980, 0x136019AC, 0xC6019B0, 0x136019CA, 0xC6019D0,
  0x136019DB, 0xC6019DE, 0x84019E0, 0x1E01A00, 0x13601A1C, 0x1E01A1E, 0x11A01A20, 0x13601A5F,
  0x11A01A60, 0x13601A7D, 0x11A01A7F, 0x13601A8A, 0x11A01A90, 0x13601A9A, 0x11A01AA0, 0x13601AAE,
  0x6E01AB0, 0x13601ACF, 0xC01B00, 0x13601B4D, 0xC01B50, 0x13601B7F, 0x10E01B80, 0x1201BC0,
  0x13601BF4, 0x1201BFC, 0x8E01C00, 0x13601C38, 0x8E01C3B, 0x13601C4A, 0x8E01C4D, 0xD001C50,
  0x3801C80, 0x13601C89, 0x4E01C90, 0x13601CBB, 0x4E01CBD, 0x10E01CC0, 0x13601CC8, 0x6E01CD0,
  0x3001CD3, 0x6E01CD4, 0x3001CE1, 0x6E01CE2, 0x3001CE9, 0x6E01CED, 0x3001CEE, 0x6E01CF4, 0x3001CF5,
  0x6E01CF8, 0x3001CFA, 0x13601CFB, 0x8C01D00, 0x5601D26, 0x3801D2B, 0x8C01D2C, 0x5601D5D,
  0x8C01D62, 0x5601D66, 0x8C01D6B, 0x3801D78, 0x8C01D79, 0x5601DBF, 0x6E01DC0, 0x8C01E00, 0x5601F00,
  0x13601F16, 0x5601F18, 0x13601F1E, 0x5601F20, 0x13601F46, 0x5601F48, 0x13601F4E, 0x5601F50,
  0x13601F58, 0x5601F59, 0x13601F5A, 0x5601F5B, 0x13601F5C, 0x5601F5D, 0x13601F5E, 0x5601F5F,
  0x13601F7E, 0x5601F80, 0x13601FB5, 0x5601FB6, 0x13601FC5, 0x5601FC6, 0x13601FD4, 0x5601FD6,
  0x13601FDC, 0x5601FDD, 0x13601FF0, 0x5601FF2, 0x13601FF5, 0x5601FF6, 0x13601FFF, 0x3002000,
  0x6E0200C, 0x300200E, 0x13602065, 0x3002066, 0x8C02071, 0x13602072, 0x3002074, 0x8C0207F,
  0x3002080, 0x1360208F, 0x8C02090, 0x1360209D, 0x30020A0, 0x136020C1, 0x6E020D0, 0x136020F1,
  0x3002100, 0x5602126, 0x3002127, 0x8C0212A, 0x300212C, 0x8C02132, 0x3002133, 0x8C0214E, 0x300214F,
  0x8C02160, 0x3002189, 0x1360218C, 0x3002190, 0x13602427, 0x3002440, 0x1360244B, 0x3002460,
  0x1C02800, 0x3002900, 0x13602B74, 0x3002B76, 0x13602B96, 0x3002B97, 0x5002C00, 0x8C02C60,
  0x3202C80, 0x13602CF4, 0x3202CF9, 0x4E02D00, 0x13602D26, 0x4E02D27, 0x13602D28, 0x4E02D2D,
  0x13602D2E, 0x12E02D30, 0x13602D68, 0x12E02D6F, 0x13602D71, 0x12E02D7F, 0x4C02D80, 0x13602D97,
  0x4C02DA0, 0x13602DA7, 0x4C02DA8, 0x13602DAF, 0x4C02DB0, 0x13602DB7, 0x4C02DB8, 0x13602DBF,
  0x4C02DC0, 0x13602DC7, 0x4C02DC8, 0x13602DCF, 0x4C02DD0, 0x13602DD7, 0x4C02DD8, 0x13602DDF,
  0x3802DE0, 0x3002E00, 0x13602E5E, 0x5E02E80, 0x13602E9A, 0x5E02E9B, 0x13602EF4, 0x5E02F00,
  0x13602FD6, 0x3002FF0, 0x13602FFC, 0x3003000, 0x5E03005, 0x3003006, 0x5E03007, 0x3003008,
  0x5E03021, 0x6E0302A, 0x600302E, 0x3003030, 0x5E03038, 0x300303C, 0x13603040, 0x6A03041,
  0x13603097, 0x6E03099, 0x300309B, 0x6A0309D, 0x30030A0, 0x7A030A1, 0x30030FB, 0x7A030FD,
  0x13603100, 0x1803105, 0x13603130, 0x6003131, 0x1360318F, 0x3003190, 0x18031A0, 0x30031C0,
  0x136031E4, 0x7A031F0, 0x6003200, 0x1360321F, 0x3003220, 0x6003260, 0x300327F, 0x7A032D0,
  0x30032FF, 0x7A03300, 0x3003358, 0x5E03400, 0x3004DC0, 0x5E04E00, 0x1420A000, 0x1360A48D,
  0x1420A490, 0x1360A4C7, 0x960A4D0, 0x1380A500, 0x1360A62C, 0x380A640, 0xE0A6A0, 0x1360A6F8,
  0x300A700, 0x8C0A722, 0x300A788, 0x8C0A78B, 0x1360A7CB, 0x8C0A7D0, 0x1360A7D2, 0x8C0A7D3,
  0x1360A7D4, 0x8C0A7D5, 0x1360A7DA, 0x8C0A7F2, 0x1100A800, 0x1360A82D, 0x300A830, 0x1360A83A,
  0xF00A840, 0x1360A878, 0xFC0A880, 0x1360A8C6, 0xFC0A8CE, 0x1360A8DA, 0x3E0A8E0, 0x7E0A900,
  0x300A92E, 0x7E0A92F, 0xF60A930, 0x1360A954, 0xF60A95F, 0x600A960, 0x1360A97D, 0x740A980,
  0x1360A9CE, 0x300A9CF, 0x740A9D0, 0x1360A9DA, 0x740A9DE, 0xBE0A9E0, 0x1360A9FF, 0x2A0AA00,
  0x1360AA37, 0x2A0AA40, 0x1360AA4E, 0x2A0AA50, 0x1360AA5A, 0x2A0AA5C, 0xBE0AA60, 0x11C0AA80,
  0x1360AAC3, 0x11C0AADB, 0xAC0AAE0, 0x1360AAF7, 0x4C0AB01, 0x1360AB07, 0x4C0AB09, 0x1360AB0F,
  0x4C0AB11, 0x1360AB17, 0x4C0AB20, 0x1360AB27, 0x4C0AB28, 0x1360AB2F, 0x8C0AB30, 0x300AB5B,
  0x8C0AB5C, 0x560AB65, 0x8C0AB66, 0x300AB6A, 0x1360AB6C, 0x2C0AB70, 0xAC0ABC0, 0x1360ABEE,
  0xAC0ABF0, 0x1360ABFA, 0x600AC00, 0x1360D7A4, 0x600D7B0, 0x1360D7C7, 0x600D7CB, 0x1360D7FC,
  0x1360E000, 0x5E0F900, 0x1360FA6E, 0x5E0FA70, 0x1360FADA, 0x8C0FB00, 0x1360FB07, 0x80FB13,
  0x1360FB18, 0x680FB1D, 0x1360FB37, 0x680FB38, 0x1360FB3D, 0x680FB3E, 0x1360FB3F, 0x680FB40,
  0x1360FB42, 0x680FB43, 0x1360FB45, 0x680FB46, 0x60FB50, 0x1360FBC3, 0x60FBD3, 0x300FD3E, 0x60FD40,
  0x1360FD90, 0x60FD92, 0x1360FDC8, 0x60FDCF, 0x1360FDD0, 0x60FDF0, 0x6E0FE00, 0x300FE10,
  0x1360FE1A, 0x6E0FE20, 0x380FE2E, 0x300FE30, 0x1360FE53, 0x300FE54, 0x1360FE67, 0x300FE68,
  0x1360FE6C, 0x60FE70, 0x1360FE75, 0x60FE76, 0x1360FEFD, 0x300FEFF, 0x1360FF00, 0x300FF01,
  0x8C0FF21, 0x300FF3B, 0x8C0FF41, 0x300FF5B, 0x7A0FF66, 0x300FF70, 0x7A0FF71, 0x300FF9E, 0x600FFA0,
  0x1360FFBF, 0x600FFC2, 0x1360FFC8, 0x600FFCA, 0x1360FFD0, 0x600FFD2, 0x1360FFD8, 0x600FFDA,
  0x1360FFDD, 0x300FFE0, 0x1360FFE7, 0x300FFE8, 0x1360FFEF, 0x300FFF9, 0x1360FFFE, 0x9410000,
  0x1361000C, 0x941000D, 0x13610027, 0x9410028, 0x1361003B, 0x941003C, 0x1361003E, 0x941003F,
  0x1361004E, 0x9410050, 0x1361005E, 0x9410080, 0x136100FB, 0x3010100, 0x13610103, 0x3010107,
  0x13610134, 0x3010137, 0x5610140, 0x1361018F, 0x3010190, 0x1361019D, 0x56101A0, 0x136101A1,
  0x30101D0, 0x6E101FD, 0x136101FE, 0x9810280, 0x1361029D, 0x24102A0, 0x136102D1, 0x6E102E0,
  0x30102E1, 0x136102FC, 0xD410300, 0x13610324, 0xD41032D, 0x5210330, 0x1361034B, 0xD810350,
  0x1361037B, 0x13410380, 0x1361039E, 0x1341039F, 0xDA103A0, 0x136103C4, 0xDA103C8, 0x136103D6,
  0x3C10400, 0x10010450, 0xE810480, 0x1361049E, 0xE8104A0, 0x136104AA, 0xE6104B0, 0x136104D4,
  0xE6104D8, 0x136104FC, 0x4810500, 0x13610528, 0x2610530, 0x13610564, 0x261056F, 0x13A10570,
  0x1361057B, 0x13A1057C, 0x1361058B, 0x13A1058C, 0x13610593, 0x13A10594, 0x13610596, 0x13A10597,
  0x136105A2, 0x13A105A3, 0x136105B2, 0x13A105B3, 0x136105BA, 0x13A105BB, 0x136105BD, 0x9210600,
  0x13610737, 0x9210740, 0x13610756, 0x9210760, 0x13610768, 0x8C10780, 0x13610786, 0x8C10787,
  0x136107B1, 0x8C107B2, 0x136107BB, 0x3610800, 0x13610806, 0x3610808, 0x13610809, 0x361080A,
  0x13610836, 0x3610837, 0x13610839, 0x361083C, 0x1361083D, 0x361083F, 0x6C10840, 0x13610856,
  0x6C10857, 0xEC10860, 0xC010880, 0x1361089F, 0xC0108A7, 0x136108B0, 0x66108E0, 0x136108F3,
  0x66108F4, 0x136108F6, 0x66108FB, 0xF210900, 0x1361091C, 0xF21091F, 0x9A10920, 0x1361093A,
  0x9A1093F, 0x13610940, 0xB210980, 0xB0109A0, 0x136109B8, 0xB0109BC, 0x136109D0, 0xB0109D2,
  0x8010A00, 0x13610A04, 0x8010A05, 0x13610A07, 0x8010A0C, 0x13610A14, 0x8010A15, 0x13610A18,
  0x8010A19, 0x13610A36, 0x8010A38, 0x13610A3B, 0x8010A3F, 0x13610A49, 0x8010A50, 0x13610A59,
  0xDE10A60, 0xD610A80, 0x13610AA0, 0xA410AC0, 0x13610AE7, 0xA410AEB, 0x13610AF7, 0xA10B00,
  0x13610B36, 0xA10B39, 0x7210B40, 0x13610B56, 0x7210B58, 0x7010B60, 0x13610B73, 0x7010B78,
  0xF410B80, 0x13610B92, 0xF410B99, 0x13610B9D, 0xF410BA9, 0x13610BB0, 0xE010C00, 0x13610C49,
  0xD210C80, 0x13610CB3, 0xD210CC0, 0x13610CF3, 0xD210CFA, 0x6210D00, 0x13610D28, 0x6210D30,
  0x13610D3A, 0x610E60, 0x13610E7F, 0x14010E80, 0x13610EAA, 0x14010EAB, 0x13610EAE, 0x14010EB0,
  0x13610EB2, 0xDC10F00, 0x13610F28, 0x10810F30, 0x13610F5A, 0xE210F70, 0x13610F8A, 0x2E10FB0,
  0x13610FCC, 0x4A10FE0, 0x13610FF7, 0x1A11000, 0x1361104E, 0x1A11052, 0x13611076, 0x1A1107F,
  0x7611080, 0x136110C3, 0x76110CD, 0x136110CE, 0x10A110D0, 0x136110E9, 0x10A110F0, 0x136110FA,
  0x2811100, 0x13611135, 0x2811136, 0x13611148, 0x9C11150, 0x13611177, 0xFE11180, 0x136111E0,
  0x106111E1, 0x136111F5, 0x8611200, 0x13611212, 0x8611213, 0x1361123F, 0xBC11280, 0x13611287,
  0xBC11288, 0x13611289, 0xBC1128A, 0x1361128E, 0xBC1128F, 0x1361129E, 0xBC1129F, 0x136112AA,
  0x88112B0, 0x136112EB, 0x88112F0, 0x136112FA, 0x5411300, 0x13611304, 0x5411305, 0x1361130D,
  0x541130F, 0x13611311, 0x5411313, 0x13611329, 0x541132A, 0x13611331, 0x5411332, 0x13611334,
  0x5411335, 0x1361133A, 0x6E1133B, 0x541133C, 0x13611345, 0x5411347, 0x13611349, 0x541134B,
  0x1361134E, 0x5411350, 0x13611351, 0x5411357, 0x13611358, 0x541135D, 0x13611364, 0x5411366,
  0x1361136D, 0x5411370, 0x13611375, 0xC411400, 0x1361145C, 0xC41145D, 0x13611462, 0x13011480,
  0x136114C8, 0x130114D0, 0x136114DA, 0x10211580, 0x136115B6, 0x102115B8, 0x136115DE, 0xB611600,
  0x13611645, 0xB611650, 0x1361165A, 0xB811660, 0x1361166D, 0x11E11680, 0x136116BA, 0x11E116C0,
  0x136116CA, 0x211700, 0x1361171B, 0x21171D, 0x1361172C, 0x211730, 0x13611747, 0x4211800,
  0x1361183C, 0x13E118A0, 0x136118F3, 0x13E118FF, 0x4011900, 0x13611907, 0x4011909, 0x1361190A,
  0x401190C, 0x13611914, 0x4011915, 0x13611917, 0x4011918, 0x13611936, 0x4011937, 0x13611939,
  0x401193B, 0x13611947, 0x4011950, 0x1361195A, 0xC2119A0, 0x136119A8, 0xC2119AA, 0x136119D8,
  0xC2119DA, 0x136119E5, 0x14411A00, 0x13611A48, 0x10C11A50, 0x13611AA3, 0x2211AB0, 0xEE11AC0,
  0x13611AF9, 0x1611C00, 0x13611C09, 0x1611C0A, 0x13611C37, 0x1611C38, 0x13611C46, 0x1611C50,
  0x13611C6D, 0xA611C70, 0x13611C90, 0xA611C92, 0x13611CA8, 0xA611CA9, 0x13611CB7, 0xA811D00,
  0x13611D07, 0xA811D08, 0x13611D0A, 0xA811D0B, 0x13611D37, 0xA811D3A, 0x13611D3B, 0xA811D3C,
  0x13611D3E, 0xA811D3F, 0x13611D48, 0xA811D50, 0x13611D5A, 0x5A11D60, 0x13611D66, 0x5A11D67,
  0x13611D69, 0x5A11D6A, 0x13611D8F, 0x5A11D90, 0x13611D92, 0x5A11D93, 0x13611D99, 0x5A11DA0,
  0x13611DAA, 0x9E11EE0, 0x13611EF9, 0x9611FB0, 0x13611FB1, 0x12011FC0, 0x13611FF2, 0x12011FFF,
  0x3412000, 0x1361239A, 0x3412400, 0x1361246F, 0x3412470, 0x13612475, 0x3412480, 0x13612544,
  0x3A12F90, 0x13612FF3, 0x4613000, 0x1361342F, 0x4613430, 0x13613439, 0x414400, 0x13614647,
  0xE16800, 0x13616A39, 0xBA16A40, 0x13616A5F, 0xBA16A60, 0x13616A6A, 0xBA16A6E, 0x12216A70,
  0x13616ABF, 0x12216AC0, 0x13616ACA, 0x1016AD0, 0x13616AEE, 0x1016AF0, 0x13616AF6, 0xEA16B00,
  0x13616B46, 0xEA16B50, 0x13616B5A, 0xEA16B5B, 0x13616B62, 0xEA16B63, 0x13616B78, 0xEA16B7D,
  0x13616B90, 0xAA16E40, 0x13616E9B, 0xB416F00, 0x13616F4B, 0xB416F4F, 0x13616F88, 0xB416F8F,
  0x13616FA0, 0x12416FE0, 0xCA16FE1, 0x5E16FE2, 0x8216FE4, 0x13616FE5, 0x5E16FF0, 0x13616FF2,
  0x12417000, 0x136187F8, 0x12418800, 0x8218B00, 0x13618CD6, 0x12418D00, 0x13618D09, 0x7A1AFF0,
  0x1361AFF4, 0x7A1AFF5, 0x1361AFFC, 0x7A1AFFD, 0x1361AFFF, 0x7A1B000, 0x6A1B001, 0x7A1B120,
  0x1361B123, 0x6A1B150, 0x1361B153, 0x7A1B164, 0x1361B168, 0xCA1B170, 0x1361B2FC, 0x441BC00,
  0x1361BC6B, 0x441BC70, 0x1361BC7D, 0x441BC80, 0x1361BC89, 0x441BC90, 0x1361BC9A, 0x441BC9C,
  0x301BCA0, 0x1361BCA4, 0x6E1CF00, 0x1361CF2E, 0x6E1CF30, 0x1361CF47, 0x301CF50, 0x1361CFC4,
  0x301D000, 0x1361D0F6, 0x301D100, 0x1361D127, 0x301D129, 0x6E1D167, 0x301D16A, 0x6E1D17B,
  0x301D183, 0x6E1D185, 0x301D18C, 0x6E1D1AA, 0x301D1AE, 0x1361D1EB, 0x561D200, 0x1361D246,
  0x301D2E0, 0x1361D2F4, 0x301D300, 0x1361D357, 0x301D360, 0x1361D379, 0x301D400, 0x1361D455,
  0x301D456, 0x1361D49D, 0x301D49E, 0x1361D4A0, 0x301D4A2, 0x1361D4A3, 0x301D4A5, 0x1361D4A7,
  0x301D4A9, 0x1361D4AD, 0x301D4AE, 0x1361D4BA, 0x301D4BB, 0x1361D4BC, 0x301D4BD, 0x1361D4C4,
  0x301D4C5, 0x1361D506, 0x301D507, 0x1361D50B, 0x301D50D, 0x1361D515, 0x301D516, 0x1361D51D,
  0x301D51E, 0x1361D53A, 0x301D53B, 0x1361D53F, 0x301D540, 0x1361D545, 0x301D546, 0x1361D547,
  0x301D54A, 0x1361D551, 0x301D552, 0x1361D6A6, 0x301D6A8, 0x1361D7CC, 0x301D7CE, 0x1041D800,
  0x1361DA8C, 0x1041DA9B, 0x1361DAA0, 0x1041DAA1, 0x1361DAB0, 0x8C1DF00, 0x1361DF1F, 0x501E000,
  0x1361E007, 0x501E008, 0x1361E019, 0x501E01B, 0x1361E022, 0x501E023, 0x1361E025, 0x501E026,
  0x1361E02B, 0xCC1E100, 0x1361E12D, 0xCC1E130, 0x1361E13E, 0xCC1E140, 0x1361E14A, 0xCC1E14E,
  0x1361E150, 0x1321E290, 0x1361E2AF, 0x13C1E2C0, 0x1361E2FA, 0x13C1E2FF, 0x1361E300, 0x4C1E7E0,
  0x1361E7E7, 0x4C1E7E8, 0x1361E7EC, 0x4C1E7ED, 0x1361E7EF, 0x4C1E7F0, 0x1361E7FF, 0xAE1E800,
  0x1361E8C5, 0xAE1E8C7, 0x1361E8D7, 0x1E900, 0x1361E94C, 0x1E950, 0x1361E95A, 0x1E95E, 0x1361E960,
  0x301EC71, 0x1361ECB5, 0x301ED01, 0x1361ED3E, 0x61EE00, 0x1361EE04, 0x61EE05, 0x1361EE20,
  0x61EE21, 0x1361EE23, 0x61EE24, 0x1361EE25, 0x61EE27, 0x1361EE28, 0x61EE29, 0x1361EE33, 0x61EE34,
  0x1361EE38, 0x61EE39, 0x1361EE3A, 0x61EE3B, 0x1361EE3C, 0x61EE42, 0x1361EE43, 0x61EE47,
  0x1361EE48, 0x61EE49, 0x1361EE4A, 0x61EE4B, 0x1361EE4C, 0x61EE4D, 0x1361EE50, 0x61EE51,
  0x1361EE53, 0x61EE54, 0x1361EE55, 0x61EE57, 0x1361EE58, 0x61EE59, 0x1361EE5A, 0x61EE5B,
  0x1361EE5C, 0x61EE5D, 0x1361EE5E, 0x61EE5F, 0x1361EE60, 0x61EE61, 0x1361EE63, 0x61EE64,
  0x1361EE65, 0x61EE67, 0x1361EE6B, 0x61EE6C, 0x1361EE73, 0x61EE74, 0x1361EE78, 0x61EE79,
  0x1361EE7D, 0x61EE7E, 0x1361EE7F, 0x61EE80, 0x1361EE8A, 0x61EE8B, 0x1361EE9C, 0x61EEA1,
  0x1361EEA4, 0x61EEA5, 0x1361EEAA, 0x61EEAB, 0x1361EEBC, 0x61EEF0, 0x1361EEF2, 0x301F000,
  0x1361F02C, 0x301F030, 0x1361F094, 0x301F0A0, 0x1361F0AF, 0x301F0B1, 0x1361F0C0, 0x301F0C1,
  0x1361F0D0, 0x301F0D1, 0x1361F0F6, 0x301F100, 0x1361F1AE, 0x301F1E6, 0x6A1F200, 0x301F201,
  0x1361F203, 0x301F210, 0x1361F23C, 0x301F240, 0x1361F249, 0x301F250, 0x1361F252, 0x301F260,
  0x1361F266, 0x301F300, 0x1361F6D8, 0x301F6DD, 0x1361F6ED, 0x301F6F0, 0x1361F6FD, 0x301F700,
  0x1361F774, 0x301F780, 0x1361F7D9, 0x301F7E0, 0x1361F7EC, 0x301F7F0, 0x1361F7F1, 0x301F800,
  0x1361F80C, 0x301F810, 0x1361F848, 0x301F850, 0x1361F85A, 0x301F860, 0x1361F888, 0x301F890,
  0x1361F8AE, 0x301F8B0, 0x1361F8B2, 0x301F900, 0x1361FA54, 0x301FA60, 0x1361FA6E, 0x301FA70,
  0x1361FA75, 0x301FA78, 0x1361FA7D, 0x301FA80, 0x1361FA87, 0x301FA90, 0x1361FAAD, 0x301FAB0,
  0x1361FABB, 0x301FAC0, 0x1361FAC6, 0x301FAD0, 0x1361FADA, 0x301FAE0, 0x1361FAE8, 0x301FAF0,
  0x1361FAF7, 0x301FB00, 0x1361FB93, 0x301FB94, 0x1361FBCB, 0x301FBF0, 0x1361FBFA, 0x5E20000,
  0x1362A6E0, 0x5E2A700, 0x1362B739, 0x5E2B740, 0x1362B81E, 0x5E2B820, 0x1362CEA2, 0x5E2CEB0,
  0x1362EBE1, 0x5E2F800, 0x1362FA1E, 0x5E30000, 0x1363134B, 0x30E0001, 0x136E0002, 0x30E0020,
  0x136E0080, 0x6EE0100, 0x136E01F0,
};

static const uint8_t _swift_stdlib_script_extensions_data[255] = {
  0x2B, 0x46, 0x1C, 0x6C, 0x1C, 0x28, 0x1C, 0x46, 0x3, 0x64, 0x31, 0x89, 0x94, 0xA0, 0x3, 0x89,
  0x94, 0x0, 0x3, 0x64, 0x31, 0x89, 0x94, 0xA0, 0x0, 0x3, 0x51, 0x52, 0x71, 0x7A, 0x31, 0x84, 0x89,
  0x3, 0x89, 0x3, 0x94, 0xA0, 0x3, 0x31, 0xA, 0x1F, 0x2A, 0x2C, 0x2E, 0x3C, 0x46, 0x50, 0x72, 0x7F,
  0x90, 0x93, 0x98, 0xA, 0x1F, 0x2A, 0x2C, 0x2E, 0x3C, 0x46, 0x50, 0x72, 0x90, 0x93, 0x98, 0xA,
  0x1F, 0x21, 0x2D, 0x54, 0x2A, 0x2C, 0x2E, 0x3C, 0x4E, 0x50, 0x61, 0x72, 0x44, 0x83, 0x88, 0x8F,
  0x90, 0x93, 0x98, 0xA, 0x1F, 0x21, 0x2D, 0x54, 0x2A, 0x2C, 0x2E, 0x3C, 0x48, 0x4E, 0x50, 0x61,
  0x72, 0x44, 0x83, 0x88, 0x8F, 0x90, 0x93, 0x98, 0x1F, 0x21, 0x3B, 0x4E, 0xA, 0x14, 0x88, 0x2E,
  0x5E, 0x2C, 0x43, 0x2A, 0x90, 0x3C, 0x61, 0x14, 0x5F, 0x8C, 0x27, 0x46, 0x10, 0x32, 0x8B, 0x8A,
  0x5C, 0x78, 0xA, 0x1F, 0x2A, 0x3C, 0x1F, 0x1F, 0x2A, 0xA, 0x1F, 0x1F, 0x7F, 0x1F, 0x3C, 0x50,
  0x72, 0x90, 0x93, 0x1F, 0x61, 0xA, 0x1F, 0x2A, 0x3C, 0x61, 0x72, 0x93, 0x98, 0x1F, 0x2A, 0x3C,
  0xA, 0x61, 0x1C, 0x89, 0x89, 0x46, 0x5C, 0x1F, 0x2A, 0x46, 0xC, 0x30, 0x2F, 0x35, 0x3D, 0xA1, 0xC,
  0x30, 0x2F, 0x35, 0x3D, 0x2F, 0xC, 0x2F, 0x35, 0x3D, 0x2F, 0x35, 0x3D, 0x2F, 0x46, 0x1F, 0x21,
  0x2C, 0x2E, 0x43, 0x3C, 0x3B, 0x4E, 0x50, 0x5B, 0x61, 0x44, 0x8F, 0x98, 0x1F, 0x21, 0x2C, 0x2E,
  0x43, 0x3C, 0x3B, 0x4E, 0x5B, 0x61, 0x44, 0x8F, 0x98, 0x1F, 0x21, 0x2C, 0x2E, 0x43, 0x3B, 0x4E,
  0x5B, 0x44, 0x8F, 0x98, 0x1F, 0x90, 0x3F, 0x46, 0x5F, 0xF, 0x3A, 0x3, 0x64, 0x3, 0x94, 0x1D, 0x1B,
  0x4A, 0x1B, 0x4A, 0x1B, 0x49, 0x4A, 0x3, 0x19, 0x52, 0x71, 0x22,
};

static const uint16_t _swift_stdlib_script_extensions_data_indices[600] = {
  0x800, 0x800, 0x801, 0x801, 0x801, 0x801, 0x801, 0x801, 0x801, 0x801, 0x801, 0x801, 0x801, 0x801,
  0x801, 0x1002, 0x1004, 0x1006, 0x1006, 0x1004, 0x3008, 0x3008, 0x180E, 0x3811, 0x4818, 0x1021,
  0x1021, 0x1021, 0x1021, 0x1021, 0x1021, 0x1021, 0x1021, 0x1021, 0x1021, 0x1021, 0x1823, 0x1823,
  0x1823, 0x1823, 0x1823, 0x1823, 0x1823, 0x1823, 0x1823, 0x1823, 0x1021, 0x1026, 0x6828, 0x6035,
  0xA041, 0xA855, 0x206A, 0x206A, 0x206A, 0x206A, 0x206A, 0x206A, 0x206A, 0x206A, 0x206A, 0x206A,
  0x186E, 0x186E, 0x186E, 0x186E, 0x186E, 0x186E, 0x186E, 0x186E, 0x186E, 0x186E, 0x1071, 0x1071,
  0x1071, 0x1071, 0x1071, 0x1071, 0x1071, 0x1071, 0x1071, 0x1071, 0x1073, 0x1073, 0x1073, 0x1073,
  0x1073, 0x1073, 0x1073, 0x1073, 0x1073, 0x1073, 0x1075, 0x1075, 0x1075, 0x1075, 0x1075, 0x1075,
  0x1075, 0x1075, 0x1075, 0x1075, 0x1075, 0x1075, 0x1075, 0x1075, 0x1077, 0x1077, 0x1077, 0x1077,
  0x1077, 0x1077, 0x1077, 0x1077, 0x1077, 0x1077, 0x1879, 0x1879, 0x1879, 0x1879, 0x1879, 0x1879,
  0x1879, 0x1879, 0x1879, 0x1879, 0x107C, 0x207E, 0x207E, 0x1082, 0x1082, 0x1082, 0x2084, 0x888,
  0x2084, 0x1089, 0x888, 0x108B, 0x108B, 0x108D, 0x108B, 0x108D, 0x308F, 0x888, 0x108D, 0x108D,
  0x888, 0x888, 0x108D, 0x108B, 0x888, 0x888, 0x888, 0x888, 0x888, 0x888, 0x888, 0x1095, 0x108B,
  0x888, 0x888, 0x108B, 0x888, 0x888, 0x888, 0x888, 0x4097, 0x1089, 0x189F, 0x108B, 0x108B, 0x8A2,
  0x1089, 0x1089, 0x8A3, 0x800, 0x800, 0x10A4, 0x8A6, 0x10A7, 0x18A9, 0x1004, 0x30AC, 0x30AC,
  0x28B2, 0x8B7, 0x30AC, 0x30AC, 0x30AC, 0x30AC, 0x30AC, 0x30AC, 0x30AC, 0x30AC, 0x30AC, 0x30AC,
  0x28B2, 0x30AC, 0x30AC, 0x30AC, 0x30AC, 0x30AC, 0x30AC, 0x30AC, 0x30AC, 0x28B2, 0x28B2, 0x28B2,
  0x28B2, 0x10B8, 0x10B8, 0x10B8, 0x10B8, 0x28B2, 0x10BA, 0x10BA, 0x10BA, 0x10BA, 0x10BA, 0x28B2,
  0x18BC, 0x18BC, 0x8B7, 0x8B7, 0x10BA, 0x10BA, 0x10BA, 0x10BA, 0x10BA, 0x30AC, 0x10BA, 0x8B7,
  0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7,
  0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7,
  0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7,
  0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7,
  0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7,
  0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7,
  0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7,
  0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7,
  0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7,
  0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7,
  0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7,
  0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7,
  0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7,
  0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7,
  0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7,
  0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x1004, 0x10BF, 0x10BF, 0x10BF, 0x10BF, 0x10BF, 0x10BF, 0x10BF,
  0x10BF, 0x70C1, 0x70C1, 0x70C1, 0x68CF, 0x68CF, 0x68CF, 0x58DC, 0x58DC, 0x58DC, 0x58DC, 0x108B,
  0x10E7, 0x18E9, 0x10EC, 0x10EE, 0x10EE, 0x10F0, 0x10F0, 0x28B2, 0x28B2, 0x30AC, 0x30AC, 0x30AC,
  0x30AC, 0x30AC, 0x10BA, 0x10BA, 0x10BA, 0x18F2, 0x18F2, 0x10F5, 0x18F7, 0x18F7, 0x18F7, 0x18F7,
  0x18F7, 0x18F7, 0x18F7, 0x18F7, 0x18F7, 0x18F7, 0x18F7, 0x18F7, 0x18F7, 0x18F7, 0x18F7, 0x18F7,
  0x18F7, 0x18F7, 0x18F7, 0x18F7, 0x18F7, 0x18F7, 0x18F7, 0x18F7, 0x18F7, 0x18F7, 0x18F7, 0x18F7,
  0x18F7, 0x18F7, 0x18F7, 0x18F7, 0x18F7, 0x18F7, 0x18F7, 0x18F7, 0x18F7, 0x18F7, 0x18F7, 0x18F7,
  0x18F7, 0x18F7, 0x18F7, 0x18F7, 0x18F7, 0x10F5, 0x10F5, 0x10F5, 0x10F5, 0x10F5, 0x10F5, 0x10F5,
  0x10F5, 0x10F5, 0x10FA, 0x10FA, 0x10FA, 0x10FA, 0x10FA, 0x10FA, 0x10FA, 0x10FA, 0x10FA, 0x10FA,
  0x10FA, 0x10FA, 0x10FA, 0x10FA, 0x10FA, 0x10FA, 0x10FA, 0x10FA, 0x10FA, 0x10FA, 0x10FA, 0x10FA,
  0x10FA, 0x10FA, 0x10FA, 0x10FA, 0x10FA, 0x10FA, 0x10FC, 0x1075, 0x1075, 0x1075, 0x1075, 0x1075,
  0x1075, 0x1075, 0x8FE, 0x8FE, 0x8FE, 0x8FE, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7,
  0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7, 0x8B7,
};

static const uint16_t _swift_stdlib_script_extensions_ranks[198] = {
  0x0, 0x15, 0x15, 0x19, 0x20, 0x23, 0x23, 0x25, 0x0, 0xF, 0xF, 0xF, 0xF, 0x0, 0x0, 0x5, 0x5, 0x5,
  0x0, 0x0, 0x0, 0x1, 0xA, 0x0, 0xB, 0xC, 0xC, 0xC, 0x0, 0x0, 0x0, 0x0, 0xE, 0x0, 0x0, 0xA, 0xA,
  0x14, 0x0, 0x0, 0xA, 0xA, 0xA, 0x0, 0xA, 0xE, 0xE, 0xE, 0x0, 0xA, 0xA, 0xA, 0xA, 0x0, 0x0, 0xA,
  0xA, 0xA, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x3, 0x0, 0x20, 0x2B, 0x2B, 0x2B, 0x0, 0x4,
  0x4, 0x4, 0x4, 0x0, 0x0, 0x1, 0x1, 0x1, 0x0, 0x1, 0x1, 0x1, 0x1, 0x0, 0x0, 0x0, 0x1, 0x1, 0x0,
  0xC, 0x2A, 0x2A, 0x2F, 0x0, 0x2, 0x2, 0x12, 0x32, 0x0, 0x10, 0x28, 0x58, 0x65, 0x0, 0x0, 0x1E,
  0x1E, 0x3D, 0x0, 0x0, 0x0, 0x1, 0x1, 0x0, 0x8, 0x8, 0x8, 0x8, 0x0, 0x0, 0xA, 0xA, 0xA, 0x0, 0x3,
  0x3, 0x3, 0x4, 0x0, 0x0, 0x2, 0x2, 0x2, 0x0, 0x2, 0x4, 0x4, 0x4, 0x0, 0x0, 0x6, 0x8, 0x8, 0x0,
  0x0, 0x0, 0x0, 0xC, 0x0, 0x1D, 0x1D, 0x1D, 0x1D, 0x0, 0x0, 0x0, 0x10, 0x1C, 0x0, 0x0, 0x1, 0x1,
  0x1, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x2, 0x2, 0x2, 0x2, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0,
  0x4, 0x4, 0x0, 0x0, 0x0, 0x0, 0x10, 0x0, 0x2, 0x2, 0x2, 0x2,
};

static const uint64_t _swift_stdlib_script_extensions[199] = {
  0x8, 0x1E800D8609F78, 0x0, 0xF0000000, 0x80FC00000000000, 0x400C, 0x0, 0x80000400000000, 0x200000,
  0xFFF8000000240000, 0x0, 0x0, 0x0, 0x0, 0x0, 0xF8, 0x0, 0x0, 0xF0000, 0x0, 0x0,
  0x1000000000000000, 0xF801000000009800, 0x14003F, 0x103FF, 0x10000000000000, 0x0, 0x0, 0x240000,
  0x0, 0x0, 0x0, 0xFFF000060000, 0x300000, 0x0, 0xFFC00000, 0x0, 0xFFC00000, 0x3E0000, 0x0, 0xFFC0,
  0x0, 0x0, 0x520000, 0xFFC0000000000000, 0xF, 0x0, 0x0, 0x5C0000, 0xFFC000000000, 0x0, 0x0, 0x0,
  0x6A0000, 0x0, 0x3FF0000, 0x0, 0x0, 0x740800, 0x0, 0x0, 0x0, 0x6000000000, 0x7F0000, 0x0, 0x0,
  0x2C00000000, 0x0, 0x810000, 0xFFFFFFFF00000000, 0x7FF, 0x0, 0x0, 0x840000, 0x500000000000003,
  0x0, 0x0, 0x0, 0xAF0000, 0x0, 0x8000, 0x0, 0x0, 0xB30000, 0x1, 0x0, 0x0, 0x0, 0xB40000, 0x0, 0x0,
  0x80000, 0x0, 0xB50000, 0xFF4E000000000000, 0xF0BF3C00FFFB, 0x0, 0x11E00, 0xB60000, 0x18000000,
  0x0, 0xFFFF000000000000, 0xFFFFFFFF00000000, 0xE5000F, 0xFFFF000000000000, 0xFFFFFF,
  0xFFFFFFFFFFFF0000, 0xFFF0001, 0x11B8000, 0x0, 0xF801FFFFFF000000, 0x0, 0x7FFFFFFF00000000,
  0x1810000, 0x0, 0x0, 0x800000000000, 0x0, 0x1BE0000, 0xFF000000000000, 0x0, 0x0, 0x0, 0x1BF0000,
  0x0, 0x3FF0000, 0x0, 0x0, 0x1C70000, 0x400000000000000A, 0x0, 0x0, 0x80000000, 0x1D10000, 0x0,
  0xC0000000, 0x0, 0x0, 0x1D50000, 0x2004, 0x600000, 0x0, 0x0, 0x1D70000, 0x0, 0x1003E00000000,
  0xC0000000, 0x0, 0x1DB0000, 0x0, 0x0, 0x0, 0xFF87000000000000, 0x1E3FFFF, 0xFF8FFFFF, 0x0, 0x0,
  0x0, 0x1FF0000, 0x0, 0x0, 0xFFFF000000000000, 0xFFF, 0x21C0000, 0x0, 0x4, 0x0, 0x0, 0x2380000,
  0x0, 0x0, 0x0, 0xA00000000, 0x2390000, 0x1800, 0x0, 0x0, 0x0, 0x23B0000, 0x0, 0x0, 0x0,
  0xB000000000000, 0x23D0000, 0x0, 0x0, 0xF, 0x0, 0x2400000, 0x0, 0x0, 0x0, 0xFFFF000000000000,
  0x2440003, 0x3, 0x0, 0x0, 0x0, 0x2560000,
};

#endif
