/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix.common.math;

public final class Math {
    public static final double EPSILON = 1.0E-15;
    public static final double ONE_THIRD = 0.3333333333333333;
    public static final double ONE_FOURTH = 0.25;
    public static final double PI = java.lang.Math.PI;
    public static final double HALF_PI = 1.5707963267948966;
    public static final double PI_OVER_FOUR = 0.7853981633974483;
    public static final double TWO_PI = java.lang.Math.PI * 2;
    public static final double ONE_OVER_PI = 0.3183098861837907;
    public static final double ONE_OVER_2PI = 0.15915494309189535;
    public static final double TWO_OVER_PI = 0.6366197723675814;
    public static final double FOUR_OVER_PI = 1.2732395447351628;
    public static final double LOG2 = Math.log(2.0);
    public static final double SQRT2 = Math.sqrt(2.0);
    public static final double SQRT2_INV = 1.0 / SQRT2;
    public static final double SQRT3 = Math.sqrt(3.0);
    public static final double SQRT3_INV = 1.0 / SQRT3;
    public static final double SQRT6 = Math.sqrt(6.0);

    public static boolean isFinite(double v) {
        return Math.abs(v) <= Double.MAX_VALUE;
    }

    public static double toRadians(double a) {
        return java.lang.Math.toRadians(a);
    }

    public static double toDegrees(double a) {
        return java.lang.Math.toDegrees(a);
    }

    public static double abs(double a) {
        return java.lang.Math.abs(a);
    }

    public static double signum(double a) {
        return java.lang.Math.signum(a);
    }

    public static int round(float a) {
        return java.lang.Math.round(a);
    }

    public static long round(double a) {
        return java.lang.Math.round(a);
    }

    public static double pow(double a, double b) {
        return java.lang.Math.pow(a, b);
    }

    public static double cos(double a) {
        return java.lang.Math.cos(a);
    }

    public static double sin(double a) {
        return java.lang.Math.sin(a);
    }

    public static double oneMinusSin(double a) {
        a *= 0.5;
        a += 0.7853981633974483;
        a = Math.cos(a);
        a *= a;
        return a *= 2.0;
    }

    public static double sqrtOfOneMinusSin(double a) {
        a *= 0.5;
        a += 0.7853981633974483;
        return SQRT2 * ((a = Math.cos(a)) > 0.0 ? a : -a);
    }

    public static double sqrtOfOneMinusSinPC(double a) {
        assert (-4.71238898038469 <= a && a <= 1.5707963267948966);
        a *= 0.5;
        a += 0.7853981633974483;
        a = Math.cos(a);
        return a *= SQRT2;
    }

    public static double tan(double a) {
        return java.lang.Math.tan(a);
    }

    public static double sinc(double a) {
        if (Math.abs(a) > 1.0E-4) {
            return Math.sin(a) / a;
        }
        a *= a;
        return 1.0 - a * (1.0 - a / 20.0) / 6.0;
    }

    public static double sincP(double a) {
        assert (a >= 0.0);
        if (a > 1.0E-4) {
            return Math.sin(a) / a;
        }
        a *= a;
        return 1.0 - a * (1.0 - a / 20.0) / 6.0;
    }

    public static double acos(double a) {
        return java.lang.Math.acos(a);
    }

    public static double asin(double a) {
        return java.lang.Math.asin(a);
    }

    public static double asinc(double a) {
        if (Math.abs(a) > 1.0E-4) {
            return Math.asin(a) / a;
        }
        a *= a;
        return 1.0 + a * (1.0 + a * 9.0 / 20.0) / 6.0;
    }

    public static double asincP(double a) {
        assert (a >= 0.0);
        if (a > 1.0E-4) {
            return Math.asin(a) / a;
        }
        a *= a;
        return 1.0 + a * (1.0 + a * 9.0 / 20.0) / 6.0;
    }

    public static double atan2(double y, double x) {
        return java.lang.Math.atan2(y, x);
    }

    public static double tanh(double x) {
        return java.lang.Math.tan(x);
    }

    public static double atanh(double x) {
        return 0.5 * Math.log((1.0 + x) / (1.0 - x));
    }

    public static double log(double x) {
        return java.lang.Math.log(x);
    }

    public static double sqrt(double angleRadians) {
        return java.lang.Math.sqrt(angleRadians);
    }

    public static int roots(double q0, double q1, double q2, double[] result) {
        double delta = q1 * q1 - 4.0 * q2 * q0;
        int i = 0;
        if (delta == 0.0) {
            result[i++] = -(0.5 * q1 / q2);
        } else if (delta > 0.0) {
            delta = Math.sqrt(delta);
            result[i++] = -0.5 * (delta + q1) / q2;
            result[i++] = 0.5 * (delta - q1) / q2;
        }
        return i;
    }

    public static int roots(double q0, double q1, double q2, double q3, double[] result) {
        q2 /= q3;
        q1 /= q3;
        q0 /= q3;
        q3 = (3.0 * q1 - q2 * q2) / 3.0;
        q2 = (2.0 * q2 * q2 * q2 - 9.0 * q1 * q2 + 27.0 * q0) / 27.0;
        double delta = 0.25 * q2 * q2 + q3 * q3 * q3 / 27.0;
        int i = 0;
        if (delta > 0.0) {
            delta = Math.sqrt(delta);
            q0 = -0.5 * q2;
            q0 = Math.pow(q0 - delta, 0.3333333333333333) + Math.pow(q0 + delta, 0.3333333333333333);
            result[i++] = q0 - 0.3333333333333333 * q1;
        } else if (delta == 0.0) {
            if (q2 < 0.0) {
                q3 = Math.sqrt(-q3 / 3.0);
                result[i++] = 2.0 * q3;
                result[i++] = -q3;
                result[i++] = -q3;
            } else if (q2 == 0.0) {
                result[i++] = 0.0;
                result[i++] = 0.0;
                result[i++] = 0.0;
            } else {
                assert (q2 > 0.0) : q2;
                q3 = Math.sqrt(-q3 / 3.0);
                result[i++] = -2.0 * q3;
                result[i++] = q3;
                result[i++] = q3;
            }
        } else {
            if (delta < 0.0) {
                throw new Error("TO BE CONTINUED!!");
            }
            assert (!Math.isFinite(delta));
        }
        assert (0 <= i && i <= 3);
        return i;
    }
}

