# 2022-01-26 Triage Log

An awesome week. There was some bits of noise from PR [#91032](https://github.com/rust-lang/rust/issues/91032) that landed and then had to be backed out (and may soon land again), and we continue to wrestle with how to classify which things to include in rollup PR's. But overall there were some very real wins to the compiler's performance, and it is definitely reflected in the [total bootstrap time graph](https://perf.rust-lang.org/bootstrap.html). Great job!

Triage done by **@pnkfelix**.
Revision range: [7bc7be860f99f4a40d45b0f74e2d01b02e072357..c54dfee65126a0ac385d55389a316e89095a0713](https://perf.rust-lang.org/?start=7bc7be860f99f4a40d45b0f74e2d01b02e072357&end=c54dfee65126a0ac385d55389a316e89095a0713&absolute=false&stat=instructions%3Au)

4 Regressions, 5 Improvements, 4 Mixed; 3 of them in rollups

29 comparisons made in total

#### Regressions

Update some rustc dependencies to deduplicate them [#92896](https://github.com/rust-lang/rust/issues/92896)
- Average relevant regression: 0.5%
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=0bcacb391b28460f5a50fd627f01f670dfcfc7cc&end=84e918971d643c6a33067d5125214ab800ce5307&stat=instructions:u): 0.6% on `full` builds of `match-stress-enum check`
- 6 of the 7 significant relevant regresions were to variants of `match-stress-enum`.
- PR author guesses that it could be noise injected via one of the dependency updates, specifically hashbrown 0.11.0 to 0.11.2.
- Left it untriaged for now (I would like to circle back and check whether there's any way to check that hypothesis; but if it goes untouched for a week, then we might just rubber-stamp it as triaged).

Disable drop range tracking in generators [#93165](https://github.com/rust-lang/rust/issues/93165)
- Average relevant regression: 284.5%
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=10c4c4afec6dfc483af6efb7019941bab9a51a29&end=d13e8dd41d44a73664943169d5b7fe39b22c449f&stat=instructions:u): 879.2% on `full` builds of `deeply-nested-async check`
- This regression was expected; it is a result of backing out PR [#91032](https://github.com/rust-lang/rust/issues/91032), which was included in rollup PR [#93138](https://github.com/rust-lang/rust/issues/93138), but was reverted due to correctness concerns (discussed under "Mixed" section below).

Revert "Do not hash leading zero bytes of i64 numbers in Sip128 hasher" [#93014](https://github.com/rust-lang/rust/issues/93014)
- Average relevant regression: 1.5%
- Average relevant improvement: -0.7%
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=ef119d704d87a05435ea97ef4161529142313a9b&end=d2dc425721554348d4ed427f7eb89cdb49efefdb&stat=instructions:u): 7.9% on `incr-full` builds of `clap-rs check`
- This regression was expected; this PR reverts a perf optimization to restore correctness.

Store a `Symbol` instead of an `Ident` in `AssocItem` [#93095](https://github.com/rust-lang/rust/issues/93095)
- Average relevant regression: 0.8%
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=92ed8747f255b2695c33b64982e6959711a72cb9&end=8cdb3cd94efece1e17cbd8f6edb1dc1a482779a0&stat=instructions:u): 2.1% on `incr-patched: compile one` builds of `regex check`
- This PR was already triaged: it is a correctness fix for incremental compilation, and the lesser of two evils (when compared to PR [#92837](https://github.com/rust-lang/rust/pull/92837)).

#### Improvements

Improve capacity estimation in Vec::from_iter [#92138](https://github.com/rust-lang/rust/issues/92138)
- Average relevant improvement: -1.4%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=237949b6c8e5b387e0a9d1e7a22e0397c95fe488&end=74fbbefea8d13683cca5eee62e4740706cb3144a&stat=instructions:u): -3.0% on `full` builds of `projection-caching doc`
- This hopefully closes the loop on an nearly four-year old hypothesized performance fix, issue [#48994](https://github.com/rust-lang/rust/issues/48994).

Make `Decodable` and `Decoder` infallible. [#93066](https://github.com/rust-lang/rust/issues/93066)
- Average relevant improvement: -0.8%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=1e4067957bd5d0e12c1657e720903209ecc291dc&end=84322efad553c7a79c80189f2d1b9197c1aa005f&stat=instructions:u): -2.1% on `full` builds of `helloworld doc`
- Wow. This [compare page](https://perf.rust-lang.org/compare.html?start=1e4067957bd5d0e12c1657e720903209ecc291dc&end=84322efad553c7a79c80189f2d1b9197c1aa005f) has an impressive amount of green.
- Perhaps even more notably, the bootstrap time had 8 seconds (-1.141%) shaved off via this PR, and from the [bootstrap graph](https://perf.rust-lang.org/bootstrap.html), the bulk of that improvement has stuck.
- Huge kudos to @**nnethercote** (the PR author) here.

Use `indexmap` to avoid sorting `LocalDefId`s [#90842](https://github.com/rust-lang/rust/issues/90842)
- Average relevant improvement: -1.1%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=51126be1b260216b41143469086e6e6ee567647e&end=e7825f2b690c9a0d21b6f6d84c404bb53b151b38&stat=instructions:u): -1.1% on `incr-unchanged` builds of `ctfe-stress-4 check`
- This is part of foundational work (namely [#90317](https://github.com/rust-lang/rust/issues/90317)) to make our incr. comp. system more robust, in that we want to ensure that information untracked for incremental compilation does not indirectly influence values and cause stable hashes to deviate.
- The point is: the motivation here is not performance. That's just a happy accident, from what I can tell.

Rustdoc: remove ListAttributesIter and use impl Iterator instead [#92353](https://github.com/rust-lang/rust/issues/92353)
- Average relevant improvement: -2.6%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=17dfae79bbc3dabe1427073086acf7f7bd45148c&end=92ed8747f255b2695c33b64982e6959711a72cb9&stat=instructions:u): -4.2% on `full` builds of `deeply-nested doc`
- rustdoc performance improvement.

Rollup of 10 pull requests [#93069](https://github.com/rust-lang/rust/issues/93069)
- Average relevant improvement: -0.7%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=2f004d2d401682e553af3984ebd9a3976885e752&end=5e57faa78aa7661c6000204591558f6665f11abc&stat=instructions:u): -1.0% on `full` builds of `ripgrep opt`
- This was auto-classifed as not relevant and pnkfelix does not know why, so its been moved in "Improvements"


#### Mixed

Rollup of 17 pull requests [#93138](https://github.com/rust-lang/rust/issues/93138)
- Average relevant regression: 1.6%
- Average relevant improvement: -57.9%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=777bb86bcdbc568be7cff6eeeaaf81a89b4aa50b&end=523be2e05da322daaecf1ecc8f2c0d625f5f46e3&stat=instructions:u): -89.5% on `full` builds of `deeply-nested-async check`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=777bb86bcdbc568be7cff6eeeaaf81a89b4aa50b&end=523be2e05da322daaecf1ecc8f2c0d625f5f46e3&stat=instructions:u): 2.6% on `full` builds of `await-call-tree check`
- The noted improvement from this roll-up was due to the inclusion of PR [#91032](https://github.com/rust-lang/rust/pull/91032), "Introduce drop range tracking to generator interior analysis".
- PR [#91032](https://github.com/rust-lang/rust/pull/91032) injected a family of ICEs, such as issue [#93161](https://github.com/rust-lang/rust/issues/93161), so the feature it added is being disabled.
- As for the improvement: The PR author, @**eholk**, made a [note](https://github.com/rust-lang/rust/pull/93138#issuecomment-1019567349) hypothesizing that the improvement to deeply-nested-async may be an artifact of how much is pruned from the generator type. (This may be a sign of a overly artificial benchmark; I wrote a [comment](https://github.com/rust-lang/rust/pull/93138#issuecomment-1021820785) asking for more clarification there.)

Emit simpler code from format_args [#91359](https://github.com/rust-lang/rust/issues/91359)
- Average relevant regression: 1.2%
- Average relevant improvement: -0.7%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=523be2e05da322daaecf1ecc8f2c0d625f5f46e3&end=0bcacb391b28460f5a50fd627f01f670dfcfc7cc&stat=instructions:u): -2.2% on `full` builds of `cranelift-codegen check`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=523be2e05da322daaecf1ecc8f2c0d625f5f46e3&end=0bcacb391b28460f5a50fd627f01f670dfcfc7cc&stat=instructions:u): 3.0% on `full` builds of `html5ever opt`
- These performance differences were anticipated ahead of time. @**simulacrum** posted a [nice analysis](https://github.com/rust-lang/rust/pull/91359#issuecomment-1013525074) explaining the probable root cause.
- Notably, "with `-Csymbol-mangling-version=v0` the hashes (changes to which cause LLVM's workload to change) go away; [...] this patch is pretty much an improvement in terms of emitted IR (as roughly expected)."

Update hashbrown to 0.12.0 [#92998](https://github.com/rust-lang/rust/issues/92998)
- Average relevant regression: 1.0%
- Average relevant improvement: -0.9%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=bfe15646761a75f0259e204cab071565eed2b1e5&end=10c4c4afec6dfc483af6efb7019941bab9a51a29&stat=instructions:u): -9.4% on `incr-patched: println` builds of `webrender opt`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=bfe15646761a75f0259e204cab071565eed2b1e5&end=10c4c4afec6dfc483af6efb7019941bab9a51a29&stat=instructions:u): 2.5% on `incr-unchanged` builds of `externs debug`
- "an overall win but with a bit of noise since this code is extremely sensitive to inlining."

Rollup of 8 pull requests [#93288](https://github.com/rust-lang/rust/issues/93288)
- Average relevant regression: 1.5%
- Average relevant improvement: -0.7%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=e7825f2b690c9a0d21b6f6d84c404bb53b151b38&end=df368ae457c54fb95d3e64f9986a5f171a6370f0&stat=instructions:u): -0.8% on `incr-full` builds of `keccak check`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=e7825f2b690c9a0d21b6f6d84c404bb53b151b38&end=df368ae457c54fb95d3e64f9986a5f171a6370f0&stat=instructions:u): 2.0% on `incr-full` builds of `stm32f4 check`
- stm32f4 regressed on many axes (check/debug/opt/doc, full and incremental); inflate check for both full and incremental. keccak improved slightly.
- It is not obvious what caused the changes here in this rollup.
- stm32f4 was added in part to test compiler trait machinery.
- After looking at each of 8 PR's in the rollup, most likely causes are either PR [#93064](https://github.com/rust-lang/rust/pull/93064/) ("Properly track DepNodes in trait evaluation provisional cache") or PR [#93175](https://github.com/rust-lang/rust/pull/93175/) ("Implement stable overlap check considering negative traits"). Left comments on each PR asking if they should have had perf runs.
- I am leaving this unmarked (i.e. untriaged) for now.

#### Untriaged Pull Requests

- [#93288 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/93288)
- [#93138 Rollup of 17 pull requests](https://github.com/rust-lang/rust/pull/93138)
- [#93095 Store a `Symbol` instead of an `Ident` in `AssocItem`](https://github.com/rust-lang/rust/pull/93095)
- [#92896 Update some rustc dependencies to deduplicate them](https://github.com/rust-lang/rust/pull/92896)
- [#92844 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/92844)
- [#92816 Remove deprecated LLVM-style inline assembly](https://github.com/rust-lang/rust/pull/92816)
- [#92805 partially revertish `lazily "compute" anon const default substs`](https://github.com/rust-lang/rust/pull/92805)
- [#92534 Hash `Ident` spans in all HIR structures](https://github.com/rust-lang/rust/pull/92534)
- [#92356 Add {Add,Sub,Mul,Div,Rem,BitXor,BitOr,BitAnd}{,Assign}<$t> to Saturat…](https://github.com/rust-lang/rust/pull/92356)
- [#92277 rustc_metadata: Stop passing `CrateMetadataRef` by reference (step 1)](https://github.com/rust-lang/rust/pull/92277)
- [#92252 Update pulldown-cmark version to 0.9](https://github.com/rust-lang/rust/pull/92252)
- [#92229 Do not display `~const Drop` in rustdoc](https://github.com/rust-lang/rust/pull/92229)
- [#92227 Rustdoc: use `is_doc_hidden` method on more places](https://github.com/rust-lang/rust/pull/92227)
- [#92149 Fix bad caching of `~const Drop` bounds](https://github.com/rust-lang/rust/pull/92149)
- [#92135 Add `#[inline]` modifier to `TypeId::of`](https://github.com/rust-lang/rust/pull/92135)
- [#92110 Backport LLVM changes to disable deferred inlining](https://github.com/rust-lang/rust/pull/92110)
- [#92106 Rollup of 4 pull requests](https://github.com/rust-lang/rust/pull/92106)
- [#92088 intra-doc: Use an enum to represent URL fragments](https://github.com/rust-lang/rust/pull/92088)
- [#92064 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/92064)
- [#92062 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/92062)
- [#92041 Remove 'speculative evaluation' of predicates](https://github.com/rust-lang/rust/pull/92041)
- [#92003 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/92003)
- [#91996 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/91996)
- [#91959 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/91959)
- [#91924 Fully serialize AdtDef](https://github.com/rust-lang/rust/pull/91924)
- [#91900 rustdoc: make `--passes` and `--no-defaults` have no effect](https://github.com/rust-lang/rust/pull/91900)
- [#91844 Eliminate `ObligationCauseData`](https://github.com/rust-lang/rust/pull/91844)
- [#91841 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/91841)
- [#91838 Do array-slice equality via array equality, rather than always via slices](https://github.com/rust-lang/rust/pull/91838)
- [#91812 rustdoc: Pretty-print assoc const defaults on-demand](https://github.com/rust-lang/rust/pull/91812)
