function(atomic_configure_file input output)
  string(RANDOM random_id)
  get_filename_component(output_file_name ${output} NAME)
  get_filename_component(atomic_file ${output} NAME)
  set(atomic_file "${CMAKE_BINARY_DIR}/atomic_configure/${atomic_file}.${random_id}")
  configure_file("${input}" "${atomic_file}" ${ARGN})
  get_filename_component(output_path ${output} PATH)
  file(COPY "${atomic_file}" DESTINATION "${output_path}")
  file(RENAME "${output_path}/${output_file_name}.${random_id}" "${output_path}/${output_file_name}")
endfunction()
