# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2022 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "Sx.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.event

import raritan.rpc.sx


# interface
class Sx(Interface):
    idlType = "sx.Sx:1.0.0"

    # structure
    class ClientInfo(Structure):
        idlType = "sx.Sx.ClientInfo:1.0.0"
        elements = ["portId", "portName", "userName", "userIp"]

        def __init__(self, portId, portName, userName, userIp):
            typecheck.is_string(portId, AssertionError)
            typecheck.is_string(portName, AssertionError)
            typecheck.is_string(userName, AssertionError)
            typecheck.is_string(userIp, AssertionError)

            self.portId = portId
            self.portName = portName
            self.userName = userName
            self.userIp = userIp

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                portId = json['portId'],
                portName = json['portName'],
                userName = json['userName'],
                userIp = json['userIp'],
            )
            return obj

        def encode(self):
            json = {}
            json['portId'] = self.portId
            json['portName'] = self.portName
            json['userName'] = self.userName
            json['userIp'] = self.userIp
            return json

    # value object
    class ClientConnectionStatusEvent(raritan.rpc.event.UserEvent):
        idlType = "sx.Sx.ClientConnectionStatusEvent:1.0.0"

        def __init__(self, clientInfo, status, clientCnt, actUserName, actIpAddr, source):
            super(raritan.rpc.sx.Sx.ClientConnectionStatusEvent, self).__init__(actUserName, actIpAddr, source)
            typecheck.is_struct(clientInfo, raritan.rpc.sx.Sx.ClientInfo, AssertionError)
            typecheck.is_bool(status, AssertionError)
            typecheck.is_int(clientCnt, AssertionError)

            self.clientInfo = clientInfo
            self.status = status
            self.clientCnt = clientCnt

        def encode(self):
            json = super(raritan.rpc.sx.Sx.ClientConnectionStatusEvent, self).encode()
            json['clientInfo'] = raritan.rpc.sx.Sx.ClientInfo.encode(self.clientInfo)
            json['status'] = self.status
            json['clientCnt'] = self.clientCnt
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                clientInfo = raritan.rpc.sx.Sx.ClientInfo.decode(json['clientInfo'], agent),
                status = json['status'],
                clientCnt = json['clientCnt'],
                # for event.UserEvent
                actUserName = json['actUserName'],
                actIpAddr = json['actIpAddr'],
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["clientInfo", "status", "clientCnt"]
            elements = elements + super(raritan.rpc.sx.Sx.ClientConnectionStatusEvent, self).listElements()
            return elements
