// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2022 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from OverCurrentProtector.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.pdumodel {
  public class OverCurrentProtector_3_0_2 : Com.Raritan.Idl.pdumodel.EDevice {

    static public readonly new TypeInfo typeInfo = new TypeInfo("pdumodel.OverCurrentProtector:3.0.2", null);

    public OverCurrentProtector_3_0_2(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public OverCurrentProtector_3_0_2(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new OverCurrentProtector_3_0_2 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new OverCurrentProtector_3_0_2(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public enum Type {
      BREAKER_1POLE,
      BREAKER_2POLE,
      BREAKER_3POLE,
      FUSE,
      FUSE_PAIR,
      RCBO_2POLE,
      RCBO_3POLE,
      RCBO_4POLE,
    }

    public class MetaData : ICloneable {
      public object Clone() {
        MetaData copy = new MetaData();
        copy.label = this.label;
        copy.namePlate = this.namePlate;
        copy.rating = this.rating;
        copy.type = this.type;
        copy.maxTripCnt = this.maxTripCnt;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["label"] = this.label;
        json["namePlate"] = this.namePlate.Encode();
        json["rating"] = this.rating.Encode();
        json["type"] = (int)this.type;
        json["maxTripCnt"] = this.maxTripCnt;
        return json;
      }

      public static MetaData Decode(LightJson.JsonObject json, Agent agent) {
        MetaData inst = new MetaData();
        inst.label = (string)json["label"];
        inst.namePlate = Com.Raritan.Idl.pdumodel.Nameplate.Decode(json["namePlate"], agent);
        inst.rating = Com.Raritan.Idl.pdumodel.Rating.Decode(json["rating"], agent);
        inst.type = (Com.Raritan.Idl.pdumodel.OverCurrentProtector_3_0_2.Type)(int)json["type"];
        inst.maxTripCnt = (int)json["maxTripCnt"];
        return inst;
      }

      public string label = "";
      public Com.Raritan.Idl.pdumodel.Nameplate namePlate = new Com.Raritan.Idl.pdumodel.Nameplate();
      public Com.Raritan.Idl.pdumodel.Rating rating = new Com.Raritan.Idl.pdumodel.Rating();
      public Com.Raritan.Idl.pdumodel.OverCurrentProtector_3_0_2.Type type = Com.Raritan.Idl.pdumodel.OverCurrentProtector_3_0_2.Type.BREAKER_1POLE;
      public int maxTripCnt = 0;
    }

    public class Sensors : ICloneable {
      public object Clone() {
        Sensors copy = new Sensors();
        copy.trip = this.trip;
        copy.voltage = this.voltage;
        copy.current = this.current;
        copy.peakCurrent = this.peakCurrent;
        copy.maximumCurrent = this.maximumCurrent;
        copy.activePower = this.activePower;
        copy.reactivePower = this.reactivePower;
        copy.apparentPower = this.apparentPower;
        copy.powerFactor = this.powerFactor;
        copy.displacementPowerFactor = this.displacementPowerFactor;
        copy.activeEnergy = this.activeEnergy;
        copy.apparentEnergy = this.apparentEnergy;
        copy.phaseAngle = this.phaseAngle;
        copy.lineFrequency = this.lineFrequency;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["trip"] = this.trip != null ? this.trip.Encode() : JsonValue.Null;
        json["voltage"] = this.voltage != null ? this.voltage.Encode() : JsonValue.Null;
        json["current"] = this.current != null ? this.current.Encode() : JsonValue.Null;
        json["peakCurrent"] = this.peakCurrent != null ? this.peakCurrent.Encode() : JsonValue.Null;
        json["maximumCurrent"] = this.maximumCurrent != null ? this.maximumCurrent.Encode() : JsonValue.Null;
        json["activePower"] = this.activePower != null ? this.activePower.Encode() : JsonValue.Null;
        json["reactivePower"] = this.reactivePower != null ? this.reactivePower.Encode() : JsonValue.Null;
        json["apparentPower"] = this.apparentPower != null ? this.apparentPower.Encode() : JsonValue.Null;
        json["powerFactor"] = this.powerFactor != null ? this.powerFactor.Encode() : JsonValue.Null;
        json["displacementPowerFactor"] = this.displacementPowerFactor != null ? this.displacementPowerFactor.Encode() : JsonValue.Null;
        json["activeEnergy"] = this.activeEnergy != null ? this.activeEnergy.Encode() : JsonValue.Null;
        json["apparentEnergy"] = this.apparentEnergy != null ? this.apparentEnergy.Encode() : JsonValue.Null;
        json["phaseAngle"] = this.phaseAngle != null ? this.phaseAngle.Encode() : JsonValue.Null;
        json["lineFrequency"] = this.lineFrequency != null ? this.lineFrequency.Encode() : JsonValue.Null;
        return json;
      }

      public static Sensors Decode(LightJson.JsonObject json, Agent agent) {
        Sensors inst = new Sensors();
        inst.trip = Com.Raritan.Idl.sensors.StateSensor_4_0_2.StaticCast(ObjectProxy.Decode(json["trip"], agent));
        inst.voltage = Com.Raritan.Idl.sensors.NumericSensor_4_0_2.StaticCast(ObjectProxy.Decode(json["voltage"], agent));
        inst.current = Com.Raritan.Idl.sensors.NumericSensor_4_0_2.StaticCast(ObjectProxy.Decode(json["current"], agent));
        inst.peakCurrent = Com.Raritan.Idl.sensors.NumericSensor_4_0_2.StaticCast(ObjectProxy.Decode(json["peakCurrent"], agent));
        inst.maximumCurrent = Com.Raritan.Idl.sensors.NumericSensor_4_0_2.StaticCast(ObjectProxy.Decode(json["maximumCurrent"], agent));
        inst.activePower = Com.Raritan.Idl.sensors.NumericSensor_4_0_2.StaticCast(ObjectProxy.Decode(json["activePower"], agent));
        inst.reactivePower = Com.Raritan.Idl.sensors.NumericSensor_4_0_2.StaticCast(ObjectProxy.Decode(json["reactivePower"], agent));
        inst.apparentPower = Com.Raritan.Idl.sensors.NumericSensor_4_0_2.StaticCast(ObjectProxy.Decode(json["apparentPower"], agent));
        inst.powerFactor = Com.Raritan.Idl.sensors.NumericSensor_4_0_2.StaticCast(ObjectProxy.Decode(json["powerFactor"], agent));
        inst.displacementPowerFactor = Com.Raritan.Idl.sensors.NumericSensor_4_0_2.StaticCast(ObjectProxy.Decode(json["displacementPowerFactor"], agent));
        inst.activeEnergy = Com.Raritan.Idl.sensors.NumericSensor_4_0_2.StaticCast(ObjectProxy.Decode(json["activeEnergy"], agent));
        inst.apparentEnergy = Com.Raritan.Idl.sensors.NumericSensor_4_0_2.StaticCast(ObjectProxy.Decode(json["apparentEnergy"], agent));
        inst.phaseAngle = Com.Raritan.Idl.sensors.NumericSensor_4_0_2.StaticCast(ObjectProxy.Decode(json["phaseAngle"], agent));
        inst.lineFrequency = Com.Raritan.Idl.sensors.NumericSensor_4_0_2.StaticCast(ObjectProxy.Decode(json["lineFrequency"], agent));
        return inst;
      }

      public Com.Raritan.Idl.sensors.StateSensor_4_0_2 trip = null;
      public Com.Raritan.Idl.sensors.NumericSensor_4_0_2 voltage = null;
      public Com.Raritan.Idl.sensors.NumericSensor_4_0_2 current = null;
      public Com.Raritan.Idl.sensors.NumericSensor_4_0_2 peakCurrent = null;
      public Com.Raritan.Idl.sensors.NumericSensor_4_0_2 maximumCurrent = null;
      public Com.Raritan.Idl.sensors.NumericSensor_4_0_2 activePower = null;
      public Com.Raritan.Idl.sensors.NumericSensor_4_0_2 reactivePower = null;
      public Com.Raritan.Idl.sensors.NumericSensor_4_0_2 apparentPower = null;
      public Com.Raritan.Idl.sensors.NumericSensor_4_0_2 powerFactor = null;
      public Com.Raritan.Idl.sensors.NumericSensor_4_0_2 displacementPowerFactor = null;
      public Com.Raritan.Idl.sensors.NumericSensor_4_0_2 activeEnergy = null;
      public Com.Raritan.Idl.sensors.NumericSensor_4_0_2 apparentEnergy = null;
      public Com.Raritan.Idl.sensors.NumericSensor_4_0_2 phaseAngle = null;
      public Com.Raritan.Idl.sensors.NumericSensor_4_0_2 lineFrequency = null;
    }

    public class Settings : ICloneable {
      public object Clone() {
        Settings copy = new Settings();
        copy.name = this.name;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["name"] = this.name;
        return json;
      }

      public static Settings Decode(LightJson.JsonObject json, Agent agent) {
        Settings inst = new Settings();
        inst.name = (string)json["name"];
        return inst;
      }

      public string name = "";
    }

    public class SettingsChangedEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("pdumodel.OverCurrentProtector_3_0_2.SettingsChangedEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

      public Com.Raritan.Idl.pdumodel.OverCurrentProtector_3_0_2.Settings oldSettings = new Com.Raritan.Idl.pdumodel.OverCurrentProtector_3_0_2.Settings();
      public Com.Raritan.Idl.pdumodel.OverCurrentProtector_3_0_2.Settings newSettings = new Com.Raritan.Idl.pdumodel.OverCurrentProtector_3_0_2.Settings();
    }

    public class GetMetaDataResult {
      public Com.Raritan.Idl.pdumodel.OverCurrentProtector_3_0_2.MetaData _ret_;
    }

    public GetMetaDataResult getMetaData() {
      JsonObject _parameters = null;
      var _result = RpcCall("getMetaData", _parameters);
      var _ret = new GetMetaDataResult();
      _ret._ret_ = Com.Raritan.Idl.pdumodel.OverCurrentProtector_3_0_2.MetaData.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getMetaData(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getMetaData(AsyncRpcResponse<GetMetaDataResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getMetaData", _parameters,
        _result => {
          try {
            var _ret = new GetMetaDataResult();
            _ret._ret_ = Com.Raritan.Idl.pdumodel.OverCurrentProtector_3_0_2.MetaData.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetSensorsResult {
      public Com.Raritan.Idl.pdumodel.OverCurrentProtector_3_0_2.Sensors _ret_;
    }

    public GetSensorsResult getSensors() {
      JsonObject _parameters = null;
      var _result = RpcCall("getSensors", _parameters);
      var _ret = new GetSensorsResult();
      _ret._ret_ = Com.Raritan.Idl.pdumodel.OverCurrentProtector_3_0_2.Sensors.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getSensors(AsyncRpcResponse<GetSensorsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSensors(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSensors(AsyncRpcResponse<GetSensorsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getSensors", _parameters,
        _result => {
          try {
            var _ret = new GetSensorsResult();
            _ret._ret_ = Com.Raritan.Idl.pdumodel.OverCurrentProtector_3_0_2.Sensors.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetPolesResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.pdumodel.DoublePole_4_0_1> _ret_;
    }

    public GetPolesResult getPoles() {
      JsonObject _parameters = null;
      var _result = RpcCall("getPoles", _parameters);
      var _ret = new GetPolesResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.DoublePole_4_0_1>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.pdumodel.DoublePole_4_0_1.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getPoles(AsyncRpcResponse<GetPolesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getPoles(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getPoles(AsyncRpcResponse<GetPolesResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getPoles", _parameters,
        _result => {
          try {
            var _ret = new GetPolesResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.pdumodel.DoublePole_4_0_1>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.pdumodel.DoublePole_4_0_1.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetInletResult {
      public Com.Raritan.Idl.pdumodel.Inlet_2_0_2 _ret_;
    }

    public GetInletResult getInlet() {
      JsonObject _parameters = null;
      var _result = RpcCall("getInlet", _parameters);
      var _ret = new GetInletResult();
      _ret._ret_ = Com.Raritan.Idl.pdumodel.Inlet_2_0_2.StaticCast(ObjectProxy.Decode(_result["_ret_"], agent));
      return _ret;
    }

    public AsyncRequest getInlet(AsyncRpcResponse<GetInletResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getInlet(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getInlet(AsyncRpcResponse<GetInletResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getInlet", _parameters,
        _result => {
          try {
            var _ret = new GetInletResult();
            _ret._ret_ = Com.Raritan.Idl.pdumodel.Inlet_2_0_2.StaticCast(ObjectProxy.Decode(_result["_ret_"], agent));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetOCPResult {
      public Com.Raritan.Idl.pdumodel.OverCurrentProtector_3_0_2 _ret_;
    }

    public GetOCPResult getOCP() {
      JsonObject _parameters = null;
      var _result = RpcCall("getOCP", _parameters);
      var _ret = new GetOCPResult();
      _ret._ret_ = Com.Raritan.Idl.pdumodel.OverCurrentProtector_3_0_2.StaticCast(ObjectProxy.Decode(_result["_ret_"], agent));
      return _ret;
    }

    public AsyncRequest getOCP(AsyncRpcResponse<GetOCPResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getOCP(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getOCP(AsyncRpcResponse<GetOCPResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getOCP", _parameters,
        _result => {
          try {
            var _ret = new GetOCPResult();
            _ret._ret_ = Com.Raritan.Idl.pdumodel.OverCurrentProtector_3_0_2.StaticCast(ObjectProxy.Decode(_result["_ret_"], agent));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetSettingsResult {
      public Com.Raritan.Idl.pdumodel.OverCurrentProtector_3_0_2.Settings _ret_;
    }

    public GetSettingsResult getSettings() {
      JsonObject _parameters = null;
      var _result = RpcCall("getSettings", _parameters);
      var _ret = new GetSettingsResult();
      _ret._ret_ = Com.Raritan.Idl.pdumodel.OverCurrentProtector_3_0_2.Settings.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSettings(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSettings(AsyncRpcResponse<GetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getSettings", _parameters,
        _result => {
          try {
            var _ret = new GetSettingsResult();
            _ret._ret_ = Com.Raritan.Idl.pdumodel.OverCurrentProtector_3_0_2.Settings.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetSettingsResult {
      public int _ret_;
    }

    public SetSettingsResult setSettings(Com.Raritan.Idl.pdumodel.OverCurrentProtector_3_0_2.Settings settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("setSettings", _parameters);
      var _ret = new SetSettingsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.pdumodel.OverCurrentProtector_3_0_2.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setSettings(settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setSettings(Com.Raritan.Idl.pdumodel.OverCurrentProtector_3_0_2.Settings settings, AsyncRpcResponse<SetSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setSettings", _parameters,
        _result => {
          try {
            var _ret = new SetSettingsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
