% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datadoc.R
\docType{data}
\name{wolves}
\alias{wolves}
\title{Skull dimensions of the wolf \emph{Canis lupus} L.}
\format{
A data frame with 25 rows and 12 variables.
The variables are as follows (all measurements are in milimeters):

\itemize{
     \item \code{class}: a factor presenting the combinations of \code{location}
         and \code{sex}. The levels are \code{arf} \code{arm} \code{rmf} and \code{rmm}
     \item \code{location}: a factor with levels \code{ar}=Arctic, \code{rm}=Rocky Mountain
     \item \code{sex}: a factor with levels \code{f}=female, \code{m}=male
     \item \code{x1}: palatal length
     \item \code{x2}: postpalatal length
     \item \code{x3}: zygomatic width
     \item \code{x4}: palatal width outside first upper molars
     \item \code{x5}: palatal width inside second upper molars
     \item \code{x6}: postglenoid foramina width
     \item \code{x7}: interorbital width
     \item \code{x8}: braincase width
     \item \code{x9}: crown length
}
}
\source{
Jolicoeur, P. Multivariate geographical variation in the wolf \emph{Canis lupis L.},
 \emph{Evolution}, XIII, 283--299.

 Morrison, D. F.  \emph{Multivariate Statistical Methods},  (3rd ed.), 1990.
 New York: McGraw-Hill, p. 288--289.
}
\usage{
data(wolves)
}
\description{
A data set containing skull morphometric measurements on Rocky Mountain
 and Arctic wolves (\emph{Canis Lupus L.}). The tdata are published in Morrison (1990),
 originally from Jolicoeur (1959).
}
\examples{

 data(wolves)

 ## Remove the factors location and sex which we will not use for now
 x <- wolves[,-c(2:3)]

 ## Plot a pairwise scaterplot matrix
 pairs(x[,2:10])

 mcd <- CovMcd(x[, 2:10])
 plot(mcd, which="pairs")

 lda <- LdaClassic(class~., data=x)
 lda@center
 lda@cov

 predict(lda)

}
\keyword{datasets}
