% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ltg2amb.R
\name{latag2n.phyDat}
\alias{latag2n.phyDat}
\title{Replace leading and trailing alignment gaps with an ambiguous state}
\usage{
latag2n.phyDat(x, amb = ifelse(attr(x, "type") == "DNA", "N", "?"),
  gap = "-", ...)
}
\arguments{
\item{x}{an object of class \code{phyDat}.}

\item{amb}{character of the ambiguous state t replace the gaps.}

\item{gap}{gap parameter to replace.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
returns an object of class \code{phyDat}.
}
\description{
Substitutes leading and trailing alignment gaps in aligned sequences into N
(i.e., A, C, G, or T) or ?. The gaps in the middle of the sequences are left
unchanged.
}
\examples{
x <- phyDat(matrix(c("-", "A", "G", "-", "T", "C"), 2, 3))
y <- latag2n.phyDat(x)
image(x)
image(y)
}
\seealso{
\code{\link[ape]{latag2n}}, \code{\link{ancestral.pml}},
\code{\link{gap_as_state}}
}
\keyword{cluster}
