% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_multimodal.R
\name{check_multimodal}
\alias{check_multimodal}
\title{Check if a distribution is unimodal or multimodal}
\usage{
check_multimodal(x, ...)
}
\arguments{
\item{x}{A numeric vector or a data frame.}

\item{...}{Arguments passed to or from other methods.}
}
\description{
For univariate distributions (one-dimensional vectors), this functions
performs a Ameijeiras-Alonso et al. (2018) excess mass test. For multivariate
distributions (dataframes), it uses mixture modelling. However, it seems that
it always returns a significant result (suggesting that the distribution is
multimodal). A better method might be needed here.
}
\examples{
\dontrun{
if (require("multimode")) {
  # Univariate
  x <- rnorm(1000)
  check_multimodal(x)
}

if (require("multimode") && require("mclust")) {
  x <- c(rnorm(1000), rnorm(1000, 2))
  check_multimodal(x)

  # Multivariate
  m <- data.frame(
    x = rnorm(200),
    y = rbeta(200, 2, 1)
  )
  plot(m$x, m$y)
  check_multimodal(m)

  m <- data.frame(
    x = c(rnorm(100), rnorm(100, 4)),
    y = c(rbeta(100, 2, 1), rbeta(100, 1, 4))
  )
  plot(m$x, m$y)
  check_multimodal(m)
}
}
}
\references{
\itemize{
\item Ameijeiras-Alonso, J., Crujeiras, R. M., and Rodríguez-Casal, A. (2019).
Mode testing, critical bandwidth and excess mass. Test, 28(3), 900-919.
}
}
