% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shape_properties.R
\name{sp_line}
\alias{sp_line}
\alias{print.sp_line}
\alias{update.sp_line}
\title{Line properties}
\usage{
sp_line(
  color = "transparent",
  lwd = 1,
  lty = "solid",
  linecmpd = "sng",
  lineend = "rnd",
  linejoin = "round",
  headend = sp_lineend(type = "none"),
  tailend = sp_lineend(type = "none")
)

\method{print}{sp_line}(x, ...)

\method{update}{sp_line}(
  object,
  color,
  lwd,
  lty,
  linecmpd,
  lineend,
  linejoin,
  headend,
  tailend,
  ...
)
}
\arguments{
\item{color}{line color - a single character value specifying
a valid color (e.g. "#000000" or "black").}

\item{lwd}{line width (in point) - 0 or positive integer value.}

\item{lty}{single character value specifying the line type.
Expected value is one of the following : default \code{'solid'}
or \code{'dot'} or \code{'dash'} or \code{'lgDash'}
or \code{'dashDot'} or \code{'lgDashDot'} or \code{'lgDashDotDot'}
or \code{'sysDash'} or \code{'sysDot'} or \code{'sysDashDot'}
or \code{'sysDashDotDot'}.}

\item{linecmpd}{single character value specifying the compound line type.
Expected value is one of the following : default \code{'sng'}
or \code{'dbl'} or \code{'tri'} or \code{'thinThick'}
or \code{'thickThin'}}

\item{lineend}{single character value specifying the line end style
Expected value is one of the following : default \code{'rnd'}
or \code{'sq'} or \code{'flat'}}

\item{linejoin}{single character value specifying the line join style
Expected value is one of the following : default \code{'round'}
or \code{'bevel'} or \code{'miter'}}

\item{headend}{a \code{sp_lineend} object specifying line head end style}

\item{tailend}{a \code{sp_lineend} object specifying line tail end style}

\item{x, object}{\code{sp_line} object}

\item{...}{further arguments - not used}
}
\value{
a \code{sp_line} object
}
\description{
Create a \code{sp_line} object that describes
line properties.
}
\examples{
sp_line()
sp_line(color = "red", lwd = 2)
sp_line(lty = "dot", linecmpd = "dbl")
print( sp_line (color="red", lwd = 2) )
obj <- sp_line (color="red", lwd = 2)
update( obj, linecmpd = "dbl" )
}
\seealso{
\link{sp_lineend}

Other functions for defining shape properties: 
\code{\link{sp_lineend}()}
}
\concept{functions for defining shape properties}
