% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count.R
\name{fct_count}
\alias{fct_count}
\title{Count entries in a factor}
\usage{
fct_count(f, sort = FALSE, prop = FALSE)
}
\arguments{
\item{f}{A factor (or character vector).}

\item{sort}{If \code{TRUE}, sort the result so that the most common values
float to the top.}

\item{prop}{If \code{TRUE}, compute the fraction of marginal table.}
}
\value{
A tibble with columns \code{f}, \code{n} and \code{p}, if prop is \code{TRUE}.
}
\description{
Count entries in a factor
}
\examples{
f <- factor(sample(letters)[rpois(1000, 10)])
table(f)
fct_count(f)
fct_count(f, sort = TRUE)
fct_count(f, sort = TRUE, prop = TRUE)
}
