% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelling.R
\name{align_coefs}
\alias{align_coefs}
\title{Align and combine fixed-effect coefficients from multiple models}
\usage{
align_coefs(models)
}
\arguments{
\item{models}{A named list of fitted model objects. Each element should be a
model that can be passed to \code{broom::tidy()}.}
}
\value{
A tibble with columns:
\describe{
\item{model}{The name of the model (from the list).}
\item{term}{The term name (coefficient).}
\item{estimate}{The estimated coefficient.}
\item{std.error}{The standard error.}
\item{statistic}{The Wald statistic (estimate / std.error).}
\item{p.value}{Two-sided normal p-value.}
}
}
\description{
Extracts and aligns the fixed-effect estimates from a list of fitted model objects,
returning them in a single tidy data frame with consistent columns for easy comparison.
Works with a mix of model types such as \code{lm}, \code{glm}, \code{gls}, \code{lmer}, etc.

For models without p-values (e.g., \code{lmer}), the function computes approximate
Wald statistics and two-sided normal p-values.
}
\examples{
# Example using the built-in CO2 dataset
data(CO2)

# Fit models
lm_fit  <- lm(uptake ~ conc + Type + Treatment, data = CO2)
glm_fit <- glm(uptake ~ conc + Type + Treatment, family = Gamma(identity), data = CO2)

# Combine estimates
models_list <- list(lm = lm_fit, glm = glm_fit)
result <- align_coefs(models_list)
print(result)

}
