% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/car-tidiers.R
\name{durbinWatsonTest_tidiers}
\alias{durbinWatsonTest_tidiers}
\alias{tidy.durbinWatsonTest}
\alias{glance.durbinWatsonTest}
\title{Tidy/glance a(n) durbinWatsonTest object}
\usage{
\method{tidy}{durbinWatsonTest}(x, ...)

\method{glance}{durbinWatsonTest}(x, ...)
}
\arguments{
\item{x}{An object of class \code{durbinWatsonTest} created by a call to
\code{\link[car:durbinWatsonTest]{car::durbinWatsonTest()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Two exceptions here are:
\itemize{
\item \code{tidy()} methods will warn when supplied an \code{exponentiate} argument if
it will be ignored.
\item \code{augment()} methods will warn when supplied a \code{newdata} argument if it
will be ignored.
}}
}
\description{
For models that have only a single component, the \code{\link[=tidy]{tidy()}} and
\code{\link[=glance]{glance()}} methods are identical. Please see the documentation for both
of those methods.
}
\examples{
\dontshow{if (rlang::is_installed("car")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# load modeling library
library(car)

# fit model
dw <- durbinWatsonTest(lm(mpg ~ wt, data = mtcars))

# summarize model fit with tidiers
tidy(dw)

# same output for all durbinWatsonTests
glance(dw) 
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[=glance]{glance()}}, \code{\link[car:durbinWatsonTest]{car::durbinWatsonTest()}}

Other car tidiers: 
\code{\link{leveneTest_tidiers}}
}
\concept{car tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{alternative}{Alternative hypothesis (character).}
  \item{autocorrelation}{Autocorrelation.}
  \item{p.value}{The two-sided p-value associated with the observed statistic.}
  \item{statistic}{Test statistic for Durbin-Watson test.}
  \item{method}{Always `Durbin-Watson Test`.}

}
