% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setCondaPackageDir.R
\name{setCondaPackageDir}
\alias{setCondaPackageDir}
\title{Set or unset the Conda package directory}
\usage{
setCondaPackageDir(loc)
}
\arguments{
\item{loc}{A string containing a path to the desired directory (that should already exist).
Alternatively \code{NA}, in which case any existing setting is removed.}
}
\value{
The previous value of \code{CONDA_PKGS_DIRS}, invisibly.
}
\description{
Set or unset the directory used to store the cached Conda packages, e.g., tarballs and such.
This should be a non-temporary location as other packages may link to its contents.
}
\examples{
# Setting it to something new:
out <- setCondaPackageDir(tempdir())

# Setting it back
setCondaPackageDir(out)

}
\author{
Aaron Lun
}
