# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.migrationassessment.aio import MigrationAssessmentMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestMigrationAssessmentMgmtAvsAssessmentsOperationsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(MigrationAssessmentMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_avs_assessments_operations_list_by_group(self, resource_group):
        response = self.client.avs_assessments_operations.list_by_group(
            resource_group_name=resource_group.name,
            project_name="str",
            group_name="str",
            api_version="2023-03-15",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_avs_assessments_operations_get(self, resource_group):
        response = await self.client.avs_assessments_operations.get(
            resource_group_name=resource_group.name,
            project_name="str",
            group_name="str",
            assessment_name="str",
            api_version="2023-03-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_avs_assessments_operations_begin_create(self, resource_group):
        response = await (
            await self.client.avs_assessments_operations.begin_create(
                resource_group_name=resource_group.name,
                project_name="str",
                group_name="str",
                assessment_name="str",
                resource={
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "assessmentErrorSummary": {"str": 0},
                        "assessmentType": "str",
                        "azureLocation": "str",
                        "azureOfferCode": "str",
                        "confidenceRatingInPercentage": 0.0,
                        "cpuUtilization": 0.0,
                        "createdTimestamp": "2020-02-20 00:00:00",
                        "currency": "str",
                        "dedupeCompression": 0.0,
                        "discountPercentage": 0.0,
                        "failuresToTolerateAndRaidLevel": "str",
                        "groupType": "str",
                        "isStretchClusterEnabled": bool,
                        "limitingFactor": "str",
                        "memOvercommit": 0.0,
                        "nodeType": "str",
                        "numberOfMachines": 0,
                        "numberOfNodes": 0,
                        "percentile": "str",
                        "perfDataEndTime": "2020-02-20 00:00:00",
                        "perfDataStartTime": "2020-02-20 00:00:00",
                        "pricesTimestamp": "2020-02-20 00:00:00",
                        "provisioningState": "str",
                        "ramUtilization": 0.0,
                        "reservedInstance": "str",
                        "scalingFactor": 0.0,
                        "schemaVersion": "str",
                        "sizingCriterion": "str",
                        "stage": "str",
                        "status": "str",
                        "storageUtilization": 0.0,
                        "suitability": "str",
                        "suitabilityExplanation": "str",
                        "suitabilitySummary": {"str": 0},
                        "timeRange": "str",
                        "totalCpuCores": 0.0,
                        "totalMonthlyCost": 0.0,
                        "totalRamInGB": 0.0,
                        "totalStorageInGB": 0.0,
                        "updatedTimestamp": "2020-02-20 00:00:00",
                        "vcpuOversubscription": 0.0,
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
                api_version="2023-03-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_avs_assessments_operations_delete(self, resource_group):
        response = await self.client.avs_assessments_operations.delete(
            resource_group_name=resource_group.name,
            project_name="str",
            group_name="str",
            assessment_name="str",
            api_version="2023-03-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_avs_assessments_operations_begin_download_url(self, resource_group):
        response = await (
            await self.client.avs_assessments_operations.begin_download_url(
                resource_group_name=resource_group.name,
                project_name="str",
                group_name="str",
                assessment_name="str",
                body={},
                api_version="2023-03-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
