# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.eventhub import EventHubManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestEventHubManagementEventHubsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(EventHubManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_event_hubs_list_authorization_rules(self, resource_group):
        response = self.client.event_hubs.list_authorization_rules(
            resource_group_name=resource_group.name,
            namespace_name="str",
            event_hub_name="str",
            api_version="2022-01-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_event_hubs_create_or_update_authorization_rule(self, resource_group):
        response = self.client.event_hubs.create_or_update_authorization_rule(
            resource_group_name=resource_group.name,
            namespace_name="str",
            event_hub_name="str",
            authorization_rule_name="str",
            parameters={
                "id": "str",
                "location": "str",
                "name": "str",
                "rights": ["str"],
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2022-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_event_hubs_get_authorization_rule(self, resource_group):
        response = self.client.event_hubs.get_authorization_rule(
            resource_group_name=resource_group.name,
            namespace_name="str",
            event_hub_name="str",
            authorization_rule_name="str",
            api_version="2022-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_event_hubs_delete_authorization_rule(self, resource_group):
        response = self.client.event_hubs.delete_authorization_rule(
            resource_group_name=resource_group.name,
            namespace_name="str",
            event_hub_name="str",
            authorization_rule_name="str",
            api_version="2022-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_event_hubs_list_keys(self, resource_group):
        response = self.client.event_hubs.list_keys(
            resource_group_name=resource_group.name,
            namespace_name="str",
            event_hub_name="str",
            authorization_rule_name="str",
            api_version="2022-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_event_hubs_regenerate_keys(self, resource_group):
        response = self.client.event_hubs.regenerate_keys(
            resource_group_name=resource_group.name,
            namespace_name="str",
            event_hub_name="str",
            authorization_rule_name="str",
            parameters={"keyType": "str", "key": "str"},
            api_version="2022-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_event_hubs_list_by_namespace(self, resource_group):
        response = self.client.event_hubs.list_by_namespace(
            resource_group_name=resource_group.name,
            namespace_name="str",
            api_version="2022-01-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_event_hubs_create_or_update(self, resource_group):
        response = self.client.event_hubs.create_or_update(
            resource_group_name=resource_group.name,
            namespace_name="str",
            event_hub_name="str",
            parameters={
                "captureDescription": {
                    "destination": {
                        "archiveNameFormat": "str",
                        "blobContainer": "str",
                        "dataLakeAccountName": "str",
                        "dataLakeFolderPath": "str",
                        "dataLakeSubscriptionId": "str",
                        "name": "str",
                        "storageAccountResourceId": "str",
                    },
                    "enabled": bool,
                    "encoding": "str",
                    "intervalInSeconds": 0,
                    "sizeLimitInBytes": 0,
                    "skipEmptyArchives": bool,
                },
                "createdAt": "2020-02-20 00:00:00",
                "id": "str",
                "location": "str",
                "messageRetentionInDays": 0,
                "name": "str",
                "partitionCount": 0,
                "partitionIds": ["str"],
                "status": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
                "updatedAt": "2020-02-20 00:00:00",
            },
            api_version="2022-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_event_hubs_delete(self, resource_group):
        response = self.client.event_hubs.delete(
            resource_group_name=resource_group.name,
            namespace_name="str",
            event_hub_name="str",
            api_version="2022-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_event_hubs_get(self, resource_group):
        response = self.client.event_hubs.get(
            resource_group_name=resource_group.name,
            namespace_name="str",
            event_hub_name="str",
            api_version="2022-01-01-preview",
        )

        # please add some check logic here by yourself
        # ...
