# Reference

<!-- DO NOT EDIT: This document was generated by Puppet Strings -->

## Table of Contents

### Classes

* [`kmod`](#kmod): Ensures a couple of mandatory files are present before managing their content.

### Defined types

* [`kmod::alias`](#kmodalias): Manage kernel module aliases
* [`kmod::blacklist`](#kmodblacklist): Set a kernel module as blacklisted.
* [`kmod::install`](#kmodinstall): Set a kernel module as installed
* [`kmod::load`](#kmodload): Manage a kernel module in /etc/modules.
* [`kmod::option`](#kmodoption): Manage kernel module options
* [`kmod::setting`](#kmodsetting): Manage kernel module settings

## Classes

### <a name="kmod"></a>`kmod`

Ensures a couple of mandatory files are present before managing their content.

#### Examples

##### 

```puppet
include kmod
```

#### Parameters

The following parameters are available in the `kmod` class:

* [`list_of_aliases`](#list_of_aliases)
* [`list_of_blacklists`](#list_of_blacklists)
* [`list_of_installs`](#list_of_installs)
* [`list_of_loads`](#list_of_loads)
* [`list_of_options`](#list_of_options)
* [`owner`](#owner)
* [`group`](#group)
* [`directory_mode`](#directory_mode)
* [`file_mode`](#file_mode)
* [`exe_mode`](#exe_mode)
* [`modprobe_d`](#modprobe_d)
* [`modprobe_d_files`](#modprobe_d_files)

##### <a name="list_of_aliases"></a>`list_of_aliases`

Data type: `Hash`

Hash of [`kmod::alias`](#kmodalias) resources

Default value: `{}`

##### <a name="list_of_blacklists"></a>`list_of_blacklists`

Data type: `Hash`

Hash of [`kmod::blacklist`](#kmodblacklist) resources

Default value: `{}`

##### <a name="list_of_installs"></a>`list_of_installs`

Data type: `Hash`

Hash of [`kmod::install`](#kmodinstall) resources

Default value: `{}`

##### <a name="list_of_loads"></a>`list_of_loads`

Data type: `Hash`

Hash of [`kmod::load`](#kmodload) resources

Default value: `{}`

##### <a name="list_of_options"></a>`list_of_options`

Data type: `Hash`

Hash of [`kmod::option`](#kmodoption) resources

Default value: `{}`

##### <a name="owner"></a>`owner`

Data type: `String[1]`

Default owner for all files (set via Hiera to allow defaults on all defined types)

Default value: `'root'`

##### <a name="group"></a>`group`

Data type: `String[1]`

Default group for all files (set via Hiera to allow defaults on all defined types)

Default value: `'root'`

##### <a name="directory_mode"></a>`directory_mode`

Data type: `Stdlib::Filemode`

Default mode for all directories (set via Hiera to allow defaults on all defined types)

Default value: `'0755'`

##### <a name="file_mode"></a>`file_mode`

Data type: `Stdlib::Filemode`

Default mode for all regular files (set via Hiera to allow defaults on all defined types)

Default value: `'0644'`

##### <a name="exe_mode"></a>`exe_mode`

Data type: `Stdlib::Filemode`

Default mode for all executable files (set via Hiera to allow defaults on all defined types)

Default value: `'0755'`

##### <a name="modprobe_d"></a>`modprobe_d`

Data type: `Stdlib::Unixpath`

Location of `modprobe.d` directory

Default value: `'/etc/modprobe.d'`

##### <a name="modprobe_d_files"></a>`modprobe_d_files`

Data type: `Array[Stdlib::Unixpath]`

Default files to create in `modprobe.d` directory

Default value: `[
    '/etc/modprobe.d/modprobe.conf',
    '/etc/modprobe.d/aliases.conf',
    '/etc/modprobe.d/blacklist.conf',
  ]`

## Defined types

### <a name="kmodalias"></a>`kmod::alias`

Manage kernel module aliases

#### Examples

##### 

```puppet
kmod::alias { 'bond0':
  source => 'bonding',
}
```

#### Parameters

The following parameters are available in the `kmod::alias` defined type:

* [`source`](#source)
* [`ensure`](#ensure)
* [`file`](#file)
* [`aliasname`](#aliasname)

##### <a name="source"></a>`source`

Data type: `String[1]`

Name of the module to alias

##### <a name="ensure"></a>`ensure`

Data type: `Enum['present', 'absent']`

State of the alias

Default value: `'present'`

##### <a name="file"></a>`file`

Data type: `Stdlib::Unixpath`

File to manage

Default value: `"/etc/modprobe.d/${name}.conf"`

##### <a name="aliasname"></a>`aliasname`

Data type: `String[1]`

Name of the alias (defaults to the resource title)

Default value: `$name`

### <a name="kmodblacklist"></a>`kmod::blacklist`

Set a kernel module as blacklisted.

#### Examples

##### 

```puppet
kmod::blacklist { 'pcspkr': }
```

#### Parameters

The following parameters are available in the `kmod::blacklist` defined type:

* [`ensure`](#ensure)
* [`file`](#file)

##### <a name="ensure"></a>`ensure`

Data type: `Enum['present', 'absent']`

State of the setting

Default value: `'present'`

##### <a name="file"></a>`file`

Data type: `Stdlib::Unixpath`

File to manage

Default value: `'/etc/modprobe.d/blacklist.conf'`

### <a name="kmodinstall"></a>`kmod::install`

Set a kernel module as installed

#### Examples

##### 

```puppet
kmod::install { 'pcspkr': }
```

#### Parameters

The following parameters are available in the `kmod::install` defined type:

* [`ensure`](#ensure)
* [`command`](#command)
* [`file`](#file)

##### <a name="ensure"></a>`ensure`

Data type: `Enum['present', 'absent']`

State of the setting

Default value: `'present'`

##### <a name="command"></a>`command`

Data type: `String[1]`

Command associated with the kernel module

Default value: `'/bin/true'`

##### <a name="file"></a>`file`

Data type: `Stdlib::Unixpath`

File where the stanza is written

Default value: `"/etc/modprobe.d/${name}.conf"`

### <a name="kmodload"></a>`kmod::load`

Manage a kernel module in /etc/modules.

#### Examples

##### 

```puppet
kmod::load { 'sha256': }
```

#### Parameters

The following parameters are available in the `kmod::load` defined type:

* [`ensure`](#ensure)
* [`file`](#file)

##### <a name="ensure"></a>`ensure`

Data type: `Enum['present', 'absent']`

State of the setting

Default value: `'present'`

##### <a name="file"></a>`file`

Data type: `Stdlib::Unixpath`

Optionally, set the file where the stanza is written. Not
used for systems running systemd.

Default value: `'/etc/modules'`

### <a name="kmodoption"></a>`kmod::option`

Manage kernel module options

#### Examples

##### 

```puppet
kmod::option { 'bond0 mode':
  module  => 'bond0',
  option  => 'mode',
  value   => '1',
}
```

#### Parameters

The following parameters are available in the `kmod::option` defined type:

* [`option`](#option)
* [`value`](#value)
* [`module`](#module)
* [`ensure`](#ensure)
* [`file`](#file)

##### <a name="option"></a>`option`

Data type: `String[1]`

Option to manage

##### <a name="value"></a>`value`

Data type: `Scalar`

Value of kernel module option

##### <a name="module"></a>`module`

Data type: `String[1]`

Kernel module to manage

Default value: `$name`

##### <a name="ensure"></a>`ensure`

Data type: `Enum['present', 'absent']`

State of the option

Default value: `'present'`

##### <a name="file"></a>`file`

Data type: `Stdlib::Unixpath`

File to manage

Default value: `"/etc/modprobe.d/${module}.conf"`

### <a name="kmodsetting"></a>`kmod::setting`

Manage kernel module settings

#### Examples

##### 

```puppet
kmod__setting { 'kmod::option bond0 mode':
  ensure   => 'present',
  module   => 'bond0',
  category => 'options',
  file     => '/etc/modprobe.d/bond0.conf',
  option   => 'mode',
  value    => '1',
}
```

#### Parameters

The following parameters are available in the `kmod::setting` defined type:

* [`file`](#file)
* [`category`](#category)
* [`option`](#option)
* [`value`](#value)
* [`module`](#module)
* [`ensure`](#ensure)

##### <a name="file"></a>`file`

Data type: `Stdlib::Unixpath`

File to manage

##### <a name="category"></a>`category`

Data type: `String[1]`

Setting type

##### <a name="option"></a>`option`

Data type: `Optional[String]`

Key to manage

Default value: ``undef``

##### <a name="value"></a>`value`

Data type: `Optional[Scalar]`

Value to manage

Default value: ``undef``

##### <a name="module"></a>`module`

Data type: `String[1]`

Module to manage

Default value: `$name`

##### <a name="ensure"></a>`ensure`

Data type: `Enum['present', 'absent']`

State of the setting

Default value: `'present'`

