/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.tim.Eater;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.EaterExceptionLocated;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TFunctionImpl;
import net.sourceforge.plantuml.tim.TMemory;

public class EaterDeclareReturnFunction
extends Eater {
    private TFunctionImpl function;
    private final LineLocation location;
    private boolean finalFlag;

    public EaterDeclareReturnFunction(StringLocated s) {
        super(s.getTrimmed());
        this.location = s.getLocation();
    }

    @Override
    public void analyze(TContext context, TMemory memory) throws EaterException, EaterExceptionLocated {
        this.skipSpaces();
        this.checkAndEatChar("!");
        boolean unquoted = false;
        while (this.peekUnquoted() || this.peekFinal()) {
            if (this.peekUnquoted()) {
                this.checkAndEatChar("unquoted");
                this.skipSpaces();
                unquoted = true;
                continue;
            }
            if (!this.peekFinal()) continue;
            this.checkAndEatChar("final");
            this.skipSpaces();
            this.finalFlag = true;
        }
        this.checkAndEatChar("function");
        this.skipSpaces();
        this.function = this.eatDeclareReturnFunctionWithOptionalReturn(context, memory, unquoted, this.location);
    }

    private boolean peekUnquoted() {
        return this.peekChar() == 'u';
    }

    private boolean peekFinal() {
        return this.peekChar() == 'f' && this.peekCharN2() == 'i';
    }

    public TFunctionImpl getFunction() {
        return this.function;
    }

    public final boolean getFinalFlag() {
        return this.finalFlag;
    }
}

