Minutes from 125-th OpenVDB TSC meeting, March 22nd, 2022, (EDT)

Attendees: *Ken* M., *Jeff* L., *Nick* A, *Dan* B., *Rich* J., *Andre* P.

Additional Attendees: Sebastian Gaida, Serjio Rojas, Greg Hurst
(United Therapeutics), Kyle Wardlow (United Therapeutics).

Regrets: None

Agenda:

1) Confirm quorum
2) Secretary
3) Forum
4) PRs
5) vdb_tool update
6) Threading and Interrupter
7) Next meeting

--------------------

1) Confirm quorum

Quorum is present.

2) Secretary

Secretary is Jeff Lait.

3) Forum

a) Build Issue

Will be responded to.

b) Memory usage of a single point

Reported it takes 1.6mb used to allocate one voxel.  The full internal
leaves have a union, this non-trivial data type will be bloating the
size of the internal nodes.  Someone else should respond that this is
expected.  Ken to reply

c) How to use advection for VDB points

Code snippet unclear.  Dan will look at.

d) Grid value assigned unexpected results

Not clear what they are referring to with the images.   Jeff will
reply to it.

4) PRs

a) 1330: Updated UBSAN builds to fail on errors

Fixed most of the issues that can be fixed, suppressed the others, and
added fail on error.  So if we get any new undefined behaviour we'll
trigger an error.   Removes NanoVDB as there is a lot of UB in that.

b) 1334: AX improvements

For Richard to review.  Updates point kernels to have same
optimization as the volume kernels, to do the loops in LLVM rather
than C++.  Also adds codecs to AX to match VDB Points.  This lets LLVM
then do the optimization.

c) 1335: maxMemusage and TypeLists

Attempt to improve vdb_print's memory report.  So we report
delay-loaded data as maximum.  Maximum could be confusing.  But so are
other possible choices, like "total".  Also need an API method to
return this, currently maxMemoryUsage.  Perhaps "If Loaded" and
"memUsageIfLoaded".

How to make a free standing function that can dispatch to the proper
type of VDB?  Traditionally we used virtual functions.  This PR adds
SupportedTypes as a type list that can be used when you apply.

We can then use apply<> and foreach<> to run dispatch.  Ideally we
could add SupportedGridTypes to the build process so custom grids can
get access too.

Should it be AllGridTypes rather than SupportedGridTypes?  Advantage
of SupportedTypes is that are the types supported in default library
tools.

d) PR1319 vdb_cmd relocation

Moves the command tools out from openvdb/openvdb/cmd to openvdb_cmd.
Nick to look at.  So vdb_tools will go to the new command folder.
This allows our binaries to build after all tools, in particular ax.

5) vdb_tool update

A new massive change is in-bound.  Led down the rabbit-hole of Forth,
there is a scripting language built with it.  This clarifies a lot of
the earlier decisions.

6) Threading and Interrupter

threading = true is a dangerous way to set threading.  Sometimes you
want more grain sizes.  And default parameters cause their own issues
- the nullptr from an interrupt got passed to the threading parameter
so disabled threading.

We want to support different threading primitives in the future (other
than TBB).  We could demand a struct or object that defines state like
threads/interrupter.  Or we have a more global, some file-static data
that sets threading levels.

There could be some context or state structure you have to specify.
Morphology does some more dynamic scheduling that is hard to frame in
terms of grain size.  Often want to turn off threading at a top level
and have everything below single threaded.

Maybe we have an enum with some policies.  So threaded_8 rather than a
separate 8 grain size parameter.  We could have an enum with OFF and
DEFAULT and then add policies as needed.

7) Next meeting

Next meeting is at March 29th, 2022. 1pm-2pm EDT (GMT-4).
