-- MySQL dump 10.11
--
-- Host: localhost    Database: oar
-- ------------------------------------------------------
-- Server version	5.0.51a-15-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `accounting`
--

DROP TABLE IF EXISTS `accounting`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `accounting` (
  `window_start` int(10) unsigned NOT NULL,
  `window_stop` int(10) unsigned NOT NULL,
  `accounting_user` varchar(255) NOT NULL,
  `accounting_project` varchar(255) NOT NULL,
  `queue_name` varchar(100) NOT NULL,
  `consumption_type` enum('ASKED','USED') NOT NULL,
  `consumption` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`window_start`,`window_stop`,`accounting_user`,`accounting_project`,`queue_name`,`consumption_type`),
  KEY `accounting_user` (`accounting_user`),
  KEY `accounting_project` (`accounting_project`),
  KEY `accounting_queue` (`queue_name`),
  KEY `accounting_type` (`consumption_type`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `accounting`
--

LOCK TABLES `accounting` WRITE;
/*!40000 ALTER TABLE `accounting` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounting` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admission_rules`
--

DROP TABLE IF EXISTS `admission_rules`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `admission_rules` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `rule` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `admission_rules`
--

LOCK TABLES `admission_rules` WRITE;
/*!40000 ALTER TABLE `admission_rules` DISABLE KEYS */;
INSERT INTO `admission_rules` VALUES (1,'if (not defined($queue_name)) {$queue_name=\"default\";}'),(2,'die (\"[ADMISSION RULE] root and oar users are not allowed to submit jobs.\\n\") if ( $user eq \"root\" or $user eq \"oar\" );'),(3,'\nmy $admin_group = \"admin\";\nif ($queue_name eq \"admin\") {\n    my $members; \n    (undef,undef,undef, $members) = getgrnam($admin_group);\n    my %h = map { $_ => 1 } split(/\\s+/,$members);\n    if ( $h{$user} ne 1 ) {\n        {die(\"[ADMISSION RULE] Only member of the group \".$admin_group.\" can submit jobs in the admin queue\\n\");}\n    }\n}\n'),(4,'\nmy @bad_resources = (\"type\",\"state\",\"next_state\",\"finaud_decision\",\"next_finaud_decision\",\"state_num\",\"suspended_jobs\",\"besteffort\",\"deploy\",\"expiry_date\",\"desktop_computing\",\"last_job_date\",\"available_upto\",\"scheduler_priority\");\nforeach my $mold (@{$ref_resource_list}){\n    foreach my $r (@{$mold->[0]}){\n        my $i = 0;\n        while (($i <= $#{$r->{resources}})){\n            if (grep(/^$r->{resources}->[$i]->{resource}$/, @bad_resources)){\n                die(\"[ADMISSION RULE] \'$r->{resources}->[$i]->{resource}\' resource is not allowed\\n\");\n            }\n            $i++;\n        }\n    }\n}\n'),(5,'\nif (grep(/^besteffort$/, @{$type_list}) and not $queue_name eq \"besteffort\"){\n    $queue_name = \"besteffort\";\n    print(\"[ADMISSION RULE] Automatically redirect in the besteffort queue\\n\");\n}\nif ($queue_name eq \"besteffort\" and not grep(/^besteffort$/, @{$type_list})) {\n    push(@{$type_list},\"besteffort\");\n    print(\"[ADMISSION RULE] Automatically add the besteffort type\\n\");\n}\nif (grep(/^besteffort$/, @{$type_list})){\n    if ($jobproperties ne \"\"){\n        $jobproperties = \"($jobproperties) AND besteffort = \\\'YES\\\'\";\n    }else{\n        $jobproperties = \"besteffort = \\\'YES\\\'\";\n    }\n    print(\"[ADMISSION RULE] Automatically add the besteffort constraint on the resources\\n\");\n}\n'),(6,'\nif ((grep(/^besteffort$/, @{$type_list})) and ($reservationField ne \"None\")){\n    die(\"[ADMISSION RULE] Error: a job cannot both be of type besteffort and be a reservation.\\n\");\n}\n'),(7,'\nif (grep(/^deploy$/, @{$type_list})){\n    if ($jobproperties ne \"\"){\n        $jobproperties = \"($jobproperties) AND deploy = \\\'YES\\\'\";\n    }else{\n        $jobproperties = \"deploy = \\\'YES\\\'\";\n    }\n}\n'),(8,'\nmy @bad_resources = (\"core\",\"cpu\",\"resource_id\",);\nif (grep(/^(deploy|allow_classic_ssh)$/, @{$type_list})){\n    foreach my $mold (@{$ref_resource_list}){\n        foreach my $r (@{$mold->[0]}){\n            my $i = 0;\n            while (($i <= $#{$r->{resources}})){\n                if (grep(/^$r->{resources}->[$i]->{resource}$/, @bad_resources)){\n                    die(\"[ADMISSION RULE] \'$r->{resources}->[$i]->{resource}\' resource is not allowed with a deploy or allow_classic_ssh type job\\n\");\n                }\n                $i++;\n            }\n        }\n    }\n}\n'),(9,'\nif (grep(/^desktop_computing$/, @{$type_list})){\n    print(\"[ADMISSION RULE] Added automatically desktop_computing resource constraints\\n\");\n    if ($jobproperties ne \"\"){\n        $jobproperties = \"($jobproperties) AND desktop_computing = \\\'YES\\\'\";\n    }else{\n        $jobproperties = \"desktop_computing = \\\'YES\\\'\";\n    }\n}else{\n    if ($jobproperties ne \"\"){\n        $jobproperties = \"($jobproperties) AND desktop_computing = \\\'NO\\\'\";\n    }else{\n        $jobproperties = \"desktop_computing = \\\'NO\\\'\";\n    }\n}\n'),(10,'\nif ($reservationField eq \"toSchedule\") {\n    my $unlimited=0;\n    if (open(FILE, \"< $ENV{HOME}/unlimited_reservation.users\")) {\n        while (<FILE>){\n            if (m/^\\s*$user\\s*$/m){\n                $unlimited=1;\n            }\n        }\n        close(FILE);\n    }\n    if ($unlimited > 0) {\n        print(\"[ADMISSION RULE] $user is granted the privilege to do unlimited reservations\\n\");\n    } else {\n        my $max_nb_resa = 2;\n        my $nb_resa = $dbh->do(\"    SELECT job_id\n                                    FROM jobs\n                                    WHERE\n                                        job_user = \\\'$user\\\' AND\n                                        (reservation = \\\'toSchedule\\\' OR\n                                        reservation = \\\'Scheduled\\\') AND\n                                        (state = \\\'Waiting\\\' OR state = \\\'Hold\\\')\n                               \");\n        if ($nb_resa >= $max_nb_resa){\n            die(\"[ADMISSION RULE] Error : you cannot have more than $max_nb_resa waiting reservations.\\n\");\n        }\n    }\n}\n'),(11,'\nmy $max_walltime = OAR::IO::sql_to_duration(\"12:00:00\");\nif (($jobType eq \"INTERACTIVE\") and ($reservationField eq \"None\")){ \n    foreach my $mold (@{$ref_resource_list}){\n        if ((defined($mold->[1])) and ($max_walltime < $mold->[1])){\n            print(\"[ADMISSION RULE] Walltime to big for an INTERACTIVE job so it is set to $max_walltime.\\n\");\n            $mold->[1] = $max_walltime;\n        }\n    }\n}\n'),(12,'\nmy $default_wall = OAR::IO::sql_to_duration(\"2:00:00\");\nforeach my $mold (@{$ref_resource_list}){\n    if (!defined($mold->[1])){\n        print(\"[ADMISSION RULE] Set default walltime to $default_wall.\\n\");\n        $mold->[1] = $default_wall;\n    }\n}\n'),(13,'\nmy @types = (\"container\",\"inner\",\"deploy\",\"desktop_computing\",\"besteffort\",\"cosystem\",\"idempotent\",\"timesharing\",\"allow_classic_ssh\");\nforeach my $t (@{$type_list}){\n    my $i = 0;\n    while (($types[$i] ne $t) and ($i <= $#types)){\n        $i++;\n    }\n    if (($i > $#types) and ($t !~ /^(timesharing|inner)/)){\n        die(\"[ADMISSION RULE] The job type $t is not handled by OAR; Right values are : @types\\n\");\n    }\n}\n'),(14,'\nforeach my $mold (@{$ref_resource_list}){\n    foreach my $r (@{$mold->[0]}){\n        my $prop = $r->{property};\n        if (($prop !~ /[\\s\\(]type[\\s=]/) and ($prop !~ /^type[\\s=]/)){\n            if (!defined($prop)){\n                $r->{property} = \"type = \\\'default\\\'\";\n            }else{\n                $r->{property} = \"($r->{property}) AND type = \\\'default\\\'\";\n            }\n        }\n    }\n}\nprint(\"[ADMISSION RULE] Modify resource description with type constraints\\n\");\n');
/*!40000 ALTER TABLE `admission_rules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `assigned_resources`
--

DROP TABLE IF EXISTS `assigned_resources`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `assigned_resources` (
  `moldable_job_id` int(10) unsigned NOT NULL,
  `resource_id` int(10) unsigned NOT NULL,
  `assigned_resource_index` enum('CURRENT','LOG') NOT NULL default 'CURRENT',
  PRIMARY KEY  (`moldable_job_id`,`resource_id`),
  KEY `mjob_id` (`moldable_job_id`),
  KEY `log` (`assigned_resource_index`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `assigned_resources`
--

LOCK TABLES `assigned_resources` WRITE;
/*!40000 ALTER TABLE `assigned_resources` DISABLE KEYS */;
INSERT INTO `assigned_resources` VALUES (1,1,'CURRENT'),(1,2,'CURRENT'),(1,3,'CURRENT'),(1,4,'CURRENT'),(1,5,'CURRENT'),(1,6,'CURRENT'),(1,7,'CURRENT'),(1,8,'CURRENT'),(1,9,'CURRENT'),(1,10,'CURRENT'),(1,11,'CURRENT'),(1,12,'CURRENT'),(1,13,'CURRENT'),(1,14,'CURRENT'),(1,15,'CURRENT'),(1,16,'CURRENT'),(1,17,'CURRENT'),(1,18,'CURRENT'),(1,19,'CURRENT'),(1,20,'CURRENT'),(1,21,'CURRENT'),(1,22,'CURRENT'),(1,23,'CURRENT'),(1,24,'CURRENT'),(1,25,'CURRENT'),(1,26,'CURRENT'),(1,27,'CURRENT'),(1,28,'CURRENT'),(1,29,'CURRENT'),(1,30,'CURRENT'),(1,31,'CURRENT'),(1,32,'CURRENT'),(1,33,'CURRENT'),(1,34,'CURRENT'),(1,35,'CURRENT'),(1,36,'CURRENT'),(1,37,'CURRENT'),(1,38,'CURRENT'),(1,39,'CURRENT'),(1,40,'CURRENT'),(1,41,'CURRENT'),(1,42,'CURRENT'),(1,43,'CURRENT'),(1,44,'CURRENT'),(1,45,'CURRENT'),(1,46,'CURRENT'),(1,47,'CURRENT'),(1,48,'CURRENT'),(1,49,'CURRENT'),(1,50,'CURRENT'),(1,51,'CURRENT'),(1,52,'CURRENT'),(1,53,'CURRENT'),(1,54,'CURRENT'),(1,55,'CURRENT'),(1,56,'CURRENT'),(1,57,'CURRENT'),(1,58,'CURRENT'),(1,59,'CURRENT'),(1,60,'CURRENT'),(1,61,'CURRENT'),(1,62,'CURRENT'),(1,63,'CURRENT'),(1,64,'CURRENT'),(1,65,'CURRENT'),(1,66,'CURRENT'),(1,67,'CURRENT'),(1,68,'CURRENT'),(1,69,'CURRENT'),(1,70,'CURRENT'),(1,71,'CURRENT'),(1,72,'CURRENT'),(1,73,'CURRENT'),(1,74,'CURRENT'),(1,75,'CURRENT'),(1,76,'CURRENT'),(1,77,'CURRENT'),(1,78,'CURRENT'),(1,79,'CURRENT'),(1,80,'CURRENT'),(1,81,'CURRENT'),(1,82,'CURRENT'),(1,83,'CURRENT'),(1,84,'CURRENT'),(1,85,'CURRENT'),(1,86,'CURRENT'),(1,87,'CURRENT'),(1,88,'CURRENT'),(1,89,'CURRENT'),(1,90,'CURRENT'),(1,91,'CURRENT'),(1,92,'CURRENT'),(1,93,'CURRENT'),(1,94,'CURRENT'),(1,95,'CURRENT'),(1,96,'CURRENT'),(1,97,'CURRENT'),(1,98,'CURRENT'),(1,99,'CURRENT'),(1,100,'CURRENT'),(1,101,'CURRENT'),(1,102,'CURRENT'),(1,103,'CURRENT'),(1,104,'CURRENT'),(1,105,'CURRENT'),(1,106,'CURRENT'),(1,107,'CURRENT'),(1,108,'CURRENT'),(1,109,'CURRENT'),(1,110,'CURRENT'),(1,111,'CURRENT'),(1,112,'CURRENT'),(1,113,'CURRENT'),(1,114,'CURRENT'),(1,115,'CURRENT'),(1,116,'CURRENT'),(1,117,'CURRENT'),(1,118,'CURRENT'),(1,119,'CURRENT'),(1,120,'CURRENT'),(1,121,'CURRENT'),(1,122,'CURRENT'),(1,123,'CURRENT'),(1,124,'CURRENT'),(1,125,'CURRENT'),(1,126,'CURRENT'),(1,127,'CURRENT'),(1,128,'CURRENT'),(1,129,'CURRENT'),(1,130,'CURRENT'),(1,131,'CURRENT'),(1,132,'CURRENT'),(1,133,'CURRENT'),(1,134,'CURRENT'),(1,135,'CURRENT'),(1,136,'CURRENT'),(1,137,'CURRENT'),(1,138,'CURRENT'),(1,139,'CURRENT'),(1,140,'CURRENT'),(1,141,'CURRENT'),(1,142,'CURRENT'),(1,143,'CURRENT'),(1,144,'CURRENT'),(1,145,'CURRENT'),(1,146,'CURRENT'),(1,147,'CURRENT'),(1,148,'CURRENT'),(1,149,'CURRENT'),(1,150,'CURRENT'),(1,151,'CURRENT'),(1,152,'CURRENT'),(1,153,'CURRENT'),(1,154,'CURRENT'),(1,155,'CURRENT'),(1,156,'CURRENT'),(1,157,'CURRENT'),(1,158,'CURRENT'),(1,159,'CURRENT'),(1,160,'CURRENT'),(1,161,'CURRENT'),(1,162,'CURRENT'),(1,163,'CURRENT'),(1,164,'CURRENT'),(1,165,'CURRENT'),(1,166,'CURRENT'),(1,167,'CURRENT'),(1,168,'CURRENT'),(1,169,'CURRENT'),(1,170,'CURRENT'),(1,171,'CURRENT'),(1,172,'CURRENT'),(1,173,'CURRENT'),(1,174,'CURRENT'),(1,175,'CURRENT'),(1,176,'CURRENT'),(1,177,'CURRENT'),(1,178,'CURRENT'),(1,179,'CURRENT'),(1,180,'CURRENT'),(1,181,'CURRENT'),(1,182,'CURRENT'),(1,183,'CURRENT'),(1,184,'CURRENT'),(1,185,'CURRENT'),(1,186,'CURRENT'),(1,187,'CURRENT'),(1,188,'CURRENT'),(1,189,'CURRENT'),(1,190,'CURRENT'),(1,191,'CURRENT'),(1,192,'CURRENT'),(1,193,'CURRENT'),(1,194,'CURRENT'),(1,195,'CURRENT'),(1,196,'CURRENT'),(1,197,'CURRENT'),(1,198,'CURRENT'),(1,199,'CURRENT'),(1,200,'CURRENT'),(1,201,'CURRENT'),(1,202,'CURRENT'),(1,203,'CURRENT'),(1,204,'CURRENT'),(1,205,'CURRENT'),(1,206,'CURRENT'),(1,207,'CURRENT'),(1,208,'CURRENT'),(1,209,'CURRENT'),(1,210,'CURRENT'),(1,211,'CURRENT'),(1,212,'CURRENT'),(1,213,'CURRENT'),(1,214,'CURRENT'),(1,215,'CURRENT'),(1,216,'CURRENT'),(1,217,'CURRENT'),(1,218,'CURRENT'),(1,219,'CURRENT'),(1,220,'CURRENT'),(1,221,'CURRENT'),(1,222,'CURRENT'),(1,223,'CURRENT'),(1,224,'CURRENT'),(1,225,'CURRENT'),(1,226,'CURRENT'),(1,227,'CURRENT'),(1,228,'CURRENT'),(1,229,'CURRENT'),(1,230,'CURRENT'),(1,231,'CURRENT'),(1,232,'CURRENT'),(1,233,'CURRENT'),(1,234,'CURRENT'),(1,235,'CURRENT'),(1,236,'CURRENT'),(1,237,'CURRENT'),(1,238,'CURRENT'),(1,239,'CURRENT'),(1,240,'CURRENT'),(1,241,'CURRENT'),(1,242,'CURRENT'),(1,243,'CURRENT'),(1,244,'CURRENT'),(1,245,'CURRENT'),(1,246,'CURRENT'),(1,247,'CURRENT'),(1,248,'CURRENT'),(1,249,'CURRENT'),(1,250,'CURRENT'),(1,251,'CURRENT'),(1,252,'CURRENT'),(1,253,'CURRENT'),(1,254,'CURRENT'),(1,255,'CURRENT'),(1,256,'CURRENT'),(1,257,'CURRENT'),(1,258,'CURRENT'),(1,259,'CURRENT'),(1,260,'CURRENT'),(1,261,'CURRENT'),(1,262,'CURRENT'),(1,263,'CURRENT'),(1,264,'CURRENT'),(1,265,'CURRENT'),(1,266,'CURRENT'),(1,267,'CURRENT'),(1,268,'CURRENT'),(1,269,'CURRENT'),(1,270,'CURRENT'),(1,271,'CURRENT'),(1,272,'CURRENT'),(1,273,'CURRENT'),(1,274,'CURRENT'),(1,275,'CURRENT'),(1,276,'CURRENT'),(1,277,'CURRENT'),(1,278,'CURRENT'),(1,279,'CURRENT'),(1,280,'CURRENT'),(1,281,'CURRENT'),(1,282,'CURRENT'),(1,283,'CURRENT'),(1,284,'CURRENT'),(1,285,'CURRENT'),(1,286,'CURRENT'),(1,287,'CURRENT'),(1,288,'CURRENT'),(1,289,'CURRENT'),(1,290,'CURRENT'),(1,291,'CURRENT'),(1,292,'CURRENT'),(1,293,'CURRENT'),(1,294,'CURRENT'),(1,295,'CURRENT'),(1,296,'CURRENT'),(1,297,'CURRENT'),(1,298,'CURRENT'),(1,299,'CURRENT'),(1,300,'CURRENT'),(1,301,'CURRENT'),(1,302,'CURRENT'),(1,303,'CURRENT'),(1,304,'CURRENT'),(1,305,'CURRENT'),(1,306,'CURRENT'),(1,307,'CURRENT'),(1,308,'CURRENT'),(1,309,'CURRENT'),(1,310,'CURRENT'),(1,311,'CURRENT'),(1,312,'CURRENT'),(1,313,'CURRENT'),(1,314,'CURRENT'),(1,315,'CURRENT'),(1,316,'CURRENT'),(1,317,'CURRENT'),(1,318,'CURRENT'),(1,319,'CURRENT'),(1,320,'CURRENT'),(1,321,'CURRENT'),(1,322,'CURRENT'),(1,323,'CURRENT'),(1,324,'CURRENT'),(1,325,'CURRENT'),(1,326,'CURRENT'),(1,327,'CURRENT'),(1,328,'CURRENT'),(1,329,'CURRENT'),(1,330,'CURRENT'),(1,331,'CURRENT'),(1,332,'CURRENT'),(1,333,'CURRENT'),(1,334,'CURRENT'),(1,335,'CURRENT'),(1,336,'CURRENT'),(1,337,'CURRENT'),(1,338,'CURRENT'),(1,339,'CURRENT'),(1,340,'CURRENT'),(1,341,'CURRENT'),(1,342,'CURRENT'),(1,343,'CURRENT'),(1,344,'CURRENT'),(1,345,'CURRENT'),(1,346,'CURRENT'),(1,347,'CURRENT'),(1,348,'CURRENT'),(1,349,'CURRENT'),(1,350,'CURRENT'),(1,351,'CURRENT'),(1,352,'CURRENT'),(1,353,'CURRENT'),(1,354,'CURRENT'),(1,355,'CURRENT'),(1,356,'CURRENT'),(1,357,'CURRENT'),(1,358,'CURRENT'),(1,359,'CURRENT'),(1,360,'CURRENT'),(1,361,'CURRENT'),(1,362,'CURRENT'),(1,363,'CURRENT'),(1,364,'CURRENT'),(1,365,'CURRENT'),(1,366,'CURRENT'),(1,367,'CURRENT'),(1,368,'CURRENT'),(1,369,'CURRENT'),(1,370,'CURRENT'),(1,371,'CURRENT'),(1,372,'CURRENT'),(1,373,'CURRENT'),(1,374,'CURRENT'),(1,375,'CURRENT'),(1,376,'CURRENT'),(1,377,'CURRENT'),(1,378,'CURRENT'),(1,379,'CURRENT'),(1,380,'CURRENT'),(1,381,'CURRENT'),(1,382,'CURRENT'),(1,383,'CURRENT'),(1,384,'CURRENT');
/*!40000 ALTER TABLE `assigned_resources` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `challenges`
--

DROP TABLE IF EXISTS `challenges`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `challenges` (
  `job_id` int(10) unsigned NOT NULL,
  `challenge` varchar(255) NOT NULL,
  `ssh_private_key` text NOT NULL,
  `ssh_public_key` text NOT NULL,
  PRIMARY KEY  (`job_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `challenges`
--

LOCK TABLES `challenges` WRITE;
/*!40000 ALTER TABLE `challenges` DISABLE KEYS */;
INSERT INTO `challenges` VALUES (1,'985377625403','',''),(2,'667427831868','',''),(3,'328575936452','',''),(4,'526436358531','',''),(5,'339450127053','',''),(6,'352902324711','',''),(7,'439787935539','',''),(8,'433177980900','',''),(9,'412158820386','',''),(10,'889567426013','',''),(11,'123787477918','',''),(12,'437301955259','',''),(13,'687474423394','',''),(14,'746288048177','',''),(15,'14582702730','',''),(16,'997663565985','',''),(17,'674879145649','',''),(18,'690024722441','',''),(19,'16737794344','',''),(20,'321956478365','',''),(21,'198102593728','',''),(22,'567295823087','',''),(23,'347901824469','',''),(24,'358981637823','',''),(25,'963363095260','',''),(26,'312087497049','',''),(27,'529815651084','',''),(28,'741712139294','',''),(29,'722662389119','',''),(30,'456581414983','',''),(31,'564700135802','',''),(32,'930923546039','',''),(33,'618351217432','',''),(34,'253933886838','',''),(35,'919951469012','',''),(36,'631391253628','',''),(37,'479817063155','',''),(38,'113409831727','',''),(39,'460256586390','',''),(40,'888637919751','',''),(41,'612698466823','',''),(42,'244960600118','',''),(43,'986237258258','',''),(44,'764762977211','',''),(45,'522188644464','',''),(46,'557689930153','',''),(47,'482398586654','',''),(48,'426850456119','',''),(49,'445779774178','',''),(50,'382228959891','',''),(51,'306016431962','',''),(52,'496333322328','',''),(53,'936094115561','',''),(54,'950104920267','',''),(55,'210750320534','',''),(56,'760070355682','',''),(57,'34628360140','',''),(58,'45393074936','',''),(59,'778923778169','',''),(60,'416225297915','',''),(61,'540753317139','',''),(62,'822269853045','',''),(63,'794077736864','',''),(64,'199294504317','',''),(65,'383396045145','',''),(66,'919667708761','',''),(67,'387379707609','',''),(68,'666955499284','',''),(69,'429983211987','',''),(70,'266966335083','',''),(71,'67774423238','',''),(72,'379797035436','',''),(73,'632539517319','',''),(74,'718921154345','',''),(75,'281791602102','',''),(76,'760220841345','',''),(77,'634989993487','',''),(78,'727849559000','',''),(79,'952572563271','',''),(80,'144459665128','',''),(81,'526982657917','',''),(82,'504834232227','',''),(83,'332923251510','',''),(84,'943013631579','',''),(85,'930543974814','',''),(86,'625359243786','',''),(87,'3119980291','',''),(88,'276668661347','',''),(89,'323375521301','',''),(90,'123581744804','',''),(91,'460708778890','',''),(92,'639891122774','',''),(93,'329620894118','',''),(94,'28464907388','',''),(95,'135332705526','',''),(96,'396811226922','',''),(97,'645932971806','',''),(98,'576291043152','',''),(99,'151294307624','',''),(100,'30598331782','',''),(101,'27490717898','','');
/*!40000 ALTER TABLE `challenges` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event_log_hostnames`
--

DROP TABLE IF EXISTS `event_log_hostnames`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `event_log_hostnames` (
  `event_id` int(10) unsigned NOT NULL,
  `hostname` varchar(255) NOT NULL,
  PRIMARY KEY  (`event_id`,`hostname`),
  KEY `event_hostname` (`hostname`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `event_log_hostnames`
--

LOCK TABLES `event_log_hostnames` WRITE;
/*!40000 ALTER TABLE `event_log_hostnames` DISABLE KEYS */;
/*!40000 ALTER TABLE `event_log_hostnames` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `event_logs`
--

DROP TABLE IF EXISTS `event_logs`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `event_logs` (
  `event_id` int(10) unsigned NOT NULL auto_increment,
  `type` varchar(50) NOT NULL,
  `job_id` int(10) unsigned NOT NULL,
  `date` int(10) unsigned NOT NULL,
  `description` varchar(255) NOT NULL,
  `to_check` enum('YES','NO') NOT NULL default 'YES',
  PRIMARY KEY  (`event_id`),
  KEY `event_type` (`type`),
  KEY `event_check` (`to_check`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `event_logs`
--

LOCK TABLES `event_logs` WRITE;
/*!40000 ALTER TABLE `event_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `event_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `files`
--

DROP TABLE IF EXISTS `files`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `files` (
  `file_id` int(10) unsigned NOT NULL auto_increment,
  `md5sum` varchar(255) default NULL,
  `location` varchar(255) default NULL,
  `method` varchar(255) default NULL,
  `compression` varchar(255) default NULL,
  `size` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`file_id`),
  KEY `md5sum` (`md5sum`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `files`
--

LOCK TABLES `files` WRITE;
/*!40000 ALTER TABLE `files` DISABLE KEYS */;
/*!40000 ALTER TABLE `files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `frag_jobs`
--

DROP TABLE IF EXISTS `frag_jobs`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `frag_jobs` (
  `frag_id_job` int(10) unsigned NOT NULL,
  `frag_date` int(10) unsigned NOT NULL,
  `frag_state` enum('LEON','TIMER_ARMED','LEON_EXTERMINATE','FRAGGED') NOT NULL default 'LEON',
  PRIMARY KEY  (`frag_id_job`),
  KEY `frag_state` (`frag_state`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `frag_jobs`
--

LOCK TABLES `frag_jobs` WRITE;
/*!40000 ALTER TABLE `frag_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `frag_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gantt_jobs_predictions`
--

DROP TABLE IF EXISTS `gantt_jobs_predictions`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `gantt_jobs_predictions` (
  `moldable_job_id` int(10) unsigned NOT NULL,
  `start_time` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`moldable_job_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `gantt_jobs_predictions`
--

LOCK TABLES `gantt_jobs_predictions` WRITE;
/*!40000 ALTER TABLE `gantt_jobs_predictions` DISABLE KEYS */;
INSERT INTO `gantt_jobs_predictions` VALUES (0,1224778714),(1,1224778628),(2,1224793089),(3,1224825550),(4,1224843611),(5,1224879672),(6,1224901333),(7,1224908594),(8,1224937455),(9,1224793089),(10,1224948316),(11,1224793089),(12,1224966377),(13,1224793089),(14,1224988038),(15,1224793089),(16,1225016899),(17,1224800350);
/*!40000 ALTER TABLE `gantt_jobs_predictions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gantt_jobs_predictions_log`
--

DROP TABLE IF EXISTS `gantt_jobs_predictions_log`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `gantt_jobs_predictions_log` (
  `sched_date` int(10) unsigned NOT NULL,
  `moldable_job_id` int(10) unsigned NOT NULL,
  `start_time` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`sched_date`,`moldable_job_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `gantt_jobs_predictions_log`
--

LOCK TABLES `gantt_jobs_predictions_log` WRITE;
/*!40000 ALTER TABLE `gantt_jobs_predictions_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `gantt_jobs_predictions_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gantt_jobs_predictions_visu`
--

DROP TABLE IF EXISTS `gantt_jobs_predictions_visu`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `gantt_jobs_predictions_visu` (
  `moldable_job_id` int(10) unsigned NOT NULL,
  `start_time` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`moldable_job_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `gantt_jobs_predictions_visu`
--

LOCK TABLES `gantt_jobs_predictions_visu` WRITE;
/*!40000 ALTER TABLE `gantt_jobs_predictions_visu` DISABLE KEYS */;
INSERT INTO `gantt_jobs_predictions_visu` VALUES (0,1224778679),(1,1224778628),(2,1224793089),(3,1224825550),(4,1224843611),(5,1224879672),(6,1224901333),(7,1224908594),(8,1224937455),(9,1224793089),(10,1224948316),(11,1224793089),(12,1224966377),(13,1224793089),(14,1224988038),(15,1224793089),(16,1225016899),(17,1224800350),(18,1225049360),(19,1224843611);
/*!40000 ALTER TABLE `gantt_jobs_predictions_visu` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gantt_jobs_resources`
--

DROP TABLE IF EXISTS `gantt_jobs_resources`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `gantt_jobs_resources` (
  `moldable_job_id` int(10) unsigned NOT NULL,
  `resource_id` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`moldable_job_id`,`resource_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `gantt_jobs_resources`
--

LOCK TABLES `gantt_jobs_resources` WRITE;
/*!40000 ALTER TABLE `gantt_jobs_resources` DISABLE KEYS */;
INSERT INTO `gantt_jobs_resources` VALUES (1,1),(1,2),(1,3),(1,4),(1,5),(1,6),(1,7),(1,8),(1,9),(1,10),(1,11),(1,12),(1,13),(1,14),(1,15),(1,16),(1,17),(1,18),(1,19),(1,20),(1,21),(1,22),(1,23),(1,24),(1,25),(1,26),(1,27),(1,28),(1,29),(1,30),(1,31),(1,32),(1,33),(1,34),(1,35),(1,36),(1,37),(1,38),(1,39),(1,40),(1,41),(1,42),(1,43),(1,44),(1,45),(1,46),(1,47),(1,48),(1,49),(1,50),(1,51),(1,52),(1,53),(1,54),(1,55),(1,56),(1,57),(1,58),(1,59),(1,60),(1,61),(1,62),(1,63),(1,64),(1,65),(1,66),(1,67),(1,68),(1,69),(1,70),(1,71),(1,72),(1,73),(1,74),(1,75),(1,76),(1,77),(1,78),(1,79),(1,80),(1,81),(1,82),(1,83),(1,84),(1,85),(1,86),(1,87),(1,88),(1,89),(1,90),(1,91),(1,92),(1,93),(1,94),(1,95),(1,96),(1,97),(1,98),(1,99),(1,100),(1,101),(1,102),(1,103),(1,104),(1,105),(1,106),(1,107),(1,108),(1,109),(1,110),(1,111),(1,112),(1,113),(1,114),(1,115),(1,116),(1,117),(1,118),(1,119),(1,120),(1,121),(1,122),(1,123),(1,124),(1,125),(1,126),(1,127),(1,128),(1,129),(1,130),(1,131),(1,132),(1,133),(1,134),(1,135),(1,136),(1,137),(1,138),(1,139),(1,140),(1,141),(1,142),(1,143),(1,144),(1,145),(1,146),(1,147),(1,148),(1,149),(1,150),(1,151),(1,152),(1,153),(1,154),(1,155),(1,156),(1,157),(1,158),(1,159),(1,160),(1,161),(1,162),(1,163),(1,164),(1,165),(1,166),(1,167),(1,168),(1,169),(1,170),(1,171),(1,172),(1,173),(1,174),(1,175),(1,176),(1,177),(1,178),(1,179),(1,180),(1,181),(1,182),(1,183),(1,184),(1,185),(1,186),(1,187),(1,188),(1,189),(1,190),(1,191),(1,192),(1,193),(1,194),(1,195),(1,196),(1,197),(1,198),(1,199),(1,200),(1,201),(1,202),(1,203),(1,204),(1,205),(1,206),(1,207),(1,208),(1,209),(1,210),(1,211),(1,212),(1,213),(1,214),(1,215),(1,216),(1,217),(1,218),(1,219),(1,220),(1,221),(1,222),(1,223),(1,224),(1,225),(1,226),(1,227),(1,228),(1,229),(1,230),(1,231),(1,232),(1,233),(1,234),(1,235),(1,236),(1,237),(1,238),(1,239),(1,240),(1,241),(1,242),(1,243),(1,244),(1,245),(1,246),(1,247),(1,248),(1,249),(1,250),(1,251),(1,252),(1,253),(1,254),(1,255),(1,256),(1,257),(1,258),(1,259),(1,260),(1,261),(1,262),(1,263),(1,264),(1,265),(1,266),(1,267),(1,268),(1,269),(1,270),(1,271),(1,272),(1,273),(1,274),(1,275),(1,276),(1,277),(1,278),(1,279),(1,280),(1,281),(1,282),(1,283),(1,284),(1,285),(1,286),(1,287),(1,288),(1,289),(1,290),(1,291),(1,292),(1,293),(1,294),(1,295),(1,296),(1,297),(1,298),(1,299),(1,300),(1,301),(1,302),(1,303),(1,304),(1,305),(1,306),(1,307),(1,308),(1,309),(1,310),(1,311),(1,312),(1,313),(1,314),(1,315),(1,316),(1,317),(1,318),(1,319),(1,320),(1,321),(1,322),(1,323),(1,324),(1,325),(1,326),(1,327),(1,328),(1,329),(1,330),(1,331),(1,332),(1,333),(1,334),(1,335),(1,336),(1,337),(1,338),(1,339),(1,340),(1,341),(1,342),(1,343),(1,344),(1,345),(1,346),(1,347),(1,348),(1,349),(1,350),(1,351),(1,352),(1,353),(1,354),(1,355),(1,356),(1,357),(1,358),(1,359),(1,360),(1,361),(1,362),(1,363),(1,364),(1,365),(1,366),(1,367),(1,368),(1,369),(1,370),(1,371),(1,372),(1,373),(1,374),(1,375),(1,376),(1,377),(1,378),(1,379),(1,380),(1,381),(1,382),(1,383),(1,384),(2,21),(2,22),(2,23),(2,24),(2,25),(2,26),(2,27),(2,28),(2,29),(2,30),(2,31),(2,32),(2,33),(2,34),(2,35),(2,36),(2,209),(2,210),(2,211),(2,212),(2,213),(2,214),(2,215),(2,216),(2,217),(2,218),(2,219),(2,220),(2,221),(2,222),(2,223),(2,224),(2,225),(2,226),(2,227),(2,228),(2,229),(2,230),(2,231),(2,232),(2,233),(2,234),(2,235),(2,236),(2,237),(2,238),(2,239),(2,240),(2,241),(2,242),(2,243),(2,244),(2,245),(2,246),(2,247),(2,248),(2,249),(2,250),(2,251),(2,252),(2,253),(2,254),(2,255),(2,256),(2,257),(2,258),(2,259),(2,260),(2,261),(2,262),(2,263),(2,264),(2,265),(2,266),(2,267),(2,268),(2,269),(2,270),(2,271),(2,272),(2,273),(2,274),(2,275),(2,276),(2,277),(2,278),(2,279),(2,280),(2,281),(2,282),(2,283),(2,284),(2,285),(2,286),(2,287),(2,288),(2,289),(2,290),(2,291),(2,292),(2,293),(2,294),(2,295),(2,296),(2,297),(2,298),(2,299),(2,300),(2,301),(2,302),(2,303),(2,304),(2,305),(2,306),(2,307),(2,308),(2,309),(2,310),(2,311),(2,312),(2,313),(2,314),(2,315),(2,316),(2,317),(2,318),(2,319),(2,320),(2,321),(2,322),(2,323),(2,324),(2,325),(2,326),(2,327),(2,328),(2,329),(2,330),(2,331),(2,332),(2,333),(2,334),(2,335),(2,336),(2,337),(2,338),(2,339),(2,340),(2,341),(2,342),(2,343),(2,344),(2,345),(2,346),(2,347),(2,348),(2,349),(2,350),(2,351),(2,352),(2,353),(2,354),(2,355),(2,356),(2,357),(2,358),(2,359),(2,360),(2,361),(2,362),(2,363),(2,364),(2,365),(2,366),(2,367),(2,368),(2,369),(2,370),(2,371),(2,372),(2,373),(2,374),(2,375),(2,376),(2,377),(2,378),(2,379),(2,380),(2,381),(2,382),(2,383),(2,384),(3,9),(3,10),(3,11),(3,12),(3,13),(3,14),(3,15),(3,16),(3,17),(3,18),(3,19),(3,20),(3,21),(3,22),(3,23),(3,24),(3,25),(3,26),(3,27),(3,28),(3,29),(3,30),(3,31),(3,32),(3,33),(3,34),(3,35),(3,36),(3,81),(3,82),(3,83),(3,84),(3,85),(3,86),(3,87),(3,88),(3,89),(3,90),(3,91),(3,92),(3,93),(3,94),(3,95),(3,96),(3,97),(3,98),(3,99),(3,100),(3,101),(3,102),(3,103),(3,104),(3,105),(3,106),(3,107),(3,108),(3,109),(3,110),(3,111),(3,112),(3,113),(3,114),(3,115),(3,116),(3,117),(3,118),(3,119),(3,120),(3,121),(3,122),(3,123),(3,124),(3,125),(3,126),(3,127),(3,128),(3,129),(3,130),(3,131),(3,132),(3,133),(3,134),(3,135),(3,136),(3,137),(3,138),(3,139),(3,140),(3,141),(3,142),(3,143),(3,144),(3,145),(3,146),(3,147),(3,148),(3,149),(3,150),(3,151),(3,152),(3,153),(3,154),(3,155),(3,156),(3,157),(3,158),(3,159),(3,160),(3,161),(3,162),(3,163),(3,164),(3,165),(3,166),(3,167),(3,168),(3,169),(3,170),(3,171),(3,172),(3,173),(3,174),(3,175),(3,176),(3,177),(3,178),(3,179),(3,180),(3,181),(3,182),(3,183),(3,184),(3,185),(3,186),(3,187),(3,188),(3,189),(3,190),(3,191),(3,192),(3,193),(3,194),(3,195),(3,196),(3,197),(3,198),(3,199),(3,200),(3,201),(3,202),(3,203),(3,204),(3,205),(3,206),(3,207),(3,208),(3,209),(3,210),(3,211),(3,212),(3,213),(3,214),(3,215),(3,216),(3,217),(3,218),(3,219),(3,220),(3,221),(3,222),(3,223),(3,224),(3,225),(3,226),(3,227),(3,228),(3,229),(3,230),(3,231),(3,232),(3,233),(3,234),(3,235),(3,236),(3,237),(3,238),(3,239),(3,240),(3,241),(3,242),(3,243),(3,244),(3,245),(3,246),(3,247),(3,248),(3,249),(3,250),(3,251),(3,252),(3,253),(3,254),(3,255),(3,256),(3,257),(3,258),(3,259),(3,260),(3,261),(3,262),(3,263),(3,264),(3,265),(3,266),(3,267),(3,268),(3,269),(3,270),(3,271),(3,272),(3,273),(3,274),(3,275),(3,276),(3,277),(3,278),(3,279),(3,280),(3,281),(3,282),(3,283),(3,284),(3,285),(3,286),(3,287),(3,288),(3,289),(3,290),(3,291),(3,292),(3,293),(3,294),(3,295),(3,296),(3,297),(3,298),(3,299),(3,300),(3,301),(3,302),(3,303),(3,304),(3,305),(3,306),(3,307),(3,308),(3,309),(3,310),(3,311),(3,312),(3,313),(3,314),(3,315),(3,316),(3,317),(3,318),(3,319),(3,320),(3,321),(3,322),(3,323),(3,324),(3,325),(3,326),(3,327),(3,328),(3,329),(3,330),(3,331),(3,332),(3,333),(3,334),(3,335),(3,336),(3,337),(3,338),(3,339),(3,340),(3,341),(3,342),(3,343),(3,344),(3,345),(3,346),(3,347),(3,348),(3,349),(3,350),(3,351),(3,352),(3,353),(3,354),(3,355),(3,356),(3,357),(3,358),(3,359),(3,360),(3,361),(3,362),(3,363),(3,364),(3,365),(3,366),(3,367),(3,368),(3,369),(3,370),(3,371),(3,372),(3,373),(3,374),(3,375),(3,376),(3,377),(3,378),(3,379),(3,380),(3,381),(3,382),(3,383),(3,384),(4,17),(4,18),(4,19),(4,20),(4,21),(4,22),(4,23),(4,24),(4,25),(4,26),(4,27),(4,28),(4,29),(4,30),(4,31),(4,32),(4,33),(4,34),(4,35),(4,36),(4,189),(4,190),(4,191),(4,192),(4,193),(4,194),(4,195),(4,196),(4,197),(4,198),(4,199),(4,200),(4,201),(4,202),(4,203),(4,204),(4,205),(4,206),(4,207),(4,208),(4,209),(4,210),(4,211),(4,212),(4,213),(4,214),(4,215),(4,216),(4,217),(4,218),(4,219),(4,220),(4,221),(4,222),(4,223),(4,224),(4,225),(4,226),(4,227),(4,228),(4,229),(4,230),(4,231),(4,232),(4,233),(4,234),(4,235),(4,236),(4,237),(4,238),(4,239),(4,240),(4,241),(4,242),(4,243),(4,244),(4,245),(4,246),(4,247),(4,248),(4,249),(4,250),(4,251),(4,252),(4,253),(4,254),(4,255),(4,256),(4,257),(4,258),(4,259),(4,260),(4,261),(4,262),(4,263),(4,264),(4,265),(4,266),(4,267),(4,268),(4,269),(4,270),(4,271),(4,272),(4,273),(4,274),(4,275),(4,276),(4,277),(4,278),(4,279),(4,280),(4,281),(4,282),(4,283),(4,284),(4,285),(4,286),(4,287),(4,288),(4,289),(4,290),(4,291),(4,292),(4,293),(4,294),(4,295),(4,296),(4,297),(4,298),(4,299),(4,300),(4,301),(4,302),(4,303),(4,304),(4,305),(4,306),(4,307),(4,308),(4,309),(4,310),(4,311),(4,312),(4,313),(4,314),(4,315),(4,316),(4,317),(4,318),(4,319),(4,320),(4,321),(4,322),(4,323),(4,324),(4,325),(4,326),(4,327),(4,328),(4,329),(4,330),(4,331),(4,332),(4,333),(4,334),(4,335),(4,336),(4,337),(4,338),(4,339),(4,340),(4,341),(4,342),(4,343),(4,344),(4,345),(4,346),(4,347),(4,348),(4,349),(4,350),(4,351),(4,352),(4,353),(4,354),(4,355),(4,356),(4,357),(4,358),(4,359),(4,360),(4,361),(4,362),(4,363),(4,364),(4,365),(4,366),(4,367),(4,368),(4,369),(4,370),(4,371),(4,372),(4,373),(4,374),(4,375),(4,376),(4,377),(4,378),(4,379),(4,380),(4,381),(4,382),(4,383),(4,384),(5,5),(5,6),(5,7),(5,8),(5,9),(5,10),(5,11),(5,12),(5,13),(5,14),(5,15),(5,16),(5,17),(5,18),(5,19),(5,20),(5,21),(5,22),(5,23),(5,24),(5,25),(5,26),(5,27),(5,28),(5,29),(5,30),(5,31),(5,32),(5,33),(5,34),(5,35),(5,36),(5,65),(5,66),(5,67),(5,68),(5,69),(5,70),(5,71),(5,72),(5,73),(5,74),(5,75),(5,76),(5,77),(5,78),(5,79),(5,80),(5,81),(5,82),(5,83),(5,84),(5,85),(5,86),(5,87),(5,88),(5,89),(5,90),(5,91),(5,92),(5,93),(5,94),(5,95),(5,96),(5,97),(5,98),(5,99),(5,100),(5,101),(5,102),(5,103),(5,104),(5,105),(5,106),(5,107),(5,108),(5,109),(5,110),(5,111),(5,112),(5,113),(5,114),(5,115),(5,116),(5,117),(5,118),(5,119),(5,120),(5,121),(5,122),(5,123),(5,124),(5,125),(5,126),(5,127),(5,128),(5,129),(5,130),(5,131),(5,132),(5,133),(5,134),(5,135),(5,136),(5,137),(5,138),(5,139),(5,140),(5,141),(5,142),(5,143),(5,144),(5,145),(5,146),(5,147),(5,148),(5,149),(5,150),(5,151),(5,152),(5,153),(5,154),(5,155),(5,156),(5,157),(5,158),(5,159),(5,160),(5,161),(5,162),(5,163),(5,164),(5,165),(5,166),(5,167),(5,168),(5,169),(5,170),(5,171),(5,172),(5,173),(5,174),(5,175),(5,176),(5,177),(5,178),(5,179),(5,180),(5,181),(5,182),(5,183),(5,184),(5,185),(5,186),(5,187),(5,188),(5,189),(5,190),(5,191),(5,192),(5,193),(5,194),(5,195),(5,196),(5,197),(5,198),(5,199),(5,200),(5,201),(5,202),(5,203),(5,204),(5,205),(5,206),(5,207),(5,208),(5,209),(5,210),(5,211),(5,212),(5,213),(5,214),(5,215),(5,216),(5,217),(5,218),(5,219),(5,220),(5,221),(5,222),(5,223),(5,224),(5,225),(5,226),(5,227),(5,228),(5,229),(5,230),(5,231),(5,232),(5,233),(5,234),(5,235),(5,236),(5,237),(5,238),(5,239),(5,240),(5,241),(5,242),(5,243),(5,244),(5,245),(5,246),(5,247),(5,248),(5,249),(5,250),(5,251),(5,252),(5,253),(5,254),(5,255),(5,256),(5,257),(5,258),(5,259),(5,260),(5,261),(5,262),(5,263),(5,264),(5,265),(5,266),(5,267),(5,268),(5,269),(5,270),(5,271),(5,272),(5,273),(5,274),(5,275),(5,276),(5,277),(5,278),(5,279),(5,280),(5,281),(5,282),(5,283),(5,284),(5,285),(5,286),(5,287),(5,288),(5,289),(5,290),(5,291),(5,292),(5,293),(5,294),(5,295),(5,296),(5,297),(5,298),(5,299),(5,300),(5,301),(5,302),(5,303),(5,304),(5,305),(5,306),(5,307),(5,308),(5,309),(5,310),(5,311),(5,312),(5,313),(5,314),(5,315),(5,316),(5,317),(5,318),(5,319),(5,320),(5,321),(5,322),(5,323),(5,324),(5,325),(5,326),(5,327),(5,328),(5,329),(5,330),(5,331),(5,332),(5,333),(5,334),(5,335),(5,336),(5,337),(5,338),(5,339),(5,340),(5,341),(5,342),(5,343),(5,344),(5,345),(5,346),(5,347),(5,348),(5,349),(5,350),(5,351),(5,352),(5,353),(5,354),(5,355),(5,356),(5,357),(5,358),(5,359),(5,360),(5,361),(5,362),(5,363),(5,364),(5,365),(5,366),(5,367),(5,368),(5,369),(5,370),(5,371),(5,372),(5,373),(5,374),(5,375),(5,376),(5,377),(5,378),(5,379),(5,380),(5,381),(5,382),(5,383),(5,384),(6,17),(6,18),(6,19),(6,20),(6,21),(6,22),(6,23),(6,24),(6,25),(6,26),(6,27),(6,28),(6,29),(6,30),(6,31),(6,32),(6,33),(6,34),(6,35),(6,36),(6,169),(6,170),(6,171),(6,172),(6,173),(6,174),(6,175),(6,176),(6,177),(6,178),(6,179),(6,180),(6,181),(6,182),(6,183),(6,184),(6,185),(6,186),(6,187),(6,188),(6,189),(6,190),(6,191),(6,192),(6,193),(6,194),(6,195),(6,196),(6,197),(6,198),(6,199),(6,200),(6,201),(6,202),(6,203),(6,204),(6,205),(6,206),(6,207),(6,208),(6,209),(6,210),(6,211),(6,212),(6,213),(6,214),(6,215),(6,216),(6,217),(6,218),(6,219),(6,220),(6,221),(6,222),(6,223),(6,224),(6,225),(6,226),(6,227),(6,228),(6,229),(6,230),(6,231),(6,232),(6,233),(6,234),(6,235),(6,236),(6,237),(6,238),(6,239),(6,240),(6,241),(6,242),(6,243),(6,244),(6,245),(6,246),(6,247),(6,248),(6,249),(6,250),(6,251),(6,252),(6,253),(6,254),(6,255),(6,256),(6,257),(6,258),(6,259),(6,260),(6,261),(6,262),(6,263),(6,264),(6,265),(6,266),(6,267),(6,268),(6,269),(6,270),(6,271),(6,272),(6,273),(6,274),(6,275),(6,276),(6,277),(6,278),(6,279),(6,280),(6,281),(6,282),(6,283),(6,284),(6,285),(6,286),(6,287),(6,288),(6,289),(6,290),(6,291),(6,292),(6,293),(6,294),(6,295),(6,296),(6,297),(6,298),(6,299),(6,300),(6,301),(6,302),(6,303),(6,304),(6,305),(6,306),(6,307),(6,308),(6,309),(6,310),(6,311),(6,312),(6,313),(6,314),(6,315),(6,316),(6,317),(6,318),(6,319),(6,320),(6,321),(6,322),(6,323),(6,324),(6,325),(6,326),(6,327),(6,328),(6,329),(6,330),(6,331),(6,332),(6,333),(6,334),(6,335),(6,336),(6,337),(6,338),(6,339),(6,340),(6,341),(6,342),(6,343),(6,344),(6,345),(6,346),(6,347),(6,348),(6,349),(6,350),(6,351),(6,352),(6,353),(6,354),(6,355),(6,356),(6,357),(6,358),(6,359),(6,360),(6,361),(6,362),(6,363),(6,364),(6,365),(6,366),(6,367),(6,368),(6,369),(6,370),(6,371),(6,372),(6,373),(6,374),(6,375),(6,376),(6,377),(6,378),(6,379),(6,380),(6,381),(6,382),(6,383),(6,384),(7,5),(7,6),(7,7),(7,8),(7,9),(7,10),(7,11),(7,12),(7,13),(7,14),(7,15),(7,16),(7,17),(7,18),(7,19),(7,20),(7,21),(7,22),(7,23),(7,24),(7,25),(7,26),(7,27),(7,28),(7,29),(7,30),(7,31),(7,32),(7,33),(7,34),(7,35),(7,36),(7,45),(7,46),(7,47),(7,48),(7,49),(7,50),(7,51),(7,52),(7,53),(7,54),(7,55),(7,56),(7,57),(7,58),(7,59),(7,60),(7,61),(7,62),(7,63),(7,64),(7,65),(7,66),(7,67),(7,68),(7,69),(7,70),(7,71),(7,72),(7,73),(7,74),(7,75),(7,76),(7,77),(7,78),(7,79),(7,80),(7,81),(7,82),(7,83),(7,84),(7,85),(7,86),(7,87),(7,88),(7,89),(7,90),(7,91),(7,92),(7,93),(7,94),(7,95),(7,96),(7,97),(7,98),(7,99),(7,100),(7,101),(7,102),(7,103),(7,104),(7,105),(7,106),(7,107),(7,108),(7,109),(7,110),(7,111),(7,112),(7,113),(7,114),(7,115),(7,116),(7,117),(7,118),(7,119),(7,120),(7,121),(7,122),(7,123),(7,124),(7,125),(7,126),(7,127),(7,128),(7,129),(7,130),(7,131),(7,132),(7,133),(7,134),(7,135),(7,136),(7,137),(7,138),(7,139),(7,140),(7,141),(7,142),(7,143),(7,144),(7,145),(7,146),(7,147),(7,148),(7,149),(7,150),(7,151),(7,152),(7,153),(7,154),(7,155),(7,156),(7,157),(7,158),(7,159),(7,160),(7,161),(7,162),(7,163),(7,164),(7,165),(7,166),(7,167),(7,168),(7,169),(7,170),(7,171),(7,172),(7,173),(7,174),(7,175),(7,176),(7,177),(7,178),(7,179),(7,180),(7,181),(7,182),(7,183),(7,184),(7,185),(7,186),(7,187),(7,188),(7,189),(7,190),(7,191),(7,192),(7,193),(7,194),(7,195),(7,196),(7,197),(7,198),(7,199),(7,200),(7,201),(7,202),(7,203),(7,204),(7,205),(7,206),(7,207),(7,208),(7,209),(7,210),(7,211),(7,212),(7,213),(7,214),(7,215),(7,216),(7,217),(7,218),(7,219),(7,220),(7,221),(7,222),(7,223),(7,224),(7,225),(7,226),(7,227),(7,228),(7,229),(7,230),(7,231),(7,232),(7,233),(7,234),(7,235),(7,236),(7,237),(7,238),(7,239),(7,240),(7,241),(7,242),(7,243),(7,244),(7,245),(7,246),(7,247),(7,248),(7,249),(7,250),(7,251),(7,252),(7,253),(7,254),(7,255),(7,256),(7,257),(7,258),(7,259),(7,260),(7,261),(7,262),(7,263),(7,264),(7,265),(7,266),(7,267),(7,268),(7,269),(7,270),(7,271),(7,272),(7,273),(7,274),(7,275),(7,276),(7,277),(7,278),(7,279),(7,280),(7,281),(7,282),(7,283),(7,284),(7,285),(7,286),(7,287),(7,288),(7,289),(7,290),(7,291),(7,292),(7,293),(7,294),(7,295),(7,296),(7,297),(7,298),(7,299),(7,300),(7,301),(7,302),(7,303),(7,304),(7,305),(7,306),(7,307),(7,308),(7,309),(7,310),(7,311),(7,312),(7,313),(7,314),(7,315),(7,316),(7,317),(7,318),(7,319),(7,320),(7,321),(7,322),(7,323),(7,324),(7,325),(7,326),(7,327),(7,328),(7,329),(7,330),(7,331),(7,332),(7,333),(7,334),(7,335),(7,336),(7,337),(7,338),(7,339),(7,340),(7,341),(7,342),(7,343),(7,344),(7,345),(7,346),(7,347),(7,348),(7,349),(7,350),(7,351),(7,352),(7,353),(7,354),(7,355),(7,356),(7,357),(7,358),(7,359),(7,360),(7,361),(7,362),(7,363),(7,364),(7,365),(7,366),(7,367),(7,368),(7,369),(7,370),(7,371),(7,372),(7,373),(7,374),(7,375),(7,376),(7,377),(7,378),(7,379),(7,380),(7,381),(7,382),(7,383),(7,384),(8,13),(8,14),(8,15),(8,16),(8,17),(8,18),(8,19),(8,20),(8,21),(8,22),(8,23),(8,24),(8,25),(8,26),(8,27),(8,28),(8,29),(8,30),(8,31),(8,32),(8,33),(8,34),(8,35),(8,36),(8,153),(8,154),(8,155),(8,156),(8,157),(8,158),(8,159),(8,160),(8,161),(8,162),(8,163),(8,164),(8,165),(8,166),(8,167),(8,168),(8,169),(8,170),(8,171),(8,172),(8,173),(8,174),(8,175),(8,176),(8,177),(8,178),(8,179),(8,180),(8,181),(8,182),(8,183),(8,184),(8,185),(8,186),(8,187),(8,188),(8,189),(8,190),(8,191),(8,192),(8,193),(8,194),(8,195),(8,196),(8,197),(8,198),(8,199),(8,200),(8,201),(8,202),(8,203),(8,204),(8,205),(8,206),(8,207),(8,208),(8,209),(8,210),(8,211),(8,212),(8,213),(8,214),(8,215),(8,216),(8,217),(8,218),(8,219),(8,220),(8,221),(8,222),(8,223),(8,224),(8,225),(8,226),(8,227),(8,228),(8,229),(8,230),(8,231),(8,232),(8,233),(8,234),(8,235),(8,236),(8,237),(8,238),(8,239),(8,240),(8,241),(8,242),(8,243),(8,244),(8,245),(8,246),(8,247),(8,248),(8,249),(8,250),(8,251),(8,252),(8,253),(8,254),(8,255),(8,256),(8,257),(8,258),(8,259),(8,260),(8,261),(8,262),(8,263),(8,264),(8,265),(8,266),(8,267),(8,268),(8,269),(8,270),(8,271),(8,272),(8,273),(8,274),(8,275),(8,276),(8,277),(8,278),(8,279),(8,280),(8,281),(8,282),(8,283),(8,284),(8,285),(8,286),(8,287),(8,288),(8,289),(8,290),(8,291),(8,292),(8,293),(8,294),(8,295),(8,296),(8,297),(8,298),(8,299),(8,300),(8,301),(8,302),(8,303),(8,304),(8,305),(8,306),(8,307),(8,308),(8,309),(8,310),(8,311),(8,312),(8,313),(8,314),(8,315),(8,316),(8,317),(8,318),(8,319),(8,320),(8,321),(8,322),(8,323),(8,324),(8,325),(8,326),(8,327),(8,328),(8,329),(8,330),(8,331),(8,332),(8,333),(8,334),(8,335),(8,336),(8,337),(8,338),(8,339),(8,340),(8,341),(8,342),(8,343),(8,344),(8,345),(8,346),(8,347),(8,348),(8,349),(8,350),(8,351),(8,352),(8,353),(8,354),(8,355),(8,356),(8,357),(8,358),(8,359),(8,360),(8,361),(8,362),(8,363),(8,364),(8,365),(8,366),(8,367),(8,368),(8,369),(8,370),(8,371),(8,372),(8,373),(8,374),(8,375),(8,376),(8,377),(8,378),(8,379),(8,380),(8,381),(8,382),(8,383),(8,384),(9,197),(9,198),(9,199),(9,200),(9,201),(9,202),(9,203),(9,204),(9,205),(9,206),(9,207),(9,208),(10,13),(10,14),(10,15),(10,16),(10,17),(10,18),(10,19),(10,20),(10,21),(10,22),(10,23),(10,24),(10,25),(10,26),(10,27),(10,28),(10,29),(10,30),(10,31),(10,32),(10,33),(10,34),(10,35),(10,36),(10,133),(10,134),(10,135),(10,136),(10,137),(10,138),(10,139),(10,140),(10,141),(10,142),(10,143),(10,144),(10,145),(10,146),(10,147),(10,148),(10,149),(10,150),(10,151),(10,152),(10,153),(10,154),(10,155),(10,156),(10,157),(10,158),(10,159),(10,160),(10,161),(10,162),(10,163),(10,164),(10,165),(10,166),(10,167),(10,168),(10,169),(10,170),(10,171),(10,172),(10,173),(10,174),(10,175),(10,176),(10,177),(10,178),(10,179),(10,180),(10,181),(10,182),(10,183),(10,184),(10,185),(10,186),(10,187),(10,188),(10,189),(10,190),(10,191),(10,192),(10,193),(10,194),(10,195),(10,196),(10,197),(10,198),(10,199),(10,200),(10,201),(10,202),(10,203),(10,204),(10,205),(10,206),(10,207),(10,208),(10,209),(10,210),(10,211),(10,212),(10,213),(10,214),(10,215),(10,216),(10,217),(10,218),(10,219),(10,220),(10,221),(10,222),(10,223),(10,224),(10,225),(10,226),(10,227),(10,228),(10,229),(10,230),(10,231),(10,232),(10,233),(10,234),(10,235),(10,236),(10,237),(10,238),(10,239),(10,240),(10,241),(10,242),(10,243),(10,244),(10,245),(10,246),(10,247),(10,248),(10,249),(10,250),(10,251),(10,252),(10,253),(10,254),(10,255),(10,256),(10,257),(10,258),(10,259),(10,260),(10,261),(10,262),(10,263),(10,264),(10,265),(10,266),(10,267),(10,268),(10,269),(10,270),(10,271),(10,272),(10,273),(10,274),(10,275),(10,276),(10,277),(10,278),(10,279),(10,280),(10,281),(10,282),(10,283),(10,284),(10,285),(10,286),(10,287),(10,288),(10,289),(10,290),(10,291),(10,292),(10,293),(10,294),(10,295),(10,296),(10,297),(10,298),(10,299),(10,300),(10,301),(10,302),(10,303),(10,304),(10,305),(10,306),(10,307),(10,308),(10,309),(10,310),(10,311),(10,312),(10,313),(10,314),(10,315),(10,316),(10,317),(10,318),(10,319),(10,320),(10,321),(10,322),(10,323),(10,324),(10,325),(10,326),(10,327),(10,328),(10,329),(10,330),(10,331),(10,332),(10,333),(10,334),(10,335),(10,336),(10,337),(10,338),(10,339),(10,340),(10,341),(10,342),(10,343),(10,344),(10,345),(10,346),(10,347),(10,348),(10,349),(10,350),(10,351),(10,352),(10,353),(10,354),(10,355),(10,356),(10,357),(10,358),(10,359),(10,360),(10,361),(10,362),(10,363),(10,364),(10,365),(10,366),(10,367),(10,368),(10,369),(10,370),(10,371),(10,372),(10,373),(10,374),(10,375),(10,376),(10,377),(10,378),(10,379),(10,380),(10,381),(10,382),(10,383),(10,384),(11,17),(11,18),(11,19),(11,20),(11,169),(11,170),(11,171),(11,172),(11,173),(11,174),(11,175),(11,176),(11,177),(11,178),(11,179),(11,180),(11,181),(11,182),(11,183),(11,184),(11,185),(11,186),(11,187),(11,188),(11,189),(11,190),(11,191),(11,192),(11,193),(11,194),(11,195),(11,196),(12,9),(12,10),(12,11),(12,12),(12,13),(12,14),(12,15),(12,16),(12,17),(12,18),(12,19),(12,20),(12,21),(12,22),(12,23),(12,24),(12,25),(12,26),(12,27),(12,28),(12,29),(12,30),(12,31),(12,32),(12,33),(12,34),(12,35),(12,36),(12,117),(12,118),(12,119),(12,120),(12,121),(12,122),(12,123),(12,124),(12,125),(12,126),(12,127),(12,128),(12,129),(12,130),(12,131),(12,132),(12,133),(12,134),(12,135),(12,136),(12,137),(12,138),(12,139),(12,140),(12,141),(12,142),(12,143),(12,144),(12,145),(12,146),(12,147),(12,148),(12,149),(12,150),(12,151),(12,152),(12,153),(12,154),(12,155),(12,156),(12,157),(12,158),(12,159),(12,160),(12,161),(12,162),(12,163),(12,164),(12,165),(12,166),(12,167),(12,168),(12,169),(12,170),(12,171),(12,172),(12,173),(12,174),(12,175),(12,176),(12,177),(12,178),(12,179),(12,180),(12,181),(12,182),(12,183),(12,184),(12,185),(12,186),(12,187),(12,188),(12,189),(12,190),(12,191),(12,192),(12,193),(12,194),(12,195),(12,196),(12,197),(12,198),(12,199),(12,200),(12,201),(12,202),(12,203),(12,204),(12,205),(12,206),(12,207),(12,208),(12,209),(12,210),(12,211),(12,212),(12,213),(12,214),(12,215),(12,216),(12,217),(12,218),(12,219),(12,220),(12,221),(12,222),(12,223),(12,224),(12,225),(12,226),(12,227),(12,228),(12,229),(12,230),(12,231),(12,232),(12,233),(12,234),(12,235),(12,236),(12,237),(12,238),(12,239),(12,240),(12,241),(12,242),(12,243),(12,244),(12,245),(12,246),(12,247),(12,248),(12,249),(12,250),(12,251),(12,252),(12,253),(12,254),(12,255),(12,256),(12,257),(12,258),(12,259),(12,260),(12,261),(12,262),(12,263),(12,264),(12,265),(12,266),(12,267),(12,268),(12,269),(12,270),(12,271),(12,272),(12,273),(12,274),(12,275),(12,276),(12,277),(12,278),(12,279),(12,280),(12,281),(12,282),(12,283),(12,284),(12,285),(12,286),(12,287),(12,288),(12,289),(12,290),(12,291),(12,292),(12,293),(12,294),(12,295),(12,296),(12,297),(12,298),(12,299),(12,300),(12,301),(12,302),(12,303),(12,304),(12,305),(12,306),(12,307),(12,308),(12,309),(12,310),(12,311),(12,312),(12,313),(12,314),(12,315),(12,316),(12,317),(12,318),(12,319),(12,320),(12,321),(12,322),(12,323),(12,324),(12,325),(12,326),(12,327),(12,328),(12,329),(12,330),(12,331),(12,332),(12,333),(12,334),(12,335),(12,336),(12,337),(12,338),(12,339),(12,340),(12,341),(12,342),(12,343),(12,344),(12,345),(12,346),(12,347),(12,348),(12,349),(12,350),(12,351),(12,352),(12,353),(12,354),(12,355),(12,356),(12,357),(12,358),(12,359),(12,360),(12,361),(12,362),(12,363),(12,364),(12,365),(12,366),(12,367),(12,368),(12,369),(12,370),(12,371),(12,372),(12,373),(12,374),(12,375),(12,376),(12,377),(12,378),(12,379),(12,380),(12,381),(12,382),(12,383),(12,384),(13,13),(13,14),(13,15),(13,16),(13,121),(13,122),(13,123),(13,124),(13,125),(13,126),(13,127),(13,128),(13,129),(13,130),(13,131),(13,132),(13,133),(13,134),(13,135),(13,136),(13,137),(13,138),(13,139),(13,140),(13,141),(13,142),(13,143),(13,144),(13,145),(13,146),(13,147),(13,148),(13,149),(13,150),(13,151),(13,152),(13,153),(13,154),(13,155),(13,156),(13,157),(13,158),(13,159),(13,160),(13,161),(13,162),(13,163),(13,164),(13,165),(13,166),(13,167),(13,168),(14,9),(14,10),(14,11),(14,12),(14,13),(14,14),(14,15),(14,16),(14,17),(14,18),(14,19),(14,20),(14,21),(14,22),(14,23),(14,24),(14,25),(14,26),(14,27),(14,28),(14,29),(14,30),(14,31),(14,32),(14,33),(14,34),(14,35),(14,36),(14,93),(14,94),(14,95),(14,96),(14,97),(14,98),(14,99),(14,100),(14,101),(14,102),(14,103),(14,104),(14,105),(14,106),(14,107),(14,108),(14,109),(14,110),(14,111),(14,112),(14,113),(14,114),(14,115),(14,116),(14,117),(14,118),(14,119),(14,120),(14,121),(14,122),(14,123),(14,124),(14,125),(14,126),(14,127),(14,128),(14,129),(14,130),(14,131),(14,132),(14,133),(14,134),(14,135),(14,136),(14,137),(14,138),(14,139),(14,140),(14,141),(14,142),(14,143),(14,144),(14,145),(14,146),(14,147),(14,148),(14,149),(14,150),(14,151),(14,152),(14,153),(14,154),(14,155),(14,156),(14,157),(14,158),(14,159),(14,160),(14,161),(14,162),(14,163),(14,164),(14,165),(14,166),(14,167),(14,168),(14,169),(14,170),(14,171),(14,172),(14,173),(14,174),(14,175),(14,176),(14,177),(14,178),(14,179),(14,180),(14,181),(14,182),(14,183),(14,184),(14,185),(14,186),(14,187),(14,188),(14,189),(14,190),(14,191),(14,192),(14,193),(14,194),(14,195),(14,196),(14,197),(14,198),(14,199),(14,200),(14,201),(14,202),(14,203),(14,204),(14,205),(14,206),(14,207),(14,208),(14,209),(14,210),(14,211),(14,212),(14,213),(14,214),(14,215),(14,216),(14,217),(14,218),(14,219),(14,220),(14,221),(14,222),(14,223),(14,224),(14,225),(14,226),(14,227),(14,228),(14,229),(14,230),(14,231),(14,232),(14,233),(14,234),(14,235),(14,236),(14,237),(14,238),(14,239),(14,240),(14,241),(14,242),(14,243),(14,244),(14,245),(14,246),(14,247),(14,248),(14,249),(14,250),(14,251),(14,252),(14,253),(14,254),(14,255),(14,256),(14,257),(14,258),(14,259),(14,260),(14,261),(14,262),(14,263),(14,264),(14,265),(14,266),(14,267),(14,268),(14,269),(14,270),(14,271),(14,272),(14,273),(14,274),(14,275),(14,276),(14,277),(14,278),(14,279),(14,280),(14,281),(14,282),(14,283),(14,284),(14,285),(14,286),(14,287),(14,288),(14,289),(14,290),(14,291),(14,292),(14,293),(14,294),(14,295),(14,296),(14,297),(14,298),(14,299),(14,300),(14,301),(14,302),(14,303),(14,304),(14,305),(14,306),(14,307),(14,308),(14,309),(14,310),(14,311),(14,312),(14,313),(14,314),(14,315),(14,316),(14,317),(14,318),(14,319),(14,320),(14,321),(14,322),(14,323),(14,324),(14,325),(14,326),(14,327),(14,328),(14,329),(14,330),(14,331),(14,332),(14,333),(14,334),(14,335),(14,336),(14,337),(14,338),(14,339),(14,340),(14,341),(14,342),(14,343),(14,344),(14,345),(14,346),(14,347),(14,348),(14,349),(14,350),(14,351),(14,352),(14,353),(14,354),(14,355),(14,356),(14,357),(14,358),(14,359),(14,360),(14,361),(14,362),(14,363),(14,364),(14,365),(14,366),(14,367),(14,368),(14,369),(14,370),(14,371),(14,372),(14,373),(14,374),(14,375),(14,376),(14,377),(14,378),(14,379),(14,380),(14,381),(14,382),(14,383),(14,384),(15,5),(15,6),(15,7),(15,8),(15,9),(15,10),(15,11),(15,12),(15,57),(15,58),(15,59),(15,60),(15,61),(15,62),(15,63),(15,64),(15,65),(15,66),(15,67),(15,68),(15,69),(15,70),(15,71),(15,72),(15,73),(15,74),(15,75),(15,76),(15,77),(15,78),(15,79),(15,80),(15,81),(15,82),(15,83),(15,84),(15,85),(15,86),(15,87),(15,88),(15,89),(15,90),(15,91),(15,92),(15,93),(15,94),(15,95),(15,96),(15,97),(15,98),(15,99),(15,100),(15,101),(15,102),(15,103),(15,104),(15,105),(15,106),(15,107),(15,108),(15,109),(15,110),(15,111),(15,112),(15,113),(15,114),(15,115),(15,116),(15,117),(15,118),(15,119),(15,120),(16,5),(16,6),(16,7),(16,8),(16,9),(16,10),(16,11),(16,12),(16,13),(16,14),(16,15),(16,16),(16,17),(16,18),(16,19),(16,20),(16,21),(16,22),(16,23),(16,24),(16,25),(16,26),(16,27),(16,28),(16,29),(16,30),(16,31),(16,32),(16,33),(16,34),(16,35),(16,36),(16,77),(16,78),(16,79),(16,80),(16,81),(16,82),(16,83),(16,84),(16,85),(16,86),(16,87),(16,88),(16,89),(16,90),(16,91),(16,92),(16,93),(16,94),(16,95),(16,96),(16,97),(16,98),(16,99),(16,100),(16,101),(16,102),(16,103),(16,104),(16,105),(16,106),(16,107),(16,108),(16,109),(16,110),(16,111),(16,112),(16,113),(16,114),(16,115),(16,116),(16,117),(16,118),(16,119),(16,120),(16,121),(16,122),(16,123),(16,124),(16,125),(16,126),(16,127),(16,128),(16,129),(16,130),(16,131),(16,132),(16,133),(16,134),(16,135),(16,136),(16,137),(16,138),(16,139),(16,140),(16,141),(16,142),(16,143),(16,144),(16,145),(16,146),(16,147),(16,148),(16,149),(16,150),(16,151),(16,152),(16,153),(16,154),(16,155),(16,156),(16,157),(16,158),(16,159),(16,160),(16,161),(16,162),(16,163),(16,164),(16,165),(16,166),(16,167),(16,168),(16,169),(16,170),(16,171),(16,172),(16,173),(16,174),(16,175),(16,176),(16,177),(16,178),(16,179),(16,180),(16,181),(16,182),(16,183),(16,184),(16,185),(16,186),(16,187),(16,188),(16,189),(16,190),(16,191),(16,192),(16,193),(16,194),(16,195),(16,196),(16,197),(16,198),(16,199),(16,200),(16,201),(16,202),(16,203),(16,204),(16,205),(16,206),(16,207),(16,208),(16,209),(16,210),(16,211),(16,212),(16,213),(16,214),(16,215),(16,216),(16,217),(16,218),(16,219),(16,220),(16,221),(16,222),(16,223),(16,224),(16,225),(16,226),(16,227),(16,228),(16,229),(16,230),(16,231),(16,232),(16,233),(16,234),(16,235),(16,236),(16,237),(16,238),(16,239),(16,240),(16,241),(16,242),(16,243),(16,244),(16,245),(16,246),(16,247),(16,248),(16,249),(16,250),(16,251),(16,252),(16,253),(16,254),(16,255),(16,256),(16,257),(16,258),(16,259),(16,260),(16,261),(16,262),(16,263),(16,264),(16,265),(16,266),(16,267),(16,268),(16,269),(16,270),(16,271),(16,272),(16,273),(16,274),(16,275),(16,276),(16,277),(16,278),(16,279),(16,280),(16,281),(16,282),(16,283),(16,284),(16,285),(16,286),(16,287),(16,288),(16,289),(16,290),(16,291),(16,292),(16,293),(16,294),(16,295),(16,296),(16,297),(16,298),(16,299),(16,300),(16,301),(16,302),(16,303),(16,304),(16,305),(16,306),(16,307),(16,308),(16,309),(16,310),(16,311),(16,312),(16,313),(16,314),(16,315),(16,316),(16,317),(16,318),(16,319),(16,320),(16,321),(16,322),(16,323),(16,324),(16,325),(16,326),(16,327),(16,328),(16,329),(16,330),(16,331),(16,332),(16,333),(16,334),(16,335),(16,336),(16,337),(16,338),(16,339),(16,340),(16,341),(16,342),(16,343),(16,344),(16,345),(16,346),(16,347),(16,348),(16,349),(16,350),(16,351),(16,352),(16,353),(16,354),(16,355),(16,356),(16,357),(16,358),(16,359),(16,360),(16,361),(16,362),(16,363),(16,364),(16,365),(16,366),(16,367),(16,368),(16,369),(16,370),(16,371),(16,372),(16,373),(16,374),(16,375),(16,376),(16,377),(16,378),(16,379),(16,380),(16,381),(16,382),(16,383),(16,384),(17,13),(17,14),(17,15),(17,16),(17,17),(17,18),(17,19),(17,20),(17,49),(17,50),(17,51),(17,52),(17,53),(17,54),(17,55),(17,56),(17,121),(17,122),(17,123),(17,124),(17,125),(17,126),(17,127),(17,128),(17,129),(17,130),(17,131),(17,132),(17,133),(17,134),(17,135),(17,136),(17,137),(17,138),(17,139),(17,140),(17,141),(17,142),(17,143),(17,144),(17,145),(17,146),(17,147),(17,148),(17,149),(17,150),(17,151),(17,152),(17,153),(17,154),(17,155),(17,156),(17,157),(17,158),(17,159),(17,160),(17,161),(17,162),(17,163),(17,164),(17,165),(17,166),(17,167),(17,168),(17,169),(17,170),(17,171),(17,172),(17,173),(17,174),(17,175),(17,176),(17,177),(17,178),(17,179),(17,180),(17,181),(17,182),(17,183),(17,184),(17,185),(17,186),(17,187),(17,188),(17,189),(17,190),(17,191),(17,192),(17,193),(17,194),(17,195),(17,196);
/*!40000 ALTER TABLE `gantt_jobs_resources` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gantt_jobs_resources_log`
--

DROP TABLE IF EXISTS `gantt_jobs_resources_log`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `gantt_jobs_resources_log` (
  `sched_date` int(10) unsigned NOT NULL,
  `moldable_job_id` int(10) unsigned NOT NULL,
  `resource_id` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`sched_date`,`moldable_job_id`,`resource_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `gantt_jobs_resources_log`
--

LOCK TABLES `gantt_jobs_resources_log` WRITE;
/*!40000 ALTER TABLE `gantt_jobs_resources_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `gantt_jobs_resources_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gantt_jobs_resources_visu`
--

DROP TABLE IF EXISTS `gantt_jobs_resources_visu`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `gantt_jobs_resources_visu` (
  `moldable_job_id` int(10) unsigned NOT NULL,
  `resource_id` int(10) unsigned NOT NULL,
  PRIMARY KEY  (`moldable_job_id`,`resource_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `gantt_jobs_resources_visu`
--

LOCK TABLES `gantt_jobs_resources_visu` WRITE;
/*!40000 ALTER TABLE `gantt_jobs_resources_visu` DISABLE KEYS */;
INSERT INTO `gantt_jobs_resources_visu` VALUES (1,1),(1,2),(1,3),(1,4),(1,5),(1,6),(1,7),(1,8),(1,9),(1,10),(1,11),(1,12),(1,13),(1,14),(1,15),(1,16),(1,17),(1,18),(1,19),(1,20),(1,21),(1,22),(1,23),(1,24),(1,25),(1,26),(1,27),(1,28),(1,29),(1,30),(1,31),(1,32),(1,33),(1,34),(1,35),(1,36),(1,37),(1,38),(1,39),(1,40),(1,41),(1,42),(1,43),(1,44),(1,45),(1,46),(1,47),(1,48),(1,49),(1,50),(1,51),(1,52),(1,53),(1,54),(1,55),(1,56),(1,57),(1,58),(1,59),(1,60),(1,61),(1,62),(1,63),(1,64),(1,65),(1,66),(1,67),(1,68),(1,69),(1,70),(1,71),(1,72),(1,73),(1,74),(1,75),(1,76),(1,77),(1,78),(1,79),(1,80),(1,81),(1,82),(1,83),(1,84),(1,85),(1,86),(1,87),(1,88),(1,89),(1,90),(1,91),(1,92),(1,93),(1,94),(1,95),(1,96),(1,97),(1,98),(1,99),(1,100),(1,101),(1,102),(1,103),(1,104),(1,105),(1,106),(1,107),(1,108),(1,109),(1,110),(1,111),(1,112),(1,113),(1,114),(1,115),(1,116),(1,117),(1,118),(1,119),(1,120),(1,121),(1,122),(1,123),(1,124),(1,125),(1,126),(1,127),(1,128),(1,129),(1,130),(1,131),(1,132),(1,133),(1,134),(1,135),(1,136),(1,137),(1,138),(1,139),(1,140),(1,141),(1,142),(1,143),(1,144),(1,145),(1,146),(1,147),(1,148),(1,149),(1,150),(1,151),(1,152),(1,153),(1,154),(1,155),(1,156),(1,157),(1,158),(1,159),(1,160),(1,161),(1,162),(1,163),(1,164),(1,165),(1,166),(1,167),(1,168),(1,169),(1,170),(1,171),(1,172),(1,173),(1,174),(1,175),(1,176),(1,177),(1,178),(1,179),(1,180),(1,181),(1,182),(1,183),(1,184),(1,185),(1,186),(1,187),(1,188),(1,189),(1,190),(1,191),(1,192),(1,193),(1,194),(1,195),(1,196),(1,197),(1,198),(1,199),(1,200),(1,201),(1,202),(1,203),(1,204),(1,205),(1,206),(1,207),(1,208),(1,209),(1,210),(1,211),(1,212),(1,213),(1,214),(1,215),(1,216),(1,217),(1,218),(1,219),(1,220),(1,221),(1,222),(1,223),(1,224),(1,225),(1,226),(1,227),(1,228),(1,229),(1,230),(1,231),(1,232),(1,233),(1,234),(1,235),(1,236),(1,237),(1,238),(1,239),(1,240),(1,241),(1,242),(1,243),(1,244),(1,245),(1,246),(1,247),(1,248),(1,249),(1,250),(1,251),(1,252),(1,253),(1,254),(1,255),(1,256),(1,257),(1,258),(1,259),(1,260),(1,261),(1,262),(1,263),(1,264),(1,265),(1,266),(1,267),(1,268),(1,269),(1,270),(1,271),(1,272),(1,273),(1,274),(1,275),(1,276),(1,277),(1,278),(1,279),(1,280),(1,281),(1,282),(1,283),(1,284),(1,285),(1,286),(1,287),(1,288),(1,289),(1,290),(1,291),(1,292),(1,293),(1,294),(1,295),(1,296),(1,297),(1,298),(1,299),(1,300),(1,301),(1,302),(1,303),(1,304),(1,305),(1,306),(1,307),(1,308),(1,309),(1,310),(1,311),(1,312),(1,313),(1,314),(1,315),(1,316),(1,317),(1,318),(1,319),(1,320),(1,321),(1,322),(1,323),(1,324),(1,325),(1,326),(1,327),(1,328),(1,329),(1,330),(1,331),(1,332),(1,333),(1,334),(1,335),(1,336),(1,337),(1,338),(1,339),(1,340),(1,341),(1,342),(1,343),(1,344),(1,345),(1,346),(1,347),(1,348),(1,349),(1,350),(1,351),(1,352),(1,353),(1,354),(1,355),(1,356),(1,357),(1,358),(1,359),(1,360),(1,361),(1,362),(1,363),(1,364),(1,365),(1,366),(1,367),(1,368),(1,369),(1,370),(1,371),(1,372),(1,373),(1,374),(1,375),(1,376),(1,377),(1,378),(1,379),(1,380),(1,381),(1,382),(1,383),(1,384),(2,21),(2,22),(2,23),(2,24),(2,25),(2,26),(2,27),(2,28),(2,29),(2,30),(2,31),(2,32),(2,33),(2,34),(2,35),(2,36),(2,209),(2,210),(2,211),(2,212),(2,213),(2,214),(2,215),(2,216),(2,217),(2,218),(2,219),(2,220),(2,221),(2,222),(2,223),(2,224),(2,225),(2,226),(2,227),(2,228),(2,229),(2,230),(2,231),(2,232),(2,233),(2,234),(2,235),(2,236),(2,237),(2,238),(2,239),(2,240),(2,241),(2,242),(2,243),(2,244),(2,245),(2,246),(2,247),(2,248),(2,249),(2,250),(2,251),(2,252),(2,253),(2,254),(2,255),(2,256),(2,257),(2,258),(2,259),(2,260),(2,261),(2,262),(2,263),(2,264),(2,265),(2,266),(2,267),(2,268),(2,269),(2,270),(2,271),(2,272),(2,273),(2,274),(2,275),(2,276),(2,277),(2,278),(2,279),(2,280),(2,281),(2,282),(2,283),(2,284),(2,285),(2,286),(2,287),(2,288),(2,289),(2,290),(2,291),(2,292),(2,293),(2,294),(2,295),(2,296),(2,297),(2,298),(2,299),(2,300),(2,301),(2,302),(2,303),(2,304),(2,305),(2,306),(2,307),(2,308),(2,309),(2,310),(2,311),(2,312),(2,313),(2,314),(2,315),(2,316),(2,317),(2,318),(2,319),(2,320),(2,321),(2,322),(2,323),(2,324),(2,325),(2,326),(2,327),(2,328),(2,329),(2,330),(2,331),(2,332),(2,333),(2,334),(2,335),(2,336),(2,337),(2,338),(2,339),(2,340),(2,341),(2,342),(2,343),(2,344),(2,345),(2,346),(2,347),(2,348),(2,349),(2,350),(2,351),(2,352),(2,353),(2,354),(2,355),(2,356),(2,357),(2,358),(2,359),(2,360),(2,361),(2,362),(2,363),(2,364),(2,365),(2,366),(2,367),(2,368),(2,369),(2,370),(2,371),(2,372),(2,373),(2,374),(2,375),(2,376),(2,377),(2,378),(2,379),(2,380),(2,381),(2,382),(2,383),(2,384),(3,9),(3,10),(3,11),(3,12),(3,13),(3,14),(3,15),(3,16),(3,17),(3,18),(3,19),(3,20),(3,21),(3,22),(3,23),(3,24),(3,25),(3,26),(3,27),(3,28),(3,29),(3,30),(3,31),(3,32),(3,33),(3,34),(3,35),(3,36),(3,81),(3,82),(3,83),(3,84),(3,85),(3,86),(3,87),(3,88),(3,89),(3,90),(3,91),(3,92),(3,93),(3,94),(3,95),(3,96),(3,97),(3,98),(3,99),(3,100),(3,101),(3,102),(3,103),(3,104),(3,105),(3,106),(3,107),(3,108),(3,109),(3,110),(3,111),(3,112),(3,113),(3,114),(3,115),(3,116),(3,117),(3,118),(3,119),(3,120),(3,121),(3,122),(3,123),(3,124),(3,125),(3,126),(3,127),(3,128),(3,129),(3,130),(3,131),(3,132),(3,133),(3,134),(3,135),(3,136),(3,137),(3,138),(3,139),(3,140),(3,141),(3,142),(3,143),(3,144),(3,145),(3,146),(3,147),(3,148),(3,149),(3,150),(3,151),(3,152),(3,153),(3,154),(3,155),(3,156),(3,157),(3,158),(3,159),(3,160),(3,161),(3,162),(3,163),(3,164),(3,165),(3,166),(3,167),(3,168),(3,169),(3,170),(3,171),(3,172),(3,173),(3,174),(3,175),(3,176),(3,177),(3,178),(3,179),(3,180),(3,181),(3,182),(3,183),(3,184),(3,185),(3,186),(3,187),(3,188),(3,189),(3,190),(3,191),(3,192),(3,193),(3,194),(3,195),(3,196),(3,197),(3,198),(3,199),(3,200),(3,201),(3,202),(3,203),(3,204),(3,205),(3,206),(3,207),(3,208),(3,209),(3,210),(3,211),(3,212),(3,213),(3,214),(3,215),(3,216),(3,217),(3,218),(3,219),(3,220),(3,221),(3,222),(3,223),(3,224),(3,225),(3,226),(3,227),(3,228),(3,229),(3,230),(3,231),(3,232),(3,233),(3,234),(3,235),(3,236),(3,237),(3,238),(3,239),(3,240),(3,241),(3,242),(3,243),(3,244),(3,245),(3,246),(3,247),(3,248),(3,249),(3,250),(3,251),(3,252),(3,253),(3,254),(3,255),(3,256),(3,257),(3,258),(3,259),(3,260),(3,261),(3,262),(3,263),(3,264),(3,265),(3,266),(3,267),(3,268),(3,269),(3,270),(3,271),(3,272),(3,273),(3,274),(3,275),(3,276),(3,277),(3,278),(3,279),(3,280),(3,281),(3,282),(3,283),(3,284),(3,285),(3,286),(3,287),(3,288),(3,289),(3,290),(3,291),(3,292),(3,293),(3,294),(3,295),(3,296),(3,297),(3,298),(3,299),(3,300),(3,301),(3,302),(3,303),(3,304),(3,305),(3,306),(3,307),(3,308),(3,309),(3,310),(3,311),(3,312),(3,313),(3,314),(3,315),(3,316),(3,317),(3,318),(3,319),(3,320),(3,321),(3,322),(3,323),(3,324),(3,325),(3,326),(3,327),(3,328),(3,329),(3,330),(3,331),(3,332),(3,333),(3,334),(3,335),(3,336),(3,337),(3,338),(3,339),(3,340),(3,341),(3,342),(3,343),(3,344),(3,345),(3,346),(3,347),(3,348),(3,349),(3,350),(3,351),(3,352),(3,353),(3,354),(3,355),(3,356),(3,357),(3,358),(3,359),(3,360),(3,361),(3,362),(3,363),(3,364),(3,365),(3,366),(3,367),(3,368),(3,369),(3,370),(3,371),(3,372),(3,373),(3,374),(3,375),(3,376),(3,377),(3,378),(3,379),(3,380),(3,381),(3,382),(3,383),(3,384),(4,17),(4,18),(4,19),(4,20),(4,21),(4,22),(4,23),(4,24),(4,25),(4,26),(4,27),(4,28),(4,29),(4,30),(4,31),(4,32),(4,33),(4,34),(4,35),(4,36),(4,189),(4,190),(4,191),(4,192),(4,193),(4,194),(4,195),(4,196),(4,197),(4,198),(4,199),(4,200),(4,201),(4,202),(4,203),(4,204),(4,205),(4,206),(4,207),(4,208),(4,209),(4,210),(4,211),(4,212),(4,213),(4,214),(4,215),(4,216),(4,217),(4,218),(4,219),(4,220),(4,221),(4,222),(4,223),(4,224),(4,225),(4,226),(4,227),(4,228),(4,229),(4,230),(4,231),(4,232),(4,233),(4,234),(4,235),(4,236),(4,237),(4,238),(4,239),(4,240),(4,241),(4,242),(4,243),(4,244),(4,245),(4,246),(4,247),(4,248),(4,249),(4,250),(4,251),(4,252),(4,253),(4,254),(4,255),(4,256),(4,257),(4,258),(4,259),(4,260),(4,261),(4,262),(4,263),(4,264),(4,265),(4,266),(4,267),(4,268),(4,269),(4,270),(4,271),(4,272),(4,273),(4,274),(4,275),(4,276),(4,277),(4,278),(4,279),(4,280),(4,281),(4,282),(4,283),(4,284),(4,285),(4,286),(4,287),(4,288),(4,289),(4,290),(4,291),(4,292),(4,293),(4,294),(4,295),(4,296),(4,297),(4,298),(4,299),(4,300),(4,301),(4,302),(4,303),(4,304),(4,305),(4,306),(4,307),(4,308),(4,309),(4,310),(4,311),(4,312),(4,313),(4,314),(4,315),(4,316),(4,317),(4,318),(4,319),(4,320),(4,321),(4,322),(4,323),(4,324),(4,325),(4,326),(4,327),(4,328),(4,329),(4,330),(4,331),(4,332),(4,333),(4,334),(4,335),(4,336),(4,337),(4,338),(4,339),(4,340),(4,341),(4,342),(4,343),(4,344),(4,345),(4,346),(4,347),(4,348),(4,349),(4,350),(4,351),(4,352),(4,353),(4,354),(4,355),(4,356),(4,357),(4,358),(4,359),(4,360),(4,361),(4,362),(4,363),(4,364),(4,365),(4,366),(4,367),(4,368),(4,369),(4,370),(4,371),(4,372),(4,373),(4,374),(4,375),(4,376),(4,377),(4,378),(4,379),(4,380),(4,381),(4,382),(4,383),(4,384),(5,5),(5,6),(5,7),(5,8),(5,9),(5,10),(5,11),(5,12),(5,13),(5,14),(5,15),(5,16),(5,17),(5,18),(5,19),(5,20),(5,21),(5,22),(5,23),(5,24),(5,25),(5,26),(5,27),(5,28),(5,29),(5,30),(5,31),(5,32),(5,33),(5,34),(5,35),(5,36),(5,65),(5,66),(5,67),(5,68),(5,69),(5,70),(5,71),(5,72),(5,73),(5,74),(5,75),(5,76),(5,77),(5,78),(5,79),(5,80),(5,81),(5,82),(5,83),(5,84),(5,85),(5,86),(5,87),(5,88),(5,89),(5,90),(5,91),(5,92),(5,93),(5,94),(5,95),(5,96),(5,97),(5,98),(5,99),(5,100),(5,101),(5,102),(5,103),(5,104),(5,105),(5,106),(5,107),(5,108),(5,109),(5,110),(5,111),(5,112),(5,113),(5,114),(5,115),(5,116),(5,117),(5,118),(5,119),(5,120),(5,121),(5,122),(5,123),(5,124),(5,125),(5,126),(5,127),(5,128),(5,129),(5,130),(5,131),(5,132),(5,133),(5,134),(5,135),(5,136),(5,137),(5,138),(5,139),(5,140),(5,141),(5,142),(5,143),(5,144),(5,145),(5,146),(5,147),(5,148),(5,149),(5,150),(5,151),(5,152),(5,153),(5,154),(5,155),(5,156),(5,157),(5,158),(5,159),(5,160),(5,161),(5,162),(5,163),(5,164),(5,165),(5,166),(5,167),(5,168),(5,169),(5,170),(5,171),(5,172),(5,173),(5,174),(5,175),(5,176),(5,177),(5,178),(5,179),(5,180),(5,181),(5,182),(5,183),(5,184),(5,185),(5,186),(5,187),(5,188),(5,189),(5,190),(5,191),(5,192),(5,193),(5,194),(5,195),(5,196),(5,197),(5,198),(5,199),(5,200),(5,201),(5,202),(5,203),(5,204),(5,205),(5,206),(5,207),(5,208),(5,209),(5,210),(5,211),(5,212),(5,213),(5,214),(5,215),(5,216),(5,217),(5,218),(5,219),(5,220),(5,221),(5,222),(5,223),(5,224),(5,225),(5,226),(5,227),(5,228),(5,229),(5,230),(5,231),(5,232),(5,233),(5,234),(5,235),(5,236),(5,237),(5,238),(5,239),(5,240),(5,241),(5,242),(5,243),(5,244),(5,245),(5,246),(5,247),(5,248),(5,249),(5,250),(5,251),(5,252),(5,253),(5,254),(5,255),(5,256),(5,257),(5,258),(5,259),(5,260),(5,261),(5,262),(5,263),(5,264),(5,265),(5,266),(5,267),(5,268),(5,269),(5,270),(5,271),(5,272),(5,273),(5,274),(5,275),(5,276),(5,277),(5,278),(5,279),(5,280),(5,281),(5,282),(5,283),(5,284),(5,285),(5,286),(5,287),(5,288),(5,289),(5,290),(5,291),(5,292),(5,293),(5,294),(5,295),(5,296),(5,297),(5,298),(5,299),(5,300),(5,301),(5,302),(5,303),(5,304),(5,305),(5,306),(5,307),(5,308),(5,309),(5,310),(5,311),(5,312),(5,313),(5,314),(5,315),(5,316),(5,317),(5,318),(5,319),(5,320),(5,321),(5,322),(5,323),(5,324),(5,325),(5,326),(5,327),(5,328),(5,329),(5,330),(5,331),(5,332),(5,333),(5,334),(5,335),(5,336),(5,337),(5,338),(5,339),(5,340),(5,341),(5,342),(5,343),(5,344),(5,345),(5,346),(5,347),(5,348),(5,349),(5,350),(5,351),(5,352),(5,353),(5,354),(5,355),(5,356),(5,357),(5,358),(5,359),(5,360),(5,361),(5,362),(5,363),(5,364),(5,365),(5,366),(5,367),(5,368),(5,369),(5,370),(5,371),(5,372),(5,373),(5,374),(5,375),(5,376),(5,377),(5,378),(5,379),(5,380),(5,381),(5,382),(5,383),(5,384),(6,17),(6,18),(6,19),(6,20),(6,21),(6,22),(6,23),(6,24),(6,25),(6,26),(6,27),(6,28),(6,29),(6,30),(6,31),(6,32),(6,33),(6,34),(6,35),(6,36),(6,169),(6,170),(6,171),(6,172),(6,173),(6,174),(6,175),(6,176),(6,177),(6,178),(6,179),(6,180),(6,181),(6,182),(6,183),(6,184),(6,185),(6,186),(6,187),(6,188),(6,189),(6,190),(6,191),(6,192),(6,193),(6,194),(6,195),(6,196),(6,197),(6,198),(6,199),(6,200),(6,201),(6,202),(6,203),(6,204),(6,205),(6,206),(6,207),(6,208),(6,209),(6,210),(6,211),(6,212),(6,213),(6,214),(6,215),(6,216),(6,217),(6,218),(6,219),(6,220),(6,221),(6,222),(6,223),(6,224),(6,225),(6,226),(6,227),(6,228),(6,229),(6,230),(6,231),(6,232),(6,233),(6,234),(6,235),(6,236),(6,237),(6,238),(6,239),(6,240),(6,241),(6,242),(6,243),(6,244),(6,245),(6,246),(6,247),(6,248),(6,249),(6,250),(6,251),(6,252),(6,253),(6,254),(6,255),(6,256),(6,257),(6,258),(6,259),(6,260),(6,261),(6,262),(6,263),(6,264),(6,265),(6,266),(6,267),(6,268),(6,269),(6,270),(6,271),(6,272),(6,273),(6,274),(6,275),(6,276),(6,277),(6,278),(6,279),(6,280),(6,281),(6,282),(6,283),(6,284),(6,285),(6,286),(6,287),(6,288),(6,289),(6,290),(6,291),(6,292),(6,293),(6,294),(6,295),(6,296),(6,297),(6,298),(6,299),(6,300),(6,301),(6,302),(6,303),(6,304),(6,305),(6,306),(6,307),(6,308),(6,309),(6,310),(6,311),(6,312),(6,313),(6,314),(6,315),(6,316),(6,317),(6,318),(6,319),(6,320),(6,321),(6,322),(6,323),(6,324),(6,325),(6,326),(6,327),(6,328),(6,329),(6,330),(6,331),(6,332),(6,333),(6,334),(6,335),(6,336),(6,337),(6,338),(6,339),(6,340),(6,341),(6,342),(6,343),(6,344),(6,345),(6,346),(6,347),(6,348),(6,349),(6,350),(6,351),(6,352),(6,353),(6,354),(6,355),(6,356),(6,357),(6,358),(6,359),(6,360),(6,361),(6,362),(6,363),(6,364),(6,365),(6,366),(6,367),(6,368),(6,369),(6,370),(6,371),(6,372),(6,373),(6,374),(6,375),(6,376),(6,377),(6,378),(6,379),(6,380),(6,381),(6,382),(6,383),(6,384),(7,5),(7,6),(7,7),(7,8),(7,9),(7,10),(7,11),(7,12),(7,13),(7,14),(7,15),(7,16),(7,17),(7,18),(7,19),(7,20),(7,21),(7,22),(7,23),(7,24),(7,25),(7,26),(7,27),(7,28),(7,29),(7,30),(7,31),(7,32),(7,33),(7,34),(7,35),(7,36),(7,45),(7,46),(7,47),(7,48),(7,49),(7,50),(7,51),(7,52),(7,53),(7,54),(7,55),(7,56),(7,57),(7,58),(7,59),(7,60),(7,61),(7,62),(7,63),(7,64),(7,65),(7,66),(7,67),(7,68),(7,69),(7,70),(7,71),(7,72),(7,73),(7,74),(7,75),(7,76),(7,77),(7,78),(7,79),(7,80),(7,81),(7,82),(7,83),(7,84),(7,85),(7,86),(7,87),(7,88),(7,89),(7,90),(7,91),(7,92),(7,93),(7,94),(7,95),(7,96),(7,97),(7,98),(7,99),(7,100),(7,101),(7,102),(7,103),(7,104),(7,105),(7,106),(7,107),(7,108),(7,109),(7,110),(7,111),(7,112),(7,113),(7,114),(7,115),(7,116),(7,117),(7,118),(7,119),(7,120),(7,121),(7,122),(7,123),(7,124),(7,125),(7,126),(7,127),(7,128),(7,129),(7,130),(7,131),(7,132),(7,133),(7,134),(7,135),(7,136),(7,137),(7,138),(7,139),(7,140),(7,141),(7,142),(7,143),(7,144),(7,145),(7,146),(7,147),(7,148),(7,149),(7,150),(7,151),(7,152),(7,153),(7,154),(7,155),(7,156),(7,157),(7,158),(7,159),(7,160),(7,161),(7,162),(7,163),(7,164),(7,165),(7,166),(7,167),(7,168),(7,169),(7,170),(7,171),(7,172),(7,173),(7,174),(7,175),(7,176),(7,177),(7,178),(7,179),(7,180),(7,181),(7,182),(7,183),(7,184),(7,185),(7,186),(7,187),(7,188),(7,189),(7,190),(7,191),(7,192),(7,193),(7,194),(7,195),(7,196),(7,197),(7,198),(7,199),(7,200),(7,201),(7,202),(7,203),(7,204),(7,205),(7,206),(7,207),(7,208),(7,209),(7,210),(7,211),(7,212),(7,213),(7,214),(7,215),(7,216),(7,217),(7,218),(7,219),(7,220),(7,221),(7,222),(7,223),(7,224),(7,225),(7,226),(7,227),(7,228),(7,229),(7,230),(7,231),(7,232),(7,233),(7,234),(7,235),(7,236),(7,237),(7,238),(7,239),(7,240),(7,241),(7,242),(7,243),(7,244),(7,245),(7,246),(7,247),(7,248),(7,249),(7,250),(7,251),(7,252),(7,253),(7,254),(7,255),(7,256),(7,257),(7,258),(7,259),(7,260),(7,261),(7,262),(7,263),(7,264),(7,265),(7,266),(7,267),(7,268),(7,269),(7,270),(7,271),(7,272),(7,273),(7,274),(7,275),(7,276),(7,277),(7,278),(7,279),(7,280),(7,281),(7,282),(7,283),(7,284),(7,285),(7,286),(7,287),(7,288),(7,289),(7,290),(7,291),(7,292),(7,293),(7,294),(7,295),(7,296),(7,297),(7,298),(7,299),(7,300),(7,301),(7,302),(7,303),(7,304),(7,305),(7,306),(7,307),(7,308),(7,309),(7,310),(7,311),(7,312),(7,313),(7,314),(7,315),(7,316),(7,317),(7,318),(7,319),(7,320),(7,321),(7,322),(7,323),(7,324),(7,325),(7,326),(7,327),(7,328),(7,329),(7,330),(7,331),(7,332),(7,333),(7,334),(7,335),(7,336),(7,337),(7,338),(7,339),(7,340),(7,341),(7,342),(7,343),(7,344),(7,345),(7,346),(7,347),(7,348),(7,349),(7,350),(7,351),(7,352),(7,353),(7,354),(7,355),(7,356),(7,357),(7,358),(7,359),(7,360),(7,361),(7,362),(7,363),(7,364),(7,365),(7,366),(7,367),(7,368),(7,369),(7,370),(7,371),(7,372),(7,373),(7,374),(7,375),(7,376),(7,377),(7,378),(7,379),(7,380),(7,381),(7,382),(7,383),(7,384),(8,13),(8,14),(8,15),(8,16),(8,17),(8,18),(8,19),(8,20),(8,21),(8,22),(8,23),(8,24),(8,25),(8,26),(8,27),(8,28),(8,29),(8,30),(8,31),(8,32),(8,33),(8,34),(8,35),(8,36),(8,153),(8,154),(8,155),(8,156),(8,157),(8,158),(8,159),(8,160),(8,161),(8,162),(8,163),(8,164),(8,165),(8,166),(8,167),(8,168),(8,169),(8,170),(8,171),(8,172),(8,173),(8,174),(8,175),(8,176),(8,177),(8,178),(8,179),(8,180),(8,181),(8,182),(8,183),(8,184),(8,185),(8,186),(8,187),(8,188),(8,189),(8,190),(8,191),(8,192),(8,193),(8,194),(8,195),(8,196),(8,197),(8,198),(8,199),(8,200),(8,201),(8,202),(8,203),(8,204),(8,205),(8,206),(8,207),(8,208),(8,209),(8,210),(8,211),(8,212),(8,213),(8,214),(8,215),(8,216),(8,217),(8,218),(8,219),(8,220),(8,221),(8,222),(8,223),(8,224),(8,225),(8,226),(8,227),(8,228),(8,229),(8,230),(8,231),(8,232),(8,233),(8,234),(8,235),(8,236),(8,237),(8,238),(8,239),(8,240),(8,241),(8,242),(8,243),(8,244),(8,245),(8,246),(8,247),(8,248),(8,249),(8,250),(8,251),(8,252),(8,253),(8,254),(8,255),(8,256),(8,257),(8,258),(8,259),(8,260),(8,261),(8,262),(8,263),(8,264),(8,265),(8,266),(8,267),(8,268),(8,269),(8,270),(8,271),(8,272),(8,273),(8,274),(8,275),(8,276),(8,277),(8,278),(8,279),(8,280),(8,281),(8,282),(8,283),(8,284),(8,285),(8,286),(8,287),(8,288),(8,289),(8,290),(8,291),(8,292),(8,293),(8,294),(8,295),(8,296),(8,297),(8,298),(8,299),(8,300),(8,301),(8,302),(8,303),(8,304),(8,305),(8,306),(8,307),(8,308),(8,309),(8,310),(8,311),(8,312),(8,313),(8,314),(8,315),(8,316),(8,317),(8,318),(8,319),(8,320),(8,321),(8,322),(8,323),(8,324),(8,325),(8,326),(8,327),(8,328),(8,329),(8,330),(8,331),(8,332),(8,333),(8,334),(8,335),(8,336),(8,337),(8,338),(8,339),(8,340),(8,341),(8,342),(8,343),(8,344),(8,345),(8,346),(8,347),(8,348),(8,349),(8,350),(8,351),(8,352),(8,353),(8,354),(8,355),(8,356),(8,357),(8,358),(8,359),(8,360),(8,361),(8,362),(8,363),(8,364),(8,365),(8,366),(8,367),(8,368),(8,369),(8,370),(8,371),(8,372),(8,373),(8,374),(8,375),(8,376),(8,377),(8,378),(8,379),(8,380),(8,381),(8,382),(8,383),(8,384),(9,197),(9,198),(9,199),(9,200),(9,201),(9,202),(9,203),(9,204),(9,205),(9,206),(9,207),(9,208),(10,13),(10,14),(10,15),(10,16),(10,17),(10,18),(10,19),(10,20),(10,21),(10,22),(10,23),(10,24),(10,25),(10,26),(10,27),(10,28),(10,29),(10,30),(10,31),(10,32),(10,33),(10,34),(10,35),(10,36),(10,133),(10,134),(10,135),(10,136),(10,137),(10,138),(10,139),(10,140),(10,141),(10,142),(10,143),(10,144),(10,145),(10,146),(10,147),(10,148),(10,149),(10,150),(10,151),(10,152),(10,153),(10,154),(10,155),(10,156),(10,157),(10,158),(10,159),(10,160),(10,161),(10,162),(10,163),(10,164),(10,165),(10,166),(10,167),(10,168),(10,169),(10,170),(10,171),(10,172),(10,173),(10,174),(10,175),(10,176),(10,177),(10,178),(10,179),(10,180),(10,181),(10,182),(10,183),(10,184),(10,185),(10,186),(10,187),(10,188),(10,189),(10,190),(10,191),(10,192),(10,193),(10,194),(10,195),(10,196),(10,197),(10,198),(10,199),(10,200),(10,201),(10,202),(10,203),(10,204),(10,205),(10,206),(10,207),(10,208),(10,209),(10,210),(10,211),(10,212),(10,213),(10,214),(10,215),(10,216),(10,217),(10,218),(10,219),(10,220),(10,221),(10,222),(10,223),(10,224),(10,225),(10,226),(10,227),(10,228),(10,229),(10,230),(10,231),(10,232),(10,233),(10,234),(10,235),(10,236),(10,237),(10,238),(10,239),(10,240),(10,241),(10,242),(10,243),(10,244),(10,245),(10,246),(10,247),(10,248),(10,249),(10,250),(10,251),(10,252),(10,253),(10,254),(10,255),(10,256),(10,257),(10,258),(10,259),(10,260),(10,261),(10,262),(10,263),(10,264),(10,265),(10,266),(10,267),(10,268),(10,269),(10,270),(10,271),(10,272),(10,273),(10,274),(10,275),(10,276),(10,277),(10,278),(10,279),(10,280),(10,281),(10,282),(10,283),(10,284),(10,285),(10,286),(10,287),(10,288),(10,289),(10,290),(10,291),(10,292),(10,293),(10,294),(10,295),(10,296),(10,297),(10,298),(10,299),(10,300),(10,301),(10,302),(10,303),(10,304),(10,305),(10,306),(10,307),(10,308),(10,309),(10,310),(10,311),(10,312),(10,313),(10,314),(10,315),(10,316),(10,317),(10,318),(10,319),(10,320),(10,321),(10,322),(10,323),(10,324),(10,325),(10,326),(10,327),(10,328),(10,329),(10,330),(10,331),(10,332),(10,333),(10,334),(10,335),(10,336),(10,337),(10,338),(10,339),(10,340),(10,341),(10,342),(10,343),(10,344),(10,345),(10,346),(10,347),(10,348),(10,349),(10,350),(10,351),(10,352),(10,353),(10,354),(10,355),(10,356),(10,357),(10,358),(10,359),(10,360),(10,361),(10,362),(10,363),(10,364),(10,365),(10,366),(10,367),(10,368),(10,369),(10,370),(10,371),(10,372),(10,373),(10,374),(10,375),(10,376),(10,377),(10,378),(10,379),(10,380),(10,381),(10,382),(10,383),(10,384),(11,17),(11,18),(11,19),(11,20),(11,169),(11,170),(11,171),(11,172),(11,173),(11,174),(11,175),(11,176),(11,177),(11,178),(11,179),(11,180),(11,181),(11,182),(11,183),(11,184),(11,185),(11,186),(11,187),(11,188),(11,189),(11,190),(11,191),(11,192),(11,193),(11,194),(11,195),(11,196),(12,9),(12,10),(12,11),(12,12),(12,13),(12,14),(12,15),(12,16),(12,17),(12,18),(12,19),(12,20),(12,21),(12,22),(12,23),(12,24),(12,25),(12,26),(12,27),(12,28),(12,29),(12,30),(12,31),(12,32),(12,33),(12,34),(12,35),(12,36),(12,117),(12,118),(12,119),(12,120),(12,121),(12,122),(12,123),(12,124),(12,125),(12,126),(12,127),(12,128),(12,129),(12,130),(12,131),(12,132),(12,133),(12,134),(12,135),(12,136),(12,137),(12,138),(12,139),(12,140),(12,141),(12,142),(12,143),(12,144),(12,145),(12,146),(12,147),(12,148),(12,149),(12,150),(12,151),(12,152),(12,153),(12,154),(12,155),(12,156),(12,157),(12,158),(12,159),(12,160),(12,161),(12,162),(12,163),(12,164),(12,165),(12,166),(12,167),(12,168),(12,169),(12,170),(12,171),(12,172),(12,173),(12,174),(12,175),(12,176),(12,177),(12,178),(12,179),(12,180),(12,181),(12,182),(12,183),(12,184),(12,185),(12,186),(12,187),(12,188),(12,189),(12,190),(12,191),(12,192),(12,193),(12,194),(12,195),(12,196),(12,197),(12,198),(12,199),(12,200),(12,201),(12,202),(12,203),(12,204),(12,205),(12,206),(12,207),(12,208),(12,209),(12,210),(12,211),(12,212),(12,213),(12,214),(12,215),(12,216),(12,217),(12,218),(12,219),(12,220),(12,221),(12,222),(12,223),(12,224),(12,225),(12,226),(12,227),(12,228),(12,229),(12,230),(12,231),(12,232),(12,233),(12,234),(12,235),(12,236),(12,237),(12,238),(12,239),(12,240),(12,241),(12,242),(12,243),(12,244),(12,245),(12,246),(12,247),(12,248),(12,249),(12,250),(12,251),(12,252),(12,253),(12,254),(12,255),(12,256),(12,257),(12,258),(12,259),(12,260),(12,261),(12,262),(12,263),(12,264),(12,265),(12,266),(12,267),(12,268),(12,269),(12,270),(12,271),(12,272),(12,273),(12,274),(12,275),(12,276),(12,277),(12,278),(12,279),(12,280),(12,281),(12,282),(12,283),(12,284),(12,285),(12,286),(12,287),(12,288),(12,289),(12,290),(12,291),(12,292),(12,293),(12,294),(12,295),(12,296),(12,297),(12,298),(12,299),(12,300),(12,301),(12,302),(12,303),(12,304),(12,305),(12,306),(12,307),(12,308),(12,309),(12,310),(12,311),(12,312),(12,313),(12,314),(12,315),(12,316),(12,317),(12,318),(12,319),(12,320),(12,321),(12,322),(12,323),(12,324),(12,325),(12,326),(12,327),(12,328),(12,329),(12,330),(12,331),(12,332),(12,333),(12,334),(12,335),(12,336),(12,337),(12,338),(12,339),(12,340),(12,341),(12,342),(12,343),(12,344),(12,345),(12,346),(12,347),(12,348),(12,349),(12,350),(12,351),(12,352),(12,353),(12,354),(12,355),(12,356),(12,357),(12,358),(12,359),(12,360),(12,361),(12,362),(12,363),(12,364),(12,365),(12,366),(12,367),(12,368),(12,369),(12,370),(12,371),(12,372),(12,373),(12,374),(12,375),(12,376),(12,377),(12,378),(12,379),(12,380),(12,381),(12,382),(12,383),(12,384),(13,13),(13,14),(13,15),(13,16),(13,121),(13,122),(13,123),(13,124),(13,125),(13,126),(13,127),(13,128),(13,129),(13,130),(13,131),(13,132),(13,133),(13,134),(13,135),(13,136),(13,137),(13,138),(13,139),(13,140),(13,141),(13,142),(13,143),(13,144),(13,145),(13,146),(13,147),(13,148),(13,149),(13,150),(13,151),(13,152),(13,153),(13,154),(13,155),(13,156),(13,157),(13,158),(13,159),(13,160),(13,161),(13,162),(13,163),(13,164),(13,165),(13,166),(13,167),(13,168),(14,9),(14,10),(14,11),(14,12),(14,13),(14,14),(14,15),(14,16),(14,17),(14,18),(14,19),(14,20),(14,21),(14,22),(14,23),(14,24),(14,25),(14,26),(14,27),(14,28),(14,29),(14,30),(14,31),(14,32),(14,33),(14,34),(14,35),(14,36),(14,93),(14,94),(14,95),(14,96),(14,97),(14,98),(14,99),(14,100),(14,101),(14,102),(14,103),(14,104),(14,105),(14,106),(14,107),(14,108),(14,109),(14,110),(14,111),(14,112),(14,113),(14,114),(14,115),(14,116),(14,117),(14,118),(14,119),(14,120),(14,121),(14,122),(14,123),(14,124),(14,125),(14,126),(14,127),(14,128),(14,129),(14,130),(14,131),(14,132),(14,133),(14,134),(14,135),(14,136),(14,137),(14,138),(14,139),(14,140),(14,141),(14,142),(14,143),(14,144),(14,145),(14,146),(14,147),(14,148),(14,149),(14,150),(14,151),(14,152),(14,153),(14,154),(14,155),(14,156),(14,157),(14,158),(14,159),(14,160),(14,161),(14,162),(14,163),(14,164),(14,165),(14,166),(14,167),(14,168),(14,169),(14,170),(14,171),(14,172),(14,173),(14,174),(14,175),(14,176),(14,177),(14,178),(14,179),(14,180),(14,181),(14,182),(14,183),(14,184),(14,185),(14,186),(14,187),(14,188),(14,189),(14,190),(14,191),(14,192),(14,193),(14,194),(14,195),(14,196),(14,197),(14,198),(14,199),(14,200),(14,201),(14,202),(14,203),(14,204),(14,205),(14,206),(14,207),(14,208),(14,209),(14,210),(14,211),(14,212),(14,213),(14,214),(14,215),(14,216),(14,217),(14,218),(14,219),(14,220),(14,221),(14,222),(14,223),(14,224),(14,225),(14,226),(14,227),(14,228),(14,229),(14,230),(14,231),(14,232),(14,233),(14,234),(14,235),(14,236),(14,237),(14,238),(14,239),(14,240),(14,241),(14,242),(14,243),(14,244),(14,245),(14,246),(14,247),(14,248),(14,249),(14,250),(14,251),(14,252),(14,253),(14,254),(14,255),(14,256),(14,257),(14,258),(14,259),(14,260),(14,261),(14,262),(14,263),(14,264),(14,265),(14,266),(14,267),(14,268),(14,269),(14,270),(14,271),(14,272),(14,273),(14,274),(14,275),(14,276),(14,277),(14,278),(14,279),(14,280),(14,281),(14,282),(14,283),(14,284),(14,285),(14,286),(14,287),(14,288),(14,289),(14,290),(14,291),(14,292),(14,293),(14,294),(14,295),(14,296),(14,297),(14,298),(14,299),(14,300),(14,301),(14,302),(14,303),(14,304),(14,305),(14,306),(14,307),(14,308),(14,309),(14,310),(14,311),(14,312),(14,313),(14,314),(14,315),(14,316),(14,317),(14,318),(14,319),(14,320),(14,321),(14,322),(14,323),(14,324),(14,325),(14,326),(14,327),(14,328),(14,329),(14,330),(14,331),(14,332),(14,333),(14,334),(14,335),(14,336),(14,337),(14,338),(14,339),(14,340),(14,341),(14,342),(14,343),(14,344),(14,345),(14,346),(14,347),(14,348),(14,349),(14,350),(14,351),(14,352),(14,353),(14,354),(14,355),(14,356),(14,357),(14,358),(14,359),(14,360),(14,361),(14,362),(14,363),(14,364),(14,365),(14,366),(14,367),(14,368),(14,369),(14,370),(14,371),(14,372),(14,373),(14,374),(14,375),(14,376),(14,377),(14,378),(14,379),(14,380),(14,381),(14,382),(14,383),(14,384),(15,5),(15,6),(15,7),(15,8),(15,9),(15,10),(15,11),(15,12),(15,57),(15,58),(15,59),(15,60),(15,61),(15,62),(15,63),(15,64),(15,65),(15,66),(15,67),(15,68),(15,69),(15,70),(15,71),(15,72),(15,73),(15,74),(15,75),(15,76),(15,77),(15,78),(15,79),(15,80),(15,81),(15,82),(15,83),(15,84),(15,85),(15,86),(15,87),(15,88),(15,89),(15,90),(15,91),(15,92),(15,93),(15,94),(15,95),(15,96),(15,97),(15,98),(15,99),(15,100),(15,101),(15,102),(15,103),(15,104),(15,105),(15,106),(15,107),(15,108),(15,109),(15,110),(15,111),(15,112),(15,113),(15,114),(15,115),(15,116),(15,117),(15,118),(15,119),(15,120),(16,5),(16,6),(16,7),(16,8),(16,9),(16,10),(16,11),(16,12),(16,13),(16,14),(16,15),(16,16),(16,17),(16,18),(16,19),(16,20),(16,21),(16,22),(16,23),(16,24),(16,25),(16,26),(16,27),(16,28),(16,29),(16,30),(16,31),(16,32),(16,33),(16,34),(16,35),(16,36),(16,77),(16,78),(16,79),(16,80),(16,81),(16,82),(16,83),(16,84),(16,85),(16,86),(16,87),(16,88),(16,89),(16,90),(16,91),(16,92),(16,93),(16,94),(16,95),(16,96),(16,97),(16,98),(16,99),(16,100),(16,101),(16,102),(16,103),(16,104),(16,105),(16,106),(16,107),(16,108),(16,109),(16,110),(16,111),(16,112),(16,113),(16,114),(16,115),(16,116),(16,117),(16,118),(16,119),(16,120),(16,121),(16,122),(16,123),(16,124),(16,125),(16,126),(16,127),(16,128),(16,129),(16,130),(16,131),(16,132),(16,133),(16,134),(16,135),(16,136),(16,137),(16,138),(16,139),(16,140),(16,141),(16,142),(16,143),(16,144),(16,145),(16,146),(16,147),(16,148),(16,149),(16,150),(16,151),(16,152),(16,153),(16,154),(16,155),(16,156),(16,157),(16,158),(16,159),(16,160),(16,161),(16,162),(16,163),(16,164),(16,165),(16,166),(16,167),(16,168),(16,169),(16,170),(16,171),(16,172),(16,173),(16,174),(16,175),(16,176),(16,177),(16,178),(16,179),(16,180),(16,181),(16,182),(16,183),(16,184),(16,185),(16,186),(16,187),(16,188),(16,189),(16,190),(16,191),(16,192),(16,193),(16,194),(16,195),(16,196),(16,197),(16,198),(16,199),(16,200),(16,201),(16,202),(16,203),(16,204),(16,205),(16,206),(16,207),(16,208),(16,209),(16,210),(16,211),(16,212),(16,213),(16,214),(16,215),(16,216),(16,217),(16,218),(16,219),(16,220),(16,221),(16,222),(16,223),(16,224),(16,225),(16,226),(16,227),(16,228),(16,229),(16,230),(16,231),(16,232),(16,233),(16,234),(16,235),(16,236),(16,237),(16,238),(16,239),(16,240),(16,241),(16,242),(16,243),(16,244),(16,245),(16,246),(16,247),(16,248),(16,249),(16,250),(16,251),(16,252),(16,253),(16,254),(16,255),(16,256),(16,257),(16,258),(16,259),(16,260),(16,261),(16,262),(16,263),(16,264),(16,265),(16,266),(16,267),(16,268),(16,269),(16,270),(16,271),(16,272),(16,273),(16,274),(16,275),(16,276),(16,277),(16,278),(16,279),(16,280),(16,281),(16,282),(16,283),(16,284),(16,285),(16,286),(16,287),(16,288),(16,289),(16,290),(16,291),(16,292),(16,293),(16,294),(16,295),(16,296),(16,297),(16,298),(16,299),(16,300),(16,301),(16,302),(16,303),(16,304),(16,305),(16,306),(16,307),(16,308),(16,309),(16,310),(16,311),(16,312),(16,313),(16,314),(16,315),(16,316),(16,317),(16,318),(16,319),(16,320),(16,321),(16,322),(16,323),(16,324),(16,325),(16,326),(16,327),(16,328),(16,329),(16,330),(16,331),(16,332),(16,333),(16,334),(16,335),(16,336),(16,337),(16,338),(16,339),(16,340),(16,341),(16,342),(16,343),(16,344),(16,345),(16,346),(16,347),(16,348),(16,349),(16,350),(16,351),(16,352),(16,353),(16,354),(16,355),(16,356),(16,357),(16,358),(16,359),(16,360),(16,361),(16,362),(16,363),(16,364),(16,365),(16,366),(16,367),(16,368),(16,369),(16,370),(16,371),(16,372),(16,373),(16,374),(16,375),(16,376),(16,377),(16,378),(16,379),(16,380),(16,381),(16,382),(16,383),(16,384),(17,13),(17,14),(17,15),(17,16),(17,17),(17,18),(17,19),(17,20),(17,49),(17,50),(17,51),(17,52),(17,53),(17,54),(17,55),(17,56),(17,121),(17,122),(17,123),(17,124),(17,125),(17,126),(17,127),(17,128),(17,129),(17,130),(17,131),(17,132),(17,133),(17,134),(17,135),(17,136),(17,137),(17,138),(17,139),(17,140),(17,141),(17,142),(17,143),(17,144),(17,145),(17,146),(17,147),(17,148),(17,149),(17,150),(17,151),(17,152),(17,153),(17,154),(17,155),(17,156),(17,157),(17,158),(17,159),(17,160),(17,161),(17,162),(17,163),(17,164),(17,165),(17,166),(17,167),(17,168),(17,169),(17,170),(17,171),(17,172),(17,173),(17,174),(17,175),(17,176),(17,177),(17,178),(17,179),(17,180),(17,181),(17,182),(17,183),(17,184),(17,185),(17,186),(17,187),(17,188),(17,189),(17,190),(17,191),(17,192),(17,193),(17,194),(17,195),(17,196),(18,5),(18,6),(18,7),(18,8),(18,9),(18,10),(18,11),(18,12),(18,13),(18,14),(18,15),(18,16),(18,17),(18,18),(18,19),(18,20),(18,21),(18,22),(18,23),(18,24),(18,25),(18,26),(18,27),(18,28),(18,29),(18,30),(18,31),(18,32),(18,33),(18,34),(18,35),(18,36),(18,57),(18,58),(18,59),(18,60),(18,61),(18,62),(18,63),(18,64),(18,65),(18,66),(18,67),(18,68),(18,69),(18,70),(18,71),(18,72),(18,73),(18,74),(18,75),(18,76),(18,77),(18,78),(18,79),(18,80),(18,81),(18,82),(18,83),(18,84),(18,85),(18,86),(18,87),(18,88),(18,89),(18,90),(18,91),(18,92),(18,93),(18,94),(18,95),(18,96),(18,97),(18,98),(18,99),(18,100),(18,101),(18,102),(18,103),(18,104),(18,105),(18,106),(18,107),(18,108),(18,109),(18,110),(18,111),(18,112),(18,113),(18,114),(18,115),(18,116),(18,117),(18,118),(18,119),(18,120),(18,121),(18,122),(18,123),(18,124),(18,125),(18,126),(18,127),(18,128),(18,129),(18,130),(18,131),(18,132),(18,133),(18,134),(18,135),(18,136),(18,137),(18,138),(18,139),(18,140),(18,141),(18,142),(18,143),(18,144),(18,145),(18,146),(18,147),(18,148),(18,149),(18,150),(18,151),(18,152),(18,153),(18,154),(18,155),(18,156),(18,157),(18,158),(18,159),(18,160),(18,161),(18,162),(18,163),(18,164),(18,165),(18,166),(18,167),(18,168),(18,169),(18,170),(18,171),(18,172),(18,173),(18,174),(18,175),(18,176),(18,177),(18,178),(18,179),(18,180),(18,181),(18,182),(18,183),(18,184),(18,185),(18,186),(18,187),(18,188),(18,189),(18,190),(18,191),(18,192),(18,193),(18,194),(18,195),(18,196),(18,197),(18,198),(18,199),(18,200),(18,201),(18,202),(18,203),(18,204),(18,205),(18,206),(18,207),(18,208),(18,209),(18,210),(18,211),(18,212),(18,213),(18,214),(18,215),(18,216),(18,217),(18,218),(18,219),(18,220),(18,221),(18,222),(18,223),(18,224),(18,225),(18,226),(18,227),(18,228),(18,229),(18,230),(18,231),(18,232),(18,233),(18,234),(18,235),(18,236),(18,237),(18,238),(18,239),(18,240),(18,241),(18,242),(18,243),(18,244),(18,245),(18,246),(18,247),(18,248),(18,249),(18,250),(18,251),(18,252),(18,253),(18,254),(18,255),(18,256),(18,257),(18,258),(18,259),(18,260),(18,261),(18,262),(18,263),(18,264),(18,265),(18,266),(18,267),(18,268),(18,269),(18,270),(18,271),(18,272),(18,273),(18,274),(18,275),(18,276),(18,277),(18,278),(18,279),(18,280),(18,281),(18,282),(18,283),(18,284),(18,285),(18,286),(18,287),(18,288),(18,289),(18,290),(18,291),(18,292),(18,293),(18,294),(18,295),(18,296),(18,297),(18,298),(18,299),(18,300),(18,301),(18,302),(18,303),(18,304),(18,305),(18,306),(18,307),(18,308),(18,309),(18,310),(18,311),(18,312),(18,313),(18,314),(18,315),(18,316),(18,317),(18,318),(18,319),(18,320),(18,321),(18,322),(18,323),(18,324),(18,325),(18,326),(18,327),(18,328),(18,329),(18,330),(18,331),(18,332),(18,333),(18,334),(18,335),(18,336),(18,337),(18,338),(18,339),(18,340),(18,341),(18,342),(18,343),(18,344),(18,345),(18,346),(18,347),(18,348),(18,349),(18,350),(18,351),(18,352),(18,353),(18,354),(18,355),(18,356),(18,357),(18,358),(18,359),(18,360),(18,361),(18,362),(18,363),(18,364),(18,365),(18,366),(18,367),(18,368),(18,369),(18,370),(18,371),(18,372),(18,373),(18,374),(18,375),(18,376),(18,377),(18,378),(18,379),(18,380),(18,381),(18,382),(18,383),(18,384),(19,9),(19,10),(19,11),(19,12),(19,13),(19,14),(19,15),(19,16),(19,81),(19,82),(19,83),(19,84),(19,85),(19,86),(19,87),(19,88),(19,89),(19,90),(19,91),(19,92),(19,93),(19,94),(19,95),(19,96),(19,97),(19,98),(19,99),(19,100),(19,101),(19,102),(19,103),(19,104),(19,105),(19,106),(19,107),(19,108),(19,109),(19,110),(19,111),(19,112),(19,113),(19,114),(19,115),(19,116),(19,117),(19,118),(19,119),(19,120),(19,121),(19,122),(19,123),(19,124),(19,125),(19,126),(19,127),(19,128),(19,129),(19,130),(19,131),(19,132),(19,133),(19,134),(19,135),(19,136),(19,137),(19,138),(19,139),(19,140),(19,141),(19,142),(19,143),(19,144),(19,145),(19,146),(19,147),(19,148),(19,149),(19,150),(19,151),(19,152),(19,153),(19,154),(19,155),(19,156),(19,157),(19,158),(19,159),(19,160),(19,161),(19,162),(19,163),(19,164),(19,165),(19,166),(19,167),(19,168),(19,169),(19,170),(19,171),(19,172),(19,173),(19,174),(19,175),(19,176),(19,177),(19,178),(19,179),(19,180),(19,181),(19,182),(19,183),(19,184),(19,185),(19,186),(19,187),(19,188);
/*!40000 ALTER TABLE `gantt_jobs_resources_visu` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `job_dependencies`
--

DROP TABLE IF EXISTS `job_dependencies`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `job_dependencies` (
  `job_id` int(10) unsigned NOT NULL,
  `job_id_required` int(10) unsigned NOT NULL,
  `job_dependency_index` enum('CURRENT','LOG') NOT NULL default 'CURRENT',
  PRIMARY KEY  (`job_id`,`job_id_required`),
  KEY `id` (`job_id`),
  KEY `log` (`job_dependency_index`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `job_dependencies`
--

LOCK TABLES `job_dependencies` WRITE;
/*!40000 ALTER TABLE `job_dependencies` DISABLE KEYS */;
/*!40000 ALTER TABLE `job_dependencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `job_resource_descriptions`
--

DROP TABLE IF EXISTS `job_resource_descriptions`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `job_resource_descriptions` (
  `res_job_group_id` int(10) unsigned NOT NULL,
  `res_job_resource_type` varchar(255) NOT NULL,
  `res_job_value` int(11) NOT NULL,
  `res_job_order` int(10) unsigned NOT NULL default '0',
  `res_job_index` enum('CURRENT','LOG') NOT NULL default 'CURRENT',
  PRIMARY KEY  (`res_job_group_id`,`res_job_resource_type`,`res_job_order`),
  KEY `resgroup` (`res_job_group_id`),
  KEY `log` (`res_job_index`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `job_resource_descriptions`
--

LOCK TABLES `job_resource_descriptions` WRITE;
/*!40000 ALTER TABLE `job_resource_descriptions` DISABLE KEYS */;
INSERT INTO `job_resource_descriptions` VALUES (1,'resource_id',-1,0,'CURRENT'),(2,'host',48,0,'CURRENT'),(3,'host',83,0,'CURRENT'),(4,'host',54,0,'CURRENT'),(5,'host',88,0,'CURRENT'),(6,'host',59,0,'CURRENT'),(7,'host',93,0,'CURRENT'),(8,'host',64,0,'CURRENT'),(9,'host',3,0,'CURRENT'),(10,'host',69,0,'CURRENT'),(11,'host',8,0,'CURRENT'),(12,'host',74,0,'CURRENT'),(13,'host',13,0,'CURRENT'),(14,'host',80,0,'CURRENT'),(15,'host',18,0,'CURRENT'),(16,'host',85,0,'CURRENT'),(17,'host',23,0,'CURRENT'),(18,'host',90,0,'CURRENT'),(19,'host',29,0,'CURRENT'),(20,'host',95,0,'CURRENT'),(21,'host',34,0,'CURRENT'),(22,'host',5,0,'CURRENT'),(23,'host',39,0,'CURRENT'),(24,'host',10,0,'CURRENT'),(25,'host',44,0,'CURRENT'),(26,'host',79,0,'CURRENT'),(27,'host',50,0,'CURRENT'),(28,'host',55,0,'CURRENT'),(29,'host',89,0,'CURRENT'),(30,'host',60,0,'CURRENT'),(31,'host',95,0,'CURRENT'),(32,'host',65,0,'CURRENT'),(33,'host',4,0,'CURRENT'),(34,'host',70,0,'CURRENT'),(35,'host',9,0,'CURRENT'),(36,'host',76,0,'CURRENT'),(37,'host',14,0,'CURRENT'),(38,'host',81,0,'CURRENT'),(39,'host',19,0,'CURRENT'),(40,'host',86,0,'CURRENT'),(41,'host',25,0,'CURRENT'),(42,'host',91,0,'CURRENT'),(43,'host',30,0,'CURRENT'),(44,'host',96,0,'CURRENT'),(45,'host',35,0,'CURRENT'),(46,'host',6,0,'CURRENT'),(47,'host',40,0,'CURRENT'),(48,'host',75,0,'CURRENT'),(49,'host',45,0,'CURRENT'),(50,'host',80,0,'CURRENT'),(51,'host',51,0,'CURRENT'),(52,'host',85,0,'CURRENT'),(53,'host',56,0,'CURRENT'),(54,'host',90,0,'CURRENT'),(55,'host',61,0,'CURRENT'),(56,'host',96,0,'CURRENT'),(57,'host',66,0,'CURRENT'),(58,'host',5,0,'CURRENT'),(59,'host',71,0,'CURRENT'),(60,'host',10,0,'CURRENT'),(61,'host',77,0,'CURRENT'),(62,'host',15,0,'CURRENT'),(63,'host',82,0,'CURRENT'),(64,'host',20,0,'CURRENT'),(65,'host',87,0,'CURRENT'),(66,'host',26,0,'CURRENT'),(67,'host',92,0,'CURRENT'),(68,'host',31,0,'CURRENT'),(69,'host',1,0,'CURRENT'),(70,'host',36,0,'CURRENT'),(71,'host',7,0,'CURRENT'),(72,'host',41,0,'CURRENT'),(73,'host',76,0,'CURRENT'),(74,'host',46,0,'CURRENT'),(75,'host',81,0,'CURRENT'),(76,'host',52,0,'CURRENT'),(77,'host',86,0,'CURRENT'),(78,'host',57,0,'CURRENT'),(79,'host',91,0,'CURRENT'),(80,'host',62,0,'CURRENT'),(81,'host',1,0,'CURRENT'),(82,'host',67,0,'CURRENT'),(83,'host',6,0,'CURRENT'),(84,'host',73,0,'CURRENT'),(85,'host',11,0,'CURRENT'),(86,'host',78,0,'CURRENT'),(87,'host',16,0,'CURRENT'),(88,'host',83,0,'CURRENT'),(89,'host',22,0,'CURRENT'),(90,'host',88,0,'CURRENT'),(91,'host',27,0,'CURRENT'),(92,'host',93,0,'CURRENT'),(93,'host',32,0,'CURRENT'),(94,'host',3,0,'CURRENT'),(95,'host',37,0,'CURRENT'),(96,'host',8,0,'CURRENT'),(97,'host',42,0,'CURRENT'),(98,'host',77,0,'CURRENT'),(99,'host',48,0,'CURRENT'),(100,'host',82,0,'CURRENT'),(101,'host',53,0,'CURRENT');
/*!40000 ALTER TABLE `job_resource_descriptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `job_resource_groups`
--

DROP TABLE IF EXISTS `job_resource_groups`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `job_resource_groups` (
  `res_group_id` int(10) unsigned NOT NULL auto_increment,
  `res_group_moldable_id` int(10) unsigned NOT NULL,
  `res_group_property` text,
  `res_group_index` enum('CURRENT','LOG') NOT NULL default 'CURRENT',
  PRIMARY KEY  (`res_group_id`),
  KEY `moldable_job` (`res_group_moldable_id`),
  KEY `log` (`res_group_index`)
) ENGINE=MyISAM AUTO_INCREMENT=102 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `job_resource_groups`
--

LOCK TABLES `job_resource_groups` WRITE;
/*!40000 ALTER TABLE `job_resource_groups` DISABLE KEYS */;
INSERT INTO `job_resource_groups` VALUES (1,1,'type = \'default\'','CURRENT'),(2,2,'type = \'default\'','CURRENT'),(3,3,'type = \'default\'','CURRENT'),(4,4,'type = \'default\'','CURRENT'),(5,5,'type = \'default\'','CURRENT'),(6,6,'type = \'default\'','CURRENT'),(7,7,'type = \'default\'','CURRENT'),(8,8,'type = \'default\'','CURRENT'),(9,9,'type = \'default\'','CURRENT'),(10,10,'type = \'default\'','CURRENT'),(11,11,'type = \'default\'','CURRENT'),(12,12,'type = \'default\'','CURRENT'),(13,13,'type = \'default\'','CURRENT'),(14,14,'type = \'default\'','CURRENT'),(15,15,'type = \'default\'','CURRENT'),(16,16,'type = \'default\'','CURRENT'),(17,17,'type = \'default\'','CURRENT'),(18,18,'type = \'default\'','CURRENT'),(19,19,'type = \'default\'','CURRENT'),(20,20,'type = \'default\'','CURRENT'),(21,21,'type = \'default\'','CURRENT'),(22,22,'type = \'default\'','CURRENT'),(23,23,'type = \'default\'','CURRENT'),(24,24,'type = \'default\'','CURRENT'),(25,25,'type = \'default\'','CURRENT'),(26,26,'type = \'default\'','CURRENT'),(27,27,'type = \'default\'','CURRENT'),(28,28,'type = \'default\'','CURRENT'),(29,29,'type = \'default\'','CURRENT'),(30,30,'type = \'default\'','CURRENT'),(31,31,'type = \'default\'','CURRENT'),(32,32,'type = \'default\'','CURRENT'),(33,33,'type = \'default\'','CURRENT'),(34,34,'type = \'default\'','CURRENT'),(35,35,'type = \'default\'','CURRENT'),(36,36,'type = \'default\'','CURRENT'),(37,37,'type = \'default\'','CURRENT'),(38,38,'type = \'default\'','CURRENT'),(39,39,'type = \'default\'','CURRENT'),(40,40,'type = \'default\'','CURRENT'),(41,41,'type = \'default\'','CURRENT'),(42,42,'type = \'default\'','CURRENT'),(43,43,'type = \'default\'','CURRENT'),(44,44,'type = \'default\'','CURRENT'),(45,45,'type = \'default\'','CURRENT'),(46,46,'type = \'default\'','CURRENT'),(47,47,'type = \'default\'','CURRENT'),(48,48,'type = \'default\'','CURRENT'),(49,49,'type = \'default\'','CURRENT'),(50,50,'type = \'default\'','CURRENT'),(51,51,'type = \'default\'','CURRENT'),(52,52,'type = \'default\'','CURRENT'),(53,53,'type = \'default\'','CURRENT'),(54,54,'type = \'default\'','CURRENT'),(55,55,'type = \'default\'','CURRENT'),(56,56,'type = \'default\'','CURRENT'),(57,57,'type = \'default\'','CURRENT'),(58,58,'type = \'default\'','CURRENT'),(59,59,'type = \'default\'','CURRENT'),(60,60,'type = \'default\'','CURRENT'),(61,61,'type = \'default\'','CURRENT'),(62,62,'type = \'default\'','CURRENT'),(63,63,'type = \'default\'','CURRENT'),(64,64,'type = \'default\'','CURRENT'),(65,65,'type = \'default\'','CURRENT'),(66,66,'type = \'default\'','CURRENT'),(67,67,'type = \'default\'','CURRENT'),(68,68,'type = \'default\'','CURRENT'),(69,69,'type = \'default\'','CURRENT'),(70,70,'type = \'default\'','CURRENT'),(71,71,'type = \'default\'','CURRENT'),(72,72,'type = \'default\'','CURRENT'),(73,73,'type = \'default\'','CURRENT'),(74,74,'type = \'default\'','CURRENT'),(75,75,'type = \'default\'','CURRENT'),(76,76,'type = \'default\'','CURRENT'),(77,77,'type = \'default\'','CURRENT'),(78,78,'type = \'default\'','CURRENT'),(79,79,'type = \'default\'','CURRENT'),(80,80,'type = \'default\'','CURRENT'),(81,81,'type = \'default\'','CURRENT'),(82,82,'type = \'default\'','CURRENT'),(83,83,'type = \'default\'','CURRENT'),(84,84,'type = \'default\'','CURRENT'),(85,85,'type = \'default\'','CURRENT'),(86,86,'type = \'default\'','CURRENT'),(87,87,'type = \'default\'','CURRENT'),(88,88,'type = \'default\'','CURRENT'),(89,89,'type = \'default\'','CURRENT'),(90,90,'type = \'default\'','CURRENT'),(91,91,'type = \'default\'','CURRENT'),(92,92,'type = \'default\'','CURRENT'),(93,93,'type = \'default\'','CURRENT'),(94,94,'type = \'default\'','CURRENT'),(95,95,'type = \'default\'','CURRENT'),(96,96,'type = \'default\'','CURRENT'),(97,97,'type = \'default\'','CURRENT'),(98,98,'type = \'default\'','CURRENT'),(99,99,'type = \'default\'','CURRENT'),(100,100,'type = \'default\'','CURRENT'),(101,101,'type = \'default\'','CURRENT');
/*!40000 ALTER TABLE `job_resource_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `job_state_logs`
--

DROP TABLE IF EXISTS `job_state_logs`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `job_state_logs` (
  `job_state_log_id` int(10) unsigned NOT NULL auto_increment,
  `job_id` int(10) unsigned NOT NULL,
  `job_state` enum('Waiting','Hold','toLaunch','toError','toAckReservation','Launching','Finishing','Running','Suspended','Resuming','Terminated','Error') NOT NULL,
  `date_start` int(10) unsigned NOT NULL,
  `date_stop` int(10) unsigned default '0',
  PRIMARY KEY  (`job_state_log_id`),
  KEY `id` (`job_id`),
  KEY `state` (`job_state`)
) ENGINE=MyISAM AUTO_INCREMENT=105 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `job_state_logs`
--

LOCK TABLES `job_state_logs` WRITE;
/*!40000 ALTER TABLE `job_state_logs` DISABLE KEYS */;
INSERT INTO `job_state_logs` VALUES (1,1,'Waiting',1224778627,1224778628),(2,1,'toLaunch',1224778628,1224778628),(3,1,'Launching',1224778628,1224778629),(4,1,'Running',1224778629,0),(5,2,'Waiting',1224778637,0),(6,3,'Waiting',1224778638,0),(7,4,'Waiting',1224778639,0),(8,5,'Waiting',1224778640,0),(9,6,'Waiting',1224778640,0),(10,7,'Waiting',1224778641,0),(11,8,'Waiting',1224778642,0),(12,9,'Waiting',1224778642,0),(13,10,'Waiting',1224778643,0),(14,11,'Waiting',1224778644,0),(15,12,'Waiting',1224778645,0),(16,13,'Waiting',1224778645,0),(17,14,'Waiting',1224778646,0),(18,15,'Waiting',1224778647,0),(19,16,'Waiting',1224778647,0),(20,17,'Waiting',1224778648,0),(21,18,'Waiting',1224778648,0),(22,19,'Waiting',1224778649,0),(23,20,'Waiting',1224778650,0),(24,21,'Waiting',1224778650,0),(25,22,'Waiting',1224778651,0),(26,23,'Waiting',1224778652,0),(27,24,'Waiting',1224778652,0),(28,25,'Waiting',1224778653,0),(29,26,'Waiting',1224778653,0),(30,27,'Waiting',1224778654,0),(31,28,'Waiting',1224778655,0),(32,29,'Waiting',1224778655,0),(33,30,'Waiting',1224778656,0),(34,31,'Waiting',1224778657,0),(35,32,'Waiting',1224778657,0),(36,33,'Waiting',1224778658,0),(37,34,'Waiting',1224778658,0),(38,35,'Waiting',1224778659,0),(39,36,'Waiting',1224778660,0),(40,37,'Waiting',1224778660,0),(41,38,'Waiting',1224778661,0),(42,39,'Waiting',1224778661,0),(43,40,'Waiting',1224778662,0),(44,41,'Waiting',1224778663,0),(45,42,'Waiting',1224778663,0),(46,43,'Waiting',1224778664,0),(47,44,'Waiting',1224778665,0),(48,45,'Waiting',1224778665,0),(49,46,'Waiting',1224778666,0),(50,47,'Waiting',1224778666,0),(51,48,'Waiting',1224778667,0),(52,49,'Waiting',1224778668,0),(53,50,'Waiting',1224778668,0),(54,51,'Waiting',1224778669,0),(55,52,'Waiting',1224778669,0),(56,53,'Waiting',1224778670,0),(57,54,'Waiting',1224778671,0),(58,55,'Waiting',1224778671,0),(59,56,'Waiting',1224778672,0),(60,57,'Waiting',1224778673,0),(61,58,'Waiting',1224778673,0),(62,59,'Waiting',1224778674,0),(63,60,'Waiting',1224778674,0),(64,61,'Waiting',1224778675,0),(65,62,'Waiting',1224778676,0),(66,63,'Waiting',1224778676,0),(67,64,'Waiting',1224778677,0),(68,65,'Waiting',1224778678,0),(69,66,'Waiting',1224778678,0),(70,67,'Waiting',1224778679,0),(71,68,'Waiting',1224778680,0),(72,69,'Waiting',1224778680,0),(73,70,'Waiting',1224778681,0),(74,71,'Waiting',1224778681,0),(75,72,'Waiting',1224778682,0),(76,73,'Waiting',1224778683,0),(77,74,'Waiting',1224778683,0),(78,75,'Waiting',1224778684,0),(79,76,'Waiting',1224778684,0),(80,77,'Waiting',1224778685,0),(81,78,'Waiting',1224778686,0),(82,79,'Waiting',1224778686,0),(83,80,'Waiting',1224778687,0),(84,81,'Waiting',1224778688,0),(85,82,'Waiting',1224778688,0),(86,83,'Waiting',1224778689,0),(87,84,'Waiting',1224778689,0),(88,85,'Waiting',1224778690,0),(89,86,'Waiting',1224778691,0),(90,87,'Waiting',1224778691,0),(91,88,'Waiting',1224778692,0),(92,89,'Waiting',1224778692,0),(93,90,'Waiting',1224778693,0),(94,91,'Waiting',1224778694,0),(95,92,'Waiting',1224778694,0),(96,93,'Waiting',1224778695,0),(97,94,'Waiting',1224778696,0),(98,95,'Waiting',1224778696,0),(99,96,'Waiting',1224778697,0),(100,97,'Waiting',1224778697,0),(101,98,'Waiting',1224778698,0),(102,99,'Waiting',1224778699,0),(103,100,'Waiting',1224778699,0),(104,101,'Waiting',1224778700,0);
/*!40000 ALTER TABLE `job_state_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `job_types`
--

DROP TABLE IF EXISTS `job_types`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `job_types` (
  `job_type_id` int(10) unsigned NOT NULL auto_increment,
  `job_id` int(10) unsigned NOT NULL,
  `type` varchar(255) NOT NULL,
  `types_index` enum('CURRENT','LOG') NOT NULL default 'CURRENT',
  PRIMARY KEY  (`job_type_id`),
  KEY `log` (`types_index`),
  KEY `type` (`type`),
  KEY `id_types` (`job_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `job_types`
--

LOCK TABLES `job_types` WRITE;
/*!40000 ALTER TABLE `job_types` DISABLE KEYS */;
INSERT INTO `job_types` VALUES (1,1,'cosystem','CURRENT');
/*!40000 ALTER TABLE `job_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `jobs` (
  `job_id` int(10) unsigned NOT NULL auto_increment,
  `initial_request` text,
  `job_name` varchar(100) default NULL,
  `job_env` text,
  `job_type` enum('INTERACTIVE','PASSIVE') NOT NULL default 'PASSIVE',
  `info_type` varchar(255) default NULL,
  `state` enum('Waiting','Hold','toLaunch','toError','toAckReservation','Launching','Running','Suspended','Resuming','Finishing','Terminated','Error') NOT NULL,
  `reservation` enum('None','toSchedule','Scheduled') NOT NULL default 'None',
  `message` varchar(255) NOT NULL,
  `scheduler_info` varchar(255) NOT NULL,
  `job_user` varchar(255) NOT NULL,
  `project` varchar(255) NOT NULL,
  `job_group` varchar(255) NOT NULL,
  `command` text,
  `exit_code` int(11) default NULL,
  `queue_name` varchar(100) NOT NULL,
  `properties` text,
  `launching_directory` text NOT NULL,
  `submission_time` int(10) unsigned NOT NULL,
  `start_time` int(10) unsigned NOT NULL,
  `stop_time` int(10) unsigned NOT NULL,
  `file_id` int(10) unsigned default NULL,
  `accounted` enum('YES','NO') NOT NULL default 'NO',
  `notify` varchar(255) default NULL,
  `assigned_moldable_job` int(10) unsigned default '0',
  `checkpoint` int(10) unsigned NOT NULL default '0',
  `checkpoint_signal` int(11) NOT NULL,
  `stdout_file` text,
  `stderr_file` text,
  `resubmit_job_id` int(10) unsigned default '0',
  `suspended` enum('YES','NO') NOT NULL default 'NO',
  PRIMARY KEY  (`job_id`),
  KEY `state` (`state`),
  KEY `state_id` (`state`,`job_id`),
  KEY `reservation` (`reservation`),
  KEY `queue_name` (`queue_name`),
  KEY `accounted` (`accounted`),
  KEY `suspended` (`suspended`)
) ENGINE=MyISAM AUTO_INCREMENT=102 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
INSERT INTO `jobs` VALUES (1,'oarsub -l nodes=ALL,walltime=4 -t cosystem sleep 14400',NULL,NULL,'PASSIVE','caigang:','Running','None','FIFO scheduling OK','FIFO scheduling OK','neyron','default','','sleep 14400',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778627,1224778628,0,NULL,'NO',NULL,1,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(2,'oarsub -l host=48,walltime=9 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','FIFO scheduling OK','FIFO scheduling OK','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778637,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(3,'oarsub -l host=83,walltime=5 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','FIFO scheduling OK','FIFO scheduling OK','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778638,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(4,'oarsub -l host=54,walltime=10 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','FIFO scheduling OK','FIFO scheduling OK','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778639,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(5,'oarsub -l host=88,walltime=6 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','FIFO scheduling OK','FIFO scheduling OK','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778640,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(6,'oarsub -l host=59,walltime=2 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','FIFO scheduling OK','FIFO scheduling OK','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778640,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(7,'oarsub -l host=93,walltime=8 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','FIFO scheduling OK','FIFO scheduling OK','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778641,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(8,'oarsub -l host=64,walltime=3 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','FIFO scheduling OK','FIFO scheduling OK','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778642,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(9,'oarsub -l host=3,walltime=9 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','FIFO scheduling OK','FIFO scheduling OK','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778642,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(10,'oarsub -l host=69,walltime=5 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','FIFO scheduling OK','FIFO scheduling OK','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778643,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(11,'oarsub -l host=8,walltime=1 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','FIFO scheduling OK','FIFO scheduling OK','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778644,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(12,'oarsub -l host=74,walltime=6 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','FIFO scheduling OK','FIFO scheduling OK','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778645,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(13,'oarsub -l host=13,walltime=2 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','FIFO scheduling OK','FIFO scheduling OK','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778645,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(14,'oarsub -l host=80,walltime=8 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','FIFO scheduling OK','FIFO scheduling OK','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778646,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(15,'oarsub -l host=18,walltime=4 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','FIFO scheduling OK','FIFO scheduling OK','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778647,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(16,'oarsub -l host=85,walltime=9 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','FIFO scheduling OK','FIFO scheduling OK','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778647,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(17,'oarsub -l host=23,walltime=5 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','FIFO scheduling OK','FIFO scheduling OK','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778648,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(18,'oarsub -l host=90,walltime=1 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','FIFO scheduling OK','FIFO scheduling OK','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778648,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(19,'oarsub -l host=29,walltime=6 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','FIFO scheduling OK','FIFO scheduling OK','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778649,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(20,'oarsub -l host=95,walltime=2 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 20','Cannot find enough resources which fit for the job 20','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778650,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(21,'oarsub -l host=34,walltime=8 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 21','Cannot find enough resources which fit for the job 21','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778650,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(22,'oarsub -l host=5,walltime=4 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 22','Cannot find enough resources which fit for the job 22','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778651,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(23,'oarsub -l host=39,walltime=9 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 23','Cannot find enough resources which fit for the job 23','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778652,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(24,'oarsub -l host=10,walltime=5 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 24','Cannot find enough resources which fit for the job 24','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778652,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(25,'oarsub -l host=44,walltime=1 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 25','Cannot find enough resources which fit for the job 25','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778653,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(26,'oarsub -l host=79,walltime=7 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 26','Cannot find enough resources which fit for the job 26','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778653,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(27,'oarsub -l host=50,walltime=2 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 27','Cannot find enough resources which fit for the job 27','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778654,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(28,'oarsub -l host=55,walltime=4 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 28','Cannot find enough resources which fit for the job 28','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778655,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(29,'oarsub -l host=89,walltime=10 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 29','Cannot find enough resources which fit for the job 29','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778655,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(30,'oarsub -l host=60,walltime=5 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 30','Cannot find enough resources which fit for the job 30','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778656,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(31,'oarsub -l host=95,walltime=1 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 31','Cannot find enough resources which fit for the job 31','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778657,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(32,'oarsub -l host=65,walltime=7 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 32','Cannot find enough resources which fit for the job 32','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778657,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(33,'oarsub -l host=4,walltime=5 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 33','Cannot find enough resources which fit for the job 33','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778658,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(34,'oarsub -l host=70,walltime=10 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 34','Cannot find enough resources which fit for the job 34','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778658,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(35,'oarsub -l host=9,walltime=6 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 35','Cannot find enough resources which fit for the job 35','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778659,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(36,'oarsub -l host=76,walltime=2 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 36','Cannot find enough resources which fit for the job 36','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778660,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(37,'oarsub -l host=14,walltime=7 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 37','Cannot find enough resources which fit for the job 37','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778660,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(38,'oarsub -l host=81,walltime=3 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 38','Cannot find enough resources which fit for the job 38','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778661,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(39,'oarsub -l host=19,walltime=9 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 39','Cannot find enough resources which fit for the job 39','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778661,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(40,'oarsub -l host=86,walltime=5 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 40','Cannot find enough resources which fit for the job 40','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778662,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(41,'oarsub -l host=25,walltime=10 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 41','Cannot find enough resources which fit for the job 41','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778663,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(42,'oarsub -l host=91,walltime=6 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 42','Cannot find enough resources which fit for the job 42','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778663,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(43,'oarsub -l host=30,walltime=2 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 43','Cannot find enough resources which fit for the job 43','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778664,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(44,'oarsub -l host=96,walltime=8 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 44','Cannot find enough resources which fit for the job 44','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778665,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(45,'oarsub -l host=35,walltime=3 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 45','Cannot find enough resources which fit for the job 45','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778665,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(46,'oarsub -l host=6,walltime=9 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 46','Cannot find enough resources which fit for the job 46','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778666,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(47,'oarsub -l host=40,walltime=5 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 47','Cannot find enough resources which fit for the job 47','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778666,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(48,'oarsub -l host=75,walltime=1 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 48','Cannot find enough resources which fit for the job 48','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778667,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(49,'oarsub -l host=45,walltime=6 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 49','Cannot find enough resources which fit for the job 49','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778668,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(50,'oarsub -l host=80,walltime=2 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 50','Cannot find enough resources which fit for the job 50','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778668,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(51,'oarsub -l host=51,walltime=8 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 51','Cannot find enough resources which fit for the job 51','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778669,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(52,'oarsub -l host=85,walltime=4 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 52','Cannot find enough resources which fit for the job 52','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778669,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(53,'oarsub -l host=56,walltime=9 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 53','Cannot find enough resources which fit for the job 53','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778670,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(54,'oarsub -l host=90,walltime=5 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 54','Cannot find enough resources which fit for the job 54','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778671,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(55,'oarsub -l host=61,walltime=1 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 55','Cannot find enough resources which fit for the job 55','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778671,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(56,'oarsub -l host=96,walltime=6 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 56','Cannot find enough resources which fit for the job 56','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778672,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(57,'oarsub -l host=66,walltime=2 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 57','Cannot find enough resources which fit for the job 57','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778673,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(58,'oarsub -l host=5,walltime=8 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 58','Cannot find enough resources which fit for the job 58','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778673,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(59,'oarsub -l host=71,walltime=4 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 59','Cannot find enough resources which fit for the job 59','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778674,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(60,'oarsub -l host=10,walltime=9 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 60','Cannot find enough resources which fit for the job 60','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778674,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(61,'oarsub -l host=77,walltime=5 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 61','Cannot find enough resources which fit for the job 61','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778675,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(62,'oarsub -l host=15,walltime=1 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 62','Cannot find enough resources which fit for the job 62','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778676,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(63,'oarsub -l host=82,walltime=7 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 63','Cannot find enough resources which fit for the job 63','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778676,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(64,'oarsub -l host=20,walltime=2 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 64','Cannot find enough resources which fit for the job 64','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778677,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(65,'oarsub -l host=87,walltime=8 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 65','Cannot find enough resources which fit for the job 65','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778678,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(66,'oarsub -l host=26,walltime=4 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','Cannot find enough resources which fit for the job 66','Cannot find enough resources which fit for the job 66','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778678,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(67,'oarsub -l host=92,walltime=10 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778679,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(68,'oarsub -l host=31,walltime=5 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778680,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(69,'oarsub -l host=1,walltime=1 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778680,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(70,'oarsub -l host=36,walltime=7 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778681,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(71,'oarsub -l host=7,walltime=3 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778681,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(72,'oarsub -l host=41,walltime=8 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778682,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(73,'oarsub -l host=76,walltime=4 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778683,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(74,'oarsub -l host=46,walltime=10 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778683,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(75,'oarsub -l host=81,walltime=5 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778684,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(76,'oarsub -l host=52,walltime=1 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778684,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(77,'oarsub -l host=86,walltime=7 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778685,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(78,'oarsub -l host=57,walltime=3 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778686,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(79,'oarsub -l host=91,walltime=8 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778686,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(80,'oarsub -l host=62,walltime=4 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778687,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(81,'oarsub -l host=1,walltime=10 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778688,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(82,'oarsub -l host=67,walltime=6 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778688,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(83,'oarsub -l host=6,walltime=1 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778689,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(84,'oarsub -l host=73,walltime=7 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778689,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(85,'oarsub -l host=11,walltime=3 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778690,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(86,'oarsub -l host=78,walltime=9 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778691,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(87,'oarsub -l host=16,walltime=4 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778691,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(88,'oarsub -l host=83,walltime=10 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778692,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(89,'oarsub -l host=22,walltime=6 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778692,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(90,'oarsub -l host=88,walltime=2 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778693,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(91,'oarsub -l host=27,walltime=7 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778694,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(92,'oarsub -l host=93,walltime=3 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778694,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(93,'oarsub -l host=32,walltime=9 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778695,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(94,'oarsub -l host=3,walltime=4 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778696,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(95,'oarsub -l host=37,walltime=10 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778696,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(96,'oarsub -l host=8,walltime=6 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778697,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(97,'oarsub -l host=42,walltime=2 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778697,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(98,'oarsub -l host=77,walltime=7 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778698,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(99,'oarsub -l host=48,walltime=3 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778699,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(100,'oarsub -l host=82,walltime=9 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778699,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO'),(101,'oarsub -l host=53,walltime=5 sleep 3600',NULL,NULL,'PASSIVE','caigang:','Waiting','None','','','neyron','default','','sleep 3600',NULL,'default','desktop_computing = \'NO\'','/home/neyron',1224778700,0,0,NULL,'NO',NULL,0,0,12,'OAR.%jobid%.stdout','OAR.%jobid%.stderr',0,'NO');
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `moldable_job_descriptions`
--

DROP TABLE IF EXISTS `moldable_job_descriptions`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `moldable_job_descriptions` (
  `moldable_id` int(10) unsigned NOT NULL auto_increment,
  `moldable_job_id` int(10) unsigned NOT NULL,
  `moldable_walltime` int(10) unsigned NOT NULL,
  `moldable_index` enum('CURRENT','LOG') NOT NULL default 'CURRENT',
  PRIMARY KEY  (`moldable_id`),
  KEY `job` (`moldable_job_id`),
  KEY `log` (`moldable_index`)
) ENGINE=MyISAM AUTO_INCREMENT=102 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `moldable_job_descriptions`
--

LOCK TABLES `moldable_job_descriptions` WRITE;
/*!40000 ALTER TABLE `moldable_job_descriptions` DISABLE KEYS */;
INSERT INTO `moldable_job_descriptions` VALUES (1,1,14400,'CURRENT'),(2,2,32400,'CURRENT'),(3,3,18000,'CURRENT'),(4,4,36000,'CURRENT'),(5,5,21600,'CURRENT'),(6,6,7200,'CURRENT'),(7,7,28800,'CURRENT'),(8,8,10800,'CURRENT'),(9,9,32400,'CURRENT'),(10,10,18000,'CURRENT'),(11,11,3600,'CURRENT'),(12,12,21600,'CURRENT'),(13,13,7200,'CURRENT'),(14,14,28800,'CURRENT'),(15,15,14400,'CURRENT'),(16,16,32400,'CURRENT'),(17,17,18000,'CURRENT'),(18,18,3600,'CURRENT'),(19,19,21600,'CURRENT'),(20,20,7200,'CURRENT'),(21,21,28800,'CURRENT'),(22,22,14400,'CURRENT'),(23,23,32400,'CURRENT'),(24,24,18000,'CURRENT'),(25,25,3600,'CURRENT'),(26,26,25200,'CURRENT'),(27,27,7200,'CURRENT'),(28,28,14400,'CURRENT'),(29,29,36000,'CURRENT'),(30,30,18000,'CURRENT'),(31,31,3600,'CURRENT'),(32,32,25200,'CURRENT'),(33,33,18000,'CURRENT'),(34,34,36000,'CURRENT'),(35,35,21600,'CURRENT'),(36,36,7200,'CURRENT'),(37,37,25200,'CURRENT'),(38,38,10800,'CURRENT'),(39,39,32400,'CURRENT'),(40,40,18000,'CURRENT'),(41,41,36000,'CURRENT'),(42,42,21600,'CURRENT'),(43,43,7200,'CURRENT'),(44,44,28800,'CURRENT'),(45,45,10800,'CURRENT'),(46,46,32400,'CURRENT'),(47,47,18000,'CURRENT'),(48,48,3600,'CURRENT'),(49,49,21600,'CURRENT'),(50,50,7200,'CURRENT'),(51,51,28800,'CURRENT'),(52,52,14400,'CURRENT'),(53,53,32400,'CURRENT'),(54,54,18000,'CURRENT'),(55,55,3600,'CURRENT'),(56,56,21600,'CURRENT'),(57,57,7200,'CURRENT'),(58,58,28800,'CURRENT'),(59,59,14400,'CURRENT'),(60,60,32400,'CURRENT'),(61,61,18000,'CURRENT'),(62,62,3600,'CURRENT'),(63,63,25200,'CURRENT'),(64,64,7200,'CURRENT'),(65,65,28800,'CURRENT'),(66,66,14400,'CURRENT'),(67,67,36000,'CURRENT'),(68,68,18000,'CURRENT'),(69,69,3600,'CURRENT'),(70,70,25200,'CURRENT'),(71,71,10800,'CURRENT'),(72,72,28800,'CURRENT'),(73,73,14400,'CURRENT'),(74,74,36000,'CURRENT'),(75,75,18000,'CURRENT'),(76,76,3600,'CURRENT'),(77,77,25200,'CURRENT'),(78,78,10800,'CURRENT'),(79,79,28800,'CURRENT'),(80,80,14400,'CURRENT'),(81,81,36000,'CURRENT'),(82,82,21600,'CURRENT'),(83,83,3600,'CURRENT'),(84,84,25200,'CURRENT'),(85,85,10800,'CURRENT'),(86,86,32400,'CURRENT'),(87,87,14400,'CURRENT'),(88,88,36000,'CURRENT'),(89,89,21600,'CURRENT'),(90,90,7200,'CURRENT'),(91,91,25200,'CURRENT'),(92,92,10800,'CURRENT'),(93,93,32400,'CURRENT'),(94,94,14400,'CURRENT'),(95,95,36000,'CURRENT'),(96,96,21600,'CURRENT'),(97,97,7200,'CURRENT'),(98,98,25200,'CURRENT'),(99,99,10800,'CURRENT'),(100,100,32400,'CURRENT'),(101,101,18000,'CURRENT');
/*!40000 ALTER TABLE `moldable_job_descriptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `queues`
--

DROP TABLE IF EXISTS `queues`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `queues` (
  `queue_name` varchar(100) NOT NULL,
  `priority` int(10) unsigned NOT NULL,
  `scheduler_policy` varchar(100) NOT NULL,
  `state` enum('Active','notActive') NOT NULL default 'Active',
  PRIMARY KEY  (`queue_name`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `queues`
--

LOCK TABLES `queues` WRITE;
/*!40000 ALTER TABLE `queues` DISABLE KEYS */;
INSERT INTO `queues` VALUES ('admin',10,'oar_sched_gantt_with_timesharing','Active'),('default',2,'oar_sched_gantt_with_timesharing','Active'),('besteffort',0,'oar_sched_gantt_with_timesharing','Active');
/*!40000 ALTER TABLE `queues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resource_logs`
--

DROP TABLE IF EXISTS `resource_logs`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `resource_logs` (
  `resource_log_id` int(10) unsigned NOT NULL auto_increment,
  `resource_id` int(10) unsigned NOT NULL,
  `attribute` varchar(255) NOT NULL,
  `value` varchar(255) NOT NULL,
  `date_start` int(10) unsigned NOT NULL,
  `date_stop` int(10) unsigned default '0',
  `finaud_decision` enum('YES','NO') NOT NULL default 'NO',
  PRIMARY KEY  (`resource_log_id`),
  KEY `resource` (`resource_id`),
  KEY `attribute` (`attribute`),
  KEY `finaud` (`finaud_decision`),
  KEY `val` (`value`)
) ENGINE=MyISAM AUTO_INCREMENT=2305 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `resource_logs`
--

LOCK TABLES `resource_logs` WRITE;
/*!40000 ALTER TABLE `resource_logs` DISABLE KEYS */;
INSERT INTO `resource_logs` VALUES (1,1,'state','Alive',1224778461,0,'NO'),(2,1,'core ','1',1224778461,0,'NO'),(3,1,'cpu ','1',1224778461,0,'NO'),(4,1,'host ','node-1',1224778461,0,'NO'),(5,1,'cpuset','0',1224778461,0,'NO'),(6,1,'network_address','127.0.2.1',1224778461,0,'NO'),(7,2,'state','Alive',1224778461,0,'NO'),(8,2,'core ','2',1224778461,0,'NO'),(9,2,'cpu ','1',1224778461,0,'NO'),(10,2,'host ','node-1',1224778461,0,'NO'),(11,2,'cpuset','1',1224778461,0,'NO'),(12,2,'network_address','127.0.2.1',1224778461,0,'NO'),(13,3,'state','Alive',1224778462,0,'NO'),(14,3,'core ','3',1224778462,0,'NO'),(15,3,'cpu ','2',1224778462,0,'NO'),(16,3,'host ','node-1',1224778462,0,'NO'),(17,3,'cpuset','2',1224778462,0,'NO'),(18,3,'network_address','127.0.2.1',1224778462,0,'NO'),(19,4,'state','Alive',1224778462,0,'NO'),(20,4,'core ','4',1224778462,0,'NO'),(21,4,'cpu ','2',1224778462,0,'NO'),(22,4,'host ','node-1',1224778462,0,'NO'),(23,4,'cpuset','3',1224778462,0,'NO'),(24,4,'network_address','127.0.2.1',1224778462,0,'NO'),(25,5,'state','Alive',1224778462,0,'NO'),(26,5,'core ','5',1224778462,0,'NO'),(27,5,'cpu ','3',1224778462,0,'NO'),(28,5,'host ','node-2',1224778462,0,'NO'),(29,5,'cpuset','0',1224778462,0,'NO'),(30,5,'network_address','127.0.2.2',1224778462,0,'NO'),(31,6,'state','Alive',1224778462,0,'NO'),(32,6,'core ','6',1224778462,0,'NO'),(33,6,'cpu ','3',1224778462,0,'NO'),(34,6,'host ','node-2',1224778462,0,'NO'),(35,6,'cpuset','1',1224778462,0,'NO'),(36,6,'network_address','127.0.2.2',1224778462,0,'NO'),(37,7,'state','Alive',1224778462,0,'NO'),(38,7,'core ','7',1224778462,0,'NO'),(39,7,'cpu ','4',1224778462,0,'NO'),(40,7,'host ','node-2',1224778462,0,'NO'),(41,7,'cpuset','2',1224778462,0,'NO'),(42,7,'network_address','127.0.2.2',1224778462,0,'NO'),(43,8,'state','Alive',1224778462,0,'NO'),(44,8,'core ','8',1224778462,0,'NO'),(45,8,'cpu ','4',1224778462,0,'NO'),(46,8,'host ','node-2',1224778462,0,'NO'),(47,8,'cpuset','3',1224778462,0,'NO'),(48,8,'network_address','127.0.2.2',1224778462,0,'NO'),(49,9,'state','Alive',1224778463,0,'NO'),(50,9,'core ','9',1224778463,0,'NO'),(51,9,'cpu ','5',1224778463,0,'NO'),(52,9,'host ','node-3',1224778463,0,'NO'),(53,9,'cpuset','0',1224778463,0,'NO'),(54,9,'network_address','127.0.2.3',1224778463,0,'NO'),(55,10,'state','Alive',1224778463,0,'NO'),(56,10,'core ','10',1224778463,0,'NO'),(57,10,'cpu ','5',1224778463,0,'NO'),(58,10,'host ','node-3',1224778463,0,'NO'),(59,10,'cpuset','1',1224778463,0,'NO'),(60,10,'network_address','127.0.2.3',1224778463,0,'NO'),(61,11,'state','Alive',1224778463,0,'NO'),(62,11,'core ','11',1224778463,0,'NO'),(63,11,'cpu ','6',1224778463,0,'NO'),(64,11,'host ','node-3',1224778463,0,'NO'),(65,11,'cpuset','2',1224778463,0,'NO'),(66,11,'network_address','127.0.2.3',1224778463,0,'NO'),(67,12,'state','Alive',1224778463,0,'NO'),(68,12,'core ','12',1224778463,0,'NO'),(69,12,'cpu ','6',1224778463,0,'NO'),(70,12,'host ','node-3',1224778463,0,'NO'),(71,12,'cpuset','3',1224778463,0,'NO'),(72,12,'network_address','127.0.2.3',1224778463,0,'NO'),(73,13,'state','Alive',1224778463,0,'NO'),(74,13,'core ','13',1224778463,0,'NO'),(75,13,'cpu ','7',1224778463,0,'NO'),(76,13,'host ','node-4',1224778463,0,'NO'),(77,13,'cpuset','0',1224778463,0,'NO'),(78,13,'network_address','127.0.2.4',1224778463,0,'NO'),(79,14,'state','Alive',1224778464,0,'NO'),(80,14,'core ','14',1224778464,0,'NO'),(81,14,'cpu ','7',1224778464,0,'NO'),(82,14,'host ','node-4',1224778464,0,'NO'),(83,14,'cpuset','1',1224778464,0,'NO'),(84,14,'network_address','127.0.2.4',1224778464,0,'NO'),(85,15,'state','Alive',1224778464,0,'NO'),(86,15,'core ','15',1224778464,0,'NO'),(87,15,'cpu ','8',1224778464,0,'NO'),(88,15,'host ','node-4',1224778464,0,'NO'),(89,15,'cpuset','2',1224778464,0,'NO'),(90,15,'network_address','127.0.2.4',1224778464,0,'NO'),(91,16,'state','Alive',1224778464,0,'NO'),(92,16,'core ','16',1224778464,0,'NO'),(93,16,'cpu ','8',1224778464,0,'NO'),(94,16,'host ','node-4',1224778464,0,'NO'),(95,16,'cpuset','3',1224778464,0,'NO'),(96,16,'network_address','127.0.2.4',1224778464,0,'NO'),(97,17,'state','Alive',1224778464,0,'NO'),(98,17,'core ','17',1224778464,0,'NO'),(99,17,'cpu ','9',1224778464,0,'NO'),(100,17,'host ','node-5',1224778464,0,'NO'),(101,17,'cpuset','0',1224778464,0,'NO'),(102,17,'network_address','127.0.2.5',1224778464,0,'NO'),(103,18,'state','Alive',1224778464,0,'NO'),(104,18,'core ','18',1224778464,0,'NO'),(105,18,'cpu ','9',1224778464,0,'NO'),(106,18,'host ','node-5',1224778464,0,'NO'),(107,18,'cpuset','1',1224778464,0,'NO'),(108,18,'network_address','127.0.2.5',1224778464,0,'NO'),(109,19,'state','Alive',1224778465,0,'NO'),(110,19,'core ','19',1224778465,0,'NO'),(111,19,'cpu ','10',1224778465,0,'NO'),(112,19,'host ','node-5',1224778465,0,'NO'),(113,19,'cpuset','2',1224778465,0,'NO'),(114,19,'network_address','127.0.2.5',1224778465,0,'NO'),(115,20,'state','Alive',1224778465,0,'NO'),(116,20,'core ','20',1224778465,0,'NO'),(117,20,'cpu ','10',1224778465,0,'NO'),(118,20,'host ','node-5',1224778465,0,'NO'),(119,20,'cpuset','3',1224778465,0,'NO'),(120,20,'network_address','127.0.2.5',1224778465,0,'NO'),(121,21,'state','Alive',1224778465,0,'NO'),(122,21,'core ','21',1224778465,0,'NO'),(123,21,'cpu ','11',1224778465,0,'NO'),(124,21,'host ','node-6',1224778465,0,'NO'),(125,21,'cpuset','0',1224778465,0,'NO'),(126,21,'network_address','127.0.2.6',1224778465,0,'NO'),(127,22,'state','Alive',1224778465,0,'NO'),(128,22,'core ','22',1224778465,0,'NO'),(129,22,'cpu ','11',1224778465,0,'NO'),(130,22,'host ','node-6',1224778465,0,'NO'),(131,22,'cpuset','1',1224778465,0,'NO'),(132,22,'network_address','127.0.2.6',1224778465,0,'NO'),(133,23,'state','Alive',1224778465,0,'NO'),(134,23,'core ','23',1224778465,0,'NO'),(135,23,'cpu ','12',1224778465,0,'NO'),(136,23,'host ','node-6',1224778465,0,'NO'),(137,23,'cpuset','2',1224778465,0,'NO'),(138,23,'network_address','127.0.2.6',1224778465,0,'NO'),(139,24,'state','Alive',1224778466,0,'NO'),(140,24,'core ','24',1224778466,0,'NO'),(141,24,'cpu ','12',1224778466,0,'NO'),(142,24,'host ','node-6',1224778466,0,'NO'),(143,24,'cpuset','3',1224778466,0,'NO'),(144,24,'network_address','127.0.2.6',1224778466,0,'NO'),(145,25,'state','Alive',1224778466,0,'NO'),(146,25,'core ','25',1224778466,0,'NO'),(147,25,'cpu ','13',1224778466,0,'NO'),(148,25,'host ','node-7',1224778466,0,'NO'),(149,25,'cpuset','0',1224778466,0,'NO'),(150,25,'network_address','127.0.2.7',1224778466,0,'NO'),(151,26,'state','Alive',1224778466,0,'NO'),(152,26,'core ','26',1224778466,0,'NO'),(153,26,'cpu ','13',1224778466,0,'NO'),(154,26,'host ','node-7',1224778466,0,'NO'),(155,26,'cpuset','1',1224778466,0,'NO'),(156,26,'network_address','127.0.2.7',1224778466,0,'NO'),(157,27,'state','Alive',1224778466,0,'NO'),(158,27,'core ','27',1224778466,0,'NO'),(159,27,'cpu ','14',1224778466,0,'NO'),(160,27,'host ','node-7',1224778466,0,'NO'),(161,27,'cpuset','2',1224778466,0,'NO'),(162,27,'network_address','127.0.2.7',1224778466,0,'NO'),(163,28,'state','Alive',1224778466,0,'NO'),(164,28,'core ','28',1224778466,0,'NO'),(165,28,'cpu ','14',1224778466,0,'NO'),(166,28,'host ','node-7',1224778466,0,'NO'),(167,28,'cpuset','3',1224778466,0,'NO'),(168,28,'network_address','127.0.2.7',1224778466,0,'NO'),(169,29,'state','Alive',1224778466,0,'NO'),(170,29,'core ','29',1224778466,0,'NO'),(171,29,'cpu ','15',1224778466,0,'NO'),(172,29,'host ','node-8',1224778466,0,'NO'),(173,29,'cpuset','0',1224778466,0,'NO'),(174,29,'network_address','127.0.2.8',1224778466,0,'NO'),(175,30,'state','Alive',1224778467,0,'NO'),(176,30,'core ','30',1224778467,0,'NO'),(177,30,'cpu ','15',1224778467,0,'NO'),(178,30,'host ','node-8',1224778467,0,'NO'),(179,30,'cpuset','1',1224778467,0,'NO'),(180,30,'network_address','127.0.2.8',1224778467,0,'NO'),(181,31,'state','Alive',1224778467,0,'NO'),(182,31,'core ','31',1224778467,0,'NO'),(183,31,'cpu ','16',1224778467,0,'NO'),(184,31,'host ','node-8',1224778467,0,'NO'),(185,31,'cpuset','2',1224778467,0,'NO'),(186,31,'network_address','127.0.2.8',1224778467,0,'NO'),(187,32,'state','Alive',1224778467,0,'NO'),(188,32,'core ','32',1224778467,0,'NO'),(189,32,'cpu ','16',1224778467,0,'NO'),(190,32,'host ','node-8',1224778467,0,'NO'),(191,32,'cpuset','3',1224778467,0,'NO'),(192,32,'network_address','127.0.2.8',1224778467,0,'NO'),(193,33,'state','Alive',1224778467,0,'NO'),(194,33,'core ','33',1224778467,0,'NO'),(195,33,'cpu ','17',1224778467,0,'NO'),(196,33,'host ','node-9',1224778467,0,'NO'),(197,33,'cpuset','0',1224778467,0,'NO'),(198,33,'network_address','127.0.2.9',1224778467,0,'NO'),(199,34,'state','Alive',1224778467,0,'NO'),(200,34,'core ','34',1224778467,0,'NO'),(201,34,'cpu ','17',1224778467,0,'NO'),(202,34,'host ','node-9',1224778467,0,'NO'),(203,34,'cpuset','1',1224778467,0,'NO'),(204,34,'network_address','127.0.2.9',1224778467,0,'NO'),(205,35,'state','Alive',1224778468,0,'NO'),(206,35,'core ','35',1224778468,0,'NO'),(207,35,'cpu ','18',1224778468,0,'NO'),(208,35,'host ','node-9',1224778468,0,'NO'),(209,35,'cpuset','2',1224778468,0,'NO'),(210,35,'network_address','127.0.2.9',1224778468,0,'NO'),(211,36,'state','Alive',1224778468,0,'NO'),(212,36,'core ','36',1224778468,0,'NO'),(213,36,'cpu ','18',1224778468,0,'NO'),(214,36,'host ','node-9',1224778468,0,'NO'),(215,36,'cpuset','3',1224778468,0,'NO'),(216,36,'network_address','127.0.2.9',1224778468,0,'NO'),(217,37,'state','Alive',1224778468,0,'NO'),(218,37,'core ','37',1224778468,0,'NO'),(219,37,'cpu ','19',1224778468,0,'NO'),(220,37,'host ','node-10',1224778468,0,'NO'),(221,37,'cpuset','0',1224778468,0,'NO'),(222,37,'network_address','127.0.2.10',1224778468,0,'NO'),(223,38,'state','Alive',1224778468,0,'NO'),(224,38,'core ','38',1224778468,0,'NO'),(225,38,'cpu ','19',1224778468,0,'NO'),(226,38,'host ','node-10',1224778468,0,'NO'),(227,38,'cpuset','1',1224778468,0,'NO'),(228,38,'network_address','127.0.2.10',1224778468,0,'NO'),(229,39,'state','Alive',1224778468,0,'NO'),(230,39,'core ','39',1224778468,0,'NO'),(231,39,'cpu ','20',1224778468,0,'NO'),(232,39,'host ','node-10',1224778468,0,'NO'),(233,39,'cpuset','2',1224778468,0,'NO'),(234,39,'network_address','127.0.2.10',1224778468,0,'NO'),(235,40,'state','Alive',1224778469,0,'NO'),(236,40,'core ','40',1224778469,0,'NO'),(237,40,'cpu ','20',1224778469,0,'NO'),(238,40,'host ','node-10',1224778469,0,'NO'),(239,40,'cpuset','3',1224778469,0,'NO'),(240,40,'network_address','127.0.2.10',1224778469,0,'NO'),(241,41,'state','Alive',1224778469,0,'NO'),(242,41,'core ','41',1224778469,0,'NO'),(243,41,'cpu ','21',1224778469,0,'NO'),(244,41,'host ','node-11',1224778469,0,'NO'),(245,41,'cpuset','0',1224778469,0,'NO'),(246,41,'network_address','127.0.2.11',1224778469,0,'NO'),(247,42,'state','Alive',1224778469,0,'NO'),(248,42,'core ','42',1224778469,0,'NO'),(249,42,'cpu ','21',1224778469,0,'NO'),(250,42,'host ','node-11',1224778469,0,'NO'),(251,42,'cpuset','1',1224778469,0,'NO'),(252,42,'network_address','127.0.2.11',1224778469,0,'NO'),(253,43,'state','Alive',1224778469,0,'NO'),(254,43,'core ','43',1224778469,0,'NO'),(255,43,'cpu ','22',1224778469,0,'NO'),(256,43,'host ','node-11',1224778469,0,'NO'),(257,43,'cpuset','2',1224778469,0,'NO'),(258,43,'network_address','127.0.2.11',1224778469,0,'NO'),(259,44,'state','Alive',1224778469,0,'NO'),(260,44,'core ','44',1224778469,0,'NO'),(261,44,'cpu ','22',1224778469,0,'NO'),(262,44,'host ','node-11',1224778469,0,'NO'),(263,44,'cpuset','3',1224778469,0,'NO'),(264,44,'network_address','127.0.2.11',1224778469,0,'NO'),(265,45,'state','Alive',1224778470,0,'NO'),(266,45,'core ','45',1224778470,0,'NO'),(267,45,'cpu ','23',1224778470,0,'NO'),(268,45,'host ','node-12',1224778470,0,'NO'),(269,45,'cpuset','0',1224778470,0,'NO'),(270,45,'network_address','127.0.2.12',1224778470,0,'NO'),(271,46,'state','Alive',1224778470,0,'NO'),(272,46,'core ','46',1224778470,0,'NO'),(273,46,'cpu ','23',1224778470,0,'NO'),(274,46,'host ','node-12',1224778470,0,'NO'),(275,46,'cpuset','1',1224778470,0,'NO'),(276,46,'network_address','127.0.2.12',1224778470,0,'NO'),(277,47,'state','Alive',1224778470,0,'NO'),(278,47,'core ','47',1224778470,0,'NO'),(279,47,'cpu ','24',1224778470,0,'NO'),(280,47,'host ','node-12',1224778470,0,'NO'),(281,47,'cpuset','2',1224778470,0,'NO'),(282,47,'network_address','127.0.2.12',1224778470,0,'NO'),(283,48,'state','Alive',1224778470,0,'NO'),(284,48,'core ','48',1224778470,0,'NO'),(285,48,'cpu ','24',1224778470,0,'NO'),(286,48,'host ','node-12',1224778470,0,'NO'),(287,48,'cpuset','3',1224778470,0,'NO'),(288,48,'network_address','127.0.2.12',1224778470,0,'NO'),(289,49,'state','Alive',1224778471,0,'NO'),(290,49,'core ','49',1224778471,0,'NO'),(291,49,'cpu ','25',1224778471,0,'NO'),(292,49,'host ','node-13',1224778471,0,'NO'),(293,49,'cpuset','0',1224778471,0,'NO'),(294,49,'network_address','127.0.2.13',1224778471,0,'NO'),(295,50,'state','Alive',1224778471,0,'NO'),(296,50,'core ','50',1224778471,0,'NO'),(297,50,'cpu ','25',1224778471,0,'NO'),(298,50,'host ','node-13',1224778471,0,'NO'),(299,50,'cpuset','1',1224778471,0,'NO'),(300,50,'network_address','127.0.2.13',1224778471,0,'NO'),(301,51,'state','Alive',1224778471,0,'NO'),(302,51,'core ','51',1224778471,0,'NO'),(303,51,'cpu ','26',1224778471,0,'NO'),(304,51,'host ','node-13',1224778471,0,'NO'),(305,51,'cpuset','2',1224778471,0,'NO'),(306,51,'network_address','127.0.2.13',1224778471,0,'NO'),(307,52,'state','Alive',1224778472,0,'NO'),(308,52,'core ','52',1224778472,0,'NO'),(309,52,'cpu ','26',1224778472,0,'NO'),(310,52,'host ','node-13',1224778472,0,'NO'),(311,52,'cpuset','3',1224778472,0,'NO'),(312,52,'network_address','127.0.2.13',1224778472,0,'NO'),(313,53,'state','Alive',1224778472,0,'NO'),(314,53,'core ','53',1224778472,0,'NO'),(315,53,'cpu ','27',1224778472,0,'NO'),(316,53,'host ','node-14',1224778472,0,'NO'),(317,53,'cpuset','0',1224778472,0,'NO'),(318,53,'network_address','127.0.2.14',1224778472,0,'NO'),(319,54,'state','Alive',1224778472,0,'NO'),(320,54,'core ','54',1224778472,0,'NO'),(321,54,'cpu ','27',1224778472,0,'NO'),(322,54,'host ','node-14',1224778472,0,'NO'),(323,54,'cpuset','1',1224778472,0,'NO'),(324,54,'network_address','127.0.2.14',1224778472,0,'NO'),(325,55,'state','Alive',1224778472,0,'NO'),(326,55,'core ','55',1224778472,0,'NO'),(327,55,'cpu ','28',1224778472,0,'NO'),(328,55,'host ','node-14',1224778472,0,'NO'),(329,55,'cpuset','2',1224778472,0,'NO'),(330,55,'network_address','127.0.2.14',1224778472,0,'NO'),(331,56,'state','Alive',1224778472,0,'NO'),(332,56,'core ','56',1224778472,0,'NO'),(333,56,'cpu ','28',1224778472,0,'NO'),(334,56,'host ','node-14',1224778472,0,'NO'),(335,56,'cpuset','3',1224778472,0,'NO'),(336,56,'network_address','127.0.2.14',1224778472,0,'NO'),(337,57,'state','Alive',1224778473,0,'NO'),(338,57,'core ','57',1224778473,0,'NO'),(339,57,'cpu ','29',1224778473,0,'NO'),(340,57,'host ','node-15',1224778473,0,'NO'),(341,57,'cpuset','0',1224778473,0,'NO'),(342,57,'network_address','127.0.2.15',1224778473,0,'NO'),(343,58,'state','Alive',1224778473,0,'NO'),(344,58,'core ','58',1224778473,0,'NO'),(345,58,'cpu ','29',1224778473,0,'NO'),(346,58,'host ','node-15',1224778473,0,'NO'),(347,58,'cpuset','1',1224778473,0,'NO'),(348,58,'network_address','127.0.2.15',1224778473,0,'NO'),(349,59,'state','Alive',1224778473,0,'NO'),(350,59,'core ','59',1224778473,0,'NO'),(351,59,'cpu ','30',1224778473,0,'NO'),(352,59,'host ','node-15',1224778473,0,'NO'),(353,59,'cpuset','2',1224778473,0,'NO'),(354,59,'network_address','127.0.2.15',1224778473,0,'NO'),(355,60,'state','Alive',1224778473,0,'NO'),(356,60,'core ','60',1224778473,0,'NO'),(357,60,'cpu ','30',1224778473,0,'NO'),(358,60,'host ','node-15',1224778473,0,'NO'),(359,60,'cpuset','3',1224778473,0,'NO'),(360,60,'network_address','127.0.2.15',1224778473,0,'NO'),(361,61,'state','Alive',1224778473,0,'NO'),(362,61,'core ','61',1224778473,0,'NO'),(363,61,'cpu ','31',1224778473,0,'NO'),(364,61,'host ','node-16',1224778473,0,'NO'),(365,61,'cpuset','0',1224778473,0,'NO'),(366,61,'network_address','127.0.2.16',1224778473,0,'NO'),(367,62,'state','Alive',1224778473,0,'NO'),(368,62,'core ','62',1224778473,0,'NO'),(369,62,'cpu ','31',1224778473,0,'NO'),(370,62,'host ','node-16',1224778473,0,'NO'),(371,62,'cpuset','1',1224778473,0,'NO'),(372,62,'network_address','127.0.2.16',1224778473,0,'NO'),(373,63,'state','Alive',1224778474,0,'NO'),(374,63,'core ','63',1224778474,0,'NO'),(375,63,'cpu ','32',1224778474,0,'NO'),(376,63,'host ','node-16',1224778474,0,'NO'),(377,63,'cpuset','2',1224778474,0,'NO'),(378,63,'network_address','127.0.2.16',1224778474,0,'NO'),(379,64,'state','Alive',1224778474,0,'NO'),(380,64,'core ','64',1224778474,0,'NO'),(381,64,'cpu ','32',1224778474,0,'NO'),(382,64,'host ','node-16',1224778474,0,'NO'),(383,64,'cpuset','3',1224778474,0,'NO'),(384,64,'network_address','127.0.2.16',1224778474,0,'NO'),(385,65,'state','Alive',1224778474,0,'NO'),(386,65,'core ','65',1224778474,0,'NO'),(387,65,'cpu ','33',1224778474,0,'NO'),(388,65,'host ','node-17',1224778474,0,'NO'),(389,65,'cpuset','0',1224778474,0,'NO'),(390,65,'network_address','127.0.2.17',1224778474,0,'NO'),(391,66,'state','Alive',1224778474,0,'NO'),(392,66,'core ','66',1224778474,0,'NO'),(393,66,'cpu ','33',1224778474,0,'NO'),(394,66,'host ','node-17',1224778474,0,'NO'),(395,66,'cpuset','1',1224778474,0,'NO'),(396,66,'network_address','127.0.2.17',1224778474,0,'NO'),(397,67,'state','Alive',1224778474,0,'NO'),(398,67,'core ','67',1224778474,0,'NO'),(399,67,'cpu ','34',1224778474,0,'NO'),(400,67,'host ','node-17',1224778474,0,'NO'),(401,67,'cpuset','2',1224778474,0,'NO'),(402,67,'network_address','127.0.2.17',1224778474,0,'NO'),(403,68,'state','Alive',1224778475,0,'NO'),(404,68,'core ','68',1224778475,0,'NO'),(405,68,'cpu ','34',1224778475,0,'NO'),(406,68,'host ','node-17',1224778475,0,'NO'),(407,68,'cpuset','3',1224778475,0,'NO'),(408,68,'network_address','127.0.2.17',1224778475,0,'NO'),(409,69,'state','Alive',1224778475,0,'NO'),(410,69,'core ','69',1224778475,0,'NO'),(411,69,'cpu ','35',1224778475,0,'NO'),(412,69,'host ','node-18',1224778475,0,'NO'),(413,69,'cpuset','0',1224778475,0,'NO'),(414,69,'network_address','127.0.2.18',1224778475,0,'NO'),(415,70,'state','Alive',1224778475,0,'NO'),(416,70,'core ','70',1224778475,0,'NO'),(417,70,'cpu ','35',1224778475,0,'NO'),(418,70,'host ','node-18',1224778475,0,'NO'),(419,70,'cpuset','1',1224778475,0,'NO'),(420,70,'network_address','127.0.2.18',1224778475,0,'NO'),(421,71,'state','Alive',1224778475,0,'NO'),(422,71,'core ','71',1224778475,0,'NO'),(423,71,'cpu ','36',1224778475,0,'NO'),(424,71,'host ','node-18',1224778475,0,'NO'),(425,71,'cpuset','2',1224778475,0,'NO'),(426,71,'network_address','127.0.2.18',1224778475,0,'NO'),(427,72,'state','Alive',1224778475,0,'NO'),(428,72,'core ','72',1224778475,0,'NO'),(429,72,'cpu ','36',1224778475,0,'NO'),(430,72,'host ','node-18',1224778475,0,'NO'),(431,72,'cpuset','3',1224778475,0,'NO'),(432,72,'network_address','127.0.2.18',1224778475,0,'NO'),(433,73,'state','Alive',1224778476,0,'NO'),(434,73,'core ','73',1224778476,0,'NO'),(435,73,'cpu ','37',1224778476,0,'NO'),(436,73,'host ','node-19',1224778476,0,'NO'),(437,73,'cpuset','0',1224778476,0,'NO'),(438,73,'network_address','127.0.2.19',1224778476,0,'NO'),(439,74,'state','Alive',1224778476,0,'NO'),(440,74,'core ','74',1224778476,0,'NO'),(441,74,'cpu ','37',1224778476,0,'NO'),(442,74,'host ','node-19',1224778476,0,'NO'),(443,74,'cpuset','1',1224778476,0,'NO'),(444,74,'network_address','127.0.2.19',1224778476,0,'NO'),(445,75,'state','Alive',1224778476,0,'NO'),(446,75,'core ','75',1224778476,0,'NO'),(447,75,'cpu ','38',1224778476,0,'NO'),(448,75,'host ','node-19',1224778476,0,'NO'),(449,75,'cpuset','2',1224778476,0,'NO'),(450,75,'network_address','127.0.2.19',1224778476,0,'NO'),(451,76,'state','Alive',1224778476,0,'NO'),(452,76,'core ','76',1224778476,0,'NO'),(453,76,'cpu ','38',1224778476,0,'NO'),(454,76,'host ','node-19',1224778476,0,'NO'),(455,76,'cpuset','3',1224778476,0,'NO'),(456,76,'network_address','127.0.2.19',1224778476,0,'NO'),(457,77,'state','Alive',1224778476,0,'NO'),(458,77,'core ','77',1224778476,0,'NO'),(459,77,'cpu ','39',1224778476,0,'NO'),(460,77,'host ','node-20',1224778476,0,'NO'),(461,77,'cpuset','0',1224778476,0,'NO'),(462,77,'network_address','127.0.2.20',1224778476,0,'NO'),(463,78,'state','Alive',1224778477,0,'NO'),(464,78,'core ','78',1224778477,0,'NO'),(465,78,'cpu ','39',1224778477,0,'NO'),(466,78,'host ','node-20',1224778477,0,'NO'),(467,78,'cpuset','1',1224778477,0,'NO'),(468,78,'network_address','127.0.2.20',1224778477,0,'NO'),(469,79,'state','Alive',1224778477,0,'NO'),(470,79,'core ','79',1224778477,0,'NO'),(471,79,'cpu ','40',1224778477,0,'NO'),(472,79,'host ','node-20',1224778477,0,'NO'),(473,79,'cpuset','2',1224778477,0,'NO'),(474,79,'network_address','127.0.2.20',1224778477,0,'NO'),(475,80,'state','Alive',1224778477,0,'NO'),(476,80,'core ','80',1224778477,0,'NO'),(477,80,'cpu ','40',1224778477,0,'NO'),(478,80,'host ','node-20',1224778477,0,'NO'),(479,80,'cpuset','3',1224778477,0,'NO'),(480,80,'network_address','127.0.2.20',1224778477,0,'NO'),(481,81,'state','Alive',1224778477,0,'NO'),(482,81,'core ','81',1224778477,0,'NO'),(483,81,'cpu ','41',1224778477,0,'NO'),(484,81,'host ','node-21',1224778477,0,'NO'),(485,81,'cpuset','0',1224778477,0,'NO'),(486,81,'network_address','127.0.2.21',1224778477,0,'NO'),(487,82,'state','Alive',1224778477,0,'NO'),(488,82,'core ','82',1224778477,0,'NO'),(489,82,'cpu ','41',1224778477,0,'NO'),(490,82,'host ','node-21',1224778477,0,'NO'),(491,82,'cpuset','1',1224778477,0,'NO'),(492,82,'network_address','127.0.2.21',1224778477,0,'NO'),(493,83,'state','Alive',1224778478,0,'NO'),(494,83,'core ','83',1224778478,0,'NO'),(495,83,'cpu ','42',1224778478,0,'NO'),(496,83,'host ','node-21',1224778478,0,'NO'),(497,83,'cpuset','2',1224778478,0,'NO'),(498,83,'network_address','127.0.2.21',1224778478,0,'NO'),(499,84,'state','Alive',1224778478,0,'NO'),(500,84,'core ','84',1224778478,0,'NO'),(501,84,'cpu ','42',1224778478,0,'NO'),(502,84,'host ','node-21',1224778478,0,'NO'),(503,84,'cpuset','3',1224778478,0,'NO'),(504,84,'network_address','127.0.2.21',1224778478,0,'NO'),(505,85,'state','Alive',1224778478,0,'NO'),(506,85,'core ','85',1224778478,0,'NO'),(507,85,'cpu ','43',1224778478,0,'NO'),(508,85,'host ','node-22',1224778478,0,'NO'),(509,85,'cpuset','0',1224778478,0,'NO'),(510,85,'network_address','127.0.2.22',1224778478,0,'NO'),(511,86,'state','Alive',1224778478,0,'NO'),(512,86,'core ','86',1224778478,0,'NO'),(513,86,'cpu ','43',1224778478,0,'NO'),(514,86,'host ','node-22',1224778478,0,'NO'),(515,86,'cpuset','1',1224778478,0,'NO'),(516,86,'network_address','127.0.2.22',1224778478,0,'NO'),(517,87,'state','Alive',1224778478,0,'NO'),(518,87,'core ','87',1224778478,0,'NO'),(519,87,'cpu ','44',1224778478,0,'NO'),(520,87,'host ','node-22',1224778478,0,'NO'),(521,87,'cpuset','2',1224778478,0,'NO'),(522,87,'network_address','127.0.2.22',1224778478,0,'NO'),(523,88,'state','Alive',1224778478,0,'NO'),(524,88,'core ','88',1224778479,0,'NO'),(525,88,'cpu ','44',1224778479,0,'NO'),(526,88,'host ','node-22',1224778479,0,'NO'),(527,88,'cpuset','3',1224778479,0,'NO'),(528,88,'network_address','127.0.2.22',1224778479,0,'NO'),(529,89,'state','Alive',1224778479,0,'NO'),(530,89,'core ','89',1224778479,0,'NO'),(531,89,'cpu ','45',1224778479,0,'NO'),(532,89,'host ','node-23',1224778479,0,'NO'),(533,89,'cpuset','0',1224778479,0,'NO'),(534,89,'network_address','127.0.2.23',1224778479,0,'NO'),(535,90,'state','Alive',1224778479,0,'NO'),(536,90,'core ','90',1224778479,0,'NO'),(537,90,'cpu ','45',1224778479,0,'NO'),(538,90,'host ','node-23',1224778479,0,'NO'),(539,90,'cpuset','1',1224778479,0,'NO'),(540,90,'network_address','127.0.2.23',1224778479,0,'NO'),(541,91,'state','Alive',1224778479,0,'NO'),(542,91,'core ','91',1224778479,0,'NO'),(543,91,'cpu ','46',1224778479,0,'NO'),(544,91,'host ','node-23',1224778479,0,'NO'),(545,91,'cpuset','2',1224778479,0,'NO'),(546,91,'network_address','127.0.2.23',1224778479,0,'NO'),(547,92,'state','Alive',1224778479,0,'NO'),(548,92,'core ','92',1224778479,0,'NO'),(549,92,'cpu ','46',1224778479,0,'NO'),(550,92,'host ','node-23',1224778479,0,'NO'),(551,92,'cpuset','3',1224778479,0,'NO'),(552,92,'network_address','127.0.2.23',1224778479,0,'NO'),(553,93,'state','Alive',1224778479,0,'NO'),(554,93,'core ','93',1224778479,0,'NO'),(555,93,'cpu ','47',1224778479,0,'NO'),(556,93,'host ','node-24',1224778479,0,'NO'),(557,93,'cpuset','0',1224778479,0,'NO'),(558,93,'network_address','127.0.2.24',1224778479,0,'NO'),(559,94,'state','Alive',1224778480,0,'NO'),(560,94,'core ','94',1224778480,0,'NO'),(561,94,'cpu ','47',1224778480,0,'NO'),(562,94,'host ','node-24',1224778480,0,'NO'),(563,94,'cpuset','1',1224778480,0,'NO'),(564,94,'network_address','127.0.2.24',1224778480,0,'NO'),(565,95,'state','Alive',1224778480,0,'NO'),(566,95,'core ','95',1224778480,0,'NO'),(567,95,'cpu ','48',1224778480,0,'NO'),(568,95,'host ','node-24',1224778480,0,'NO'),(569,95,'cpuset','2',1224778480,0,'NO'),(570,95,'network_address','127.0.2.24',1224778480,0,'NO'),(571,96,'state','Alive',1224778480,0,'NO'),(572,96,'core ','96',1224778480,0,'NO'),(573,96,'cpu ','48',1224778480,0,'NO'),(574,96,'host ','node-24',1224778480,0,'NO'),(575,96,'cpuset','3',1224778480,0,'NO'),(576,96,'network_address','127.0.2.24',1224778480,0,'NO'),(577,97,'state','Alive',1224778480,0,'NO'),(578,97,'core ','97',1224778480,0,'NO'),(579,97,'cpu ','49',1224778480,0,'NO'),(580,97,'host ','node-25',1224778480,0,'NO'),(581,97,'cpuset','0',1224778480,0,'NO'),(582,97,'network_address','127.0.2.25',1224778480,0,'NO'),(583,98,'state','Alive',1224778480,0,'NO'),(584,98,'core ','98',1224778480,0,'NO'),(585,98,'cpu ','49',1224778480,0,'NO'),(586,98,'host ','node-25',1224778480,0,'NO'),(587,98,'cpuset','1',1224778480,0,'NO'),(588,98,'network_address','127.0.2.25',1224778480,0,'NO'),(589,99,'state','Alive',1224778481,0,'NO'),(590,99,'core ','99',1224778481,0,'NO'),(591,99,'cpu ','50',1224778481,0,'NO'),(592,99,'host ','node-25',1224778481,0,'NO'),(593,99,'cpuset','2',1224778481,0,'NO'),(594,99,'network_address','127.0.2.25',1224778481,0,'NO'),(595,100,'state','Alive',1224778481,0,'NO'),(596,100,'core ','100',1224778481,0,'NO'),(597,100,'cpu ','50',1224778481,0,'NO'),(598,100,'host ','node-25',1224778481,0,'NO'),(599,100,'cpuset','3',1224778481,0,'NO'),(600,100,'network_address','127.0.2.25',1224778481,0,'NO'),(601,101,'state','Alive',1224778481,0,'NO'),(602,101,'core ','101',1224778481,0,'NO'),(603,101,'cpu ','51',1224778481,0,'NO'),(604,101,'host ','node-26',1224778481,0,'NO'),(605,101,'cpuset','0',1224778481,0,'NO'),(606,101,'network_address','127.0.2.26',1224778481,0,'NO'),(607,102,'state','Alive',1224778481,0,'NO'),(608,102,'core ','102',1224778481,0,'NO'),(609,102,'cpu ','51',1224778481,0,'NO'),(610,102,'host ','node-26',1224778481,0,'NO'),(611,102,'cpuset','1',1224778481,0,'NO'),(612,102,'network_address','127.0.2.26',1224778481,0,'NO'),(613,103,'state','Alive',1224778482,0,'NO'),(614,103,'core ','103',1224778482,0,'NO'),(615,103,'cpu ','52',1224778482,0,'NO'),(616,103,'host ','node-26',1224778482,0,'NO'),(617,103,'cpuset','2',1224778482,0,'NO'),(618,103,'network_address','127.0.2.26',1224778482,0,'NO'),(619,104,'state','Alive',1224778482,0,'NO'),(620,104,'core ','104',1224778482,0,'NO'),(621,104,'cpu ','52',1224778482,0,'NO'),(622,104,'host ','node-26',1224778482,0,'NO'),(623,104,'cpuset','3',1224778482,0,'NO'),(624,104,'network_address','127.0.2.26',1224778482,0,'NO'),(625,105,'state','Alive',1224778482,0,'NO'),(626,105,'core ','105',1224778482,0,'NO'),(627,105,'cpu ','53',1224778482,0,'NO'),(628,105,'host ','node-27',1224778482,0,'NO'),(629,105,'cpuset','0',1224778482,0,'NO'),(630,105,'network_address','127.0.2.27',1224778482,0,'NO'),(631,106,'state','Alive',1224778482,0,'NO'),(632,106,'core ','106',1224778482,0,'NO'),(633,106,'cpu ','53',1224778482,0,'NO'),(634,106,'host ','node-27',1224778482,0,'NO'),(635,106,'cpuset','1',1224778482,0,'NO'),(636,106,'network_address','127.0.2.27',1224778482,0,'NO'),(637,107,'state','Alive',1224778482,0,'NO'),(638,107,'core ','107',1224778482,0,'NO'),(639,107,'cpu ','54',1224778482,0,'NO'),(640,107,'host ','node-27',1224778482,0,'NO'),(641,107,'cpuset','2',1224778482,0,'NO'),(642,107,'network_address','127.0.2.27',1224778482,0,'NO'),(643,108,'state','Alive',1224778483,0,'NO'),(644,108,'core ','108',1224778483,0,'NO'),(645,108,'cpu ','54',1224778483,0,'NO'),(646,108,'host ','node-27',1224778483,0,'NO'),(647,108,'cpuset','3',1224778483,0,'NO'),(648,108,'network_address','127.0.2.27',1224778483,0,'NO'),(649,109,'state','Alive',1224778483,0,'NO'),(650,109,'core ','109',1224778483,0,'NO'),(651,109,'cpu ','55',1224778483,0,'NO'),(652,109,'host ','node-28',1224778483,0,'NO'),(653,109,'cpuset','0',1224778483,0,'NO'),(654,109,'network_address','127.0.2.28',1224778483,0,'NO'),(655,110,'state','Alive',1224778483,0,'NO'),(656,110,'core ','110',1224778483,0,'NO'),(657,110,'cpu ','55',1224778483,0,'NO'),(658,110,'host ','node-28',1224778483,0,'NO'),(659,110,'cpuset','1',1224778483,0,'NO'),(660,110,'network_address','127.0.2.28',1224778483,0,'NO'),(661,111,'state','Alive',1224778483,0,'NO'),(662,111,'core ','111',1224778483,0,'NO'),(663,111,'cpu ','56',1224778483,0,'NO'),(664,111,'host ','node-28',1224778483,0,'NO'),(665,111,'cpuset','2',1224778483,0,'NO'),(666,111,'network_address','127.0.2.28',1224778483,0,'NO'),(667,112,'state','Alive',1224778484,0,'NO'),(668,112,'core ','112',1224778484,0,'NO'),(669,112,'cpu ','56',1224778484,0,'NO'),(670,112,'host ','node-28',1224778484,0,'NO'),(671,112,'cpuset','3',1224778484,0,'NO'),(672,112,'network_address','127.0.2.28',1224778484,0,'NO'),(673,113,'state','Alive',1224778484,0,'NO'),(674,113,'core ','113',1224778484,0,'NO'),(675,113,'cpu ','57',1224778484,0,'NO'),(676,113,'host ','node-29',1224778484,0,'NO'),(677,113,'cpuset','0',1224778484,0,'NO'),(678,113,'network_address','127.0.2.29',1224778484,0,'NO'),(679,114,'state','Alive',1224778484,0,'NO'),(680,114,'core ','114',1224778484,0,'NO'),(681,114,'cpu ','57',1224778484,0,'NO'),(682,114,'host ','node-29',1224778484,0,'NO'),(683,114,'cpuset','1',1224778484,0,'NO'),(684,114,'network_address','127.0.2.29',1224778484,0,'NO'),(685,115,'state','Alive',1224778484,0,'NO'),(686,115,'core ','115',1224778484,0,'NO'),(687,115,'cpu ','58',1224778484,0,'NO'),(688,115,'host ','node-29',1224778484,0,'NO'),(689,115,'cpuset','2',1224778484,0,'NO'),(690,115,'network_address','127.0.2.29',1224778484,0,'NO'),(691,116,'state','Alive',1224778484,0,'NO'),(692,116,'core ','116',1224778484,0,'NO'),(693,116,'cpu ','58',1224778484,0,'NO'),(694,116,'host ','node-29',1224778484,0,'NO'),(695,116,'cpuset','3',1224778484,0,'NO'),(696,116,'network_address','127.0.2.29',1224778484,0,'NO'),(697,117,'state','Alive',1224778485,0,'NO'),(698,117,'core ','117',1224778485,0,'NO'),(699,117,'cpu ','59',1224778485,0,'NO'),(700,117,'host ','node-30',1224778485,0,'NO'),(701,117,'cpuset','0',1224778485,0,'NO'),(702,117,'network_address','127.0.2.30',1224778485,0,'NO'),(703,118,'state','Alive',1224778485,0,'NO'),(704,118,'core ','118',1224778485,0,'NO'),(705,118,'cpu ','59',1224778485,0,'NO'),(706,118,'host ','node-30',1224778485,0,'NO'),(707,118,'cpuset','1',1224778485,0,'NO'),(708,118,'network_address','127.0.2.30',1224778485,0,'NO'),(709,119,'state','Alive',1224778485,0,'NO'),(710,119,'core ','119',1224778485,0,'NO'),(711,119,'cpu ','60',1224778485,0,'NO'),(712,119,'host ','node-30',1224778485,0,'NO'),(713,119,'cpuset','2',1224778485,0,'NO'),(714,119,'network_address','127.0.2.30',1224778485,0,'NO'),(715,120,'state','Alive',1224778485,0,'NO'),(716,120,'core ','120',1224778485,0,'NO'),(717,120,'cpu ','60',1224778485,0,'NO'),(718,120,'host ','node-30',1224778485,0,'NO'),(719,120,'cpuset','3',1224778485,0,'NO'),(720,120,'network_address','127.0.2.30',1224778485,0,'NO'),(721,121,'state','Alive',1224778485,0,'NO'),(722,121,'core ','121',1224778485,0,'NO'),(723,121,'cpu ','61',1224778485,0,'NO'),(724,121,'host ','node-31',1224778485,0,'NO'),(725,121,'cpuset','0',1224778485,0,'NO'),(726,121,'network_address','127.0.2.31',1224778485,0,'NO'),(727,122,'state','Alive',1224778486,0,'NO'),(728,122,'core ','122',1224778486,0,'NO'),(729,122,'cpu ','61',1224778486,0,'NO'),(730,122,'host ','node-31',1224778486,0,'NO'),(731,122,'cpuset','1',1224778486,0,'NO'),(732,122,'network_address','127.0.2.31',1224778486,0,'NO'),(733,123,'state','Alive',1224778486,0,'NO'),(734,123,'core ','123',1224778486,0,'NO'),(735,123,'cpu ','62',1224778486,0,'NO'),(736,123,'host ','node-31',1224778486,0,'NO'),(737,123,'cpuset','2',1224778486,0,'NO'),(738,123,'network_address','127.0.2.31',1224778486,0,'NO'),(739,124,'state','Alive',1224778486,0,'NO'),(740,124,'core ','124',1224778486,0,'NO'),(741,124,'cpu ','62',1224778486,0,'NO'),(742,124,'host ','node-31',1224778486,0,'NO'),(743,124,'cpuset','3',1224778486,0,'NO'),(744,124,'network_address','127.0.2.31',1224778486,0,'NO'),(745,125,'state','Alive',1224778486,0,'NO'),(746,125,'core ','125',1224778486,0,'NO'),(747,125,'cpu ','63',1224778486,0,'NO'),(748,125,'host ','node-32',1224778486,0,'NO'),(749,125,'cpuset','0',1224778486,0,'NO'),(750,125,'network_address','127.0.2.32',1224778486,0,'NO'),(751,126,'state','Alive',1224778486,0,'NO'),(752,126,'core ','126',1224778486,0,'NO'),(753,126,'cpu ','63',1224778486,0,'NO'),(754,126,'host ','node-32',1224778486,0,'NO'),(755,126,'cpuset','1',1224778486,0,'NO'),(756,126,'network_address','127.0.2.32',1224778486,0,'NO'),(757,127,'state','Alive',1224778487,0,'NO'),(758,127,'core ','127',1224778487,0,'NO'),(759,127,'cpu ','64',1224778487,0,'NO'),(760,127,'host ','node-32',1224778487,0,'NO'),(761,127,'cpuset','2',1224778487,0,'NO'),(762,127,'network_address','127.0.2.32',1224778487,0,'NO'),(763,128,'state','Alive',1224778487,0,'NO'),(764,128,'core ','128',1224778487,0,'NO'),(765,128,'cpu ','64',1224778487,0,'NO'),(766,128,'host ','node-32',1224778487,0,'NO'),(767,128,'cpuset','3',1224778487,0,'NO'),(768,128,'network_address','127.0.2.32',1224778487,0,'NO'),(769,129,'state','Alive',1224778487,0,'NO'),(770,129,'core ','129',1224778487,0,'NO'),(771,129,'cpu ','65',1224778487,0,'NO'),(772,129,'host ','node-33',1224778487,0,'NO'),(773,129,'cpuset','0',1224778487,0,'NO'),(774,129,'network_address','127.0.2.33',1224778487,0,'NO'),(775,130,'state','Alive',1224778487,0,'NO'),(776,130,'core ','130',1224778487,0,'NO'),(777,130,'cpu ','65',1224778487,0,'NO'),(778,130,'host ','node-33',1224778487,0,'NO'),(779,130,'cpuset','1',1224778487,0,'NO'),(780,130,'network_address','127.0.2.33',1224778487,0,'NO'),(781,131,'state','Alive',1224778487,0,'NO'),(782,131,'core ','131',1224778487,0,'NO'),(783,131,'cpu ','66',1224778487,0,'NO'),(784,131,'host ','node-33',1224778487,0,'NO'),(785,131,'cpuset','2',1224778487,0,'NO'),(786,131,'network_address','127.0.2.33',1224778487,0,'NO'),(787,132,'state','Alive',1224778487,0,'NO'),(788,132,'core ','132',1224778487,0,'NO'),(789,132,'cpu ','66',1224778487,0,'NO'),(790,132,'host ','node-33',1224778487,0,'NO'),(791,132,'cpuset','3',1224778487,0,'NO'),(792,132,'network_address','127.0.2.33',1224778487,0,'NO'),(793,133,'state','Alive',1224778488,0,'NO'),(794,133,'core ','133',1224778488,0,'NO'),(795,133,'cpu ','67',1224778488,0,'NO'),(796,133,'host ','node-34',1224778488,0,'NO'),(797,133,'cpuset','0',1224778488,0,'NO'),(798,133,'network_address','127.0.2.34',1224778488,0,'NO'),(799,134,'state','Alive',1224778488,0,'NO'),(800,134,'core ','134',1224778488,0,'NO'),(801,134,'cpu ','67',1224778488,0,'NO'),(802,134,'host ','node-34',1224778488,0,'NO'),(803,134,'cpuset','1',1224778488,0,'NO'),(804,134,'network_address','127.0.2.34',1224778488,0,'NO'),(805,135,'state','Alive',1224778488,0,'NO'),(806,135,'core ','135',1224778488,0,'NO'),(807,135,'cpu ','68',1224778488,0,'NO'),(808,135,'host ','node-34',1224778488,0,'NO'),(809,135,'cpuset','2',1224778488,0,'NO'),(810,135,'network_address','127.0.2.34',1224778488,0,'NO'),(811,136,'state','Alive',1224778488,0,'NO'),(812,136,'core ','136',1224778488,0,'NO'),(813,136,'cpu ','68',1224778488,0,'NO'),(814,136,'host ','node-34',1224778488,0,'NO'),(815,136,'cpuset','3',1224778488,0,'NO'),(816,136,'network_address','127.0.2.34',1224778488,0,'NO'),(817,137,'state','Alive',1224778488,0,'NO'),(818,137,'core ','137',1224778488,0,'NO'),(819,137,'cpu ','69',1224778488,0,'NO'),(820,137,'host ','node-35',1224778488,0,'NO'),(821,137,'cpuset','0',1224778488,0,'NO'),(822,137,'network_address','127.0.2.35',1224778488,0,'NO'),(823,138,'state','Alive',1224778489,0,'NO'),(824,138,'core ','138',1224778489,0,'NO'),(825,138,'cpu ','69',1224778489,0,'NO'),(826,138,'host ','node-35',1224778489,0,'NO'),(827,138,'cpuset','1',1224778489,0,'NO'),(828,138,'network_address','127.0.2.35',1224778489,0,'NO'),(829,139,'state','Alive',1224778489,0,'NO'),(830,139,'core ','139',1224778489,0,'NO'),(831,139,'cpu ','70',1224778489,0,'NO'),(832,139,'host ','node-35',1224778489,0,'NO'),(833,139,'cpuset','2',1224778489,0,'NO'),(834,139,'network_address','127.0.2.35',1224778489,0,'NO'),(835,140,'state','Alive',1224778489,0,'NO'),(836,140,'core ','140',1224778489,0,'NO'),(837,140,'cpu ','70',1224778489,0,'NO'),(838,140,'host ','node-35',1224778489,0,'NO'),(839,140,'cpuset','3',1224778489,0,'NO'),(840,140,'network_address','127.0.2.35',1224778489,0,'NO'),(841,141,'state','Alive',1224778489,0,'NO'),(842,141,'core ','141',1224778489,0,'NO'),(843,141,'cpu ','71',1224778489,0,'NO'),(844,141,'host ','node-36',1224778489,0,'NO'),(845,141,'cpuset','0',1224778489,0,'NO'),(846,141,'network_address','127.0.2.36',1224778489,0,'NO'),(847,142,'state','Alive',1224778489,0,'NO'),(848,142,'core ','142',1224778489,0,'NO'),(849,142,'cpu ','71',1224778489,0,'NO'),(850,142,'host ','node-36',1224778489,0,'NO'),(851,142,'cpuset','1',1224778489,0,'NO'),(852,142,'network_address','127.0.2.36',1224778489,0,'NO'),(853,143,'state','Alive',1224778490,0,'NO'),(854,143,'core ','143',1224778490,0,'NO'),(855,143,'cpu ','72',1224778490,0,'NO'),(856,143,'host ','node-36',1224778490,0,'NO'),(857,143,'cpuset','2',1224778490,0,'NO'),(858,143,'network_address','127.0.2.36',1224778490,0,'NO'),(859,144,'state','Alive',1224778490,0,'NO'),(860,144,'core ','144',1224778490,0,'NO'),(861,144,'cpu ','72',1224778490,0,'NO'),(862,144,'host ','node-36',1224778490,0,'NO'),(863,144,'cpuset','3',1224778490,0,'NO'),(864,144,'network_address','127.0.2.36',1224778490,0,'NO'),(865,145,'state','Alive',1224778490,0,'NO'),(866,145,'core ','145',1224778490,0,'NO'),(867,145,'cpu ','73',1224778490,0,'NO'),(868,145,'host ','node-37',1224778490,0,'NO'),(869,145,'cpuset','0',1224778490,0,'NO'),(870,145,'network_address','127.0.2.37',1224778490,0,'NO'),(871,146,'state','Alive',1224778490,0,'NO'),(872,146,'core ','146',1224778490,0,'NO'),(873,146,'cpu ','73',1224778490,0,'NO'),(874,146,'host ','node-37',1224778490,0,'NO'),(875,146,'cpuset','1',1224778490,0,'NO'),(876,146,'network_address','127.0.2.37',1224778490,0,'NO'),(877,147,'state','Alive',1224778490,0,'NO'),(878,147,'core ','147',1224778490,0,'NO'),(879,147,'cpu ','74',1224778490,0,'NO'),(880,147,'host ','node-37',1224778490,0,'NO'),(881,147,'cpuset','2',1224778490,0,'NO'),(882,147,'network_address','127.0.2.37',1224778490,0,'NO'),(883,148,'state','Alive',1224778491,0,'NO'),(884,148,'core ','148',1224778491,0,'NO'),(885,148,'cpu ','74',1224778491,0,'NO'),(886,148,'host ','node-37',1224778491,0,'NO'),(887,148,'cpuset','3',1224778491,0,'NO'),(888,148,'network_address','127.0.2.37',1224778491,0,'NO'),(889,149,'state','Alive',1224778491,0,'NO'),(890,149,'core ','149',1224778491,0,'NO'),(891,149,'cpu ','75',1224778491,0,'NO'),(892,149,'host ','node-38',1224778491,0,'NO'),(893,149,'cpuset','0',1224778491,0,'NO'),(894,149,'network_address','127.0.2.38',1224778491,0,'NO'),(895,150,'state','Alive',1224778491,0,'NO'),(896,150,'core ','150',1224778491,0,'NO'),(897,150,'cpu ','75',1224778491,0,'NO'),(898,150,'host ','node-38',1224778491,0,'NO'),(899,150,'cpuset','1',1224778491,0,'NO'),(900,150,'network_address','127.0.2.38',1224778491,0,'NO'),(901,151,'state','Alive',1224778491,0,'NO'),(902,151,'core ','151',1224778491,0,'NO'),(903,151,'cpu ','76',1224778491,0,'NO'),(904,151,'host ','node-38',1224778491,0,'NO'),(905,151,'cpuset','2',1224778491,0,'NO'),(906,151,'network_address','127.0.2.38',1224778491,0,'NO'),(907,152,'state','Alive',1224778491,0,'NO'),(908,152,'core ','152',1224778491,0,'NO'),(909,152,'cpu ','76',1224778491,0,'NO'),(910,152,'host ','node-38',1224778491,0,'NO'),(911,152,'cpuset','3',1224778491,0,'NO'),(912,152,'network_address','127.0.2.38',1224778491,0,'NO'),(913,153,'state','Alive',1224778491,0,'NO'),(914,153,'core ','153',1224778491,0,'NO'),(915,153,'cpu ','77',1224778491,0,'NO'),(916,153,'host ','node-39',1224778491,0,'NO'),(917,153,'cpuset','0',1224778491,0,'NO'),(918,153,'network_address','127.0.2.39',1224778491,0,'NO'),(919,154,'state','Alive',1224778492,0,'NO'),(920,154,'core ','154',1224778492,0,'NO'),(921,154,'cpu ','77',1224778492,0,'NO'),(922,154,'host ','node-39',1224778492,0,'NO'),(923,154,'cpuset','1',1224778492,0,'NO'),(924,154,'network_address','127.0.2.39',1224778492,0,'NO'),(925,155,'state','Alive',1224778492,0,'NO'),(926,155,'core ','155',1224778492,0,'NO'),(927,155,'cpu ','78',1224778492,0,'NO'),(928,155,'host ','node-39',1224778492,0,'NO'),(929,155,'cpuset','2',1224778492,0,'NO'),(930,155,'network_address','127.0.2.39',1224778492,0,'NO'),(931,156,'state','Alive',1224778492,0,'NO'),(932,156,'core ','156',1224778492,0,'NO'),(933,156,'cpu ','78',1224778492,0,'NO'),(934,156,'host ','node-39',1224778492,0,'NO'),(935,156,'cpuset','3',1224778492,0,'NO'),(936,156,'network_address','127.0.2.39',1224778492,0,'NO'),(937,157,'state','Alive',1224778492,0,'NO'),(938,157,'core ','157',1224778492,0,'NO'),(939,157,'cpu ','79',1224778492,0,'NO'),(940,157,'host ','node-40',1224778492,0,'NO'),(941,157,'cpuset','0',1224778492,0,'NO'),(942,157,'network_address','127.0.2.40',1224778492,0,'NO'),(943,158,'state','Alive',1224778492,0,'NO'),(944,158,'core ','158',1224778492,0,'NO'),(945,158,'cpu ','79',1224778492,0,'NO'),(946,158,'host ','node-40',1224778492,0,'NO'),(947,158,'cpuset','1',1224778492,0,'NO'),(948,158,'network_address','127.0.2.40',1224778492,0,'NO'),(949,159,'state','Alive',1224778493,0,'NO'),(950,159,'core ','159',1224778493,0,'NO'),(951,159,'cpu ','80',1224778493,0,'NO'),(952,159,'host ','node-40',1224778493,0,'NO'),(953,159,'cpuset','2',1224778493,0,'NO'),(954,159,'network_address','127.0.2.40',1224778493,0,'NO'),(955,160,'state','Alive',1224778493,0,'NO'),(956,160,'core ','160',1224778493,0,'NO'),(957,160,'cpu ','80',1224778493,0,'NO'),(958,160,'host ','node-40',1224778493,0,'NO'),(959,160,'cpuset','3',1224778493,0,'NO'),(960,160,'network_address','127.0.2.40',1224778493,0,'NO'),(961,161,'state','Alive',1224778493,0,'NO'),(962,161,'core ','161',1224778493,0,'NO'),(963,161,'cpu ','81',1224778493,0,'NO'),(964,161,'host ','node-41',1224778493,0,'NO'),(965,161,'cpuset','0',1224778493,0,'NO'),(966,161,'network_address','127.0.2.41',1224778493,0,'NO'),(967,162,'state','Alive',1224778493,0,'NO'),(968,162,'core ','162',1224778493,0,'NO'),(969,162,'cpu ','81',1224778493,0,'NO'),(970,162,'host ','node-41',1224778493,0,'NO'),(971,162,'cpuset','1',1224778493,0,'NO'),(972,162,'network_address','127.0.2.41',1224778493,0,'NO'),(973,163,'state','Alive',1224778493,0,'NO'),(974,163,'core ','163',1224778493,0,'NO'),(975,163,'cpu ','82',1224778493,0,'NO'),(976,163,'host ','node-41',1224778493,0,'NO'),(977,163,'cpuset','2',1224778493,0,'NO'),(978,163,'network_address','127.0.2.41',1224778493,0,'NO'),(979,164,'state','Alive',1224778494,0,'NO'),(980,164,'core ','164',1224778494,0,'NO'),(981,164,'cpu ','82',1224778494,0,'NO'),(982,164,'host ','node-41',1224778494,0,'NO'),(983,164,'cpuset','3',1224778494,0,'NO'),(984,164,'network_address','127.0.2.41',1224778494,0,'NO'),(985,165,'state','Alive',1224778494,0,'NO'),(986,165,'core ','165',1224778494,0,'NO'),(987,165,'cpu ','83',1224778494,0,'NO'),(988,165,'host ','node-42',1224778494,0,'NO'),(989,165,'cpuset','0',1224778494,0,'NO'),(990,165,'network_address','127.0.2.42',1224778494,0,'NO'),(991,166,'state','Alive',1224778494,0,'NO'),(992,166,'core ','166',1224778494,0,'NO'),(993,166,'cpu ','83',1224778494,0,'NO'),(994,166,'host ','node-42',1224778494,0,'NO'),(995,166,'cpuset','1',1224778494,0,'NO'),(996,166,'network_address','127.0.2.42',1224778494,0,'NO'),(997,167,'state','Alive',1224778494,0,'NO'),(998,167,'core ','167',1224778494,0,'NO'),(999,167,'cpu ','84',1224778494,0,'NO'),(1000,167,'host ','node-42',1224778494,0,'NO'),(1001,167,'cpuset','2',1224778494,0,'NO'),(1002,167,'network_address','127.0.2.42',1224778494,0,'NO'),(1003,168,'state','Alive',1224778494,0,'NO'),(1004,168,'core ','168',1224778494,0,'NO'),(1005,168,'cpu ','84',1224778494,0,'NO'),(1006,168,'host ','node-42',1224778494,0,'NO'),(1007,168,'cpuset','3',1224778494,0,'NO'),(1008,168,'network_address','127.0.2.42',1224778494,0,'NO'),(1009,169,'state','Alive',1224778495,0,'NO'),(1010,169,'core ','169',1224778495,0,'NO'),(1011,169,'cpu ','85',1224778495,0,'NO'),(1012,169,'host ','node-43',1224778495,0,'NO'),(1013,169,'cpuset','0',1224778495,0,'NO'),(1014,169,'network_address','127.0.2.43',1224778495,0,'NO'),(1015,170,'state','Alive',1224778495,0,'NO'),(1016,170,'core ','170',1224778495,0,'NO'),(1017,170,'cpu ','85',1224778495,0,'NO'),(1018,170,'host ','node-43',1224778495,0,'NO'),(1019,170,'cpuset','1',1224778495,0,'NO'),(1020,170,'network_address','127.0.2.43',1224778495,0,'NO'),(1021,171,'state','Alive',1224778495,0,'NO'),(1022,171,'core ','171',1224778495,0,'NO'),(1023,171,'cpu ','86',1224778495,0,'NO'),(1024,171,'host ','node-43',1224778495,0,'NO'),(1025,171,'cpuset','2',1224778495,0,'NO'),(1026,171,'network_address','127.0.2.43',1224778495,0,'NO'),(1027,172,'state','Alive',1224778495,0,'NO'),(1028,172,'core ','172',1224778495,0,'NO'),(1029,172,'cpu ','86',1224778495,0,'NO'),(1030,172,'host ','node-43',1224778495,0,'NO'),(1031,172,'cpuset','3',1224778495,0,'NO'),(1032,172,'network_address','127.0.2.43',1224778495,0,'NO'),(1033,173,'state','Alive',1224778495,0,'NO'),(1034,173,'core ','173',1224778495,0,'NO'),(1035,173,'cpu ','87',1224778495,0,'NO'),(1036,173,'host ','node-44',1224778495,0,'NO'),(1037,173,'cpuset','0',1224778495,0,'NO'),(1038,173,'network_address','127.0.2.44',1224778495,0,'NO'),(1039,174,'state','Alive',1224778496,0,'NO'),(1040,174,'core ','174',1224778496,0,'NO'),(1041,174,'cpu ','87',1224778496,0,'NO'),(1042,174,'host ','node-44',1224778496,0,'NO'),(1043,174,'cpuset','1',1224778496,0,'NO'),(1044,174,'network_address','127.0.2.44',1224778496,0,'NO'),(1045,175,'state','Alive',1224778496,0,'NO'),(1046,175,'core ','175',1224778496,0,'NO'),(1047,175,'cpu ','88',1224778496,0,'NO'),(1048,175,'host ','node-44',1224778496,0,'NO'),(1049,175,'cpuset','2',1224778496,0,'NO'),(1050,175,'network_address','127.0.2.44',1224778496,0,'NO'),(1051,176,'state','Alive',1224778496,0,'NO'),(1052,176,'core ','176',1224778496,0,'NO'),(1053,176,'cpu ','88',1224778496,0,'NO'),(1054,176,'host ','node-44',1224778496,0,'NO'),(1055,176,'cpuset','3',1224778496,0,'NO'),(1056,176,'network_address','127.0.2.44',1224778496,0,'NO'),(1057,177,'state','Alive',1224778496,0,'NO'),(1058,177,'core ','177',1224778496,0,'NO'),(1059,177,'cpu ','89',1224778496,0,'NO'),(1060,177,'host ','node-45',1224778496,0,'NO'),(1061,177,'cpuset','0',1224778496,0,'NO'),(1062,177,'network_address','127.0.2.45',1224778496,0,'NO'),(1063,178,'state','Alive',1224778497,0,'NO'),(1064,178,'core ','178',1224778497,0,'NO'),(1065,178,'cpu ','89',1224778497,0,'NO'),(1066,178,'host ','node-45',1224778497,0,'NO'),(1067,178,'cpuset','1',1224778497,0,'NO'),(1068,178,'network_address','127.0.2.45',1224778497,0,'NO'),(1069,179,'state','Alive',1224778497,0,'NO'),(1070,179,'core ','179',1224778497,0,'NO'),(1071,179,'cpu ','90',1224778497,0,'NO'),(1072,179,'host ','node-45',1224778497,0,'NO'),(1073,179,'cpuset','2',1224778497,0,'NO'),(1074,179,'network_address','127.0.2.45',1224778497,0,'NO'),(1075,180,'state','Alive',1224778497,0,'NO'),(1076,180,'core ','180',1224778497,0,'NO'),(1077,180,'cpu ','90',1224778497,0,'NO'),(1078,180,'host ','node-45',1224778497,0,'NO'),(1079,180,'cpuset','3',1224778497,0,'NO'),(1080,180,'network_address','127.0.2.45',1224778497,0,'NO'),(1081,181,'state','Alive',1224778497,0,'NO'),(1082,181,'core ','181',1224778497,0,'NO'),(1083,181,'cpu ','91',1224778497,0,'NO'),(1084,181,'host ','node-46',1224778497,0,'NO'),(1085,181,'cpuset','0',1224778497,0,'NO'),(1086,181,'network_address','127.0.2.46',1224778497,0,'NO'),(1087,182,'state','Alive',1224778497,0,'NO'),(1088,182,'core ','182',1224778497,0,'NO'),(1089,182,'cpu ','91',1224778497,0,'NO'),(1090,182,'host ','node-46',1224778497,0,'NO'),(1091,182,'cpuset','1',1224778497,0,'NO'),(1092,182,'network_address','127.0.2.46',1224778497,0,'NO'),(1093,183,'state','Alive',1224778497,0,'NO'),(1094,183,'core ','183',1224778497,0,'NO'),(1095,183,'cpu ','92',1224778497,0,'NO'),(1096,183,'host ','node-46',1224778497,0,'NO'),(1097,183,'cpuset','2',1224778497,0,'NO'),(1098,183,'network_address','127.0.2.46',1224778497,0,'NO'),(1099,184,'state','Alive',1224778498,0,'NO'),(1100,184,'core ','184',1224778498,0,'NO'),(1101,184,'cpu ','92',1224778498,0,'NO'),(1102,184,'host ','node-46',1224778498,0,'NO'),(1103,184,'cpuset','3',1224778498,0,'NO'),(1104,184,'network_address','127.0.2.46',1224778498,0,'NO'),(1105,185,'state','Alive',1224778498,0,'NO'),(1106,185,'core ','185',1224778498,0,'NO'),(1107,185,'cpu ','93',1224778498,0,'NO'),(1108,185,'host ','node-47',1224778498,0,'NO'),(1109,185,'cpuset','0',1224778498,0,'NO'),(1110,185,'network_address','127.0.2.47',1224778498,0,'NO'),(1111,186,'state','Alive',1224778498,0,'NO'),(1112,186,'core ','186',1224778498,0,'NO'),(1113,186,'cpu ','93',1224778498,0,'NO'),(1114,186,'host ','node-47',1224778498,0,'NO'),(1115,186,'cpuset','1',1224778498,0,'NO'),(1116,186,'network_address','127.0.2.47',1224778498,0,'NO'),(1117,187,'state','Alive',1224778498,0,'NO'),(1118,187,'core ','187',1224778498,0,'NO'),(1119,187,'cpu ','94',1224778498,0,'NO'),(1120,187,'host ','node-47',1224778498,0,'NO'),(1121,187,'cpuset','2',1224778498,0,'NO'),(1122,187,'network_address','127.0.2.47',1224778498,0,'NO'),(1123,188,'state','Alive',1224778498,0,'NO'),(1124,188,'core ','188',1224778498,0,'NO'),(1125,188,'cpu ','94',1224778498,0,'NO'),(1126,188,'host ','node-47',1224778498,0,'NO'),(1127,188,'cpuset','3',1224778498,0,'NO'),(1128,188,'network_address','127.0.2.47',1224778498,0,'NO'),(1129,189,'state','Alive',1224778499,0,'NO'),(1130,189,'core ','189',1224778499,0,'NO'),(1131,189,'cpu ','95',1224778499,0,'NO'),(1132,189,'host ','node-48',1224778499,0,'NO'),(1133,189,'cpuset','0',1224778499,0,'NO'),(1134,189,'network_address','127.0.2.48',1224778499,0,'NO'),(1135,190,'state','Alive',1224778499,0,'NO'),(1136,190,'core ','190',1224778499,0,'NO'),(1137,190,'cpu ','95',1224778499,0,'NO'),(1138,190,'host ','node-48',1224778499,0,'NO'),(1139,190,'cpuset','1',1224778499,0,'NO'),(1140,190,'network_address','127.0.2.48',1224778499,0,'NO'),(1141,191,'state','Alive',1224778499,0,'NO'),(1142,191,'core ','191',1224778499,0,'NO'),(1143,191,'cpu ','96',1224778499,0,'NO'),(1144,191,'host ','node-48',1224778499,0,'NO'),(1145,191,'cpuset','2',1224778499,0,'NO'),(1146,191,'network_address','127.0.2.48',1224778499,0,'NO'),(1147,192,'state','Alive',1224778499,0,'NO'),(1148,192,'core ','192',1224778499,0,'NO'),(1149,192,'cpu ','96',1224778499,0,'NO'),(1150,192,'host ','node-48',1224778499,0,'NO'),(1151,192,'cpuset','3',1224778499,0,'NO'),(1152,192,'network_address','127.0.2.48',1224778499,0,'NO'),(1153,193,'state','Alive',1224778499,0,'NO'),(1154,193,'core ','193',1224778499,0,'NO'),(1155,193,'cpu ','97',1224778499,0,'NO'),(1156,193,'host ','node-49',1224778499,0,'NO'),(1157,193,'cpuset','0',1224778499,0,'NO'),(1158,193,'network_address','127.0.2.49',1224778499,0,'NO'),(1159,194,'state','Alive',1224778500,0,'NO'),(1160,194,'core ','194',1224778500,0,'NO'),(1161,194,'cpu ','97',1224778500,0,'NO'),(1162,194,'host ','node-49',1224778500,0,'NO'),(1163,194,'cpuset','1',1224778500,0,'NO'),(1164,194,'network_address','127.0.2.49',1224778500,0,'NO'),(1165,195,'state','Alive',1224778500,0,'NO'),(1166,195,'core ','195',1224778500,0,'NO'),(1167,195,'cpu ','98',1224778500,0,'NO'),(1168,195,'host ','node-49',1224778500,0,'NO'),(1169,195,'cpuset','2',1224778500,0,'NO'),(1170,195,'network_address','127.0.2.49',1224778500,0,'NO'),(1171,196,'state','Alive',1224778500,0,'NO'),(1172,196,'core ','196',1224778500,0,'NO'),(1173,196,'cpu ','98',1224778500,0,'NO'),(1174,196,'host ','node-49',1224778500,0,'NO'),(1175,196,'cpuset','3',1224778500,0,'NO'),(1176,196,'network_address','127.0.2.49',1224778500,0,'NO'),(1177,197,'state','Alive',1224778500,0,'NO'),(1178,197,'core ','197',1224778500,0,'NO'),(1179,197,'cpu ','99',1224778500,0,'NO'),(1180,197,'host ','node-50',1224778500,0,'NO'),(1181,197,'cpuset','0',1224778500,0,'NO'),(1182,197,'network_address','127.0.2.50',1224778500,0,'NO'),(1183,198,'state','Alive',1224778500,0,'NO'),(1184,198,'core ','198',1224778500,0,'NO'),(1185,198,'cpu ','99',1224778500,0,'NO'),(1186,198,'host ','node-50',1224778500,0,'NO'),(1187,198,'cpuset','1',1224778500,0,'NO'),(1188,198,'network_address','127.0.2.50',1224778500,0,'NO'),(1189,199,'state','Alive',1224778501,0,'NO'),(1190,199,'core ','199',1224778501,0,'NO'),(1191,199,'cpu ','100',1224778501,0,'NO'),(1192,199,'host ','node-50',1224778501,0,'NO'),(1193,199,'cpuset','2',1224778501,0,'NO'),(1194,199,'network_address','127.0.2.50',1224778501,0,'NO'),(1195,200,'state','Alive',1224778501,0,'NO'),(1196,200,'core ','200',1224778501,0,'NO'),(1197,200,'cpu ','100',1224778501,0,'NO'),(1198,200,'host ','node-50',1224778501,0,'NO'),(1199,200,'cpuset','3',1224778501,0,'NO'),(1200,200,'network_address','127.0.2.50',1224778501,0,'NO'),(1201,201,'state','Alive',1224778501,0,'NO'),(1202,201,'core ','201',1224778501,0,'NO'),(1203,201,'cpu ','101',1224778501,0,'NO'),(1204,201,'host ','node-51',1224778501,0,'NO'),(1205,201,'cpuset','0',1224778501,0,'NO'),(1206,201,'network_address','127.0.2.51',1224778501,0,'NO'),(1207,202,'state','Alive',1224778501,0,'NO'),(1208,202,'core ','202',1224778501,0,'NO'),(1209,202,'cpu ','101',1224778501,0,'NO'),(1210,202,'host ','node-51',1224778501,0,'NO'),(1211,202,'cpuset','1',1224778501,0,'NO'),(1212,202,'network_address','127.0.2.51',1224778501,0,'NO'),(1213,203,'state','Alive',1224778501,0,'NO'),(1214,203,'core ','203',1224778501,0,'NO'),(1215,203,'cpu ','102',1224778501,0,'NO'),(1216,203,'host ','node-51',1224778501,0,'NO'),(1217,203,'cpuset','2',1224778501,0,'NO'),(1218,203,'network_address','127.0.2.51',1224778501,0,'NO'),(1219,204,'state','Alive',1224778502,0,'NO'),(1220,204,'core ','204',1224778502,0,'NO'),(1221,204,'cpu ','102',1224778502,0,'NO'),(1222,204,'host ','node-51',1224778502,0,'NO'),(1223,204,'cpuset','3',1224778502,0,'NO'),(1224,204,'network_address','127.0.2.51',1224778502,0,'NO'),(1225,205,'state','Alive',1224778502,0,'NO'),(1226,205,'core ','205',1224778502,0,'NO'),(1227,205,'cpu ','103',1224778502,0,'NO'),(1228,205,'host ','node-52',1224778502,0,'NO'),(1229,205,'cpuset','0',1224778502,0,'NO'),(1230,205,'network_address','127.0.2.52',1224778502,0,'NO'),(1231,206,'state','Alive',1224778502,0,'NO'),(1232,206,'core ','206',1224778502,0,'NO'),(1233,206,'cpu ','103',1224778502,0,'NO'),(1234,206,'host ','node-52',1224778502,0,'NO'),(1235,206,'cpuset','1',1224778502,0,'NO'),(1236,206,'network_address','127.0.2.52',1224778502,0,'NO'),(1237,207,'state','Alive',1224778502,0,'NO'),(1238,207,'core ','207',1224778502,0,'NO'),(1239,207,'cpu ','104',1224778502,0,'NO'),(1240,207,'host ','node-52',1224778502,0,'NO'),(1241,207,'cpuset','2',1224778502,0,'NO'),(1242,207,'network_address','127.0.2.52',1224778502,0,'NO'),(1243,208,'state','Alive',1224778502,0,'NO'),(1244,208,'core ','208',1224778502,0,'NO'),(1245,208,'cpu ','104',1224778502,0,'NO'),(1246,208,'host ','node-52',1224778502,0,'NO'),(1247,208,'cpuset','3',1224778502,0,'NO'),(1248,208,'network_address','127.0.2.52',1224778502,0,'NO'),(1249,209,'state','Alive',1224778502,0,'NO'),(1250,209,'core ','209',1224778502,0,'NO'),(1251,209,'cpu ','105',1224778502,0,'NO'),(1252,209,'host ','node-53',1224778502,0,'NO'),(1253,209,'cpuset','0',1224778502,0,'NO'),(1254,209,'network_address','127.0.2.53',1224778502,0,'NO'),(1255,210,'state','Alive',1224778503,0,'NO'),(1256,210,'core ','210',1224778503,0,'NO'),(1257,210,'cpu ','105',1224778503,0,'NO'),(1258,210,'host ','node-53',1224778503,0,'NO'),(1259,210,'cpuset','1',1224778503,0,'NO'),(1260,210,'network_address','127.0.2.53',1224778503,0,'NO'),(1261,211,'state','Alive',1224778503,0,'NO'),(1262,211,'core ','211',1224778503,0,'NO'),(1263,211,'cpu ','106',1224778503,0,'NO'),(1264,211,'host ','node-53',1224778503,0,'NO'),(1265,211,'cpuset','2',1224778503,0,'NO'),(1266,211,'network_address','127.0.2.53',1224778503,0,'NO'),(1267,212,'state','Alive',1224778503,0,'NO'),(1268,212,'core ','212',1224778503,0,'NO'),(1269,212,'cpu ','106',1224778503,0,'NO'),(1270,212,'host ','node-53',1224778503,0,'NO'),(1271,212,'cpuset','3',1224778503,0,'NO'),(1272,212,'network_address','127.0.2.53',1224778503,0,'NO'),(1273,213,'state','Alive',1224778503,0,'NO'),(1274,213,'core ','213',1224778503,0,'NO'),(1275,213,'cpu ','107',1224778503,0,'NO'),(1276,213,'host ','node-54',1224778503,0,'NO'),(1277,213,'cpuset','0',1224778503,0,'NO'),(1278,213,'network_address','127.0.2.54',1224778503,0,'NO'),(1279,214,'state','Alive',1224778503,0,'NO'),(1280,214,'core ','214',1224778503,0,'NO'),(1281,214,'cpu ','107',1224778503,0,'NO'),(1282,214,'host ','node-54',1224778503,0,'NO'),(1283,214,'cpuset','1',1224778503,0,'NO'),(1284,214,'network_address','127.0.2.54',1224778503,0,'NO'),(1285,215,'state','Alive',1224778504,0,'NO'),(1286,215,'core ','215',1224778504,0,'NO'),(1287,215,'cpu ','108',1224778504,0,'NO'),(1288,215,'host ','node-54',1224778504,0,'NO'),(1289,215,'cpuset','2',1224778504,0,'NO'),(1290,215,'network_address','127.0.2.54',1224778504,0,'NO'),(1291,216,'state','Alive',1224778504,0,'NO'),(1292,216,'core ','216',1224778504,0,'NO'),(1293,216,'cpu ','108',1224778504,0,'NO'),(1294,216,'host ','node-54',1224778504,0,'NO'),(1295,216,'cpuset','3',1224778504,0,'NO'),(1296,216,'network_address','127.0.2.54',1224778504,0,'NO'),(1297,217,'state','Alive',1224778504,0,'NO'),(1298,217,'core ','217',1224778504,0,'NO'),(1299,217,'cpu ','109',1224778504,0,'NO'),(1300,217,'host ','node-55',1224778504,0,'NO'),(1301,217,'cpuset','0',1224778504,0,'NO'),(1302,217,'network_address','127.0.2.55',1224778504,0,'NO'),(1303,218,'state','Alive',1224778504,0,'NO'),(1304,218,'core ','218',1224778504,0,'NO'),(1305,218,'cpu ','109',1224778504,0,'NO'),(1306,218,'host ','node-55',1224778504,0,'NO'),(1307,218,'cpuset','1',1224778504,0,'NO'),(1308,218,'network_address','127.0.2.55',1224778504,0,'NO'),(1309,219,'state','Alive',1224778504,0,'NO'),(1310,219,'core ','219',1224778504,0,'NO'),(1311,219,'cpu ','110',1224778504,0,'NO'),(1312,219,'host ','node-55',1224778504,0,'NO'),(1313,219,'cpuset','2',1224778504,0,'NO'),(1314,219,'network_address','127.0.2.55',1224778504,0,'NO'),(1315,220,'state','Alive',1224778505,0,'NO'),(1316,220,'core ','220',1224778505,0,'NO'),(1317,220,'cpu ','110',1224778505,0,'NO'),(1318,220,'host ','node-55',1224778505,0,'NO'),(1319,220,'cpuset','3',1224778505,0,'NO'),(1320,220,'network_address','127.0.2.55',1224778505,0,'NO'),(1321,221,'state','Alive',1224778505,0,'NO'),(1322,221,'core ','221',1224778505,0,'NO'),(1323,221,'cpu ','111',1224778505,0,'NO'),(1324,221,'host ','node-56',1224778505,0,'NO'),(1325,221,'cpuset','0',1224778505,0,'NO'),(1326,221,'network_address','127.0.2.56',1224778505,0,'NO'),(1327,222,'state','Alive',1224778505,0,'NO'),(1328,222,'core ','222',1224778505,0,'NO'),(1329,222,'cpu ','111',1224778505,0,'NO'),(1330,222,'host ','node-56',1224778505,0,'NO'),(1331,222,'cpuset','1',1224778505,0,'NO'),(1332,222,'network_address','127.0.2.56',1224778505,0,'NO'),(1333,223,'state','Alive',1224778505,0,'NO'),(1334,223,'core ','223',1224778505,0,'NO'),(1335,223,'cpu ','112',1224778505,0,'NO'),(1336,223,'host ','node-56',1224778505,0,'NO'),(1337,223,'cpuset','2',1224778505,0,'NO'),(1338,223,'network_address','127.0.2.56',1224778505,0,'NO'),(1339,224,'state','Alive',1224778505,0,'NO'),(1340,224,'core ','224',1224778505,0,'NO'),(1341,224,'cpu ','112',1224778505,0,'NO'),(1342,224,'host ','node-56',1224778505,0,'NO'),(1343,224,'cpuset','3',1224778505,0,'NO'),(1344,224,'network_address','127.0.2.56',1224778505,0,'NO'),(1345,225,'state','Alive',1224778506,0,'NO'),(1346,225,'core ','225',1224778506,0,'NO'),(1347,225,'cpu ','113',1224778506,0,'NO'),(1348,225,'host ','node-57',1224778506,0,'NO'),(1349,225,'cpuset','0',1224778506,0,'NO'),(1350,225,'network_address','127.0.2.57',1224778506,0,'NO'),(1351,226,'state','Alive',1224778506,0,'NO'),(1352,226,'core ','226',1224778506,0,'NO'),(1353,226,'cpu ','113',1224778506,0,'NO'),(1354,226,'host ','node-57',1224778506,0,'NO'),(1355,226,'cpuset','1',1224778506,0,'NO'),(1356,226,'network_address','127.0.2.57',1224778506,0,'NO'),(1357,227,'state','Alive',1224778506,0,'NO'),(1358,227,'core ','227',1224778506,0,'NO'),(1359,227,'cpu ','114',1224778506,0,'NO'),(1360,227,'host ','node-57',1224778506,0,'NO'),(1361,227,'cpuset','2',1224778506,0,'NO'),(1362,227,'network_address','127.0.2.57',1224778506,0,'NO'),(1363,228,'state','Alive',1224778506,0,'NO'),(1364,228,'core ','228',1224778506,0,'NO'),(1365,228,'cpu ','114',1224778506,0,'NO'),(1366,228,'host ','node-57',1224778506,0,'NO'),(1367,228,'cpuset','3',1224778506,0,'NO'),(1368,228,'network_address','127.0.2.57',1224778506,0,'NO'),(1369,229,'state','Alive',1224778506,0,'NO'),(1370,229,'core ','229',1224778506,0,'NO'),(1371,229,'cpu ','115',1224778506,0,'NO'),(1372,229,'host ','node-58',1224778506,0,'NO'),(1373,229,'cpuset','0',1224778506,0,'NO'),(1374,229,'network_address','127.0.2.58',1224778506,0,'NO'),(1375,230,'state','Alive',1224778507,0,'NO'),(1376,230,'core ','230',1224778507,0,'NO'),(1377,230,'cpu ','115',1224778507,0,'NO'),(1378,230,'host ','node-58',1224778507,0,'NO'),(1379,230,'cpuset','1',1224778507,0,'NO'),(1380,230,'network_address','127.0.2.58',1224778507,0,'NO'),(1381,231,'state','Alive',1224778507,0,'NO'),(1382,231,'core ','231',1224778507,0,'NO'),(1383,231,'cpu ','116',1224778507,0,'NO'),(1384,231,'host ','node-58',1224778507,0,'NO'),(1385,231,'cpuset','2',1224778507,0,'NO'),(1386,231,'network_address','127.0.2.58',1224778507,0,'NO'),(1387,232,'state','Alive',1224778507,0,'NO'),(1388,232,'core ','232',1224778507,0,'NO'),(1389,232,'cpu ','116',1224778507,0,'NO'),(1390,232,'host ','node-58',1224778507,0,'NO'),(1391,232,'cpuset','3',1224778507,0,'NO'),(1392,232,'network_address','127.0.2.58',1224778507,0,'NO'),(1393,233,'state','Alive',1224778507,0,'NO'),(1394,233,'core ','233',1224778507,0,'NO'),(1395,233,'cpu ','117',1224778507,0,'NO'),(1396,233,'host ','node-59',1224778507,0,'NO'),(1397,233,'cpuset','0',1224778507,0,'NO'),(1398,233,'network_address','127.0.2.59',1224778507,0,'NO'),(1399,234,'state','Alive',1224778507,0,'NO'),(1400,234,'core ','234',1224778507,0,'NO'),(1401,234,'cpu ','117',1224778507,0,'NO'),(1402,234,'host ','node-59',1224778507,0,'NO'),(1403,234,'cpuset','1',1224778507,0,'NO'),(1404,234,'network_address','127.0.2.59',1224778507,0,'NO'),(1405,235,'state','Alive',1224778507,0,'NO'),(1406,235,'core ','235',1224778507,0,'NO'),(1407,235,'cpu ','118',1224778507,0,'NO'),(1408,235,'host ','node-59',1224778507,0,'NO'),(1409,235,'cpuset','2',1224778507,0,'NO'),(1410,235,'network_address','127.0.2.59',1224778507,0,'NO'),(1411,236,'state','Alive',1224778508,0,'NO'),(1412,236,'core ','236',1224778508,0,'NO'),(1413,236,'cpu ','118',1224778508,0,'NO'),(1414,236,'host ','node-59',1224778508,0,'NO'),(1415,236,'cpuset','3',1224778508,0,'NO'),(1416,236,'network_address','127.0.2.59',1224778508,0,'NO'),(1417,237,'state','Alive',1224778508,0,'NO'),(1418,237,'core ','237',1224778508,0,'NO'),(1419,237,'cpu ','119',1224778508,0,'NO'),(1420,237,'host ','node-60',1224778508,0,'NO'),(1421,237,'cpuset','0',1224778508,0,'NO'),(1422,237,'network_address','127.0.2.60',1224778508,0,'NO'),(1423,238,'state','Alive',1224778508,0,'NO'),(1424,238,'core ','238',1224778508,0,'NO'),(1425,238,'cpu ','119',1224778508,0,'NO'),(1426,238,'host ','node-60',1224778508,0,'NO'),(1427,238,'cpuset','1',1224778508,0,'NO'),(1428,238,'network_address','127.0.2.60',1224778508,0,'NO'),(1429,239,'state','Alive',1224778508,0,'NO'),(1430,239,'core ','239',1224778508,0,'NO'),(1431,239,'cpu ','120',1224778508,0,'NO'),(1432,239,'host ','node-60',1224778508,0,'NO'),(1433,239,'cpuset','2',1224778508,0,'NO'),(1434,239,'network_address','127.0.2.60',1224778508,0,'NO'),(1435,240,'state','Alive',1224778508,0,'NO'),(1436,240,'core ','240',1224778508,0,'NO'),(1437,240,'cpu ','120',1224778508,0,'NO'),(1438,240,'host ','node-60',1224778508,0,'NO'),(1439,240,'cpuset','3',1224778508,0,'NO'),(1440,240,'network_address','127.0.2.60',1224778508,0,'NO'),(1441,241,'state','Alive',1224778509,0,'NO'),(1442,241,'core ','241',1224778509,0,'NO'),(1443,241,'cpu ','121',1224778509,0,'NO'),(1444,241,'host ','node-61',1224778509,0,'NO'),(1445,241,'cpuset','0',1224778509,0,'NO'),(1446,241,'network_address','127.0.2.61',1224778509,0,'NO'),(1447,242,'state','Alive',1224778509,0,'NO'),(1448,242,'core ','242',1224778509,0,'NO'),(1449,242,'cpu ','121',1224778509,0,'NO'),(1450,242,'host ','node-61',1224778509,0,'NO'),(1451,242,'cpuset','1',1224778509,0,'NO'),(1452,242,'network_address','127.0.2.61',1224778509,0,'NO'),(1453,243,'state','Alive',1224778509,0,'NO'),(1454,243,'core ','243',1224778509,0,'NO'),(1455,243,'cpu ','122',1224778509,0,'NO'),(1456,243,'host ','node-61',1224778509,0,'NO'),(1457,243,'cpuset','2',1224778509,0,'NO'),(1458,243,'network_address','127.0.2.61',1224778509,0,'NO'),(1459,244,'state','Alive',1224778509,0,'NO'),(1460,244,'core ','244',1224778509,0,'NO'),(1461,244,'cpu ','122',1224778509,0,'NO'),(1462,244,'host ','node-61',1224778509,0,'NO'),(1463,244,'cpuset','3',1224778509,0,'NO'),(1464,244,'network_address','127.0.2.61',1224778509,0,'NO'),(1465,245,'state','Alive',1224778509,0,'NO'),(1466,245,'core ','245',1224778509,0,'NO'),(1467,245,'cpu ','123',1224778509,0,'NO'),(1468,245,'host ','node-62',1224778509,0,'NO'),(1469,245,'cpuset','0',1224778509,0,'NO'),(1470,245,'network_address','127.0.2.62',1224778509,0,'NO'),(1471,246,'state','Alive',1224778510,0,'NO'),(1472,246,'core ','246',1224778510,0,'NO'),(1473,246,'cpu ','123',1224778510,0,'NO'),(1474,246,'host ','node-62',1224778510,0,'NO'),(1475,246,'cpuset','1',1224778510,0,'NO'),(1476,246,'network_address','127.0.2.62',1224778510,0,'NO'),(1477,247,'state','Alive',1224778510,0,'NO'),(1478,247,'core ','247',1224778510,0,'NO'),(1479,247,'cpu ','124',1224778510,0,'NO'),(1480,247,'host ','node-62',1224778510,0,'NO'),(1481,247,'cpuset','2',1224778510,0,'NO'),(1482,247,'network_address','127.0.2.62',1224778510,0,'NO'),(1483,248,'state','Alive',1224778510,0,'NO'),(1484,248,'core ','248',1224778510,0,'NO'),(1485,248,'cpu ','124',1224778510,0,'NO'),(1486,248,'host ','node-62',1224778510,0,'NO'),(1487,248,'cpuset','3',1224778510,0,'NO'),(1488,248,'network_address','127.0.2.62',1224778510,0,'NO'),(1489,249,'state','Alive',1224778510,0,'NO'),(1490,249,'core ','249',1224778510,0,'NO'),(1491,249,'cpu ','125',1224778510,0,'NO'),(1492,249,'host ','node-63',1224778510,0,'NO'),(1493,249,'cpuset','0',1224778510,0,'NO'),(1494,249,'network_address','127.0.2.63',1224778510,0,'NO'),(1495,250,'state','Alive',1224778510,0,'NO'),(1496,250,'core ','250',1224778510,0,'NO'),(1497,250,'cpu ','125',1224778510,0,'NO'),(1498,250,'host ','node-63',1224778510,0,'NO'),(1499,250,'cpuset','1',1224778510,0,'NO'),(1500,250,'network_address','127.0.2.63',1224778510,0,'NO'),(1501,251,'state','Alive',1224778511,0,'NO'),(1502,251,'core ','251',1224778511,0,'NO'),(1503,251,'cpu ','126',1224778511,0,'NO'),(1504,251,'host ','node-63',1224778511,0,'NO'),(1505,251,'cpuset','2',1224778511,0,'NO'),(1506,251,'network_address','127.0.2.63',1224778511,0,'NO'),(1507,252,'state','Alive',1224778511,0,'NO'),(1508,252,'core ','252',1224778511,0,'NO'),(1509,252,'cpu ','126',1224778511,0,'NO'),(1510,252,'host ','node-63',1224778511,0,'NO'),(1511,252,'cpuset','3',1224778511,0,'NO'),(1512,252,'network_address','127.0.2.63',1224778511,0,'NO'),(1513,253,'state','Alive',1224778511,0,'NO'),(1514,253,'core ','253',1224778511,0,'NO'),(1515,253,'cpu ','127',1224778511,0,'NO'),(1516,253,'host ','node-64',1224778511,0,'NO'),(1517,253,'cpuset','0',1224778511,0,'NO'),(1518,253,'network_address','127.0.2.64',1224778511,0,'NO'),(1519,254,'state','Alive',1224778511,0,'NO'),(1520,254,'core ','254',1224778511,0,'NO'),(1521,254,'cpu ','127',1224778511,0,'NO'),(1522,254,'host ','node-64',1224778511,0,'NO'),(1523,254,'cpuset','1',1224778511,0,'NO'),(1524,254,'network_address','127.0.2.64',1224778511,0,'NO'),(1525,255,'state','Alive',1224778511,0,'NO'),(1526,255,'core ','255',1224778511,0,'NO'),(1527,255,'cpu ','128',1224778511,0,'NO'),(1528,255,'host ','node-64',1224778511,0,'NO'),(1529,255,'cpuset','2',1224778511,0,'NO'),(1530,255,'network_address','127.0.2.64',1224778511,0,'NO'),(1531,256,'state','Alive',1224778512,0,'NO'),(1532,256,'core ','256',1224778512,0,'NO'),(1533,256,'cpu ','128',1224778512,0,'NO'),(1534,256,'host ','node-64',1224778512,0,'NO'),(1535,256,'cpuset','3',1224778512,0,'NO'),(1536,256,'network_address','127.0.2.64',1224778512,0,'NO'),(1537,257,'state','Alive',1224778512,0,'NO'),(1538,257,'core ','257',1224778512,0,'NO'),(1539,257,'cpu ','129',1224778512,0,'NO'),(1540,257,'host ','node-65',1224778512,0,'NO'),(1541,257,'cpuset','0',1224778512,0,'NO'),(1542,257,'network_address','127.0.2.65',1224778512,0,'NO'),(1543,258,'state','Alive',1224778512,0,'NO'),(1544,258,'core ','258',1224778512,0,'NO'),(1545,258,'cpu ','129',1224778512,0,'NO'),(1546,258,'host ','node-65',1224778512,0,'NO'),(1547,258,'cpuset','1',1224778512,0,'NO'),(1548,258,'network_address','127.0.2.65',1224778512,0,'NO'),(1549,259,'state','Alive',1224778512,0,'NO'),(1550,259,'core ','259',1224778512,0,'NO'),(1551,259,'cpu ','130',1224778512,0,'NO'),(1552,259,'host ','node-65',1224778512,0,'NO'),(1553,259,'cpuset','2',1224778512,0,'NO'),(1554,259,'network_address','127.0.2.65',1224778512,0,'NO'),(1555,260,'state','Alive',1224778512,0,'NO'),(1556,260,'core ','260',1224778512,0,'NO'),(1557,260,'cpu ','130',1224778512,0,'NO'),(1558,260,'host ','node-65',1224778512,0,'NO'),(1559,260,'cpuset','3',1224778512,0,'NO'),(1560,260,'network_address','127.0.2.65',1224778512,0,'NO'),(1561,261,'state','Alive',1224778512,0,'NO'),(1562,261,'core ','261',1224778512,0,'NO'),(1563,261,'cpu ','131',1224778512,0,'NO'),(1564,261,'host ','node-66',1224778512,0,'NO'),(1565,261,'cpuset','0',1224778512,0,'NO'),(1566,261,'network_address','127.0.2.66',1224778512,0,'NO'),(1567,262,'state','Alive',1224778513,0,'NO'),(1568,262,'core ','262',1224778513,0,'NO'),(1569,262,'cpu ','131',1224778513,0,'NO'),(1570,262,'host ','node-66',1224778513,0,'NO'),(1571,262,'cpuset','1',1224778513,0,'NO'),(1572,262,'network_address','127.0.2.66',1224778513,0,'NO'),(1573,263,'state','Alive',1224778513,0,'NO'),(1574,263,'core ','263',1224778513,0,'NO'),(1575,263,'cpu ','132',1224778513,0,'NO'),(1576,263,'host ','node-66',1224778513,0,'NO'),(1577,263,'cpuset','2',1224778513,0,'NO'),(1578,263,'network_address','127.0.2.66',1224778513,0,'NO'),(1579,264,'state','Alive',1224778513,0,'NO'),(1580,264,'core ','264',1224778513,0,'NO'),(1581,264,'cpu ','132',1224778513,0,'NO'),(1582,264,'host ','node-66',1224778513,0,'NO'),(1583,264,'cpuset','3',1224778513,0,'NO'),(1584,264,'network_address','127.0.2.66',1224778513,0,'NO'),(1585,265,'state','Alive',1224778513,0,'NO'),(1586,265,'core ','265',1224778513,0,'NO'),(1587,265,'cpu ','133',1224778513,0,'NO'),(1588,265,'host ','node-67',1224778513,0,'NO'),(1589,265,'cpuset','0',1224778513,0,'NO'),(1590,265,'network_address','127.0.2.67',1224778513,0,'NO'),(1591,266,'state','Alive',1224778513,0,'NO'),(1592,266,'core ','266',1224778513,0,'NO'),(1593,266,'cpu ','133',1224778513,0,'NO'),(1594,266,'host ','node-67',1224778513,0,'NO'),(1595,266,'cpuset','1',1224778513,0,'NO'),(1596,266,'network_address','127.0.2.67',1224778513,0,'NO'),(1597,267,'state','Alive',1224778514,0,'NO'),(1598,267,'core ','267',1224778514,0,'NO'),(1599,267,'cpu ','134',1224778514,0,'NO'),(1600,267,'host ','node-67',1224778514,0,'NO'),(1601,267,'cpuset','2',1224778514,0,'NO'),(1602,267,'network_address','127.0.2.67',1224778514,0,'NO'),(1603,268,'state','Alive',1224778514,0,'NO'),(1604,268,'core ','268',1224778514,0,'NO'),(1605,268,'cpu ','134',1224778514,0,'NO'),(1606,268,'host ','node-67',1224778514,0,'NO'),(1607,268,'cpuset','3',1224778514,0,'NO'),(1608,268,'network_address','127.0.2.67',1224778514,0,'NO'),(1609,269,'state','Alive',1224778514,0,'NO'),(1610,269,'core ','269',1224778514,0,'NO'),(1611,269,'cpu ','135',1224778514,0,'NO'),(1612,269,'host ','node-68',1224778514,0,'NO'),(1613,269,'cpuset','0',1224778514,0,'NO'),(1614,269,'network_address','127.0.2.68',1224778514,0,'NO'),(1615,270,'state','Alive',1224778514,0,'NO'),(1616,270,'core ','270',1224778514,0,'NO'),(1617,270,'cpu ','135',1224778514,0,'NO'),(1618,270,'host ','node-68',1224778514,0,'NO'),(1619,270,'cpuset','1',1224778514,0,'NO'),(1620,270,'network_address','127.0.2.68',1224778514,0,'NO'),(1621,271,'state','Alive',1224778514,0,'NO'),(1622,271,'core ','271',1224778514,0,'NO'),(1623,271,'cpu ','136',1224778514,0,'NO'),(1624,271,'host ','node-68',1224778514,0,'NO'),(1625,271,'cpuset','2',1224778514,0,'NO'),(1626,271,'network_address','127.0.2.68',1224778514,0,'NO'),(1627,272,'state','Alive',1224778515,0,'NO'),(1628,272,'core ','272',1224778515,0,'NO'),(1629,272,'cpu ','136',1224778515,0,'NO'),(1630,272,'host ','node-68',1224778515,0,'NO'),(1631,272,'cpuset','3',1224778515,0,'NO'),(1632,272,'network_address','127.0.2.68',1224778515,0,'NO'),(1633,273,'state','Alive',1224778515,0,'NO'),(1634,273,'core ','273',1224778515,0,'NO'),(1635,273,'cpu ','137',1224778515,0,'NO'),(1636,273,'host ','node-69',1224778515,0,'NO'),(1637,273,'cpuset','0',1224778515,0,'NO'),(1638,273,'network_address','127.0.2.69',1224778515,0,'NO'),(1639,274,'state','Alive',1224778515,0,'NO'),(1640,274,'core ','274',1224778515,0,'NO'),(1641,274,'cpu ','137',1224778515,0,'NO'),(1642,274,'host ','node-69',1224778515,0,'NO'),(1643,274,'cpuset','1',1224778515,0,'NO'),(1644,274,'network_address','127.0.2.69',1224778515,0,'NO'),(1645,275,'state','Alive',1224778515,0,'NO'),(1646,275,'core ','275',1224778515,0,'NO'),(1647,275,'cpu ','138',1224778515,0,'NO'),(1648,275,'host ','node-69',1224778515,0,'NO'),(1649,275,'cpuset','2',1224778515,0,'NO'),(1650,275,'network_address','127.0.2.69',1224778515,0,'NO'),(1651,276,'state','Alive',1224778515,0,'NO'),(1652,276,'core ','276',1224778515,0,'NO'),(1653,276,'cpu ','138',1224778515,0,'NO'),(1654,276,'host ','node-69',1224778515,0,'NO'),(1655,276,'cpuset','3',1224778515,0,'NO'),(1656,276,'network_address','127.0.2.69',1224778515,0,'NO'),(1657,277,'state','Alive',1224778516,0,'NO'),(1658,277,'core ','277',1224778516,0,'NO'),(1659,277,'cpu ','139',1224778516,0,'NO'),(1660,277,'host ','node-70',1224778516,0,'NO'),(1661,277,'cpuset','0',1224778516,0,'NO'),(1662,277,'network_address','127.0.2.70',1224778516,0,'NO'),(1663,278,'state','Alive',1224778516,0,'NO'),(1664,278,'core ','278',1224778516,0,'NO'),(1665,278,'cpu ','139',1224778516,0,'NO'),(1666,278,'host ','node-70',1224778516,0,'NO'),(1667,278,'cpuset','1',1224778516,0,'NO'),(1668,278,'network_address','127.0.2.70',1224778516,0,'NO'),(1669,279,'state','Alive',1224778516,0,'NO'),(1670,279,'core ','279',1224778516,0,'NO'),(1671,279,'cpu ','140',1224778516,0,'NO'),(1672,279,'host ','node-70',1224778516,0,'NO'),(1673,279,'cpuset','2',1224778516,0,'NO'),(1674,279,'network_address','127.0.2.70',1224778516,0,'NO'),(1675,280,'state','Alive',1224778516,0,'NO'),(1676,280,'core ','280',1224778516,0,'NO'),(1677,280,'cpu ','140',1224778516,0,'NO'),(1678,280,'host ','node-70',1224778516,0,'NO'),(1679,280,'cpuset','3',1224778516,0,'NO'),(1680,280,'network_address','127.0.2.70',1224778516,0,'NO'),(1681,281,'state','Alive',1224778516,0,'NO'),(1682,281,'core ','281',1224778516,0,'NO'),(1683,281,'cpu ','141',1224778516,0,'NO'),(1684,281,'host ','node-71',1224778516,0,'NO'),(1685,281,'cpuset','0',1224778516,0,'NO'),(1686,281,'network_address','127.0.2.71',1224778516,0,'NO'),(1687,282,'state','Alive',1224778516,0,'NO'),(1688,282,'core ','282',1224778516,0,'NO'),(1689,282,'cpu ','141',1224778516,0,'NO'),(1690,282,'host ','node-71',1224778516,0,'NO'),(1691,282,'cpuset','1',1224778516,0,'NO'),(1692,282,'network_address','127.0.2.71',1224778516,0,'NO'),(1693,283,'state','Alive',1224778517,0,'NO'),(1694,283,'core ','283',1224778517,0,'NO'),(1695,283,'cpu ','142',1224778517,0,'NO'),(1696,283,'host ','node-71',1224778517,0,'NO'),(1697,283,'cpuset','2',1224778517,0,'NO'),(1698,283,'network_address','127.0.2.71',1224778517,0,'NO'),(1699,284,'state','Alive',1224778517,0,'NO'),(1700,284,'core ','284',1224778517,0,'NO'),(1701,284,'cpu ','142',1224778517,0,'NO'),(1702,284,'host ','node-71',1224778517,0,'NO'),(1703,284,'cpuset','3',1224778517,0,'NO'),(1704,284,'network_address','127.0.2.71',1224778517,0,'NO'),(1705,285,'state','Alive',1224778517,0,'NO'),(1706,285,'core ','285',1224778517,0,'NO'),(1707,285,'cpu ','143',1224778517,0,'NO'),(1708,285,'host ','node-72',1224778517,0,'NO'),(1709,285,'cpuset','0',1224778517,0,'NO'),(1710,285,'network_address','127.0.2.72',1224778517,0,'NO'),(1711,286,'state','Alive',1224778517,0,'NO'),(1712,286,'core ','286',1224778517,0,'NO'),(1713,286,'cpu ','143',1224778517,0,'NO'),(1714,286,'host ','node-72',1224778517,0,'NO'),(1715,286,'cpuset','1',1224778517,0,'NO'),(1716,286,'network_address','127.0.2.72',1224778517,0,'NO'),(1717,287,'state','Alive',1224778517,0,'NO'),(1718,287,'core ','287',1224778517,0,'NO'),(1719,287,'cpu ','144',1224778517,0,'NO'),(1720,287,'host ','node-72',1224778517,0,'NO'),(1721,287,'cpuset','2',1224778517,0,'NO'),(1722,287,'network_address','127.0.2.72',1224778517,0,'NO'),(1723,288,'state','Alive',1224778518,0,'NO'),(1724,288,'core ','288',1224778518,0,'NO'),(1725,288,'cpu ','144',1224778518,0,'NO'),(1726,288,'host ','node-72',1224778518,0,'NO'),(1727,288,'cpuset','3',1224778518,0,'NO'),(1728,288,'network_address','127.0.2.72',1224778518,0,'NO'),(1729,289,'state','Alive',1224778518,0,'NO'),(1730,289,'core ','289',1224778518,0,'NO'),(1731,289,'cpu ','145',1224778518,0,'NO'),(1732,289,'host ','node-73',1224778518,0,'NO'),(1733,289,'cpuset','0',1224778518,0,'NO'),(1734,289,'network_address','127.0.2.73',1224778518,0,'NO'),(1735,290,'state','Alive',1224778518,0,'NO'),(1736,290,'core ','290',1224778518,0,'NO'),(1737,290,'cpu ','145',1224778518,0,'NO'),(1738,290,'host ','node-73',1224778518,0,'NO'),(1739,290,'cpuset','1',1224778518,0,'NO'),(1740,290,'network_address','127.0.2.73',1224778518,0,'NO'),(1741,291,'state','Alive',1224778518,0,'NO'),(1742,291,'core ','291',1224778518,0,'NO'),(1743,291,'cpu ','146',1224778518,0,'NO'),(1744,291,'host ','node-73',1224778518,0,'NO'),(1745,291,'cpuset','2',1224778518,0,'NO'),(1746,291,'network_address','127.0.2.73',1224778518,0,'NO'),(1747,292,'state','Alive',1224778518,0,'NO'),(1748,292,'core ','292',1224778518,0,'NO'),(1749,292,'cpu ','146',1224778518,0,'NO'),(1750,292,'host ','node-73',1224778518,0,'NO'),(1751,292,'cpuset','3',1224778518,0,'NO'),(1752,292,'network_address','127.0.2.73',1224778518,0,'NO'),(1753,293,'state','Alive',1224778519,0,'NO'),(1754,293,'core ','293',1224778519,0,'NO'),(1755,293,'cpu ','147',1224778519,0,'NO'),(1756,293,'host ','node-74',1224778519,0,'NO'),(1757,293,'cpuset','0',1224778519,0,'NO'),(1758,293,'network_address','127.0.2.74',1224778519,0,'NO'),(1759,294,'state','Alive',1224778519,0,'NO'),(1760,294,'core ','294',1224778519,0,'NO'),(1761,294,'cpu ','147',1224778519,0,'NO'),(1762,294,'host ','node-74',1224778519,0,'NO'),(1763,294,'cpuset','1',1224778519,0,'NO'),(1764,294,'network_address','127.0.2.74',1224778519,0,'NO'),(1765,295,'state','Alive',1224778519,0,'NO'),(1766,295,'core ','295',1224778519,0,'NO'),(1767,295,'cpu ','148',1224778519,0,'NO'),(1768,295,'host ','node-74',1224778519,0,'NO'),(1769,295,'cpuset','2',1224778519,0,'NO'),(1770,295,'network_address','127.0.2.74',1224778519,0,'NO'),(1771,296,'state','Alive',1224778519,0,'NO'),(1772,296,'core ','296',1224778519,0,'NO'),(1773,296,'cpu ','148',1224778519,0,'NO'),(1774,296,'host ','node-74',1224778519,0,'NO'),(1775,296,'cpuset','3',1224778519,0,'NO'),(1776,296,'network_address','127.0.2.74',1224778519,0,'NO'),(1777,297,'state','Alive',1224778519,0,'NO'),(1778,297,'core ','297',1224778519,0,'NO'),(1779,297,'cpu ','149',1224778519,0,'NO'),(1780,297,'host ','node-75',1224778519,0,'NO'),(1781,297,'cpuset','0',1224778519,0,'NO'),(1782,297,'network_address','127.0.2.75',1224778519,0,'NO'),(1783,298,'state','Alive',1224778520,0,'NO'),(1784,298,'core ','298',1224778520,0,'NO'),(1785,298,'cpu ','149',1224778520,0,'NO'),(1786,298,'host ','node-75',1224778520,0,'NO'),(1787,298,'cpuset','1',1224778520,0,'NO'),(1788,298,'network_address','127.0.2.75',1224778520,0,'NO'),(1789,299,'state','Alive',1224778520,0,'NO'),(1790,299,'core ','299',1224778520,0,'NO'),(1791,299,'cpu ','150',1224778520,0,'NO'),(1792,299,'host ','node-75',1224778520,0,'NO'),(1793,299,'cpuset','2',1224778520,0,'NO'),(1794,299,'network_address','127.0.2.75',1224778520,0,'NO'),(1795,300,'state','Alive',1224778520,0,'NO'),(1796,300,'core ','300',1224778520,0,'NO'),(1797,300,'cpu ','150',1224778520,0,'NO'),(1798,300,'host ','node-75',1224778520,0,'NO'),(1799,300,'cpuset','3',1224778520,0,'NO'),(1800,300,'network_address','127.0.2.75',1224778520,0,'NO'),(1801,301,'state','Alive',1224778520,0,'NO'),(1802,301,'core ','301',1224778520,0,'NO'),(1803,301,'cpu ','151',1224778520,0,'NO'),(1804,301,'host ','node-76',1224778520,0,'NO'),(1805,301,'cpuset','0',1224778520,0,'NO'),(1806,301,'network_address','127.0.2.76',1224778520,0,'NO'),(1807,302,'state','Alive',1224778520,0,'NO'),(1808,302,'core ','302',1224778520,0,'NO'),(1809,302,'cpu ','151',1224778520,0,'NO'),(1810,302,'host ','node-76',1224778520,0,'NO'),(1811,302,'cpuset','1',1224778520,0,'NO'),(1812,302,'network_address','127.0.2.76',1224778520,0,'NO'),(1813,303,'state','Alive',1224778521,0,'NO'),(1814,303,'core ','303',1224778521,0,'NO'),(1815,303,'cpu ','152',1224778521,0,'NO'),(1816,303,'host ','node-76',1224778521,0,'NO'),(1817,303,'cpuset','2',1224778521,0,'NO'),(1818,303,'network_address','127.0.2.76',1224778521,0,'NO'),(1819,304,'state','Alive',1224778521,0,'NO'),(1820,304,'core ','304',1224778521,0,'NO'),(1821,304,'cpu ','152',1224778521,0,'NO'),(1822,304,'host ','node-76',1224778521,0,'NO'),(1823,304,'cpuset','3',1224778521,0,'NO'),(1824,304,'network_address','127.0.2.76',1224778521,0,'NO'),(1825,305,'state','Alive',1224778521,0,'NO'),(1826,305,'core ','305',1224778521,0,'NO'),(1827,305,'cpu ','153',1224778521,0,'NO'),(1828,305,'host ','node-77',1224778521,0,'NO'),(1829,305,'cpuset','0',1224778521,0,'NO'),(1830,305,'network_address','127.0.2.77',1224778521,0,'NO'),(1831,306,'state','Alive',1224778521,0,'NO'),(1832,306,'core ','306',1224778521,0,'NO'),(1833,306,'cpu ','153',1224778521,0,'NO'),(1834,306,'host ','node-77',1224778521,0,'NO'),(1835,306,'cpuset','1',1224778521,0,'NO'),(1836,306,'network_address','127.0.2.77',1224778521,0,'NO'),(1837,307,'state','Alive',1224778521,0,'NO'),(1838,307,'core ','307',1224778521,0,'NO'),(1839,307,'cpu ','154',1224778521,0,'NO'),(1840,307,'host ','node-77',1224778521,0,'NO'),(1841,307,'cpuset','2',1224778521,0,'NO'),(1842,307,'network_address','127.0.2.77',1224778521,0,'NO'),(1843,308,'state','Alive',1224778521,0,'NO'),(1844,308,'core ','308',1224778521,0,'NO'),(1845,308,'cpu ','154',1224778521,0,'NO'),(1846,308,'host ','node-77',1224778521,0,'NO'),(1847,308,'cpuset','3',1224778521,0,'NO'),(1848,308,'network_address','127.0.2.77',1224778521,0,'NO'),(1849,309,'state','Alive',1224778522,0,'NO'),(1850,309,'core ','309',1224778522,0,'NO'),(1851,309,'cpu ','155',1224778522,0,'NO'),(1852,309,'host ','node-78',1224778522,0,'NO'),(1853,309,'cpuset','0',1224778522,0,'NO'),(1854,309,'network_address','127.0.2.78',1224778522,0,'NO'),(1855,310,'state','Alive',1224778522,0,'NO'),(1856,310,'core ','310',1224778522,0,'NO'),(1857,310,'cpu ','155',1224778522,0,'NO'),(1858,310,'host ','node-78',1224778522,0,'NO'),(1859,310,'cpuset','1',1224778522,0,'NO'),(1860,310,'network_address','127.0.2.78',1224778522,0,'NO'),(1861,311,'state','Alive',1224778522,0,'NO'),(1862,311,'core ','311',1224778522,0,'NO'),(1863,311,'cpu ','156',1224778522,0,'NO'),(1864,311,'host ','node-78',1224778522,0,'NO'),(1865,311,'cpuset','2',1224778522,0,'NO'),(1866,311,'network_address','127.0.2.78',1224778522,0,'NO'),(1867,312,'state','Alive',1224778522,0,'NO'),(1868,312,'core ','312',1224778522,0,'NO'),(1869,312,'cpu ','156',1224778522,0,'NO'),(1870,312,'host ','node-78',1224778522,0,'NO'),(1871,312,'cpuset','3',1224778522,0,'NO'),(1872,312,'network_address','127.0.2.78',1224778522,0,'NO'),(1873,313,'state','Alive',1224778522,0,'NO'),(1874,313,'core ','313',1224778522,0,'NO'),(1875,313,'cpu ','157',1224778522,0,'NO'),(1876,313,'host ','node-79',1224778522,0,'NO'),(1877,313,'cpuset','0',1224778522,0,'NO'),(1878,313,'network_address','127.0.2.79',1224778522,0,'NO'),(1879,314,'state','Alive',1224778523,0,'NO'),(1880,314,'core ','314',1224778523,0,'NO'),(1881,314,'cpu ','157',1224778523,0,'NO'),(1882,314,'host ','node-79',1224778523,0,'NO'),(1883,314,'cpuset','1',1224778523,0,'NO'),(1884,314,'network_address','127.0.2.79',1224778523,0,'NO'),(1885,315,'state','Alive',1224778523,0,'NO'),(1886,315,'core ','315',1224778523,0,'NO'),(1887,315,'cpu ','158',1224778523,0,'NO'),(1888,315,'host ','node-79',1224778523,0,'NO'),(1889,315,'cpuset','2',1224778523,0,'NO'),(1890,315,'network_address','127.0.2.79',1224778523,0,'NO'),(1891,316,'state','Alive',1224778523,0,'NO'),(1892,316,'core ','316',1224778523,0,'NO'),(1893,316,'cpu ','158',1224778523,0,'NO'),(1894,316,'host ','node-79',1224778523,0,'NO'),(1895,316,'cpuset','3',1224778523,0,'NO'),(1896,316,'network_address','127.0.2.79',1224778523,0,'NO'),(1897,317,'state','Alive',1224778523,0,'NO'),(1898,317,'core ','317',1224778523,0,'NO'),(1899,317,'cpu ','159',1224778523,0,'NO'),(1900,317,'host ','node-80',1224778523,0,'NO'),(1901,317,'cpuset','0',1224778523,0,'NO'),(1902,317,'network_address','127.0.2.80',1224778523,0,'NO'),(1903,318,'state','Alive',1224778524,0,'NO'),(1904,318,'core ','318',1224778524,0,'NO'),(1905,318,'cpu ','159',1224778524,0,'NO'),(1906,318,'host ','node-80',1224778524,0,'NO'),(1907,318,'cpuset','1',1224778524,0,'NO'),(1908,318,'network_address','127.0.2.80',1224778524,0,'NO'),(1909,319,'state','Alive',1224778524,0,'NO'),(1910,319,'core ','319',1224778524,0,'NO'),(1911,319,'cpu ','160',1224778524,0,'NO'),(1912,319,'host ','node-80',1224778524,0,'NO'),(1913,319,'cpuset','2',1224778524,0,'NO'),(1914,319,'network_address','127.0.2.80',1224778524,0,'NO'),(1915,320,'state','Alive',1224778524,0,'NO'),(1916,320,'core ','320',1224778524,0,'NO'),(1917,320,'cpu ','160',1224778524,0,'NO'),(1918,320,'host ','node-80',1224778524,0,'NO'),(1919,320,'cpuset','3',1224778524,0,'NO'),(1920,320,'network_address','127.0.2.80',1224778524,0,'NO'),(1921,321,'state','Alive',1224778524,0,'NO'),(1922,321,'core ','321',1224778524,0,'NO'),(1923,321,'cpu ','161',1224778524,0,'NO'),(1924,321,'host ','node-81',1224778524,0,'NO'),(1925,321,'cpuset','0',1224778524,0,'NO'),(1926,321,'network_address','127.0.2.81',1224778524,0,'NO'),(1927,322,'state','Alive',1224778525,0,'NO'),(1928,322,'core ','322',1224778525,0,'NO'),(1929,322,'cpu ','161',1224778525,0,'NO'),(1930,322,'host ','node-81',1224778525,0,'NO'),(1931,322,'cpuset','1',1224778525,0,'NO'),(1932,322,'network_address','127.0.2.81',1224778525,0,'NO'),(1933,323,'state','Alive',1224778525,0,'NO'),(1934,323,'core ','323',1224778525,0,'NO'),(1935,323,'cpu ','162',1224778525,0,'NO'),(1936,323,'host ','node-81',1224778525,0,'NO'),(1937,323,'cpuset','2',1224778525,0,'NO'),(1938,323,'network_address','127.0.2.81',1224778525,0,'NO'),(1939,324,'state','Alive',1224778525,0,'NO'),(1940,324,'core ','324',1224778525,0,'NO'),(1941,324,'cpu ','162',1224778525,0,'NO'),(1942,324,'host ','node-81',1224778525,0,'NO'),(1943,324,'cpuset','3',1224778525,0,'NO'),(1944,324,'network_address','127.0.2.81',1224778525,0,'NO'),(1945,325,'state','Alive',1224778525,0,'NO'),(1946,325,'core ','325',1224778525,0,'NO'),(1947,325,'cpu ','163',1224778525,0,'NO'),(1948,325,'host ','node-82',1224778525,0,'NO'),(1949,325,'cpuset','0',1224778525,0,'NO'),(1950,325,'network_address','127.0.2.82',1224778525,0,'NO'),(1951,326,'state','Alive',1224778525,0,'NO'),(1952,326,'core ','326',1224778525,0,'NO'),(1953,326,'cpu ','163',1224778525,0,'NO'),(1954,326,'host ','node-82',1224778525,0,'NO'),(1955,326,'cpuset','1',1224778525,0,'NO'),(1956,326,'network_address','127.0.2.82',1224778525,0,'NO'),(1957,327,'state','Alive',1224778525,0,'NO'),(1958,327,'core ','327',1224778525,0,'NO'),(1959,327,'cpu ','164',1224778525,0,'NO'),(1960,327,'host ','node-82',1224778525,0,'NO'),(1961,327,'cpuset','2',1224778526,0,'NO'),(1962,327,'network_address','127.0.2.82',1224778526,0,'NO'),(1963,328,'state','Alive',1224778526,0,'NO'),(1964,328,'core ','328',1224778526,0,'NO'),(1965,328,'cpu ','164',1224778526,0,'NO'),(1966,328,'host ','node-82',1224778526,0,'NO'),(1967,328,'cpuset','3',1224778526,0,'NO'),(1968,328,'network_address','127.0.2.82',1224778526,0,'NO'),(1969,329,'state','Alive',1224778526,0,'NO'),(1970,329,'core ','329',1224778526,0,'NO'),(1971,329,'cpu ','165',1224778526,0,'NO'),(1972,329,'host ','node-83',1224778526,0,'NO'),(1973,329,'cpuset','0',1224778526,0,'NO'),(1974,329,'network_address','127.0.2.83',1224778526,0,'NO'),(1975,330,'state','Alive',1224778526,0,'NO'),(1976,330,'core ','330',1224778526,0,'NO'),(1977,330,'cpu ','165',1224778526,0,'NO'),(1978,330,'host ','node-83',1224778526,0,'NO'),(1979,330,'cpuset','1',1224778526,0,'NO'),(1980,330,'network_address','127.0.2.83',1224778526,0,'NO'),(1981,331,'state','Alive',1224778526,0,'NO'),(1982,331,'core ','331',1224778526,0,'NO'),(1983,331,'cpu ','166',1224778526,0,'NO'),(1984,331,'host ','node-83',1224778526,0,'NO'),(1985,331,'cpuset','2',1224778526,0,'NO'),(1986,331,'network_address','127.0.2.83',1224778526,0,'NO'),(1987,332,'state','Alive',1224778526,0,'NO'),(1988,332,'core ','332',1224778526,0,'NO'),(1989,332,'cpu ','166',1224778526,0,'NO'),(1990,332,'host ','node-83',1224778526,0,'NO'),(1991,332,'cpuset','3',1224778526,0,'NO'),(1992,332,'network_address','127.0.2.83',1224778526,0,'NO'),(1993,333,'state','Alive',1224778527,0,'NO'),(1994,333,'core ','333',1224778527,0,'NO'),(1995,333,'cpu ','167',1224778527,0,'NO'),(1996,333,'host ','node-84',1224778527,0,'NO'),(1997,333,'cpuset','0',1224778527,0,'NO'),(1998,333,'network_address','127.0.2.84',1224778527,0,'NO'),(1999,334,'state','Alive',1224778527,0,'NO'),(2000,334,'core ','334',1224778527,0,'NO'),(2001,334,'cpu ','167',1224778527,0,'NO'),(2002,334,'host ','node-84',1224778527,0,'NO'),(2003,334,'cpuset','1',1224778527,0,'NO'),(2004,334,'network_address','127.0.2.84',1224778527,0,'NO'),(2005,335,'state','Alive',1224778527,0,'NO'),(2006,335,'core ','335',1224778527,0,'NO'),(2007,335,'cpu ','168',1224778527,0,'NO'),(2008,335,'host ','node-84',1224778527,0,'NO'),(2009,335,'cpuset','2',1224778527,0,'NO'),(2010,335,'network_address','127.0.2.84',1224778527,0,'NO'),(2011,336,'state','Alive',1224778527,0,'NO'),(2012,336,'core ','336',1224778527,0,'NO'),(2013,336,'cpu ','168',1224778527,0,'NO'),(2014,336,'host ','node-84',1224778527,0,'NO'),(2015,336,'cpuset','3',1224778527,0,'NO'),(2016,336,'network_address','127.0.2.84',1224778527,0,'NO'),(2017,337,'state','Alive',1224778527,0,'NO'),(2018,337,'core ','337',1224778527,0,'NO'),(2019,337,'cpu ','169',1224778527,0,'NO'),(2020,337,'host ','node-85',1224778527,0,'NO'),(2021,337,'cpuset','0',1224778527,0,'NO'),(2022,337,'network_address','127.0.2.85',1224778527,0,'NO'),(2023,338,'state','Alive',1224778528,0,'NO'),(2024,338,'core ','338',1224778528,0,'NO'),(2025,338,'cpu ','169',1224778528,0,'NO'),(2026,338,'host ','node-85',1224778528,0,'NO'),(2027,338,'cpuset','1',1224778528,0,'NO'),(2028,338,'network_address','127.0.2.85',1224778528,0,'NO'),(2029,339,'state','Alive',1224778528,0,'NO'),(2030,339,'core ','339',1224778528,0,'NO'),(2031,339,'cpu ','170',1224778528,0,'NO'),(2032,339,'host ','node-85',1224778528,0,'NO'),(2033,339,'cpuset','2',1224778528,0,'NO'),(2034,339,'network_address','127.0.2.85',1224778528,0,'NO'),(2035,340,'state','Alive',1224778528,0,'NO'),(2036,340,'core ','340',1224778528,0,'NO'),(2037,340,'cpu ','170',1224778528,0,'NO'),(2038,340,'host ','node-85',1224778528,0,'NO'),(2039,340,'cpuset','3',1224778528,0,'NO'),(2040,340,'network_address','127.0.2.85',1224778528,0,'NO'),(2041,341,'state','Alive',1224778528,0,'NO'),(2042,341,'core ','341',1224778528,0,'NO'),(2043,341,'cpu ','171',1224778528,0,'NO'),(2044,341,'host ','node-86',1224778528,0,'NO'),(2045,341,'cpuset','0',1224778528,0,'NO'),(2046,341,'network_address','127.0.2.86',1224778528,0,'NO'),(2047,342,'state','Alive',1224778528,0,'NO'),(2048,342,'core ','342',1224778528,0,'NO'),(2049,342,'cpu ','171',1224778528,0,'NO'),(2050,342,'host ','node-86',1224778528,0,'NO'),(2051,342,'cpuset','1',1224778528,0,'NO'),(2052,342,'network_address','127.0.2.86',1224778528,0,'NO'),(2053,343,'state','Alive',1224778529,0,'NO'),(2054,343,'core ','343',1224778529,0,'NO'),(2055,343,'cpu ','172',1224778529,0,'NO'),(2056,343,'host ','node-86',1224778529,0,'NO'),(2057,343,'cpuset','2',1224778529,0,'NO'),(2058,343,'network_address','127.0.2.86',1224778529,0,'NO'),(2059,344,'state','Alive',1224778529,0,'NO'),(2060,344,'core ','344',1224778529,0,'NO'),(2061,344,'cpu ','172',1224778529,0,'NO'),(2062,344,'host ','node-86',1224778529,0,'NO'),(2063,344,'cpuset','3',1224778529,0,'NO'),(2064,344,'network_address','127.0.2.86',1224778529,0,'NO'),(2065,345,'state','Alive',1224778529,0,'NO'),(2066,345,'core ','345',1224778529,0,'NO'),(2067,345,'cpu ','173',1224778529,0,'NO'),(2068,345,'host ','node-87',1224778529,0,'NO'),(2069,345,'cpuset','0',1224778529,0,'NO'),(2070,345,'network_address','127.0.2.87',1224778529,0,'NO'),(2071,346,'state','Alive',1224778529,0,'NO'),(2072,346,'core ','346',1224778529,0,'NO'),(2073,346,'cpu ','173',1224778529,0,'NO'),(2074,346,'host ','node-87',1224778529,0,'NO'),(2075,346,'cpuset','1',1224778529,0,'NO'),(2076,346,'network_address','127.0.2.87',1224778529,0,'NO'),(2077,347,'state','Alive',1224778529,0,'NO'),(2078,347,'core ','347',1224778529,0,'NO'),(2079,347,'cpu ','174',1224778529,0,'NO'),(2080,347,'host ','node-87',1224778529,0,'NO'),(2081,347,'cpuset','2',1224778529,0,'NO'),(2082,347,'network_address','127.0.2.87',1224778529,0,'NO'),(2083,348,'state','Alive',1224778530,0,'NO'),(2084,348,'core ','348',1224778530,0,'NO'),(2085,348,'cpu ','174',1224778530,0,'NO'),(2086,348,'host ','node-87',1224778530,0,'NO'),(2087,348,'cpuset','3',1224778530,0,'NO'),(2088,348,'network_address','127.0.2.87',1224778530,0,'NO'),(2089,349,'state','Alive',1224778530,0,'NO'),(2090,349,'core ','349',1224778530,0,'NO'),(2091,349,'cpu ','175',1224778530,0,'NO'),(2092,349,'host ','node-88',1224778530,0,'NO'),(2093,349,'cpuset','0',1224778530,0,'NO'),(2094,349,'network_address','127.0.2.88',1224778530,0,'NO'),(2095,350,'state','Alive',1224778530,0,'NO'),(2096,350,'core ','350',1224778530,0,'NO'),(2097,350,'cpu ','175',1224778530,0,'NO'),(2098,350,'host ','node-88',1224778530,0,'NO'),(2099,350,'cpuset','1',1224778530,0,'NO'),(2100,350,'network_address','127.0.2.88',1224778530,0,'NO'),(2101,351,'state','Alive',1224778530,0,'NO'),(2102,351,'core ','351',1224778530,0,'NO'),(2103,351,'cpu ','176',1224778530,0,'NO'),(2104,351,'host ','node-88',1224778530,0,'NO'),(2105,351,'cpuset','2',1224778530,0,'NO'),(2106,351,'network_address','127.0.2.88',1224778530,0,'NO'),(2107,352,'state','Alive',1224778530,0,'NO'),(2108,352,'core ','352',1224778530,0,'NO'),(2109,352,'cpu ','176',1224778530,0,'NO'),(2110,352,'host ','node-88',1224778530,0,'NO'),(2111,352,'cpuset','3',1224778530,0,'NO'),(2112,352,'network_address','127.0.2.88',1224778530,0,'NO'),(2113,353,'state','Alive',1224778530,0,'NO'),(2114,353,'core ','353',1224778530,0,'NO'),(2115,353,'cpu ','177',1224778530,0,'NO'),(2116,353,'host ','node-89',1224778530,0,'NO'),(2117,353,'cpuset','0',1224778530,0,'NO'),(2118,353,'network_address','127.0.2.89',1224778530,0,'NO'),(2119,354,'state','Alive',1224778531,0,'NO'),(2120,354,'core ','354',1224778531,0,'NO'),(2121,354,'cpu ','177',1224778531,0,'NO'),(2122,354,'host ','node-89',1224778531,0,'NO'),(2123,354,'cpuset','1',1224778531,0,'NO'),(2124,354,'network_address','127.0.2.89',1224778531,0,'NO'),(2125,355,'state','Alive',1224778531,0,'NO'),(2126,355,'core ','355',1224778531,0,'NO'),(2127,355,'cpu ','178',1224778531,0,'NO'),(2128,355,'host ','node-89',1224778531,0,'NO'),(2129,355,'cpuset','2',1224778531,0,'NO'),(2130,355,'network_address','127.0.2.89',1224778531,0,'NO'),(2131,356,'state','Alive',1224778531,0,'NO'),(2132,356,'core ','356',1224778531,0,'NO'),(2133,356,'cpu ','178',1224778531,0,'NO'),(2134,356,'host ','node-89',1224778531,0,'NO'),(2135,356,'cpuset','3',1224778531,0,'NO'),(2136,356,'network_address','127.0.2.89',1224778531,0,'NO'),(2137,357,'state','Alive',1224778531,0,'NO'),(2138,357,'core ','357',1224778531,0,'NO'),(2139,357,'cpu ','179',1224778531,0,'NO'),(2140,357,'host ','node-90',1224778531,0,'NO'),(2141,357,'cpuset','0',1224778531,0,'NO'),(2142,357,'network_address','127.0.2.90',1224778531,0,'NO'),(2143,358,'state','Alive',1224778531,0,'NO'),(2144,358,'core ','358',1224778531,0,'NO'),(2145,358,'cpu ','179',1224778531,0,'NO'),(2146,358,'host ','node-90',1224778531,0,'NO'),(2147,358,'cpuset','1',1224778531,0,'NO'),(2148,358,'network_address','127.0.2.90',1224778531,0,'NO'),(2149,359,'state','Alive',1224778532,0,'NO'),(2150,359,'core ','359',1224778532,0,'NO'),(2151,359,'cpu ','180',1224778532,0,'NO'),(2152,359,'host ','node-90',1224778532,0,'NO'),(2153,359,'cpuset','2',1224778532,0,'NO'),(2154,359,'network_address','127.0.2.90',1224778532,0,'NO'),(2155,360,'state','Alive',1224778532,0,'NO'),(2156,360,'core ','360',1224778532,0,'NO'),(2157,360,'cpu ','180',1224778532,0,'NO'),(2158,360,'host ','node-90',1224778532,0,'NO'),(2159,360,'cpuset','3',1224778532,0,'NO'),(2160,360,'network_address','127.0.2.90',1224778532,0,'NO'),(2161,361,'state','Alive',1224778532,0,'NO'),(2162,361,'core ','361',1224778532,0,'NO'),(2163,361,'cpu ','181',1224778532,0,'NO'),(2164,361,'host ','node-91',1224778532,0,'NO'),(2165,361,'cpuset','0',1224778532,0,'NO'),(2166,361,'network_address','127.0.2.91',1224778532,0,'NO'),(2167,362,'state','Alive',1224778532,0,'NO'),(2168,362,'core ','362',1224778532,0,'NO'),(2169,362,'cpu ','181',1224778532,0,'NO'),(2170,362,'host ','node-91',1224778532,0,'NO'),(2171,362,'cpuset','1',1224778532,0,'NO'),(2172,362,'network_address','127.0.2.91',1224778532,0,'NO'),(2173,363,'state','Alive',1224778532,0,'NO'),(2174,363,'core ','363',1224778532,0,'NO'),(2175,363,'cpu ','182',1224778532,0,'NO'),(2176,363,'host ','node-91',1224778532,0,'NO'),(2177,363,'cpuset','2',1224778532,0,'NO'),(2178,363,'network_address','127.0.2.91',1224778532,0,'NO'),(2179,364,'state','Alive',1224778533,0,'NO'),(2180,364,'core ','364',1224778533,0,'NO'),(2181,364,'cpu ','182',1224778533,0,'NO'),(2182,364,'host ','node-91',1224778533,0,'NO'),(2183,364,'cpuset','3',1224778533,0,'NO'),(2184,364,'network_address','127.0.2.91',1224778533,0,'NO'),(2185,365,'state','Alive',1224778533,0,'NO'),(2186,365,'core ','365',1224778533,0,'NO'),(2187,365,'cpu ','183',1224778533,0,'NO'),(2188,365,'host ','node-92',1224778533,0,'NO'),(2189,365,'cpuset','0',1224778533,0,'NO'),(2190,365,'network_address','127.0.2.92',1224778533,0,'NO'),(2191,366,'state','Alive',1224778533,0,'NO'),(2192,366,'core ','366',1224778533,0,'NO'),(2193,366,'cpu ','183',1224778533,0,'NO'),(2194,366,'host ','node-92',1224778533,0,'NO'),(2195,366,'cpuset','1',1224778533,0,'NO'),(2196,366,'network_address','127.0.2.92',1224778533,0,'NO'),(2197,367,'state','Alive',1224778533,0,'NO'),(2198,367,'core ','367',1224778533,0,'NO'),(2199,367,'cpu ','184',1224778533,0,'NO'),(2200,367,'host ','node-92',1224778533,0,'NO'),(2201,367,'cpuset','2',1224778533,0,'NO'),(2202,367,'network_address','127.0.2.92',1224778533,0,'NO'),(2203,368,'state','Alive',1224778533,0,'NO'),(2204,368,'core ','368',1224778533,0,'NO'),(2205,368,'cpu ','184',1224778533,0,'NO'),(2206,368,'host ','node-92',1224778533,0,'NO'),(2207,368,'cpuset','3',1224778533,0,'NO'),(2208,368,'network_address','127.0.2.92',1224778533,0,'NO'),(2209,369,'state','Alive',1224778534,0,'NO'),(2210,369,'core ','369',1224778534,0,'NO'),(2211,369,'cpu ','185',1224778534,0,'NO'),(2212,369,'host ','node-93',1224778534,0,'NO'),(2213,369,'cpuset','0',1224778534,0,'NO'),(2214,369,'network_address','127.0.2.93',1224778534,0,'NO'),(2215,370,'state','Alive',1224778534,0,'NO'),(2216,370,'core ','370',1224778534,0,'NO'),(2217,370,'cpu ','185',1224778534,0,'NO'),(2218,370,'host ','node-93',1224778534,0,'NO'),(2219,370,'cpuset','1',1224778534,0,'NO'),(2220,370,'network_address','127.0.2.93',1224778534,0,'NO'),(2221,371,'state','Alive',1224778534,0,'NO'),(2222,371,'core ','371',1224778534,0,'NO'),(2223,371,'cpu ','186',1224778534,0,'NO'),(2224,371,'host ','node-93',1224778534,0,'NO'),(2225,371,'cpuset','2',1224778534,0,'NO'),(2226,371,'network_address','127.0.2.93',1224778534,0,'NO'),(2227,372,'state','Alive',1224778534,0,'NO'),(2228,372,'core ','372',1224778534,0,'NO'),(2229,372,'cpu ','186',1224778534,0,'NO'),(2230,372,'host ','node-93',1224778534,0,'NO'),(2231,372,'cpuset','3',1224778534,0,'NO'),(2232,372,'network_address','127.0.2.93',1224778534,0,'NO'),(2233,373,'state','Alive',1224778534,0,'NO'),(2234,373,'core ','373',1224778534,0,'NO'),(2235,373,'cpu ','187',1224778534,0,'NO'),(2236,373,'host ','node-94',1224778534,0,'NO'),(2237,373,'cpuset','0',1224778534,0,'NO'),(2238,373,'network_address','127.0.2.94',1224778534,0,'NO'),(2239,374,'state','Alive',1224778535,0,'NO'),(2240,374,'core ','374',1224778535,0,'NO'),(2241,374,'cpu ','187',1224778535,0,'NO'),(2242,374,'host ','node-94',1224778535,0,'NO'),(2243,374,'cpuset','1',1224778535,0,'NO'),(2244,374,'network_address','127.0.2.94',1224778535,0,'NO'),(2245,375,'state','Alive',1224778535,0,'NO'),(2246,375,'core ','375',1224778535,0,'NO'),(2247,375,'cpu ','188',1224778535,0,'NO'),(2248,375,'host ','node-94',1224778535,0,'NO'),(2249,375,'cpuset','2',1224778535,0,'NO'),(2250,375,'network_address','127.0.2.94',1224778535,0,'NO'),(2251,376,'state','Alive',1224778535,0,'NO'),(2252,376,'core ','376',1224778535,0,'NO'),(2253,376,'cpu ','188',1224778535,0,'NO'),(2254,376,'host ','node-94',1224778535,0,'NO'),(2255,376,'cpuset','3',1224778535,0,'NO'),(2256,376,'network_address','127.0.2.94',1224778535,0,'NO'),(2257,377,'state','Alive',1224778535,0,'NO'),(2258,377,'core ','377',1224778535,0,'NO'),(2259,377,'cpu ','189',1224778535,0,'NO'),(2260,377,'host ','node-95',1224778535,0,'NO'),(2261,377,'cpuset','0',1224778535,0,'NO'),(2262,377,'network_address','127.0.2.95',1224778535,0,'NO'),(2263,378,'state','Alive',1224778535,0,'NO'),(2264,378,'core ','378',1224778535,0,'NO'),(2265,378,'cpu ','189',1224778535,0,'NO'),(2266,378,'host ','node-95',1224778535,0,'NO'),(2267,378,'cpuset','1',1224778535,0,'NO'),(2268,378,'network_address','127.0.2.95',1224778535,0,'NO'),(2269,379,'state','Alive',1224778535,0,'NO'),(2270,379,'core ','379',1224778535,0,'NO'),(2271,379,'cpu ','190',1224778535,0,'NO'),(2272,379,'host ','node-95',1224778535,0,'NO'),(2273,379,'cpuset','2',1224778535,0,'NO'),(2274,379,'network_address','127.0.2.95',1224778535,0,'NO'),(2275,380,'state','Alive',1224778536,0,'NO'),(2276,380,'core ','380',1224778536,0,'NO'),(2277,380,'cpu ','190',1224778536,0,'NO'),(2278,380,'host ','node-95',1224778536,0,'NO'),(2279,380,'cpuset','3',1224778536,0,'NO'),(2280,380,'network_address','127.0.2.95',1224778536,0,'NO'),(2281,381,'state','Alive',1224778536,0,'NO'),(2282,381,'core ','381',1224778536,0,'NO'),(2283,381,'cpu ','191',1224778536,0,'NO'),(2284,381,'host ','node-96',1224778536,0,'NO'),(2285,381,'cpuset','0',1224778536,0,'NO'),(2286,381,'network_address','127.0.2.96',1224778536,0,'NO'),(2287,382,'state','Alive',1224778536,0,'NO'),(2288,382,'core ','382',1224778536,0,'NO'),(2289,382,'cpu ','191',1224778536,0,'NO'),(2290,382,'host ','node-96',1224778536,0,'NO'),(2291,382,'cpuset','1',1224778536,0,'NO'),(2292,382,'network_address','127.0.2.96',1224778536,0,'NO'),(2293,383,'state','Alive',1224778536,0,'NO'),(2294,383,'core ','383',1224778536,0,'NO'),(2295,383,'cpu ','192',1224778536,0,'NO'),(2296,383,'host ','node-96',1224778536,0,'NO'),(2297,383,'cpuset','2',1224778536,0,'NO'),(2298,383,'network_address','127.0.2.96',1224778536,0,'NO'),(2299,384,'state','Alive',1224778536,0,'NO'),(2300,384,'core ','384',1224778536,0,'NO'),(2301,384,'cpu ','192',1224778536,0,'NO'),(2302,384,'host ','node-96',1224778536,0,'NO'),(2303,384,'cpuset','3',1224778536,0,'NO'),(2304,384,'network_address','127.0.2.96',1224778536,0,'NO');
/*!40000 ALTER TABLE `resource_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `resources`
--

DROP TABLE IF EXISTS `resources`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `resources` (
  `resource_id` int(10) unsigned NOT NULL auto_increment,
  `type` varchar(100) NOT NULL default 'default',
  `network_address` varchar(100) NOT NULL,
  `state` enum('Alive','Dead','Suspected','Absent') NOT NULL,
  `next_state` enum('UnChanged','Alive','Dead','Absent','Suspected') NOT NULL default 'UnChanged',
  `finaud_decision` enum('YES','NO') NOT NULL default 'NO',
  `next_finaud_decision` enum('YES','NO') NOT NULL default 'NO',
  `state_num` int(11) NOT NULL default '0',
  `suspended_jobs` enum('YES','NO') NOT NULL default 'NO',
  `scheduler_priority` int(10) unsigned NOT NULL default '0',
  `cpuset` int(10) unsigned NOT NULL default '0',
  `besteffort` enum('YES','NO') NOT NULL default 'YES',
  `deploy` enum('YES','NO') NOT NULL default 'NO',
  `expiry_date` int(10) unsigned NOT NULL,
  `desktop_computing` enum('YES','NO') NOT NULL default 'NO',
  `last_job_date` int(10) unsigned default '0',
  `available_upto` int(10) unsigned NOT NULL default '0',
  `host` varchar(255) default NULL,
  `cpu` int(11) default NULL,
  `core` int(11) default NULL,
  PRIMARY KEY  (`resource_id`),
  KEY `state` (`state`),
  KEY `next_state` (`next_state`),
  KEY `suspended_jobs` (`suspended_jobs`),
  KEY `type` (`type`),
  KEY `network_address` (`network_address`)
) ENGINE=MyISAM AUTO_INCREMENT=385 DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `resources`
--

LOCK TABLES `resources` WRITE;
/*!40000 ALTER TABLE `resources` DISABLE KEYS */;
INSERT INTO `resources` VALUES (1,'default','127.0.2.1','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-1',1,1),(2,'default','127.0.2.1','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-1',1,2),(3,'default','127.0.2.1','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-1',2,3),(4,'default','127.0.2.1','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-1',2,4),(5,'default','127.0.2.2','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-2',3,5),(6,'default','127.0.2.2','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-2',3,6),(7,'default','127.0.2.2','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-2',4,7),(8,'default','127.0.2.2','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-2',4,8),(9,'default','127.0.2.3','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-3',5,9),(10,'default','127.0.2.3','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-3',5,10),(11,'default','127.0.2.3','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-3',6,11),(12,'default','127.0.2.3','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-3',6,12),(13,'default','127.0.2.4','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-4',7,13),(14,'default','127.0.2.4','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-4',7,14),(15,'default','127.0.2.4','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-4',8,15),(16,'default','127.0.2.4','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-4',8,16),(17,'default','127.0.2.5','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-5',9,17),(18,'default','127.0.2.5','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-5',9,18),(19,'default','127.0.2.5','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-5',10,19),(20,'default','127.0.2.5','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-5',10,20),(21,'default','127.0.2.6','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-6',11,21),(22,'default','127.0.2.6','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-6',11,22),(23,'default','127.0.2.6','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-6',12,23),(24,'default','127.0.2.6','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-6',12,24),(25,'default','127.0.2.7','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-7',13,25),(26,'default','127.0.2.7','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-7',13,26),(27,'default','127.0.2.7','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-7',14,27),(28,'default','127.0.2.7','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-7',14,28),(29,'default','127.0.2.8','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-8',15,29),(30,'default','127.0.2.8','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-8',15,30),(31,'default','127.0.2.8','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-8',16,31),(32,'default','127.0.2.8','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-8',16,32),(33,'default','127.0.2.9','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-9',17,33),(34,'default','127.0.2.9','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-9',17,34),(35,'default','127.0.2.9','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-9',18,35),(36,'default','127.0.2.9','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-9',18,36),(37,'default','127.0.2.10','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-10',19,37),(38,'default','127.0.2.10','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-10',19,38),(39,'default','127.0.2.10','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-10',20,39),(40,'default','127.0.2.10','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-10',20,40),(41,'default','127.0.2.11','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-11',21,41),(42,'default','127.0.2.11','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-11',21,42),(43,'default','127.0.2.11','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-11',22,43),(44,'default','127.0.2.11','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-11',22,44),(45,'default','127.0.2.12','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-12',23,45),(46,'default','127.0.2.12','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-12',23,46),(47,'default','127.0.2.12','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-12',24,47),(48,'default','127.0.2.12','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-12',24,48),(49,'default','127.0.2.13','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-13',25,49),(50,'default','127.0.2.13','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-13',25,50),(51,'default','127.0.2.13','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-13',26,51),(52,'default','127.0.2.13','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-13',26,52),(53,'default','127.0.2.14','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-14',27,53),(54,'default','127.0.2.14','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-14',27,54),(55,'default','127.0.2.14','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-14',28,55),(56,'default','127.0.2.14','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-14',28,56),(57,'default','127.0.2.15','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-15',29,57),(58,'default','127.0.2.15','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-15',29,58),(59,'default','127.0.2.15','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-15',30,59),(60,'default','127.0.2.15','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-15',30,60),(61,'default','127.0.2.16','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-16',31,61),(62,'default','127.0.2.16','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-16',31,62),(63,'default','127.0.2.16','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-16',32,63),(64,'default','127.0.2.16','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-16',32,64),(65,'default','127.0.2.17','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-17',33,65),(66,'default','127.0.2.17','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-17',33,66),(67,'default','127.0.2.17','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-17',34,67),(68,'default','127.0.2.17','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-17',34,68),(69,'default','127.0.2.18','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-18',35,69),(70,'default','127.0.2.18','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-18',35,70),(71,'default','127.0.2.18','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-18',36,71),(72,'default','127.0.2.18','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-18',36,72),(73,'default','127.0.2.19','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-19',37,73),(74,'default','127.0.2.19','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-19',37,74),(75,'default','127.0.2.19','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-19',38,75),(76,'default','127.0.2.19','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-19',38,76),(77,'default','127.0.2.20','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-20',39,77),(78,'default','127.0.2.20','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-20',39,78),(79,'default','127.0.2.20','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-20',40,79),(80,'default','127.0.2.20','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-20',40,80),(81,'default','127.0.2.21','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-21',41,81),(82,'default','127.0.2.21','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-21',41,82),(83,'default','127.0.2.21','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-21',42,83),(84,'default','127.0.2.21','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-21',42,84),(85,'default','127.0.2.22','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-22',43,85),(86,'default','127.0.2.22','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-22',43,86),(87,'default','127.0.2.22','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-22',44,87),(88,'default','127.0.2.22','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-22',44,88),(89,'default','127.0.2.23','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-23',45,89),(90,'default','127.0.2.23','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-23',45,90),(91,'default','127.0.2.23','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-23',46,91),(92,'default','127.0.2.23','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-23',46,92),(93,'default','127.0.2.24','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-24',47,93),(94,'default','127.0.2.24','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-24',47,94),(95,'default','127.0.2.24','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-24',48,95),(96,'default','127.0.2.24','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-24',48,96),(97,'default','127.0.2.25','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-25',49,97),(98,'default','127.0.2.25','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-25',49,98),(99,'default','127.0.2.25','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-25',50,99),(100,'default','127.0.2.25','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-25',50,100),(101,'default','127.0.2.26','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-26',51,101),(102,'default','127.0.2.26','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-26',51,102),(103,'default','127.0.2.26','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-26',52,103),(104,'default','127.0.2.26','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-26',52,104),(105,'default','127.0.2.27','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-27',53,105),(106,'default','127.0.2.27','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-27',53,106),(107,'default','127.0.2.27','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-27',54,107),(108,'default','127.0.2.27','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-27',54,108),(109,'default','127.0.2.28','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-28',55,109),(110,'default','127.0.2.28','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-28',55,110),(111,'default','127.0.2.28','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-28',56,111),(112,'default','127.0.2.28','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-28',56,112),(113,'default','127.0.2.29','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-29',57,113),(114,'default','127.0.2.29','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-29',57,114),(115,'default','127.0.2.29','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-29',58,115),(116,'default','127.0.2.29','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-29',58,116),(117,'default','127.0.2.30','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-30',59,117),(118,'default','127.0.2.30','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-30',59,118),(119,'default','127.0.2.30','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-30',60,119),(120,'default','127.0.2.30','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-30',60,120),(121,'default','127.0.2.31','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-31',61,121),(122,'default','127.0.2.31','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-31',61,122),(123,'default','127.0.2.31','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-31',62,123),(124,'default','127.0.2.31','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-31',62,124),(125,'default','127.0.2.32','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-32',63,125),(126,'default','127.0.2.32','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-32',63,126),(127,'default','127.0.2.32','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-32',64,127),(128,'default','127.0.2.32','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-32',64,128),(129,'default','127.0.2.33','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-33',65,129),(130,'default','127.0.2.33','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-33',65,130),(131,'default','127.0.2.33','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-33',66,131),(132,'default','127.0.2.33','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-33',66,132),(133,'default','127.0.2.34','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-34',67,133),(134,'default','127.0.2.34','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-34',67,134),(135,'default','127.0.2.34','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-34',68,135),(136,'default','127.0.2.34','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-34',68,136),(137,'default','127.0.2.35','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-35',69,137),(138,'default','127.0.2.35','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-35',69,138),(139,'default','127.0.2.35','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-35',70,139),(140,'default','127.0.2.35','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-35',70,140),(141,'default','127.0.2.36','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-36',71,141),(142,'default','127.0.2.36','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-36',71,142),(143,'default','127.0.2.36','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-36',72,143),(144,'default','127.0.2.36','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-36',72,144),(145,'default','127.0.2.37','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-37',73,145),(146,'default','127.0.2.37','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-37',73,146),(147,'default','127.0.2.37','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-37',74,147),(148,'default','127.0.2.37','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-37',74,148),(149,'default','127.0.2.38','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-38',75,149),(150,'default','127.0.2.38','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-38',75,150),(151,'default','127.0.2.38','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-38',76,151),(152,'default','127.0.2.38','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-38',76,152),(153,'default','127.0.2.39','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-39',77,153),(154,'default','127.0.2.39','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-39',77,154),(155,'default','127.0.2.39','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-39',78,155),(156,'default','127.0.2.39','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-39',78,156),(157,'default','127.0.2.40','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-40',79,157),(158,'default','127.0.2.40','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-40',79,158),(159,'default','127.0.2.40','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-40',80,159),(160,'default','127.0.2.40','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-40',80,160),(161,'default','127.0.2.41','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-41',81,161),(162,'default','127.0.2.41','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-41',81,162),(163,'default','127.0.2.41','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-41',82,163),(164,'default','127.0.2.41','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-41',82,164),(165,'default','127.0.2.42','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-42',83,165),(166,'default','127.0.2.42','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-42',83,166),(167,'default','127.0.2.42','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-42',84,167),(168,'default','127.0.2.42','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-42',84,168),(169,'default','127.0.2.43','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-43',85,169),(170,'default','127.0.2.43','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-43',85,170),(171,'default','127.0.2.43','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-43',86,171),(172,'default','127.0.2.43','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-43',86,172),(173,'default','127.0.2.44','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-44',87,173),(174,'default','127.0.2.44','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-44',87,174),(175,'default','127.0.2.44','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-44',88,175),(176,'default','127.0.2.44','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-44',88,176),(177,'default','127.0.2.45','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-45',89,177),(178,'default','127.0.2.45','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-45',89,178),(179,'default','127.0.2.45','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-45',90,179),(180,'default','127.0.2.45','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-45',90,180),(181,'default','127.0.2.46','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-46',91,181),(182,'default','127.0.2.46','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-46',91,182),(183,'default','127.0.2.46','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-46',92,183),(184,'default','127.0.2.46','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-46',92,184),(185,'default','127.0.2.47','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-47',93,185),(186,'default','127.0.2.47','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-47',93,186),(187,'default','127.0.2.47','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-47',94,187),(188,'default','127.0.2.47','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-47',94,188),(189,'default','127.0.2.48','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-48',95,189),(190,'default','127.0.2.48','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-48',95,190),(191,'default','127.0.2.48','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-48',96,191),(192,'default','127.0.2.48','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-48',96,192),(193,'default','127.0.2.49','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-49',97,193),(194,'default','127.0.2.49','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-49',97,194),(195,'default','127.0.2.49','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-49',98,195),(196,'default','127.0.2.49','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-49',98,196),(197,'default','127.0.2.50','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-50',99,197),(198,'default','127.0.2.50','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-50',99,198),(199,'default','127.0.2.50','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-50',100,199),(200,'default','127.0.2.50','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-50',100,200),(201,'default','127.0.2.51','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-51',101,201),(202,'default','127.0.2.51','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-51',101,202),(203,'default','127.0.2.51','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-51',102,203),(204,'default','127.0.2.51','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-51',102,204),(205,'default','127.0.2.52','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-52',103,205),(206,'default','127.0.2.52','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-52',103,206),(207,'default','127.0.2.52','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-52',104,207),(208,'default','127.0.2.52','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-52',104,208),(209,'default','127.0.2.53','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-53',105,209),(210,'default','127.0.2.53','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-53',105,210),(211,'default','127.0.2.53','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-53',106,211),(212,'default','127.0.2.53','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-53',106,212),(213,'default','127.0.2.54','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-54',107,213),(214,'default','127.0.2.54','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-54',107,214),(215,'default','127.0.2.54','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-54',108,215),(216,'default','127.0.2.54','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-54',108,216),(217,'default','127.0.2.55','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-55',109,217),(218,'default','127.0.2.55','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-55',109,218),(219,'default','127.0.2.55','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-55',110,219),(220,'default','127.0.2.55','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-55',110,220),(221,'default','127.0.2.56','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-56',111,221),(222,'default','127.0.2.56','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-56',111,222),(223,'default','127.0.2.56','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-56',112,223),(224,'default','127.0.2.56','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-56',112,224),(225,'default','127.0.2.57','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-57',113,225),(226,'default','127.0.2.57','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-57',113,226),(227,'default','127.0.2.57','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-57',114,227),(228,'default','127.0.2.57','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-57',114,228),(229,'default','127.0.2.58','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-58',115,229),(230,'default','127.0.2.58','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-58',115,230),(231,'default','127.0.2.58','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-58',116,231),(232,'default','127.0.2.58','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-58',116,232),(233,'default','127.0.2.59','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-59',117,233),(234,'default','127.0.2.59','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-59',117,234),(235,'default','127.0.2.59','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-59',118,235),(236,'default','127.0.2.59','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-59',118,236),(237,'default','127.0.2.60','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-60',119,237),(238,'default','127.0.2.60','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-60',119,238),(239,'default','127.0.2.60','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-60',120,239),(240,'default','127.0.2.60','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-60',120,240),(241,'default','127.0.2.61','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-61',121,241),(242,'default','127.0.2.61','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-61',121,242),(243,'default','127.0.2.61','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-61',122,243),(244,'default','127.0.2.61','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-61',122,244),(245,'default','127.0.2.62','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-62',123,245),(246,'default','127.0.2.62','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-62',123,246),(247,'default','127.0.2.62','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-62',124,247),(248,'default','127.0.2.62','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-62',124,248),(249,'default','127.0.2.63','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-63',125,249),(250,'default','127.0.2.63','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-63',125,250),(251,'default','127.0.2.63','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-63',126,251),(252,'default','127.0.2.63','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-63',126,252),(253,'default','127.0.2.64','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-64',127,253),(254,'default','127.0.2.64','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-64',127,254),(255,'default','127.0.2.64','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-64',128,255),(256,'default','127.0.2.64','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-64',128,256),(257,'default','127.0.2.65','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-65',129,257),(258,'default','127.0.2.65','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-65',129,258),(259,'default','127.0.2.65','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-65',130,259),(260,'default','127.0.2.65','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-65',130,260),(261,'default','127.0.2.66','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-66',131,261),(262,'default','127.0.2.66','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-66',131,262),(263,'default','127.0.2.66','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-66',132,263),(264,'default','127.0.2.66','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-66',132,264),(265,'default','127.0.2.67','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-67',133,265),(266,'default','127.0.2.67','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-67',133,266),(267,'default','127.0.2.67','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-67',134,267),(268,'default','127.0.2.67','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-67',134,268),(269,'default','127.0.2.68','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-68',135,269),(270,'default','127.0.2.68','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-68',135,270),(271,'default','127.0.2.68','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-68',136,271),(272,'default','127.0.2.68','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-68',136,272),(273,'default','127.0.2.69','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-69',137,273),(274,'default','127.0.2.69','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-69',137,274),(275,'default','127.0.2.69','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-69',138,275),(276,'default','127.0.2.69','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-69',138,276),(277,'default','127.0.2.70','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-70',139,277),(278,'default','127.0.2.70','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-70',139,278),(279,'default','127.0.2.70','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-70',140,279),(280,'default','127.0.2.70','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-70',140,280),(281,'default','127.0.2.71','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-71',141,281),(282,'default','127.0.2.71','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-71',141,282),(283,'default','127.0.2.71','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-71',142,283),(284,'default','127.0.2.71','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-71',142,284),(285,'default','127.0.2.72','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-72',143,285),(286,'default','127.0.2.72','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-72',143,286),(287,'default','127.0.2.72','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-72',144,287),(288,'default','127.0.2.72','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-72',144,288),(289,'default','127.0.2.73','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-73',145,289),(290,'default','127.0.2.73','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-73',145,290),(291,'default','127.0.2.73','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-73',146,291),(292,'default','127.0.2.73','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-73',146,292),(293,'default','127.0.2.74','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-74',147,293),(294,'default','127.0.2.74','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-74',147,294),(295,'default','127.0.2.74','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-74',148,295),(296,'default','127.0.2.74','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-74',148,296),(297,'default','127.0.2.75','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-75',149,297),(298,'default','127.0.2.75','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-75',149,298),(299,'default','127.0.2.75','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-75',150,299),(300,'default','127.0.2.75','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-75',150,300),(301,'default','127.0.2.76','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-76',151,301),(302,'default','127.0.2.76','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-76',151,302),(303,'default','127.0.2.76','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-76',152,303),(304,'default','127.0.2.76','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-76',152,304),(305,'default','127.0.2.77','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-77',153,305),(306,'default','127.0.2.77','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-77',153,306),(307,'default','127.0.2.77','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-77',154,307),(308,'default','127.0.2.77','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-77',154,308),(309,'default','127.0.2.78','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-78',155,309),(310,'default','127.0.2.78','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-78',155,310),(311,'default','127.0.2.78','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-78',156,311),(312,'default','127.0.2.78','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-78',156,312),(313,'default','127.0.2.79','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-79',157,313),(314,'default','127.0.2.79','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-79',157,314),(315,'default','127.0.2.79','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-79',158,315),(316,'default','127.0.2.79','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-79',158,316),(317,'default','127.0.2.80','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-80',159,317),(318,'default','127.0.2.80','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-80',159,318),(319,'default','127.0.2.80','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-80',160,319),(320,'default','127.0.2.80','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-80',160,320),(321,'default','127.0.2.81','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-81',161,321),(322,'default','127.0.2.81','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-81',161,322),(323,'default','127.0.2.81','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-81',162,323),(324,'default','127.0.2.81','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-81',162,324),(325,'default','127.0.2.82','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-82',163,325),(326,'default','127.0.2.82','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-82',163,326),(327,'default','127.0.2.82','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-82',164,327),(328,'default','127.0.2.82','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-82',164,328),(329,'default','127.0.2.83','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-83',165,329),(330,'default','127.0.2.83','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-83',165,330),(331,'default','127.0.2.83','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-83',166,331),(332,'default','127.0.2.83','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-83',166,332),(333,'default','127.0.2.84','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-84',167,333),(334,'default','127.0.2.84','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-84',167,334),(335,'default','127.0.2.84','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-84',168,335),(336,'default','127.0.2.84','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-84',168,336),(337,'default','127.0.2.85','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-85',169,337),(338,'default','127.0.2.85','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-85',169,338),(339,'default','127.0.2.85','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-85',170,339),(340,'default','127.0.2.85','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-85',170,340),(341,'default','127.0.2.86','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-86',171,341),(342,'default','127.0.2.86','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-86',171,342),(343,'default','127.0.2.86','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-86',172,343),(344,'default','127.0.2.86','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-86',172,344),(345,'default','127.0.2.87','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-87',173,345),(346,'default','127.0.2.87','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-87',173,346),(347,'default','127.0.2.87','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-87',174,347),(348,'default','127.0.2.87','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-87',174,348),(349,'default','127.0.2.88','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-88',175,349),(350,'default','127.0.2.88','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-88',175,350),(351,'default','127.0.2.88','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-88',176,351),(352,'default','127.0.2.88','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-88',176,352),(353,'default','127.0.2.89','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-89',177,353),(354,'default','127.0.2.89','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-89',177,354),(355,'default','127.0.2.89','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-89',178,355),(356,'default','127.0.2.89','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-89',178,356),(357,'default','127.0.2.90','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-90',179,357),(358,'default','127.0.2.90','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-90',179,358),(359,'default','127.0.2.90','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-90',180,359),(360,'default','127.0.2.90','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-90',180,360),(361,'default','127.0.2.91','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-91',181,361),(362,'default','127.0.2.91','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-91',181,362),(363,'default','127.0.2.91','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-91',182,363),(364,'default','127.0.2.91','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-91',182,364),(365,'default','127.0.2.92','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-92',183,365),(366,'default','127.0.2.92','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-92',183,366),(367,'default','127.0.2.92','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-92',184,367),(368,'default','127.0.2.92','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-92',184,368),(369,'default','127.0.2.93','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-93',185,369),(370,'default','127.0.2.93','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-93',185,370),(371,'default','127.0.2.93','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-93',186,371),(372,'default','127.0.2.93','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-93',186,372),(373,'default','127.0.2.94','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-94',187,373),(374,'default','127.0.2.94','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-94',187,374),(375,'default','127.0.2.94','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-94',188,375),(376,'default','127.0.2.94','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-94',188,376),(377,'default','127.0.2.95','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-95',189,377),(378,'default','127.0.2.95','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-95',189,378),(379,'default','127.0.2.95','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-95',190,379),(380,'default','127.0.2.95','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-95',190,380),(381,'default','127.0.2.96','Alive','UnChanged','NO','NO',1,'NO',0,0,'YES','NO',0,'NO',0,0,'node-96',191,381),(382,'default','127.0.2.96','Alive','UnChanged','NO','NO',1,'NO',0,1,'YES','NO',0,'NO',0,0,'node-96',191,382),(383,'default','127.0.2.96','Alive','UnChanged','NO','NO',1,'NO',0,2,'YES','NO',0,'NO',0,0,'node-96',192,383),(384,'default','127.0.2.96','Alive','UnChanged','NO','NO',1,'NO',0,3,'YES','NO',0,'NO',0,0,'node-96',192,384);
/*!40000 ALTER TABLE `resources` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `schema`
--

DROP TABLE IF EXISTS `schema`;
SET @saved_cs_client     = @@character_set_client;
SET character_set_client = utf8;
CREATE TABLE `schema` (
  `version` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
SET character_set_client = @saved_cs_client;

--
-- Dumping data for table `schema`
--

LOCK TABLES `schema` WRITE;
/*!40000 ALTER TABLE `schema` DISABLE KEYS */;
INSERT INTO `schema` VALUES ('2.3.0+svn1369');
/*!40000 ALTER TABLE `schema` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2008-10-23 16:18:51
