'\" t
.\"     Title: xisetclientpointer
.\"    Author: [FIXME: author] [see http://www.docbook.org/tdg5/en/html/author]
.\" Generator: DocBook XSL Stylesheets vsnapshot <http://docbook.sf.net/>
.\"      Date: 09/05/2024
.\"    Manual: \ \&
.\"    Source: \ \&
.\"  Language: English
.\"
.TH "XISETCLIENTPOINTER" "libmansuffix" "09/05/2024" "\ \&" "\ \&"
.\" -----------------------------------------------------------------
.\" * Define some portability stuff
.\" -----------------------------------------------------------------
.\" ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
.\" http://bugs.debian.org/507673
.\" http://lists.gnu.org/archive/html/groff/2009-02/msg00013.html
.\" ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
.ie \n(.g .ds Aq \(aq
.el       .ds Aq '
.\" -----------------------------------------------------------------
.\" * set default formatting
.\" -----------------------------------------------------------------
.\" disable hyphenation
.nh
.\" disable justification (adjust text to left margin only)
.ad l
.\" -----------------------------------------------------------------
.\" * MAIN CONTENT STARTS HERE *
.\" -----------------------------------------------------------------
.SH "NAME"
XISetClientPointer, XIGetClientPointer \- set or get the ClientPointer device\&.
.SH "SYNOPSIS"
.sp
.nf
#include <X11/extensions/XInput2\&.h>
.fi
.sp
.nf
XISetClientPointer( Display *display,
                    Window win,
                    int deviceid);
.fi
.sp
.nf
Bool XIGetClientPointer( Display *display,
                         Window win,
                         int *device);
.fi
.sp
.nf
display
       Specifies the connection to the X server\&.
.fi
.sp
.nf
win
       Specifies a window belonging to the client\&. May be None\&.
.fi
.sp
.nf
deviceid
       Specifies the ClientPointer device\&.
.fi
.SH "DESCRIPTION"
.sp
.if n \{\
.RS 4
.\}
.nf
The ClientPointer is the device that is perceived to be the
core pointer for non\-XI protocol requests and replies\&. Each
time a protocol message needs device\-dependent data and the
device is not explicitly given, the ClientPointer device is
used to obtain the data\&. For example, a XQueryPointer request
will return the coordinates of the ClientPointer\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
XISetClientPointer request sets the ClientPointer device for
the client that owns the given window\&. If win is None, the
requesting client\*(Aqs ClientPointer is set to the device
specified with deviceid\&. Only master pointer devices can be set
as ClientPointer\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
XISetClientPointer and can generate a BadDevice and a BadWindow
error\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
The XIGetClientPointer request returns the ClientPointer\*(Aqs
device ID for the client that owns the given window\&. If win is
None, the requesting client\*(Aqs ClientPointer is returned\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
win may be a client ID instead of a window\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
XIGetClientPointer can generate a BadWindow error\&.
.fi
.if n \{\
.RE
.\}
.SH "DIAGNOSTICS"
.sp
.if n \{\
.RS 4
.\}
.nf
BadDevice
       An invalid device was specified\&. The device does not
       exist or is not a master pointer device\&.
.fi
.if n \{\
.RE
.\}
.sp
.if n \{\
.RS 4
.\}
.nf
BadWindow
       A value for a Window argument does not name a defined
       window\&.
.fi
.if n \{\
.RE
.\}
