; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-none-eabi < %s | FileCheck %s

; CHECK: .LCPI0_0:
; CHECK: 	.byte	0                               // 0x0
; CHECK: 	.byte	16                              // 0x10
; CHECK: 	.byte	32                              // 0x20
; CHECK: 	.byte	48                              // 0x30
; CHECK: 	.byte	2                               // 0x2
; CHECK: 	.byte	18                              // 0x12
; CHECK: 	.byte	34                              // 0x22
; CHECK: 	.byte	50                              // 0x32
; CHECK: 	.byte	4                               // 0x4
; CHECK: 	.byte	20                              // 0x14
; CHECK: 	.byte	36                              // 0x24
; CHECK: 	.byte	52                              // 0x34
; CHECK: 	.byte	6                               // 0x6
; CHECK: 	.byte	22                              // 0x16
; CHECK: 	.byte	38                              // 0x26
; CHECK: 	.byte	54                              // 0x36
define <16 x i8> @shuffle4_v4i8_16(<4 x i8> %a, <4 x i8> %b, <4 x i8> %c, <4 x i8> %d) {
; CHECK-LABEL: shuffle4_v4i8_16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI0_0
; CHECK-NEXT:    // kill: def $d3 killed $d3 killed $q0_q1_q2_q3 def $q0_q1_q2_q3
; CHECK-NEXT:    // kill: def $d2 killed $d2 killed $q0_q1_q2_q3 def $q0_q1_q2_q3
; CHECK-NEXT:    // kill: def $d1 killed $d1 killed $q0_q1_q2_q3 def $q0_q1_q2_q3
; CHECK-NEXT:    ldr q4, [x8, :lo12:.LCPI0_0]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0_q1_q2_q3 def $q0_q1_q2_q3
; CHECK-NEXT:    tbl v0.16b, { v0.16b, v1.16b, v2.16b, v3.16b }, v4.16b
; CHECK-NEXT:    ret
  %x = shufflevector <4 x i8> %a, <4 x i8> %b, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %y = shufflevector <4 x i8> %c, <4 x i8> %d, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %z = shufflevector <8 x i8> %x, <8 x i8> %y, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
  ret <16 x i8> %z
}

; CHECK: .LCPI1_0:
; CHECK: 	.byte	0                               // 0x0
; CHECK: 	.byte	16                              // 0x10
; CHECK: 	.byte	32                              // 0x20
; CHECK: 	.byte	48                              // 0x30
; CHECK: 	.byte	2                               // 0x2
; CHECK: 	.byte	18                              // 0x12
; CHECK: 	.byte	34                              // 0x22
; CHECK: 	.byte	50                              // 0x32
define <8 x i8> @shuffle4_v4i8_8(<4 x i8> %a, <4 x i8> %b, <4 x i8> %c, <4 x i8> %d) {
; CHECK-LABEL: shuffle4_v4i8_8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI1_0
; CHECK-NEXT:    // kill: def $d3 killed $d3 killed $q0_q1_q2_q3 def $q0_q1_q2_q3
; CHECK-NEXT:    // kill: def $d2 killed $d2 killed $q0_q1_q2_q3 def $q0_q1_q2_q3
; CHECK-NEXT:    // kill: def $d1 killed $d1 killed $q0_q1_q2_q3 def $q0_q1_q2_q3
; CHECK-NEXT:    ldr d4, [x8, :lo12:.LCPI1_0]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0_q1_q2_q3 def $q0_q1_q2_q3
; CHECK-NEXT:    tbl v0.8b, { v0.16b, v1.16b, v2.16b, v3.16b }, v4.8b
; CHECK-NEXT:    ret
  %x = shufflevector <4 x i8> %a, <4 x i8> %b, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %y = shufflevector <4 x i8> %c, <4 x i8> %d, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %z = shufflevector <8 x i8> %x, <8 x i8> %y, <8 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13>
  ret <8 x i8> %z
}

; CHECK: .LCPI2_0:
; CHECK: 	.byte	0                               // 0x0
; CHECK: 	.byte	3                               // 0x3
; CHECK: 	.byte	2                               // 0x2
; CHECK: 	.byte	1                               // 0x1
; CHECK: 	.byte	12                              // 0xc
; CHECK: 	.byte	15                              // 0xf
; CHECK: 	.byte	14                              // 0xe
; CHECK: 	.byte	12                              // 0xc
; CHECK: .LCPI2_1:
; CHECK: 	.byte	4                               // 0x4
; CHECK: 	.byte	7                               // 0x7
; CHECK: 	.byte	6                               // 0x6
; CHECK: 	.byte	7                               // 0x7
; CHECK: 	.byte	8                               // 0x8
; CHECK: 	.byte	10                              // 0xa
; CHECK: 	.byte	9                               // 0x9
; CHECK: 	.byte	11                              // 0xb
; CHECK: 	.section	.rodata.cst16,"aM",@progbits,16
; CHECK: 	.p2align	4
; CHECK: .LCPI2_2:
; CHECK: 	.byte	0                               // 0x0
; CHECK: 	.byte	4                               // 0x4
; CHECK: 	.byte	16                              // 0x10
; CHECK: 	.byte	20                              // 0x14
; CHECK: 	.byte	1                               // 0x1
; CHECK: 	.byte	5                               // 0x5
; CHECK: 	.byte	17                              // 0x11
; CHECK: 	.byte	21                              // 0x15
; CHECK: 	.byte	2                               // 0x2
; CHECK: 	.byte	6                               // 0x6
; CHECK: 	.byte	18                              // 0x12
; CHECK: 	.byte	22                              // 0x16
; CHECK: 	.byte	3                               // 0x3
; CHECK: 	.byte	7                               // 0x7
; CHECK: 	.byte	19                              // 0x13
; CHECK: 	.byte	23                              // 0x17
define <16 x i8> @shuffle4_v8i8(<8 x i8> %a, <8 x i8> %b, <8 x i8> %c, <8 x i8> %d) {
; CHECK-LABEL: shuffle4_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI2_0
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    adrp x9, .LCPI2_1
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-NEXT:    // kill: def $d3 killed $d3 def $q3
; CHECK-NEXT:    mov v2.d[1], v3.d[0]
; CHECK-NEXT:    ldr d1, [x8, :lo12:.LCPI2_0]
; CHECK-NEXT:    adrp x8, .LCPI2_2
; CHECK-NEXT:    ldr d3, [x9, :lo12:.LCPI2_1]
; CHECK-NEXT:    tbl v0.8b, { v0.16b }, v1.8b
; CHECK-NEXT:    tbl v1.8b, { v2.16b }, v3.8b
; CHECK-NEXT:    ldr q2, [x8, :lo12:.LCPI2_2]
; CHECK-NEXT:    tbl v0.16b, { v0.16b, v1.16b }, v2.16b
; CHECK-NEXT:    ret
  %x = shufflevector <8 x i8> %a, <8 x i8> %b, <8 x i32> <i32 0, i32 3, i32 2, i32 1, i32 12, i32 15, i32 14, i32 12>
  %y = shufflevector <8 x i8> %c, <8 x i8> %d, <8 x i32> <i32 4, i32 7, i32 6, i32 7, i32 8, i32 10, i32 9, i32 11>
  %z = shufflevector <8 x i8> %x, <8 x i8> %y, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
  ret <16 x i8> %z
}

; CHECK: .LCPI3_0:
; CHECK: 	.byte	0                               // 0x0
; CHECK: 	.byte	3                               // 0x3
; CHECK: 	.byte	2                               // 0x2
; CHECK: 	.byte	1                               // 0x1
; CHECK: 	.byte	12                              // 0xc
; CHECK: 	.byte	15                              // 0xf
; CHECK: 	.byte	14                              // 0xe
; CHECK: 	.byte	12                              // 0xc
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
; CHECK: .LCPI3_1:
; CHECK: 	.byte	4                               // 0x4
; CHECK: 	.byte	7                               // 0x7
; CHECK: 	.byte	6                               // 0x6
; CHECK: 	.byte	7                               // 0x7
; CHECK: 	.byte	8                               // 0x8
; CHECK: 	.byte	10                              // 0xa
; CHECK: 	.byte	9                               // 0x9
; CHECK: 	.byte	11                              // 0xb
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
; CHECK: .LCPI3_2:
; CHECK: 	.byte	16                              // 0x10
; CHECK: 	.byte	20                              // 0x14
; CHECK: 	.byte	0                               // 0x0
; CHECK: 	.byte	4                               // 0x4
; CHECK: 	.byte	17                              // 0x11
; CHECK: 	.byte	21                              // 0x15
; CHECK: 	.byte	1                               // 0x1
; CHECK: 	.byte	5                               // 0x5
; CHECK: 	.byte	18                              // 0x12
; CHECK: 	.byte	22                              // 0x16
; CHECK: 	.byte	2                               // 0x2
; CHECK: 	.byte	6                               // 0x6
; CHECK: 	.byte	19                              // 0x13
; CHECK: 	.byte	23                              // 0x17
; CHECK: 	.byte	3                               // 0x3
; CHECK: 	.byte	7                               // 0x7
define <16 x i8> @shuffle4_v16i8(<16 x i8> %a, <16 x i8> %b, <16 x i8> %c, <16 x i8> %d) {
; CHECK-LABEL: shuffle4_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI3_0
; CHECK-NEXT:    adrp x9, .LCPI3_1
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI3_0]
; CHECK-NEXT:    adrp x8, .LCPI3_2
; CHECK-NEXT:    ldr q3, [x9, :lo12:.LCPI3_1]
; CHECK-NEXT:    tbl v1.16b, { v0.16b }, v1.16b
; CHECK-NEXT:    tbl v0.16b, { v2.16b }, v3.16b
; CHECK-NEXT:    ldr q2, [x8, :lo12:.LCPI3_2]
; CHECK-NEXT:    tbl v0.16b, { v0.16b, v1.16b }, v2.16b
; CHECK-NEXT:    ret
  %x = shufflevector <16 x i8> %a, <16 x i8> %b, <8 x i32> <i32 0, i32 3, i32 2, i32 1, i32 12, i32 15, i32 14, i32 12>
  %y = shufflevector <16 x i8> %c, <16 x i8> %d, <8 x i32> <i32 4, i32 7, i32 6, i32 7, i32 8, i32 10, i32 9, i32 11>
  %z = shufflevector <8 x i8> %x, <8 x i8> %y, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
  ret <16 x i8> %z
}

; CHECK: .LCPI4_0:
; CHECK: 	.byte	0                               // 0x0
; CHECK: 	.byte	1                               // 0x1
; CHECK: 	.byte	8                               // 0x8
; CHECK: 	.byte	9                               // 0x9
; CHECK: 	.byte	16                              // 0x10
; CHECK: 	.byte	17                              // 0x11
; CHECK: 	.byte	24                              // 0x18
; CHECK: 	.byte	25                              // 0x19
; CHECK: 	.byte	2                               // 0x2
; CHECK: 	.byte	3                               // 0x3
; CHECK: 	.byte	10                              // 0xa
; CHECK: 	.byte	11                              // 0xb
; CHECK: 	.byte	18                              // 0x12
; CHECK: 	.byte	19                              // 0x13
; CHECK: 	.byte	26                              // 0x1a
; CHECK: 	.byte	27                              // 0x1b
define <8 x i16> @shuffle4_v8i16(<4 x i16> %a, <4 x i16> %b, <4 x i16> %c, <4 x i16> %d) {
; CHECK-LABEL: shuffle4_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmov d5, d2
; CHECK-NEXT:    adrp x8, .LCPI4_0
; CHECK-NEXT:    fmov d4, d0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    // kill: def $d3 killed $d3 def $q3
; CHECK-NEXT:    ldr q0, [x8, :lo12:.LCPI4_0]
; CHECK-NEXT:    mov v4.d[1], v1.d[0]
; CHECK-NEXT:    mov v5.d[1], v3.d[0]
; CHECK-NEXT:    tbl v0.16b, { v4.16b, v5.16b }, v0.16b
; CHECK-NEXT:    ret
  %x = shufflevector <4 x i16> %a, <4 x i16> %b, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %y = shufflevector <4 x i16> %c, <4 x i16> %d, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %z = shufflevector <8 x i16> %x, <8 x i16> %y, <8 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13>
  ret <8 x i16> %z
}

define <4 x i32> @shuffle4_v4i32(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c, <4 x i32> %d) {
; CHECK-LABEL: shuffle4_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    rev64 v3.4s, v3.4s
; CHECK-NEXT:    zip1 v4.4s, v1.4s, v1.4s
; CHECK-NEXT:    zip2 v1.4s, v3.4s, v2.4s
; CHECK-NEXT:    ext v0.16b, v4.16b, v0.16b, #4
; CHECK-NEXT:    mov v1.d[1], v0.d[1]
; CHECK-NEXT:    mov v0.16b, v1.16b
; CHECK-NEXT:    ret
  %x = shufflevector <4 x i32> %a, <4 x i32> %b, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %y = shufflevector <4 x i32> %c, <4 x i32> %d, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %z = shufflevector <8 x i32> %x, <8 x i32> %y, <4 x i32> <i32 15, i32 10, i32 5, i32 0>
  ret <4 x i32> %z
}

; CHECK: .LCPI6_0:
; CHECK: 	.byte	0                               // 0x0
; CHECK: 	.byte	7                               // 0x7
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	1                               // 0x1
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.section	.rodata.cst16,"aM",@progbits,16
; CHECK: 	.p2align	4
; CHECK: .LCPI6_1:
; CHECK: 	.byte	0                               // 0x0
; CHECK: 	.byte	16                              // 0x10
; CHECK: 	.byte	19                              // 0x13
; CHECK: 	.byte	3                               // 0x3
; CHECK: 	.byte	1                               // 0x1
; CHECK: 	.byte	17                              // 0x11
; CHECK: 	.byte	0                               // 0x0
; CHECK: 	.byte	1                               // 0x1
; CHECK: 	.byte	0                               // 0x0
; CHECK: 	.byte	16                              // 0x10
; CHECK: 	.byte	19                              // 0x13
; CHECK: 	.byte	3                               // 0x3
; CHECK: 	.byte	1                               // 0x1
; CHECK: 	.byte	17                              // 0x11
; CHECK: 	.byte	0                               // 0x0
; CHECK: 	.byte	1                               // 0x1
define <16 x i8> @shuffle4_v8i8_v16i8(<8 x i8> %a, <8 x i8> %b, <8 x i8> %c, <8 x i8> %d) {
; CHECK-LABEL: shuffle4_v8i8_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI6_0
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov v2.d[1], v2.d[0]
; CHECK-NEXT:    mov v0.d[1], v0.d[0]
; CHECK-NEXT:    ldr d1, [x8, :lo12:.LCPI6_0]
; CHECK-NEXT:    adrp x8, .LCPI6_1
; CHECK-NEXT:    tbl v3.8b, { v2.16b }, v1.8b
; CHECK-NEXT:    tbl v2.8b, { v0.16b }, v1.8b
; CHECK-NEXT:    ldr q0, [x8, :lo12:.LCPI6_1]
; CHECK-NEXT:    tbl v0.16b, { v2.16b, v3.16b }, v0.16b
; CHECK-NEXT:    ret
  %x = shufflevector <8 x i8> %a, <8 x i8> %b, <4 x i32> <i32 0, i32 7, i32 5, i32 1>
  %y = shufflevector <8 x i8> %c, <8 x i8> %d, <4 x i32> <i32 0, i32 7, i32 5, i32 1>
  %z = shufflevector <4 x i8> %x, <4 x i8> %y, <16 x i32> <i32 0, i32 4, i32 7, i32 3, i32 1, i32 5, i32 0, i32 1, i32 0, i32 4, i32 7, i32 3, i32 1, i32 5, i32 0, i32 1>
  ret <16 x i8> %z
}

; CHECK: .LCPI7_0:
; CHECK: 	.byte	0                               // 0x0
; CHECK: 	.byte	7                               // 0x7
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	1                               // 0x1
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
; CHECK: .LCPI7_1:
; CHECK: 	.byte	0                               // 0x0
; CHECK: 	.byte	8                               // 0x8
; CHECK: 	.byte	11                              // 0xb
; CHECK: 	.byte	3                               // 0x3
; CHECK: 	.byte	1                               // 0x1
; CHECK: 	.byte	9                               // 0x9
; CHECK: 	.byte	0                               // 0x0
; CHECK: 	.byte	1                               // 0x1
define <8 x i8> @shuffle4_v8i8_v8i8(<8 x i8> %a, <8 x i8> %b, <8 x i8> %c, <8 x i8> %d) {
; CHECK-LABEL: shuffle4_v8i8_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI7_0
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov v2.d[1], v2.d[0]
; CHECK-NEXT:    mov v0.d[1], v0.d[0]
; CHECK-NEXT:    ldr d1, [x8, :lo12:.LCPI7_0]
; CHECK-NEXT:    adrp x8, .LCPI7_1
; CHECK-NEXT:    tbl v2.8b, { v2.16b }, v1.8b
; CHECK-NEXT:    tbl v0.8b, { v0.16b }, v1.8b
; CHECK-NEXT:    ldr d1, [x8, :lo12:.LCPI7_1]
; CHECK-NEXT:    mov v0.d[1], v2.d[0]
; CHECK-NEXT:    tbl v0.8b, { v0.16b }, v1.8b
; CHECK-NEXT:    ret
  %x = shufflevector <8 x i8> %a, <8 x i8> %b, <4 x i32> <i32 0, i32 7, i32 5, i32 1>
  %y = shufflevector <8 x i8> %c, <8 x i8> %d, <4 x i32> <i32 0, i32 7, i32 5, i32 1>
  %z = shufflevector <4 x i8> %x, <4 x i8> %y, <8 x i32> <i32 0, i32 4, i32 7, i32 3, i32 1, i32 5, i32 0, i32 1>
  ret <8 x i8> %z
}

; CHECK: .LCPI8_0:
; CHECK: 	.byte	0                               // 0x0
; CHECK: 	.byte	1                               // 0x1
; CHECK: 	.byte	8                               // 0x8
; CHECK: 	.byte	9                               // 0x9
; CHECK: 	.byte	16                              // 0x10
; CHECK: 	.byte	17                              // 0x11
; CHECK: 	.byte	24                              // 0x18
; CHECK: 	.byte	25                              // 0x19
; CHECK: 	.byte	2                               // 0x2
; CHECK: 	.byte	3                               // 0x3
; CHECK: 	.byte	10                              // 0xa
; CHECK: 	.byte	11                              // 0xb
; CHECK: 	.byte	18                              // 0x12
; CHECK: 	.byte	19                              // 0x13
; CHECK: 	.byte	26                              // 0x1a
; CHECK: 	.byte	27                              // 0x1b
define <8 x i16> @shuffle4_v4i8_zext(<4 x i8> %a, <4 x i8> %b, <4 x i8> %c, <4 x i8> %d) {
; CHECK-LABEL: shuffle4_v4i8_zext:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp1 v0.8b, v0.8b, v1.8b
; CHECK-NEXT:    adrp x8, .LCPI8_0
; CHECK-NEXT:    uzp1 v2.8b, v2.8b, v3.8b
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI8_0]
; CHECK-NEXT:    ushll v3.8h, v0.8b, #0
; CHECK-NEXT:    ushll v4.8h, v2.8b, #0
; CHECK-NEXT:    tbl v0.16b, { v3.16b, v4.16b }, v1.16b
; CHECK-NEXT:    ret
  %x = shufflevector <4 x i8> %a, <4 x i8> %b, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %y = shufflevector <4 x i8> %c, <4 x i8> %d, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %xe = zext <8 x i8> %x to <8 x i16>
  %ye = zext <8 x i8> %y to <8 x i16>
  %z = shufflevector <8 x i16> %xe, <8 x i16> %ye, <8 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13>
  ret <8 x i16> %z
}

; CHECK: .LCPI9_0:
; CHECK: 	.byte	0                               // 0x0
; CHECK: 	.byte	16                              // 0x10
; CHECK: 	.byte	32                              // 0x20
; CHECK: 	.byte	48                              // 0x30
; CHECK: 	.byte	2                               // 0x2
; CHECK: 	.byte	18                              // 0x12
; CHECK: 	.byte	34                              // 0x22
; CHECK: 	.byte	50                              // 0x32
; CHECK: 	.byte	4                               // 0x4
; CHECK: 	.byte	20                              // 0x14
; CHECK: 	.byte	36                              // 0x24
; CHECK: 	.byte	52                              // 0x34
; CHECK: 	.byte	6                               // 0x6
; CHECK: 	.byte	22                              // 0x16
; CHECK: 	.byte	38                              // 0x26
; CHECK: 	.byte	54                              // 0x36
define <16 x i8> @shuffle4_v4i16_trunc(<4 x i16> %ae, <4 x i16> %be, <4 x i16> %ce, <4 x i16> %de) {
; CHECK-LABEL: shuffle4_v4i16_trunc:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI9_0
; CHECK-NEXT:    // kill: def $d3 killed $d3 killed $q0_q1_q2_q3 def $q0_q1_q2_q3
; CHECK-NEXT:    // kill: def $d2 killed $d2 killed $q0_q1_q2_q3 def $q0_q1_q2_q3
; CHECK-NEXT:    // kill: def $d1 killed $d1 killed $q0_q1_q2_q3 def $q0_q1_q2_q3
; CHECK-NEXT:    ldr q4, [x8, :lo12:.LCPI9_0]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0_q1_q2_q3 def $q0_q1_q2_q3
; CHECK-NEXT:    tbl v0.16b, { v0.16b, v1.16b, v2.16b, v3.16b }, v4.16b
; CHECK-NEXT:    ret
  %a = trunc <4 x i16> %ae to <4 x i8>
  %b = trunc <4 x i16> %be to <4 x i8>
  %c = trunc <4 x i16> %ce to <4 x i8>
  %d = trunc <4 x i16> %de to <4 x i8>
  %x = shufflevector <4 x i8> %a, <4 x i8> %b, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %y = shufflevector <4 x i8> %c, <4 x i8> %d, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %z = shufflevector <8 x i8> %x, <8 x i8> %y, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
  ret <16 x i8> %z
}

; CHECK: .LCPI10_0:
; CHECK: 	.byte	0                               // 0x0
; CHECK: 	.byte	16                              // 0x10
; CHECK: 	.byte	32                              // 0x20
; CHECK: 	.byte	48                              // 0x30
; CHECK: 	.byte	2                               // 0x2
; CHECK: 	.byte	18                              // 0x12
; CHECK: 	.byte	34                              // 0x22
; CHECK: 	.byte	50                              // 0x32
; CHECK: 	.byte	4                               // 0x4
; CHECK: 	.byte	20                              // 0x14
; CHECK: 	.byte	36                              // 0x24
; CHECK: 	.byte	52                              // 0x34
; CHECK: 	.byte	6                               // 0x6
; CHECK: 	.byte	22                              // 0x16
; CHECK: 	.byte	38                              // 0x26
; CHECK: 	.byte	54                              // 0x36
; CHECK: 	.text
define <16 x i8> @shuffle4_v4i32_trunc(<4 x i32> %ae, <4 x i32> %be, <4 x i32> %ce, <4 x i32> %de) {
; CHECK-LABEL: shuffle4_v4i32_trunc:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI10_0
; CHECK-NEXT:    xtn v4.4h, v0.4s
; CHECK-NEXT:    xtn v5.4h, v1.4s
; CHECK-NEXT:    xtn v6.4h, v2.4s
; CHECK-NEXT:    ldr q0, [x8, :lo12:.LCPI10_0]
; CHECK-NEXT:    xtn v7.4h, v3.4s
; CHECK-NEXT:    tbl v0.16b, { v4.16b, v5.16b, v6.16b, v7.16b }, v0.16b
; CHECK-NEXT:    ret
  %a = trunc <4 x i32> %ae to <4 x i8>
  %b = trunc <4 x i32> %be to <4 x i8>
  %c = trunc <4 x i32> %ce to <4 x i8>
  %d = trunc <4 x i32> %de to <4 x i8>
  %x = shufflevector <4 x i8> %a, <4 x i8> %b, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %y = shufflevector <4 x i8> %c, <4 x i8> %d, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %z = shufflevector <8 x i8> %x, <8 x i8> %y, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 1, i32 5, i32 9, i32 13, i32 2, i32 6, i32 10, i32 14, i32 3, i32 7, i32 11, i32 15>
  ret <16 x i8> %z
}

; CHECK: .LCPI11_0:
; CHECK: 	.byte	0                               // 0x0
; CHECK: 	.byte	16                              // 0x10
; CHECK: 	.byte	32                              // 0x20
; CHECK: 	.byte	2                               // 0x2
; CHECK: 	.byte	18                              // 0x12
; CHECK: 	.byte	34                              // 0x22
; CHECK: 	.byte	4                               // 0x4
; CHECK: 	.byte	20                              // 0x14
; CHECK: 	.byte	36                              // 0x24
; CHECK: 	.byte	6                               // 0x6
; CHECK: 	.byte	22                              // 0x16
; CHECK: 	.byte	38                              // 0x26
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
define <12 x i8> @shuffle3_v4i8(<4 x i8> %a, <4 x i8> %b, <4 x i8> %c) {
; CHECK-LABEL: shuffle3_v4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI11_0
; CHECK-NEXT:    // kill: def $d2 killed $d2 killed $q0_q1_q2 def $q0_q1_q2
; CHECK-NEXT:    // kill: def $d1 killed $d1 killed $q0_q1_q2 def $q0_q1_q2
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0_q1_q2 def $q0_q1_q2
; CHECK-NEXT:    ldr q3, [x8, :lo12:.LCPI11_0]
; CHECK-NEXT:    tbl v0.16b, { v0.16b, v1.16b, v2.16b }, v3.16b
; CHECK-NEXT:    ret
  %x = shufflevector <4 x i8> %a, <4 x i8> %b, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %y = shufflevector <4 x i8> %c, <4 x i8> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %z = shufflevector <8 x i8> %x, <8 x i8> %y, <12 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6, i32 10, i32 3, i32 7, i32 11>
  ret <12 x i8> %z
}

; CHECK: .LCPI12_0:
; CHECK: 	.byte	0                               // 0x0
; CHECK: 	.byte	1                               // 0x1
; CHECK: 	.byte	8                               // 0x8
; CHECK: 	.byte	9                               // 0x9
; CHECK: 	.byte	16                              // 0x10
; CHECK: 	.byte	17                              // 0x11
; CHECK: 	.byte	2                               // 0x2
; CHECK: 	.byte	3                               // 0x3
; CHECK: 	.byte	10                              // 0xa
; CHECK: 	.byte	11                              // 0xb
; CHECK: 	.byte	18                              // 0x12
; CHECK: 	.byte	19                              // 0x13
; CHECK: 	.byte	4                               // 0x4
; CHECK: 	.byte	5                               // 0x5
; CHECK: 	.byte	12                              // 0xc
; CHECK: 	.byte	13                              // 0xd
define <8 x i16> @shuffle3_v4i16(<4 x i16> %a, <4 x i16> %b, <4 x i16> %c) {
; CHECK-LABEL: shuffle3_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fmov d3, d2
; CHECK-NEXT:    adrp x8, .LCPI12_0
; CHECK-NEXT:    fmov d2, d0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $q1
; CHECK-NEXT:    ldr q0, [x8, :lo12:.LCPI12_0]
; CHECK-NEXT:    mov v2.d[1], v1.d[0]
; CHECK-NEXT:    tbl v0.16b, { v2.16b, v3.16b }, v0.16b
; CHECK-NEXT:    ret
  %x = shufflevector <4 x i16> %a, <4 x i16> %b, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %y = shufflevector <4 x i16> %c, <4 x i16> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %z = shufflevector <8 x i16> %x, <8 x i16> %y, <8 x i32> <i32 0, i32 4, i32 8, i32 1, i32 5, i32 9, i32 2, i32 6>
  ret <8 x i16> %z
}

define <4 x i32> @shuffle3_v4i32(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; CHECK-LABEL: shuffle3_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    trn1 v1.4s, v0.4s, v1.4s
; CHECK-NEXT:    mov v1.d[1], v0.d[0]
; CHECK-NEXT:    mov v1.s[2], v2.s[0]
; CHECK-NEXT:    mov v0.16b, v1.16b
; CHECK-NEXT:    ret
  %x = shufflevector <4 x i32> %a, <4 x i32> %b, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %y = shufflevector <4 x i32> %c, <4 x i32> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %z = shufflevector <8 x i32> %x, <8 x i32> %y, <4 x i32> <i32 0, i32 4, i32 8, i32 1>
  ret <4 x i32> %z
}

; CHECK: .LCPI14_0:
; CHECK: 	.byte	4                               // 0x4
; CHECK: 	.byte	8                               // 0x8
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	14                              // 0xe
; CHECK: 	.byte	3                               // 0x3
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.section	.rodata.cst16,"aM",@progbits,16
; CHECK: 	.p2align	4
; CHECK: .LCPI14_1:
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	15                              // 0xf
; CHECK: 	.byte	27                              // 0x1b
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	24                              // 0x18
; CHECK: 	.byte	12                              // 0xc
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
; CHECK: 	.byte	255                             // 0xff
define <8 x i8> @insert4_v8i8(<8 x i8> %a, <16 x i8> %b, <8 x i8> %c, <16 x i8> %d) {
; CHECK-LABEL: insert4_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI14_0
; CHECK-NEXT:    adrp x9, .LCPI14_1
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov v4.16b, v3.16b
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    mov v0.d[1], v2.d[0]
; CHECK-NEXT:    mov v3.16b, v1.16b
; CHECK-NEXT:    ldr d1, [x8, :lo12:.LCPI14_0]
; CHECK-NEXT:    ldr q2, [x9, :lo12:.LCPI14_1]
; CHECK-NEXT:    tbl v0.8b, { v0.16b }, v1.8b
; CHECK-NEXT:    tbl v1.16b, { v3.16b, v4.16b }, v2.16b
; CHECK-NEXT:    trn1 v0.4h, v1.4h, v0.4h
; CHECK-NEXT:    trn2 v0.4h, v0.4h, v1.4h
; CHECK-NEXT:    ret
  %e1 = extractelement <8 x i8> %a, i32 4
  %e2 = extractelement <8 x i8> %c, i32 0
  %e3 = extractelement <16 x i8> %b, i32 15
  %e4 = extractelement <16 x i8> %d, i32 11
  %e5 = extractelement <8 x i8> %c, i32 6
  %e6 = extractelement <8 x i8> %a, i32 3
  %e7 = extractelement <16 x i8> %d, i32 8
  %e8 = extractelement <16 x i8> %b, i32 12
  %i1 = insertelement <8 x i8> undef, i8 %e1, i32 0
  %i2 = insertelement <8 x i8> %i1, i8 %e2, i32 1
  %i3 = insertelement <8 x i8> %i2, i8 %e3, i32 2
  %i4 = insertelement <8 x i8> %i3, i8 %e4, i32 3
  %i5 = insertelement <8 x i8> %i4, i8 %e5, i32 4
  %i6 = insertelement <8 x i8> %i5, i8 %e6, i32 5
  %i7 = insertelement <8 x i8> %i6, i8 %e7, i32 6
  %i8 = insertelement <8 x i8> %i7, i8 %e8, i32 7
  ret <8 x i8> %i8
}

; CHECK: .LCPI15_0:
; CHECK: .byte 255                             // 0xff
; CHECK: .byte 255                             // 0xff
; CHECK: .byte 15                              // 0xf
; CHECK: .byte 27                              // 0x1b
; CHECK: .byte 255                             // 0xff
; CHECK: .byte 255                             // 0xff
; CHECK: .byte 24                              // 0x18
; CHECK: .byte 12                              // 0xc
; CHECK: .byte 255                             // 0xff
; CHECK: .byte 255                             // 0xff
; CHECK: .byte 15                              // 0xf
; CHECK: .byte 27                              // 0x1b
; CHECK: .byte 255                             // 0xff
; CHECK: .byte 255                             // 0xff
; CHECK: .byte 24                              // 0x18
; CHECK: .byte 12                              // 0xc
; CHECK: .LCPI15_1:
; CHECK: .byte 20                              // 0x14
; CHECK: .byte 24                              // 0x18
; CHECK: .byte 2                               // 0x2
; CHECK: .byte 3                               // 0x3
; CHECK: .byte 30                              // 0x1e
; CHECK: .byte 19                              // 0x13
; CHECK: .byte 6                               // 0x6
; CHECK: .byte 7                               // 0x7
; CHECK: .byte 20                              // 0x14
; CHECK: .byte 24                              // 0x18
; CHECK: .byte 10                              // 0xa
; CHECK: .byte 11                              // 0xb
; CHECK: .byte 30                              // 0x1e
; CHECK: .byte 19                              // 0x13
; CHECK: .byte 14                              // 0xe
; CHECK: .byte 15                              // 0xf
define <16 x i8> @insert4_v16i8(<8 x i8> %a, <16 x i8> %b, <8 x i8> %c, <16 x i8> %d) {
; CHECK-LABEL: insert4_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI15_0
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q31_q0
; CHECK-NEXT:    // kill: def $d2 killed $d2 def $q2
; CHECK-NEXT:    mov v4.16b, v3.16b
; CHECK-NEXT:    mov v3.16b, v1.16b
; CHECK-NEXT:    ldr q5, [x8, :lo12:.LCPI15_0]
; CHECK-NEXT:    adrp x8, .LCPI15_1
; CHECK-NEXT:    mov v0.d[1], v2.d[0]
; CHECK-NEXT:    tbl v31.16b, { v3.16b, v4.16b }, v5.16b
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI15_1]
; CHECK-NEXT:    tbl v0.16b, { v31.16b, v0.16b }, v1.16b
; CHECK-NEXT:    ret
  %e1 = extractelement <8 x i8> %a, i32 4
  %e2 = extractelement <8 x i8> %c, i32 0
  %e3 = extractelement <16 x i8> %b, i32 15
  %e4 = extractelement <16 x i8> %d, i32 11
  %e5 = extractelement <8 x i8> %c, i32 6
  %e6 = extractelement <8 x i8> %a, i32 3
  %e7 = extractelement <16 x i8> %d, i32 8
  %e8 = extractelement <16 x i8> %b, i32 12
  %e9 = extractelement <8 x i8> %a, i32 4
  %e10 = extractelement <8 x i8> %c, i32 0
  %e11 = extractelement <16 x i8> %b, i32 15
  %e12 = extractelement <16 x i8> %d, i32 11
  %e13 = extractelement <8 x i8> %c, i32 6
  %e14 = extractelement <8 x i8> %a, i32 3
  %e15 = extractelement <16 x i8> %d, i32 8
  %e16 = extractelement <16 x i8> %b, i32 12
  %i1 = insertelement <16 x i8> undef, i8 %e1, i32 0
  %i2 = insertelement <16 x i8> %i1, i8 %e2, i32 1
  %i3 = insertelement <16 x i8> %i2, i8 %e3, i32 2
  %i4 = insertelement <16 x i8> %i3, i8 %e4, i32 3
  %i5 = insertelement <16 x i8> %i4, i8 %e5, i32 4
  %i6 = insertelement <16 x i8> %i5, i8 %e6, i32 5
  %i7 = insertelement <16 x i8> %i6, i8 %e7, i32 6
  %i8 = insertelement <16 x i8> %i7, i8 %e8, i32 7
  %i9 = insertelement <16 x i8> %i8, i8 %e9, i32 8
  %i10 = insertelement <16 x i8> %i9, i8 %e10, i32 9
  %i11 = insertelement <16 x i8> %i10, i8 %e11, i32 10
  %i12 = insertelement <16 x i8> %i11, i8 %e12, i32 11
  %i13 = insertelement <16 x i8> %i12, i8 %e13, i32 12
  %i14 = insertelement <16 x i8> %i13, i8 %e14, i32 13
  %i15 = insertelement <16 x i8> %i14, i8 %e15, i32 14
  %i16 = insertelement <16 x i8> %i15, i8 %e16, i32 15
  ret <16 x i8> %i16
}


; CHECK: .LCPI16_0:
; CHECK: 	.byte	0
; CHECK: 	.byte	1
; CHECK: 	.byte	4
; CHECK: 	.byte	5
; CHECK: 	.byte	16
; CHECK: 	.byte	17
; CHECK: 	.byte	20
; CHECK: 	.byte	21
; CHECK: 	.byte	32
; CHECK: 	.byte	33
; CHECK: 	.byte	36
; CHECK: 	.byte	37
; CHECK: 	.byte	48
; CHECK: 	.byte	49
; CHECK: 	.byte	52
; CHECK: 	.byte	53
define <16 x i16> @test(<2 x double> %l213, <2 x double> %l231, <2 x double> %l249, <2 x double> %l267, <2 x double> %l285, <2 x double> %l303, <2 x double> %l321, <2 x double> %l339) {
; CHECK-LABEL: test:
; CHECK:       // %bb.0:
; CHECK-NEXT:    frintm v0.2d, v0.2d
; CHECK-NEXT:    adrp x8, .LCPI16_0
; CHECK-NEXT:    frintm v4.2d, v4.2d
; CHECK-NEXT:    frintm v1.2d, v1.2d
; CHECK-NEXT:    frintm v5.2d, v5.2d
; CHECK-NEXT:    frintm v2.2d, v2.2d
; CHECK-NEXT:    frintm v6.2d, v6.2d
; CHECK-NEXT:    frintm v3.2d, v3.2d
; CHECK-NEXT:    frintm v7.2d, v7.2d
; CHECK-NEXT:    fcvtzs v0.2d, v0.2d
; CHECK-NEXT:    fcvtzs v4.2d, v4.2d
; CHECK-NEXT:    fcvtzs v1.2d, v1.2d
; CHECK-NEXT:    fcvtzs v5.2d, v5.2d
; CHECK-NEXT:    fcvtzs v2.2d, v2.2d
; CHECK-NEXT:    fcvtzs v6.2d, v6.2d
; CHECK-NEXT:    fcvtzs v3.2d, v3.2d
; CHECK-NEXT:    xtn v16.2s, v0.2d
; CHECK-NEXT:    fcvtzs v0.2d, v7.2d
; CHECK-NEXT:    xtn v20.2s, v4.2d
; CHECK-NEXT:    xtn v17.2s, v1.2d
; CHECK-NEXT:    xtn v21.2s, v5.2d
; CHECK-NEXT:    xtn v18.2s, v2.2d
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI16_0]
; CHECK-NEXT:    xtn v22.2s, v6.2d
; CHECK-NEXT:    xtn v19.2s, v3.2d
; CHECK-NEXT:    xtn v23.2s, v0.2d
; CHECK-NEXT:    tbl v2.16b, { v16.16b, v17.16b, v18.16b, v19.16b }, v1.16b
; CHECK-NEXT:    tbl v1.16b, { v20.16b, v21.16b, v22.16b, v23.16b }, v1.16b
; CHECK-NEXT:    uzp1 v0.8h, v2.8h, v1.8h
; CHECK-NEXT:    uzp2 v1.8h, v2.8h, v1.8h
; CHECK-NEXT:    ret
  %l214 = call fast <2 x double> @llvm.floor.v2f64(<2 x double> %l213)
  %l215 = fptosi <2 x double> %l214 to <2 x i16>
  %l232 = call fast <2 x double> @llvm.floor.v2f64(<2 x double> %l231)
  %l233 = fptosi <2 x double> %l232 to <2 x i16>
  %l250 = call fast <2 x double> @llvm.floor.v2f64(<2 x double> %l249)
  %l251 = fptosi <2 x double> %l250 to <2 x i16>
  %l268 = call fast <2 x double> @llvm.floor.v2f64(<2 x double> %l267)
  %l269 = fptosi <2 x double> %l268 to <2 x i16>
  %l286 = call fast <2 x double> @llvm.floor.v2f64(<2 x double> %l285)
  %l287 = fptosi <2 x double> %l286 to <2 x i16>
  %l304 = call fast <2 x double> @llvm.floor.v2f64(<2 x double> %l303)
  %l305 = fptosi <2 x double> %l304 to <2 x i16>
  %l322 = call fast <2 x double> @llvm.floor.v2f64(<2 x double> %l321)
  %l323 = fptosi <2 x double> %l322 to <2 x i16>
  %l340 = call fast <2 x double> @llvm.floor.v2f64(<2 x double> %l339)
  %l341 = fptosi <2 x double> %l340 to <2 x i16>
  %l342 = shufflevector <2 x i16> %l215, <2 x i16> %l233, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %l343 = shufflevector <2 x i16> %l251, <2 x i16> %l269, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %l344 = shufflevector <2 x i16> %l287, <2 x i16> %l305, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %l345 = shufflevector <2 x i16> %l323, <2 x i16> %l341, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %l346 = shufflevector <4 x i16> %l342, <4 x i16> %l343, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %l347 = shufflevector <4 x i16> %l344, <4 x i16> %l345, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %interleaved.vec = shufflevector <8 x i16> %l346, <8 x i16> %l347, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  ret <16 x i16> %interleaved.vec
}

declare <2 x double> @llvm.floor.v2f64(<2 x double> %l213)
