/* Code generated by IfcQuery EXPRESS generator, www.ifcquery.com */
#include <sstream>
#include <limits>

#include "ifcpp/model/AttributeObject.h"
#include "ifcpp/model/BuildingException.h"
#include "ifcpp/model/BuildingGuid.h"
#include "ifcpp/reader/ReaderUtil.h"
#include "ifcpp/writer/WriterUtil.h"
#include "ifcpp/IFC4/include/IfcColourRgbList.h"
#include "ifcpp/IFC4/include/IfcIndexedColourMap.h"
#include "ifcpp/IFC4/include/IfcNormalisedRatioMeasure.h"
#include "ifcpp/IFC4/include/IfcPositiveInteger.h"
#include "ifcpp/IFC4/include/IfcTessellatedFaceSet.h"

// ENTITY IfcIndexedColourMap 
IfcIndexedColourMap::IfcIndexedColourMap( int id ) { m_entity_id = id; }
IfcIndexedColourMap::~IfcIndexedColourMap() {}
shared_ptr<BuildingObject> IfcIndexedColourMap::getDeepCopy( BuildingCopyOptions& options )
{
	shared_ptr<IfcIndexedColourMap> copy_self( new IfcIndexedColourMap() );
	if( m_MappedTo ) { copy_self->m_MappedTo = dynamic_pointer_cast<IfcTessellatedFaceSet>( m_MappedTo->getDeepCopy(options) ); }
	if( m_Opacity ) { copy_self->m_Opacity = dynamic_pointer_cast<IfcNormalisedRatioMeasure>( m_Opacity->getDeepCopy(options) ); }
	if( m_Colours ) { copy_self->m_Colours = dynamic_pointer_cast<IfcColourRgbList>( m_Colours->getDeepCopy(options) ); }
	for( size_t ii=0; ii<m_ColourIndex.size(); ++ii )
	{
		auto item_ii = m_ColourIndex[ii];
		if( item_ii )
		{
			copy_self->m_ColourIndex.emplace_back( dynamic_pointer_cast<IfcPositiveInteger>(item_ii->getDeepCopy(options) ) );
		}
	}
	return copy_self;
}
void IfcIndexedColourMap::getStepLine( std::stringstream& stream ) const
{
	stream << "#" << m_entity_id << "= IFCINDEXEDCOLOURMAP" << "(";
	if( m_MappedTo ) { stream << "#" << m_MappedTo->m_entity_id; } else { stream << "$"; }
	stream << ",";
	if( m_Opacity ) { m_Opacity->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	if( m_Colours ) { stream << "#" << m_Colours->m_entity_id; } else { stream << "$"; }
	stream << ",";
	stream << "(";
	for( size_t ii = 0; ii < m_ColourIndex.size(); ++ii )
	{
		if( ii > 0 )
		{
			stream << ",";
		}
		const shared_ptr<IfcPositiveInteger>& type_object = m_ColourIndex[ii];
		if( type_object )
		{
			type_object->getStepParameter( stream, false );
		}
		else
		{
			stream << "$";
		}
	}
	stream << ")";
	stream << ");";
}
void IfcIndexedColourMap::getStepParameter( std::stringstream& stream, bool ) const { stream << "#" << m_entity_id; }
const std::wstring IfcIndexedColourMap::toString() const { return L"IfcIndexedColourMap"; }
void IfcIndexedColourMap::readStepArguments( const std::vector<std::wstring>& args, const std::map<int,shared_ptr<BuildingEntity> >& map )
{
	const size_t num_args = args.size();
	if( num_args != 4 ){ std::stringstream err; err << "Wrong parameter count for entity IfcIndexedColourMap, expecting 4, having " << num_args << ". Entity ID: " << m_entity_id << std::endl; throw BuildingException( err.str().c_str() ); }
	readEntityReference( args[0], m_MappedTo, map );
	m_Opacity = IfcNormalisedRatioMeasure::createObjectFromSTEP( args[1], map );
	readEntityReference( args[2], m_Colours, map );
	readTypeOfIntegerList( args[3], m_ColourIndex );
}
void IfcIndexedColourMap::getAttributes( std::vector<std::pair<std::string, shared_ptr<BuildingObject> > >& vec_attributes ) const
{
	IfcPresentationItem::getAttributes( vec_attributes );
	vec_attributes.emplace_back( std::make_pair( "MappedTo", m_MappedTo ) );
	vec_attributes.emplace_back( std::make_pair( "Opacity", m_Opacity ) );
	vec_attributes.emplace_back( std::make_pair( "Colours", m_Colours ) );
	if( !m_ColourIndex.empty() )
	{
		shared_ptr<AttributeObjectVector> ColourIndex_vec_object( new AttributeObjectVector() );
		std::copy( m_ColourIndex.begin(), m_ColourIndex.end(), std::back_inserter( ColourIndex_vec_object->m_vec ) );
		vec_attributes.emplace_back( std::make_pair( "ColourIndex", ColourIndex_vec_object ) );
	}
}
void IfcIndexedColourMap::getAttributesInverse( std::vector<std::pair<std::string, shared_ptr<BuildingObject> > >& vec_attributes_inverse ) const
{
	IfcPresentationItem::getAttributesInverse( vec_attributes_inverse );
}
void IfcIndexedColourMap::setInverseCounterparts( shared_ptr<BuildingEntity> ptr_self_entity )
{
	IfcPresentationItem::setInverseCounterparts( ptr_self_entity );
	shared_ptr<IfcIndexedColourMap> ptr_self = dynamic_pointer_cast<IfcIndexedColourMap>( ptr_self_entity );
	if( !ptr_self ) { throw BuildingException( "IfcIndexedColourMap::setInverseCounterparts: type mismatch" ); }
	if( m_MappedTo )
	{
		m_MappedTo->m_HasColours_inverse.emplace_back( ptr_self );
	}
}
void IfcIndexedColourMap::unlinkFromInverseCounterparts()
{
	IfcPresentationItem::unlinkFromInverseCounterparts();
	if( m_MappedTo )
	{
		std::vector<weak_ptr<IfcIndexedColourMap> >& HasColours_inverse = m_MappedTo->m_HasColours_inverse;
		for( auto it_HasColours_inverse = HasColours_inverse.begin(); it_HasColours_inverse != HasColours_inverse.end(); )
		{
			weak_ptr<IfcIndexedColourMap> self_candidate_weak = *it_HasColours_inverse;
			if( self_candidate_weak.expired() )
			{
				++it_HasColours_inverse;
				continue;
			}
			shared_ptr<IfcIndexedColourMap> self_candidate( *it_HasColours_inverse );
			if( self_candidate.get() == this )
			{
				it_HasColours_inverse= HasColours_inverse.erase( it_HasColours_inverse );
			}
			else
			{
				++it_HasColours_inverse;
			}
		}
	}
}
