;;; GNU Guix --- Functional package management for GNU
;;; Copyright © 2019 Ivan Petkov <ivanppetkov@gmail.com>
;;; Copyright © 2019-2025 Efraim Flashner <efraim@flashner.co.il>
;;; Copyright © 2019-2024 Nicolas Goaziou <mail@nicolasgoaziou.fr>
;;; Copyright © 2019, 2024 Giacomo Leidi <goodoldpaul@autistici.org>
;;; Copyright © 2019–2021 Tobias Geerinckx-Rice <me@tobias.gr>
;;; Copyright © 2019, 2020 John Soo <jsoo1@asu.edu>
;;; Copyright © 2019, 2020 Hartmut Goebel <h.goebel@crazy-compilers.com>
;;; Copyright © 2020 Jakub Kądziołka <kuba@kadziolka.net>
;;; Copyright © 2020 Leo Famulari <leo@famulari.name>
;;; Copyright © 2020 Gabriel Arazas <foo.dogsquared@gmail.com>
;;; Copyright © 2020 André Batista <nandre@riseup.net>
;;; Copyright © 2020 Arun Isaac <arunisaac@systemreboot.net>
;;; Copyright © 2020 Antoine Côté <antoine.cote@posteo.net>
;;; Copyright © 2021-2024 Maxim Cournoyer <maxim.cournoyer@gmail.com>
;;; Copyright © 2021 aecepoglu <aecepoglu@fastmail.fm>
;;; Copyright © 2021, 2022 Zheng Junjie <873216071@qq.com>
;;; Copyright © 2021 Alexandru-Sergiu Marton <brown121407@posteo.ro>
;;; Copyright © 2021 Antero Mejr <antero@kodmin.com>
;;; Copyright © 2021 Vinicius Monego <monego@posteo.net>
;;; Copyright © 2021 muradm <mail@muradm.net>
;;; Copyright © 2021, 2022 Petr Hodina <phodina@protonmail.com>
;;; Copyright © 2021-2025 Ricardo Wurmus <rekado@elephly.net>
;;; Copyright © 2021 Jacob Hrbek <kreyren@rixotstudio.cz>
;;; Copyright © 2021, 2022 Nicolas Graves <ngraves@ngraves.fr>
;;; Copyright © 2022 Aleksandr Vityazev <avityazev@posteo.org>
;;; Copyright © 2022 Marius Bakke <marius@gnu.org>
;;; Copyright © 2022 Evgenii Lepikhin <e.lepikhin@corp.mail.ru>
;;; Copyright © 2022 Gabriel Arazas <foo.dogsquared@gmail.com>
;;; Copyright © 2022 ( <paren@disroot.org>
;;; Copyright © 2022 Greg Hogan <code@greghogan.com>
;;; Copyright © 2022 Paul A. Patience <paul@apatience.com>
;;; Copyright © 2022 Paul Alesius <paul@unnservice.com>
;;; Copyright © 2023 Arnav Andrew Jose <arnav.jose@gmail.com>
;;; Copyright © 2023, 2024 Wilko Meyer <w@wmeyer.eu>
;;; Copyright © 2023, 2024 Jaeme Sifat <jaeme@runbox.com>
;;; Copyright © 2023 Steve George <steve@futurile.net>
;;; Copyright © 2023 Sergio Pastor Pérez <sergio.pastorperez@outlook.es>
;;; Copyright © 2023, 2024 VÖRÖSKŐI András <voroskoi@gmail.com>
;;; Copyright © 2023 Daniel Ziltener <dziltener@lyrion.ch>
;;; Copyright © 2023, 2024 Troy Figiel <troy@troyfigiel.com>
;;; Copyright © 2024 Herman Rimm <herman@rimm.ee>
;;; Copyright © 2024 Tomas Volf <~@wolfsden.cz>
;;; Copyright © 2024 Suhail Singh <suhail@bayesians.ca>
;;; Copyright © 2024 Aaron Covrig <aaron.covrig.us@ieee.org>
;;; Copyright © 2024 Nguyễn Gia Phong <mcsinyx@disroot.org>
;;; Copyright © 2024, 2025 Jordan Moore <lockbox@struct.foo>
;;; Copyright © 2024 Sharlatan Hellseher <sharlatanus@gmail.com>
;;; Copyright © 2024 Murilo <murilo@disroot.org>
;;; Copyright © 2025 Divya Ranjan Pattanaik <divya@subvertising.org>
;;; Copyright © 2025 Karl Hallsby <karl@hallsby.com>
;;; Copyright © 2025 Andrew Wong <wongandj@icloud.com>
;;;
;;; This file is part of GNU Guix.
;;;
;;; GNU Guix is free software; you can redistribute it and/or modify it
;;; under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 3 of the License, or (at
;;; your option) any later version.
;;;
;;; GNU Guix is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Guix.  If not, see <http://www.gnu.org/licenses/>.

(define-module (gnu packages crates-io)
  #:use-module (guix build-system cargo)
  #:use-module (guix download)
  #:use-module (guix git-download)
  #:use-module ((guix licenses) #:prefix license:)
  #:use-module (guix packages)
  #:use-module (guix gexp)
  #:use-module (guix utils)
  #:use-module (gnu packages)
  #:use-module (gnu packages acl)
  #:use-module (gnu packages admin)
  #:use-module (gnu packages aidc)
  #:use-module (gnu packages audio)
  #:use-module (gnu packages autotools)
  #:use-module (gnu packages avahi)
  #:use-module (gnu packages base)
  #:use-module (gnu packages bash)
  #:use-module (gnu packages c)
  #:use-module (gnu packages certs)
  #:use-module (gnu packages cmake)
  #:use-module (gnu packages compression)
  #:use-module (gnu packages cpp)
  #:use-module (gnu packages crates-apple)
  #:use-module (gnu packages crates-audio)
  #:use-module (gnu packages crates-check)
  #:use-module (gnu packages crates-compression)
  #:use-module (gnu packages crates-crypto)
  #:use-module (gnu packages crates-database)
  #:use-module (gnu packages crates-graphics)
  #:use-module (gnu packages crates-gtk)
  #:use-module (gnu packages crates-shell)
  #:use-module (gnu packages crates-tls)
  #:use-module (gnu packages crates-vcs)
  #:use-module (gnu packages crates-web)
  #:use-module (gnu packages crates-windows)
  #:use-module (gnu packages crypto)
  #:use-module (gnu packages curl)
  #:use-module (gnu packages databases)
  #:use-module (gnu packages fontutils)
  #:use-module (gnu packages gettext)
  #:use-module (gnu packages gl)
  #:use-module (gnu packages glib)
  #:use-module (gnu packages hardware)
  #:use-module (gnu packages icu4c)
  #:use-module (gnu packages image)
  #:use-module (gnu packages jemalloc)
  #:use-module (gnu packages libusb)
  #:use-module (gnu packages linux)
  #:use-module (gnu packages llvm)
  #:use-module (gnu packages mail)
  #:use-module (gnu packages maths)
  #:use-module (gnu packages multiprecision)
  #:use-module (gnu packages nettle)
  #:use-module (gnu packages pcre)
  #:use-module (gnu packages perl)
  #:use-module (gnu packages pkg-config)
  #:use-module (gnu packages protobuf)
  #:use-module (gnu packages python)
  #:use-module (gnu packages rust)
  #:use-module (gnu packages rust-apps)
  #:use-module (gnu packages security-token)
  #:use-module (gnu packages selinux)
  #:use-module (gnu packages sequoia)
  #:use-module (gnu packages serialization)
  #:use-module (gnu packages sqlite)
  #:use-module (gnu packages ssh)
  #:use-module (gnu packages tls)
  #:use-module (gnu packages valgrind)
  #:use-module (gnu packages version-control)
  #:use-module (gnu packages web)
  #:use-module (gnu packages xml)
  #:use-module (gnu packages xorg)
  #:use-module (gnu packages gtk)
  #:use-module (gnu packages virtualization)
  #:use-module (gnu packages webkit)
  #:use-module (srfi srfi-1))

;;;
;;; Please: Try to add new module packages in alphabetic order.
;;;

(define-public rust-ab-glyph-0.2
  (package
    (name "rust-ab-glyph")
    (version "0.2.29")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "ab_glyph" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1c7p94qf8x6n62nrbia7nzwdxm2sbyygnhd5qfmfl7p7h30p4dpc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; Tests want font files.
       #:cargo-inputs
       (("rust-ab-glyph-rasterizer" ,rust-ab-glyph-rasterizer-0.1)
        ("rust-libm" ,rust-libm-0.2)
        ("rust-owned-ttf-parser" ,rust-owned-ttf-parser-0.25))))
    (home-page "https://github.com/alexheretic/ab-glyph")
    (synopsis "API for rasterizing OpenType font glyphs")
    (description
     "This package provides an API for loading, scaling, positioning and
rasterizing OpenType font glyphs.")
    (license license:asl2.0)))

(define-public rust-ab-glyph-rasterizer-0.1
  (package
    (name "rust-ab-glyph-rasterizer")
    (version "0.1.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ab_glyph_rasterizer" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0ikhgzig59q8b1a1iw83sxfnvylg5gx6w2y8ynbnf231xs9if6y7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libm" ,rust-libm-0.2))))
    (home-page "https://github.com/alexheretic/ab-glyph")
    (synopsis "Coverage rasterization for lines, quadratic & cubic beziers")
    (description
     "This package provides coverage rasterization for lines, quadratic and
cubic beziers.")
    (license license:asl2.0)))

(define-public rust-abi-stable-0.11
  (package
    (name "rust-abi-stable")
    (version "0.11.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "abi_stable" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0if428pq8ly97zi6q1842nak977rwxnj17650i8gwpxh7qnm3mk9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags
       '("--features=testing")
       #:cargo-inputs (("rust-abi-stable-derive" ,rust-abi-stable-derive-0.11)
                       ("rust-abi-stable-shared" ,rust-abi-stable-shared-0.11)
                       ("rust-const-panic" ,rust-const-panic-0.2)
                       ("rust-core-extensions" ,rust-core-extensions-1)
                       ("rust-crossbeam-channel" ,rust-crossbeam-channel-0.5)
                       ("rust-generational-arena" ,rust-generational-arena-0.2)
                       ("rust-libloading" ,rust-libloading-0.7)
                       ("rust-lock-api" ,rust-lock-api-0.4)
                       ("rust-parking-lot" ,rust-parking-lot-0.12)
                       ("rust-paste" ,rust-paste-1)
                       ("rust-repr-offset" ,rust-repr-offset-0.2)
                       ("rust-rustc-version" ,rust-rustc-version-0.4)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-serde-derive" ,rust-serde-derive-1)
                       ("rust-serde-json" ,rust-serde-json-1))
       #:cargo-development-inputs (("rust-bincode" ,rust-bincode-1)
                                   ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.8)
                                   ("rust-fnv" ,rust-fnv-1)
                                   ("rust-hashbrown" ,rust-hashbrown-0.13)
                                   ("rust-rand" ,rust-rand-0.8)
                                   ("rust-serde-json" ,rust-serde-json-1)
                                   ("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://github.com/rodrimati1992/abi_stable_crates/")
    (synopsis "Rust-to-Rust ffi,writing libraries loaded at program startup")
    (description
     "This package contains code for doing Rust-to-Rust ffi, writing libraries
loaded at program startup.")
    (license (list license:expat license:asl2.0))))

(define-public rust-abi-stable-0.10
  (package
    (inherit rust-abi-stable-0.11)
    (name "rust-abi-stable")
    (version "0.10.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "abi_stable" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "03vg0cl0727whv7nxyvm8g9xfwxnfcdn8p872jqw1z6n84yjix7s"))
       (modules '((guix build utils)))
       (snippet
        '(begin (substitute* "Cargo.toml"
                  (((string-append ">=([[:digit:]]+\\.[[:digit:]]+\\.[[:digit:]]+),"
                                   " <([[:digit:]]+\\.[[:digit:]]+\\.[[:digit:]]+)")
                    _ version _)
                   (string-append ">=" version)))))))
    (arguments
     `(#:tests? #f      ; tests must be run with the "testing" feature
       #:cargo-inputs
       (("rust-abi-stable-derive" ,rust-abi-stable-derive-0.10)
        ("rust-abi-stable-shared" ,rust-abi-stable-shared-0.10)
        ("rust-core-extensions" ,rust-core-extensions-1)
        ("rust-crossbeam-channel" ,rust-crossbeam-channel-0.5)
        ("rust-generational-arena" ,rust-generational-arena-0.2)
        ("rust-libloading" ,rust-libloading-0.7)
        ("rust-lock-api" ,rust-lock-api-0.4)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-parking-lot" ,rust-parking-lot-0.11)
        ("rust-paste" ,rust-paste-1)
        ("rust-repr-offset" ,rust-repr-offset-0.2)
        ("rust-rustc-version" ,rust-rustc-version-0.4)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1))
       #:cargo-development-inputs
       (("rust-bincode" ,rust-bincode-1)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.8)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-hashbrown" ,rust-hashbrown-0.11)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-abi-stable-derive-0.11
  (package
    (name "rust-abi-stable-derive")
    (version "0.11.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "abi_stable_derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "16780mmr2hwx8ajcq59nhvq3krv5i8r7mg41x08fx907nil885yp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags
       '("--release" "--"
         "--skip=sabi_trait::tests::sabi_trait_test_cases"
         "--skip=stable_abi::tests::test_cases")
       #:cargo-inputs (("rust-abi-stable-shared" ,rust-abi-stable-shared-0.11)
                       ("rust-as-derive-utils" ,rust-as-derive-utils-0.11)
                       ("rust-core-extensions" ,rust-core-extensions-1)
                       ("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-rustc-version" ,rust-rustc-version-0.4)
                       ("rust-syn" ,rust-syn-1)
                       ("rust-typed-arena" ,rust-typed-arena-2))
       #:cargo-development-inputs
       (("rust-as-derive-utils" ,rust-as-derive-utils-0.11))))
    (home-page "https://github.com/rodrimati1992/abi_stable_crates/")
    (synopsis "Implementation detail of abi_stable")
    (description "This package contains an implementation detail of abi_stable.")
    (license (list license:expat license:asl2.0))))

(define-public rust-abi-stable-derive-0.10
  (package
    (inherit rust-abi-stable-derive-0.11)
    (name "rust-abi-stable-derive")
    (version "0.10.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "abi_stable_derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1w503n9rxja3h8ls6p5xsly8aclbp30dm4hd0525bvpbippi161v"))))
    (arguments
     `(#:cargo-test-flags
       '("--release" "--"
         "--skip=sabi_trait::tests::sabi_trait_test_cases"
         "--skip=stable_abi::tests::test_cases")
       #:cargo-inputs
       (("rust-abi-stable-shared" ,rust-abi-stable-shared-0.10)
        ("rust-as-derive-utils" ,rust-as-derive-utils-0.10)
        ("rust-core-extensions" ,rust-core-extensions-1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-rustc-version" ,rust-rustc-version-0.2)
        ("rust-syn" ,rust-syn-1)
        ("rust-typed-arena" ,rust-typed-arena-2))
       #:cargo-development-inputs
       (("rust-as-derive-utils" ,rust-as-derive-utils-0.10))))))

(define-public rust-abi-stable-shared-0.11
  (package
    (name "rust-abi-stable-shared")
    (version "0.11.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "abi_stable_shared" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0qrbmlypvxx3zij1c6w6yykpp5pjcfx9qr2d9lzyc8y1i1vdzddj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-core-extensions" ,rust-core-extensions-1))))
    (home-page "https://github.com/rodrimati1992/abi_stable_crates/")
    (synopsis "Implementation detail of abi_stable")
    (description "This package contains an implementation detail of abi_stable.")
    (license (list license:expat license:asl2.0))))

(define-public rust-abi-stable-shared-0.10
  (package
    (inherit rust-abi-stable-shared-0.11)
    (name "rust-abi-stable-shared")
    (version "0.10.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "abi_stable_shared" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0psaz0vghdz84vrb311g4b74d2nhrlbmwxa8if88s0bf0s4xmsgc"))))
    (arguments
     `(#:cargo-inputs (("rust-core-extensions" ,rust-core-extensions-1))))))

(define-public rust-abomonation-0.7
  (package
    (name "rust-abomonation")
    (version "0.7.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "abomonation" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1cjg3hjf028n447pdj7zcdgrkngx30as8ndxlxx947wvr49jkrsn"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-recycler" ,rust-recycler-0.1))))
    (home-page "https://github.com/TimelyDataflow/abomonation")
    (synopsis "High performance and very unsafe serialization library")
    (description
     "This package provides a high performance and very unsafe serialization
library in Rust.")
    (license license:expat)))

(define-public rust-adaptive-barrier-1
  (package
    (name "rust-adaptive-barrier")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "adaptive-barrier" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1004swrxg9g755h0sk0y1kclk4y9hzk6dzl8772df4l4j44gqz8w"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/vorner/adaptive-barrier")
    (synopsis "Barrier with adaptable number of thread subsciptions")
    (description
     "This is a Barrier synchronization primitive, similar to
@code{std::sync::Barrier}, but one that adjusts the expected number of
threads.  This makes it robust in face of panics (it won't make your program
deadlock, like the standard Barrier).")
    (license (list license:asl2.0 license:expat))))

(define-public rust-adblock-0.7
  (package
    (name "rust-adblock")
    (version "0.7.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/brave/adblock-rust")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0prlkq8am3sskg55x7b8vr4j54dmkjqldyl50isq5qyy9pff3xxs"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags
       (list "--release" "--"
             ;; Skip tests which require the network.
             "--skip=check_live_from_filterlists"
             "--skip=check_live_specific_urls"
             "--skip=stable_serialization"
             "--skip=stable_serialization_through_load")
       #:cargo-inputs
       (("rust-addr" ,rust-addr-0.14)
        ("rust-base64" ,rust-base64-0.13)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-cssparser" ,rust-cssparser-0.28)
        ("rust-flate2" ,rust-flate2-1)
        ("rust-idna" ,rust-idna-0.2)
        ("rust-itertools" ,rust-itertools-0.10)
        ("rust-lifeguard" ,rust-lifeguard-0.6)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-percent-encoding" ,rust-percent-encoding-2)
        ("rust-regex" ,rust-regex-1)
        ("rust-rmp-serde" ,rust-rmp-serde-0.13)
        ("rust-rmp-serde" ,rust-rmp-serde-0.15)
        ("rust-seahash" ,rust-seahash-3)
        ("rust-selectors" ,rust-selectors-0.23)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-twoway" ,rust-twoway-0.2)
        ("rust-url" ,rust-url-2))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.4)
        ("rust-csv" ,rust-csv-1)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-mock-instant" ,rust-mock-instant-0.2)
        ("rust-reqwest" ,rust-reqwest-0.11)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-sha2" ,rust-sha2-0.9)
        ("rust-tokio" ,rust-tokio-1))))
    (home-page "https://github.com/brave/adblock-rust/")
    (synopsis "Adblock Plus syntax filter parsing and matching")
    (description "This package provides native Rust module for Adblock Plus
syntax (e.g.  EasyList, EasyPrivacy) filter parsing and matching.")
    (license license:mpl2.0)))

(define-public rust-adblock-0.5
  (package
    (inherit rust-adblock-0.7)
    (name "rust-adblock")
    (version "0.5.8")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "adblock" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1qgjcrm7vqxq5ispdj95ql7payy5d5rj0zfwba4b076xxvw1q4yq"))))
    (arguments
     `(#:cargo-test-flags
       (list "--release" "--"
             ;; Not all files included
             "--skip=check_works_same_after_deserialization"
             "--skip=check_matching_equivalent"
             "--skip=check_matching_hostnames"
             ;; Skip tests which require the network.
             "--skip=check_live_from_filterlists"
             "--skip=check_live_specific_urls"
             "--skip=stable_serialization"
             "--skip=stable_serialization_through_load")
       #:cargo-inputs
       (("rust-addr" ,rust-addr-0.14)
        ("rust-base64" ,rust-base64-0.13)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-cssparser" ,rust-cssparser-0.28)
        ("rust-flate2" ,rust-flate2-1)
        ("rust-idna" ,rust-idna-0.2)
        ("rust-itertools" ,rust-itertools-0.10)
        ("rust-lifeguard" ,rust-lifeguard-0.6)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-percent-encoding" ,rust-percent-encoding-2)
        ("rust-regex" ,rust-regex-1)
        ("rust-rmp-serde" ,rust-rmp-serde-0.13)
        ("rust-rmp-serde" ,rust-rmp-serde-0.15)
        ("rust-seahash" ,rust-seahash-3)
        ("rust-selectors" ,rust-selectors-0.23)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-twoway" ,rust-twoway-0.2)
        ("rust-url" ,rust-url-2))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-csv" ,rust-csv-1)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-reqwest" ,rust-reqwest-0.11)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-sha2" ,rust-sha2-0.9)
        ("rust-tokio" ,rust-tokio-1))))))

(define-public rust-addchain-0.2
  (package
    (name "rust-addchain")
    (version "0.2.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "addchain" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0w45hpybsx9gzhlxf6x9451kycg8xwj3x8qzjnk8wqm55926jbiv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-num-bigint" ,rust-num-bigint-0.3)
        ("rust-num-integer" ,rust-num-integer-0.1)
        ("rust-num-traits" ,rust-num-traits-0.2))))
    (home-page "https://github.com/str4d/addchain")
    (synopsis "Generate addition chains")
    (description "Generate addition chains")
    (license (list license:expat license:asl2.0))))

(define-public rust-addr-0.14
  (package
    (name "rust-addr")
    (version "0.14.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "addr" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32
            "0w6v0wwv203v0lyvwsq27rwfhvmw7dsmrqc9r3gszbx2974wlk65"))))
    (build-system cargo-build-system)
    (arguments
      `(#:skip-build? #t
        #:cargo-inputs
        (("rust-no-std-net" ,rust-no-std-net-0.5)
         ("rust-psl" ,rust-psl-2)
         ("rust-psl-types" ,rust-psl-types-2)
         ("rust-publicsuffix" ,rust-publicsuffix-2)
         ("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/addr-rs/addr")
    (synopsis "Parsing domain names")
    (description "This package provides a library for parsing domain names.")
    (license (list license:expat license:asl2.0))))

(define-public rust-addr2line-0.24
  (package
    (name "rust-addr2line")
    (version "0.24.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "addr2line" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1hd1i57zxgz08j6h5qrhsnm2fi0bcqvsh389fw400xm3arz2ggnz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-clap" ,rust-clap-4)
        ("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-cpp-demangle" ,rust-cpp-demangle-0.4)
        ("rust-fallible-iterator" ,rust-fallible-iterator-0.3)
        ("rust-gimli" ,rust-gimli-0.31)
        ("rust-memmap2" ,rust-memmap2-0.9)
        ("rust-object" ,rust-object-0.36)
        ("rust-rustc-demangle" ,rust-rustc-demangle-0.1)
        ("rust-rustc-std-workspace-alloc" ,rust-rustc-std-workspace-alloc-1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1)
        ("rust-smallvec" ,rust-smallvec-1)
        ("rust-typed-arena" ,rust-typed-arena-2))
       #:cargo-development-inputs (("rust-backtrace" ,rust-backtrace-0.3)
                                   ("rust-findshlibs" ,rust-findshlibs-0.10)
                                   ("rust-libtest-mimic" ,rust-libtest-mimic-0.7))))
    (home-page "https://github.com/gimli-rs/addr2line")
    (synopsis "Symbolication library written in Rust, using gimli")
    (description
     "This package provides a cross-platform symbolication library written in
Rust, using gimli.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-adler-1
  (package
    (name "rust-adler")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "adler" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1zim79cvzd5yrkzl3nyfx0avijwgk9fqv3yrscdy1cc79ih02qpj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3))))
    (home-page "https://github.com/jonas-schievink/adler")
    (synopsis "Implementation of the Adler-32 checksum")
    (description
     "This crate provides a simple implementation of the Adler-32
checksum, used in the zlib compression format.")
    (license
     (list license:expat
           license:asl2.0
           (license:non-copyleft "https://spdx.org/licenses/0BSD.html")))))

(define-public rust-adler2-2
  (package
    (name "rust-adler2")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "adler2" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "09r6drylvgy8vv8k20lnbvwq8gp09h7smfn6h1rxsy15pgh629si"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1))
       #:cargo-development-inputs (("rust-criterion" ,rust-criterion-0.3))))
    (home-page "https://github.com/oyvindln/adler2")
    (synopsis "Implementation of the Adler-32 checksum")
    (description
     "This package provides a simple clean-room implementation of the Adler-32
checksum.")
    (license (list license:bsd-0 license:expat license:asl2.0))))

(define-public rust-adler32-1
  (package
    (name "rust-adler32")
    (version "1.2.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "adler32" version))
        (file-name
          (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0d7jq7jsjyhsgbhnfq5fvrlh9j0i9g1fqrl2735ibv5f75yjgqda"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-getrandom" ,rust-getrandom-0.1)
        ("rust-humansize" ,rust-humansize-1)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2)
        ("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.3))))
    (home-page "https://github.com/remram44/adler32-rs")
    (synopsis "Implementation of the Adler32 rolling hash algorithm")
    (description
     "This library is an implementation of the Adler32 rolling hash algorithm in
the Rust programming language.")
    (license (list license:bsd-3
                   license:zlib))))

(define-public rust-afl-0.12
  (package
    (name "rust-afl")
    (version "0.12.17")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "afl" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "05f7wrz15h97b6xqa914syiv6ij849ndgyb5iwmgwkv26qpjzhzn"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t     ; We don't want to add AFL as an input.
       #:cargo-inputs
       (("rust-clap" ,rust-clap-4)
        ("rust-fs-extra" ,rust-fs-extra-1)
        ("rust-home" ,rust-home-0.5)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-rustc-version" ,rust-rustc-version-0.4)
        ("rust-tempfile" ,rust-tempfile-3)
        ("rust-xdg" ,rust-xdg-2))
       #:cargo-development-inputs
       (("rust-arbitrary" ,rust-arbitrary-1)
        ("rust-assert-cmd" ,rust-assert-cmd-2)
        ("rust-tempfile" ,rust-tempfile-3))
       #:phases (modify-phases %standard-phases
                  ;; Custom archive file for test suite.
                  (delete 'check-for-pregenerated-files))))
    (home-page "https://github.com/rust-fuzz/afl.rs")
    (synopsis
     "Fuzzing Rust code with american-fuzzy-lop")
    (description
     "Fuzz Rust code with american-fuzzy-lop.")
    (license license:asl2.0)))

(define-public rust-afl-0.11
  (package
    (inherit rust-afl-0.12)
    (name "rust-afl")
    (version "0.11.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "afl" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0a2jm690mcxd073j9isd16rpzkjfmpgamw9h64f5l2fpns0423vc"))))
    (arguments
     `(#:skip-build? #t     ; We don't want to add AFL as an input.
       #:cargo-inputs (("rust-cc" ,rust-cc-1)
                       ("rust-clap" ,rust-clap-2)
                       ("rust-lazy-static" ,rust-lazy-static-1)
                       ("rust-libc" ,rust-libc-0.2)
                       ("rust-rustc-version" ,rust-rustc-version-0.4)
                       ("rust-xdg" ,rust-xdg-2))
       #:cargo-development-inputs (("rust-tempfile" ,rust-tempfile-3))
       #:phases (modify-phases %standard-phases
                  ;; Custom archive file for test suite.
                  (delete 'check-for-pregenerated-files))))))

(define-public rust-ahash-0.8
  (package
    (name "rust-ahash")
    (version "0.8.11")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "ahash" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "04chdfkls5xmhp1d48gnjsmglbqibizs3bpbj6rsj604m10si7g8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-atomic-polyfill" ,rust-atomic-polyfill-1)
        ("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-const-random" ,rust-const-random-0.1)
        ("rust-getrandom" ,rust-getrandom-0.2)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-version-check" ,rust-version-check-0.9)
        ("rust-zerocopy" ,rust-zerocopy-0.7))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-fxhash" ,rust-fxhash-0.2)
        ("rust-hashbrown" ,rust-hashbrown-0.14)
        ("rust-hex" ,rust-hex-0.4)
        ("rust-no-panic" ,rust-no-panic-0.1)
        ("rust-pcg-mwc" ,rust-pcg-mwc-0.2)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-seahash" ,rust-seahash-4)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-smallvec" ,rust-smallvec-1))))
    (home-page "https://github.com/tkaitchuck/ahash")
    (synopsis
     "Non-cryptographic hash function using AES-NI")
    (description
     "This package provides a non-cryptographic hash function using AES-NI for
high performance.")
    (license (list license:expat license:asl2.0))))

(define-public rust-ahash-0.7
  (package
    (name "rust-ahash")
    (version "0.7.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ahash" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1y9014qsy6gs9xld4ch7a6xi9bpki8vaciawxq4p75d8qvh7f549"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-atomic-polyfill" ,rust-atomic-polyfill-1)
        ("rust-const-random" ,rust-const-random-0.1)
        ("rust-getrandom" ,rust-getrandom-0.2)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-version-check" ,rust-version-check-0.9))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-fxhash" ,rust-fxhash-0.2)
        ("rust-hex" ,rust-hex-0.4)
        ("rust-no-panic" ,rust-no-panic-0.1)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-seahash" ,rust-seahash-4)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/tkaitchuck/ahash")
    (synopsis "Non-cryptographic hash function using AES-NI")
    (description "This package provides a non-cryptographic hash function
using AES-NI for high performance.")
    (license (list license:expat license:asl2.0))))

(define-public rust-ahash-0.4
  (package
    (inherit rust-ahash-0.7)
    (name "rust-ahash")
    (version "0.4.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ahash" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "129290b8lz7fw8gzdq7k2jrm6yqgv6dsb1sc1gfy1pl2rqm26lq4"))))
    (arguments
     `(#:cargo-inputs
       (("rust-const-random" ,rust-const-random-0.1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-fxhash" ,rust-fxhash-0.2)
        ("rust-hex" ,rust-hex-0.3)
        ("rust-no-panic" ,rust-no-panic-0.1)
        ("rust-rand" ,rust-rand-0.6)
        ("rust-seahash" ,rust-seahash-3))))))

(define-public rust-ahash-0.3
  (package
    (inherit rust-ahash-0.4)
    (name "rust-ahash")
    (version "0.3.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ahash" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "05qjnr0wccch0gg2kghg0xyh8qd5gfqd15q9dd6r1lamcs375zg8"))))
    (arguments
     `(#:tests? #f  ; `#![feature]` may not be used on the stable release channel
       #:cargo-inputs
       (("rust-const-random" ,rust-const-random-0.1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-fxhash" ,rust-fxhash-0.2)
        ("rust-hex" ,rust-hex-0.3)
        ("rust-no-panic" ,rust-no-panic-0.1)
        ("rust-rand" ,rust-rand-0.6)
        ("rust-seahash" ,rust-seahash-3))))))

(define-public rust-ahash-0.2
  (package
    (inherit rust-ahash-0.4)
    (name "rust-ahash")
    (version "0.2.19")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ahash" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1yzdrxaq99zfy0niq5i3cz5jv569s3s6z5q2cxcg08y6prh1nri9"))))
    (arguments
     `(#:cargo-inputs
       (("rust-const-random" ,rust-const-random-0.1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.2)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-fxhash" ,rust-fxhash-0.2)
        ("rust-hex" ,rust-hex-0.3)
        ("rust-no-panic" ,rust-no-panic-0.1)
        ("rust-rand" ,rust-rand-0.6)
        ("rust-seahash" ,rust-seahash-3))))))

(define-public rust-aho-corasick-1
  (package
    (name "rust-aho-corasick")
    (version "1.1.3")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "aho-corasick" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "05mrpkvdgp5d20y2p989f187ry9diliijgwrs254fs9s1m1x6q4f"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-log" ,rust-log-0.4)
        ("rust-memchr" ,rust-memchr-2))
       #:cargo-development-inputs (("rust-doc-comment" ,rust-doc-comment-0.3))))
    (home-page "https://github.com/BurntSushi/aho-corasick")
    (synopsis "Fast multiple substring searching")
    (description "This package provides a fast multiple substring searching.")
    (license (list license:unlicense license:expat))))

(define-public rust-aho-corasick-0.7
  (package
    (inherit rust-aho-corasick-1)
    (name "rust-aho-corasick")
    (version "0.7.20")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "aho-corasick" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1b3if3nav4qzgjz9bf75b2cv2h2yisrqfs0np70i38kgz4cn94yc"))))
    (arguments
     `(#:cargo-inputs (("rust-memchr" ,rust-memchr-2))))))

(define-public rust-aho-corasick-0.6
  (package
    (inherit rust-aho-corasick-0.7)
    (name "rust-aho-corasick")
    (version "0.6.10")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "aho-corasick" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "19f8v503ibvlyr824g5ynicrh1lsmp2i0zmpszr8lqay0qw3vkl1"))))
    (arguments
     `(#:cargo-inputs
       (("rust-memchr" ,rust-memchr-2))
       #:cargo-development-inputs
       (("rust-csv" ,rust-csv-1)
        ("rust-docopt" ,rust-docopt-1)
        ("rust-memmap" ,rust-memmap-0.6)
        ("rust-quickcheck" ,rust-quickcheck-0.7)
        ("rust-rand" ,rust-rand-0.5)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1))))))

(define-public rust-aho-corasick-0.5
  (package
    (inherit rust-aho-corasick-0.6)
    (name "rust-aho-corasick")
    (version "0.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aho-corasick" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0rnvdmlajikq0i4zdy1p3pv699q6apvsxfc7av7byhppllp2r5ya"))))
    (arguments
     `(#:cargo-inputs
       (("rust-memchr" ,rust-memchr-0.1))
       #:cargo-development-inputs
       (("rust-csv" ,rust-csv-0.14)
        ("rust-docopt" ,rust-docopt-0.6)
        ("rust-memmap" ,rust-memmap-0.2)
        ("rust-quickcheck" ,rust-quickcheck-0.2)
        ("rust-rand" ,rust-rand-0.3)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3))))))

(define-public rust-al-sys-0.6
  (package
    (name "rust-al-sys")
    (version "0.6.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "al-sys" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "08whlcfrhn4gqi4nbglkdqv5ysdpnvnlsqg51q34q9hh9l7rp3gz"))))
    (build-system cargo-build-system)
    (arguments
     (list #:cargo-inputs
           `(("rust-cmake" ,rust-cmake-0.1)
             ("rust-libloading" ,rust-libloading-0.5)
             ("rust-rental" ,rust-rental-0.5))))
    (home-page "https://github.com/jpernst/alto")
    (synopsis "Raw bindings for OpenAL 1.1")
    (description "Rust bindings for OpenAL, this crate contains FFI elements.")
    (license (list license:expat license:asl2.0))))

(define-public rust-alga-0.9
  (package
    (name "rust-alga")
    (version "0.9.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "alga" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1wl4z8ini9269x04g8wwdz1nn3hmmvaaysq4jwhymikyg81kv0jg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags
       '("--release" "--lib" "--bins" "--tests")
       #:cargo-inputs
       (("rust-approx" ,rust-approx-0.3)
        ("rust-decimal" ,rust-decimal-2)
        ("rust-num-complex" ,rust-num-complex-0.2)
        ("rust-num-traits" ,rust-num-traits-0.2))
       #:cargo-development-inputs
       (("rust-alga-derive" ,rust-alga-derive-0.9)
        ("rust-quickcheck" ,rust-quickcheck-0.8))))
    (home-page "https://github.com/rustsim/alga")
    (synopsis "Abstract algebra for Rust")
    (description "Alga aims to provide solid mathematical abstractions to
algebra-focused applications.  It defines and organizes through trait
inheritance the basic building blocks of general algebraic structures.
Specific implementations of algebraic structure traits are left to other
crates.  Higher-level traits for specialized domains of algebra (like linear
algebra) are also provided and will prove useful for applications that include
code that is generic with regard to the algebraic entity types.")
    (license license:asl2.0)))

(define-public rust-alga-derive-0.9
  (package
    (name "rust-alga-derive")
    (version "0.9.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "alga_derive" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0a2594j6blczz18vfg85agr7vsjrbq6900d3xwxw0zzbqj9j2adz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-edit-distance" ,rust-edit-distance-2)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quickcheck" ,rust-quickcheck-0.9)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/rustsim/alga")
    (synopsis "Dutomatic deriving of abstract algebra traits")
    (description "Derive attribute for implementing algebraic traits from the
@code{alga} crate.")
    (license license:asl2.0)))

(define-public rust-aliasable-0.1
  (package
    (name "rust-aliasable")
    (version "0.1.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "aliasable" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "1z8548zdjlm4ps1k0d7x68lfdyji02crwcc9rw3q3bb106f643r5"))))
    (build-system cargo-build-system)
    (arguments
      `(#:cargo-inputs
        (("rust-aliasable-deref-trait" ,rust-aliasable-deref-trait-0.2)
         ("rust-stable-deref-trait" ,rust-stable-deref-trait-1))))
    (home-page "https://github.com/avitex/rust-aliasable")
    (synopsis "Basic aliasable (non unique pointer) types")
    (description
     "Rust library providing basic aliasable (non @code{core::ptr::Unique})
types.")
    (license license:expat)))

(define-public rust-aliasable-deref-trait-0.2
  (package
    (name "rust-aliasable-deref-trait")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aliasable_deref_trait" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0abzqsxd09jxl01brzjnwk8zg7k8zma76gzq87385q8fqm710jxb"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/avitex/rust-aliasable-deref-trait")
    (synopsis "Marker trait for aliasable pointers")
    (description
     "This package provides a marker trait for types that deref to an
address that is aliasable when coerced to a raw pointer")
    (license license:expat)))

(define-public rust-aligned-0.4
  (package
    (name "rust-aligned")
    (version "0.4.2")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "aligned" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "08srg0rbz21s1kk97b1canffly7icr31sp7l1nqk2i1ym05lqzip"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-as-slice" ,rust-as-slice-0.2))))
    (home-page "https://github.com/japaric/aligned")
    (synopsis "Newtype with alignment of at least `A` bytes")
    (description
     "This package provides a newtype with alignment of at least `A` bytes.")
    (license (list license:expat license:asl2.0))))

(define-public rust-aligned-vec-0.5
  (package
    (name "rust-aligned-vec")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "aligned-vec" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1lb8qjqfap028ylf8zap6rkwrnrqimc3v6h3cixycjrdx1y0vaaa"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/sarah-ek/aligned-vec/")
    (synopsis "Aligned vector and box containers")
    (description "This package provides an aligned vector and box containers.")
    (license license:expat)))

(define-public rust-alloc-no-stdlib-2
  (package
    (name "rust-alloc-no-stdlib")
    (version "2.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "alloc-no-stdlib" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1cy6r2sfv5y5cigv86vms7n5nlwhx1rbyxwcraqnmm1rxiib2yyc"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/dropbox/rust-alloc-no-stdlib")
    (synopsis "Dynamic allocator that may be used with or without the stdlib")
    (description "This package provides a dynamic allocator that may be used
with or without the stdlib.  This allows a package with nostd to allocate
memory dynamically and be used either with a custom allocator, items on the
stack, or by a package that wishes to simply use Box<>.  It also provides
options to use calloc or a mutable global variable for pre-zeroed memory.")
    (license license:bsd-3)))

(define-public rust-alloc-stdlib-0.2
  (package
    (name "rust-alloc-stdlib")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "alloc-stdlib" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1kkfbld20ab4165p29v172h8g0wvq8i06z8vnng14whw0isq5ywl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-alloc-no-stdlib" ,rust-alloc-no-stdlib-2))))
    (home-page "https://github.com/dropbox/rust-alloc-no-stdlib")
    (synopsis "Dynamic allocator example that may be used with the stdlib")
    (description "This package provides a dynamic allocator example that may
be used with the stdlib.")
    (license license:bsd-3)))

(define-public rust-alloc-traits-0.1
  (package
    (name "rust-alloc-traits")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "alloc-traits" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "10z4rmykwnp8ps5r5n34190h6gmzpj1f67fqildi1z8r6f2m8bbb"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/HeroicKatora/static-alloc")
    (synopsis "Traits to replace or supplement the alloc module in no_std")
    (description
     "This package provides Traits to replace or supplement the alloc module
in no_std.")
    (license license:expat)))

(define-public rust-alloca-0.4
  (package
    (name "rust-alloca")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "alloca" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1x6p4387rz6j7h342kp3b7bgvqzyl9mibf959pkfk9xflrgd19z5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-cc" ,rust-cc-1))))
    (home-page "https://github.com/playXE/alloca-rs")
    (synopsis "Mostly safe wrapper for alloca")
    (description "This package provides a mostly safe wrapper for alloca.")
    (license license:expat)))

(define-public rust-allocator-api2-0.2
  (package
    (name "rust-allocator-api2")
    (version "0.2.21")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "allocator-api2" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "08zrzs022xwndihvzdn78yqarv2b9696y67i6h78nla3ww87jgb8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags '("--lib")
       #:cargo-inputs (("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/zakarumych/allocator-api2")
    (synopsis "Mirror of Rust's allocator API")
    (description "Mirror of Rust's allocator API.")
    (license (list license:expat license:asl2.0))))

(define-public rust-alphanumeric-sort-1
  (package
    (name "rust-alphanumeric-sort")
    (version "1.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "alphanumeric-sort" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "13vyx3cqpylvc0md4563rd42b7dvk3fv4wny0kpcc48gy72n0z6n"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs (("rust-bencher" ,rust-bencher-0.1))))
    (home-page "https://magiclen.org/alphanumeric-sort")
    (synopsis "Sort order for files and folders whose names contain numerals")
    (description
     "This crate can help you sort order for files and folders whose names
contain numerals.")
    (license license:expat)))

(define-public rust-alto-3
  (package
    (name "rust-alto")
    (version "3.0.4")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "alto" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1rgsdmh346s3rwhzqacjc6nz7jap4dd72c1gfmkaq9sgzh9fhnyp"))))
    (build-system cargo-build-system)
    (arguments
     (list #:tests? #f  ; Not all files included.
           #:cargo-inputs
           `(("rust-al-sys" ,rust-al-sys-0.6)
             ("rust-lazy-static" ,rust-lazy-static-0.2)
             ("rust-parking-lot" ,rust-parking-lot-0.4))))
    (home-page "https://github.com/jpernst/alto")
    (synopsis
     "Idiomatic Rust bindings for OpenAL 1.1 and extensions (including EFX)")
    (description
     "Rust bindings for OpenAL 1.1 and extensions (including EFX).")
    (license (list license:expat license:asl2.0))))

(define-public rust-amd-0.2
  (package
    (name "rust-amd")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "amd" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "15ib7hhzdifb2m099561ip0fq627gaszw4sq36ys75snaw0y0yd6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-num-traits" ,rust-num-traits-0.2))))
    (home-page "https://github.com/rwl/amd_order/")
    (synopsis "Approximate Minimum Degree ordering")
    (description "This package provides a set of routines for ordering a
sparse matrix prior to Cholesky factorization.")
    (license license:bsd-3)))

(define-public rust-android-activity-0.6
  (package
    (name "rust-android-activity")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "android-activity" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0inh88x8x2fh62jg739s9hwyvdh8i920qf0qw7bhr802j9c7hsgg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t     ; error: ndk-sys only supports compiling for Android.
       #:cargo-inputs (("rust-android-properties" ,rust-android-properties-0.2)
                       ("rust-bitflags" ,rust-bitflags-2)
                       ("rust-cc" ,rust-cc-1)
                       ("rust-cesu8" ,rust-cesu8-1)
                       ("rust-jni" ,rust-jni-0.21)
                       ("rust-jni-sys" ,rust-jni-sys-0.3)
                       ("rust-libc" ,rust-libc-0.2)
                       ("rust-log" ,rust-log-0.4)
                       ("rust-ndk" ,rust-ndk-0.9)
                       ("rust-ndk-context" ,rust-ndk-context-0.1)
                       ("rust-ndk-sys" ,rust-ndk-sys-0.6)
                       ("rust-num-enum" ,rust-num-enum-0.7)
                       ("rust-thiserror" ,rust-thiserror-1))))
    (home-page "https://github.com/rust-mobile/android-activity")
    (synopsis "Glue for building Rust applications on Android")
    (description
     "This package provides the glue for building Rust applications on Android
with @code{NativeActivity} or @code{GameActivity}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-android-activity-0.5
  (package
    (inherit rust-android-activity-0.6)
    (name "rust-android-activity")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "android-activity" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1fgl1jbzwbxrw4naw8bzjmphqj68q3hiylc05pakyz4p5a8h3f1r"))))
    (arguments
     `(#:skip-build? #t     ; Only supports compiling for Android.
       #:cargo-inputs (("rust-android-properties" ,rust-android-properties-0.2)
                       ("rust-bitflags" ,rust-bitflags-2)
                       ("rust-cc" ,rust-cc-1)
                       ("rust-cesu8" ,rust-cesu8-1)
                       ("rust-jni" ,rust-jni-0.21)
                       ("rust-jni-sys" ,rust-jni-sys-0.3)
                       ("rust-libc" ,rust-libc-0.2)
                       ("rust-log" ,rust-log-0.4)
                       ("rust-ndk" ,rust-ndk-0.8)
                       ("rust-ndk-context" ,rust-ndk-context-0.1)
                       ("rust-ndk-sys" ,rust-ndk-sys-0.5)
                       ("rust-num-enum" ,rust-num-enum-0.7)
                       ("rust-thiserror" ,rust-thiserror-1))))))

(define-public rust-android-activity-0.4
  (package
    (inherit rust-android-activity-0.5)
    (name "rust-android-activity")
    (version "0.4.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "android-activity" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32 "19imf29l08n7qlkqk3ri3m3nzfhm0lmkqizafs68i2ysbq2a0xvw"))))
    (arguments
     `(#:skip-build? #t     ; Only supports compiling for Android.
       #:cargo-inputs
       (("rust-android-properties" ,rust-android-properties-0.2)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-cc" ,rust-cc-1)
        ("rust-jni-sys" ,rust-jni-sys-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-ndk" ,rust-ndk-0.7)
        ("rust-ndk-context" ,rust-ndk-context-0.1)
        ("rust-ndk-sys" ,rust-ndk-sys-0.4)
        ("rust-num-enum" ,rust-num-enum-0.5))))))

(define-public rust-android-glue-0.2
  (package
    (name "rust-android-glue")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "android_glue" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "01y495x4i9vqkwmklwn2xk7sqg666az2axjcpkr4iwngdwi48100"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/tomaka/android-rs-glue")
    (synopsis "Glue for the Android JNI")
    (description "This package provides the glue for the Android JNI.")
    (license license:expat)))

(define-public rust-android-log-sys-0.3
  (package
    (name "rust-android-log-sys")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "android_log-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0dwrvwkx2xxqys6nrhfavbbqfx2rs61nq8akrlnqkfbapxb81k2y"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #true))      ;XXX: Android only
    (home-page "https://github.com/rust-mobile/android_log-sys-rs")
    (synopsis "FFI bindings to Android log Library")
    (description "This package provides FFI bindings to Android log Library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-android-log-sys-0.2
  (package
    (inherit rust-android-log-sys-0.3)
    (name "rust-android-log-sys")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "android_log-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0bhhs1cgzp9vzjvkn2q31ppc7w4am5s273hkvl5iac5475kmp5l5"))))
    (arguments `(#:skip-build? #true))))    ;XXX: Android only

(define-public rust-android-log-sys-0.1
  (package
    (inherit rust-android-log-sys-0.2)
    (name "rust-android-log-sys")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "android_log-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0klq7cp4lm74gjf9p12zdjcr159blbicrfvadmaqvfxbi8njw1dq"))))
    (arguments `(#:skip-build? #true)))) ;XXX: Android only

(define-public rust-android-logger-0.13
  (package
    (name "rust-android-logger")
    (version "0.13.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "android_logger" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0bvp6lf39q0zykn70lys562kdb14r9dfm91m79jxq53cfi7i7564"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-android-log-sys" ,rust-android-log-sys-0.3)
                       ("rust-env-logger" ,rust-env-logger-0.10)
                       ("rust-log" ,rust-log-0.4)
                       ("rust-once-cell" ,rust-once-cell-1))))
    (home-page "https://github.com/rust-mobile/android_logger-rs")
    (synopsis "Logging implementation for @code{log}")
    (description
     "This library is a drop-in replacement for @code{env_logger}.  Instead,
it outputs messages to Android's logcat.")
    (license (list license:expat license:asl2.0))))

(define-public rust-android-logger-0.11
  (package
    (inherit rust-android-logger-0.13)
    (name "rust-android-logger")
    (version "0.11.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "android_logger" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0fl8ix7q1cj73lzy6xcwyrqwpvnx5aaxszawidivv9ra4h6bh6c6"))))
    (arguments
     `(#:cargo-inputs (("rust-android-log-sys" ,rust-android-log-sys-0.2)
                       ("rust-env-logger" ,rust-env-logger-0.10)
                       ("rust-log" ,rust-log-0.4)
                       ("rust-once-cell" ,rust-once-cell-1))))))

(define-public rust-android-logger-0.10
  (package
    (inherit rust-android-logger-0.11)
    (name "rust-android-logger")
    (version "0.10.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "android_logger" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0rigzgkaik2y7pvsilpjdy19mdq1kkamw2rdf9fjkvb5hfqhkvfr"))))
    (arguments
     `(#:cargo-inputs
       (("rust-android-log-sys" ,rust-android-log-sys-0.2)
        ("rust-env-logger" ,rust-env-logger-0.8)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4))))))

(define-public rust-android-logger-0.8
  (package
    (inherit rust-android-logger-0.10)
    (name "rust-android-logger")
    (version "0.8.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "android_logger" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0kj8i03fqqwxd803hrk27j2399v27ajjj9zxi2nnyml0s4nm9gcc"))))
    (arguments
     `(#:cargo-inputs
       (("rust-android-log-sys" ,rust-android-log-sys-0.1)
        ("rust-env-logger" ,rust-env-logger-0.7)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-log" ,rust-log-0.4))))))

(define-public rust-android-properties-0.2
  (package
    (name "rust-android-properties")
    (version "0.2.2")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "android-properties" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32 "016slvg269c0y120p9qd8vdfqa2jbw4j0g18gfw6p3ain44v4zpw"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/miklelappo/android-properties")
    (synopsis "Rust-based Android properties wrapper")
    (description
     "This package provides a Rust-based Android properties wrapper.")
    (license license:expat)))

(define-public rust-android-system-properties-0.1
  (package
    (name "rust-android-system-properties")
    (version "0.1.5")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "android_system_properties" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32 "04b3wrz12837j7mdczqd95b732gw5q7q66cv4yn4646lvccp57l1"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/nical/android_system_properties")
    (synopsis "Minimal Android system properties wrapper")
    (description
     "This package provides a minimal Android system properties wrapper.")
    (license (list license:expat license:asl2.0))))

(define-public rust-android-tzdata-0.1
  (package
    (name "rust-android-tzdata")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "android-tzdata" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1w7ynjxrfs97xg3qlcdns4kgfpwcdv824g611fq32cag4cdr96g9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; Not all files included
       #:cargo-development-inputs (("rust-zip" ,rust-zip-0.6))))
    (home-page "https://github.com/RumovZ/android-tzdata")
    (synopsis "Parser for the Android-specific tzdata file")
    (description "Parser for the Android-specific tzdata file.")
    (license (list license:expat license:asl2.0))))

(define-public rust-anes-0.1
  (package
    (name "rust-anes")
    (version "0.1.6")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "anes" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "16bj1ww1xkwzbckk32j2pnbn5vk6wgsl3q4p3j9551xbcarwnijb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f                   ;FIXME: unresolved import anes::parser..?
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-libc" ,rust-libc-0.2))
       #:cargo-inputs (("rust-bitflags" ,rust-bitflags-1))))
    (home-page "https://github.com/zrzka/anes-rs")
    (synopsis "Parse ANSI escape sequences")
    (description
     "This package contains an ANSI escape sequences provider and parser.")
    ;; The user can choose either license.
    (license (list license:expat license:asl2.0))))

(define-public rust-annotate-snippets-0.11
  (package
    (name "rust-annotate-snippets")
    (version "0.11.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "annotate-snippets" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "14frjyhpm41mn2rn70p9288xny1l0jx70k7d2iy9k9sy9vamxqr4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-anstyle" ,rust-anstyle-1)
                       ("rust-unicode-width" ,rust-unicode-width-0.1))
       #:cargo-development-inputs (("rust-anstream" ,rust-anstream-0.6)
                                   ("rust-criterion" ,rust-criterion-0.5)
                                   ("rust-difference" ,rust-difference-2)
                                   ("rust-glob" ,rust-glob-0.3)
                                   ("rust-serde" ,rust-serde-1)
                                   ("rust-snapbox" ,rust-snapbox-0.6)
                                   ("rust-toml" ,rust-toml-0.5)
                                   ("rust-tryfn" ,rust-tryfn-0.2))))
    (home-page "https://github.com/rust-lang/annotate-snippets-rs")
    (synopsis "Library for building code annotations")
    (description
     "This package provides a library for building code annotations.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-annotate-snippets-0.10
  (package
    (inherit rust-annotate-snippets-0.11)
    (name "rust-annotate-snippets")
    (version "0.10.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "annotate-snippets" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1rmzxhi079d6j67x1dyv3sjkrc13x6av513cn27pwjl8i5bnd6vd"))))
    (arguments
     `(#:cargo-inputs (("rust-anstyle" ,rust-anstyle-1)
                       ("rust-unicode-width" ,rust-unicode-width-0.1))
       #:cargo-development-inputs (("rust-criterion" ,rust-criterion-0.5)
                                   ("rust-difference" ,rust-difference-2)
                                   ("rust-glob" ,rust-glob-0.3)
                                   ("rust-serde" ,rust-serde-1)
                                   ("rust-toml" ,rust-toml-0.5))))))

(define-public rust-annotate-snippets-0.9
  (package
    (inherit rust-annotate-snippets-0.10)
    (name "rust-annotate-snippets")
    (version "0.9.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "annotate-snippets" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "07p8r6jzb7nqydq0kr5pllckqcdxlyld2g275v425axnzffpxbyc"))))
    (arguments
     `(#:cargo-inputs (("rust-unicode-width" ,rust-unicode-width-0.1)
                       ("rust-yansi-term" ,rust-yansi-term-0.1))
       #:cargo-development-inputs (("rust-criterion" ,rust-criterion-0.3)
                                   ("rust-difference" ,rust-difference-2)
                                   ("rust-glob" ,rust-glob-0.3)
                                   ("rust-serde" ,rust-serde-1)
                                   ("rust-toml" ,rust-toml-0.5)
                                   ("rust-yansi-term" ,rust-yansi-term-0.1))))))

(define-public rust-annotate-snippets-0.6
  (package
    (inherit rust-annotate-snippets-0.10)
    (name "rust-annotate-snippets")
    (version "0.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "annotate-snippets" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "19x7ldklprdgf8pam8b3lfhrxqw5yldcvk5j0bw2agsajbj1q0n7"))))
    (arguments
     `(#:cargo-inputs (("rust-ansi-term" ,rust-ansi-term-0.11))
       #:cargo-development-inputs (("rust-ansi-term" ,rust-ansi-term-0.12)
                                   ("rust-difference" ,rust-difference-2)
                                   ("rust-glob" ,rust-glob-0.3)
                                   ("rust-serde" ,rust-serde-1)
                                   ("rust-serde-yaml" ,rust-serde-yaml-0.8))))))

(define-public rust-ansi-parser-0.8
  (package
    (name "rust-ansi-parser")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ansi-parser" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "09vi51kdnbwj6c4vdiiydpqxiiwyppn7kbynf22ij9xzg4h3kcmw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-heapless" ,rust-heapless-0.5)
                       ("rust-nom" ,rust-nom-4))))
    (home-page "https://gitlab.com/DavidBittner/ansi-parser")
    (synopsis "Library using nom for parsing ANSI Escape Codes")
    (description
     "This package provides a library using nom for parsing ANSI Escape Codes.")
    (license license:mpl2.0)))

(define-public rust-ansi-parser-0.6
  (package
    (inherit rust-ansi-parser-0.8)
    (name "rust-ansi-parser")
    (version "0.6.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ansi-parser" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "152idb8a6gwdxzj6m099h3xgx8vw0sjc6skgw94nm2k3y5swc6kn"))))
    (arguments
     `(#:cargo-inputs
       (("rust-heapless" ,rust-heapless-0.5)
        ("rust-nom" ,rust-nom-4))))))

(define-public rust-ansi-str-0.8
  (package
    (name "rust-ansi-str")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ansi-str" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "07ddhqynv05xjyhw295w29qy77fi84sh5p2mm46ap0d94s4mgx0w"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-ansitok" ,rust-ansitok-0.2))
       #:cargo-development-inputs (("rust-owo-colors" ,rust-owo-colors-3))))
    (home-page "https://github.com/zhiburt/ansi-str")
    (synopsis
     "Library which provides a set of methods to work with ANSI strings")
    (description
     "This package provides a library which provides a set of methods to work
with ANSI strings.")
    (license license:expat)))

(define-public rust-ansi-to-html-0.1
  (package
    (name "rust-ansi-to-html")
    (version "0.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ansi-to-html" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "18kwlgr3vfsij8gvl7vxw11yl628b1s8z2pldh73z4zzq2693gf7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-once-cell" ,rust-once-cell-1)
                       ("rust-regex" ,rust-regex-1)
                       ("rust-thiserror" ,rust-thiserror-1))
       #:cargo-development-inputs (("rust-insta" ,rust-insta-1))))
    (home-page
     "https://github.com/Aloso/to-html/tree/master/crates/ansi-to-html")
    (synopsis "ANSI escape codes to HTML converter")
    (description "This package provides an ANSI escape codes to HTML converter.")
    (license license:expat)))

(define-public rust-ansi-width-0.1
  (package
    (name "rust-ansi-width")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ansi-width" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "023693dwvci91456nfi0aygc44i1f098l2f23ssq67b1ybk3r7i1"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-unicode-width" ,rust-unicode-width-0.1))))
    (home-page "https://docs.rs/ansi-width")
    (synopsis "Calculate the width of a string when printed to the terminal")
    (description
     "Calculate the width of a string when printed to the terminal.")
    (license license:expat)))

(define-public rust-ansitok-0.2
  (package
    (name "rust-ansitok")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ansitok" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "10vc2d1325qsbvbnqnj48zg55wv7jz929drx9vpdscdvl7k48012"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-nom" ,rust-nom-7)
                       ("rust-vte" ,rust-vte-0.10))))
    (home-page "https://gitlab.com/zhiburt/ansitok")
    (synopsis "Library for parsing ANSI Escape Codes")
    (description
     "This package provides a library for parsing ANSI Escape Codes.")
    (license license:expat)))

(define-public rust-anstream-0.6
  (package
    (name "rust-anstream")
    (version "0.6.18")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "anstream" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "16sjk4x3ns2c3ya1x28a44kh6p47c7vhk27251i015hik1lm7k4a"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-anstyle" ,rust-anstyle-1)
        ("rust-anstyle-parse" ,rust-anstyle-parse-0.2)
        ("rust-anstyle-query" ,rust-anstyle-query-1)
        ("rust-anstyle-wincon" ,rust-anstyle-wincon-3)
        ("rust-colorchoice" ,rust-colorchoice-1)
        ("rust-is-terminal-polyfill" ,rust-is-terminal-polyfill-1)
        ("rust-utf8parse" ,rust-utf8parse-0.2))
       #:cargo-development-inputs
       (("rust-divan" ,rust-divan-0.1)
        ("rust-lexopt" ,rust-lexopt-0.3)
        ("rust-owo-colors" ,rust-owo-colors-4)
        ("rust-proptest" ,rust-proptest-1)
        ("rust-strip-ansi-escapes" ,rust-strip-ansi-escapes-0.2))))
    (home-page "https://github.com/rust-cli/anstyle")
    (synopsis "Library for writing colored text to a terminal")
    (description
     "This package provides a simple cross platform library for writing colored
text to a terminal.")
    (license (list license:expat license:asl2.0))))

(define-public rust-anstream-0.3
  (package
    (inherit rust-anstream-0.6)
    (name "rust-anstream")
    (version "0.3.2")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "anstream" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0qzinx9c8zfq3xqpxzmlv6nrm3ymccr4n8gffkdmj31p50v4za0c"))))
    (arguments
     `(#:cargo-inputs
       (("rust-anstyle" ,rust-anstyle-1)
        ("rust-anstyle-parse" ,rust-anstyle-parse-0.2)
        ("rust-anstyle-query" ,rust-anstyle-query-1)
        ("rust-anstyle-wincon" ,rust-anstyle-wincon-1)
        ("rust-colorchoice" ,rust-colorchoice-1)
        ("rust-is-terminal" ,rust-is-terminal-0.4)
        ("rust-utf8parse" ,rust-utf8parse-0.2))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.4)
        ("rust-owo-colors" ,rust-owo-colors-3)
        ("rust-proptest" ,rust-proptest-1)
        ("rust-strip-ansi-escapes" ,rust-strip-ansi-escapes-0.1))))))

(define-public rust-anstyle-1
  (package
    (name "rust-anstyle")
    (version "1.0.8")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "anstyle" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1cfmkza63xpn1kkz844mgjwm9miaiz4jkyczmwxzivcsypk1vv0v"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-lexopt" ,rust-lexopt-0.3))))
    (home-page "https://github.com/rust-cli/anstyle")
    (synopsis "ANSI text styling")
    (description "This package provides ANSI text styling.")
    (license (list license:expat license:asl2.0))))

(define-public rust-anstyle-0.3
  (package
    (inherit rust-anstyle-1)
    (name "rust-anstyle")
    (version "0.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "anstyle" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ll42s5ch4ldp0fw8laidqji540p7higd06h2v111qq2pn0rxsi3"))))
    (arguments
     `(#:cargo-development-inputs (("rust-lexopt" ,rust-lexopt-0.3))))))

(define-public rust-anstyle-lossy-1
  (package
    (name "rust-anstyle-lossy")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "anstyle-lossy" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "10c1cg8vjb7mxwky2xc8j7zdp15i1qvpmd2w6nlsxm6vcx3l9859"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-anstyle" ,rust-anstyle-1))))
    (home-page "https://github.com/rust-cli/anstyle")
    (synopsis "Conversion between ANSI color codes")
    (description "Lossy conversion between ANSI Color Codes.")
    (license (list license:expat license:asl2.0))))

(define-public rust-anstyle-parse-0.2
  (package
    (name "rust-anstyle-parse")
    (version "0.2.3")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "anstyle-parse" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "134jhzrz89labrdwxxnjxqjdg06qvaflj1wkfnmyapwyldfwcnn7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags
       '("--release" "--"
         "--skip=state::codegen::table")
       #:cargo-inputs
       (("rust-arrayvec" ,rust-arrayvec-0.7)
        ("rust-utf8parse" ,rust-utf8parse-0.2))
       #:cargo-development-inputs
       (("rust-codegenrs" ,rust-codegenrs-3)
        ("rust-criterion" ,rust-criterion-0.5)
        ("rust-proptest" ,rust-proptest-1)
        ("rust-snapbox" ,rust-snapbox-0.4)
        ("rust-vte-generate-state-changes" ,rust-vte-generate-state-changes-0.1))))
    (home-page "https://github.com/rust-cli/anstyle")
    (synopsis "Parse ANSI Style Escapes")
    (description "Parse ANSI Style Escapes")
    (license (list license:expat license:asl2.0))))

(define-public rust-anstyle-parse-0.1
  (package
    (inherit rust-anstyle-parse-0.2)
    (name "rust-anstyle-parse")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "anstyle-parse" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "05h1zy6y2ha2k8cnah9s0a296w2g3bfyfi2z7r7x3zly9r9vpld7"))))
    (arguments
     `(#:cargo-test-flags
       '("--release" "--"
         ;; not all files included
         "--skip=state::codegen::table")
       #:cargo-inputs (("rust-arrayvec" ,rust-arrayvec-0.7)
                       ("rust-utf8parse" ,rust-utf8parse-0.2))
       #:cargo-development-inputs
       (("rust-codegenrs" ,rust-codegenrs-2)
        ("rust-criterion" ,rust-criterion-0.4)
        ("rust-proptest" ,rust-proptest-1)
        ("rust-snapbox" ,rust-snapbox-0.4)
        ("rust-vte-generate-state-changes" ,rust-vte-generate-state-changes-0.1))))))

(define-public rust-anstyle-query-1
  (package
    (name "rust-anstyle-query")
    (version "1.0.2")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "anstyle-query" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0j3na4b1nma39g4x7cwvj009awxckjf3z2vkwhldgka44hqj72g2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-windows-sys" ,rust-windows-sys-0.52))))
    (home-page "https://github.com/rust-cli/anstyle")
    (synopsis "Look up colored console capabilities")
    (description "Look up colored console capabilities")
    (license (list license:expat license:asl2.0))))

(define-public rust-anstyle-stream-0.2
  (package
    (name "rust-anstyle-stream")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "anstyle-stream" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1l695l55mwxfz3iaw524cy89j57bm5y9y8xv63z5bldslmmrd0qk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-anstyle" ,rust-anstyle-0.3)
                       ("rust-anstyle-parse" ,rust-anstyle-parse-0.1)
                       ("rust-anstyle-wincon" ,rust-anstyle-wincon-0.2)
                       ("rust-concolor-override" ,rust-concolor-override-1)
                       ("rust-concolor-query" ,rust-concolor-query-0.3)
                       ("rust-is-terminal" ,rust-is-terminal-0.4)
                       ("rust-utf8parse" ,rust-utf8parse-0.2))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.4)
        ("rust-owo-colors" ,rust-owo-colors-3)
        ("rust-proptest" ,rust-proptest-1)
        ("rust-strip-ansi-escapes" ,rust-strip-ansi-escapes-0.1))))
    (home-page "https://github.com/rust-cli/anstyle")
    (synopsis "Library for writing colored text to a terminal")
    (description "This package provides a simple cross platform library for
writing colored text to a terminal.")
    (license (list license:expat license:asl2.0))))

(define-public rust-anstyle-svg-0.1
  (package
    (name "rust-anstyle-svg")
    (version "0.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "anstyle-svg" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0yi8d0cv1spcisch35b1f7q7lz7j7yyircrnvgaxcj5l8zadlvcb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; Tests segfault.
       #:cargo-inputs (("rust-anstream" ,rust-anstream-0.6)
                       ("rust-anstyle" ,rust-anstyle-1)
                       ("rust-anstyle-lossy" ,rust-anstyle-lossy-1)
                       ("rust-html-escape" ,rust-html-escape-0.2)
                       ("rust-unicode-width" ,rust-unicode-width-0.1))
       #:cargo-development-inputs (("rust-snapbox" ,rust-snapbox-0.5))))
    (home-page "https://github.com/rust-cli/anstyle")
    (synopsis "Convert ANSI escape codes to SVG")
    (description "Convert ANSI escape codes to SVG.")
    (license (list license:expat license:asl2.0))))

(define-public rust-antidote-1
  (package
    (name "rust-antidote")
    (version "1.0.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "antidote" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "19g2sw2qa2ibnh4x7j1snk46593jgx6y7rnvva496ynq61af5z9l"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/sfackler/rust-antidote")
    (synopsis "Poison-free Mutex and RwLock types")
    (description
     "These types expose identical APIs to the standard library @code{Mutex} and
@code{RwLock} except that they do not return @code{PoisonError}s.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-any-all-workaround-0.1
  (package
    (name "rust-any-all-workaround")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "any_all_workaround" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "11ifmzawvvi6d4r1lk0dkdnbswf574npgkika4535k7j6l3s9zl8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-cfg-if" ,rust-cfg-if-1))
       #:phases (modify-phases %standard-phases
                  ;; `#![feature]` may not be used on the stable release channel
                  ;; Enable using nightly/dev features
                  (add-after 'unpack 'enable-unstable-features
                    (lambda _ (setenv "RUSTC_BOOTSTRAP" "1"))))))
    (home-page "https://docs.rs/any_all_workaround/")
    (synopsis "Workaround for bad LLVM codegen for boolean reductions on 32-bit ARM")
    (description
     "This package provides Workaround for bad LLVM codegen for boolean
reductions on 32-bit ARM.")
    (license (list license:expat license:asl2.0))))

(define-public rust-anyhow-1
  (package
    (name "rust-anyhow")
    (version "1.0.95")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "anyhow" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "010vd1ki8w84dzgx6c81sc8qm9n02fxic1gkpv52zp4nwrn0kb1l"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-backtrace" ,rust-backtrace-0.3))
       #:cargo-development-inputs
       (("rust-futures" ,rust-futures-0.3)
        ("rust-rustversion" ,rust-rustversion-1)
        ("rust-syn" ,rust-syn-2)
        ("rust-thiserror" ,rust-thiserror-2)
        ("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://github.com/dtolnay/anyhow")
    (synopsis "Flexible concrete Error type")
    (description "This package provides a flexible concrete Error type built on
@code{std::error::Error}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-anyinput-0.1
  (package
    (name "rust-anyinput")
    (version "0.1.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "anyinput" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "08dkks0pg097vcjj3a43fxzazs2cnmf1jd7kcj8s3y6lfxj80n12"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-anyinput-derive" ,rust-anyinput-derive-0.1))))
    (home-page "https://github.com/CarlKCarlK/anyinput")
    (synopsis "Macro for functions that accept any input")
    (description
     "This package provides a macro for easier writing of functions that
accept any string-, path-, iterator-, array-, or ndarray-like input.")
    (license (list license:expat license:asl2.0))))

(define-public rust-anyinput-core-0.1
  (package
    (name "rust-anyinput-core")
    (version "0.1.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "anyinput-core" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "17y761xzk0xy7n5q0d76fb29f40cd59qa3b4kv58g9n8k2qivks9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-ndarray" ,rust-ndarray-0.16)
                       ("rust-proc-macro-error" ,rust-proc-macro-error-1)
                       ("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-strum" ,rust-strum-0.26)
                       ("rust-syn" ,rust-syn-2))))
    (home-page "https://github.com/CarlKCarlK/anyinput")
    (synopsis "Internal helper library of anyinput")
    (description
     "This package provides an internal helper library of anyinput.")
    (license (list license:expat license:asl2.0))))

(define-public rust-anyinput-derive-0.1
  (package
    (name "rust-anyinput-derive")
    (version "0.1.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "anyinput-derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1xcgkdkskmh8xxxyr1chfapn9avk8d8s7jjph5zy4ff22dri4m7y"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-anyinput-core" ,rust-anyinput-core-0.1)
                       ("rust-proc-macro-error" ,rust-proc-macro-error-1)
                       ("rust-proc-macro2" ,rust-proc-macro2-1))))
    (home-page "https://github.com/CarlKCarlK/anyinput")
    (synopsis "Internal helper library of anyinput")
    (description
     "This package provides an internal helper library of anyinput.")
    (license (list license:expat license:asl2.0))))

(define-public rust-apache-avro-0.16
  (package
    (name "rust-apache-avro")
    (version "0.16.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "apache-avro" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "180113hv4b7dw63szi5rzjb5pj8lwn5zyf8fnxq0kx7qna1wddyf"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-apache-avro-derive" ,rust-apache-avro-derive-0.16)
                       ("rust-bzip2" ,rust-bzip2-0.4)
                       ("rust-crc32fast" ,rust-crc32fast-1)
                       ("rust-digest" ,rust-digest-0.10)
                       ("rust-lazy-static" ,rust-lazy-static-1)
                       ("rust-libflate" ,rust-libflate-2)
                       ("rust-log" ,rust-log-0.4)
                       ("rust-num-bigint" ,rust-num-bigint-0.4)
                       ("rust-quad-rand" ,rust-quad-rand-0.2)
                       ("rust-rand" ,rust-rand-0.8)
                       ("rust-regex-lite" ,rust-regex-lite-0.1)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-serde-json" ,rust-serde-json-1)
                       ("rust-snap" ,rust-snap-1)
                       ("rust-strum" ,rust-strum-0.25)
                       ("rust-strum-macros" ,rust-strum-macros-0.25)
                       ("rust-thiserror" ,rust-thiserror-1)
                       ("rust-typed-builder" ,rust-typed-builder-0.16)
                       ("rust-uuid" ,rust-uuid-1)
                       ("rust-xz2" ,rust-xz2-0.1)
                       ("rust-zstd" ,rust-zstd-0.12))
       #:cargo-development-inputs
       (("rust-anyhow" ,rust-anyhow-1)
        ("rust-apache-avro-test-helper" ,rust-apache-avro-test-helper-0.16)
        ("rust-criterion" ,rust-criterion-0.5)
        ("rust-hex-literal" ,rust-hex-literal-0.4)
        ("rust-md-5" ,rust-md-5-0.10)
        ("rust-pretty-assertions" ,rust-pretty-assertions-1)
        ("rust-serial-test" ,rust-serial-test-2)
        ("rust-sha2" ,rust-sha2-0.10))))
    (home-page "https://github.com/apache/avro")
    (synopsis "Library for working with Apache Avro in Rust")
    (description
     "This package provides a library for working with Apache Avro in Rust.")
    (license license:asl2.0)))

(define-public rust-apache-avro-derive-0.16
  (package
    (name "rust-apache-avro-derive")
    (version "0.16.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "apache-avro-derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "192wmrzjz1bwfiwv11979kk3dl51q50vgppn2iyph8v9048y85z3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; use of undeclared crate or module `apache_avro`
       #:cargo-inputs (("rust-darling" ,rust-darling-0.20)
                       ("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-serde-json" ,rust-serde-json-1)
                       ("rust-syn" ,rust-syn-2))
       #:cargo-development-inputs (("rust-proptest" ,rust-proptest-1)
                                   ("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/apache/avro")
    (synopsis "Library for deriving Avro schemata from Rust structs and enums")
    (description "This package provides a library for deriving Avro schemata
from Rust structs and enums.")
    (license license:asl2.0)))

(define-public rust-apache-avro-test-helper-0.16
  (package
    (name "rust-apache-avro-test-helper")
    (version "0.16.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "apache-avro-test-helper" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1mgj73sli4m49frp4y460p7sxpkc73f00n5rqcbby4sh5fdqh9hf"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-anyhow" ,rust-anyhow-1)
                       ("rust-color-backtrace" ,rust-color-backtrace-0.5)
                       ("rust-ctor" ,rust-ctor-0.2)
                       ("rust-env-logger" ,rust-env-logger-0.10)
                       ("rust-lazy-static" ,rust-lazy-static-1)
                       ("rust-log" ,rust-log-0.4)
                       ("rust-ref-thread-local" ,rust-ref-thread-local-0.1))))
    (home-page "https://github.com/apache/avro")
    (synopsis "Apache Avro tests helper")
    (description "This package contains the Apache Avro tests helper.")
    (license license:asl2.0)))

(define-public rust-app-dirs2-2
  (package
    (name "rust-app-dirs2")
    (version "2.5.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "app_dirs2" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0bimzwj54fv8dvailkfb4l9sdsmnsn6hi183p76c3a736dbv7rx7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-jni" ,rust-jni-0.21)
        ("rust-ndk-context" ,rust-ndk-context-0.1)
        ("rust-winapi" ,rust-winapi-0.3)
        ("rust-xdg" ,rust-xdg-2))
       #:cargo-development-inputs
       (("rust-log" ,rust-log-0.4)
        ("rust-ndk-glue" ,rust-ndk-glue-0.7)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-tempfile" ,rust-tempfile-3)
        ("rust-test-case" ,rust-test-case-2))))
    (home-page "https://lib.rs/app_dirs2")
    (synopsis "Put app's data in the right place on every platform")
    (description
     "This package helps you to put your app's data in the right place
on every platform.")
    (license license:expat)))

(define-public rust-approx-0.5
  (package
    (name "rust-approx")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "approx" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ilpv3dgd58rasslss0labarq7jawxmivk17wsh8wmkdm3q15cfa"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-num-complex" ,rust-num-complex-0.4)
        ("rust-num-traits" ,rust-num-traits-0.2))))
    (home-page "https://github.com/brendanzab/approx")
    (synopsis "Approximate floating point equality comparisons and assertions")
    (description
     "This crate provides facilities for testing the approximate equality of
floating-point based types, using either relative difference, or units in the
last place (ULPs) comparisons.")
    (license license:asl2.0)))

(define-public rust-approx-0.4
  (package
    (name "rust-approx")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "approx" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0y52dg58lapl4pp1kqlznfw1blbki0nx6b0aw8kja2yi3gyhaaiz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-num-complex" ,rust-num-complex-0.3)
        ("rust-num-traits" ,rust-num-traits-0.2))))
    (home-page "https://github.com/brendanzab/approx")
    (synopsis "Approximate floating point equality comparisons and assertions")
    (description
     "This crate provides facilities for testing the approximate equality of
floating-point based types, using either relative difference, or units in the
last place (ULPs) comparisons.")
    (license license:asl2.0)))

(define-public rust-approx-0.3
  (package
    (inherit rust-approx-0.4)
    (name "rust-approx")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "approx" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1hx580xjdxl3766js9b49rnbnmr8gw8c060809l43k9f0xshprph"))))
    (arguments
     `(#:cargo-inputs
       (("rust-num-complex" ,rust-num-complex-0.2)
        ("rust-num-traits" ,rust-num-traits-0.2))))))

(define-public rust-approx-0.1
  (package
    (inherit rust-approx-0.3)
    (name "rust-approx")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "approx" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "153awzwywmb61xg857b80l63b1x6hifx2pha7lxf6fck9qxwraq8"))))
    (arguments '())))

(define-public rust-arbitrary-1
  (package
    (name "rust-arbitrary")
    (version "1.4.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "arbitrary" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "08zj2yanll5s5gsbmvgwvbq39iqzy3nia3yx3db3zwba08yhpqnx"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-derive-arbitrary" ,rust-derive-arbitrary-1))
       #:cargo-development-inputs (("rust-exhaustigen" ,rust-exhaustigen-0.1))))
    (home-page "https://github.com/rust-fuzz/arbitrary")
    (synopsis "Trait for generating structured data from unstructured data")
    (description
     "The @code{Arbitrary} crate lets you construct arbitrary instance of
a type.

This crate is primarily intended to be combined with a fuzzer like
@code{libFuzzer} and @code{cargo-fuzz} or AFL, and to help you turn the raw,
untyped byte buffers that they produce into well-typed, valid, structured
values.  This allows you to combine structure-aware test case generation with
coverage-guided, mutation-based fuzzers.")
    (license (list license:expat license:asl2.0))))

(define-public rust-arbitrary-0.4
  (package
    (inherit rust-arbitrary-1)
    (name "rust-arbitrary")
    (version "0.4.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arbitrary" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0sa55cynafwzvlhyhfpm3vmi2fydj3ipdj5yfbaif7l56cixfmfv"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-derive-arbitrary" ,rust-derive-arbitrary-0.4))))))

(define-public rust-arboard-3
  (package
    (name "rust-arboard")
    (version "3.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arboard" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0n7s54yjbv3qksq2fivcdnvriplmzp8fd14dfrw7k7048cciy152"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; tests require X11 $DISPLAY
       #:cargo-inputs (("rust-clipboard-win" ,rust-clipboard-win-5)
                       ("rust-core-graphics" ,rust-core-graphics-0.23)
                       ("rust-image" ,rust-image-0.24)
                       ("rust-log" ,rust-log-0.4)
                       ("rust-objc" ,rust-objc-0.2)
                       ("rust-objc-foundation" ,rust-objc-foundation-0.1)
                       ("rust-objc-id" ,rust-objc-id-0.1)
                       ("rust-parking-lot" ,rust-parking-lot-0.12)
                       ("rust-thiserror" ,rust-thiserror-1)
                       ("rust-windows-sys" ,rust-windows-sys-0.48)
                       ("rust-wl-clipboard-rs" ,rust-wl-clipboard-rs-0.8)
                       ("rust-x11rb" ,rust-x11rb-0.13))
       #:cargo-development-inputs (("rust-env-logger" ,rust-env-logger-0.9))))
    (home-page "https://github.com/1Password/arboard")
    (synopsis "Image and text handling for the OS clipboard")
    (description
     "This package provides image and text handling for the OS clipboard.")
    (license (list license:expat license:asl2.0))))

(define-public rust-arc-swap-1
  (package
    (name "rust-arc-swap")
    (version "1.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arc-swap" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0mrl9a9r9p9bln74q6aszvf22q1ijiw089jkrmabfqkbj31zixv9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-adaptive-barrier" ,rust-adaptive-barrier-1)
        ("rust-criterion" ,rust-criterion-0.5)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.8)
        ("rust-itertools" ,rust-itertools-0.12)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-parking-lot" ,rust-parking-lot-0.12)
        ("rust-proptest" ,rust-proptest-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-test" ,rust-serde-test-1))))
    (home-page "https://github.com/vorner/arc-swap")
    (synopsis "Atomically swappable Arc")
    (description "This package provides an atomically swappable Arc.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-archery-1
  (package
    (name "rust-archery")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "archery" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0sdqlmybcvd0rzv22ac3k3xxm5anr1gpm03sf02iy0jmrlhyvqpa"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-static-assertions" ,rust-static-assertions-1)
                       ("rust-triomphe" ,rust-triomphe-0.1))
       #:cargo-development-inputs
       (("rust-bincode" ,rust-bincode-1)
        ("rust-criterion" ,rust-criterion-0.5)
        ("rust-pretty-assertions" ,rust-pretty-assertions-1)
        ("rust-static-assertions" ,rust-static-assertions-1))))
    (home-page "https://github.com/orium/archery")
    (synopsis "Abstract over the atomicity of reference-counting pointers")
    (description "This package provides a way to abstract @code{Rc} and
@code{Arc} smart pointers.  It can also create data structures where
the pointer type is parameterizable.")
    (license license:mpl2.0)))

(define-public rust-arg-enum-proc-macro-0.3
  (package
    (name "rust-arg-enum-proc-macro")
    (version "0.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arg_enum_proc_macro" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1sjdfd5a8j6r99cf0bpqrd6b160x9vz97y5rysycsjda358jms8a"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-syn" ,rust-syn-2))
       #:cargo-development-inputs (("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://github.com/lu-zero/arg_enum_proc_macro")
    (synopsis "Procedural macro compatible with clap arg_enum")
    (description
     "This package provides a procedural macro compatible with clap's
@code{arg_enum}.")
    (license license:expat)))

(define-public rust-argfile-0.1
  (package
    (name "rust-argfile")
    (version "0.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "argfile" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1xm5yq9r04k9zf0hlx47a4yv86np6iwpqczfcmg0iia15bwc91qj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-fs-err" ,rust-fs-err-2)
        ("rust-os-str-bytes" ,rust-os-str-bytes-6)
        ("rust-shlex" ,rust-shlex-1))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-4)
        ("rust-wild" ,rust-wild-2))))
    (home-page "https://github.com/rust-cli/argfile")
    (synopsis "Load additional CLI arguments from a file")
    (description
     "This library enables loading additional @acronym{CLI,
Command-Line Interface} arguments from a file.  This is meant to work with any
CLI parser, like @code{rust-clap}, by pre-processing the arguments, like
@code{rust-wild}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-argh-0.1
  (package
    (name "rust-argh")
    (version "0.1.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "argh" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "06fjmac07knqw7vahra9rkbfrrsv31yrqhf7wi623xvzjq3bmxbs"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-argh-derive" ,rust-argh-derive-0.1)
                       ("rust-argh-shared" ,rust-argh-shared-0.1))
       #:cargo-development-inputs (("rust-once-cell" ,rust-once-cell-1)
                                   ("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://github.com/google/argh")
    (synopsis "Derive-based argument parser optimized for code size")
    (description "Derive-based argument parser optimized for code size.")
    (license license:bsd-3)))

(define-public rust-argh-derive-0.1
  (package
    (name "rust-argh-derive")
    (version "0.1.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "argh_derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0ynq2f2f05ybhmvg5y4m1kdfihw4jsq3bnq6gp32yykbvzp0mpsn"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-argh-shared" ,rust-argh-shared-0.1)
                       ("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-syn" ,rust-syn-2))))
    (home-page "https://github.com/google/argh")
    (synopsis "Derive-based argument parsing optimized for code size")
    (description "Derive-based argument parsing optimized for code size.")
    (license license:bsd-3)))

(define-public rust-argh-shared-0.1
  (package
    (name "rust-argh-shared")
    (version "0.1.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "argh_shared" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0cbmf3n5fd7ha014m303f4bmsmj0v84an4a1rh77d9dx868z74sn"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/google/argh")
    (synopsis "Derive-based argument parsing optimized for code size")
    (description "Derive-based argument parsing optimized for code size.")
    (license license:bsd-3)))

(define-public rust-argmax-0.3
  (package
    (name "rust-argmax")
    (version "0.3.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "argmax" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32 "0ricjx82rdnycjndlmaiwxc85lq3gh4av44xlkjwbwm7wgskwzjv"))))
    (build-system cargo-build-system)
    (arguments
    `(#:cargo-inputs
      (("rust-lazy-static" ,rust-lazy-static-1)
       ("rust-libc" ,rust-libc-0.2)
       ("rust-nix" ,rust-nix-0.24))))
    (home-page "https://github.com/sharkdp/argmax")
    (synopsis "Rust library to deal with 'argument too long' errors")
    (description "This package provides a rust library to deal with argument
too long errors.")
    (license (list license:expat license:asl2.0))))

(define-public rust-argminmax-0.6
  (package
    (name "rust-argminmax")
    (version "0.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "argminmax" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1alfp2wfh3pms6f5fj8qw9birndgac2jd2shdl2xascxsrclnhjj"))
       (modules '((guix build utils)))
       (snippet
        '(begin (substitute* "Cargo.toml"
                  (("\"=([[:digit:]]+(\\.[[:digit:]]+)*)" _ version)
                   (string-append "\"^" version)))))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t ; `#![feature]` may not be used on the stable release channel
       #:cargo-inputs (("rust-arrow" ,rust-arrow-5)
                       ("rust-arrow2" ,rust-arrow2-0.7)
                       ("rust-half" ,rust-half-2)
                       ("rust-ndarray" ,rust-ndarray-0.15)
                       ("rust-num-traits" ,rust-num-traits-0.2))
       #:cargo-development-inputs
       (("rust-codspeed-criterion-compat" ,rust-codspeed-criterion-compat-2)
        ("rust-criterion" ,rust-criterion-0.5)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-rstest" ,rust-rstest-0.18)
        ("rust-rstest-reuse" ,rust-rstest-reuse-0.6))))
    (home-page "https://github.com/jvdd/argminmax")
    (synopsis
     "ArgMinMax (argmin & argmax in 1 function) with SIMD for floats and integers")
    (description
     "@code{ArgMinMax} (argmin & argmax in 1 function) with SIMD for floats and
integers.")
    (license license:expat)))

(define-public rust-ariadne-0.1
  (package
    (name "rust-ariadne")
    (version "0.1.5")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "ariadne" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0303ig5g2v2xzhyzkis0nph2v21441vzalamhxgcxa5y8qh2mjzi"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-yansi" ,rust-yansi-0.5))))
    (home-page "https://github.com/zesterer/ariadne")
    (synopsis "Fancy diagnostics & reporting crate")
    (description "This package provides a fancy diagnostics & reporting crate.")
    (license license:expat)))

(define-public rust-arr-macro-0.1
  (package
    (name "rust-arr-macro")
    (version "0.1.3")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "arr_macro" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "199086q8zva66lbg9bpz6fa67s81ra7yfa8148cwy1w7lkymn43a"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-arr-macro-impl" ,rust-arr-macro-impl-0.1)
        ("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5))))
    (home-page "https://github.com/JoshMcguigan/arr_macro")
    (synopsis "Initialize arrays with ease")
    (description "Array macro helps initialize arrays.  It is useful when
initializing large arrays (greater than 32 elements), or arrays of types which
do not implement the copy or default traits.")
    (license (list license:expat license:asl2.0))))

(define-public rust-arr-macro-impl-0.1
  (package
    (name "rust-arr-macro-impl")
    (version "0.1.3")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "arr_macro_impl" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1lbjilz3pvwav72dfkcbz99rsq7m04xbdpqh8g3yvx3jsn5wf286"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/JoshMcguigan/arr_macro")
    (synopsis "Private impl crate for arr_macro")
    (description "This package provides a private @code{impl} crate for
@code{arr_macro}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-array-init-2
  (package
    (name "rust-array-init")
    (version "2.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "array-init" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1z0bh6grrkxlbknq3xyipp42rasngi806y92fiddyb2n99lvfqix"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/Manishearth/array-init/")
    (synopsis "Safe wrapper for initializing fixed-size arrays")
    (description
     "A crate that removes the need to fill an array before running
initialisers.  Provides an init closure that's called for each element of the
array.")
    (license (list license:expat license:asl2.0))))

(define-public rust-array-init-cursor-0.2
  (package
    (name "rust-array-init-cursor")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "array-init-cursor" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0xpbqf7qkvzplpjd7f0wbcf2n1v9vygdccwxkd1amxp4il0hlzdz"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/planus-org/planus")
    (synopsis "Utility crate to help keep track of arrays of MaybeUninit")
    (description
     "Utility crate to help keep track of arrays of @code{MaybeUninit}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-array-macro-1
  (package
    (name "rust-array-macro")
    (version "1.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "array-macro" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "19mdx2xlppnqwl6rhsbzylx61a0kkp2ql8q16195b7iga977ps86"))))
    (build-system cargo-build-system)
    (home-page "https://gitlab.com/KonradBorowski/array-macro")
    (synopsis "Array multiple elements constructor syntax")
    (description "This package implements constructor syntax for arrays with
multiple elements.")
    (license (list license:expat license:asl2.0))))

(define-public rust-array-ops-0.1
  (package
    (name "rust-array-ops")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "array-ops" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1jn7l9gppp6kr9kgsy22sw5p9cn1jazmqxy296gjwiwz5d11i4fc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-rand-core" ,rust-rand-core-0.5)
        ("rust-rand-xoshiro" ,rust-rand-xoshiro-0.4))))
    (home-page "https://github.com/bodil/array-ops")
    (synopsis "Automatic method implementations for array data types")
    (description "This package provides a number of traits with default
implementations for most of the standard library's methods on array like data
structures.")
    (license license:mpl2.0)))

(define-public rust-arraydeque-0.5
  (package
    (name "rust-arraydeque")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arraydeque" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0dn2xdfg3rkiqsh8a6achnmvf5nf11xk33xgjzpksliab4yjx43x"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/andylokandy/arraydeque")
    (synopsis
     "Ring buffer with a fixed capacity, which can be stored on the stack")
    (description
     "This package provides a ring buffer with a fixed capacity, which can be stored
on the stack.")
    (license (list license:expat license:asl2.0))))

(define-public rust-arrayref-0.3
  (package
    (name "rust-arrayref")
    (version "0.3.9")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrayref" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1jzyp0nvp10dmahaq9a2rnxqdd5wxgbvp8xaibps3zai8c9fi8kn"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs (("rust-quickcheck" ,rust-quickcheck-1))))
    (home-page "https://github.com/droundy/arrayref")
    (synopsis "Macros to take array references of slices")
    (description "Macros to take array references of slices.")
    (license license:bsd-2)))

(define-public rust-arraystring-0.3
  (package
    (name "rust-arraystring")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arraystring" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1181rr76jqlldrpy586cj2bzgxvzhn8crj2vg75diq8pf537qlad"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-diesel" ,rust-diesel-1)
                       ("rust-log" ,rust-log-0.4)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-typenum" ,rust-typenum-1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.2)
        ("rust-diesel" ,rust-diesel-1)
        ("rust-env-logger" ,rust-env-logger-0.5)
        ("rust-inlinable-string" ,rust-inlinable-string-0.1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-smallstring" ,rust-smallstring-0.1))))
    (home-page "https://github.com/paulocsanz/arraystring")
    (synopsis "Fixed capacity stack based generic string")
    (description
     "This package provides fixed capacity stack based generic string.")
    (license (list license:expat license:asl2.0))))

(define-public rust-arrayvec-0.7
  (package
    (name "rust-arrayvec")
    (version "0.7.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrayvec" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0l1fz4ccgv6pm609rif37sl5nv5k6lbzi7kkppgzqzh1vwix20kw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-borsh" ,rust-borsh-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-zeroize" ,rust-zeroize-1))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-matches" ,rust-matches-0.1)
        ("rust-serde-test" ,rust-serde-test-1))))
    (home-page "https://github.com/bluss/arrayvec")
    (synopsis "Vector with fixed capacity")
    (description
     "This package provides a vector with fixed capacity, backed by an
array (it can be stored on the stack too).  Implements fixed capacity
ArrayVec and ArrayString.")
    (license (list license:expat license:asl2.0))))

(define-public rust-arrayvec-0.5
  (package
    (inherit rust-arrayvec-0.7)
    (name "rust-arrayvec")
    (version "0.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrayvec" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "12q6hn01x5435bprwlb7w9m7817dyfq55yrl4psygr78bp32zdi3"))))
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-matches" ,rust-matches-0.1)
        ("rust-serde-test" ,rust-serde-test-1))))))

(define-public rust-arrayvec-0.4
  (package
    (inherit rust-arrayvec-0.5)
    (name "rust-arrayvec")
    (version "0.4.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrayvec" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1fdiv5m627gh6flp4mpmi1mh647imm9x423licsr11psz97d97yd"))))
    (arguments
     `(#:cargo-inputs
       (("rust-nodrop" ,rust-nodrop-0.1)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-matches" ,rust-matches-0.1)
        ("rust-serde-test" ,rust-serde-test-1))))))

(define-public rust-arrow-47
  (package
    (name "rust-arrow")
    (version "47.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrow" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0agq8c2q8nifsysnri8svh9m9dqkk55ww3d3slvqms4cpa9rxavz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags
       ;; Test fixtures are not included in the crate tarball. We need to skip
       ;; the tests that require these.
       '("--release" "--" "--exact"
         "--skip=util::test_util::tests::test_happy")
       #:cargo-inputs
       (("rust-ahash" ,rust-ahash-0.8)
        ("rust-arrow-arith" ,rust-arrow-arith-47)
        ("rust-arrow-array" ,rust-arrow-array-47)
        ("rust-arrow-buffer" ,rust-arrow-buffer-47)
        ("rust-arrow-cast" ,rust-arrow-cast-47)
        ("rust-arrow-csv" ,rust-arrow-csv-47)
        ("rust-arrow-data" ,rust-arrow-data-47)
        ("rust-arrow-ipc" ,rust-arrow-ipc-47)
        ("rust-arrow-json" ,rust-arrow-json-47)
        ("rust-arrow-ord" ,rust-arrow-ord-47)
        ("rust-arrow-row" ,rust-arrow-row-47)
        ("rust-arrow-schema" ,rust-arrow-schema-47)
        ("rust-arrow-select" ,rust-arrow-select-47)
        ("rust-arrow-string" ,rust-arrow-string-47)
        ("rust-pyo3" ,rust-pyo3-0.19)
        ("rust-rand" ,rust-rand-0.8))
       #:cargo-development-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-criterion" ,rust-criterion-0.5)
        ("rust-half" ,rust-half-2)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-serde" ,rust-serde-1)
        ("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/apache/arrow-rs")
    (synopsis "Rust implementation of Apache Arrow")
    (description "This crate provides a complete, safe and native Rust
implementation of Apache Arrow.")
    (license license:asl2.0)))

(define-public rust-arrow-5
  (package
    (inherit rust-arrow-47)
    (name "rust-arrow")
    (version "5.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrow" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0c8j4766cfjc04dmcyayigbn6mim9cfys78a64ilw26qrxpyhy16"))))
    (arguments
     `(#:tests? #f
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-csv" ,rust-csv-1)
        ("rust-flatbuffers" ,rust-flatbuffers-2)
        ("rust-getrandom" ,rust-getrandom-0.2)
        ("rust-hex" ,rust-hex-0.4)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-lexical-core" ,rust-lexical-core-0.7)
        ("rust-multiversion" ,rust-multiversion-0.6)
        ("rust-num" ,rust-num-0.4)
        ("rust-packed-simd-2" ,rust-packed-simd-2-0.3)
        ("rust-prettytable-rs" ,rust-prettytable-rs-0.8)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-regex" ,rust-regex-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-flate2" ,rust-flate2-1)
        ("rust-tempfile" ,rust-tempfile-3))))))

(define-public rust-arrow-arith-47
  (package
    (name "rust-arrow-arith")
    (version "47.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrow-arith" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0mprvyxmnj3x84l6p8h34zz11kil71x5gf989zk9xbc7iqv4w7dw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-arrow-array" ,rust-arrow-array-47)
        ("rust-arrow-buffer" ,rust-arrow-buffer-47)
        ("rust-arrow-data" ,rust-arrow-data-47)
        ("rust-arrow-schema" ,rust-arrow-schema-47)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-half" ,rust-half-2)
        ("rust-num" ,rust-num-0.4))))
    (home-page "https://github.com/apache/arrow-rs")
    (synopsis "Arithmetic and aggregation kernels Apache Arrow")
    (description "This crate provides arithmetic and aggregation kernels for
Apache Arrow.  Examples include time-related functions, logical operations for
booleans, arithmetic functions such as addition and various aggregation
functions.")
    (license license:asl2.0)))

(define-public rust-arrow-array-47
  (package
    (name "rust-arrow-array")
    (version "47.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrow-array" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "139iwhc3j8mcn6avgjl4k3sc7g43kq92m02fbba05qgdadrglbnh"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-ahash" ,rust-ahash-0.8)
        ("rust-arrow-buffer" ,rust-arrow-buffer-47)
        ("rust-arrow-data" ,rust-arrow-data-47)
        ("rust-arrow-schema" ,rust-arrow-schema-47)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-chrono-tz" ,rust-chrono-tz-0.8)
        ("rust-half" ,rust-half-2)
        ("rust-hashbrown" ,rust-hashbrown-0.14)
        ("rust-num" ,rust-num-0.4)
        ("rust-packed-simd" ,rust-packed-simd-0.3))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.5)
        ("rust-rand" ,rust-rand-0.8))))
    (home-page "https://github.com/apache/arrow-rs")
    (synopsis "Array abstractions for Apache Arrow")
    (description "The central type in Apache Arrow are arrays, which are a
known-length sequence of values all having the same type.  This crate provides
concrete implementations of each type, as well as an @code{Array} trait that
can be used for type-erasure.")
    (license license:asl2.0)))

(define-public rust-arrow-array-43
  (package
    (inherit rust-arrow-array-47)
    (name "rust-arrow-array")
    (version "43.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrow-array" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1l7k48p40b8j4nzda5z20b45zsaphm9yylzwryr8n7vxbxrfmmv3"))))
    (arguments
     `(#:cargo-test-flags
       '("--release" "--"
         "--skip=array::binary_array::tests::test_binary_array_from_incorrect_list_array")
       #:cargo-inputs (("rust-ahash" ,rust-ahash-0.8)
                       ("rust-arrow-buffer" ,rust-arrow-buffer-43)
                       ("rust-arrow-data" ,rust-arrow-data-43)
                       ("rust-arrow-schema" ,rust-arrow-schema-43)
                       ("rust-chrono" ,rust-chrono-0.4)
                       ("rust-chrono-tz" ,rust-chrono-tz-0.8)
                       ("rust-half" ,rust-half-2)
                       ("rust-hashbrown" ,rust-hashbrown-0.14)
                       ("rust-num" ,rust-num-0.4)
                       ("rust-packed-simd-2" ,rust-packed-simd-2-0.3))
       #:cargo-development-inputs (("rust-criterion" ,rust-criterion-0.5)
                                   ("rust-rand" ,rust-rand-0.8))))))

(define-public rust-arrow-buffer-47
  (package
    (name "rust-arrow-buffer")
    (version "47.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrow-buffer" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "15b1km7kb7cys2pdxgq1p9syiw7yzf9cch85rcw12504a8i1k8gx"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bytes" ,rust-bytes-1)
        ("rust-half" ,rust-half-2)
        ("rust-num" ,rust-num-0.4))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.5)
        ("rust-rand" ,rust-rand-0.8))))
    (home-page "https://github.com/apache/arrow-rs")
    (synopsis "Buffer abstractions for Apache Arrow")
    (description "This crate provides low-level buffer abstractions for the
Rust implementation of Apache Arrow.")
    (license license:asl2.0)))

(define-public rust-arrow-buffer-43
  (package
    (inherit rust-arrow-buffer-47)
    (name "rust-arrow-buffer")
    (version "43.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrow-buffer" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "08m7cxfksmc2qsygba0ingr1a3acbrxx9qdr0184wj3z0yg47gmx"))))
    (arguments
     `(#:cargo-inputs (("rust-half" ,rust-half-2)
                       ("rust-num" ,rust-num-0.4))
       #:cargo-development-inputs (("rust-criterion" ,rust-criterion-0.5)
                                   ("rust-rand" ,rust-rand-0.8))))))

(define-public rust-arrow-cast-47
  (package
    (name "rust-arrow-cast")
    (version "47.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrow-cast" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1vjdr0gqln3x60jlwan6vfb6f1alhww95by51gani24np58mv0hx"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags
       '("--release" "--"
         "--skip=display::tests::test_array_value_to_string_duration")
       #:cargo-inputs
       (("rust-arrow-array" ,rust-arrow-array-47)
        ("rust-arrow-buffer" ,rust-arrow-buffer-47)
        ("rust-arrow-data" ,rust-arrow-data-47)
        ("rust-arrow-schema" ,rust-arrow-schema-47)
        ("rust-arrow-select" ,rust-arrow-select-47)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-comfy-table" ,rust-comfy-table-7)
        ("rust-half" ,rust-half-2)
        ("rust-lexical-core" ,rust-lexical-core-0.8)
        ("rust-num" ,rust-num-0.4))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.5)
        ("rust-half" ,rust-half-2))))
    (home-page "https://github.com/apache/arrow-rs")
    (synopsis "Cast kernels and utilities for Apache Arrow")
    (description "This crate provides typecasting kernels and other utilities
for Apache Arrow, such as prettyprinting, parsing, and Base64 encoding and
decoding.")
    (license license:asl2.0)))

(define-public rust-arrow-csv-47
  (package
    (name "rust-arrow-csv")
    (version "47.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrow-csv" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1wff8a151xspfrcc4lda6g0d9fa6vva63q23gwcxq9miqrfqbvs3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags
       ;; Test fixtures are not included in the crate tarball. We need to skip
       ;; the tests that require these.
       '("--release"
         ;; Skip the doctests, since some of these also depend on the test
         ;; fixtures.
         "--lib" "--bins" "--tests"
         "--"
         "--exact"
         "--skip=reader::tests::test_buffered"
         "--skip=reader::tests::test_csv"
         "--skip=reader::tests::test_csv_builder_with_bounds"
         "--skip=reader::tests::test_csv_from_buf_reader"
         "--skip=reader::tests::test_csv_reader_with_decimal"
         "--skip=reader::tests::test_csv_schema_metadata"
         "--skip=reader::tests::test_csv_with_dictionary"
         "--skip=reader::tests::test_csv_with_projection"
         "--skip=reader::tests::test_csv_with_schema_inference"
         "--skip=reader::tests::test_csv_with_schema_inference_no_headers"
         "--skip=reader::tests::test_custom_nulls"
         "--skip=reader::tests::test_custom_nulls_with_inference"
         "--skip=reader::tests::test_nulls"
         "--skip=reader::tests::test_nulls_with_inference"
         "--skip=reader::tests::test_parse_invalid_csv")
       #:cargo-inputs
       (("rust-arrow-array" ,rust-arrow-array-47)
        ("rust-arrow-buffer" ,rust-arrow-buffer-47)
        ("rust-arrow-cast" ,rust-arrow-cast-47)
        ("rust-arrow-data" ,rust-arrow-data-47)
        ("rust-arrow-schema" ,rust-arrow-schema-47)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-csv" ,rust-csv-1)
        ("rust-csv-core" ,rust-csv-core-0.1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-lexical-core" ,rust-lexical-core-0.8)
        ("rust-regex" ,rust-regex-1))
       #:cargo-development-inputs
       (("rust-bytes" ,rust-bytes-1)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-tempfile" ,rust-tempfile-3)
        ("rust-tokio" ,rust-tokio-1))))
    (home-page "https://github.com/apache/arrow-rs")
    (synopsis "Parse CSV formatted data to and from the Arrow format")
    (description "This crate enables support for transferring data between the
Arrow memory format and CSV line-delimited records.")
    (license license:asl2.0)))

(define-public rust-arrow-data-47
  (package
    (name "rust-arrow-data")
    (version "47.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrow-data" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0fpp09ykg6nb7jcaqnjzga242y7nlrfz3v0wlrf0kd68k4v4qnj7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-arrow-buffer" ,rust-arrow-buffer-47)
        ("rust-arrow-schema" ,rust-arrow-schema-47)
        ("rust-half" ,rust-half-2)
        ("rust-num" ,rust-num-0.4))))
    (home-page "https://github.com/apache/arrow-rs")
    (synopsis "Low-level array data abstractions for Apache Arrow")
    (description "This crate contains low-level array data abstractions for
the Apache Arrow implementation in Rust.")
    (license license:asl2.0)))

(define-public rust-arrow-data-43
  (package
    (inherit rust-arrow-data-47)
    (name "rust-arrow-data")
    (version "43.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrow-data" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "12q2dvfaj78rfj5k3sfn8d3fnhwp3iizd4dbf5m14526qniz9x6l"))))
    (arguments
     `(#:cargo-inputs (("rust-arrow-buffer" ,rust-arrow-buffer-43)
                       ("rust-arrow-schema" ,rust-arrow-schema-43)
                       ("rust-half" ,rust-half-2)
                       ("rust-num" ,rust-num-0.4))))))

(define-public rust-arrow-format-0.8
  (package
    (name "rust-arrow-format")
    (version "0.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrow-format" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1irj67p6c224dzw86jr7j3z9r5zfid52gy6ml8rdqk4r2si4x207"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-planus" ,rust-planus-0.3)
                       ("rust-prost" ,rust-prost-0.11)
                       ("rust-prost-derive" ,rust-prost-derive-0.11)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-tonic" ,rust-tonic-0.8))))
    (home-page "https://github.com/DataEngineeringLabs/arrow-format")
    (synopsis "Unofficial flatbuffers and tonic code of Apache Arrow spec")
    (description "This package provides an nofficial flatbuffers and tonic
code of Apache Arrow spec.")
    (license license:asl2.0)))

(define-public rust-arrow-format-0.3
  (package
    (inherit rust-arrow-format-0.8)
    (name "rust-arrow-format")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrow-format" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0apg3x3yllbazh6jr85g5yammjqxpnrk6jm4n2yypyhbcvcs4zcz"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-flatbuffers" ,rust-flatbuffers-2)
        ("rust-prost" ,rust-prost-0.9)
        ("rust-prost-derive" ,rust-prost-derive-0.9)
        ("rust-tonic" ,rust-tonic-0.6))))))

(define-public rust-arrow-ipc-47
  (package
    (name "rust-arrow-ipc")
    (version "47.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrow-ipc" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0shnrpmkwicxcn12s6lw8xqj9xibjjfqah58nxlzhjf5i9f00j0j"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-arrow-array" ,rust-arrow-array-47)
        ("rust-arrow-buffer" ,rust-arrow-buffer-47)
        ("rust-arrow-cast" ,rust-arrow-cast-47)
        ("rust-arrow-data" ,rust-arrow-data-47)
        ("rust-arrow-schema" ,rust-arrow-schema-47)
        ("rust-flatbuffers" ,rust-flatbuffers-23)
        ("rust-lz4" ,rust-lz4-1)
        ("rust-zstd" ,rust-zstd-0.12))
       #:cargo-development-inputs
       (("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/apache/arrow-rs")
    (synopsis "Support for the Arrow IPC format")
    (description "This crate provides support for the Arrow @acronym{IPC,
Interprocess Communication} format.")
    (license license:asl2.0)))

(define-public rust-arrow-json-47
  (package
    (name "rust-arrow-json")
    (version "47.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrow-json" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "175ncx809i6gq7i4xr03kxkk3f2nxnd49zjlqg78qs6x0hxpwggh"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags
       ;; Test fixtures are not included in the crate tarball. We need to skip
       ;; the tests that require these.
       '("--release"
         ;; Skip the doctests, since some of these also depend on the test
         ;; fixtures.
         "--lib" "--bins" "--tests"
         "--"
         "--exact"
         "--skip=reader::schema::tests::test_json_infer_schema"
         "--skip=reader::tests::test_date_from_json_milliseconds"
         "--skip=reader::tests::test_json_arrays"
         "--skip=reader::tests::test_json_basic"
         "--skip=reader::tests::test_json_basic_schema"
         "--skip=reader::tests::test_json_basic_schema_projection"
         "--skip=reader::tests::test_json_basic_with_nulls"
         "--skip=reader::tests::test_json_empty_projection"
         "--skip=reader::tests::test_json_iterator"
         "--skip=reader::tests::test_time_from_json_nanoseconds"
         "--skip=reader::tests::test_timestamp_from_json_milliseconds"
         "--skip=reader::tests::test_timestamp_from_json_seconds"
         "--skip=reader::tests::test_with_multiple_batches"
         "--skip=writer::tests::test_write_multi_batches"
         "--skip=writer::tests::test_write_single_batch"
         "--skip=writer::tests::write_arrays"
         "--skip=writer::tests::write_basic_nulls"
         "--skip=writer::tests::write_basic_rows"
         "--skip=writer::tests::write_durations")
       #:cargo-inputs
       (("rust-arrow-array" ,rust-arrow-array-47)
        ("rust-arrow-buffer" ,rust-arrow-buffer-47)
        ("rust-arrow-cast" ,rust-arrow-cast-47)
        ("rust-arrow-data" ,rust-arrow-data-47)
        ("rust-arrow-schema" ,rust-arrow-schema-47)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-half" ,rust-half-2)
        ("rust-indexmap" ,rust-indexmap-2)
        ("rust-lexical-core" ,rust-lexical-core-0.8)
        ("rust-num" ,rust-num-0.4)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1))
       #:cargo-development-inputs
       (("rust-bytes" ,rust-bytes-1)
        ("rust-flate2" ,rust-flate2-1)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-serde" ,rust-serde-1)
        ("rust-tempfile" ,rust-tempfile-3)
        ("rust-tokio" ,rust-tokio-1))))
    (home-page "https://github.com/apache/arrow-rs")
    (synopsis "Parse JSON formatted data to and from the Arrow format")
    (description
     "This crate enables support for transferring data between the Arrow
memory format and JSON line-delimited records.")
    (license license:asl2.0)))

(define-public rust-arrow-ord-47
  (package
    (name "rust-arrow-ord")
    (version "47.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrow-ord" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1x3irbymxic9hjaakq0rvkcqxj1jq2hfpclywh066spa12j7mf03"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-arrow-array" ,rust-arrow-array-47)
        ("rust-arrow-buffer" ,rust-arrow-buffer-47)
        ("rust-arrow-data" ,rust-arrow-data-47)
        ("rust-arrow-schema" ,rust-arrow-schema-47)
        ("rust-arrow-select" ,rust-arrow-select-47)
        ("rust-half" ,rust-half-2)
        ("rust-num" ,rust-num-0.4))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.8))))
    (home-page "https://github.com/apache/arrow-rs")
    (synopsis "Ordering kernels for Apache Arrow arrays")
    (description "This crate provides various ordering kernels for Apache
Arrow arrays.  Examples include @code{cmp}, @code{ord}, @code{partition},
@code{rank} and @code{sort} kernels.")
    (license license:asl2.0)))

(define-public rust-arrow-row-47
  (package
    (name "rust-arrow-row")
    (version "47.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrow-row" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "08jxyqvsm3pvz09jprqrxdhg1yczncyb5jlgj2vckrw1nn538jhi"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-ahash" ,rust-ahash-0.8)
        ("rust-arrow-array" ,rust-arrow-array-47)
        ("rust-arrow-buffer" ,rust-arrow-buffer-47)
        ("rust-arrow-data" ,rust-arrow-data-47)
        ("rust-arrow-schema" ,rust-arrow-schema-47)
        ("rust-half" ,rust-half-2)
        ("rust-hashbrown" ,rust-hashbrown-0.14))
       #:cargo-development-inputs
       (("rust-arrow-cast" ,rust-arrow-cast-47)
        ("rust-arrow-ord" ,rust-arrow-ord-47)
        ("rust-rand" ,rust-rand-0.8))))
    (home-page "https://github.com/apache/arrow-rs")
    (synopsis "Row-oriented Apache Arrow representation")
    (description "This crate provides a comparable row-oriented representation
of a collection of @code{Array}.  Rows are normalized for sorting, and can
therefore be very efficiently compared, using @code{memcmp} under the hood, or
used in non-comparison sorts such as radix sort.")
    (license license:asl2.0)))

(define-public rust-arrow-schema-47
  (package
    (name "rust-arrow-schema")
    (version "47.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrow-schema" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0jyfw40m070zj2pv8mp3gvlnzs0mavnzn6qhw19qh5bv26f1f7ax"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-2)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-bincode" ,rust-bincode-1)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/apache/arrow-rs")
    (synopsis "Logical types for Apache Arrow arrays")
    (description "This crate defines the logical types for arrays of the
Apache Arrow implementation in Rust.")
    (license license:asl2.0)))

(define-public rust-arrow-schema-43
  (package
    (inherit rust-arrow-schema-47)
    (name "rust-arrow-schema")
    (version "43.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrow-schema" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0zp8jz0pcr2d020rrmkdkzg6yizb2gc0fbfgzddb2w7mxrbwpsrb"))))
    (arguments
     `(#:cargo-inputs (("rust-bitflags" ,rust-bitflags-2)
                       ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs (("rust-bincode" ,rust-bincode-1)
                                   ("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-arrow-select-47
  (package
    (name "rust-arrow-select")
    (version "47.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrow-select" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0231igp3fihf2kz1s9i2k6vhnlpmg662gr9rn6fpxrh26801xiym"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-ahash" ,rust-ahash-0.8)
        ("rust-arrow-array" ,rust-arrow-array-47)
        ("rust-arrow-buffer" ,rust-arrow-buffer-47)
        ("rust-arrow-data" ,rust-arrow-data-47)
        ("rust-arrow-schema" ,rust-arrow-schema-47)
        ("rust-num" ,rust-num-0.4))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.8))))
    (home-page "https://github.com/apache/arrow-rs")
    (synopsis "Selection kernels for Apache Arrow arrays")
    (description "This crate provides various selection kernels for Apache
Arrow arrays.  Examples include @code{filter}, @code{concat} and @code{take}
kernels, as well as @code{window} functions such as shifting.")
    (license license:asl2.0)))

(define-public rust-arrow-string-47
  (package
    (name "rust-arrow-string")
    (version "47.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrow-string" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ar1njf4biff3ylpyk2m2bhvqmsywl9akagljm429ffnharbpkn4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-arrow-array" ,rust-arrow-array-47)
        ("rust-arrow-buffer" ,rust-arrow-buffer-47)
        ("rust-arrow-data" ,rust-arrow-data-47)
        ("rust-arrow-schema" ,rust-arrow-schema-47)
        ("rust-arrow-select" ,rust-arrow-select-47)
        ("rust-num" ,rust-num-0.4)
        ("rust-regex" ,rust-regex-1)
        ("rust-regex-syntax" ,rust-regex-syntax-0.7))))
    (home-page "https://github.com/apache/arrow-rs")
    (synopsis "String kernels for Apache Arrow arrays")
    (description "This crate provides various string kernels for Apache Arrow
arrays.  Examples include @code{concat_elements}, @code{length}, @code{like},
@code{regexp} and @code{substring} kernels.")
    (license license:asl2.0)))

(define-public rust-arrow2-0.17
  (package
    (name "rust-arrow2")
    (version "0.17.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrow2" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1yh40rdx0hwyag621byl6rk8w2jzvgvsj78sg1yp82qlxbd6ii2r"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; failed to resolve: could not find `parquet` in `io`
       #:cargo-inputs
       (("rust-ahash" ,rust-ahash-0.8)
        ("rust-arrow-array" ,rust-arrow-array-43)
        ("rust-arrow-buffer" ,rust-arrow-buffer-43)
        ("rust-arrow-data" ,rust-arrow-data-43)
        ("rust-arrow-format" ,rust-arrow-format-0.8)
        ("rust-arrow-schema" ,rust-arrow-schema-43)
        ("rust-async-stream" ,rust-async-stream-0.3)
        ("rust-avro-schema" ,rust-avro-schema-0.3)
        ("rust-base64" ,rust-base64-0.21)
        ("rust-bytemuck" ,rust-bytemuck-1)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-chrono-tz" ,rust-chrono-tz-0.8)
        ("rust-comfy-table" ,rust-comfy-table-6)
        ("rust-csv" ,rust-csv-1)
        ("rust-csv-async" ,rust-csv-async-1)
        ("rust-csv-core" ,rust-csv-core-0.1)
        ("rust-dyn-clone" ,rust-dyn-clone-1)
        ("rust-either" ,rust-either-1)
        ("rust-ethnum" ,rust-ethnum-1)
        ("rust-fallible-streaming-iterator" ,rust-fallible-streaming-iterator-0.1)
        ("rust-foreign-vec" ,rust-foreign-vec-0.1)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-getrandom" ,rust-getrandom-0.2)
        ("rust-hash-hasher" ,rust-hash-hasher-2)
        ("rust-hashbrown" ,rust-hashbrown-0.13)
        ("rust-hex" ,rust-hex-0.4)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-itertools" ,rust-itertools-0.10)
        ("rust-json-deserializer" ,rust-json-deserializer-0.4)
        ("rust-lexical-core" ,rust-lexical-core-0.8)
        ("rust-lz4" ,rust-lz4-1)
        ("rust-multiversion" ,rust-multiversion-0.7)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-odbc-api" ,rust-odbc-api-0.36)
        ("rust-orc-format" ,rust-orc-format-0.3)
        ("rust-parquet2" ,rust-parquet2-0.17)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-regex" ,rust-regex-1)
        ("rust-regex-syntax" ,rust-regex-syntax-0.6)
        ("rust-rustc-version" ,rust-rustc-version-0.4)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-simdutf8" ,rust-simdutf8-0.1)
        ("rust-streaming-iterator" ,rust-streaming-iterator-0.1)
        ("rust-strength-reduce" ,rust-strength-reduce-0.2)
        ("rust-zstd" ,rust-zstd-0.12))
       #:cargo-development-inputs
       (("rust-avro-rs" ,rust-avro-rs-0.13)
        ("rust-criterion" ,rust-criterion-0.4)
        ("rust-crossbeam-channel" ,rust-crossbeam-channel-0.5)
        ("rust-doc-comment" ,rust-doc-comment-0.3)
        ("rust-flate2" ,rust-flate2-1)
        ("rust-proptest" ,rust-proptest-1)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-sample-arrow2" ,rust-sample-arrow2-0.1)
        ("rust-sample-std" ,rust-sample-std-0.1)
        ("rust-sample-test" ,rust-sample-test-0.1)
        ("rust-tokio" ,rust-tokio-1)
        ("rust-tokio-util" ,rust-tokio-util-0.7))))
    (home-page "https://github.com/jorgecarleitao/arrow2")
    (synopsis "Unofficial implementation of Apache Arrow spec in safe Rust")
    (description "Unofficial implementation of Apache Arrow spec in safe Rust.")
    (license license:asl2.0)))

(define-public rust-arrow2-0.7
  (package
    (name "rust-arrow2")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "arrow2" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "15dkirkx07bagjgcar2ikmvs0d1zsk5l99bsszla91rxbivy4wyq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-ahash" ,rust-ahash-0.7)
        ("rust-arrow-format" ,rust-arrow-format-0.3)
        ("rust-avro-rs" ,rust-avro-rs-0.13)
        ("rust-base64" ,rust-base64-0.13)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-chrono-tz" ,rust-chrono-tz-0.6)
        ("rust-comfy-table" ,rust-comfy-table-4)
        ("rust-csv" ,rust-csv-1)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-hash-hasher" ,rust-hash-hasher-2)
        ("rust-hex" ,rust-hex-0.4)
        ("rust-indexmap" ,rust-indexmap-1)
        ("rust-itertools" ,rust-itertools-0.10)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-lexical-core" ,rust-lexical-core-0.8)
        ("rust-libflate" ,rust-libflate-1)
        ("rust-lz4" ,rust-lz4-1)
        ("rust-multiversion" ,rust-multiversion-0.6)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-packed-simd-2" ,rust-packed-simd-2-0.3)
        ("rust-parquet2" ,rust-parquet2-0.6)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-regex" ,rust-regex-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-simdutf8" ,rust-simdutf8-0.1)
        ("rust-streaming-iterator" ,rust-streaming-iterator-0.1)
        ("rust-strength-reduce" ,rust-strength-reduce-0.2)
        ("rust-zstd" ,rust-zstd-0.9))))
    (home-page "https://github.com/jorgecarleitao/arrow2")
    (synopsis "Unofficial implementation of Apache Arrow spec in safe Rust")
    (description
     "Arrow2 is a Rust library to work with the Arrow format.  It is
a re-write of the official Arrow crate using transmute-free operations.")
    (license license:asl2.0)))

(define-public rust-article-scraper-1
  (package
    (name "rust-article-scraper")
    (version "1.1.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "article_scraper" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1l904hn99fgj83f3dhspxgz1j3xzgjbnbfsgvmhd1jg5l4hqfhxp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f ;tests use the network
       #:cargo-inputs
       (("rust-base64" ,rust-base64-0.13)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-encoding-rs" ,rust-encoding-rs-0.8)
        ("rust-failure" ,rust-failure-0.1)
        ("rust-image" ,rust-image-0.23)
        ("rust-libxml" ,rust-libxml-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-parking-lot" ,rust-parking-lot-0.11)
        ("rust-regex" ,rust-regex-1)
        ("rust-reqwest" ,rust-reqwest-0.11)
        ("rust-tokio" ,rust-tokio-1)
        ("rust-url" ,rust-url-2))))
    (native-inputs
     (list pkg-config))
    (inputs
     (list libxml2 openssl))
    (home-page "https://gitlab.com/news-flash/article_scraper")
    (synopsis "Scrap article contents from the web")
    (description "This package provides a crate to scrap article contents from
the web.")
    ;; No copyright headers in the source code.  LICENSE indicates gpl3.
    (license license:gpl3)))

(define-public rust-as-derive-utils-0.11
  (package
    (name "rust-as-derive-utils")
    (version "0.11.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "as_derive_utils" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1i2kwzxdhydicj9bqscz5w73nmx612yi3ha137qlr900b5j9cg7z"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f              ; Only doc tests, which fail.
       #:cargo-inputs (("rust-aho-corasick" ,rust-aho-corasick-0.7)
                       ("rust-bitflags" ,rust-bitflags-1)
                       ("rust-core-extensions" ,rust-core-extensions-1)
                       ("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-regex" ,rust-regex-1)
                       ("rust-ron" ,rust-ron-0.7)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-serde-derive" ,rust-serde-derive-1)
                       ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/rodrimati1992/abi_stable_crates/")
    (synopsis "Private derive utilities used by abi_stable and structural")
    (description "This package contains private derive utilities used by
the abi_stable and structural crates.")
    (license (list license:expat license:asl2.0))))

(define-public rust-as-derive-utils-0.10
  (package
    (inherit rust-as-derive-utils-0.11)
    (name "rust-as-derive-utils")
    (version "0.10.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "as_derive_utils" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "16qxh5q7gn6vnzk20g7vaj76f4dd74zkn66fv638ryyfjnj6z8p0"))
       (modules '((guix build utils)))
       (snippet
        '(begin (substitute* "Cargo.toml"
                  (((string-append ">=([[:digit:]]+\\.[[:digit:]]+\\.[[:digit:]]+),"
                                   " <([[:digit:]]+\\.[[:digit:]]+\\.[[:digit:]]+)")
                    _ version _)
                   (string-append ">=" version)))))))
    (arguments
     `(#:tests? #f              ; Only doc tests, which fail.
       #:cargo-inputs
       (("rust-aho-corasick" ,rust-aho-corasick-0.7)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-core-extensions" ,rust-core-extensions-1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-ron" ,rust-ron-0.6)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-syn" ,rust-syn-1))))))

(define-public rust-as-derive-utils-0.8
  (package
    (inherit rust-as-derive-utils-0.10)
    (name "rust-as-derive-utils")
    (version "0.8.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "as_derive_utils" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1rjmbasb2spxdmm47kzw2zmr8icbdrcr0wa9kyn7lim5c0idh69b"))
       (modules '((guix build utils)))
       (snippet
        '(begin (substitute* "Cargo.toml"
                  (("\"~([[:digit:]]+(\\.[[:digit:]]+)*)" _ version)
                   (string-append "\"^" version)))))))
    (arguments
     `(#:cargo-inputs
       (("rust-aho-corasick" ,rust-aho-corasick-0.7)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-core-extensions" ,rust-core-extensions-0.1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-ron" ,rust-ron-0.5)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-syn" ,rust-syn-1))))))

(define-public rust-as-raw-xcb-connection-1
  (package
    (name "rust-as-raw-xcb-connection")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "as-raw-xcb-connection" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1am99fbsp5f5vnbvr0qnjma36q49c9zvdbn0czwwvian18mk2prd"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/psychon/as-raw-xcb-connection")
    (synopsis "Trait to facilitate interoperatibility with libxcb C API")
    (description "This package provides trait to facilitate interoperatibility
with @code{libxcb} C API.")
    (license (list license:expat license:asl2.0))))

(define-public rust-as-slice-0.2
  (package
    (name "rust-as-slice")
    (version "0.2.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "as-slice" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "05j52y1ws8kir5zjxnl48ann0if79sb56p9nm76hvma01r7nnssi"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-stable-deref-trait" ,rust-stable-deref-trait-1))))
    (home-page "https://github.com/japaric/as-slice")
    (synopsis "AsSlice and AsMutSlice traits")
    (description "This package provides @code{AsSlice} and @code{AsMutSlice}
traits.")
    (license (list license:expat license:asl2.0))))

(define-public rust-as-slice-0.1
  (package
    (inherit rust-as-slice-0.2)
    (name "rust-as-slice")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "as-slice" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1q3a9494ikaq38zjg5px5gwwrbdgnyj23b505224njlmwd4knh25"))))
    (arguments
     `(#:cargo-inputs
       (("rust-generic-array-0.14" ,rust-generic-array-0.14)
        ("rust-generic-array-0.13" ,rust-generic-array-0.13)
        ("rust-generic-array-0.12" ,rust-generic-array-0.12)
        ("rust-stable-deref-trait" ,rust-stable-deref-trait-1))))))

(define-public rust-as-variant-1
  (package
    (name "rust-as-variant")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "as_variant" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "13vryhfcslf50f8j1msnxg5689bzwz56z45dgzxqd7r40wis53zk"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/jplatte/as_variant")
    (synopsis "Macro to convert enums with newtype variants to Option")
    (description
     "This package provides a simple macro to convert enums with newtype
variants to `Option`s.")
    (license license:mpl2.0)))

(define-public rust-ascii-1
  (package
    (name "rust-ascii")
    (version "1.1.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "ascii" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32 "05nyyp39x4wzc1959kv7ckwqpkdzjd9dw4slzyjh73qbhjcfqayr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-serde" ,rust-serde-1)
        ("rust-serde-test" ,rust-serde-test-1))))
    (home-page "https://github.com/tomprogrammer/rust-ascii")
    (synopsis "ASCII-only equivalents to `char`, `str` and `String`")
    (description
     "A rust library that provides ASCII-only string and character types,
equivalent to the @code{char}, @code{str} and @code{String} types in the
standard library.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-ascii-0.9
  (package
    (inherit rust-ascii-1)
    (name "rust-ascii")
    (version "0.9.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ascii" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0km3zzkhrr22drf9p1zcblqirlxkdc7zra25acpi0h8qax5c1cga"))))
    (arguments
     `(#:tests? #f      ; Not all tests build.
       #:cargo-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.6)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-test" ,rust-serde-test-1))))))

(define-public rust-ascii-0.8
  (package
    (inherit rust-ascii-1)
    (name "rust-ascii")
    (version "0.8.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ascii" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "051gh2bgjq90s0f0i0hd9p4z4fpg5k82b570d1223jj7rhd8kglp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags
       '("--release" "--"
         "--skip=src/ascii_char.rs - ascii_char::AsciiChar::from (line 296)"
         "--skip=src/ascii_string.rs - ascii_string::AsciiString::pop (line 259)")
       #:cargo-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.4))))))

(define-public rust-ascii-utils-0.9
  (package
    (name "rust-ascii-utils")
    (version "0.9.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ascii_utils" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0jpp550pwi38msflpy7lnqm2r153kn9k19bss6k9ak9yacq8z4vi"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/tredoe/ascii_utils")
    (synopsis "Utilities to handle ASCII characters")
    (description
     "This library provides utilities to handle ASCII characters.")
    (license license:mpl2.0)))

(define-public rust-assert-0.7
  (package
    (name "rust-assert")
    (version "0.7.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "assert" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1fxwnw8ypr6i6bxsy4ggzpjb70aysl044nfzyl3q8kyyv25zqisn"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/stainless-steel/assert")
    (synopsis "Assertions for testing")
    (description "This package provides assertions for testing.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-assert-approx-eq-1
  (package
    (name "rust-assert-approx-eq")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "assert_approx_eq" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1zagfwfad5wssmr830gk3489f97ppczv6xs627jxniwm6ssdl1rw"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/ashleygwilliams/assert_approx_eq")
    (synopsis "Assert approximately equal")
    (description
     "This package provides a Rust macro for asserting two numbers are
approximately equal.")
    ;; Either license can be chosen at the users option.
    (license (list license:expat license:asl2.0))))

(define-public rust-assert-cli-0.6
  (package
    (name "rust-assert-cli")
    (version "0.6.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "assert_cli" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0jc1bh3cvnl66bl7s5gr1xnm0hl8d2l3gmil0pmhp5v2xp0bg6m2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f ;; requires `printenv`, but installing coreutils doesn't help
       #:cargo-inputs
       (("rust-colored" ,rust-colored-1)
        ("rust-difference" ,rust-difference-2)
        ("rust-environment" ,rust-environment-0.1)
        ("rust-failure" ,rust-failure-0.1)
        ("rust-failure-derive" ,rust-failure-derive-0.1)
        ("rust-serde-json" ,rust-serde-json-1))
       #:cargo-development-inputs
       (("rust-docmatic" ,rust-docmatic-0.1))))
    (home-page "https://github.com/assert-rs/assert_cli")
    (synopsis "Test CLI Applications")
    (description "This package helps testing CLI Applications.")
    (license (list license:expat license:asl2.0))))

(define-public rust-assert-cmd-2
  (package
    (name "rust-assert-cmd")
    (version "2.0.16")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "assert_cmd" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0gdj0710k3lnvyjmpv8a4dgwrk9ib85l2wfw4n2xwy3qyavka66w"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-anstream" ,rust-anstream-0.6)
        ("rust-anstyle" ,rust-anstyle-1)
        ("rust-bstr" ,rust-bstr-1)
        ("rust-doc-comment" ,rust-doc-comment-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-predicates" ,rust-predicates-3)
        ("rust-predicates-core" ,rust-predicates-core-1)
        ("rust-predicates-tree" ,rust-predicates-tree-1)
        ("rust-wait-timeout" ,rust-wait-timeout-0.2))
       #:cargo-development-inputs
       (("rust-automod" ,rust-automod-1)
        ("rust-escargot" ,rust-escargot-0.5))))
    (home-page "https://github.com/assert-rs/assert_cmd")
    (synopsis "Test CLI Applications")
    (description "@code{assert_cmd} aims to simplify the process for doing
integration testing of CLIs, including finding your crate's binary to test and
assertions on the result of your program's run.")
    (license (list license:expat license:asl2.0))))

(define-public rust-assert-cmd-1
  (package
    (inherit rust-assert-cmd-2)
    (name "rust-assert-cmd")
    (version "1.0.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "assert_cmd" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1zhz7bgzsmwc50bknw658q6i0lcwk67v6zp74fmh31ixcz3370n9"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bstr" ,rust-bstr-0.2)
        ("rust-doc-comment" ,rust-doc-comment-0.3)
        ("rust-predicates" ,rust-predicates-2)
        ("rust-predicates-core" ,rust-predicates-core-1)
        ("rust-predicates-tree" ,rust-predicates-tree-1)
        ("rust-wait-timeout" ,rust-wait-timeout-0.2))
       #:cargo-development-inputs
       (("rust-escargot" ,rust-escargot-0.5))))))

(define-public rust-assert-float-eq-1
  (package
    (name "rust-assert-float-eq")
    (version "1.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "assert_float_eq" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0xryhlk2p012y109048c5jj5f448cv0b86ylkjgg5v7dzcpnbsjc"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/AlexHuszagh/assert_float_eq")
    (synopsis "Assertions for floating-point equality")
    (description "This package provides assertions for floating-point equality.")
    (license (list license:expat license:asl2.0))))

(define-public rust-assert-fs-1
  (package
    (name "rust-assert-fs")
    (version "1.0.13")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "assert_fs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0j2vhxyb12ng6knln2bckywp5yqqxqhdd3gf0rfyvhp5d1x62w7h"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags
       '("--release" "--"
         ;; Not all files included.
         "--skip=assert::test::into_path_from_bytes"
         "--skip=assert::test::into_path_from_str")
       #:cargo-inputs
       (("rust-anstream" ,rust-anstream-0.3)
        ("rust-anstyle" ,rust-anstyle-1)
        ("rust-doc-comment" ,rust-doc-comment-0.3)
        ("rust-globwalk" ,rust-globwalk-0.8)
        ("rust-predicates" ,rust-predicates-3)
        ("rust-predicates-core" ,rust-predicates-core-1)
        ("rust-predicates-tree" ,rust-predicates-tree-1)
        ("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/assert-rs/assert_fs")
    (synopsis "Filesystem fixtures and assertions for testing")
    (description
     "This crate provides file system fixtures and assertions for testing.")
    (license (list license:expat license:asl2.0))))

(define-public rust-assert-impl-0.1
  (package
    (name "rust-assert-impl")
    (version "0.1.3")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "assert-impl" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "17jvig9rwdc1sf1j5q8q9k69njg3k8g7x7g6wcb711hcvq9l6in3"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/upsuper/assert-impl")
    (synopsis "Macro for static assert types implement a trait or not")
    (description "Macro for static assert types implement a trait or not")
    (license license:expat)))

(define-public rust-assert-json-diff-2
  (package
    (name "rust-assert-json-diff")
    (version "2.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "assert-json-diff" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "04mg3w0rh3schpla51l18362hsirl23q93aisws2irrj32wg5r27"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-serde" ,rust-serde-1)
                       ("rust-serde-json" ,rust-serde-json-1))
       #:cargo-development-inputs
       (("rust-serde" ,rust-serde-1)
        ("rust-version-sync" ,rust-version-sync-0.8))))
    (home-page "https://github.com/davidpdrsn/assert-json-diff")
    (synopsis "Easily compare two JSON values and get great output")
    (description "This package lets you easily compare two JSON values
and get great output.")
    (license license:expat)))

(define-public rust-assert-matches-1
  (package
    (name "rust-assert-matches")
    (version "1.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "assert_matches" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1a9b3p9vy0msylyr2022sk5flid37ini1dxji5l3vwxsvw4xcd4v"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/murarth/assert_matches")
    (synopsis "Asserts that a value matches a pattern")
    (description
     "This package asserts that a value matches a pattern in Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-assert-matches2-0.1
  (package
    (name "rust-assert-matches2")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "assert_matches2" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0mnz1wgz1s2s1985h44mdhy2m7615jjyr9pzq359injqqja2v0qm"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs (("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://codeberg.org/jplatte/assert_matches2")
    (synopsis
     "Assert_matches! macro that brings variables from the pattern into scope")
    (description
     "This package provides a version of the assert_matches! macro that brings
variables from the pattern into scope.")
    (license license:mpl2.0)))

(define-public rust-assert2-0.3
  (package
    (name "rust-assert2")
    (version "0.3.11")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "assert2" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "15cfdn5sl8ls6234pv2ysflw2xcxh8j1ypjlif7wnva0hc8qvyga"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-assert2-macros" ,rust-assert2-macros-0.3)
                       ("rust-is-terminal" ,rust-is-terminal-0.4)
                       ("rust-yansi" ,rust-yansi-0.5))))
    (home-page "https://github.com/de-vri-es/assert2-rs")
    (synopsis "Macros inspired by Catch2")
    (description "This package provides assert!(...) and check!(...) macros
inspired by Catch2.")
    (license license:bsd-2)))

(define-public rust-assert2-macros-0.3
  (package
    (name "rust-assert2-macros")
    (version "0.3.11")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "assert2-macros" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0dcjbac962smxr6pmnsd6mdglh6any36ifshqzqzi4ppwvrvsmbc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-rustc-version" ,rust-rustc-version-0.4)
                       ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/de-vri-es/assert2-rs")
    (synopsis "Procedural macros for assert2")
    (description "This package provides procedural macros for assert2.")
    (license license:bsd-2)))

(define-public rust-associative-cache-2
  (package
    (name "rust-associative-cache")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "associative-cache" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1b9bgf19c27sdch6c4x2qyf34i1cl8f328knv1yk1irbg9vcv4xr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-rand" ,rust-rand-0.8))))
    (home-page "https://github.com/fitzgen/associative-cache")
    (synopsis "Associative cache with fixed-size capacity")
    (description
     "This package provides a generic N-way associative cache with fixed-size
capacity and random or least recently used (LRU) replacement.")
    (license (list license:expat license:asl2.0))))

(define-public rust-associative-cache-1
  (package
    (inherit rust-associative-cache-2)
    (name "rust-associative-cache")
    (version "1.0.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "associative-cache" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "05lg0mwpqfqb9zh958x0358x1k5ngmmmbzjnp0imrd8vzhrn40a6"))))
    (arguments
     ;; 2 doctests fail because rand is not declared
     `(#:tests? #false
       #:cargo-inputs (("rust-rand" ,rust-rand-0.7))))))

(define-public rust-async-attributes-1
  (package
    (name "rust-async-attributes")
    (version "1.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-attributes" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1rcnypqgmlcw9vwh0fk8bivvz8p5v8acy0zd2njdv6yxyiwkw853"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-async-std" ,rust-async-std-0.99))))
    (home-page "https://github.com/async-rs/async-attributes")
    (synopsis "Experimental language-level polyfills for Async Rust")
    (description
     "This package provides experimental language-level polyfills for Async
Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-broadcast-0.7
  (package
    (name "rust-async-broadcast")
    (version "0.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-broadcast" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0zia7z1y31awmxma9c89zmvkbj7mdkf7highkmz5z3pa4lp0xk90"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-event-listener" ,rust-event-listener-5)
                       ("rust-event-listener-strategy" ,rust-event-listener-strategy-0.5)
                       ("rust-futures-core" ,rust-futures-core-0.3)
                       ("rust-pin-project-lite" ,rust-pin-project-lite-0.2))
       #:cargo-development-inputs (("rust-criterion" ,rust-criterion-0.3)
                                   ("rust-doc-comment" ,rust-doc-comment-0.3)
                                   ("rust-easy-parallel" ,rust-easy-parallel-3)
                                   ("rust-futures-lite" ,rust-futures-lite-1)
                                   ("rust-futures-util" ,rust-futures-util-0.3))))
    (home-page "https://github.com/smol-rs/async-broadcast")
    (synopsis "Async broadcast channels")
    (description "This package provides async broadcast channels in Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-broadcast-0.6
  (package
    (inherit rust-async-broadcast-0.7)
    (name "rust-async-broadcast")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-broadcast" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0d1xk2pr5khk1radkbaf7pp7pbjkb18m43n2rgkfsfxk177pak9k"))))
    (arguments
     `(#:cargo-inputs
       (("rust-event-listener" ,rust-event-listener-3)
        ("rust-event-listener-strategy" ,rust-event-listener-strategy-0.1)
        ("rust-futures-core" ,rust-futures-core-0.3))
       #:cargo-development-inputs (("rust-criterion" ,rust-criterion-0.3)
                                   ("rust-doc-comment" ,rust-doc-comment-0.3)
                                   ("rust-easy-parallel" ,rust-easy-parallel-3)
                                   ("rust-futures-lite" ,rust-futures-lite-1)
                                   ("rust-futures-util" ,rust-futures-util-0.3))))))

(define-public rust-async-broadcast-0.5
  (package
    (inherit rust-async-broadcast-0.6)
    (name "rust-async-broadcast")
    (version "0.5.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "async-broadcast" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0avdqbci1qdlfc4glc3wqrb0wi5ffc7bqv2q1wg14syayvdwqj3w"))))
    (arguments
     `(#:cargo-inputs
       (("rust-event-listener" ,rust-event-listener-2)
        ("rust-futures-core" ,rust-futures-core-0.3))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-doc-comment" ,rust-doc-comment-0.3)
        ("rust-easy-parallel" ,rust-easy-parallel-3)
        ("rust-futures-lite" ,rust-futures-lite-1)
        ("rust-futures-util" ,rust-futures-util-0.3))))))

(define-public rust-async-channel-2
  (package
    (name "rust-async-channel")
    (version "2.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-channel" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0skvwxj6ysfc6d7bhczz9a2550260g62bm5gl0nmjxxyn007id49"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-concurrent-queue" ,rust-concurrent-queue-2)
        ("rust-event-listener-strategy" ,rust-event-listener-strategy-0.5)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-pin-project-lite" ,rust-pin-project-lite-0.2))
       #:cargo-development-inputs
       (("rust-easy-parallel" ,rust-easy-parallel-3)
        ("rust-futures-lite" ,rust-futures-lite-2)
        ("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.3))))
    (home-page "https://github.com/smol-rs/async-channel")
    (synopsis "Async multi-producer multi-consumer channel")
    (description "This package provides async multi-producer
multi-consumer channels.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-channel-1
  (package
    (inherit rust-async-channel-2)
    (name "rust-async-channel")
    (version "1.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-channel" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0dbdlkzlncbibd3ij6y6jmvjd0cmdn48ydcfdpfhw09njd93r5c1"))))
    (arguments
     `(#:cargo-inputs
       (("rust-concurrent-queue" ,rust-concurrent-queue-2)
        ("rust-event-listener" ,rust-event-listener-2)
        ("rust-futures-core" ,rust-futures-core-0.3))
       #:cargo-development-inputs
       (("rust-easy-parallel" ,rust-easy-parallel-3)
        ("rust-futures-lite" ,rust-futures-lite-1))))))

(define-public rust-async-compat-0.2
  (package
    (name "rust-async-compat")
    (version "0.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-compat" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1h4gqla7s8wczivqskbxg7nl3qj0svd6yf9fjssgg8wnwfyr9avv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-futures-core" ,rust-futures-core-0.3)
                       ("rust-futures-io" ,rust-futures-io-0.3)
                       ("rust-once-cell" ,rust-once-cell-1)
                       ("rust-pin-project-lite" ,rust-pin-project-lite-0.2)
                       ("rust-tokio" ,rust-tokio-1))
       #:cargo-development-inputs (("rust-blocking" ,rust-blocking-1)
                                   ("rust-futures" ,rust-futures-0.3)
                                   ("rust-reqwest" ,rust-reqwest-0.12)
                                   ("rust-tokio" ,rust-tokio-1)
                                   ("rust-warp" ,rust-warp-0.3))))
    (native-inputs (list pkg-config))
    (inputs (list openssl))
    (home-page "https://github.com/smol-rs/async-compat")
    (synopsis "Compatibility adapter between tokio and futures")
    (description
     "This package provides compatibility adapter between tokio and futures.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-compression-0.4
  (package
    (name "rust-async-compression")
    (version "0.4.18")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-compression" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "08pmavgjha81hf1acwxka82vi0r711whnp5lyha68r3hbx8mm2fz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-brotli" ,rust-brotli-7)
                       ("rust-bzip2" ,rust-bzip2-0.4)
                       ("rust-deflate64" ,rust-deflate64-0.1)
                       ("rust-flate2" ,rust-flate2-1)
                       ("rust-futures-core" ,rust-futures-core-0.3)
                       ("rust-futures-io" ,rust-futures-io-0.3)
                       ("rust-memchr" ,rust-memchr-2)
                       ("rust-pin-project-lite" ,rust-pin-project-lite-0.2)
                       ("rust-tokio" ,rust-tokio-1)
                       ("rust-xz2" ,rust-xz2-0.1)
                       ("rust-zstd" ,rust-zstd-0.13)
                       ("rust-zstd-safe" ,rust-zstd-safe-7))
       #:cargo-development-inputs (("rust-bytes" ,rust-bytes-1)
                                   ("rust-futures" ,rust-futures-0.3)
                                   ("rust-futures-test" ,rust-futures-test-0.3)
                                   ("rust-ntest" ,rust-ntest-0.9)
                                   ("rust-proptest" ,rust-proptest-1)
                                   ("rust-proptest-derive" ,rust-proptest-derive-0.5)
                                   ("rust-rand" ,rust-rand-0.8)
                                   ("rust-tokio" ,rust-tokio-1)
                                   ("rust-tokio-util" ,rust-tokio-util-0.7))))
    (home-page "https://github.com/Nullus157/async-compression")
    (synopsis
     "Adaptors between compression crates and Rust's modern asynchronous IO types")
    (description "This package provides adaptors between compression crates
and Rust's modern asynchronous IO types.")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-compression-0.3
  (package
    (inherit rust-async-compression-0.4)
    (name "rust-async-compression")
    (version "0.3.15")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-compression" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0fnnpbsljngmrj8amhw6yg164bl6x4r43mr093g1ps9rmvbpqb4l"))))
    (arguments
     `(#:cargo-inputs
       (("rust-brotli" ,rust-brotli-3)
        ("rust-bytes" ,rust-bytes-0.5)
        ("rust-bzip2" ,rust-bzip2-0.4)
        ("rust-flate2" ,rust-flate2-1)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-io" ,rust-futures-io-0.3)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-pin-project-lite" ,rust-pin-project-lite-0.2)
        ("rust-tokio" ,rust-tokio-0.2)
        ("rust-tokio" ,rust-tokio-0.3)
        ("rust-tokio" ,rust-tokio-1)
        ("rust-xz2" ,rust-xz2-0.1)
        ("rust-zstd" ,rust-zstd-0.11)
        ("rust-zstd-safe" ,rust-zstd-safe-5))
       #:cargo-development-inputs
       (("rust-bytes" ,rust-bytes-1)
        ("rust-bytes" ,rust-bytes-0.6)
        ("rust-bytes" ,rust-bytes-0.5)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-futures-test" ,rust-futures-test-0.3)
        ("rust-ntest" ,rust-ntest-0.8)
        ("rust-proptest" ,rust-proptest-1)
        ("rust-proptest-derive" ,rust-proptest-derive-0.3)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-tokio" ,rust-tokio-1)
        ("rust-tokio" ,rust-tokio-0.2)
        ("rust-tokio" ,rust-tokio-0.3)
        ("rust-tokio-util" ,rust-tokio-util-0.6)
        ("rust-tokio-util" ,rust-tokio-util-0.5)
        ("rust-tokio-util" ,rust-tokio-util-0.4)
        ("rust-tokio-util" ,rust-tokio-util-0.3))))))

(define-public rust-async-datagram-3
  (package
    (name "rust-async-datagram")
    (version "3.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-datagram" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0k4kiy67d24ay8l7xrfjpsa4zkmhxv97ddj0f16rcv61qkky3i4f"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/rustasync/async-datagram")
    (synopsis "Async datagram traits")
    (description "This package provides asynchronous datagram traits.")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-dup-1
  (package
    (name "rust-async-dup")
    (version "1.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-dup" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0484raf2r5lj97b8skkric9ysivrp3bns0gcg67h7x9sasmqca3w"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-async-lock" ,rust-async-lock-3)
        ("rust-futures-io" ,rust-futures-io-0.3))
       #:cargo-development-inputs
       (("rust-futures" ,rust-futures-0.3)
        ("rust-smol" ,rust-smol-0.1))))
    (home-page "https://github.com/stjepang/async-dup")
    (synopsis "Duplicate an async I/O handle")
    (description
     "This crate provides two tools, Arc and Mutex.  Arc implements
AsyncRead, AsyncWrite, and AsyncSeek if a reference to the inner type
does.  A reference to Mutex implements AsyncRead, AsyncWrite, and
AsyncSeek if the inner type does.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-executor-1
  (package
    (name "rust-async-executor")
    (version "1.13.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-executor" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1v6w1dbvsmw6cs4dk4lxj5dvrikc6xi479wikwaab2qy3h09mjih"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-async-task" ,rust-async-task-4)
        ("rust-concurrent-queue" ,rust-concurrent-queue-2)
        ("rust-fastrand" ,rust-fastrand-2)
        ("rust-futures-lite" ,rust-futures-lite-2)
        ("rust-slab" ,rust-slab-0.4))
       #:cargo-development-inputs
       (("rust-async-channel" ,rust-async-channel-2)
        ("rust-async-io" ,rust-async-io-2)
        ("rust-async-lock" ,rust-async-lock-3)
        ("rust-criterion" ,rust-criterion-0.5)
        ("rust-easy-parallel" ,rust-easy-parallel-3)
        ("rust-fastrand" ,rust-fastrand-2)
        ("rust-futures-lite" ,rust-futures-lite-2)
        ("rust-once-cell" ,rust-once-cell-1))))
    (home-page "https://github.com/stjepang/async-executor")
    (synopsis "Async executor")
    (description "This library provides async executors.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-fs-2
  (package
    (name "rust-async-fs")
    (version "2.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-fs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0jp0p7lg9zqy2djgdmivbzx0yqmfn9sm2s9dkhaws3zlharhkkgb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-async-lock" ,rust-async-lock-3)
                       ("rust-blocking" ,rust-blocking-1)
                       ("rust-futures-lite" ,rust-futures-lite-2))
       #:cargo-development-inputs (("rust-libc" ,rust-libc-0.2)
                                   ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/smol-rs/async-fs")
    (synopsis "Async filesystem primitives")
    (description "This package provides async filesystem primitives.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-fs-1
  (package
    (inherit rust-async-fs-2)
    (name "rust-async-fs")
    (version "1.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-fs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "01if2h77mry9cnm91ql2md595108i2c1bfy9gaivzvjfcl2gk717"))))
    (arguments
     `(#:cargo-inputs (("rust-async-lock" ,rust-async-lock-2)
                       ("rust-autocfg" ,rust-autocfg-1)
                       ("rust-blocking" ,rust-blocking-1)
                       ("rust-futures-lite" ,rust-futures-lite-1))
       #:cargo-development-inputs (("rust-libc" ,rust-libc-0.2)
                                   ("rust-winapi" ,rust-winapi-0.3))))))

(define-public rust-async-generic-1
  (package
    (name "rust-async-generic")
    (version "1.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-generic" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0wqnsinxaw6cj6wfbrj96qfrbc1gfgsm95qm6cw8gypfcs2p5wyx"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-syn" ,rust-syn-2))
       #:cargo-development-inputs (("rust-async-std" ,rust-async-std-1)
                                   ("rust-async-trait" ,rust-async-trait-0.1))))
    (home-page "https://github.com/scouten/async-generic")
    (synopsis "Code that can be both async and synchronous without duplicating it")
    (description
     "This package provides a way to write code that can be both async and
synchronous without duplicating it.")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-global-executor-2
  (package
    (name "rust-async-global-executor")
    (version "2.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-global-executor" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1762s45cc134d38rrv0hyp41hv4iv6nmx59vswid2p0il8rvdc85"))))
    (build-system cargo-build-system)
    (arguments
     (list #:cargo-inputs (list rust-async-channel-2
                                rust-async-executor-1
                                rust-async-io-2
                                rust-async-lock-3
                                rust-blocking-1
                                rust-futures-lite-2
                                rust-once-cell-1
                                rust-tokio-1
                                rust-tokio-0.2
                                rust-tokio-0.3)
           #:cargo-development-inputs (list rust-doc-comment-0.3)))
    (home-page "https://github.com/async-rs/async-global-executor")
    (synopsis "Global executor built on top of @code{async-executor} and
@code{async-io}")
    (description
     "This package provides a global executor built on top of
@code{async-executor} and @code{async-io}.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-io-2
  (package
    (name "rust-async-io")
    (version "2.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-io" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0n8h0vy53n4vdkq529scqnkzm9vcl3r73za9nj81s2nfrhiv78j3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-async-lock" ,rust-async-lock-3)
                       ("rust-cfg-if" ,rust-cfg-if-1)
                       ("rust-concurrent-queue" ,rust-concurrent-queue-2)
                       ("rust-futures-io" ,rust-futures-io-0.3)
                       ("rust-futures-lite" ,rust-futures-lite-2)
                       ("rust-parking" ,rust-parking-2)
                       ("rust-polling" ,rust-polling-3)
                       ("rust-rustix" ,rust-rustix-0.38)
                       ("rust-slab" ,rust-slab-0.4)
                       ("rust-tracing" ,rust-tracing-0.1)
                       ("rust-windows-sys" ,rust-windows-sys-0.59))
       #:cargo-development-inputs (("rust-async-channel" ,rust-async-channel-2)
                                   ("rust-async-net" ,rust-async-net-2)
                                   ("rust-blocking" ,rust-blocking-1)
                                   ("rust-criterion" ,rust-criterion-0.4)
                                   ("rust-getrandom" ,rust-getrandom-0.2)
                                   ("rust-inotify" ,rust-inotify-0.11)
                                   ("rust-signal-hook" ,rust-signal-hook-0.3)
                                   ("rust-tempfile" ,rust-tempfile-3)
                                   ("rust-timerfd" ,rust-timerfd-1)
                                   ("rust-uds-windows" ,rust-uds-windows-1))))
    (home-page "https://github.com/smol-rs/async-io")
    (synopsis "Async I/O and timers")
    (description
     "This crate provides two tools: Async, an adapter for standard
networking types (and many other types) to use in async programs, and
Timer, a future that expires at a point in time.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-io-1
  (package
    (inherit rust-async-io-2)
    (name "rust-async-io")
    (version "1.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-io" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1byj7lpw0ahk6k63sbc9859v68f28hpaab41dxsjj1ggjdfv9i8g"))))
    (arguments
     `(#:cargo-inputs
       (("rust-async-lock" ,rust-async-lock-2)
        ("rust-autocfg" ,rust-autocfg-1)
        ("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-concurrent-queue" ,rust-concurrent-queue-2)
        ("rust-futures-lite" ,rust-futures-lite-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-parking" ,rust-parking-2)
        ("rust-polling" ,rust-polling-2)
        ("rust-rustix" ,rust-rustix-0.37)
        ("rust-slab" ,rust-slab-0.4)
        ("rust-socket2" ,rust-socket2-0.4)
        ("rust-waker-fn" ,rust-waker-fn-1))
       #:cargo-development-inputs
       (("rust-async-channel" ,rust-async-channel-1)
        ("rust-async-net" ,rust-async-net-1)
        ("rust-blocking" ,rust-blocking-1)
        ("rust-criterion" ,rust-criterion-0.4)
        ("rust-getrandom" ,rust-getrandom-0.2)
        ("rust-inotify" ,rust-inotify-0.10)
        ("rust-signal-hook" ,rust-signal-hook-0.3)
        ("rust-tempfile" ,rust-tempfile-3)
        ("rust-timerfd" ,rust-timerfd-1)
        ("rust-uds-windows" ,rust-uds-windows-1))))))

(define-public rust-async-lock-3
  (package
    (name "rust-async-lock")
    (version "3.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-lock" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "060vh45i809wcqyxzs5g69nqiqah7ydz0hpkcjys9258vqn4fvpz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-event-listener" ,rust-event-listener-5)
        ("rust-event-listener-strategy" ,rust-event-listener-strategy-0.5)
        ("rust-loom" ,rust-loom-0.7)
        ("rust-pin-project-lite" ,rust-pin-project-lite-0.2))
       #:cargo-development-inputs
       (("rust-fastrand" ,rust-fastrand-2)
        ("rust-flume" ,rust-flume-0.11)
        ("rust-futures-lite" ,rust-futures-lite-2)
        ("rust-waker-fn" ,rust-waker-fn-1)
        ("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.3))))
    (home-page "https://github.com/smol-rs/async-lock")
    (synopsis "Async synchronization primitives")
    (description "This package provides async synchronization primitives.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-lock-2
  (package
    (inherit rust-async-lock-3)
    (name "rust-async-lock")
    (version "2.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-lock" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0asq5xdzgp3d5m82y5rg7a0k9q0g95jy6mgc7ivl334x7qlp4wi8"))))
    (arguments
     `(#:cargo-inputs
       (("rust-event-listener" ,rust-event-listener-2))
       #:cargo-development-inputs
       (("rust-async-channel" ,rust-async-channel-1)
        ("rust-fastrand" ,rust-fastrand-2)
        ("rust-futures-lite" ,rust-futures-lite-1)
        ("rust-waker-fn" ,rust-waker-fn-1)
        ("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.3))))))

(define-public rust-async-log-1
  (package
    (name "rust-async-log")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-log" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "16ymra7f8169br9ss9m9n4l6rjcav9ns6r9mv4nr4r9i9wq37fpm"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-async-log-attributes" ,rust-async-log-attributes-1)
        ("rust-backtrace" ,rust-backtrace-0.3)
        ("rust-log" ,rust-log-0.4))))
    (home-page "https://github.com/async-rs/async-log")
    (synopsis "Async tracing capabilities for the @code{log} crate")
    (description
     "This crate provides extension types and hooks to @code{log} to enable
asynchronous logging.")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-log-attributes-1
  (package
    (name "rust-async-log-attributes")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-log-attributes" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0b9nysb5yxf772cinl5rsyhl2zazj2qfhbckv1kjz9qr3gkgi5ys"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-syn" ,rust-syn-0.15))))
    (home-page "https://github.com/rustasync/runtime")
    (synopsis
     "Proc Macro attributes for the async-log crate")
    (description
     "This package provides proc macro attributes for the @code{async-log}
crate.")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-macros-1
  (package
    (name "rust-async-macros")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-macros" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1fib4wxiym9f045xqb8a2gyfa8yym3hb62g4jqjfmzn14jdxa8g4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #false
       #:cargo-inputs
       (("rust-futures-core-preview" ,rust-futures-core-preview-0.3)
        ("rust-pin-utils" ,rust-pin-utils-0.1))
       #:cargo-development-inputs
       (("rust-futures-preview" ,rust-futures-preview-0.3))))
    (home-page "https://github.com/async-rs/async-macros")
    (synopsis "Macros for async-std")
    (description "Macros for async-std.")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-net-2
  (package
    (name "rust-async-net")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-net" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1xyc5a5vcp3a7h1q2lbfh79wz8136dig4q4x6g4w2ws8ml7h0j5r"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-async-io" ,rust-async-io-2)
                       ("rust-blocking" ,rust-blocking-1)
                       ("rust-futures-lite" ,rust-futures-lite-2))))
    (home-page "https://github.com/smol-rs/async-net")
    (synopsis "Async networking primitives for TCP/UDP/Unix communication")
    (description "This package provides async networking primitives for
TCP/UDP/Unix communication.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-net-1
  (package
    (inherit rust-async-net-2)
    (name "rust-async-net")
    (version "1.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-net" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0by1m21ciwq6kvd8jplb0mqr9yh17zil1icakdvga76f33nv2d04"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-async-io" ,rust-async-io-1)
        ("rust-blocking" ,rust-blocking-1)
        ("rust-futures-lite" ,rust-futures-lite-1))))))

(define-public rust-async-object-pool-0.1
  (package
    (name "rust-async-object-pool")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-object-pool" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0b3546r13bdhcigbfbmpihh8gxxpad165cp80h3dbwn3jxmlag1k"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-async-std" ,rust-async-std-1))))
    (home-page "https://github.com/alexliesenfeld/async-object-pool")
    (synopsis
     "Object pool implementation that using asynchronous synchronization primitives")
    (description
     "This package provides a simple object pool implementation that uses only
asynchronous synchronization primitives.")
    (license license:expat)))

(define-public rust-async-once-cell-0.5
  (package
    (name "rust-async-once-cell")
    (version "0.5.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-once-cell" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0np3zj2yvk20ha4rk7sf8s0rngywhcykl1zgyb36flkq4qvzi222"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-critical-section" ,rust-critical-section-1))))
    (home-page "https://github.com/danieldg/async-once-cell")
    (synopsis "Async single assignment cells and lazy values")
    (description "This package provides async single assignment cells
and lazy values.")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-pidfd-0.1
  (package
    (name "rust-async-pidfd")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-pidfd" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "168pylpf7n898szw32sva7kf9h3x1mnip54mfr8f7f4v55c705qj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; Not all files included.
       #:cargo-inputs (("rust-async-io" ,rust-async-io-1)
                       ("rust-libc" ,rust-libc-0.2))
       #:cargo-development-inputs
       (("rust-futures-lite" ,rust-futures-lite-1))))
    (home-page "https://github.com/joshtriplett/async-pidfd")
    (synopsis "Process file descriptors (pidfd) for Linux")
    (description
      "@code{async-pidfd} provides Rust support for pidfd, and supports
managing processes both synchronously (via the PidFd type) and
asynchronously (via the AsyncPidFd type).")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-priority-channel-0.1
  (package
    (name "rust-async-priority-channel")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-priority-channel" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0h36m0avgs86pgh286xkvbnhdhb8bxgsnlxwwazvw88v5scph5n2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-event-listener" ,rust-event-listener-2))
       #:cargo-development-inputs (("rust-futures-lite" ,rust-futures-lite-1)
                                   ("rust-tokio" ,rust-tokio-1))))
    (home-page "https://github.com/rmcgibbo/async-priority-channel")
    (synopsis "Async channel with message delivery by priority")
    (description
     "This package provides an async channel where pending messages are
delivered in order of priority.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-process-2
  (package
    (name "rust-async-process")
    (version "2.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-process" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1fr6cpqdw7hrmzns1983lgx86cg8vyz7nlrn0h0125iqq8fmy9b3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags
       '("--release" "--"
         "--skip=set_current_dir_works" ; assertion failed: p.is_ok()
         ;; No such file or directory
         "--skip=signal_reported_right"
         "--skip=stdin_works"
         "--skip=test_spawn_multiple_with_stdio")
       #:cargo-inputs (("rust-async-channel" ,rust-async-channel-2)
                       ("rust-async-io" ,rust-async-io-2)
                       ("rust-async-lock" ,rust-async-lock-3)
                       ("rust-async-signal" ,rust-async-signal-0.2)
                       ("rust-async-task" ,rust-async-task-4)
                       ("rust-blocking" ,rust-blocking-1)
                       ("rust-cfg-if" ,rust-cfg-if-1)
                       ("rust-event-listener" ,rust-event-listener-5)
                       ("rust-futures-lite" ,rust-futures-lite-2)
                       ("rust-rustix" ,rust-rustix-0.38)
                       ("rust-tracing" ,rust-tracing-0.1))
       #:cargo-development-inputs (("rust-async-io" ,rust-async-io-1))))
    (home-page "https://github.com/smol-rs/async-process")
    (synopsis "Async interface for working with processes")
    (description
     "This crate is an async version of @code{std::process}.  A background
thread named @code{async-process} is lazily created on first use, which waits
for spawned child processes to exit and then calls the @code{wait()} syscall
to clean up the ``zombie'' processes.

This is unlike the process API in the standard library, where dropping
a running Child leaks its resources.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-process-1
  (package
    (inherit rust-async-process-2)
    (name "rust-async-process")
    (version "1.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-process" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "126s968lvhg9rlwsnxp7wfzkfn7rl87p0dlvqqlibn081ax3hr7a"))))
    (arguments
     `(#:cargo-test-flags
       '("--release" "--"
         "--skip=set_current_dir_works" ; assertion failed: p.is_ok()
         ;; No such file or directory
         "--skip=signal_reported_right"
         "--skip=stdin_works"
         "--skip=test_spawn_multiple_with_stdio")
       #:cargo-inputs (("rust-async-io" ,rust-async-io-1)
                       ("rust-async-lock" ,rust-async-lock-2)
                       ("rust-async-signal" ,rust-async-signal-0.2)
                       ("rust-blocking" ,rust-blocking-1)
                       ("rust-cfg-if" ,rust-cfg-if-1)
                       ("rust-event-listener" ,rust-event-listener-3)
                       ("rust-futures-lite" ,rust-futures-lite-1)
                       ("rust-rustix" ,rust-rustix-0.38)
                       ("rust-windows-sys" ,rust-windows-sys-0.48))
       #:cargo-development-inputs (("rust-async-io" ,rust-async-io-1))))))

(define-public rust-async-ready-3
  (package
    (name "rust-async-ready")
    (version "3.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-ready" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "09xw34q0k48r1bvs3s1l2a1mglz98l7zjbkdcy861k8zsyfwfw4l"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/rustasync/async-ready")
    (synopsis "Async readiness traits")
    (description
     "This package provides Async readiness traits.  Those can be useful when
implementing async state machines that can later be wrapped in dedicated
futures.")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-recursion-1
  (package
    (name "rust-async-recursion")
    (version "1.1.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "async-recursion" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "04ac4zh8qz2xjc79lmfi4jlqj5f92xjvfaqvbzwkizyqd4pl4hrv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; TODO: Tests unexpectedly pass.
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-2))
       #:cargo-development-inputs
       (("rust-futures-executor" ,rust-futures-executor-0.3)
        ("rust-macrotest" ,rust-macrotest-1)
        ("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://github.com/dcchut/async-recursion")
    (synopsis "Recursion for async functions")
    (description "This package provides recursion for async functions in Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-session-3
  (package
    (name "rust-async-session")
    (version "3.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-session" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0c76vazdlcs2rsxq8gd8a6wnb913vxhnfx1hyfmfpqml4gjlrnh7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-anyhow" ,rust-anyhow-1)
                       ("rust-async-lock" ,rust-async-lock-2)
                       ("rust-async-trait" ,rust-async-trait-0.1)
                       ("rust-base64" ,rust-base64-0.13)
                       ("rust-bincode" ,rust-bincode-1)
                       ("rust-blake3" ,rust-blake3-0.3)
                       ("rust-chrono" ,rust-chrono-0.4)
                       ("rust-hmac" ,rust-hmac-0.11)
                       ("rust-log" ,rust-log-0.4)
                       ("rust-rand" ,rust-rand-0.8)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-serde-json" ,rust-serde-json-1)
                       ("rust-sha2" ,rust-sha2-0.9))
       #:cargo-development-inputs (("rust-async-std" ,rust-async-std-1))))
    (home-page "https://github.com/http-rs/async-session")
    (synopsis "Async session support with pluggable middleware")
    (description "Async session support with pluggable middleware.")
    (license (list license:expat license:asl2.0))))

(define-public rust-async-signal-0.2
  (package
    (name "rust-async-signal")
    (version "0.2.10")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-signal" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1wxrq3871l00mil43nmh0akvwjjjnv0bn7n2pzwbvh00k0s00zk3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-async-io" ,rust-async-io-2)
        ("rust-async-lock" ,rust-async-lock-3)
        ("rust-atomic-waker" ,rust-atomic-waker-1)
        ("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-io" ,rust-futures-io-0.3)
        ("rust-rustix" ,rust-rustix-0.38)
        ("rust-signal-hook-registry" ,rust-signal-hook-registry-1)
        ("rust-slab" ,rust-slab-0.4)
        ("rust-windows-sys" ,rust-windows-sys-0.59))
       #:cargo-development-inputs
       (("rust-async-io" ,rust-async-io-2)
        ("rust-fastrand" ,rust-fastrand-2)
        ("rust-futures-lite" ,rust-futures-lite-2)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-signal-hook" ,rust-signal-hook-0.3))))
    (home-page "https://github.com/smol-rs/async-signal")
    (synopsis "Async signal handling")
    (description "This package provides async signal handling.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-std-1
  (package
    (name "rust-async-std")
    (version "1.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-std" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "059nbiyijwbndyrz0050skvlvzhds0dmnl0biwmxwbw055glfd66"))))
    (build-system cargo-build-system)
    (arguments
     (list #:cargo-test-flags
           `(list "--" "--skip=io_timeout_timedout")
           #:cargo-inputs
           `(("rust-async-attributes" ,rust-async-attributes-1)
             ("rust-async-channel" ,rust-async-channel-1)
             ("rust-async-global-executor" ,rust-async-global-executor-2)
             ("rust-async-io" ,rust-async-io-2)
             ("rust-async-lock" ,rust-async-lock-3)
             ("rust-async-process" ,rust-async-process-2)
             ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.8)
             ("rust-futures-channel" ,rust-futures-channel-0.3)
             ("rust-futures-core" ,rust-futures-core-0.3)
             ("rust-futures-io" ,rust-futures-io-0.3)
             ("rust-futures-lite" ,rust-futures-lite-2)
             ("rust-gloo-timers" ,rust-gloo-timers-0.3)
             ("rust-kv-log-macro" ,rust-kv-log-macro-1)
             ("rust-log" ,rust-log-0.4)
             ("rust-memchr" ,rust-memchr-2)
             ("rust-once-cell" ,rust-once-cell-1)
             ("rust-pin-project-lite" ,rust-pin-project-lite-0.2)
             ("rust-pin-utils" ,rust-pin-utils-0.1)
             ("rust-slab" ,rust-slab-0.4)
             ("rust-surf" ,rust-surf-2)
             ("rust-wasm-bindgen-futures" ,rust-wasm-bindgen-futures-0.4))
           #:cargo-development-inputs
           `(("rust-femme" ,rust-femme-2)
             ("rust-futures" ,rust-futures-0.3)
             ("rust-getrandom" ,rust-getrandom-0.2)
             ("rust-rand" ,rust-rand-0.8)
             ("rust-rand-xorshift" ,rust-rand-xorshift-0.3)
             ("rust-tempfile" ,rust-tempfile-3)
             ("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.3))))
    (home-page "https://async.rs")
    (synopsis "Async version of the Rust standard library")
    (description
     "This crate provides an async version of @code{std}.  It provides all the
interfaces you are used to, but in an async version and ready for Rust's
@code{async/await} syntax.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-std-0.99
  (package
    (inherit rust-async-std-1)
    (name "rust-async-std")
    (version "0.99.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-std" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1k34181r1xzalyf7alka0ibnbqll6s5l435ycydm7fv1g6gill24"))))
    (arguments
     `(#:cargo-test-flags '("--"
                            "--skip=io_timeout_timedout"
                            "--skip=src/stream/mod.rs - stream (line 36)")
       #:cargo-inputs
       (("rust-async-attributes" ,rust-async-attributes-1)
        ("rust-async-macros" ,rust-async-macros-1)
        ("rust-async-task" ,rust-async-task-1)
        ("rust-broadcaster" ,rust-broadcaster-0.2)
        ("rust-crossbeam-channel" ,rust-crossbeam-channel-0.3)
        ("rust-crossbeam-deque" ,rust-crossbeam-deque-0.7)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.6)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-io" ,rust-futures-io-0.3)
        ("rust-futures-timer" ,rust-futures-timer-1)
        ("rust-kv-log-macro" ,rust-kv-log-macro-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-mio" ,rust-mio-0.6)
        ("rust-mio-uds" ,rust-mio-uds-0.6)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-pin-project-lite" ,rust-pin-project-lite-0.1)
        ("rust-pin-utils" ,rust-pin-utils-0.1)
        ("rust-slab" ,rust-slab-0.4))
       #:cargo-development-inputs
       (("rust-femme" ,rust-femme-1)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-tempdir" ,rust-tempdir-0.3))))))

(define-public rust-async-stream-0.3
  (package
    (name "rust-async-stream")
    (version "0.3.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-stream" version))
       (file-name (string-append name "-" version ".tar.gz"))
       ;; I have no idea why tokio-test is missing, I filed:
       ;;   https://github.com/tokio-rs/async-stream/issues/102
       (modules '((guix build utils)))
       (snippet
        '(substitute* "Cargo.toml"
           (("^\\[dev-dependencies.trybuild]")
            "[dev-dependencies.tokio-test]
version = \"0.4\"

[dev-dependencies.trybuild]")))
       (sha256
        (base32 "0xl4zqncrdmw2g6241wgr11dxdg4h7byy6bz3l6si03qyfk72nhb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags '("--" "--skip=test")
       #:cargo-inputs
       (("rust-async-stream-impl" ,rust-async-stream-impl-0.3)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-pin-project-lite" ,rust-pin-project-lite-0.2))
       #:cargo-development-inputs
       (("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-rustversion" ,rust-rustversion-1)
        ("rust-tokio" ,rust-tokio-1)
        ("rust-tokio-test" ,rust-tokio-test-0.4)
        ("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://github.com/tokio-rs/async-stream")
    (synopsis "Asynchronous streams using async & await notation")
    (description
     "This package provides asynchronous streams using async & await
notation.")
    (license license:expat)))

(define-public rust-async-stream-impl-0.3
  (package
    (name "rust-async-stream-impl")
    (version "0.3.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-stream-impl" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0kaplfb5axsvf1gfs2gk6c4zx6zcsns0yf3ssk7iwni7bphlvhn7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-2))
       #:cargo-development-inputs
       (("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-tokio" ,rust-tokio-1))))
    (home-page "https://github.com/tokio-rs/async-stream")
    (synopsis "Proc macros for async-stream crate")
    (description
     "This package provides proc macros for @code{rust-async-stream}
crate.")
    (license license:expat)))

(define-public rust-async-task-4
  (package
    (name "rust-async-task")
    (version "4.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-task" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1pp3avr4ri2nbh7s6y9ws0397nkx1zymmcr14sq761ljarh3axcb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-portable-atomic" ,rust-portable-atomic-1))
       #:cargo-development-inputs
       (("rust-atomic-waker" ,rust-atomic-waker-1)
        ("rust-easy-parallel" ,rust-easy-parallel-3)
        ("rust-flaky-test" ,rust-flaky-test-0.2)
        ("rust-flume" ,rust-flume-0.11)
        ("rust-futures-lite" ,rust-futures-lite-2)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-pin-project-lite" ,rust-pin-project-lite-0.2)
        ("rust-smol" ,rust-smol-2))))
    (home-page "https://github.com/stjepang/async-task")
    (synopsis "Task abstraction for building executors")
    (description
     "This package provides a task abstraction for building executors.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-async-task-3
  (package
    (inherit rust-async-task-4)
    (name "rust-async-task")
    (version "3.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-task" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1lrm7cm9dpashmkbqa8mvglbf85gadviqil7qnnrm0pjdqap4xy1"))))
    (arguments
     `(#:cargo-development-inputs
       (("rust-crossbeam" ,rust-crossbeam-0.7)
        ("rust-futures" ,rust-futures-0.3))))))

(define-public rust-async-task-1
  (package
    (inherit rust-async-task-4)
    (name "rust-async-task")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-task" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0p88087z43zvv924my16a17qd65kdlv1r59h80h73rvrn0bc1hha"))))
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs
       (("rust-crossbeam" ,rust-crossbeam-0.7)
        ("rust-futures" ,rust-futures-0.3))))))

(define-public rust-async-trait-0.1
  (package
    (name "rust-async-trait")
    (version "0.1.83")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "async-trait" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1p8q8gm4fv2fdka8hwy2w3f8df7p5inixqi7rlmbnky3wmysw73j"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-2))
       #:cargo-development-inputs
       (("rust-futures" ,rust-futures-0.3)
        ("rust-rustversion" ,rust-rustversion-1)
        ("rust-tracing" ,rust-tracing-0.1)
        ("rust-tracing-attributes" ,rust-tracing-attributes-0.1)
        ("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://github.com/dtolnay/async-trait")
    (synopsis "Type erasure for async trait methods")
    (description "This package provides type erasure for async trait
methods.")
    (license (list license:expat license:asl2.0))))

(define-public rust-atoi-2
  (package
    (name "rust-atoi")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "atoi" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0a05h42fggmy7h0ajjv6m7z72l924i7igbx13hk9d8pyign9k3gj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-num-traits" ,rust-num-traits-0.2))
       #:cargo-development-inputs (("rust-criterion" ,rust-criterion-0.4))))
    (home-page "https://github.com/pacman82/atoi-rs")
    (synopsis "Parse integers directly from `[u8]` slices in safe code")
    (description "Parse integers directly from `[u8]` slices in safe code.")
    (license license:expat)))

(define-public rust-atoi-1
  (package
    (inherit rust-atoi-2)
    (name "rust-atoi")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "atoi" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "13mycnr954w17lcvvbpzr4rmhl1h13cg8hq63j0rrx9g6497vifp"))))
    (arguments
     `(#:cargo-inputs (("rust-num-traits" ,rust-num-traits-0.2))
       #:cargo-development-inputs (("rust-criterion" ,rust-criterion-0.3))))))

(define-public rust-atoi-simd-0.15
  (package
    (name "rust-atoi-simd")
    (version "0.15.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "atoi_simd" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1a98kvaqyhb1shi2c6qhvklahc7ckvpmibcy319i6g1i9xqkgq4s"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs (("rust-arrayvec" ,rust-arrayvec-0.7)
                                   ("rust-numtoa" ,rust-numtoa-0.2))))
    (home-page "https://github.com/RoDmitry/atoi_simd")
    (synopsis "Fast @code{&[u8]} to integer parser")
    (description "This package provides a fast @code{&[u8]} to integer parser.")
    (license (list license:expat license:asl2.0))))

(define-public rust-atom-0.3
  (package
    (name "rust-atom")
    (version "0.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "atom" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1qig9fcdqf07mzzpkicm5wgxv0zpr28njdsqf708wxq27yf6k1iw"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/slide-rs/atom")
    (synopsis "Safe abstraction around AtomicPtr")
    (description "This package provides a safe abstraction around AtomicPtr.")
    (license license:asl2.0)))

(define-public rust-atomic-0.6
  (package
    (name "rust-atomic")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "atomic" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "15193mfhmrq3p6vi1a10hw3n6kvzf5h32zikhby3mdj0ww1q10cd"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-bytemuck" ,rust-bytemuck-1))
       #:cargo-development-inputs (("rust-bytemuck" ,rust-bytemuck-1))))
    (home-page "https://github.com/Amanieu/atomic-rs")
    (synopsis "Generic @code{Atomic<T>} wrapper type")
    (description
     "This package provides a generic @code{Atomic<T>} type for all
@code{T: Copy} types, unlike the standard library which only provides a few
fixed atomic types.")
    ;; The user can choose either license.
    (license (list license:asl2.0 license:expat))))

(define-public rust-atomic-0.5
  (package
    (inherit rust-atomic-0.6)
    (name "rust-atomic")
    (version "0.5.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "atomic" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0k135q1qfmxxyzrlhr47r0j38r5fnd4163rgl552qxyagrk853dq"))))
    (arguments
     `(#:cargo-inputs (("rust-autocfg" ,rust-autocfg-1))))))

(define-public rust-atomic-polyfill-1
  (package
    (name "rust-atomic-polyfill")
    (version "1.0.3")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "atomic-polyfill" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1x00ndablb89zvbr8m03cgjzgajg86fqn8pgz85yy2gy1pivrwlc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-critical-section" ,rust-critical-section-1))))
    (home-page "https://github.com/embassy-rs/atomic-polyfill")
    (synopsis "Atomic polyfills, for targets where they're not available")
    (description "This package provides atomic polyfills, for targets where
they're not available.")
    (license (list license:expat license:asl2.0))))

(define-public rust-atomic-refcell-0.1
  (package
    (name "rust-atomic-refcell")
    (version "0.1.13")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "atomic_refcell" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0z04ng59y22mwf315wamx78ybhjag0x6k7isc36hdgcv63c7rrj1"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs (("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/bholley/atomic_refcell")
    (synopsis "Threadsafe RefCell")
    (description "This package provides Threadsafe @code{RefCell}.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-atomic-take-1
  (package
    (name "rust-atomic-take")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "atomic-take" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1hzvfqiy0ixsawkh7ci9visn95kx2j6yvnqxz536x5wpzranpax8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs (("rust-tokio" ,rust-tokio-1))))
    (home-page "https://github.com/Darksonn/atomic-take")
    (synopsis "Atomically take a value out of a container once")
    (description "Atomically take a value out of a container once.")
    (license license:expat)))

(define-public rust-atomic-waker-1
  (package
    (name "rust-atomic-waker")
    (version "1.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "atomic-waker" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1h5av1lw56m0jf0fd3bchxq8a30xv0b4wv8s4zkp4s0i7mfvs18m"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-portable-atomic" ,rust-portable-atomic-1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.4)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-rayon" ,rust-rayon-1))))
    (home-page "https://github.com/smol-rs/atomic-waker")
    (synopsis "Synchronization primitive for task wakeup")
    (description
     "This package provides a synchronization primitive for task wakeup.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-atomic-write-file-0.1
  (package
    (name "rust-atomic-write-file")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "atomic-write-file" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0dl4x0srdwjxm3zz3fj1c7m44i3b7mjiad550fqklj1n4bfbxkgd"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-nix" ,rust-nix-0.27)
                       ("rust-rand" ,rust-rand-0.8))))
    (home-page "https://github.com/andreacorbellini/rust-atomic-write-file")
    (synopsis "Write files atomically to a file system")
    (description "Write files atomically to a file system.")
    (license license:bsd-3)))

(define-public rust-atomig-0.4
  (package
    (name "rust-atomig")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "atomig" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "08f8mhww13dskj55rw37h9d2bwghqxvp7q70mg826y8zn4bjmbqf"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-atomig-macro" ,rust-atomig-macro-0.3)
                       ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs (("rust-bincode" ,rust-bincode-1))))
    (home-page "https://github.com/LukasKalbertodt/atomig/")
    (synopsis
     "Generic and lock-free `std` atomics via `Atomic<T>`")
    (description
     "This package provides Generic, convenient and lock-free `std` atomics via
@code{Atomic<T>}.  Can be used with many primitive types (including floats) and
with custom types.")
    (license (list license:expat license:asl2.0))))

(define-public rust-atomig-macro-0.3
  (package
    (name "rust-atomig-macro")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "atomig-macro" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0hvgrip2nqqlgpfz8p9zrs6iyrv8nyz0c5bgvm5mxim4ik4wh44s"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/LukasKalbertodt/atomig/")
    (synopsis "Helper crate for `atomig`")
    (description "This package provides Helper crate for `atomig`.")
    (license (list license:expat license:asl2.0))))

(define-public rust-atty-0.2
  (package
    (name "rust-atty")
    (version "0.2.14")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "atty" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1s7yslcs6a28c5vz7jwj63lkfgyx8mx99fdirlhi9lbhhzhrpcyr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f ;; tests expect a tty
       #:cargo-inputs
       (("rust-hermit-abi" ,rust-hermit-abi-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/softprops/atty")
    (synopsis "Simple interface for querying atty")
    (description
     "This package provides a simple interface for querying atty.")
    (license license:expat)))

(define-public rust-auto-enums-0.8
  (package
    (name "rust-auto-enums")
    (version "0.8.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "auto_enums" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1yxcdw961199wrk1v5js321ynyfd4m40c0gi2pypby2mx2vpg6s5"))
       (modules '((guix build utils)))
       (snippet '(begin
                   (substitute* "Cargo.toml"
                     (("\\[features\\]" all)
                      (string-append "[dev-dependencies]" "\n"
                                     "macrotest = \"1\"" "\n"
                                     "trybuild = \"1\"" "\n"
                                     "\n" all)))))))
    (build-system cargo-build-system)
    (arguments
     (list
      #:cargo-inputs `(("rust-derive-utils" ,rust-derive-utils-0.14)
                       ("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-syn" ,rust-syn-2))
      #:cargo-development-inputs `(("rust-futures" ,rust-futures-0.1)
                                   ("rust-futures-util" ,rust-futures-util-0.3)
                                   ("rust-http-body" ,rust-http-body-1)
                                   ("rust-macrotest" ,rust-macrotest-1)
                                   ("rust-rayon" ,rust-rayon-1)
                                   ("rust-rustversion" ,rust-rustversion-1)
                                   ("rust-serde" ,rust-serde-1)
                                   ("rust-tokio" ,rust-tokio-1)
                                   ("rust-tokio" ,rust-tokio-0.1)
                                   ("rust-tokio" ,rust-tokio-0.2)
                                   ("rust-tokio" ,rust-tokio-0.3)
                                   ("rust-trybuild" ,rust-trybuild-1))
      #:cargo-test-flags '(list "--release" "--"
                                ;; Skipping broken tests
                                "--skip=src/lib.rs - (line 547)"
                                "--skip=src/lib.rs - (line 672)"
                                "--skip=src/lib.rs - (line 755)"
                                "--skip=src/lib.rs - (line 818)"
                                "--skip=src/lib.rs - _README (line 1073)")
      #:phases #~(modify-phases %standard-phases
                   ;; Tests depend on nightly/dev features
                   (add-before 'check 'enable-unstable-features
                     (lambda _
                       (setenv "RUSTC_BOOTSTRAP" "1"))))))
    (home-page "https://github.com/taiki-e/auto_enums")
    (synopsis
     "Library to allow multiple return types by automatically generated enum")
    (description
     "This package provides a library to allow multiple return types by
automatically generated enum.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-auto-impl-0.5
  (package
    (name "rust-auto-impl")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "auto_impl" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "195d6s9bfcchwizf3km1g69l74f6xvm5gl9505js2r9xi4ff4qkq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags
       (list "--release" "--"
             "--skip=ui_compile_fail")
       #:cargo-inputs
       (("rust-proc-macro-error" ,rust-proc-macro-error-1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://github.com/auto-impl-rs/auto_impl/")
    (synopsis
     "Automatically implement traits for common smart pointers and closures")
    (description
     "Automatically implement traits for common smart pointers and closures.")
    (license (list license:expat license:asl2.0))))

(define-public rust-auto-impl-0.4
  (package
    (inherit rust-auto-impl-0.5)
    (name "rust-auto-impl")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "auto_impl" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0f0aildq7rl7imgl6x6xw8jg4m08xz9q1bpcrmf5xnhar23gbjs2"))))
    (arguments
     `(#:cargo-test-flags
       (list "--release" "--" "--skip=ui")
       #:cargo-inputs
       (("rust-proc-macro-error" ,rust-proc-macro-error-1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-rustversion" ,rust-rustversion-1)
        ("rust-trybuild" ,rust-trybuild-1))))))

(define-public rust-autocfg-1
  (package
    (name "rust-autocfg")
    (version "1.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "autocfg" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "09lz3by90d2hphbq56znag9v87gfpd9gb8nr82hll8z6x2nhprdc"))))
    (build-system cargo-build-system)
    (arguments
     (list #:cargo-test-flags '(list "--" "--skip=test_wrappers")))
    (home-page "https://github.com/cuviper/autocfg")
    (synopsis "Automatic configuration for Rust compiler features")
    (description
     "This package utomatically configures Rust compiler features.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-autocfg-0.1
  (package
    (inherit rust-autocfg-1)
    (name "rust-autocfg")
    (version "0.1.8")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "autocfg" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0y4vw4l4izdxq1v0rrhvmlbqvalrqrmk60v1z0dqlgnlbzkl7phd"))))
    (arguments `(#:cargo-inputs (("rust-autocfg" ,rust-autocfg-1))))))

(define-public rust-automod-1
  (package
    (name "rust-automod")
    (version "1.0.14")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "automod" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "12rsa5barxi8v916hlvvpjyh43y5x2yjc2bg1xs6v960vccyxwzd"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-2))))
    (home-page "https://github.com/dtolnay/automod")
    (synopsis "Pull in every source file in a directory as a module")
    (description "Pull in every source file in a directory as a module.")
    (license (list license:expat license:asl2.0))))

(define-public rust-av-metrics-0.9
  (package
    (name "rust-av-metrics")
    (version "0.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "av-metrics" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0c1m5rrrx88y1hm4i17qh0fd2rqd3jwck86lj5dkw85hpmdyjv4r"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-crossbeam" ,rust-crossbeam-0.8)
        ("rust-itertools" ,rust-itertools-0.10)
        ("rust-lab" ,rust-lab-0.11)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-thiserror" ,rust-thiserror-1)
        ("rust-v-frame" ,rust-v-frame-0.3))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.4)
        ("rust-y4m" ,rust-y4m-0.8))))
    (home-page "https://github.com/rust-av/av-metrics")
    (synopsis "Collection of algorithms for measuring audio/video metrics")
    (description
     "This package provides a collection of algorithms for measuring
audio/video metrics.")
    (license license:expat)))

(define-public rust-av1-grain-0.2
  (package
    (name "rust-av1-grain")
    (version "0.2.3")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "av1-grain" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32 "1gvqdh21bm1cfqiwyiinbqi0mg7x2lg2fwgmphma8ijxijfr0y36"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-anyhow" ,rust-anyhow-1)
        ("rust-arrayvec" ,rust-arrayvec-0.7)
        ("rust-log" ,rust-log-0.4)
        ("rust-nom" ,rust-nom-7)
        ("rust-num-rational" ,rust-num-rational-0.4)
        ("rust-serde" ,rust-serde-1)
        ("rust-v-frame" ,rust-v-frame-0.3))
       #:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-1)
        ("rust-quickcheck-macros" ,rust-quickcheck-macros-1))))
    (home-page "https://github.com/rust-av/av1-grain")
    (synopsis "Helpers for generating and parsing AV1 film grain data")
    (description "This package provides helpers for generating and parsing AV1
film grain data.")
    (license license:bsd-2)))

(define-public rust-average-0.13
  (package
    (name "rust-average")
    (version "0.13.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "average" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1c97m8yagvq8r6qgd3harm5vnkdbld4mxg9byyxh6igjsf8wfgl4"))
       (modules '((guix build utils)))
       (snippet
        '(begin
           (substitute* "Cargo.toml"
             ;; The resolver feature is not supported by our versions of Cargo.
             (("resolver = \"2\".*") "")
             ;; Relax version requirement for byteorder
             (("=1.3") "^1.3"))))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-easy-cast" ,rust-easy-cast-0.4)
        ("rust-float-ord" ,rust-float-ord-0.3)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-big-array" ,rust-serde-big-array-0.3)
        ("rust-serde-derive" ,rust-serde-derive-1))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-byteorder" ,rust-byteorder-1)
        ("rust-proptest" ,rust-proptest-1)
        ("rust-quantiles" ,rust-quantiles-0.7)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-rand-distr" ,rust-rand-distr-0.4)
        ("rust-rand-xoshiro" ,rust-rand-xoshiro-0.6)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-streaming-stats" ,rust-streaming-stats-0.2))))
    (home-page "https://github.com/vks/average")
    (synopsis "Calculate statistics iteratively")
    (description "This crate provides tools for calculating statistics
iteratively in Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-average-0.10
  (package
    (name "rust-average")
    (version "0.10.6")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "average" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1npcsgksxa8c03cam1zyxgaw9rsifwbzbflf4pjrq55b0a01cg1j"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-conv" ,rust-conv-0.3)
        ("rust-float-ord" ,rust-float-ord-0.2)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-big-array" ,rust-serde-big-array-0.3)
        ("rust-serde-derive" ,rust-serde-derive-1))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-proptest" ,rust-proptest-0.10)
        ("rust-quantiles" ,rust-quantiles-0.7)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-rand-distr" ,rust-rand-distr-0.3)
        ("rust-rand-xoshiro" ,rust-rand-xoshiro-0.4)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-streaming-stats" ,rust-streaming-stats-0.2))))
    (home-page "https://github.com/vks/average")
    (synopsis "Calculate statistics iteratively")
    (description "This crate provides for calculating statistics iteratively
in Rust.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-average-0.9
  (package
    (inherit rust-average-0.10)
    (name "rust-average")
    (version "0.9.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "average" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1f8ya00bv6qki9m7b4lb3bn845rj473mx02qpm7wgy5qc1yp75xs"))))
    (arguments
     `(#:cargo-inputs
       (("rust-conv" ,rust-conv-0.3)
        ("rust-float-ord" ,rust-float-ord-0.2)
        ("rust-num-integer" ,rust-num-integer-0.1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-big-array" ,rust-serde-big-array-0.1)
        ("rust-serde-derive" ,rust-serde-derive-1))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-quantiles" ,rust-quantiles-0.7)
        ("rust-rand" ,rust-rand-0.6)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-streaming-stats" ,rust-streaming-stats-0.2))))))

(define-public rust-avro-rs-0.13
  (package
    (name "rust-avro-rs")
    (version "0.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "avro-rs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0dsy8r4c6l4xx9wp80byrb24zvlf9m19f5nwpklis8hhczfm1rgc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1)
        ("rust-crc" ,rust-crc-1)
        ("rust-digest" ,rust-digest-0.9)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libflate" ,rust-libflate-1)
        ("rust-num-bigint" ,rust-num-bigint-0.2)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-snap" ,rust-snap-0.2)
        ("rust-strum" ,rust-strum-0.18)
        ("rust-strum-macros" ,rust-strum-macros-0.18)
        ("rust-thiserror" ,rust-thiserror-1)
        ("rust-typed-builder" ,rust-typed-builder-0.5)
        ("rust-uuid" ,rust-uuid-0.8)
        ("rust-zerocopy" ,rust-zerocopy-0.3))))
    (home-page "https://github.com/flavray/avro-rs")
    (synopsis "Library for working with Apache Avro in Rust")
    (description
     "This package is a library for working with Apache Avro in Rust.")
    (license license:expat)))

(define-public rust-avro-schema-0.3
  (package
    (name "rust-avro-schema")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "avro-schema" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1gbvciwvi2isa6qanbzi4lbqzzgvhdlzjyzlsa29dflsndaiha5m"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags
       '("--release" "--"
         "--skip=file::round_trip_deflate"
         "--skip=file::round_trip_snappy")
       #:cargo-inputs
       (("rust-async-stream" ,rust-async-stream-0.3)
        ("rust-crc" ,rust-crc-2)
        ("rust-fallible-streaming-iterator" ,rust-fallible-streaming-iterator-0.1)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-libflate" ,rust-libflate-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-snap" ,rust-snap-1))))
    (home-page "https://github.com/DataEngineeringLabs/avro-schema")
    (synopsis "Apache Avro specification")
    (description "This package contains the Apache Avro specification.")
    (license (list license:expat license:asl2.0))))

(define-public rust-az-1
  (package
    (name "rust-az")
    (version "1.2.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "az" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1i2s9bqar8hfxjmfr2cbhi4s26s2sd1kc3x3g517ygshyp8sawgp"))))
    (build-system cargo-build-system)
    (home-page "https://gitlab.com/tspiteri/az")
    (synopsis "Casts and checked casts")
    (description "This crate provides casts and checked casts.")
    (license (list license:expat license:asl2.0))))

(define-public rust-backoff-0.4
  (package
    (name "rust-backoff")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "backoff" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1h80d9xn5wngxdgza2m8w4x1kyhk0x6k9ydvsj50j2pcn6fdnbdn"))
       (modules '((guix build utils)))
       ;; XXX: Doctest hangs for no apparent reason.
       (snippet '(substitute* "src/lib.rs"
                              (("```rust\n")
                               "```rust,no_run\n")))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-async-std" ,rust-async-std-1)
                       ("rust-futures-core" ,rust-futures-core-0.3)
                       ("rust-getrandom" ,rust-getrandom-0.2)
                       ("rust-instant" ,rust-instant-0.1)
                       ("rust-pin-project-lite" ,rust-pin-project-lite-0.2)
                       ("rust-rand" ,rust-rand-0.8)
                       ("rust-tokio" ,rust-tokio-1))
       #:cargo-development-inputs
       (("rust-async-std" ,rust-async-std-1)
        ("rust-futures-executor" ,rust-futures-executor-0.3)
        ("rust-reqwest" ,rust-reqwest-0.11)
        ("rust-tokio" ,rust-tokio-1))))
    (native-inputs (list pkg-config))
    (inputs (list openssl))
    (home-page "https://github.com/ihrwein/backoff")
    (synopsis "Retry operations with exponential backoff policy")
    (description "Retry operations with exponential backoff policy.")
    (license (list license:expat license:asl2.0))))

(define-public rust-backon-0.4
  (package
    (name "rust-backon")
    (version "0.4.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "backon" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1w3bqipn0fc0dr9zgpk934ii6dz1m2c8wlrk6lfsgnk8z31q4xyn"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-fastrand" ,rust-fastrand-2)
                       ("rust-futures-core" ,rust-futures-core-0.3)
                       ("rust-pin-project" ,rust-pin-project-1)
                       ("rust-tokio" ,rust-tokio-1))
       #:cargo-development-inputs (("rust-anyhow" ,rust-anyhow-1)
                                   ("rust-reqwest" ,rust-reqwest-0.12)
                                   ("rust-tokio" ,rust-tokio-1))))
    (inputs (list openssl))
    (native-inputs (list pkg-config))
    (home-page "https://github.com/Xuanwo/backon")
    (synopsis "Retry with backoff without effort")
    (description "This package provides a retry with backoff without
effort.")
    (license license:asl2.0)))

(define-public rust-backtrace-0.3
  (package
    (name "rust-backtrace")
    (version "0.3.74")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "backtrace" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "06pfif7nwx66qf2zaanc2fcq7m64i91ki9imw9xd3bnz5hrwp0ld"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; Not all files included.
       #:cargo-inputs
       (("rust-addr2line" ,rust-addr2line-0.24)
        ("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-cpp-demangle" ,rust-cpp-demangle-0.4)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-miniz-oxide" ,rust-miniz-oxide-0.8)
        ("rust-object" ,rust-object-0.36)
        ("rust-rustc-demangle" ,rust-rustc-demangle-0.1)
        ("rust-serde" ,rust-serde-1)
        ("rust-windows-targets" ,rust-windows-targets-0.52))
       #:cargo-development-inputs
       (("rust-libloading" ,rust-libloading-0.7))))
    (home-page "https://github.com/rust-lang/backtrace-rs")
    (synopsis "Acquire a stack trace (backtrace) at runtime in a Rust program")
    (description
     "This package provides a library to acquire a stack
trace (backtrace) at runtime in a Rust program.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-backtrace-ext-0.2
  (package
    (name "rust-backtrace-ext")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "backtrace-ext" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0l4xacjnx4jrn9k14xbs2swks018mviq03sp7c1gn62apviywysk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-backtrace" ,rust-backtrace-0.3))
       #:cargo-development-inputs (("rust-miette" ,rust-miette-5)
                                   ("rust-thiserror" ,rust-thiserror-1))))
    (home-page "https://github.com/gankra/backtrace-ext")
    (synopsis "Conveniences on top of the backtrace crate")
    (description
     "This package provides minor conveniences on top of the backtrace crate.")
    (license (list license:expat license:asl2.0))))

(define-public rust-barrel-0.6
  (package
    (name "rust-barrel")
    (version "0.6.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "barrel" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1qgzrfpp2acb06bbqrf5a8pjjwf3dwinq7sv2hqq0b1jn5wcjrwx"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-diesel" ,rust-diesel-1)
        ("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://rust-db.github.io/barrel/")
    (synopsis "Powerful schema migration building API for Rust")
    (description "This package provides a powerful schema migration building
API for Rust.")
    (license (list license:expat license:x11 license:asl2.0))))

(define-public rust-base-x-0.2
  (package
    (name "rust-base-x")
    (version "0.2.11")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "base-x" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0w02sdqvg7zwm91agb2phikw4ri8jmncw32paxsv8ra1jv8ckfsc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-json" ,rust-json-0.12)
        ("rust-rand" ,rust-rand-0.8))))
    (home-page "https://github.com/OrKoN/base-x-rs")
    (synopsis "Encode/decode any base")
    (description "This library provides for encoding and decoding any base.")
    (license license:expat)))

(define-public rust-base32-0.5
  (package
    (name "rust-base32")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "base32" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0xp0a3xml25xw2bp5pyac2nld7vmmfjl02qynnyfn6aznfggwb82"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs (("rust-quickcheck" ,rust-quickcheck-1))))
    (home-page "https://github.com/andreasots/base32")
    (synopsis "Base32 encoder/decoder for Rust")
    (description "This library lets you encode and decode in either
RFC4648 Base32 or in Crockford Base32.")
    (license (list license:expat license:asl2.0))))

(define-public rust-base32-0.4
  (package
    (inherit rust-base32-0.5)
    (name "rust-base32")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "base32" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ykwx8jhksqxghfgyw2pzikzjf4n9wqm1x2ww5wqyn68ssf6dki3"))))
    (arguments
     `(#:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.7)
        ("rust-rand" ,rust-rand-0.5))))))

(define-public rust-base58-0.1
  (package
    (name "rust-base58")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "base58" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "10xfw6v7jzn9i682mkw9nqybzafrvl3i2wawwgp5a8gh2n0fw92h"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/debris/base58")
    (synopsis "Tiny and fast base58 encoding")
    (description
     "Encode to base58 using only Rust.  This package is based on
@url{https://github.com/trezor/trezor-crypto/blob/master/base58.c} at commit
c6e7d37.  However, this package works only up to 128 bytes.")
    (license license:expat)))

(define-public rust-base64-0.22
  (package
    (name "rust-base64")
    (version "0.22.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "base64" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1imqzgh7bxcikp5vx3shqvw9j09g9ly0xr0jma0q66i52r7jbcvj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-clap" ,rust-clap-3)
        ("rust-criterion" ,rust-criterion-0.4)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-rstest" ,rust-rstest-0.13)
        ("rust-rstest-reuse" ,rust-rstest-reuse-0.6)
        ("rust-strum" ,rust-strum-0.25))))
    (home-page "https://github.com/marshallpierce/rust-base64")
    (synopsis "Encodes and decodes base64 as bytes or utf8")
    (description
     "This package encodes and decodes base64 as bytes or utf8.")
    (license (list license:expat license:asl2.0))))

(define-public rust-base64-0.21
  (package
    (inherit rust-base64-0.22)
    (name "rust-base64")
    (version "0.21.7")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "base64" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0rw52yvsk75kar9wgqfwgb414kvil1gn7mqkrhn9zf1537mpsacx"))))
    (arguments
     `(#:cargo-development-inputs
       (("rust-clap" ,rust-clap-3)
        ("rust-criterion" ,rust-criterion-0.4)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-rstest" ,rust-rstest-0.13)
        ("rust-rstest-reuse" ,rust-rstest-reuse-0.6)
        ("rust-strum" ,rust-strum-0.25))))))

(define-public rust-base64-0.20
  (package
    (inherit rust-base64-0.21)
    (name "rust-base64")
    (version "0.20.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "base64" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1r855djiv8rirg37w5arazk42ya5gm5gd2bww75v14w0sy02i8hf"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.4)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-rstest" ,rust-rstest-0.12)
        ("rust-rstest-reuse" ,rust-rstest-reuse-0.3)
        ("rust-structopt" ,rust-structopt-0.3))))))

(define-public rust-base64-0.13
  (package
    (inherit rust-base64-0.21)
    (name "rust-base64")
    (version "0.13.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "base64" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1s494mqmzjb766fy1kqlccgfg2sdcjb6hzbvzqv2jw65fdi5h6wy"))
       (modules '((guix build utils)))
       (snippet
        '(begin (substitute* "Cargo.toml"
                  (("=0\\.3\\.2") "^0.3.2"))))))
    (arguments
     `(#:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-rand" ,rust-rand-0.6)
        ("rust-structopt" ,rust-structopt-0.3))))))

(define-public rust-base64-0.12
  (package
    (inherit rust-base64-0.13)
    (name "rust-base64")
    (version "0.12.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "base64" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1zq33had71xh48n17g4kqs96szhx3yh7qibzwi4fk217n3vz0h9l"))))
    (arguments
     `(#:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-rand" ,rust-rand-0.6))))))

(define-public rust-base64-0.11
  (package
    (inherit rust-base64-0.12)
    (name "rust-base64")
    (version "0.11.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "base64" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1iqmims6yvr6vwzyy54qd672zw29ipjj17p8klcr578c9ajpw6xl"))))
    (arguments
     `(#:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-doc-comment" ,rust-doc-comment-0.3)
        ("rust-rand" ,rust-rand-0.6))))))

(define-public rust-base64-0.10
  (package
    (inherit rust-base64-0.11)
    (name "rust-base64")
    (version "0.10.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "base64" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "13k6bvd3n6dm7jqn9x918w65dd9xhx454bqphbnv0bkd6n9dj98b"))))
    (arguments
     `(#:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.2)
        ("rust-rand" ,rust-rand-0.4))))))

(define-public rust-base64-0.9
  (package
    (inherit rust-base64-0.11)
    (name "rust-base64")
    (version "0.9.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "base64" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0hs62r35bgxslawyrn1vp9rmvrkkm76fqv0vqcwd048vs876r7a8"))))
    (arguments
     `(#:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1)
        ("rust-safemem" ,rust-safemem-0.3))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.4))))))

(define-public rust-basic-toml-0.1
  (package
    (name "rust-basic-toml")
    (version "0.1.9")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "basic-toml" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1y2q0la176gmqgskarc5464fqq3rncnjc138iiayj57n53i8hcw2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-semver" ,rust-semver-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/dtolnay/basic-toml")
    (synopsis "Minimal TOML library with few dependencies")
    (description "This package provides minimal TOML library with few
dependencies.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bat-0.24
  (package
    (name "rust-bat")
    (version "0.24.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bat" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "11nc2iv2qhd1bs16yijqq934864ybnmg485rny70scy26xb9xk4x"))
       (modules '((guix build utils)))
       (snippet
        '(begin (substitute* "Cargo.toml"
                  (("\"~([[:digit:]]+(\\.[[:digit:]]+)*)" _ version)
                   (string-append "\"^" version)))))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-ansi-colours" ,rust-ansi-colours-1)
                       ("rust-bincode" ,rust-bincode-1)
                       ("rust-bugreport" ,rust-bugreport-0.5)
                       ("rust-bytesize" ,rust-bytesize-1)
                       ("rust-clap" ,rust-clap-4)
                       ("rust-clircle" ,rust-clircle-0.4)
                       ("rust-console" ,rust-console-0.15)
                       ("rust-content-inspector" ,rust-content-inspector-0.2)
                       ("rust-encoding-rs" ,rust-encoding-rs-0.8)
                       ("rust-etcetera" ,rust-etcetera-0.8)
                       ("rust-flate2" ,rust-flate2-1)
                       ("rust-git2" ,rust-git2-0.18)
                       ("rust-globset" ,rust-globset-0.4)
                       ("rust-grep-cli" ,rust-grep-cli-0.1)
                       ("rust-home" ,rust-home-0.5)
                       ("rust-nu-ansi-term" ,rust-nu-ansi-term-0.49)
                       ("rust-once-cell" ,rust-once-cell-1)
                       ("rust-os-str-bytes" ,rust-os-str-bytes-6)
                       ("rust-path-abs" ,rust-path-abs-0.5)
                       ("rust-plist" ,rust-plist-1)
                       ("rust-regex" ,rust-regex-1)
                       ("rust-run-script" ,rust-run-script-0.10)
                       ("rust-semver" ,rust-semver-1)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-serde-yaml" ,rust-serde-yaml-0.9)
                       ("rust-shell-words" ,rust-shell-words-1)
                       ("rust-syntect" ,rust-syntect-5)
                       ("rust-thiserror" ,rust-thiserror-1)
                       ("rust-unicode-width" ,rust-unicode-width-0.1)
                       ("rust-walkdir" ,rust-walkdir-2)
                       ("rust-wild" ,rust-wild-2))
       #:cargo-development-inputs (("rust-assert-cmd" ,rust-assert-cmd-2)
                                   ("rust-expect-test" ,rust-expect-test-1)
                                   ("rust-nix" ,rust-nix-0.26)
                                   ("rust-predicates" ,rust-predicates-3)
                                   ("rust-serial-test" ,rust-serial-test-2)
                                   ("rust-tempfile" ,rust-tempfile-3)
                                   ("rust-wait-timeout" ,rust-wait-timeout-0.2))))
    (native-inputs (list pkg-config))
    (inputs (list libgit2-1.7 openssl zlib))
    (home-page "https://github.com/sharkdp/bat")
    (synopsis "Library providing syntax highlighting for text")
    (description
     "This package provides the @command{bat} syntax highlighter as a library to
use for syntax highlighting in other crates.")
    (license (list license:expat license:asl2.0))))

(define-public rust-battery-0.7
  (package
    (name "rust-battery")
    (version "0.7.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "battery" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1r1641dyks76p39i1iihswhc6iz5z51pihmpxniy1h1pi4k29dml"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f ;/sys/class/power_supply cannot be found
       #:cargo-inputs (("rust-cfg-if" ,rust-cfg-if-1)
                       ("rust-core-foundation" ,rust-core-foundation-0.7)
                       ("rust-lazycell" ,rust-lazycell-1)
                       ("rust-libc" ,rust-libc-0.2)
                       ("rust-libc" ,rust-libc-0.2)
                       ("rust-mach" ,rust-mach-0.3)
                       ("rust-nix" ,rust-nix-0.19)
                       ("rust-num-traits" ,rust-num-traits-0.2)
                       ("rust-uom" ,rust-uom-0.30)
                       ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs (("rust-approx" ,rust-approx-0.3)
                                   ("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/svartalf/rust-battery")
    (synopsis "Cross-platform information about the notebook batteries")
    (description
     "This package provides Cross-platform information about the notebook batteries.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-beef-0.5
  (package
    (name "rust-beef")
    (version "0.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "beef" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1c95lbnhld96iwwbyh5kzykbpysq0fnjfhwxa1mhap5qxgrl30is"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; Doc tests segfault.
       #:cargo-inputs (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs (("rust-serde-derive" ,rust-serde-derive-1)
                                   ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/maciejhirsz/beef")
    (synopsis "Faster, more compact implementation of Cow")
    (description "This package provides faster, more compact implementation of
Cow.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bencher-0.1
  (package
    (name "rust-bencher")
    (version "0.1.5")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bencher" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1x8p2xblgqssay8cdykp5pkfc0np0jk5bs5cx4f5av097aav9zbx"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/bluss/bencher/")
    (synopsis "Port of the libtest benchmark runner to Rust stable")
    (description "This package provides a port of the libtest (unstable Rust)
benchmark runner to Rust stable releases.  Supports running benchmarks and
filtering based on the name.  Benchmark execution works exactly the same way
and no more (caveat: black_box is still missing!).")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-better-panic-0.3
  (package
    (name "rust-better-panic")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "better-panic" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0djh7qs39z0mbkzxs4nrc9ngnyjpsxq67lqfv75q91i63b8y3abg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-backtrace" ,rust-backtrace-0.3)
                       ("rust-console" ,rust-console-0.15)
                       ("rust-syntect" ,rust-syntect-4))))
    (home-page "https://github.com/mitsuhiko/better-panic")
    (synopsis "Pretty panic backtraces")
    (description "Pretty panic backtraces inspired by Python's tracebacks.")
    (license license:expat)))

(define-public rust-bigdecimal-0.4
  (package
    (name "rust-bigdecimal")
    (version "0.4.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bigdecimal" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0b284z1lxc8r5090lr1xi2kny3jncqrlv02wk03mmin506pz6cbz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-autocfg" ,rust-autocfg-1)
                       ("rust-libm" ,rust-libm-0.2)
                       ("rust-num-bigint" ,rust-num-bigint-0.4)
                       ("rust-num-integer" ,rust-num-integer-0.1)
                       ("rust-num-traits" ,rust-num-traits-0.2)
                       ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs (("rust-paste" ,rust-paste-1)
                                   ("rust-serde-test" ,rust-serde-test-0.8)
                                   ("rust-siphasher" ,rust-siphasher-0.3))))
    (home-page "https://github.com/akubera/bigdecimal-rs")
    (synopsis "Arbitrary precision decimal numbers")
    (description "This package provides arbitrary precision decimal numbers.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bigdecimal-0.3
  (package
    (inherit rust-bigdecimal-0.4)
    (name "rust-bigdecimal")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bigdecimal" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ypfsldr1ng80n3ax1h699kqw3s5gzzqvr30zc4ybh5g1vf3sxx6"))))
    (arguments
     `(#:cargo-inputs
       (("rust-num-bigint" ,rust-num-bigint-0.4)
        ("rust-num-integer" ,rust-num-integer-0.1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs (("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-bigdecimal-0.2
  (package
    (inherit rust-bigdecimal-0.3)
    (name "rust-bigdecimal")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bigdecimal" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0mkja6m149apsnbw5narzcxmb9b4ish58gn4qvvys03jwdi0brfi"))))
    (arguments
     `(#:cargo-inputs
       (("rust-num-bigint" ,rust-num-bigint-0.3)
        ("rust-num-integer" ,rust-num-integer-0.1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-bigdecimal-0.1
  (package
    (inherit rust-bigdecimal-0.2)
    (name "rust-bigdecimal")
    (version "0.1.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bigdecimal" version))
        (file-name
          (string-append name "-" version ".tar.gz"))
        (sha256
          (base32
            "0i32g88sin9dzr4jn41wgg3pyx2xxm0m1a9s5vh9lpyj5lg1jx0k"))))
    (arguments
      `(#:cargo-inputs
        (("rust-num-bigint" ,rust-num-bigint-0.2)
         ("rust-num-integer" ,rust-num-integer-0.1)
         ("rust-num-traits" ,rust-num-traits-0.2)
         ("rust-serde" ,rust-serde-1))
        #:cargo-development-inputs
        (("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-binascii-0.1
  (package
    (name "rust-binascii")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "binascii" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0wnaglgl72pn5ilv61q6y34w76gbg7crb8ifqk6lsxnq2gajjg9q"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/naim94a/binascii-rs")
    (synopsis
     "No-std binascii operations including base64, base32 and base16 (hex)")
    (description
     "This package contains useful no-std binascii operations including base64,
base32 and base16 (hex)")
    (license license:expat)))

(define-public rust-bincode-1
  (package
    (name "rust-bincode")
    (version "1.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bincode" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1bfw3mnwzx5g1465kiqllp5n4r10qrqy88kdlp3jfwnq2ya5xx5i"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-serde-bytes" ,rust-serde-bytes-0.11)
        ("rust-serde-derive" ,rust-serde-derive-1))))
    (home-page "https://github.com/servo/bincode")
    (synopsis
     "Binary serialization/deserialization strategy")
    (description
     "This package provides a binary serialization/deserialization strategy
that uses Serde for transforming structs into bytes and vice versa!")
    (license license:expat)))

(define-public rust-bindgen-0.71
  (package
    (name "rust-bindgen")
    (version "0.71.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bindgen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1cynz43s9xwjbd1y03rx9h37xs0isyl8bi6g6yngp35nglyvyn2z"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-annotate-snippets" ,rust-annotate-snippets-0.11)
                       ("rust-bitflags" ,rust-bitflags-2)
                       ("rust-cexpr" ,rust-cexpr-0.6)
                       ("rust-clang-sys" ,rust-clang-sys-1)
                       ("rust-clap" ,rust-clap-4)
                       ("rust-clap-complete" ,rust-clap-complete-4)
                       ("rust-itertools" ,rust-itertools-0.10)
                       ("rust-log" ,rust-log-0.4)
                       ("rust-prettyplease" ,rust-prettyplease-0.2)
                       ("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-regex" ,rust-regex-1)
                       ("rust-rustc-hash" ,rust-rustc-hash-2)
                       ("rust-shlex" ,rust-shlex-1)
                       ("rust-syn" ,rust-syn-2))))
    (inputs (list clang))
    (home-page "https://rust-lang.github.io/rust-bindgen/")
    (synopsis "Generate Rust FFI bindings to C and C++ libraries")
    (description "This package can be used to automatically generate Rust FFI
bindings to C and C++ libraries.")
    (license license:bsd-3)))

(define-public rust-bindgen-0.70
  (package
    (inherit rust-bindgen-0.71)
    (name "rust-bindgen")
    (version "0.70.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bindgen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0vyf0jp6apcy9kjyz4s8vldj0xqycnbzb6zv3skkwiqdi3nqz7gl"))))
    (arguments
     `(#:cargo-inputs (("rust-annotate-snippets" ,rust-annotate-snippets-0.9)
                       ("rust-bitflags" ,rust-bitflags-2)
                       ("rust-cexpr" ,rust-cexpr-0.6)
                       ("rust-clang-sys" ,rust-clang-sys-1)
                       ("rust-itertools" ,rust-itertools-0.10)
                       ("rust-log" ,rust-log-0.4)
                       ("rust-prettyplease" ,rust-prettyplease-0.2)
                       ("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-regex" ,rust-regex-1)
                       ("rust-rustc-hash" ,rust-rustc-hash-1)
                       ("rust-shlex" ,rust-shlex-1)
                       ("rust-syn" ,rust-syn-2))))))

(define-public rust-bindgen-0.69
  (package
    (inherit rust-bindgen-0.70)
    (name "rust-bindgen")
    (version "0.69.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bindgen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1240snlcfj663k04bjsg629g4wx6f83flgbjh5rzpgyagk3864r7"))))
    (arguments
     `(#:cargo-inputs (("rust-annotate-snippets" ,rust-annotate-snippets-0.9)
                       ("rust-bitflags" ,rust-bitflags-2)
                       ("rust-cexpr" ,rust-cexpr-0.6)
                       ("rust-clang-sys" ,rust-clang-sys-1)
                       ("rust-itertools" ,rust-itertools-0.10)
                       ("rust-lazy-static" ,rust-lazy-static-1)
                       ("rust-lazycell" ,rust-lazycell-1)
                       ("rust-log" ,rust-log-0.4)
                       ("rust-prettyplease" ,rust-prettyplease-0.2)
                       ("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-regex" ,rust-regex-1)
                       ("rust-rustc-hash" ,rust-rustc-hash-1)
                       ("rust-shlex" ,rust-shlex-1)
                       ("rust-syn" ,rust-syn-2)
                       ("rust-which" ,rust-which-4))))))

(define-public rust-bindgen-0.68
  (package
    (inherit rust-bindgen-0.69)
    (name "rust-bindgen")
    (version "0.68.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bindgen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0y40gndyay1fj8d3d8gsd9fyfzjlbghx92i560kmvhvfxc9l6vkj"))))
    (arguments
     `(#:cargo-inputs (("rust-annotate-snippets" ,rust-annotate-snippets-0.9)
                       ("rust-bitflags" ,rust-bitflags-2)
                       ("rust-cexpr" ,rust-cexpr-0.6)
                       ("rust-clang-sys" ,rust-clang-sys-1)
                       ("rust-lazy-static" ,rust-lazy-static-1)
                       ("rust-lazycell" ,rust-lazycell-1)
                       ("rust-log" ,rust-log-0.4)
                       ("rust-peeking-take-while" ,rust-peeking-take-while-0.1)
                       ("rust-prettyplease" ,rust-prettyplease-0.2)
                       ("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-regex" ,rust-regex-1)
                       ("rust-rustc-hash" ,rust-rustc-hash-1)
                       ("rust-shlex" ,rust-shlex-1)
                       ("rust-syn" ,rust-syn-2)
                       ("rust-which" ,rust-which-4))))))

(define-public rust-bindgen-0.66
  (package
    (inherit rust-bindgen-0.69)
    (name "rust-bindgen")
    (version "0.66.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bindgen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "19yj6fsb08x0l1pg871vvfvlx1mglamz8hyjpazhfc90zh34xf7j"))))
    (arguments
     `(#:cargo-inputs (("rust-annotate-snippets" ,rust-annotate-snippets-0.9)
                       ("rust-bitflags" ,rust-bitflags-2)
                       ("rust-cexpr" ,rust-cexpr-0.6)
                       ("rust-clang-sys" ,rust-clang-sys-1)
                       ("rust-lazy-static" ,rust-lazy-static-1)
                       ("rust-lazycell" ,rust-lazycell-1)
                       ("rust-log" ,rust-log-0.4)
                       ("rust-peeking-take-while" ,rust-peeking-take-while-0.1)
                       ("rust-prettyplease" ,rust-prettyplease-0.2)
                       ("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-regex" ,rust-regex-1)
                       ("rust-rustc-hash" ,rust-rustc-hash-1)
                       ("rust-shlex" ,rust-shlex-1)
                       ("rust-syn" ,rust-syn-2)
                       ("rust-which" ,rust-which-4))))))

(define-public rust-bindgen-0.65
  (package
    (inherit rust-bindgen-0.69)
    (name "rust-bindgen")
    (version "0.65.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bindgen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1i9wci1h3xnk8hi7cf06capgifnmpk9dd59zqznh6jcsdx37ppyg"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-annotate-snippets" ,rust-annotate-snippets-0.9)
                       ("rust-bitflags" ,rust-bitflags-1)
                       ("rust-cexpr" ,rust-cexpr-0.6)
                       ("rust-clang-sys" ,rust-clang-sys-1)
                       ("rust-lazy-static" ,rust-lazy-static-1)
                       ("rust-lazycell" ,rust-lazycell-1)
                       ("rust-log" ,rust-log-0.4)
                       ("rust-peeking-take-while" ,rust-peeking-take-while-0.1)
                       ("rust-prettyplease" ,rust-prettyplease-0.2)
                       ("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-regex" ,rust-regex-1)
                       ("rust-rustc-hash" ,rust-rustc-hash-1)
                       ("rust-shlex" ,rust-shlex-1)
                       ("rust-syn" ,rust-syn-2)
                       ("rust-which" ,rust-which-4))))))

(define-public rust-bindgen-0.64
  (package
    (inherit rust-bindgen-0.66)
    (name "rust-bindgen")
    (version "0.64.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bindgen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1d0zmfc5swjgaydbamxb4xm687ahgv18dbcpvrzbf39665h3w964"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-cexpr" ,rust-cexpr-0.6)
        ("rust-clang-sys" ,rust-clang-sys-1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-lazycell" ,rust-lazycell-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-peeking-take-while" ,rust-peeking-take-while-0.1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-shlex" ,rust-shlex-1)
        ("rust-syn" ,rust-syn-1)
        ("rust-which" ,rust-which-4))))))

(define-public rust-bindgen-0.63
  (package
    (inherit rust-bindgen-0.64)
    (name "rust-bindgen")
    (version "0.63.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bindgen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "119qkny3swlx8zm0jxp19hizpkym6arh8mlv9ylskch030961n1n"))))))

(define-public rust-bindgen-0.61
  (package
    (inherit rust-bindgen-0.64)
    (name "rust-bindgen")
    (version "0.61.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "bindgen" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32 "16phlka8ykx28jlk7l637vlr9h01j8mh2s0d6km6z922l5c2w0la"))))))

(define-public rust-bindgen-0.59
  (package
    (inherit rust-bindgen-0.64)
    (name "rust-bindgen")
    (version "0.59.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bindgen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1f4fpycxmbrqk8r2x9brhfgjh86mzc6bngn4a9631x78b2jaklib"))))
    (arguments
     `(#:tests? #f  ; Only the build phase, to make sure we have the right inputs.
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-cexpr" ,rust-cexpr-0.6)
        ("rust-clang-sys" ,rust-clang-sys-1)
        ("rust-clap" ,rust-clap-2)
        ("rust-env-logger" ,rust-env-logger-0.9)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-lazycell" ,rust-lazycell-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-peeking-take-while" ,rust-peeking-take-while-0.1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-shlex" ,rust-shlex-1)
        ("rust-which" ,rust-which-4))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-2)
        ("rust-diff" ,rust-diff-0.1)
        ("rust-shlex" ,rust-shlex-1)
        ("rust-tempfile" ,rust-tempfile-3))))))

(define-public rust-bindgen-0.58
  (package
    (inherit rust-bindgen-0.59)
    (name "rust-bindgen")
    (version "0.58.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bindgen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "13r505nn28ay0byfd96hdg8xwcpa2r20czjy111pl66p22s2718g"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-cexpr" ,rust-cexpr-0.4)
        ("rust-clang-sys" ,rust-clang-sys-1)
        ("rust-clap" ,rust-clap-2)
        ("rust-env-logger" ,rust-env-logger-0.8)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-lazycell" ,rust-lazycell-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-peeking-take-while" ,rust-peeking-take-while-0.1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-shlex" ,rust-shlex-1)
        ("rust-which" ,rust-which-3))))))

(define-public rust-bindgen-0.57
  (package
    (inherit rust-bindgen-0.58)
    (name "rust-bindgen")
    (version "0.57.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bindgen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0g96ypnck6n60p3cz9k3y3jnxi4z7jfv2pha5bxsm8269806aj7x"))))
    (arguments
     `(#:tests? #false ;tests/headers/16-byte-alignment.h does not exist
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-cexpr" ,rust-cexpr-0.4)
        ("rust-clang-sys" ,rust-clang-sys-1)
        ("rust-clap" ,rust-clap-2)
        ("rust-env-logger" ,rust-env-logger-0.8)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-lazycell" ,rust-lazycell-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-peeking-take-while" ,rust-peeking-take-while-0.1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-shlex" ,rust-shlex-0.1)
        ("rust-which" ,rust-which-3))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-2)
        ("rust-diff" ,rust-diff-0.1)
        ("rust-shlex" ,rust-shlex-0.1))))
    (inputs
     (list clang))))

(define-public rust-bindgen-0.56
  (package
    (inherit rust-bindgen-0.57)
    (name "rust-bindgen")
    (version "0.56.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "bindgen" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0fajmgk2064ca1z9iq1jjkji63qwwz38z3d67kv6xdy0xgdpk8rd"))))
    (arguments
     (list #:cargo-test-flags ``("--release" "--"
                                 "--skip=test::commandline_multiple_headers")
           #:cargo-inputs `(("rust-bitflags" ,rust-bitflags-1)
                            ("rust-cexpr" ,rust-cexpr-0.4)
                            ("rust-clang-sys" ,rust-clang-sys-1)
                            ("rust-clap" ,rust-clap-2)
                            ("rust-env-logger" ,rust-env-logger-0.8)
                            ("rust-lazy-static" ,rust-lazy-static-1)
                            ("rust-lazycell" ,rust-lazycell-1)
                            ("rust-log" ,rust-log-0.4)
                            ("rust-peeking-take-while" ,rust-peeking-take-while-0.1)
                            ("rust-proc-macro2" ,rust-proc-macro2-1)
                            ("rust-quote" ,rust-quote-1)
                            ("rust-regex" ,rust-regex-1)
                            ("rust-rustc-hash" ,rust-rustc-hash-1)
                            ("rust-shlex" ,rust-shlex-0.1)
                            ("rust-which" ,rust-which-3))
           #:cargo-development-inputs `(("rust-clap" ,rust-clap-2)
                                        ("rust-diff" ,rust-diff-0.1)
                                        ("rust-shlex" ,rust-shlex-0.1))))
    (inputs (list clang))))

(define-public rust-bindgen-0.55
  (package
    (inherit rust-bindgen-0.57)
    (name "rust-bindgen")
    (version "0.55.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bindgen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0hxlvy9q9984rr3rqaxwmgxjrd9wh11mcc161hv3shz6b7jkrcbm"))))
    (arguments
     `(#:cargo-test-flags
       (list "--release" "--"
             "--skip=test::commandline_multiple_headers")
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-cexpr" ,rust-cexpr-0.4)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-clang-sys" ,rust-clang-sys-1)
        ("rust-clap" ,rust-clap-2)
        ("rust-env-logger" ,rust-env-logger-0.7)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-lazycell" ,rust-lazycell-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-peeking-take-while" ,rust-peeking-take-while-0.1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-shlex" ,rust-shlex-0.1)
        ("rust-which" ,rust-which-3))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-2)
        ("rust-diff" ,rust-diff-0.1)
        ("rust-shlex" ,rust-shlex-0.1))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'enable-unstable-features
           (lambda _
             (setenv "RUSTC_BOOTSTRAP" "1")
             #t)))))))

(define-public rust-bindgen-0.53
  (package
    (inherit rust-bindgen-0.55)
    (name "rust-bindgen")
    (version "0.53.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bindgen" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1rc9grfd25bk5b2acmqljhx55ndbzmh7w8b3x6q707cb4s6rfan7"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-cexpr" ,rust-cexpr-0.4)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-clang-sys" ,rust-clang-sys-0.29)
        ("rust-clap" ,rust-clap-2)
        ("rust-env-logger" ,rust-env-logger-0.7)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-lazycell" ,rust-lazycell-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-peeking-take-while" ,rust-peeking-take-while-0.1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-shlex" ,rust-shlex-0.1)
        ("rust-which" ,rust-which-3))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-2)
        ("rust-diff" ,rust-diff-0.1)
        ("rust-shlex" ,rust-shlex-0.1))))))

(define-public rust-bindgen-0.37
  (package
    (inherit rust-bindgen-0.53)
    (name "rust-bindgen")
    (version "0.37.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bindgen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "08f2cyzr8fc027mzj2lhmn5j3w318g2ql7yfw5ngxa3yhy1an98v"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-cexpr" ,rust-cexpr-0.2)
                       ("rust-cfg-if" ,rust-cfg-if-0.1)
                       ("rust-clang-sys" ,rust-clang-sys-0.23)
                       ("rust-clap" ,rust-clap-2)
                       ("rust-env-logger" ,rust-env-logger-0.5)
                       ("rust-lazy-static" ,rust-lazy-static-1)
                       ("rust-log" ,rust-log-0.4)
                       ("rust-peeking-take-while" ,rust-peeking-take-while-0.1)
                       ("rust-proc-macro2" ,rust-proc-macro2-0.3)
                       ("rust-quote" ,rust-quote-0.5)
                       ("rust-regex" ,rust-regex-1)
                       ("rust-which" ,rust-which-1))))))

(define-public rust-bio-1
  (package
    (name "rust-bio")
    (version "1.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bio" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1hpnfwjyqg23dlk75frydf9kgilccyn3haaw6xdwh25zpa9wnwks"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-anyhow" ,rust-anyhow-1)
                       ("rust-approx" ,rust-approx-0.5)
                       ("rust-bio-types" ,rust-bio-types-1)
                       ("rust-bit-set" ,rust-bit-set-0.5)
                       ("rust-bv" ,rust-bv-0.11)
                       ("rust-bytecount" ,rust-bytecount-0.6)
                       ("rust-csv" ,rust-csv-1)
                       ("rust-custom-derive" ,rust-custom-derive-0.1)
                       ("rust-editdistancek" ,rust-editdistancek-1)
                       ("rust-enum-map" ,rust-enum-map-0.6)
                       ("rust-fxhash" ,rust-fxhash-0.2)
                       ("rust-itertools" ,rust-itertools-0.11)
                       ("rust-itertools-num" ,rust-itertools-num-0.1)
                       ("rust-lazy-static" ,rust-lazy-static-1)
                       ("rust-multimap" ,rust-multimap-0.8)
                       ("rust-ndarray" ,rust-ndarray-0.15)
                       ("rust-newtype-derive" ,rust-newtype-derive-0.1)
                       ("rust-num-integer" ,rust-num-integer-0.1)
                       ("rust-num-traits" ,rust-num-traits-0.2)
                       ("rust-ordered-float" ,rust-ordered-float-3)
                       ("rust-pest" ,rust-pest-2)
                       ("rust-pest-derive" ,rust-pest-derive-2)
                       ("rust-petgraph" ,rust-petgraph-0.6)
                       ("rust-rand" ,rust-rand-0.8)
                       ("rust-regex" ,rust-regex-1)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-serde-derive" ,rust-serde-derive-1)
                       ("rust-statrs" ,rust-statrs-0.15)
                       ("rust-strum" ,rust-strum-0.25)
                       ("rust-strum-macros" ,rust-strum-macros-0.25)
                       ("rust-thiserror" ,rust-thiserror-1)
                       ("rust-triple-accel" ,rust-triple-accel-0.4)
                       ("rust-vec-map" ,rust-vec-map-0.8))
       #:cargo-development-inputs (("rust-proptest" ,rust-proptest-1)
                                   ("rust-rand" ,rust-rand-0.8)
                                   ("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://rust-bio.github.io")
    (synopsis "Bioinformatics library for Rust")
    (description
     "This package provides a bioinformatics library for Rust.  This library
provides implementations of many algorithms and data structures that are
useful for bioinformatics, but also in other fields.")
    (license license:expat)))

(define-public rust-bio-0.33
  (package
    (inherit rust-bio-1)
    (name "rust-bio")
    (version "0.33.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bio" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1zaghvazh243x2pg866hjx1zwwpp9qzwkf45iz2fs9af5y661gz5"))))
    (arguments
     `(#:cargo-inputs
       (("rust-anyhow" ,rust-anyhow-1)
        ("rust-approx" ,rust-approx-0.3)
        ("rust-bio-types" ,rust-bio-types-0.12)
        ("rust-bit-set" ,rust-bit-set-0.5)
        ("rust-bv" ,rust-bv-0.11)
        ("rust-bytecount" ,rust-bytecount-0.6)
        ("rust-csv" ,rust-csv-1)
        ("rust-custom-derive" ,rust-custom-derive-0.1)
        ("rust-enum-map" ,rust-enum-map-0.6)
        ("rust-fnv" ,rust-fnv-1)
        ("rust-fxhash" ,rust-fxhash-0.2)
        ("rust-getset" ,rust-getset-0.0.9)
        ("rust-itertools" ,rust-itertools-0.9)
        ("rust-itertools-num" ,rust-itertools-num-0.1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-multimap" ,rust-multimap-0.8)
        ("rust-ndarray" ,rust-ndarray-0.13)
        ("rust-newtype-derive" ,rust-newtype-derive-0.1)
        ("rust-num-integer" ,rust-num-integer-0.1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-ordered-float" ,rust-ordered-float-1)
        ("rust-pest" ,rust-pest-2)
        ("rust-pest-derive" ,rust-pest-derive-2)
        ("rust-petgraph" ,rust-petgraph-0.5)
        ("rust-regex" ,rust-regex-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-statrs" ,rust-statrs-0.13)
        ("rust-strum" ,rust-strum-0.19)
        ("rust-strum-macros" ,rust-strum-macros-0.19)
        ("rust-thiserror" ,rust-thiserror-1)
        ("rust-triple-accel" ,rust-triple-accel-0.3)
        ("rust-vec-map" ,rust-vec-map-0.8))
       #:cargo-development-inputs
       (("rust-proptest" ,rust-proptest-0.10)
        ("rust-tempfile" ,rust-tempfile-3))))))

(define-public rust-bio-0.39
  (package
    (inherit rust-bio-1)
    (name "rust-bio")
    (version "0.39.2")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "bio" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "00k0zv4yyiipzg2arnkrplfi0digwnv89bczfzhyva68yfv8scvb"))))
    (arguments
     `(#:cargo-inputs
       (("rust-anyhow" ,rust-anyhow-1)
        ("rust-approx" ,rust-approx-0.5)
        ("rust-bio-types" ,rust-bio-types-0.12)
        ("rust-bit-set" ,rust-bit-set-0.5)
        ("rust-bv" ,rust-bv-0.11)
        ("rust-bytecount" ,rust-bytecount-0.6)
        ("rust-csv" ,rust-csv-1)
        ("rust-custom-derive" ,rust-custom-derive-0.1)
        ("rust-enum-map" ,rust-enum-map-0.6)
        ("rust-fxhash" ,rust-fxhash-0.2)
        ("rust-getset" ,rust-getset-0.1)
        ("rust-itertools" ,rust-itertools-0.10)
        ("rust-itertools-num" ,rust-itertools-num-0.1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-multimap" ,rust-multimap-0.8)
        ("rust-ndarray" ,rust-ndarray-0.15)
        ("rust-newtype-derive" ,rust-newtype-derive-0.1)
        ("rust-num-integer" ,rust-num-integer-0.1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-ordered-float" ,rust-ordered-float-1)
        ("rust-pest" ,rust-pest-2)
        ("rust-pest-derive" ,rust-pest-derive-2)
        ("rust-petgraph" ,rust-petgraph-0.6)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-regex" ,rust-regex-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-statrs" ,rust-statrs-0.14)
        ("rust-strum" ,rust-strum-0.21)
        ("rust-strum-macros" ,rust-strum-macros-0.21)
        ("rust-thiserror" ,rust-thiserror-1)
        ("rust-triple-accel" ,rust-triple-accel-0.4)
        ("rust-vec-map" ,rust-vec-map-0.8))))))

(define-public rust-bio-0.41
  (package
    (inherit rust-bio-0.39)
    (name "rust-bio")
    (version "0.41.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "bio" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "11kmdd5rslnqjndldh7c2lzxsyapwz7fqm2yrkn3his460z44saa"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-anyhow" ,rust-anyhow-1)
        ("rust-approx" ,rust-approx-0.5)
        ("rust-bio-types" ,rust-bio-types-0.12)
        ("rust-bit-set" ,rust-bit-set-0.5)
        ("rust-bv" ,rust-bv-0.11)
        ("rust-bytecount" ,rust-bytecount-0.6)
        ("rust-csv" ,rust-csv-1)
        ("rust-custom-derive" ,rust-custom-derive-0.1)
        ("rust-enum-map" ,rust-enum-map-0.6)
        ("rust-fxhash" ,rust-fxhash-0.2)
        ("rust-getset" ,rust-getset-0.1)
        ("rust-itertools" ,rust-itertools-0.10)
        ("rust-itertools-num" ,rust-itertools-num-0.1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-multimap" ,rust-multimap-0.8)
        ("rust-ndarray" ,rust-ndarray-0.15)
        ("rust-newtype-derive" ,rust-newtype-derive-0.1)
        ("rust-num-integer" ,rust-num-integer-0.1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-ordered-float" ,rust-ordered-float-1)
        ("rust-pest" ,rust-pest-2)
        ("rust-pest-derive" ,rust-pest-derive-2)
        ("rust-petgraph" ,rust-petgraph-0.6)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-regex" ,rust-regex-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-statrs" ,rust-statrs-0.15)
        ("rust-strum" ,rust-strum-0.21)
        ("rust-strum-macros" ,rust-strum-macros-0.21)
        ("rust-thiserror" ,rust-thiserror-1)
        ("rust-triple-accel" ,rust-triple-accel-0.4)
        ("rust-vec-map" ,rust-vec-map-0.8))
       #:cargo-development-inputs
       (("rust-proptest" ,rust-proptest-1)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-tempfile" ,rust-tempfile-3))))))

(define-public rust-bio-types-1
  (package
    (name "rust-bio-types")
    (version "1.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bio-types" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0zmdcvj44a088larkahcic5z61cwn2x80iym0w14albzid7zbp7l"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-clap" ,rust-clap-3)
                       ("rust-derive-new" ,rust-derive-new-0.6)
                       ("rust-lazy-static" ,rust-lazy-static-1)
                       ("rust-petgraph" ,rust-petgraph-0.6)
                       ("rust-regex" ,rust-regex-1)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-strum-macros" ,rust-strum-macros-0.25)
                       ("rust-thiserror" ,rust-thiserror-1))))
    (home-page "https://rust-bio.github.io")
    (synopsis "Common biomedical types for use in rust-bio and rust-htslib")
    (description
     "This package provides a collection of common biomedical types for use in
rust-bio and rust-htslib.")
    (license license:expat)))

(define-public rust-bio-types-0.12
  (package
    (inherit rust-bio-types-1)
    (name "rust-bio-types")
    (version "0.12.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bio-types" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1dmcjwky9fszmwwg7ywv52xhz93zibsgl7nj9x7gadvz8yb45g0k"))))
    (arguments
     `(#:cargo-inputs
       (("rust-derive-new" ,rust-derive-new-0.5)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-petgraph" ,rust-petgraph-0.6)
        ("rust-regex" ,rust-regex-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-strum-macros" ,rust-strum-macros-0.21)
        ("rust-thiserror" ,rust-thiserror-1))))))

(define-public rust-biquad-0.4
  (package
    (name "rust-biquad")
    (version "0.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "biquad" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0gpc13lag439nmq077wfwz055qbjaxbpk7znvnbddbg3wgsj81c2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-libm" ,rust-libm-0.1))))
    (home-page "https://github.com/korken89/biquad-rs")
    (synopsis "Rust library for digital second order IIR filters")
    (description "This package provides a Rust library for digital second
order IIR filters, also known as biquads.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bit-field-0.10
  (package
    (name "rust-bit-field")
    (version "0.10.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bit_field" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0qav5rpm4hqc33vmf4vc4r0mh51yjx5vmd9zhih26n9yjs3730nw"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/phil-opp/rust-bit-field")
    (synopsis "Methods for operating on individual bits and ranges of bits")
    (description
     "This is a simple crate which provides the BitField trait, which provides
methods for operating on individual bits and ranges of bits on Rust's integral
types.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-bit-set-0.8
  (package
    (name "rust-bit-set")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bit-set" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "18riaa10s6n59n39vix0cr7l2dgwdhcpbcm97x1xbyfp1q47x008"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-bit-vec" ,rust-bit-vec-0.8)
                       ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs (("rust-rand" ,rust-rand-0.8)
                                   ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/contain-rs/bit-set")
    (synopsis "Set of bits")
    (description "This package provides a set of bits.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-bit-set-0.5
  (package
    (inherit rust-bit-set-0.8)
    (name "rust-bit-set")
    (version "0.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bit-set" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1wcm9vxi00ma4rcxkl3pzzjli6ihrpn9cfdi0c5b4cvga2mxs007"))))
    (arguments
     `(#:cargo-inputs (("rust-bit-vec" ,rust-bit-vec-0.6))
       #:cargo-development-inputs (("rust-rand" ,rust-rand-0.3))))))

(define-public rust-bit-set-0.4
  (package
    (inherit rust-bit-set-0.5)
    (name "rust-bit-set")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bit-set" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0320hhcbr73yzjpj2237vw2zq728yg7vmzb8dardg04ff4263gyr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bit-vec" ,rust-bit-vec-0.4))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.3))))))

(define-public rust-bit-vec-0.8
  (package
    (name "rust-bit-vec")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bit-vec" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1xxa1s2cj291r7k1whbxq840jxvmdsq9xgh7bvrxl46m80fllxjy"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-borsh" ,rust-borsh-1)
                       ("rust-miniserde" ,rust-miniserde-0.1)
                       ("rust-nanoserde" ,rust-nanoserde-0.1)
                       ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs (("rust-rand" ,rust-rand-0.8)
                                   ("rust-rand-xorshift" ,rust-rand-xorshift-0.3)
                                   ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/contain-rs/bit-vec")
    (synopsis "Vector of bits")
    (description "This package provides a vector of bits.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-bit-vec-0.6
  (package
    (inherit rust-bit-vec-0.8)
    (name "rust-bit-vec")
    (version "0.6.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bit-vec" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32 "1ywqjnv60cdh1slhz67psnp422md6jdliji6alq0gmly2xm9p7rl"))))
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.7)
        ("rust-rand-xorshift" ,rust-rand-xorshift-0.2)
        ("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-bit-vec-0.5
  (package
    (inherit rust-bit-vec-0.6)
    (name "rust-bit-vec")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bit-vec" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1fyh8221s6cxlmng01v8v2ljhavzawqqs8r1xjc66ap5sjavx6zm"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-bit-vec-0.4
  (package
    (inherit rust-bit-vec-0.5)
    (name "rust-bit-vec")
    (version "0.4.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bit-vec" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0pw902a8ail0k64a7092a8vngfzsq7xkj2r22hz6q1z62s5zzd02"))))
    (arguments
     `(#:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.3))))))

(define-public rust-bitfield-0.14
  (package
    (name "rust-bitfield")
    (version "0.14.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitfield" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1b26k9acwss4qvrl60lf9n83l17d4hj47n5rmpd3iigf9j9n0zid"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/dzamlo/rust-bitfield")
    (synopsis "Macros to generate bitfield-like struct")
    (description
     "This Rust crate provides macros to generate bitfield-like struct.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bitflags-2
  (package
    (name "rust-bitflags")
    (version "2.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitflags" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1pkidwzn3hnxlsl8zizh0bncgbjnw7c41cx7bby26ncbzmiznj5h"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; Not all files included.
       #:cargo-inputs
       (("rust-arbitrary" ,rust-arbitrary-1)
        ("rust-bytemuck" ,rust-bytemuck-1)
        ("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-arbitrary" ,rust-arbitrary-1)
        ("rust-bytemuck" ,rust-bytemuck-1)
        ("rust-rustversion" ,rust-rustversion-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-test" ,rust-serde-test-1)
        ("rust-trybuild" ,rust-trybuild-1)
        ("rust-zerocopy" ,rust-zerocopy-0.7))))
    (home-page "https://github.com/bitflags/bitflags")
    (synopsis "Macro to generate structures which behave like bitflags")
    (description "This package provides a macro to generate structures which
behave like a set of bitflags.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-bitflags-1
  (package
    (inherit rust-bitflags-2)
    (name "rust-bitflags")
    (version "1.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitflags" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "12ki6w8gn1ldq7yz9y680llwk5gmrhrzszaa17g1sbrw2r2qvwxy"))))
    (arguments
     `(#:tests? #f      ; could not find `Serialize` in `serde`
       #:cargo-inputs
       (("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1))
       #:cargo-development-inputs
       (("rust-rustversion" ,rust-rustversion-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-trybuild" ,rust-trybuild-1)
        ("rust-walkdir" ,rust-walkdir-2))))))

;; XXX: The package below is meant to fix rust-nix-0.22, which has the
;; following requirements for bitflags version: ">=1.1.0 <1.3.0", and every
;; package using the latter as a dependency (e.g., nushell 0.43).
(define-public rust-bitflags-1.2
  (package
    (inherit rust-bitflags-1)
    (name "rust-bitflags")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitflags" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "14qnd5nq8p2almk79m4m8ydqhd413yaxsyjp5xd19g3mikzf47fg"))))))

(define-public rust-bitflags-0.9
  (package
    (inherit rust-bitflags-1)
    (name "rust-bitflags")
    (version "0.9.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bitflags" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "19dk39gfwmhi3iy1x0wgml1fv1bkb525ywy25zwihbm063i05zaf"))))))

(define-public rust-bitflags-0.8
  (package
    (inherit rust-bitflags-1)
    (name "rust-bitflags")
    (version "0.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitflags" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1x5z8hmirpnapkx6sww8gkc6x0q8ppni0lbsigm3mrba5byfjw0k"))))))

(define-public rust-bitflags-0.7
  (package
    (inherit rust-bitflags-1)
    (name "rust-bitflags")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitflags" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0v8hh6wdkpk9my8z8442g4hqrqf05h0qj53dsay6mv18lqvqklda"))))))

(define-public rust-bitmaps-3
  (package
    (name "rust-bitmaps")
    (version "3.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitmaps" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1mivd3wyyham6c8y21nq3ka29am6v8hqn7lzmwf91aks2fq89l51"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-proptest" ,rust-proptest-1)
        ("rust-proptest-derive" ,rust-proptest-derive-0.4))))
    (home-page "https://github.com/bodil/bitmaps")
    (synopsis "Fixed size compact boolean array in Rust")
    (description "This crate provides a convenient and efficient way of
declaring and working with fixed size bitmaps in Rust.")
    (license license:mpl2.0)))

(define-public rust-bitmaps-2
  (package
    (inherit rust-bitmaps-3)
    (name "rust-bitmaps")
    (version "2.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitmaps" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "18k4mcwxl96yvii5kcljkpb8pg5j4jj1zbsdn26nsx4r83846403"))))
    (arguments
     `(#:cargo-inputs (("rust-typenum" ,rust-typenum-1))
       #:cargo-development-inputs
       (("rust-proptest" ,rust-proptest-0.9)
        ("rust-proptest-derive" ,rust-proptest-derive-0.1))))))

(define-public rust-bitpacking-0.8
  (package
    (name "rust-bitpacking")
    (version "0.8.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitpacking" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1mw2xbpkw9zhfq5lir6bgkalhhfqb5p7xwx5yimc0ry1ffnd5ix8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t #:cargo-inputs (("rust-crunchy" ,rust-crunchy-0.2))))
    (home-page "https://crates.io/crates/bitpacking")
    (synopsis "Fast integer compression/decompression via SIMD bit-packing")
    (description
     "This crate provides fast integer compression and decompression via SIMD
bit-packing.  It is a port of simdcomp C library to Rust.")
    (license license:expat)))

(define-public rust-bitreader-0.3
  (package
    (name "rust-bitreader")
    (version "0.3.11")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitreader" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0rn010p46g7fv08la915yq4q1vjfpgz8baf3bdv6rmb3w6qmjrc8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1))))
    (home-page "https://github.com/irauta/bitreader")
    (synopsis "Individual bits reader from a slice of bytes")
    (description "BitReader helps reading individual bits from a slice of
bytes.  You can read an arbitrary numbers of bits from the byte slice, for
example 13 bits at once.  The reader internally keeps track of position within
the buffer.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bitstream-io-2
  (package
    (name "rust-bitstream-io")
    (version "2.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitstream-io" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1cli390l1dhp9skygyjjnqvczp36b7f31mkx9ry3dg26330cv6b0"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-core2" ,rust-core2-0.4))))
    (home-page "https://github.com/tuffy/bitstream-io")
    (synopsis "Read/write un-aligned values from big or little-endian streams")
    (description
     "This package is a library for reading/writing un-aligned values from/to
streams in big-endian and little-endian formats.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bitvec-1
  (package
    (name "rust-bitvec")
    (version "1.0.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "bitvec" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "173ydyj2q5vwj88k6xgjnfsshs4x9wbvjjv7sm0h36r34hn87hhv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-funty" ,rust-funty-2)
        ("rust-radium" ,rust-radium-0.7)
        ("rust-serde" ,rust-serde-1)
        ("rust-tap" ,rust-tap-1)
        ("rust-wyz" ,rust-wyz-0.5))
       #:cargo-development-inputs
       (("rust-bincode" ,rust-bincode-1)
        ("rust-criterion" ,rust-criterion-0.3)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-test" ,rust-serde-test-1)
        ("rust-static-assertions" ,rust-static-assertions-1))))
    (home-page "https://bitvecto-rs.github.io/bitvec")
    (synopsis "Manipulate memory, bit by bit")
    (description
     "This package provides a crate for manipulating memory, bit by bit.")
    (license license:expat)))

(define-public rust-bitvec-0.22
  (package
    (name "rust-bitvec")
    (version "0.22.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitvec" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "09xm84dg04y8k3cm7aa81n2xfvcnidahx0qpqc60l4w6ih5g0dsj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-funty" ,rust-funty-1.2.0-yanked) ; Specifically ~1.2
        ("rust-radium" ,rust-radium-0.6)
        ("rust-serde" ,rust-serde-1)
        ("rust-tap" ,rust-tap-1)
        ("rust-wyz" ,rust-wyz-0.4))
       #:cargo-development-inputs
       (("rust-bincode" ,rust-bincode-1)
        ("rust-criterion" ,rust-criterion-0.3)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-test" ,rust-serde-test-1)
        ("rust-static-assertions" ,rust-static-assertions-1))))
    (home-page "https://bitvecto-rs.github.io/bitvec")
    (synopsis "Manipulate memory, bit by bit")
    (description
     "This package provides a crate for manipulating memory, bit by bit.")
    (license license:expat)))

(define-public rust-bitvec-0.20
  (package
    (inherit rust-bitvec-0.22)
    (name "rust-bitvec")
    (version "0.20.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitvec" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0j3qn0z31j06c965hs3kh41l78hxbzzsf1h46xvs3ym48i1i8x3p"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags
       '("--release" "--"
         "--skip=slice::tests::get_set")
       #:cargo-inputs
       (("rust-funty" ,rust-funty-1)
        ("rust-radium" ,rust-radium-0.6)
        ("rust-serde" ,rust-serde-1)
        ("rust-tap" ,rust-tap-1)
        ("rust-wyz" ,rust-wyz-0.2))
       #:cargo-development-inputs
       (("rust-bincode" ,rust-bincode-1)
        ("rust-criterion" ,rust-criterion-0.3)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-test" ,rust-serde-test-1)
        ("rust-static-assertions" ,rust-static-assertions-1))))))

(define-public rust-bitvec-0.19
  (package
    (inherit rust-bitvec-0.22)
    (name "rust-bitvec")
    (version "0.19.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bitvec" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0cvb24nanb50vq61d3ac3pz7rxjcy0w6lr3nb56kcg1nyc73vyam"))))
    (arguments
     `(#:cargo-inputs
       (("rust-funty" ,rust-funty-1)
        ("rust-radium" ,rust-radium-0.5)
        ("rust-serde" ,rust-serde-1)
        ("rust-tap" ,rust-tap-1)
        ("rust-wyz" ,rust-wyz-0.2))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-test" ,rust-serde-test-1)
        ("rust-static-assertions" ,rust-static-assertions-1))))))

(define-public rust-blanket-0.3
  (package
    (name "rust-blanket")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "blanket" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1zvffm82h5825lcf9c0xy76mj487il472cpvcbiidy8dzslj3cg0"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; Tests fail to compile.
       #:cargo-inputs (("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-syn" ,rust-syn-2))
       #:cargo-development-inputs
       (("rust-impls" ,rust-impls-1)
        ("rust-static-assertions" ,rust-static-assertions-1)
        ("rust-syn" ,rust-syn-2)
        ("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://github.com/althonos/blanket")
    (synopsis "Macro to derive blanket implementations for your traits")
    (description
     "This package provides a simple macro to derive blanket implementations for
your traits.")
    (license license:expat)))

(define-public rust-blas-0.22
  (package
    (name "rust-blas")
    (version "0.22.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "blas" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1p1rs9y8fpxmrh9jj1rf4q517x5h960v4jf30f1gwnr1qdshz65f"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-blas-sys" ,rust-blas-sys-0.7)
                       ("rust-libc" ,rust-libc-0.2)
                       ("rust-num-complex" ,rust-num-complex-0.4))))
    (home-page "https://github.com/blas-lapack-rs/blas")
    (synopsis "Rust wrappers for BLAS (Fortran)")
    (description "The package provides wrappers for BLAS (Fortran).")
    (license (list license:asl2.0 license:expat))))

(define-public rust-blas-sys-0.7
  (package
    (name "rust-blas-sys")
    (version "0.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "blas-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0h14zjycwc76v15h8qll9z1xiryvmpvsb5gam97pqpdjrrwv5c8k"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/blas-lapack-rs/blas-sys")
    (synopsis "Rust bindings to BLAS (Fortran)")
    (description "The package provides bindings to BLAS (Fortran).")
    (license (list license:asl2.0 license:expat))))

(define-public rust-blobby-0.3
  (package
    (name "rust-blobby")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "blobby" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1v7a6lzxbvrxpnk2jv895315v7yas1cvk26mmbl90ylp1719ax44"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-hex" ,rust-hex-0.4))))
    (home-page "https://github.com/RustCrypto/utils")
    (synopsis "Iterator over simple binary blob storage")
    (description "This package provides an iterator over simple binary blob
storage.")
    (license (list license:expat license:asl2.0))))

(define-public rust-blobby-0.1
  (package
    (inherit rust-blobby-0.3)
    (name "rust-blobby")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "blobby" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1xicpf3s2mi5xqnx8ps5mdych4ib5nh2nfsbrsg8ar8bjk1girbg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1))
       #:cargo-development-inputs
       (("rust-byteorder" ,rust-byteorder-1)
        ("rust-hex" ,rust-hex-0.3))))))

(define-public rust-block-buffer-0.10
  (package
    (name "rust-block-buffer")
    (version "0.10.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "block-buffer" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0w9sa2ypmrsqqvc20nhwr75wbb5cjr4kkyhpjm1z1lv2kdicfy1h"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-generic-array" ,rust-generic-array-0.14))))
    (home-page "https://github.com/RustCrypto/utils")
    (synopsis "Fixed size buffer for block processing of data")
    (description "Fixed size buffer for block processing of data.")
    (license (list license:expat license:asl2.0))))

(define-public rust-block-buffer-0.9
  (package
    (inherit rust-block-buffer-0.10)
    (name "rust-block-buffer")
    (version "0.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "block-buffer" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1r4pf90s7d7lj1wdjhlnqa26vvbm6pnc33z138lxpnp9srpi2lj1"))))
    (arguments
     `(#:cargo-inputs
       (("rust-block-padding" ,rust-block-padding-0.2)
        ("rust-generic-array" ,rust-generic-array-0.14))))))

(define-public rust-block-buffer-0.7
  (package
    (inherit rust-block-buffer-0.9)
    (name "rust-block-buffer")
    (version "0.7.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "block-buffer" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "12v8wizynqin0hqf140kmp9s38q223mp1b0hkqk8j5pk8720v560"))))
    (arguments
     `(#:cargo-inputs
       (("rust-block-padding" ,rust-block-padding-0.1)
        ("rust-byte-tools" ,rust-byte-tools-0.3)
        ("rust-byteorder" ,rust-byteorder-1)
        ("rust-generic-array" ,rust-generic-array-0.12))))))

(define-public rust-block-padding-0.3
  (package
    (name "rust-block-padding")
    (version "0.3.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "block-padding" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32 "14wdad0r1qk5gmszxqd8cky6vx8qg7c153jv981mixzrpzmlz2d8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-generic-array" ,rust-generic-array-0.14))))
    (home-page "https://github.com/RustCrypto/utils")
    (synopsis "Padding and unpadding of messages divided into blocks")
    (description
     "Padding and unpadding of messages divided into blocks.")
    (license (list license:expat license:asl2.0))))

(define-public rust-block-padding-0.2
  (package
    (inherit rust-block-padding-0.3)
    (name "rust-block-padding")
    (version "0.2.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "block-padding" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1bickjlmfw9iv63dp781n589rfybw879mik1va59833m1hvnqscd"))))))

(define-public rust-block-padding-0.1
  (package
    (inherit rust-block-padding-0.2)
    (name "rust-block-padding")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "block-padding" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1xbkmysiz23vimd17rnsjpw9bgjxipwfslwyygqlkx4in3dxwygs"))))
    (arguments
     `(#:cargo-inputs (("rust-byte-tools" ,rust-byte-tools-0.3))))))

(define-public rust-blocking-1
  (package
    (name "rust-blocking")
    (version "1.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "blocking" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1si99l8zp7c4zq87y35ayjgc5c9b60jb8h0k14zfcs679z2l2gvh"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-async-channel" ,rust-async-channel-2)
        ("rust-async-task" ,rust-async-task-4)
        ("rust-futures-io" ,rust-futures-io-0.3)
        ("rust-futures-lite" ,rust-futures-lite-2)
        ("rust-piper" ,rust-piper-0.2)
        ("rust-tracing" ,rust-tracing-0.1))
       #:cargo-development-inputs
       (("rust-futures-lite" ,rust-futures-lite-2))))
    (home-page "https://github.com/smol-rs/blocking")
    (synopsis "Thread pool for isolating blocking I/O in async programs")
    (description
     "This package provides a thread pool for isolating blocking I/O in async
programs.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-blocking-0.6
  (package
    (inherit rust-blocking-1)
    (name "rust-blocking")
    (version "0.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "blocking" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "13g1xlsd1ardf9wxkj1d03baxfy8f8kvgjz55l6zi1q4jn5f0c1z"))))
    (arguments
     `(#:cargo-inputs
       (("rust-async-channel" ,rust-async-channel-1)
        ("rust-atomic-waker" ,rust-atomic-waker-1)
        ("rust-fastrand" ,rust-fastrand-1)
        ("rust-futures-lite" ,rust-futures-lite-1)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-waker-fn" ,rust-waker-fn-1))))))

(define-public rust-blocking-0.4
  (package
    (inherit rust-blocking-0.6)
    (name "rust-blocking")
    (version "0.4.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "blocking" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0av1h5p6lb5bpzghmzsksx31icvdwrpxxzkq6r56n1l5pzvqyinj"))))
    (arguments
     `(#:cargo-inputs
       (("rust-async-channel" ,rust-async-channel-1)
        ("rust-atomic-waker" ,rust-atomic-waker-1)
        ("rust-futures-lite" ,rust-futures-lite-0.1)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-parking" ,rust-parking-1)
        ("rust-waker-fn" ,rust-waker-fn-1))))))

(define-public rust-borsh-1
  (package
    (name "rust-borsh")
    (version "1.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "borsh" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "00vz4ngik3dz86j83ra6w3c8rq9amh1n9kaw452f6i5dfdzr81i5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; Tests aren't setup correctly.
       #:cargo-inputs (("rust-ascii" ,rust-ascii-1)
                       ("rust-borsh-derive" ,rust-borsh-derive-1)
                       ("rust-bson" ,rust-bson-2)
                       ("rust-bytes" ,rust-bytes-1)
                       ("rust-cfg-aliases" ,rust-cfg-aliases-0.2)
                       ("rust-hashbrown" ,rust-hashbrown-0.14))
       #:cargo-development-inputs (("rust-insta" ,rust-insta-1)
                                   ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://borsh.io")
    (synopsis "Borsch is the binary object representation serializer for hashing")
    (description "This crate implements @code{borsh}, the binary object
representation serializer for hashing.  It is meant to be used in
security-critical projects as it prioritizes consistency, safety, speed, and
comes with a strict specification.")
    (license (list license:expat license:asl2.0))))

(define-public rust-borsh-0.10
  (package
    (inherit rust-borsh-1)
    (name "rust-borsh")
    (version "0.10.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "borsh" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1vkgajwrpncr46hk6nn8j3382jffkpy9xhcisfxdwb5n9vb58phi"))))
    (arguments
     `(#:tests? #f  ; the trait bound `BytesMut: BorshSerialize` is not satisfied
       #:cargo-inputs
       (("rust-borsh-derive" ,rust-borsh-derive-0.10)
        ("rust-bytes" ,rust-bytes-1)
        ("rust-hashbrown" ,rust-hashbrown-0.13))
       #:cargo-development-inputs
       (("rust-bytes" ,rust-bytes-1))))))

(define-public rust-borsh-derive-1
  (package
    (name "rust-borsh-derive")
    (version "1.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "borsh-derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0i3jdajyd0mjbrsaxx3y93x13ghnylr9hv0rff1xd2wkicxklnf2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; Tests aren't setup correctly.
       #:cargo-inputs (("rust-once-cell" ,rust-once-cell-1)
                       ("rust-proc-macro-crate" ,rust-proc-macro-crate-3)
                       ("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-syn" ,rust-syn-2))
       #:cargo-development-inputs (("rust-insta" ,rust-insta-1)
                                   ("rust-prettyplease" ,rust-prettyplease-0.2)
                                   ("rust-syn" ,rust-syn-2))))
    (home-page "https://borsh.io")
    (synopsis "Derive proc-macros for @code{borsh}")
    (description "This crate implements derive proc-macros for @code{borsh}.")
    (license license:asl2.0)))

(define-public rust-borsh-derive-0.10
  (package
    (inherit rust-borsh-derive-1)
    (name "rust-borsh-derive")
    (version "0.10.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "borsh-derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "12gg3kgi6gi4qlqrxlccpnhffsxsb8scbqlnss6rj8wl1pw164l3"))))
    (arguments
     `(#:cargo-inputs
       (("rust-borsh-derive-internal" ,rust-borsh-derive-internal-0.10)
        ("rust-borsh-schema-derive-internal" ,rust-borsh-schema-derive-internal-0.10)
        ("rust-proc-macro-crate" ,rust-proc-macro-crate-0.1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-syn" ,rust-syn-1))))))

(define-public rust-borsh-derive-internal-0.10
  (package
    (name "rust-borsh-derive-internal")
    (version "0.10.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "borsh-derive-internal" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1cvn16046101px9b98i3np95rmrwvzbi63d7l957362cci8bmmk5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://borsh.io")
    (synopsis "Borsh derive proc-macro internals")
    (description "This crate contains derive proc-macro internals for @code{borsh}.")
    (license license:asl2.0)))

(define-public rust-borsh-schema-derive-internal-0.10
  (package
    (name "rust-borsh-schema-derive-internal")
    (version "0.10.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "borsh-schema-derive-internal" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1m5nldxh5ji4hxw7g3zlm6xqwj4f2j32nsg6hfz2fd06dzcr2ri7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-pretty-assertions" ,rust-pretty-assertions-1))))
    (home-page "https://borsh.io")
    (synopsis "Schema generator for @code{borsh}")
    (description "This crate implements schema generator for @code{borsh}.")
    (license license:asl2.0)))

(define-public rust-boxfnonce-0.1
  (package
    (name "rust-boxfnonce")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "boxfnonce" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "09ilf4zyx92hyhkxlsxksfyprzr9iwq5gqqb22aaqr32c8fwp22r"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/stbuehler/rust-boxfnonce")
    (synopsis "Safe FnOnce boxing for Rust")
    (description "This package provides a safe FnOnce boxing for Rust.")
    (license license:expat)))

(define-public rust-boxxy-0.13
  (package
    (name "rust-boxxy")
    (version "0.13.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "boxxy" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0rhzv4c6xn6va4dikbq2a2cmd5sa3svl13lhpcrchdn23y744aq0"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-anyhow" ,rust-anyhow-1)
                       ("rust-base64" ,rust-base64-0.13)
                       ("rust-bufstream" ,rust-bufstream-0.1)
                       ("rust-caps" ,rust-caps-0.5)
                       ("rust-cfg-if" ,rust-cfg-if-1)
                       ("rust-clap" ,rust-clap-3)
                       ("rust-close-fds" ,rust-close-fds-0.3)
                       ("rust-errno" ,rust-errno-0.2)
                       ("rust-futures-util" ,rust-futures-util-0.3)
                       ("rust-libc" ,rust-libc-0.2)
                       ("rust-libflate" ,rust-libflate-1)
                       ("rust-log" ,rust-log-0.4)
                       ("rust-nix" ,rust-nix-0.24)
                       ("rust-pledge" ,rust-pledge-0.4)
                       ("rust-regex" ,rust-regex-1)
                       ("rust-reqwest" ,rust-reqwest-0.11)
                       ("rust-rustls" ,rust-rustls-0.20)
                       ("rust-rustyline" ,rust-rustyline-10)
                       ("rust-sha2" ,rust-sha2-0.10)
                       ("rust-tar" ,rust-tar-0.4)
                       ("rust-tokio" ,rust-tokio-1))
       #:cargo-development-inputs (("rust-ctrlc" ,rust-ctrlc-3)
                                   ("rust-elf" ,rust-elf-0.0.10)
                                   ("rust-env-logger" ,rust-env-logger-0.9)
                                   ("rust-pem" ,rust-pem-1)
                                   ("rust-rustls" ,rust-rustls-0.20)
                                   ("rust-sha2" ,rust-sha2-0.10))))
    (home-page "https://github.com/kpcyrd/boxxy-rs")
    (synopsis "Linkable sandbox explorer")
    (description
     "This library provides an interactive shell that can be linked into a
program to verify sandboxing measures are adequate.")
    (license license:lgpl3)))

(define-public rust-bracoxide-0.1
  (package
    (name "rust-bracoxide")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bracoxide" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "13khmkxxh583hhzz0bvkg6bqwpnz4b9g400sq8liz3jf8asvrh7v"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs (("rust-criterion" ,rust-criterion-0.5))))
    (home-page "https://github.com/atahabaki/bracoxide")
    (synopsis "Library for brace pattern combination, etc.")
    (description "This package provides a feature-rich library for brace pattern
combination, permutation generation, and error handling.")
    (license license:expat)))

(define-public rust-branches-0.1
  (package
    (name "rust-branches")
    (version "0.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "branches" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0alxmzmms4s8vv1v94y2kdq49a4p7728fgkpxx36z2m092bznn3r"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/fereidani/branches")
    (synopsis "Branch hinting prediction and control functions")
    (description
     "This package provides branch hinting prediction and control functions for
stable Rust including likely, unlikely, assume and abort to help algorithm
optimization.")
    (license license:expat)))

(define-public rust-bresenham-0.1
  (package
    (name "rust-bresenham")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bresenham" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1mvg3zcyll0m3z79jwbg183ha4kb7bw06rd286ijwvgn4mi13hdz"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/mbr/bresenham-rs")
    (synopsis
     "Iterator-based integer-only implementation of Bresenham's line algorithm")
    (description
     "This package provides a fast, iterator-based integer-only implementation of
Bresenham's line algorithm.")
    (license license:expat)))

(define-public rust-broadcaster-0.2
  (package
    (name "rust-broadcaster")
    (version "0.2.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "broadcaster" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1848lwapy955rs8kbiv87adj68vdlh6vlj8n4wq10vx541j49887"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-futures-channel-preview" ,rust-futures-channel-preview-0.3)
        ("rust-futures-core-preview" ,rust-futures-core-preview-0.3)
        ("rust-futures-sink-preview" ,rust-futures-sink-preview-0.3)
        ("rust-futures-util-preview" ,rust-futures-util-preview-0.3)
        ("rust-parking-lot" ,rust-parking-lot-0.9)
        ("rust-slab" ,rust-slab-0.4))
       #:cargo-development-inputs
       (("rust-futures-executor-preview" ,rust-futures-executor-preview-0.3))))
    (home-page "https://github.com/leo60228/broadcaster")
    (synopsis "Broadcasting futures mpmc channel")
    (description
     "This package provides a wrapper for any Stream and Sink implementing the
@code{mpsc} pattern to enable broadcasting items.")
    (license (list license:expat license:asl2.0))))

(define-public rust-browserslist-rs-0.6
  (package
    (name "rust-browserslist-rs")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "browserslist-rs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "19l0prgnbx0cyqvjsf30ni7d87nkn8j0fj56fg259yvfh50if1ri"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; Not all files included.
       #:cargo-inputs
       (("rust-ahash" ,rust-ahash-0.7)
        ("rust-anyhow" ,rust-anyhow-1)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-either" ,rust-either-1)
        ("rust-itertools" ,rust-itertools-0.10)
        ("rust-js-sys" ,rust-js-sys-0.3)
        ("rust-napi" ,rust-napi-2)
        ("rust-napi-build" ,rust-napi-build-1)
        ("rust-napi-derive" ,rust-napi-derive-2)
        ("rust-nom" ,rust-nom-7)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-wasm-bindgen" ,rust-serde-wasm-bindgen-0.3)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-string-cache" ,rust-string-cache-0.8)
        ("rust-string-cache-codegen" ,rust-string-cache-codegen-0.5)
        ("rust-thiserror" ,rust-thiserror-1)
        ("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-2)
        ("rust-criterion" ,rust-criterion-0.3)
        ("rust-test-case" ,rust-test-case-1))))
    (home-page "https://github.com/browserslist/browserslist-rs")
    (synopsis "Rust-ported Browserslist")
    (description "Rust-ported Browserslist.")
    (license license:expat)))

(define-public rust-bs58-0.5
  (package
    (name "rust-bs58")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bs58" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1x3v51n5n2s3l0rgrsn142akdf331n2qsa75pscw71fi848vm25z"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-sha2" ,rust-sha2-0.10)
                       ("rust-smallvec" ,rust-smallvec-1)
                       ("rust-tinyvec" ,rust-tinyvec-1))
       #:cargo-development-inputs
       (("rust-assert-matches" ,rust-assert-matches-1)
        ("rust-base58" ,rust-base58-0.1)
        ("rust-criterion" ,rust-criterion-0.5)
        ("rust-rust-base58" ,rust-rust-base58-0.0.4)
        ("rust-tinyvec" ,rust-tinyvec-1))))
    (home-page "https://github.com/Nullus157/bs58-rs")
    (synopsis "Another Base58 codec implementation")
    (description
     "Another Base58 codec implementation.  Compared to the base58 crate this
is significantly faster at decoding: about 2.4x as fast when decoding 32 bytes,
almost the same speed for encoding: about 3% slower when encoding 32 bytes.
@code{rust-bs58} is not limited to 128 bytes and supports a configurable alphabet.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-bs58-0.4
  (package
    (inherit rust-bs58-0.5)
    (name "rust-bs58")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bs58" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1lr3vwzhhyica4y7rbkf26vr1h7vpjb1m6rml8zcqgw81c2y07vp"))))
    (arguments
     `(#:cargo-inputs (("rust-sha2" ,rust-sha2-0.9))
       #:cargo-development-inputs
       (("rust-assert-matches" ,rust-assert-matches-1)
        ("rust-base58" ,rust-base58-0.1)
        ("rust-criterion" ,rust-criterion-0.3)
        ("rust-rust-base58" ,rust-rust-base58-0.0.4))))))

(define-public rust-bsd-kvm-0.1
  (package
    (name "rust-bsd-kvm")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bsd-kvm" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1gncwfwlx6mq47qc1siwaiqlsaccy7vsc1v39ybs4xvvn4lfpd4l"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t ; Missing kvm.h.
       #:cargo-inputs (("rust-bsd-kvm-sys" ,rust-bsd-kvm-sys-0.2)
                       ("rust-libc" ,rust-libc-0.2)
                       ("rust-thiserror" ,rust-thiserror-1))))
    (inputs (list clang))
    (home-page "https://github.com/dalance/bsd-kvm")
    (synopsis "BSD Kernel Data Access Library (libkvm) binding")
    (description
     "This package provides the BSD Kernel Data Access Library (libkvm) binding.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bsd-kvm-sys-0.2
  (package
    (name "rust-bsd-kvm-sys")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bsd-kvm-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0cn90d0kkfcs36v3sq3lpckyy0pdpdq0m7ihjlancripdn98yh35"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t ; Missing kvm.h.
       #:cargo-inputs (("rust-bindgen" ,rust-bindgen-0.65))))
    (inputs (list clang))
    (home-page "https://github.com/dalance/bsd-kvm-sys")
    (synopsis "BSD Kernel Data Access Library (libkvm) binding")
    (description
     "This package provides BSD Kernel Data Access Library (libkvm) bindings.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bson-2
  (package
    (name "rust-bson")
    (version "2.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bson" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0ndsd9lk148xiv87am4gyr02dfmq5f6lhdzfy6kjgypwnvr0i0h6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; file not found for module `tests`
       #:cargo-inputs (("rust-ahash" ,rust-ahash-0.8)
                       ("rust-base64" ,rust-base64-0.13)
                       ("rust-bitvec" ,rust-bitvec-1)
                       ("rust-chrono" ,rust-chrono-0.4)
                       ("rust-hex" ,rust-hex-0.4)
                       ("rust-indexmap" ,rust-indexmap-2)
                       ("rust-js-sys" ,rust-js-sys-0.3)
                       ("rust-once-cell" ,rust-once-cell-1)
                       ("rust-rand" ,rust-rand-0.8)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-serde-bytes" ,rust-serde-bytes-0.11)
                       ("rust-serde-json" ,rust-serde-json-1)
                       ("rust-serde-path-to-error" ,rust-serde-path-to-error-0.1)
                       ("rust-serde-with" ,rust-serde-with-3)
                       ("rust-serde-with" ,rust-serde-with-1)
                       ("rust-time" ,rust-time-0.3)
                       ("rust-uuid" ,rust-uuid-1)
                       ("rust-uuid" ,rust-uuid-0.8))
       #:cargo-development-inputs
       (("rust-assert-matches" ,rust-assert-matches-1)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-criterion" ,rust-criterion-0.3)
        ("rust-getrandom" ,rust-getrandom-0.2)
        ("rust-pretty-assertions" ,rust-pretty-assertions-0.6)
        ("rust-proptest" ,rust-proptest-1)
        ("rust-serde-bytes" ,rust-serde-bytes-0.11))))
    (home-page "https://github.com/mongodb/bson-rust")
    (synopsis "Encoding and decoding support for BSON in Rust")
    (description "This crate provides encoding and decoding support for BSON.")
    (license license:expat)))

(define-public rust-bson-1
  (package
    (inherit rust-bson-2)
    (name "rust-bson")
    (version "1.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bson" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1cbc9mbjm4imzcv95y8r6rgl6kgv7ka5ifhhlxaqi4sv0dwaa2ny"))))
    (arguments
     `(#:tests? #f      ; file not found for module `tests`
       #:cargo-inputs
       (("rust-base64" ,rust-base64-0.13)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-decimal" ,rust-decimal-2)
        ("rust-hex" ,rust-hex-0.4)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-linked-hash-map" ,rust-linked-hash-map-0.5)
        ("rust-rand" ,rust-rand-0.7)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-uuid" ,rust-uuid-0.8))
       #:cargo-development-inputs
       (("rust-assert-matches" ,rust-assert-matches-1)
        ("rust-pretty-assertions" ,rust-pretty-assertions-0.6)
        ("rust-serde-bytes" ,rust-serde-bytes-0.11))))))

(define-public rust-bstr-1
  (package
    (name "rust-bstr")
    (version "1.11.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "bstr" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1j32ghvgwvc40bc6g38ximk52dv1xfknkzfmdwpgjnrsd1yk0skq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; Not all files included.
       #:cargo-inputs
       (("rust-memchr" ,rust-memchr-2)
        ("rust-regex-automata" ,rust-regex-automata-0.4)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-1)
        ("rust-ucd-parse" ,rust-ucd-parse-0.1)
        ("rust-unicode-segmentation" ,rust-unicode-segmentation-1))))
    (home-page "https://github.com/BurntSushi/bstr")
    (synopsis "String type that is not required to be valid UTF-8")
    (description
     "This package provides a string type that is not required to be valid
UTF-8.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bstr-0.2
  (package
    (inherit rust-bstr-1)
    (name "rust-bstr")
    (version "0.2.17")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "bstr" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "08rjbhysy6gg27db2h3pnhvr2mlr5vkj797i9625kwg8hgrnjdds"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-regex-automata" ,rust-regex-automata-0.1)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.8)
        ("rust-ucd-parse" ,rust-ucd-parse-0.1)
        ("rust-unicode-segmentation" ,rust-unicode-segmentation-1))))))

(define-public rust-btoi-0.4
  (package
    (name "rust-btoi")
    (version "0.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "btoi" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1bg02zgsv5njbhng9sq2b70przbazsczjbla5lbbdf59fdzl1mlx"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-num-traits" ,rust-num-traits-0.2))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-quickcheck" ,rust-quickcheck-1))))
    (home-page "https://github.com/niklasf/rust-btoi")
    (synopsis "Parse integers directly from ASCII byte slices")
    (description "Parse integers directly from ASCII byte slices.")
    (license (list license:expat license:asl2.0))))

(define-public rust-buf-min-0.7
  (package
    (name "rust-buf-min")
    (version "0.7.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "buf-min" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "146wb3p4n62jbka6ym7sagziydcbixwhamw0cknl49w4ys66km92"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bytes" ,rust-bytes-1)
        ("rust-ntex-bytes" ,rust-ntex-bytes-0.1))))
    (home-page "https://github.com/botika/buf-min")
    (synopsis "Minimal utf-8 safe buffer traits")
    (description "This package provides mminimal utf-8 safe buffer traits.")
    (license (list license:expat license:asl2.0))))

(define-public rust-buf-redux-0.8
  (package
    (name "rust-buf-redux")
    (version "0.8.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "buf_redux" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0zy0p4vd2kjk7z5m4m8kdwhs5cmx1z02n7v36njhgfs8fs4aclxr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-memchr" ,rust-memchr-2)
        ("rust-safemem" ,rust-safemem-0.3)
        ("rust-slice-deque" ,rust-slice-deque-0.2))))
    (home-page "https://github.com/abonander/buf_redux")
    (synopsis "Drop-in replacements for buffered I/O in @code{std::io}")
    (description
     "This package provides drop-in replacements for buffered I/O in
@code{std::io}, with extra features.")
    (license (list license:expat license:asl2.0))))

(define-public rust-buffer-redux-1
  (package
    (name "rust-buffer-redux")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "buffer-redux" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1waq39blrj7j6qp1sp2fvplwmq10yhks7fgbsdy8kxdrqn3wz2jf"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-memchr" ,rust-memchr-2)
                       ("rust-slice-ring-buffer" ,rust-slice-ring-buffer-0.3))))
    (home-page "https://github.com/dignifiedquire/buffer-redux")
    (synopsis "Replacements for buffered I/O in `std::io` with extra features")
    (description "This crate provides a drop-in replacements for buffered I/O in
@code{std::io} with extra features.")
    (license (list license:expat license:asl2.0))))

(define-public rust-buffered-reader-1
  (package
    (name "rust-buffered-reader")
    (version "1.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "buffered-reader" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "16rbk2671wbslz4rxcxcr0cglrd65fnn6b8p4s2qwyjqamg1rggs"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bzip2" ,rust-bzip2-0.4)
        ("rust-flate2" ,rust-flate2-1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2))))
    (home-page "https://sequoia-pgp.org/")
    (synopsis "Super-powered Reader")
    (description
     "Like the @code{BufRead} trait, the @code{BufferedReader} trait has an
internal buffer that is directly exposed to the user.  This design enables two
performance optimizations.  First, the use of an internal buffer amortizes
system calls.  Second, exposing the internal buffer allows the user to work
with data in place, which avoids another copy.")
    (license license:gpl3)))

(define-public rust-buffering-0.4
  (package
    (name "rust-buffering")
    (version "0.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "buffering" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1wmgy84j5scbndzx7mccz07z34n98fwnfah1zd5kzqjaif5iqk76"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-buffering-nocopy-macro" ,rust-buffering-nocopy-macro-0.2))))
    (home-page "https://github.com/jbaublitz/buffering")
    (synopsis "Library primarily designed for network packet buffer operations")
    (description
     "This package provides a library primarily designed for network packet
buffer operations.")
    (license license:bsd-3)))

(define-public rust-buffering-0.3
  (package
    (inherit rust-buffering-0.4)
    (name "rust-buffering")
    (version "0.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "buffering" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "11cyq2nm569j028g93jxk00h8nfwc3l6n3hqw79w34na01p3lq97"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-buffering-nocopy-macro" ,rust-buffering-nocopy-macro-0.1))))))

(define-public rust-buffering-nocopy-macro-0.2
  (package
    (name "rust-buffering-nocopy-macro")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "buffering_nocopy_macro" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0a8zs7s5z0f977g7zx95b8sf8gqa8iwh13rj639wk080d00l5kaa"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/jbaublitz/buffering")
    (synopsis "Proc-macro crate for buffering")
    (description "This package provides a proc-macro crate for buffering.")
    (license license:bsd-3)))

(define-public rust-buffering-nocopy-macro-0.1
  (package
    (inherit rust-buffering-nocopy-macro-0.2)
    (name "rust-buffering-nocopy-macro")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "buffering_nocopy_macro" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "03b6wp4i3273jzw2nbnrnddlxyma3p465y2dszx6vc3ysq0fdlj7"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-syn" ,rust-syn-0.14))))))

(define-public rust-bufstream-0.1
  (package
    (name "rust-bufstream")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bufstream" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1j7f52rv73hd1crzrrfb9dr50ccmi3hb1ybd6s5dyg6jmllqkqs0"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-futures" ,rust-futures-0.1)
        ("rust-tokio-io" ,rust-tokio-io-0.1))))
    (home-page "https://github.com/alexcrichton/bufstream")
    (synopsis "I/O streams with separate read/write buffers")
    (description
     "This package provides buffered I/O for streams where each read/write
half is separately buffered.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bugreport-0.5
  (package
    (name "rust-bugreport")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bugreport" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1jcq9ywxyd7fw1ing8ixna0cfcs5lrviyvx6h6080ir532w20lak"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-git-version" ,rust-git-version-0.3)
        ("rust-shell-escape" ,rust-shell-escape-0.1)
        ("rust-sys-info" ,rust-sys-info-0.9))
       #:cargo-development-inputs
       (("rust-pretty-assertions" ,rust-pretty-assertions-1)
        ("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/sharkdp/bugreport")
    (synopsis "Collect system and environment information for bug reports")
    (description
     "bugreport is a Rust library that helps application developers to
automatically collect information about the system and the environment that
users can send along with a bug report.")
    (license (list license:expat license:asl2.0))))

(define-public rust-build-const-0.2
  (package
    (name "rust-build-const")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "build_const" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1dryhsf4vfi1plljgv069sgfr8m1rsg04qy76x36kh6swqsl5bml"))))
    (build-system cargo-build-system)
    (home-page "https://crates.io/crates/build_const")
    (synopsis "Create importable constants from build.rs or a script")
    (description "This package provides a library for creating importable
constants from build.rs or a script.")
    (license license:expat)))

(define-public rust-build-context-0.1
  (package
    (name "rust-build-context")
    (version "0.1.3")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "build-context" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0df98z2ky5d5jqiqhz8bpfv7cfh0vrlrsksp3finapflx6qhqqc6"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/taiki-e/build-context")
    (synopsis "Build environment/target information available in libraries")
    (description
     "Make build environment/target information available as constants in normal
libraries and binaries.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-build-fs-tree-0.6
  (package
    (name "rust-build-fs-tree")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "build-fs-tree" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "11j2gv00zz4hpcsrnw519svchn7fml1m4hndfm2qc30xvnd36s2c"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-clap" ,rust-clap-4)
                       ("rust-clap-utilities" ,rust-clap-utilities-0.2)
                       ("rust-derive-more" ,rust-derive-more-0.99)
                       ("rust-pipe-trait" ,rust-pipe-trait-0.4)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-serde-yaml" ,rust-serde-yaml-0.9)
                       ("rust-text-block-macros" ,rust-text-block-macros-0.1))))
    (home-page "https://github.com/KSXGitHub/build-fs-tree.git")
    (synopsis "Generate a filesystem tree from a macro or a YAML tree")
    (description "Generate a filesystem tree from a macro or a YAML tree.")
    (license license:expat)))

(define-public rust-built-0.7
  (package
    (name "rust-built")
    (version "0.7.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "built" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0fyhzjgymls3qylggd6rs4vkq44rkl1kyv33lfbfrdsjxmd50q63"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags '("--" "--skip=full_testbox")
       #:cargo-inputs (("rust-cargo-lock" ,rust-cargo-lock-10)
                       ("rust-chrono" ,rust-chrono-0.4)
                       ("rust-git2" ,rust-git2-0.19)
                       ("rust-semver" ,rust-semver-1))
       #:cargo-development-inputs (("rust-tempfile" ,rust-tempfile-3))))
    (native-inputs (list pkg-config))
    (inputs (list libgit2-1.8 zlib))
    (home-page "https://github.com/lukaslueg/built")
    (synopsis "Provides a crate with information from the time it was built")
    (description
     "This package provides a crate with information from the time it was built.")
    (license license:expat)))

(define-public rust-bumpalo-3
  (package
    (name "rust-bumpalo")
    (version "3.16.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bumpalo" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
          "0b015qb4knwanbdlp1x48pkb4pm57b8gidbhhhxr900q2wb6fabr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f                      ; Not all files included.
       #:cargo-inputs
       (("rust-allocator-api2" ,rust-allocator-api2-0.2))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-quickcheck" ,rust-quickcheck-1)
        ("rust-rand" ,rust-rand-0.8))))
    (home-page "https://github.com/fitzgen/bumpalo")
    (synopsis "Fast bump allocation arena for Rust")
    (description
     "This package provides a fast bump allocation arena for Rust.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-bv-0.11
  (package
    (name "rust-bv")
    (version "0.11.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bv" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0h5kbl54fsccznfixw83xndbripw39y2qkqjwf709p75iqfvnd48"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-feature-probe" ,rust-feature-probe-0.1)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.6))))
    (home-page "https://github.com/tov/bv-rs")
    (synopsis "Bit-vectors and bit-slices")
    (description "The main type exported by this library, @code{BitVec}, is a
packed, growable bit-vector.  Its API mirrors that of @code{Vec} where
reasonable.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bwrap-1
  (package
    (name "rust-bwrap")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bwrap" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "15dv9mawgmwgpj88k832qjdi94w70advg9zv28bpgig5k8qs6gfi"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-unicode-width" ,rust-unicode-width-0.1))))
    (home-page "https://github.com/micl2e2/bwrap")
    (synopsis "Embedded systems-friendly library for wrapping text")
    (description
     "This package provides a fast, lightweight, embedded systems-friendly
library for wrapping text.")
    (license (list license:expat license:gpl3+))))

(define-public rust-by-address-1
  (package
    (name "rust-by-address")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "by_address" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "01idmag3lcwnnqrnnyik2gmbrr34drsi97q15ihvcbbidf2kryk4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags '("--release" "--"
                            "--skip=tests::test_thin_ptr_fail")))
    (home-page "https://github.com/mbrubeck/by_address")
    (synopsis "Wrapper for comparing and hashing pointers by address")
    (description
     "This package provides Wrapper for comparing and hashing pointers by address.")
    (license (list license:expat license:asl2.0))))

(define-public rust-byte-slice-cast-1
  (package
    (name "rust-byte-slice-cast")
    (version "1.2.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "byte-slice-cast" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32 "033vv1qddzsj9yfsam4abj55rp60digngcr9a8wgv9pccf5rzb63"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags
       (list "--release" "--"
             ;; Some of the tests fail.
             "--skip=tests::u16_array")))
    (home-page "https://github.com/sdroege/byte-slice-cast")
    (synopsis
     "Safely cast bytes slices from/to slices of built-in fundamental numeric types")
    (description "This Rust library enables safely cast bytes slices from/to slices
of built-in fundamental numeric types.")
    (license license:expat)))

(define-public rust-byte-tools-0.3
  (package
    (name "rust-byte-tools")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "byte-tools" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1mqi29wsm8njpl51pfwr31wmpzs5ahlcb40wsjyd92l90ixcmdg3"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/RustCrypto/utils")
    (synopsis "Bytes related utility functions")
    (description "Bytes related utility functions.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-byte-unit-5
  (package
    (name "rust-byte-unit")
    (version "5.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "byte-unit" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0x3ifzw0isgsiffg4yhvqa28rzbyxpivy2bkph69n845qp1jkkg1"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-rocket" ,rust-rocket-0.5)
                       ("rust-rust-decimal" ,rust-rust-decimal-1)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-utf8-width" ,rust-utf8-width-0.1))
       #:cargo-development-inputs (("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://magiclen.org/byte-unit")
    (synopsis "Library for interaction with units of bytes")
    (description
     "This package provides a library for interaction with units of bytes.")
    (license license:expat)))

(define-public rust-byte-unit-4
  (package
    (inherit rust-byte-unit-5)
    (name "rust-byte-unit")
    (version "4.0.19")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "byte-unit" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0v4v4z8qilnbg0lv16icbbbdq5kjpbp8yw044lszrzdqawhb6y6s"))))
    (arguments
     `(#:cargo-inputs (("rust-serde" ,rust-serde-1)
                       ("rust-utf8-width" ,rust-utf8-width-0.1))))))

(define-public rust-bytecheck-0.6
  (package
    (name "rust-bytecheck")
    (version "0.6.12")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "bytecheck" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1hmipv4yyxgbamcbw5r65wagv9khs033v9483s9kri9sw9ycbk93"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; Not all files included.
       #:cargo-inputs
       (("rust-bytecheck-derive" ,rust-bytecheck-derive-0.6)
        ("rust-ptr-meta" ,rust-ptr-meta-0.1)
        ("rust-simdutf8" ,rust-simdutf8-0.1)
        ("rust-uuid" ,rust-uuid-1))))
    (home-page "https://github.com/rkyv/bytecheck")
    (synopsis "Type validation framework")
    (description "This package provides a type validation framework for
Rust.")
    (license license:expat)))

(define-public rust-bytecheck-0.5
  (package
    (inherit rust-bytecheck-0.6)
    (name "rust-bytecheck")
    (version "0.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bytecheck" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0q11ap6nqj0rsc8ypwjh918916zlrcrzdgqm175gnpb2yn9axyh1"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bytecheck-derive" ,rust-bytecheck-derive-0.5)
        ("rust-log" ,rust-log-0.4)
        ("rust-ptr-meta" ,rust-ptr-meta-0.1)
        ("rust-simdutf8" ,rust-simdutf8-0.1))))))

(define-public rust-bytecheck-derive-0.6
  (package
    (name "rust-bytecheck-derive")
    (version "0.6.12")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "bytecheck_derive" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0ng6230brd0hvqpbgcx83inn74mdv3abwn95x515bndwkz90dd1x"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/rkyv/bytecheck")
    (synopsis "Derive macro for bytecheck")
    (description "This package provides a Derive macro for bytecheck, the type
validation framework for Rust.")
    (license license:expat)))

(define-public rust-bytecheck-derive-0.5
  (package
    (inherit rust-bytecheck-derive-0.6)
    (name "rust-bytecheck-derive")
    (version "0.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bytecheck_derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0grbkwwv5j91n7zrimci6fh4k79flxga3mkjg50jysnyraizi088"))))
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))))

(define-public rust-bytecount-0.6
  (package
    (name "rust-bytecount")
    (version "0.6.8")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "bytecount" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1klqfjwn41fwmcqw4z03v6i4imgrf7lmf3b5s9v74hxir8hrps2w"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.4)
        ("rust-quickcheck" ,rust-quickcheck-1)
        ("rust-rand" ,rust-rand-0.8))))
    (home-page "https://github.com/llogiq/bytecount")
    (synopsis "Count occurrences of a given byte")
    (description
     "Count occurrences of a given byte, or the number of UTF-8 code points,
in a byte slice, fast.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-bytelines-2
  (package
    (name "rust-bytelines")
    (version "2.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bytelines" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1jxacxpb7v0qgh325s5b7mfk90fr63jpr90dar8m47r27imnb5qj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-tokio" ,rust-tokio-1))
       #:cargo-development-inputs
       (("rust-tokio" ,rust-tokio-1))))
    (home-page "https://github.com/whitfin/bytelines")
    (synopsis "Read input lines as byte slices for high efficiency")
    (description
     "This library provides an easy way to read in input lines as byte slices for
high efficiency.")
    (license license:expat)))

(define-public rust-bytemuck-1
  (package
    (name "rust-bytemuck")
    (version "1.20.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bytemuck" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0nk9llwmvjpjlsrlga1qg3spqvci8g1nr286nhamvn7zcf5chdwb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bytemuck-derive" ,rust-bytemuck-derive-1))))
    (home-page "https://github.com/Lokathor/bytemuck")
    (synopsis "Crate for mucking around with piles of bytes")
    (description
     "This package provides a crate for mucking around with piles of bytes.")
    (license license:zlib)))

(define-public rust-bytemuck-derive-1
  (package
    (name "rust-bytemuck-derive")
    (version "1.8.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bytemuck_derive" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1v5r33dgl12rqbvh440fdjxmxxr49qpzmg6vpw5jzdbcjk6w7z5w"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; unresolved import `bytemuck`
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-2))))
    (home-page "https://github.com/Lokathor/bytemuck")
    (synopsis "Derive proc-macros for @code{bytemuck}")
    (description
     "This package derives proc-macros for the @code{bytemuck} crate.")
    (license
      (list license:zlib license:asl2.0 license:expat))))

(define-public rust-byteorder-1
  (package
    (name "rust-byteorder")
    (version "1.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "byteorder" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0jzncxyf404mwqdbspihyzpkndfgda450l0893pz5xj685cg5l0z"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.9)
        ("rust-rand" ,rust-rand-0.7))))
    (home-page "https://github.com/BurntSushi/byteorder")
    (synopsis "Reading/writing numbers in big-endian and little-endian")
    (description
     "This library is used for reading or writing numbers in big-endian and
little-endian.")
    (license (list license:expat license:unlicense))))

(define-public rust-byteorder-0.5
  (package
    (inherit rust-byteorder-1)
    (name "rust-byteorder")
    (version "0.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "byteorder" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0ma8pkyz1jbglr29m1yzlc9ghmv6672nvsrn7zd0yn5jqs60xh8g"))))
    (arguments
     `(#:tests? #f
       #:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.2)
        ("rust-rand" ,rust-rand-0.3))))))

(define-public rust-byteorder-lite-0.1
  (package
    (name "rust-byteorder-lite")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "byteorder-lite" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "15alafmz4b9az56z6x7glcbcb6a8bfgyd109qc3bvx07zx4fj7wg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs (("rust-quickcheck" ,rust-quickcheck-0.9)
                                   ("rust-rand" ,rust-rand-0.7))))
    (home-page "https://github.com/image-rs/byteorder-lite")
    (synopsis
     "Library for reading/writing numbers in big-endian and little-endian")
    (description
     "This package provides a library for reading/writing numbers in big-endian
and little-endian.")
    (license (list license:unlicense license:expat))))

(define-public rust-bytes-1
  (package
    (name "rust-bytes")
    (version "1.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bytes" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "16ykzx24v1x4f42v2lxyvlczqhdfji3v7r4ghwckpwijzvb1hn9j"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-loom" ,rust-loom-0.7)
        ("rust-serde-test" ,rust-serde-test-1))))
    (home-page "https://github.com/tokio-rs/bytes")
    (synopsis "Types and traits for working with bytes")
    (description "This package is a utility library for working with bytes.")
    (license license:expat)))

(define-public rust-bytes-0.6
  (package
    (inherit rust-bytes-1)
    (name "rust-bytes")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bytes" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "05ivrcbgl4f7z2zzm9hbsi8cy66spi70xlm6fp16zsq4ylsvrp70"))))
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-loom" ,rust-loom-0.3)
        ("rust-serde-test" ,rust-serde-test-1))))))

(define-public rust-bytes-0.5
  (package
    (inherit rust-bytes-0.6)
    (name "rust-bytes")
    (version "0.5.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bytes" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0f5s7xq6qzmdh22ygsy8v0sp02m51y0radvq4i4y8cizy1lfqk0f"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-serde" ,rust-serde-1))))))

(define-public rust-bytes-0.4
  (package
    (inherit rust-bytes-0.5)
    (name "rust-bytes")
    (version "0.4.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bytes" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0768a55q2fsqdjsvcv98ndg9dq7w2g44dvq1avhwpxrdzbydyvr0"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1)
        ("rust-either" ,rust-either-1)
        ("rust-iovec" ,rust-iovec-0.1)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-serde-test" ,rust-serde-test-1))))))

(define-public rust-bytes-0.3
  (package
    (inherit rust-bytes-0.4)
    (name "rust-bytes")
    (version "0.3.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "bytes" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "09vcp9kh12pva2xn2ir79k90v1a0id8f4sdv1abn5ifw2bqsyaf1"))))
    (arguments
     `(#:tests? #f      ; Tests not distributed in crate.
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.3))))))

(define-public rust-bytesize-1
  (package
    (name "rust-bytesize")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bytesize" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1k3aak70iwz4s2gsjbxf0ws4xnixqbdz6p2ha96s06748fpniqx3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-toml" ,rust-toml-0.7))))
    (home-page "https://github.com/hyunsik/bytesize/")
    (synopsis "Human-readable byte count representation library for Rust")
    (description "ByteSize is an utility for human-readable byte count
representation, with support for both SI and binary units.")
    (license license:asl2.0)))

(define-public rust-bytestring-1
  (package
    (name "rust-bytestring")
    (version "1.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bytestring" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0pwf6x2hxy6imy7ph15c5jxx51js5p5xwl1zfnq26a1vw9x68rg4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-bytes" ,rust-bytes-1)
                       ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-ahash" ,rust-ahash-0.8)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-static-assertions" ,rust-static-assertions-1))))
    (home-page "https://actix.rs")
    (synopsis "UTF-8 encoded string with Bytes as a storage")
    (description "This package provides a UTF-8 encoded read-only string using
`Bytes` as storage.")
    (license (list license:expat license:asl2.0))))

(define-public rust-bytestring-0.1
  (package
    (inherit rust-bytestring-1)
    (name "rust-bytestring")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "bytestring" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0qzkncgky5p5vsdb9msmfg6d92dcs9idcjcr5nk7inkja7x0az7w"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bytes" ,rust-bytes-0.5)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-byteyarn-0.2
  (package
    (name "rust-byteyarn")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "byteyarn" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1zs2r5qiqwhd6fj7bqg8ziha63sbggy5xmq6vfsan5zaq00l6lx7"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/mcy/byteyarn")
    (synopsis "Hyper-compact strings")
    (description "Hyper-compact and space efficient strings.")
    (license license:asl2.0)))

(define-public rust-c-vec-2
  (package
    (name "rust-c-vec")
    (version "2.0.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "c_vec" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32 "1s765fviy10q27b0wmkyk4q728z9v8v5pdlxv5k564y0mlks9mzx"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-doc-comment" ,rust-doc-comment-0.3)
        ("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/GuillaumeGomez/c_vec-rs.git")
    (synopsis "Structures to wrap C arrays")
    (description "This package provides structures to wrap C arrays in Rust.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-cache-padded-1
  (package
    (name "rust-cache-padded")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cache-padded" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "08gb1407k0cvhfllgg06j45r0lv99qrmraf19mccqbs2iz4j05cq"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/stjepang/cache-padded")
    (synopsis "Prevent once piece of data invalidating other cached data")
    (description
     "In concurrent programming, sometimes it is desirable to make sure
commonly accessed shared data is not all placed into the same cache line.
Updating an atomic value invalides the whole cache line it belongs to, which
makes the next access to the same cache line slower for other CPU cores.  Use
CachePadded to ensure updating one piece of data doesn't invalidate other
cached data.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-cachedir-0.3
  (package
    (name "rust-cachedir")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cachedir" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0wyqx30crm2qsq4ny57hhljyq6iw6j4qfg7fbfiqznvpf29z60s7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/jstasiak/cachedir")
    (synopsis "Interact with cache directories and @file{CACHEDIR.TAG} files")
    (description
     "This package provides a library to help interacting with cache
directories and @file{CACHEDIR.TAG} files as defined by the Cache Directory
Tagging Specification.  This library comes with functionality to, among
others, add a tag, ensure/check a tag exists and get the state of a tag.")
    (license license:expat)))

(define-public rust-calamine-0.26
  (package
    (name "rust-calamine")
    (version "0.26.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "calamine" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1cbfjwb37c28gkb42wsgpp93fxsrzhxgjjza0hc7yp9cmywld1hk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; Doc tests segfault.
       #:cargo-inputs (("rust-byteorder" ,rust-byteorder-1)
                       ("rust-chrono" ,rust-chrono-0.4)
                       ("rust-codepage" ,rust-codepage-0.1)
                       ("rust-encoding-rs" ,rust-encoding-rs-0.8)
                       ("rust-log" ,rust-log-0.4)
                       ("rust-quick-xml" ,rust-quick-xml-0.31)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-zip" ,rust-zip-2))
       #:cargo-development-inputs (("rust-env-logger" ,rust-env-logger-0.11)
                                   ("rust-glob" ,rust-glob-0.3)
                                   ("rust-rstest" ,rust-rstest-0.21)
                                   ("rust-serde-derive" ,rust-serde-derive-1)
                                   ("rust-sha2" ,rust-sha2-0.10))))
    (home-page "https://github.com/tafia/calamine")
    (synopsis "Reader and deserializer for spreadsheet files")
    (description
     "@code{calamine} is a pure Rust library to read and deserialize any
spreadsheet file.")
    (license license:expat)))

(define-public rust-calibright-0.1
  (package
    (name "rust-calibright")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "calibright" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1pqyr6zbgqpxyhszgkvmi1y0hnqrd1nnghxds62z125zkv7ygmsq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-dirs" ,rust-dirs-5)
                       ("rust-futures" ,rust-futures-0.3)
                       ("rust-log" ,rust-log-0.4)
                       ("rust-notify" ,rust-notify-6)
                       ("rust-regex" ,rust-regex-1)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-smart-default" ,rust-smart-default-0.7)
                       ("rust-thiserror" ,rust-thiserror-1)
                       ("rust-tokio" ,rust-tokio-1)
                       ("rust-toml" ,rust-toml-0.8)
                       ("rust-zbus" ,rust-zbus-3))))
    (home-page "https://github.com/bim9262/calibright")
    (synopsis "Brightness utility with calibration between monitors")
    (description
     "This package provides a brightness utility that allows you to calibrate
brightness between monitors.")
    (license license:gpl3)))

(define-public rust-calloop-0.13
  (package
    (name "rust-calloop")
    (version "0.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "calloop" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1v5zgidnhsyml403rzr7vm99f8q6r5bxq5gxyiqkr8lcapwa57dr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-async-task" ,rust-async-task-4)
                       ("rust-bitflags" ,rust-bitflags-2)
                       ("rust-futures-io" ,rust-futures-io-0.3)
                       ("rust-log" ,rust-log-0.4)
                       ("rust-nix" ,rust-nix-0.28)
                       ("rust-pin-utils" ,rust-pin-utils-0.1)
                       ("rust-polling" ,rust-polling-3)
                       ("rust-rustix" ,rust-rustix-0.38)
                       ("rust-slab" ,rust-slab-0.4)
                       ("rust-thiserror" ,rust-thiserror-1))
       #:cargo-development-inputs (("rust-futures" ,rust-futures-0.3)
                                   ("rust-rustix" ,rust-rustix-0.38))))
    (home-page "https://github.com/Smithay/calloop")
    (synopsis "Callback-based event loop")
    (description "This package provides a callback-based event loop.")
    (license license:expat)))

(define-public rust-calloop-0.12
  (package
    (inherit rust-calloop-0.13)
    (name "rust-calloop")
    (version "0.12.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "calloop" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1gxd20zpys0q4v9fg3nrkyhrnjgpkgriidgfm5aqraar9njbal3v"))))
    (arguments
     `(#:cargo-inputs (("rust-async-task" ,rust-async-task-4)
                       ("rust-bitflags" ,rust-bitflags-2)
                       ("rust-futures-io" ,rust-futures-io-0.3)
                       ("rust-log" ,rust-log-0.4)
                       ("rust-nix" ,rust-nix-0.26)
                       ("rust-pin-utils" ,rust-pin-utils-0.1)
                       ("rust-polling" ,rust-polling-3)
                       ("rust-rustix" ,rust-rustix-0.38)
                       ("rust-slab" ,rust-slab-0.4)
                       ("rust-thiserror" ,rust-thiserror-1))
       #:cargo-development-inputs (("rust-futures" ,rust-futures-0.3)
                                   ("rust-rustix" ,rust-rustix-0.38))))))

(define-public rust-calloop-0.10
  (package
    (inherit rust-calloop-0.12)
    (name "rust-calloop")
    (version "0.10.5")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "calloop" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "14h1yjksd8kakbd4xqz9xjc2gsa97rsdj5g05ivqsisswidj4n8s"))))
    (arguments
     `(#:cargo-test-flags
       (list "--release" "--"
             ;; Some of the tests fail.
             "--skip=loop_logic::tests::insert_source_no_interest")
       #:cargo-inputs
       (("rust-futures-io" ,rust-futures-io-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-nix" ,rust-nix-0.25)
        ("rust-slotmap" ,rust-slotmap-1)
        ("rust-thiserror" ,rust-thiserror-1)
        ("rust-vec-map" ,rust-vec-map-0.8))
       #:cargo-development-inputs (("rust-futures" ,rust-futures-0.3))))))

(define-public rust-calloop-0.9
  (package
    (inherit rust-calloop-0.10)
    (name "rust-calloop")
    (version "0.9.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "calloop" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "10mbcsd7fj3cg0a463h3003wycv955cnj4pm2gla2sp5xxhyqbmz"))))
    (arguments
     `(#:tests? #f ;XXX fails without stdin, fixed in 0.11
       #:cargo-inputs
       (("rust-futures-io" ,rust-futures-io-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-nix" ,rust-nix-0.22))
       #:cargo-development-inputs
       (("rust-futures" ,rust-futures-0.3))))))

(define-public rust-calloop-0.6
  (package
    (inherit rust-calloop-0.9)
    (name "rust-calloop")
    (version "0.6.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "calloop" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0z3jlsv3g28097dhsmi2l8nzkd3p937jhb4pg52njhb0wxkn20qb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-log" ,rust-log-0.4)
        ("rust-nix" ,rust-nix-0.18))))))

(define-public rust-calloop-0.4
  (package
    (inherit rust-calloop-0.6)
    (name "rust-calloop")
    (version "0.4.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "calloop" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0q6ic9lr0s86886mbyn4yncg68b2sykgwjf3iygdw01swmxhk8ks"))
        (modules '((guix build utils)))
        (snippet
         '(begin
            (substitute* "Cargo.toml"
              (("=1.0.0") "^1.0.0"))
            #t))))
    (arguments
     `(#:cargo-inputs
       (("rust-mio" ,rust-mio-0.6)
        ("rust-mio-extras" ,rust-mio-extras-2)
        ("rust-nix" ,rust-nix-0.14))
       #:cargo-development-inputs
       (("rust-lazycell" ,rust-lazycell-1))))))

(define-public rust-calloop-wayland-source-0.3
  (package
    (name "rust-calloop-wayland-source")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "calloop-wayland-source" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "086x5mq16prrcwd9k6bw9an0sp8bj9l5daz4ziz5z4snf2c6m9lm"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-calloop" ,rust-calloop-0.13)
                       ("rust-log" ,rust-log-0.4)
                       ("rust-rustix" ,rust-rustix-0.38)
                       ("rust-wayland-backend" ,rust-wayland-backend-0.3)
                       ("rust-wayland-client" ,rust-wayland-client-0.31))
       #:cargo-development-inputs
       (("rust-tempfile" ,rust-tempfile-3)
        ("rust-wayland-protocols" ,rust-wayland-protocols-0.31))))
    (home-page "https://github.com/smithay/calloop-wayland-source")
    (synopsis "Wayland-rs client event source for callloop")
    (description
     "This package provides a wayland-rs client event source for callloop.")
    (license license:expat)))

(define-public rust-calloop-wayland-source-0.2
  (package
    (inherit rust-calloop-wayland-source-0.3)
    (name "rust-calloop-wayland-source")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "calloop-wayland-source" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "00lgxlqnkd150ylfn3wi4464ibif1qwbp38shj1aszvc8ywsj3hg"))))
    (arguments
     `(#:cargo-inputs (("rust-calloop" ,rust-calloop-0.12)
                       ("rust-log" ,rust-log-0.4)
                       ("rust-rustix" ,rust-rustix-0.38)
                       ("rust-wayland-backend" ,rust-wayland-backend-0.3)
                       ("rust-wayland-client" ,rust-wayland-client-0.31))
       #:cargo-development-inputs
       (("rust-tempfile" ,rust-tempfile-3)
        ("rust-wayland-protocols" ,rust-wayland-protocols-0.31))))))

(define-public rust-camino-1
  (package
    (name "rust-camino")
    (version "1.1.9")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "camino" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1lqszl12l1146jf8g01rvjmapif82mhzih870ln3x0dmcr4yr5lb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-proptest" ,rust-proptest-1)
                       ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs (("rust-bincode" ,rust-bincode-1)
                                   ("rust-serde-bytes" ,rust-serde-bytes-0.11))))
    (home-page "https://github.com/camino-rs/camino")
    (synopsis "UTF-8 paths")
    (description "This package provides a UTF-8 paths.")
    (license (list license:expat license:asl2.0))))

(define-public rust-canonical-path-2
  (package
    (name "rust-canonical-path")
    (version "2.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "canonical-path" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0vvsjda6ka5nz8zvx6r08zqi0j59sjccgcbjxj96xj764w9y1sg6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs (("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/iqlusioninc/crates/")
    (synopsis
     "Path and PathBuf-like types for representing canonical filesystem paths")
    (description
     "This package provides Path and @code{PathBuf-like} types for representing
canonical filesystem paths.")
    (license license:asl2.0)))

(define-public rust-cap-0.1
  (package
    (name "rust-cap")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cap" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "00q00chl1y8j6p9f9rndnd9jyqyqklnd5l9fn0v4r8l4bfw5w4kg"))))
    (build-system cargo-build-system)
    (arguments
     (list #:tests? #f))    ; memory allocation of 48 bytes failed
    (home-page "https://github.com/alecmocatta/cap")
    (synopsis "Allocator that can track and limit memory usage")
    (description
     "This crate provides a generic allocator that wraps another allocator,
tracking memory usage and enabling limits to be set.")
    (license (list license:expat license:asl2.0))))

(define-public rust-capnp-0.19
  (package
    (name "rust-capnp")
    (version "0.19.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "capnp" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1v90fxhhwgcszxday345rmjp3nicpnbvshnccd55qsbszgk3465i"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-embedded-io" ,rust-embedded-io-0.6)
                       ("rust-quickcheck" ,rust-quickcheck-1))
       #:cargo-development-inputs (("rust-quickcheck" ,rust-quickcheck-1))))
    (home-page "https://github.com/capnproto/capnproto-rust")
    (synopsis "Runtime library for Cap'n Proto data encoding")
    (description "This package provides a runtime library for Cap'n Proto data
encoding.")
    (license license:expat)))

(define-public rust-capnp-futures-0.19
  (package
    (name "rust-capnp-futures")
    (version "0.19.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "capnp-futures" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "06zvxipmy0xdsxxqr54gs4yi8rgl33iprfhx4nzc0fsfncy4ib2z"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-capnp" ,rust-capnp-0.19)
                       ("rust-futures" ,rust-futures-0.3))
       #:cargo-development-inputs (("rust-capnp" ,rust-capnp-0.19)
                                   ("rust-futures" ,rust-futures-0.3)
                                   ("rust-quickcheck" ,rust-quickcheck-1))))
    (home-page "https://github.com/dwrensha/capnproto-rust")
    (synopsis "Async serialization for Cap'n Proto messages")
    (description "This package provides async serialization for Cap'n Proto
messages.")
    (license license:expat)))

(define-public rust-capnp-rpc-0.19
  (package
    (name "rust-capnp-rpc")
    (version "0.19.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "capnp-rpc" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "05hahpmfjnn49mzv4b2zp4y6si9g6yvjy6kgm2ia9apndjcbl78p"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-capnp" ,rust-capnp-0.19)
                       ("rust-capnp-futures" ,rust-capnp-futures-0.19)
                       ("rust-futures" ,rust-futures-0.3))))
    (native-inputs (list capnproto))
    (home-page "https://github.com/capnproto/capnproto-rust")
    (synopsis "Cap'n Proto remote procedure call protocol implementation")
    (description "This package provides an implementation of the Cap'n Proto
remote procedure call protocol")
    (license license:expat)))

(define-public rust-capnpc-0.19
  (package
    (name "rust-capnpc")
    (version "0.19.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "capnpc" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1v49w7zsv4bkdn88dfmi2hk5dzv5pgs0qwgkq99jsn081w7a6ny7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags '("--release" "--"
                            "--skip=compiler_command_new_no_out_dir")
       #:cargo-inputs (("rust-capnp" ,rust-capnp-0.19))))
    (home-page "https://github.com/capnproto/capnproto-rust")
    (synopsis "Cap'n Proto code generation")
    (description "Cap'n Proto code generation.")
    (license license:expat)))

(define-public rust-caps-0.5
  (package
    (name "rust-caps")
    (version "0.5.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "caps" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "02vk0w48rncgvfmj2mz2kpzvdgc14z225451w7lvvkwvaansl2qr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-serde" ,rust-serde-1)
        ("rust-thiserror" ,rust-thiserror-1))
       #:cargo-development-inputs (("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/lucab/caps-rs")
    (synopsis "Pure Rust library to work with Linux capabilities")
    (description
     "This package provides a pure-Rust library to work with Linux
capabilities.")
    (license (list license:expat license:asl2.0))))

(define-public rust-caps-0.3
  (package
    (inherit rust-caps-0.5)
    (name "rust-caps")
    (version "0.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "caps" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "071xv18dxfvmifs3dpbmqy91cm55i9mh7w2zahg9yh3z3y566smz"))))
    (arguments
     `(#:cargo-inputs
       (("rust-errno" ,rust-errno-0.2)
        ("rust-error-chain" ,rust-error-chain-0.12)
        ("rust-libc" ,rust-libc-0.2))))))

(define-public rust-captur-0.1
  (package
    (name "rust-captur")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "captur" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "10mi8mz5l9wq6pv1p26237pw4bywn90nra076ghh4ini90jv7ykh"))
       (snippet
        #~(begin (use-modules (guix build utils))
                 (substitute* "src/lib.rs"
                   (("or_patterns_back_compat")
                    "rust_2021_incompatible_or_patterns"))))))
    (build-system cargo-build-system)
    (arguments
     (list #:tests? #f))    ; `pointer_structural_match` converted into hard error
    (home-page "https://github.com/MitMaro/captur")
    (synopsis "Macro to capture whole structs from disjoint fields in a closure")
    (description
     "This package provides a macro to capture whole structs from disjoint
fields in a closure.")
    (license license:isc)))

(define-public rust-carapace-spec-clap-1
  (package
    (name "rust-carapace-spec-clap")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "carapace_spec_clap" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "08w08n7vbi8wjvivllayzpggn6c0vpax2101hc8gp9xd385q39h9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-clap" ,rust-clap-4)
                       ("rust-clap-complete" ,rust-clap-complete-4)
                       ("rust-indexmap" ,rust-indexmap-2)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-serde-yaml-ng" ,rust-serde-yaml-ng-0.10))
       #:cargo-development-inputs (("rust-snapbox" ,rust-snapbox-0.6))))
    (home-page "https://github.com/carapace-sh/carapace-spec-clap")
    (synopsis "Spec generation for clap-rs/clap")
    (description "This package provides spec generation for clap-rs/clap.")
    (license license:expat)))

(define-public rust-carapace-spec-clap-0.1
  (package
    (inherit rust-carapace-spec-clap-1)
    (name "rust-carapace-spec-clap")
    (version "0.1.12")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "carapace_spec_clap" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1pb140siiqbljpvpck5hldmfyadi3db3s8xhcqnf9ff2ln3bs9zf"))))
    (arguments
     `(#:cargo-inputs
       (("rust-clap" ,rust-clap-4)
        ("rust-clap-complete" ,rust-clap-complete-4)
        ("rust-indexmap" ,rust-indexmap-2)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-yaml" ,rust-serde-yaml-0.9))
       #:cargo-development-inputs (("rust-snapbox" ,rust-snapbox-0.4))))))

(define-public rust-card-validate-2
  (package
    (name "rust-card-validate")
    (version "2.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "card-validate" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "14gbz65z79n1xjxmh5fr8g6djshnq2g49i60q1r878z2jq2sfpv5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-lazy-static" ,rust-lazy-static-1)
                       ("rust-regex" ,rust-regex-1))))
    (home-page "https://github.com/valeriansaliou/rs-card-validate")
    (synopsis "Detect and validate credit card numbers")
    (description "This package detects and validates credit card numbers.")
    (license license:expat)))

(define-public rust-cargo-config2-0.1
  (package
    (name "rust-cargo-config2")
    (version "0.1.31")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "cargo-config2" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1ws69v398i48f2a1n4gfrcpxh0j0d08mj9c24llw1wlkrdyp7als"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags
       '("--"
         "--skip=custom_target"
         "--skip=de"
         "--skip=easy"
         "--skip=test_cargo_behavior")
       #:cargo-inputs
       (("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-toml-edit" ,rust-toml-edit-0.22)
        ("rust-windows-sys" ,rust-windows-sys-0.59))
       #:cargo-development-inputs
       (("rust-anyhow" ,rust-anyhow-1)
        ("rust-build-context" ,rust-build-context-0.1)
        ("rust-clap" ,rust-clap-4)
        ("rust-fs-err" ,rust-fs-err-3)
        ("rust-lexopt" ,rust-lexopt-0.3)
        ("rust-rustversion" ,rust-rustversion-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-shell-escape" ,rust-shell-escape-0.1)
        ("rust-static-assertions" ,rust-static-assertions-1)
        ("rust-tempfile" ,rust-tempfile-3)
        ("rust-toml" ,rust-toml-0.8))))
    (home-page "https://github.com/taiki-e/cargo-config2")
    (synopsis "Load and resolve Cargo configuration")
    (description "Load and resolve Cargo configuration.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-cargo-credential-0.4
  (package
    (name "rust-cargo-credential")
    (version "0.4.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cargo-credential" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1kf4s49b7xrsy658k5jsm1wwrv4iqj42amcgskpwpskhari7qgis"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-anyhow" ,rust-anyhow-1)
                       ("rust-libc" ,rust-libc-0.2)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-serde-json" ,rust-serde-json-1)
                       ("rust-thiserror" ,rust-thiserror-1)
                       ("rust-time" ,rust-time-0.3)
                       ("rust-windows-sys" ,rust-windows-sys-0.52))
       #:cargo-development-inputs (("rust-snapbox" ,rust-snapbox-0.6))))
    (home-page "https://github.com/rust-lang/cargo")
    (synopsis "Library to assist writing Cargo credential helpers")
    (description
     "This package provides a library to assist writing Cargo credential helpers.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cargo-credential-0.3
  (package
    (inherit rust-cargo-credential-0.4)
    (name "rust-cargo-credential")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cargo-credential" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1da8gx0lv4bkr3g070533mvyl638bviv506v8791archyy3nqv32"))))
    (arguments
     `(#:cargo-inputs
       (("rust-anyhow" ,rust-anyhow-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-thiserror" ,rust-thiserror-1)
        ("rust-time" ,rust-time-0.3)
        ("rust-windows-sys" ,rust-windows-sys-0.48))
       #:cargo-development-inputs
       (("rust-snapbox" ,rust-snapbox-0.4))))))

(define-public rust-cargo-credential-libsecret-0.4
  (package
    (name "rust-cargo-credential-libsecret")
    (version "0.4.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cargo-credential-libsecret" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "14v1rnk4pwsfqipllnlkb9vcf1xaj51mpw6i5l0mji82qhidv0vz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-anyhow" ,rust-anyhow-1)
                       ("rust-cargo-credential" ,rust-cargo-credential-0.4)
                       ("rust-libloading" ,rust-libloading-0.8))))
    (home-page "https://github.com/rust-lang/cargo")
    (synopsis "Cargo credential process that stores tokens with GNOME libsecret")
    (description
     "This package provides a Cargo credential process that stores tokens with
GNOME libsecret.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cargo-husky-1
  (package
    (name "rust-cargo-husky")
    (version "1.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cargo-husky" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1b9jx720dzw9s7rl82bywz4d089c9rb0j526c1jfzs1g4llvc0kv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; Not all files included.
       #:cargo-development-inputs (("rust-lazy-static" ,rust-lazy-static-1)
                                   ("rust-libc" ,rust-libc-0.2)
                                   ("rust-semver" ,rust-semver-0.9))))
    (home-page "https://github.com/rhysd/cargo-husky#readme")
    (synopsis "Autotest support with git hooks")
    (description "Cargo-husky is a development tool to set Git hooks
automatically on cargo test.")
    (license license:expat)))

(define-public rust-cargo-lock-10
  (package
    (name "rust-cargo-lock")
    (version "10.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cargo-lock" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0ldm8nd05cwyc2y0wwbdwx51g5phylkffaycpc2xa8kh01npfsb4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-gumdrop" ,rust-gumdrop-0.8)
                       ("rust-petgraph" ,rust-petgraph-0.6)
                       ("rust-semver" ,rust-semver-1)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-toml" ,rust-toml-0.8)
                       ("rust-url" ,rust-url-2))))
    (home-page "https://rustsec.org")
    (synopsis "@file{Cargo.lock} parser with optional dependency graph analysis")
    (description
     "This package provides self-contained @file{Cargo.lock} parser with
optional dependency graph analysis.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-cargo-manifest-0.13
  (package
    (name "rust-cargo-manifest")
    (version "0.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cargo-manifest" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "13a0dgqchxjmhr4idswpri2l3lwv7fxga69yj5hvylla0adg8vxz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-serde" ,rust-serde-1)
                       ("rust-thiserror" ,rust-thiserror-1)
                       ("rust-toml" ,rust-toml-0.8))
       #:cargo-development-inputs (("rust-insta" ,rust-insta-1))))
    (home-page "https://github.com/LukeMathWalker/cargo-manifest")
    (synopsis "Parse and manipulate manifests @code{Cargo.toml} files")
    (description "This package provides a helper crate to parse and manipulate
manifests in @code{Cargo.toml} files.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-cargo-metadata-0.19
  (package
    (name "rust-cargo-metadata")
    (version "0.19.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cargo_metadata" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "096r6ai6b8r6z42lasr16pd0zbgndvs7n6a3mwh636axmmm70sc7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags '("--"
                            "--skip=error1"
                            "--skip=error2"
                            "--skip=advanced_feature_configuration"
                            "--skip=all_the_fields"
                            "--skip=basic_workspace_root_package_exists"
                            "--skip=current_dir")
       #:cargo-inputs (("rust-camino" ,rust-camino-1)
                       ("rust-cargo-platform" ,rust-cargo-platform-0.1)
                       ("rust-derive-builder" ,rust-derive-builder-0.20)
                       ("rust-semver" ,rust-semver-1)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-serde-json" ,rust-serde-json-1)
                       ("rust-thiserror" ,rust-thiserror-2))))
    (home-page "https://github.com/oli-obk/cargo_metadata")
    (synopsis "Structured access to the output of `cargo metadata`")
    (description
     "This package provides structured access to the output of @code{cargo
metadata}.")
    (license license:expat)))

(define-public rust-cargo-metadata-0.18
  (package
    (inherit rust-cargo-metadata-0.19)
    (name "rust-cargo-metadata")
    (version "0.18.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cargo_metadata" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0drh0zndl4qgndy6kg6783cydbvhxgv0hcg7d9hhqx0zwi3nb21d"))))
    (arguments
     `(#:cargo-test-flags
       '("--release" "--"
         "--skip=advanced_feature_configuration"
         "--skip=all_the_fields"
         "--skip=basic_workspace_root_package_exists"
         "--skip=current_dir")
       #:cargo-inputs (("rust-camino" ,rust-camino-1)
                       ("rust-cargo-platform" ,rust-cargo-platform-0.1)
                       ("rust-derive-builder" ,rust-derive-builder-0.12)
                       ("rust-semver" ,rust-semver-1)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-serde-json" ,rust-serde-json-1)
                       ("rust-thiserror" ,rust-thiserror-1))))))

(define-public rust-cargo-metadata-0.17
  (package
    (inherit rust-cargo-metadata-0.18)
    (name "rust-cargo-metadata")
    (version "0.17.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cargo_metadata" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "14mmaq058nncdy3xdgylnnq3gibycjs21cj42sxfwa9158dfrnp7"))))
    (arguments
     `(#:cargo-test-flags
       '("--release" "--"
         ;; Not all files included.
         "--skip=advanced_feature_configuration"
         "--skip=all_the_fields"
         "--skip=basic_workspace_root_package_exists"
         "--skip=current_dir")
       #:cargo-inputs (("rust-camino" ,rust-camino-1)
                       ("rust-cargo-platform" ,rust-cargo-platform-0.1)
                       ("rust-derive-builder" ,rust-derive-builder-0.12)
                       ("rust-semver" ,rust-semver-1)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-serde-json" ,rust-serde-json-1)
                       ("rust-thiserror" ,rust-thiserror-1))))))

(define-public rust-cargo-metadata-0.15
  (package
    (inherit rust-cargo-metadata-0.18)
    (name "rust-cargo-metadata")
    (version "0.15.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cargo_metadata" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0fm767r349p5rh50k21g8w2hpcg2970kjx0ff517mz163wzj9r7f"))))
    (arguments
     `(#:cargo-test-flags
       '("--release" "--"
         ;; Not all files included.
         "--skip=advanced_feature_configuration"
         "--skip=all_the_fields"
         "--skip=basic_workspace_root_package_exists"
         "--skip=current_dir")
       #:cargo-inputs
       (("rust-camino" ,rust-camino-1)
        ("rust-cargo-platform" ,rust-cargo-platform-0.1)
        ("rust-derive-builder" ,rust-derive-builder-0.11)
        ("rust-semver" ,rust-semver-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-thiserror" ,rust-thiserror-1))))))

(define-public rust-cargo-metadata-0.14
  (package
    (inherit rust-cargo-metadata-0.15)
    (name "rust-cargo-metadata")
    (version "0.14.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cargo_metadata" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1yl1y40vby9cas4dlfc44szrbl4m4z3pahv3p6ckdqp8ksfv1jsa"))))
    (arguments
     `(#:cargo-test-flags
       '("--release" "--"
         ;; Not all files included.
         "--skip=advanced_feature_configuration"
         "--skip=all_the_fields"
         "--skip=current_dir")
       #:cargo-inputs
       (("rust-camino" ,rust-camino-1)
        ("rust-cargo-platform" ,rust-cargo-platform-0.1)
        ("rust-derive-builder" ,rust-derive-builder-0.9)
        ("rust-semver" ,rust-semver-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-cargo-options-0.7
  (package
    (name "rust-cargo-options")
    (version "0.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cargo-options" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1sknbp83h15da5zmkk9q9vgpw9qzwiz2sizkiv9bkrf8jvwipmya"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-anstyle" ,rust-anstyle-1)
                       ("rust-clap" ,rust-clap-4))
       #:cargo-development-inputs (("rust-trycmd" ,rust-trycmd-0.14))))
    (home-page "https://github.com/messense/cargo-options")
    (synopsis "Reusable common Cargo command line options")
    (description "Reusable common Cargo command line options.")
    (license license:expat)))

(define-public rust-cargo-platform-0.1
  (package
    (name "rust-cargo-platform")
    (version "0.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cargo-platform" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0ga4qa3fx4bidnmix5gl8qclx2mma1a441swlpfsa645kpv8xvff"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/rust-lang/cargo")
    (synopsis "Target platform abstraction for Cargo")
    (description "This package provides abstractions for the target platforms
supported by Cargo.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cargo-test-macro-0.3
  (package
    (name "rust-cargo-test-macro")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cargo-test-macro" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "15n83v5ffz4p3mjd03hwqlyaawp59bqwdg2amk3i45h6s5743flj"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/rust-lang/cargo")
    (synopsis "Helper proc-macro for Cargo's testsuite")
    (description
     "This package provides a helper proc-macro for Cargo's testsuite.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cargo-test-support-0.4
  (package
    (name "rust-cargo-test-support")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cargo-test-support" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0z8gc10ylqpk5ap6lv4l46ngqmqfh9lz5n5sgjlrkhl2nk3k3m8i"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-anstream" ,rust-anstream-0.6)
                       ("rust-anstyle" ,rust-anstyle-1)
                       ("rust-anyhow" ,rust-anyhow-1)
                       ("rust-cargo-test-macro" ,rust-cargo-test-macro-0.3)
                       ("rust-cargo-util" ,rust-cargo-util-0.2)
                       ("rust-crates-io" ,rust-crates-io-0.40)
                       ("rust-filetime" ,rust-filetime-0.2)
                       ("rust-flate2" ,rust-flate2-1)
                       ("rust-git2" ,rust-git2-0.19)
                       ("rust-glob" ,rust-glob-0.3)
                       ("rust-itertools" ,rust-itertools-0.13)
                       ("rust-pasetors" ,rust-pasetors-0.6)
                       ("rust-regex" ,rust-regex-1)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-serde-json" ,rust-serde-json-1)
                       ("rust-snapbox" ,rust-snapbox-0.6)
                       ("rust-tar" ,rust-tar-0.4)
                       ("rust-time" ,rust-time-0.3)
                       ("rust-toml" ,rust-toml-0.8)
                       ("rust-url" ,rust-url-2)
                       ("rust-walkdir" ,rust-walkdir-2)
                       ("rust-windows-sys" ,rust-windows-sys-0.59))))
    (native-inputs (list pkg-config))
    (inputs (list curl libgit2-1.8 libssh2 openssl zlib))
    (home-page "https://github.com/rust-lang/cargo")
    (synopsis "Testing framework for Cargo's testsuite")
    (description
     "This package provides a testing framework for Cargo's testsuite.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cargo-test-support-0.3
  (package
    (inherit rust-cargo-test-support-0.4)
    (name "rust-cargo-test-support")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cargo-test-support" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1fi7k976v9ali7i9a11wz3czcbp2ksc8p8kcq14b57vrci3bc5m8"))))
    (arguments
     `(#:cargo-inputs (("rust-anstream" ,rust-anstream-0.6)
                       ("rust-anstyle" ,rust-anstyle-1)
                       ("rust-anyhow" ,rust-anyhow-1)
                       ("rust-cargo-test-macro" ,rust-cargo-test-macro-0.3)
                       ("rust-cargo-util" ,rust-cargo-util-0.2)
                       ("rust-crates-io" ,rust-crates-io-0.40)
                       ("rust-filetime" ,rust-filetime-0.2)
                       ("rust-flate2" ,rust-flate2-1)
                       ("rust-git2" ,rust-git2-0.19)
                       ("rust-glob" ,rust-glob-0.3)
                       ("rust-itertools" ,rust-itertools-0.13)
                       ("rust-pasetors" ,rust-pasetors-0.6)
                       ("rust-regex" ,rust-regex-1)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-serde-json" ,rust-serde-json-1)
                       ("rust-snapbox" ,rust-snapbox-0.6)
                       ("rust-tar" ,rust-tar-0.4)
                       ("rust-time" ,rust-time-0.3)
                       ("rust-toml" ,rust-toml-0.8)
                       ("rust-url" ,rust-url-2)
                       ("rust-walkdir" ,rust-walkdir-2)
                       ("rust-windows-sys" ,rust-windows-sys-0.52))))))

(define-public rust-cargo-toml-0.20
  (package
    (name "rust-cargo-toml")
    (version "0.20.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cargo_toml" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1h0srl8n4s0xs6bq9z9zpkni3brzkkm0fmw4g00cmd10qq9mmnl8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-serde" ,rust-serde-1)
                       ("rust-toml" ,rust-toml-0.8))))
    (home-page "https://lib.rs/cargo_toml")
    (synopsis "`Cargo.toml` struct definitions for parsing with Serde")
    (description "This package provides `Cargo.toml` struct definitions for
parsing with Serde.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-cargo-util-0.2
  (package
    (name "rust-cargo-util")
    (version "0.2.15")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cargo-util" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "08mi6jsxbf9s2q40bxm2jws4bx5hyk5vca41l1h55jir8ji6gpdn"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-anyhow" ,rust-anyhow-1)
        ("rust-core-foundation" ,rust-core-foundation-0.9)
        ("rust-filetime" ,rust-filetime-0.2)
        ("rust-hex" ,rust-hex-0.4)
        ("rust-ignore" ,rust-ignore-0.4)
        ("rust-jobserver" ,rust-jobserver-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-miow" ,rust-miow-0.6)
        ("rust-same-file" ,rust-same-file-1)
        ("rust-sha2" ,rust-sha2-0.10)
        ("rust-shell-escape" ,rust-shell-escape-0.1)
        ("rust-tempfile" ,rust-tempfile-3)
        ("rust-tracing" ,rust-tracing-0.1)
        ("rust-walkdir" ,rust-walkdir-2)
        ("rust-windows-sys" ,rust-windows-sys-0.59))))
    (inputs
     (list openssl))
    (native-inputs
     (list pkg-config))
    (home-page "https://github.com/rust-lang/cargo")
    (synopsis "Utilities for Cargo")
    (description "Miscellaneous support code used by Cargo.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cargo-util-schemas-0.6
  (package
    (name "rust-cargo-util-schemas")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cargo-util-schemas" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "163x9cfg5g9ilz1ra3zr5nzk34qg8h4bxgsbrpgff6saaja2f19w"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-semver" ,rust-semver-1)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-serde-untagged" ,rust-serde-untagged-0.1)
                       ("rust-serde-value" ,rust-serde-value-0.7)
                       ("rust-thiserror" ,rust-thiserror-1)
                       ("rust-toml" ,rust-toml-0.8)
                       ("rust-unicode-xid" ,rust-unicode-xid-0.2)
                       ("rust-url" ,rust-url-2))
       #:cargo-development-inputs (("rust-snapbox" ,rust-snapbox-0.6))))
    (home-page "https://github.com/rust-lang/cargo")
    (synopsis "Deserialization schemas for Cargo")
    (description "This package provides deserialization schemas for Cargo.")
    (license (list license:expat license:asl2.0))))

(define-public rust-caseless-0.2
  (package
    (name "rust-caseless")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "caseless" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1n75pz65q9zn5rqq2xlw43dkq69rljnsd73nzpnwi1j08l3xavwb"))))
    (build-system cargo-build-system)
    (arguments
     (list #:cargo-inputs (list rust-unicode-normalization-0.1)))
    (home-page "https://github.com/unicode-rs/rust-caseless")
    (synopsis "Unicode caseless matching")
    (description "This package provides unicode caseless matching.")
    (license license:expat)))

(define-public rust-casey-0.4
  (package
    (name "rust-casey")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "casey" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0sv5ll6aavwcigmr53b22dg16adlz4pa2pb73367sna974k8cib1"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/jordy25519/casey")
    (synopsis "Case transforming macros for ident tokens")
    (description "Case transforming macros for ident tokens.")
    (license license:expat)))

(define-public rust-cassowary-0.3
  (package
    (name "rust-cassowary")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cassowary" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0lvanj0gsk6pc1chqrh4k5k0vi1rfbgzmsk46dwy3nmrqyw711nz"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/dylanede/cassowary-rs")
    (synopsis
     "Implementation of the Cassowary linear constraint solving algorithm")
    (description
     "This package provides a Rust implementation of the Cassowary linear
constraint solving algorithm.

The Cassowary algorithm is designed for naturally laying out user interfaces
using linear constraints, like ``this button must line up with this text
box''.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cast-0.3
  (package
    (name "rust-cast")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cast" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1dbyngbyz2qkk0jn2sxil8vrz3rnpcj142y184p9l4nbl9radcip"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-1))))
    (home-page "https://github.com/japaric/cast.rs")
    (synopsis
     "Ergonomic, checked cast functions for primitive types")
    (description
     "Ergonomic, checked cast functions for primitive types.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cast-0.2
  (package
    (inherit rust-cast-0.3)
    (name "rust-cast")
    (version "0.2.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cast" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "16p3bqi3qad1qdjgjc1r0x72iinj1aw2k8fw5zx2l51s52sdl92c"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; lint `const_err` has been removed
       #:cargo-inputs
       (("rust-rustc-version" ,rust-rustc-version-0.4))
       #:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.9))))))

(define-public rust-castaway-0.2
  (package
    (name "rust-castaway")
    (version "0.2.3")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "castaway" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1mf0wypwnkpa1hi0058vp8g7bjh2qraip2qv7dmak7mg1azfkfha"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-rustversion" ,rust-rustversion-1))
       #:cargo-development-inputs
       (("rust-paste" ,rust-paste-1))))
    (home-page "https://github.com/sagebind/castaway")
    (synopsis "Zero-cost downcasting for limited compile-time specialization")
    (description
     "This is an experimental library that implements zero-cost downcasting of
types that works on stable Rust.")
    (license license:expat)))

(define-public rust-castaway-0.1
  (package
    (inherit rust-castaway-0.2)
    (name "rust-castaway")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "castaway" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1xhspwy477qy5yg9c3jp713asxckjpx0vfrmz5l7r5zg7naqysd2"))))
    (arguments '())))

(define-public rust-cblas-sys-0.1
  (package
    (name "rust-cblas-sys")
    (version "0.1.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cblas-sys" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0rgsn3klhhh09d8qf3b87zl4rwk93l2g0qzh9hhb0lff5kcfrzmn"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/blas-lapack-rs/cblas-sys")
    (synopsis "Bindings to CBLAS (C)")
    (description
     "The package provides bindings to CBLAS (C).")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-cc-1
  (package
    (name "rust-cc")
    (version "1.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cc" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1bqw7559dq0by6dq5k38rijz5p0wr5sa94s2gb180n0ndfmbnmwi"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-jobserver" ,rust-jobserver-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-shlex" ,rust-shlex-1))
       #:cargo-development-inputs
       (("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/rust-lang/cc-rs")
    (synopsis "Invoke the native C compiler")
    (description
     "This package provides a build-time dependency for Cargo build scripts to
assist in invoking the native C compiler to compile native C code into a static
archive to be linked into Rustcode.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-cdshealpix-0.7
  (package
    (name "rust-cdshealpix")
    (version "0.7.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cdshealpix" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0rxg2wsrnzfhm8pid1sv22zn1cly54zdbg2ffajx0i0dvyfpm1cc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags
       (list "--release" "--"
             ;; Tests can't find FITS files:
             ;; - test/resources/skymap/skymap.fits
             ;; - test/resources/skymap/skymap.2mass.depth6.fits
             "--skip=tests::test_skymap_to_mom_basic"
             "--skip=tests::test_skymap_to_mom_chi2"
             "--skip=tests::test_mom_diff_spec"
             "--skip=tests::test_skymap_spec")
     #:cargo-inputs
       (("rust-base64" ,rust-base64-0.21)
        ("rust-byteorder" ,rust-byteorder-1)
        ("rust-colorous" ,rust-colorous-1)
        ("rust-flate2" ,rust-flate2-1)
        ("rust-itertools" ,rust-itertools-0.13)
        ("rust-katex-doc" ,rust-katex-doc-0.1)
        ("rust-log" ,rust-log-0.4)
        ("rust-mapproj" ,rust-mapproj-0.3)
        ("rust-num" ,rust-num-0.4)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-png" ,rust-png-0.17)
        ("rust-serde" ,rust-serde-1)
        ("rust-thiserror" ,rust-thiserror-1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.4)
        ("rust-rand" ,rust-rand-0.8))))
    (home-page "https://github.com/cds-astro/cds-healpix-rust/")
    (synopsis "HEALPix tessellation")
    (description
     "This library is an implementation in Rust of the HEALPix tessellation.
This implementation has been made by the Strasbourg astronomical Data
Centre (Centre de Données astronomique de Strasbourg,
@url{http://cdsweb.u-strasbg.fr/,CDS}).")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-cesu8-1
  (package
    (name "rust-cesu8")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cesu8" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0g6q58wa7khxrxcxgnqyi9s1z2cjywwwd3hzr5c55wskhx6s0hvd"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/emk/cesu8-rs")
    (synopsis "Convert to and from CESU-8 encoding")
    (description
     "This library implements the CESU-8 compatibility encoding scheme.  This
is a non-standard variant of UTF-8 that is used internally by some systems
that need to represent UTF-16 data as 8-bit characters.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-cexpr-0.6
  (package
    (name "rust-cexpr")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cexpr" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0rl77bwhs5p979ih4r0202cn5jrfsrbgrksp40lkfz5vk1x3ib3g"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t #:cargo-inputs (("rust-nom" ,rust-nom-7))))
    (inputs
     (list clang))
    (home-page "https://github.com/jethrogb/rust-cexpr")
    (synopsis "C expression parser and evaluator")
    (description
     "This package provides a C expression parser and evaluator.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-cexpr-0.4
  (package
    (inherit rust-cexpr-0.6)
    (name "rust-cexpr")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cexpr" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "09qd1k1mrhcqfhqmsz4y1bya9gcs29si7y3w96pqkgid4y2dpbpl"))))
    (arguments
     `(#:cargo-inputs
       (("rust-nom" ,rust-nom-5))
       #:cargo-development-inputs
       (("rust-clang-sys" ,rust-clang-sys-0.28))))))

(define-public rust-cexpr-0.2
  (package
    (inherit rust-cexpr-0.6)
    (name "rust-cexpr")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cexpr" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0v1xa3758czmj8h97gh548mr8g0v13ixxvrlm1s79nb7jmgc9aj2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-nom" ,rust-nom-3))))))

(define-public rust-cfg-aliases-0.2
  (package
    (name "rust-cfg-aliases")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cfg_aliases" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "092pxdc1dbgjb6qvh83gk56rkic2n2ybm4yvy76cgynmzi3zwfk1"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/katharostech/cfg_aliases")
    (synopsis "Utility to help you with long winded @code{#[cfg()]} checks")
    (description
     "CFG Aliases is a tiny utility to help save you a lot of effort with long
winded @code{#[cfg()]} checks.")
    (license license:expat)))

(define-public rust-cfg-aliases-0.1
  (package
    (inherit rust-cfg-aliases-0.2)
    (name "rust-cfg-aliases")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cfg_aliases" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "17p821nc6jm830vzl2lmwz60g3a30hcm33nk6l257i1rjdqw85px"))))))

(define-public rust-cfg-expr-0.17
  (package
    (name "rust-cfg-expr")
    (version "0.17.2")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "cfg-expr" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "12a7zr6ff4i6mfwcv711dll0w5pr3dw1lvkaf4c4a66i1gjacjwd"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-smallvec" ,rust-smallvec-1)
        ("rust-target-lexicon" ,rust-target-lexicon-0.12))
       #:cargo-development-inputs
       (("rust-similar-asserts" ,rust-similar-asserts-1))))
    (home-page "https://github.com/EmbarkStudios/cfg-expr")
    (synopsis "Parser and evaluator for Rust @code{cfg()} expressions")
    (description
     "This package provides a parser and evaluator for Rust @code{cfg()}
expressions.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cfg-expr-0.15
  (package
    (inherit rust-cfg-expr-0.17)
    (name "rust-cfg-expr")
    (version "0.15.8")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "cfg-expr" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "00lgf717pmf5qd2qsxxzs815v6baqg38d6m5i6wlh235p14asryh"))))
    (arguments
     `(#:cargo-inputs
       (("rust-smallvec" ,rust-smallvec-1)
        ("rust-target-lexicon" ,rust-target-lexicon-0.12))
       #:cargo-development-inputs
       (("rust-similar-asserts" ,rust-similar-asserts-1))))))

(define-public rust-cfg-expr-0.10
  (package
    (inherit rust-cfg-expr-0.15)
    (name "rust-cfg-expr")
    (version "0.10.3")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "cfg-expr" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1nw50j1sl6q96067399r1c6ppwp483q6vvmqdsnv493cv7sarb0a"))))
    (arguments
     `(#:cargo-inputs
       (("rust-smallvec" ,rust-smallvec-1)
        ("rust-target-lexicon" ,rust-target-lexicon-0.12))
       #:cargo-development-inputs
       (("rust-similar-asserts" ,rust-similar-asserts-1))))))

(define-public rust-cfg-expr-0.8
  (package
    (inherit rust-cfg-expr-0.10)
    (name "rust-cfg-expr")
    (version "0.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cfg-expr" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "03lgv8psc2qrr93hxgdfmfwbj1crpzghxd7qh6w2nz0l4qryh4ml"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-smallvec" ,rust-smallvec-1)
        ("rust-target-lexicon" ,rust-target-lexicon-0.12))
       #:cargo-development-inputs
       (("rust-difference" ,rust-difference-2))))))

(define-public rust-cfg-if-1
  (package
    (name "rust-cfg-if")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cfg-if" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1za0vb97n4brpzpv8lsbnzmq5r8f2b0cpqqr0sy8h5bn751xxwds"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1))))
    (home-page "https://github.com/alexcrichton/cfg-if")
    (synopsis "Define an item depending on parameters")
    (description
     "This package provides a macro to ergonomically define an item depending
on a large number of @code{#[cfg]} parameters.  Structured like an if-else
chain, the first matching branch is the item that gets emitted.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cfg-if-0.1
  (package
    (inherit rust-cfg-if-1)
    (name "rust-cfg-if")
    (version "0.1.10")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cfg-if" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "08h80ihs74jcyp24cd75wwabygbbdgl05k6p5dmq8akbr78vv1a7"))))
    (arguments
     `(#:cargo-inputs
       (("rust-compiler-builtins" ,rust-compiler-builtins-0.1)
        ("rust-rustc-std-workspace-core" ,rust-rustc-std-workspace-core-1))))))

(define-public rust-cfg-vis-0.3
  (package
    (name "rust-cfg-vis")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cfg-vis" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1745qzkxar9yd3wy4gzzsakv1cjcibhgnr3m2p5f43y1byzw78n3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-proc-macro-crate" ,rust-proc-macro-crate-1)
                       ("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/TOETOE55/cfg-vis")
    (synopsis "Macro to support `#[cfg()]` on visibility")
    (description
     "This package provides a macro to support `#[cfg()]` on visibility.")
    (license license:expat)))

(define-public rust-chan-0.1
  (package
    (name "rust-chan")
    (version "0.1.23")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "chan" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1n0y992mqfk5zpxzvrv14g9qivacmd4fiv4j1nmgyrg0vaimcjfi"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-rand" ,rust-rand-0.3))))
    (home-page "https://github.com/BurntSushi/chan")
    (synopsis "DEPRECATED. Use crossbeam-channel instead")
    (description "DEPRECATED. Use crossbeam-channel instead.")
    (license (list license:unlicense license:expat))))

(define-public rust-charset-0.1
  (package
    (name "rust-charset")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "charset" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0zkwcw525qwcqsdf74l9d2r6m69yxfxb4kgywp3q9fklgjq2gygi"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-base64" ,rust-base64-0.22)
        ("rust-encoding-rs" ,rust-encoding-rs-0.8)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-bincode" ,rust-bincode-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://docs.rs/charset/")
    (synopsis "Thunderbird-compatible character encoding decoding for email")
    (description
     "charset is a wrapper around @code{encoding_rs} that
provides (non-streaming) decoding for character encodings that occur in email
by providing decoding for UTF-7 in addition to the encodings defined by the
Encoding Standard.")
    (license (list license:expat license:asl2.0))))

(define-public rust-checked-int-cast-1
  (package
    (name "rust-checked-int-cast")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "checked_int_cast" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "06brva5agm6g12q15f8fidz17akb85q211496p1k2qxhb9mmxk0p"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/PeterReid/checked_int_cast")
    (synopsis "Conversions between primitive integers")
    (description
     "This package provides conversions between primitive integers with
overflow and underflow checking.")
    (license license:expat)))

(define-public rust-chic-1
  (package
    (name "rust-chic")
    (version "1.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "chic" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "037pkdccj25gr4my8fq1qni9v87rydpyhfi2naf86mimkxhxpdd5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-annotate-snippets" ,rust-annotate-snippets-0.6))))
    (home-page "https://github.com/yoshuawuyts/chic")
    (synopsis "Pretty parser error reporting")
    (description "This package provides pretty parser error reporting.")
    (license (list license:expat license:asl2.0))))

(define-public rust-chrono-0.4
  (package
    (name "rust-chrono")
    (version "0.4.39")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "chrono" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "09g8nf409lb184kl9j4s85k0kn8wzgjkp5ls9zid50b886fwqdky"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-android-tzdata" ,rust-android-tzdata-0.1)
        ("rust-arbitrary" ,rust-arbitrary-1)
        ("rust-iana-time-zone" ,rust-iana-time-zone-0.1)
        ("rust-js-sys" ,rust-js-sys-0.3)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-pure-rust-locales" ,rust-pure-rust-locales-0.8)
        ("rust-rkyv" ,rust-rkyv-0.7)
        ("rust-serde" ,rust-serde-1)
        ("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2)
        ("rust-windows-targets" ,rust-windows-targets-0.52))
       #:cargo-development-inputs
       (("rust-bincode" ,rust-bincode-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.3)
        ("rust-windows-bindgen" ,rust-windows-bindgen-0.58))
       #:features '("unstable-locales")))
    (home-page "https://github.com/chronotope/chrono")
    (synopsis "Date and time library for Rust")
    (description "Date and time library for Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-chrono-humanize-0.2
  (package
    (name "rust-chrono-humanize")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "chrono-humanize" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0fq25fcdqd7s39dx81hq123210q4lpcbjdz82jl2fy6jnkk2g5kr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-chrono" ,rust-chrono-0.4))))
    (home-page "https://gitlab.com/imp/chrono-humanize-rs")
    (synopsis "Human-friendly time expressions")
    (description
     "Chrono-Humanize provides human-friendly time expressions, similar to
Python @code{arrow.humanize}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-chrono-tz-0.10
  (package
    (name "rust-chrono-tz")
    (version "0.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "chrono-tz" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1dnkmhlf8jfxskrzir0y6fdbpf8mqnaz5igql9cklwh0dl2dhvfd"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-arbitrary" ,rust-arbitrary-1)
                       ("rust-chrono" ,rust-chrono-0.4)
                       ("rust-chrono-tz-build" ,rust-chrono-tz-build-0.4)
                       ("rust-phf" ,rust-phf-0.11)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-uncased" ,rust-uncased-0.9))
       #:cargo-development-inputs (("rust-chrono" ,rust-chrono-0.4)
                                   ("rust-serde-test" ,rust-serde-test-1))))
    (home-page "https://github.com/chronotope/chrono-tz")
    (synopsis "TimeZone implementations for chrono from the IANA database")
    (description
     "Chrono-TZ is a library that provides implementors of the TimeZone trait
for @code{rust-chrono}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-chrono-tz-0.9
  (package
    (inherit rust-chrono-tz-0.10)
    (name "rust-chrono-tz")
    (version "0.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "chrono-tz" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1fvicqrlmdsjkrgxr7bxfd62i9w2qi2b6iv4w85av5syvqlqnsck"))))
    (arguments
     `(#:cargo-inputs
       (("rust-arbitrary" ,rust-arbitrary-1)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-chrono-tz-build" ,rust-chrono-tz-build-0.3)
        ("rust-phf" ,rust-phf-0.11)
        ("rust-serde" ,rust-serde-1)
        ("rust-uncased" ,rust-uncased-0.9))
       #:cargo-development-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-serde-test" ,rust-serde-test-1))))))

(define-public rust-chrono-tz-0.8
  (package
    (inherit rust-chrono-tz-0.9)
    (name "rust-chrono-tz")
    (version "0.8.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "chrono-tz" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1dv0yqhr60wrhm4sdlralqw1jf5plcxc91q6v93hvamzk6gbgmwi"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-arbitrary" ,rust-arbitrary-1)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-chrono-tz-build" ,rust-chrono-tz-build-0.2)
        ("rust-phf" ,rust-phf-0.11)
        ("rust-serde" ,rust-serde-1)
        ("rust-uncased" ,rust-uncased-0.9))
       #:cargo-development-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-serde-test" ,rust-serde-test-1))))))

(define-public rust-chrono-tz-0.6
  (package
    (inherit rust-chrono-tz-0.8)
    (name "rust-chrono-tz")
    (version "0.6.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "chrono-tz" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1pmv434fhw9pwiqc12pvgaiskrq4v1dh1f238gfsg48r301r5hr9"))))
    (arguments
     `(#:cargo-test-flags
       (list "--release" "--"
             "--skip=tests::second_offsets")
       #:cargo-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-chrono-tz-build" ,rust-chrono-tz-build-0.0.3)
        ("rust-phf" ,rust-phf-0.11)
        ("rust-serde" ,rust-serde-1)
        ("rust-uncased" ,rust-uncased-0.9))
       #:cargo-development-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-serde-test" ,rust-serde-test-1))))))

(define-public rust-chrono-tz-0.5
  (package
    (inherit rust-chrono-tz-0.6)
    (name "rust-chrono-tz")
    (version "0.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "chrono-tz" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "085i4940kn0fn4gkl3xi1kv3vp2frhfig1vla1i461pcbwas6m15"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-parse-zoneinfo" ,rust-parse-zoneinfo-0.3)
        ("rust-serde" ,rust-serde-1))))))

(define-public rust-chrono-tz-build-0.4
  (package
    (name "rust-chrono-tz-build")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "chrono-tz-build" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "19qh9c3v7v4czf8z8vrhdy4jmkc6nyzd4svlwwlm493sswsflkz9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-parse-zoneinfo" ,rust-parse-zoneinfo-0.3)
                       ("rust-phf-codegen" ,rust-phf-codegen-0.11)
                       ("rust-phf-shared" ,rust-phf-shared-0.11)
                       ("rust-regex" ,rust-regex-1)
                       ("rust-uncased" ,rust-uncased-0.9))))
    (home-page "https://github.com/chronotope/chrono-tz")
    (synopsis "Internal build script for chrono-tz Rust package")
    (description "This package contains the internal build script for
the chrono-tz Rust crate.")
    (license (list license:expat license:asl2.0))))

(define-public rust-chrono-tz-build-0.3
  (package
    (inherit rust-chrono-tz-build-0.4)
    (name "rust-chrono-tz-build")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "chrono-tz-build" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1c8ixwwwsn9kgs1dr5mz963p0fgw9j9p7fzb3w2c7y8xhkp8l20c"))))
    (arguments
     `(#:cargo-inputs
       (("rust-parse-zoneinfo" ,rust-parse-zoneinfo-0.3)
        ("rust-phf" ,rust-phf-0.11)
        ("rust-phf-codegen" ,rust-phf-codegen-0.11)
        ("rust-regex" ,rust-regex-1)
        ("rust-uncased" ,rust-uncased-0.9))))))

(define-public rust-chrono-tz-build-0.2
  (package
    (inherit rust-chrono-tz-build-0.3)
    (name "rust-chrono-tz-build")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "chrono-tz-build" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "03rmzd69cn7fp0fgkjr5042b3g54s2l941afjm3001ls7kqkjgj3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-parse-zoneinfo" ,rust-parse-zoneinfo-0.3)
        ("rust-phf" ,rust-phf-0.11)
        ("rust-phf-codegen" ,rust-phf-codegen-0.11)
        ("rust-regex" ,rust-regex-1)
        ("rust-uncased" ,rust-uncased-0.9))))))

(define-public rust-chrono-tz-build-0.0.3
  (package
    (inherit rust-chrono-tz-build-0.2)
    (name "rust-chrono-tz-build")
    (version "0.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "chrono-tz-build" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "031s51dd2vbxdhz7fxk1jpbbvr800w57an14bsq3fd5khwx9ql3g"))))))

(define-public rust-chumsky-0.9
  (package
    (name "rust-chumsky")
    (version "0.9.2")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "chumsky" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "179llm5hybq5fr21mi681dq5f51j98laqmwh56kvadk2p4l045r3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-hashbrown" ,rust-hashbrown-0.12)
        ("rust-stacker" ,rust-stacker-0.1))
       #:cargo-development-inputs
       (("rust-ariadne" ,rust-ariadne-0.1)
        ("rust-pom" ,rust-pom-3))))
    (home-page "https://github.com/zesterer/chumsky")
    (synopsis "Parser library for humans with powerful error recovery")
    (description
     "This package provides a parser library for humans with powerful error
recovery.")
    (license license:expat)))

(define-public rust-ci-info-0.3
  (package
    (name "rust-ci-info")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ci_info" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "00pr17g6q6i752acrkycg0hkq3lm0p634anm41g3m6lqg8q83s75"))))
    (build-system cargo-build-system)
    (arguments
     `(#:parallel-tests? #f             ;fails otherwise
       #:cargo-test-flags
       '("--release" "--"
         "--skip=ci::ci_test::get_bamboo"
         "--skip=ci::ci_test::get_taskcluster_runid"
         "--skip=ci::ci_test::get_buildkite"
         "--skip=ci::ci_test::get_tfs")
       #:cargo-inputs
       (("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1))))
    (home-page "https://github.com/sagiegurari/ci_info")
    (synopsis "Provides current CI environment information")
    (description
     "This package provides current CI environment information.")
    (license license:asl2.0)))

(define-public rust-ciborium-0.2
  (package
    (name "rust-ciborium")
    (version "0.2.2")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "ciborium" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "03hgfw4674im1pdqblcp77m7rc8x2v828si5570ga5q9dzyrzrj2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags
       '("--release" "--"
         "--skip=codec::case_183")
       #:cargo-inputs
       (("rust-ciborium-io" ,rust-ciborium-io-0.2)
        ("rust-ciborium-ll" ,rust-ciborium-ll-0.2)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-hex" ,rust-hex-0.4)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-rstest" ,rust-rstest-0.11)
        ("rust-serde-bytes" ,rust-serde-bytes-0.11))))
    (home-page "https://github.com/enarx/ciborium")
    (synopsis "Serde implementation of CBOR")
    (description
     "This package provides CBOR serialization implementations for serde.")
    (license license:asl2.0)))

(define-public rust-ciborium-io-0.2
  (package
    (name "rust-ciborium-io")
    (version "0.2.2")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "ciborium-io" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0my7s5g24hvp1rs1zd1cxapz94inrvqpdf1rslrvxj8618gfmbq5"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/enarx/ciborium")
    (synopsis "Simplified Read/Write traits")
    (description
     "This package provides simplified Read/Write traits for @code{no_std}
usage.")
    (license license:asl2.0)))

(define-public rust-ciborium-ll-0.2
  (package
    (name "rust-ciborium-ll")
    (version "0.2.2")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "ciborium-ll" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1n8g4j5rwkfs3rzfi6g1p7ngmz6m5yxsksryzf5k72ll7mjknrjp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-ciborium-io" ,rust-ciborium-io-0.2)
                       ("rust-half" ,rust-half-2))
       #:cargo-development-inputs (("rust-hex" ,rust-hex-0.4))))
    (home-page "https://github.com/enarx/ciborium")
    (synopsis "Low-level CBOR codec primitives")
    (description
     "This package provides low-level primitives for parsing the CBOR codec.")
    (license license:asl2.0)))

(define-public rust-cint-0.3
  (package
    (name "rust-cint")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cint" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "16l9glvaxshbp3awcga3s8cdfv00gb1n2s7ixzxxjwc5yz6qf3ks"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f  ; use of undeclared type `ColorCrate2`
       #:cargo-inputs (("rust-bytemuck" ,rust-bytemuck-1))))
    (home-page "https://github.com/termhn/cint")
    (synopsis
     "Stable set of types for color interoperation between crates in Rust")
    (description
     "This package provides a lean, minimal, and stable set of types for color
interoperation between crates in Rust.")
    (license (list license:expat license:asl2.0 license:zlib))))

(define-public rust-circular-0.3
  (package
    (name "rust-circular")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "circular" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1slb0zd1xj0fjd0ql86zs57l1xbn5ywsyj1d8397bcvc1yg27z5h"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/sozu-proxy/circular")
    (synopsis "Stream abstraction for nom")
    (description
     "This package provides a stream abstraction designed for use with nom.")
    (license license:expat)))

(define-public rust-claims-0.7
  (package
    (name "rust-claims")
    (version "0.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "claims" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1da6z2r4zz4fw4a69286s54jzr7g7sz3dspq0xiw6mk432z5p6dn"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-autocfg" ,rust-autocfg-1))))
    (home-page "https://github.com/Anders429/claims")
    (synopsis "Additional assertion macros for testing")
    (description
     "This package provides additional assertion macros for testing.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-clang-ast-0.1
  (package
    (name "rust-clang-ast")
    (version "0.1.20")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "clang-ast" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32 "04qf9kpc2r3ca7c5x8bjp1daj42k69q12q8mz7bhajbm9rpafb8m"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; Fails to build clang-ast-test-suite.
       #:cargo-inputs
       (("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-clang-ast-test-suite" ,rust-clang-ast-test-suite-0.0.0)
        ("rust-rustversion" ,rust-rustversion-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/dtolnay/clang-ast")
    (synopsis "Data structures for processing Clang's ast format")
    (description "This package contains data structures for processing Clang's
@code{-ast-dump=json} format.")
    (license (list license:expat license:asl2.0))))

(define-public rust-clang-ast-test-suite-0.0.0
  (package
    (name "rust-clang-ast-test-suite")
    (version "0.0.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "clang-ast-test-suite" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "04c6p67w2f3s74pl83swj93l6p9g88vgki0rp2vxbb0bzm1hqy5h"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t))   ; Not intended to be built independently.
    (home-page "https://github.com/dtolnay/clang-ast")
    (synopsis "Test suite of the clang-ast crate")
    (description
     "This package contains the test suite of the @code{clang-ast} crate.")
    (license (list license:expat license:asl2.0))))

(define-public rust-clang-sys-1
  (package
    (name "rust-clang-sys")
    (version "1.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clang-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1x1r9yqss76z8xwpdanw313ss6fniwc1r7dzb5ycjn0ph53kj0hb"))
       (modules '((guix build utils)))
       (snippet
        '(begin
           (substitute* "Cargo.toml"
             (("version = \">=([[:digit:]]+(\\.[[:digit:]]+)*), <.*\"" _ version)
              (string-append "version = \"^" version "\"")))))))
    (build-system cargo-build-system)
    (inputs
     (list clang))
    (arguments
     `(#:cargo-inputs
       (("rust-glob" ,rust-glob-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libloading" ,rust-libloading-0.8))
       #:cargo-development-inputs (("rust-glob" ,rust-glob-0.3)
                                   ("rust-lazy-static" ,rust-lazy-static-1)
                                   ("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/KyleMayes/clang-sys")
    (synopsis "Rust bindings for libclang")
    (description "This package provides Rust bindings for libclang.")
    (license license:asl2.0)))

(define-public rust-clang-sys-0.23
  (package
    (inherit rust-clang-sys-1)
    (name "rust-clang-sys")
    (version "0.23.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clang-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1hjr333izzhs6bic84qwnyzy5xzmvasib8f3zkzj4ln3a97c1xyp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-glob" ,rust-glob-0.2)
                       ("rust-glob" ,rust-glob-0.2)
                       ("rust-libc" ,rust-libc-0.2)
                       ("rust-libloading" ,rust-libloading-0.5))))))

(define-public rust-clang-sys-0.29
  (package
    (inherit rust-clang-sys-1)
    (name "rust-clang-sys")
    (version "0.29.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "clang-sys" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "02nibl74zbz5x693iy5vdbhnfckja47m7j1mp2bj7fjw3pgkfs7y"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-glob" ,rust-glob-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libloading" ,rust-libloading-0.5))))))

(define-public rust-clang-sys-0.28
  (package
    (inherit rust-clang-sys-0.29)
    (name "rust-clang-sys")
    (version "0.28.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "clang-sys" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0ls8zcqi5bmmrvrk3b6r1ym4wlivinbv590d2dvg2xn9f44mbpl1"))))))

(define-public rust-clap-4
  (package
    (name "rust-clap")
    (version "4.5.23")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clap" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "110cf0i9fmkfqzqhi1h8za9y0vnr5rwhy3wmv1p0rcgp5vnffd9i"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-clap-builder" ,rust-clap-builder-4)
                       ("rust-clap-derive" ,rust-clap-derive-4))
       #:cargo-development-inputs (("rust-automod" ,rust-automod-1)
                                   ("rust-clap-cargo" ,rust-clap-cargo-0.14)
                                   ("rust-humantime" ,rust-humantime-2)
                                   ("rust-rustversion" ,rust-rustversion-1)
                                   ("rust-shlex" ,rust-shlex-1)
                                   ("rust-snapbox" ,rust-snapbox-0.6)
                                   ("rust-trybuild" ,rust-trybuild-1)
                                   ("rust-trycmd" ,rust-trycmd-0.15))))
    (home-page "https://github.com/clap-rs/clap")
    (synopsis "Command Line Argument Parser")
    (description
     "This package provides a simple to use, efficient, and full-featured Command Line
Argument Parser.")
    (license (list license:expat license:asl2.0))))

(define-public rust-clap-3
  (package
    (inherit rust-clap-4)
    (name "rust-clap")
    (version "3.2.25")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clap" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "08vi402vfqmfj9f07c4gl6082qxgf4c9x98pbndcnwbgaszq38af"))))
    (arguments
     (list #:cargo-test-flags
           '(list "--release" "--"
                  ;; thread 'main' panicked at 'assertion failed: `(left == right)`
                  ;;   left: `"_AnonymousValueParser(ValueParser::other(TypeId { t: 3349385470118513432 }))"`,
                  ;;  right: `"_AnonymousValueParser(ValueParser::other(usize))"`', src/builder/value_parser.rs:18:1
                  "--skip=builder::value_parser::value_parser")
           #:cargo-inputs
           `(("rust-atty" ,rust-atty-0.2)
             ("rust-backtrace" ,rust-backtrace-0.3)
             ("rust-bitflags" ,rust-bitflags-1)
             ("rust-clap-derive" ,rust-clap-derive-3)
             ("rust-clap-lex" ,rust-clap-lex-0.2)
             ("rust-indexmap" ,rust-indexmap-1)
             ("rust-once-cell" ,rust-once-cell-1)
             ("rust-regex" ,rust-regex-1)
             ("rust-strsim" ,rust-strsim-0.10)
             ("rust-termcolor" ,rust-termcolor-1)
             ("rust-terminal-size" ,rust-terminal-size-0.2)
             ("rust-textwrap" ,rust-textwrap-0.16)
             ("rust-unicase" ,rust-unicase-2)
             ("rust-yaml-rust" ,rust-yaml-rust-0.4))
           #:cargo-development-inputs
           `(("rust-humantime" ,rust-humantime-2)
             ("rust-regex" ,rust-regex-1)
             ("rust-rustversion" ,rust-rustversion-1)
             ("rust-shlex" ,rust-shlex-1)
             ("rust-snapbox" ,rust-snapbox-0.2)
             ("rust-static-assertions" ,rust-static-assertions-1)
             ("rust-trybuild" ,rust-trybuild-1)
             ("rust-trycmd" ,rust-trycmd-0.13))))))

(define-public rust-clap-2
  (package
    (inherit rust-clap-3)
    (name "rust-clap")
    (version "2.34.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clap" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "071q5d8jfwbazi6zhik9xwpacx5i6kb2vkzy060vhf0c3120aqd0"))))
    (arguments
     `(#:cargo-inputs
       (("rust-ansi-term" ,rust-ansi-term-0.12)
        ("rust-atty" ,rust-atty-0.2)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-clippy" ,rust-clippy-0.0.302)
        ("rust-strsim" ,rust-strsim-0.8)
        ("rust-term-size" ,rust-term-size-0.3)
        ("rust-textwrap" ,rust-textwrap-0.11)
        ("rust-unicode-width" ,rust-unicode-width-0.1)
        ("rust-vec-map" ,rust-vec-map-0.8)
        ("rust-yaml-rust" ,rust-yaml-rust-0.3))
       #:cargo-development-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-version-sync" ,rust-version-sync-0.8))))
    (license license:expat)))

(define-public rust-clap-builder-4
  (package
    (name "rust-clap-builder")
    (version "4.5.23")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clap_builder" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0f28rgc09kdgfq1hgg1bb1ydaw243w6dwyw74syz439k6b32yn1h"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-anstream" ,rust-anstream-0.6)
                       ("rust-anstyle" ,rust-anstyle-1)
                       ("rust-backtrace" ,rust-backtrace-0.3)
                       ("rust-clap-lex" ,rust-clap-lex-0.7)
                       ("rust-strsim" ,rust-strsim-0.11)
                       ("rust-terminal-size" ,rust-terminal-size-0.4)
                       ("rust-unicase" ,rust-unicase-2)
                       ("rust-unicode-width" ,rust-unicode-width-0.2))
       #:cargo-development-inputs
       (("rust-color-print" ,rust-color-print-0.3)
        ("rust-static-assertions" ,rust-static-assertions-1)
        ("rust-unic-emoji-char" ,rust-unic-emoji-char-0.9))))
    (home-page "https://github.com/clap-rs/clap")
    (synopsis "Full-featured Command Line Argument Parser")
    (description
     "This package provides a simple to use, efficient, and full-featured
Command Line Argument Parser.")
    (license (list license:expat license:asl2.0))))

(define-public rust-clap-cargo-0.14
  (package
    (name "rust-clap-cargo")
    (version "0.14.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clap-cargo" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0gmlr0cahj7nfzcqfc16z76rb8ar3nnidm9snx4bi5psrrlymci3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-anstyle" ,rust-anstyle-1)
                       ("rust-cargo-metadata" ,rust-cargo-metadata-0.18)
                       ("rust-clap" ,rust-clap-4))))
    (home-page "https://github.com/crate-ci/clap-cargo")
    (synopsis "Re-usable CLI flags for `cargo` plugins")
    (description "This package provides re-usable CLI flags for `cargo` plugins.")
    (license (list license:expat license:asl2.0))))

(define-public rust-clap-cargo-0.12
  (package
    (inherit rust-clap-cargo-0.14)
    (name "rust-clap-cargo")
    (version "0.12.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clap-cargo" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1r2f4ad1vpaljrfbyfsv986qiwmll0iask4sdvwllka658s22grq"))))
    (arguments
     `(#:cargo-inputs (("rust-anstyle" ,rust-anstyle-1)
                       ("rust-cargo-metadata" ,rust-cargo-metadata-0.17)
                       ("rust-clap" ,rust-clap-4))))))

(define-public rust-clap-complete-4
  (package
    (name "rust-clap-complete")
    (version "4.5.40")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clap_complete" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1sdf0gw2k5cib7n66hm0k7k0dlys4i041a35s0r2vv9v7qz6cbmc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-clap" ,rust-clap-4)
                       ("rust-clap-lex" ,rust-clap-lex-0.7)
                       ("rust-completest" ,rust-completest-0.4)
                       ("rust-completest-pty" ,rust-completest-pty-0.5)
                       ("rust-is-executable" ,rust-is-executable-1)
                       ("rust-shlex" ,rust-shlex-1))
       #:cargo-development-inputs (("rust-automod" ,rust-automod-1)
                                   ("rust-clap" ,rust-clap-4)
                                   ("rust-snapbox" ,rust-snapbox-0.6)
                                   ("rust-trycmd" ,rust-trycmd-0.15))))
    (home-page "https://github.com/clap-rs/clap")
    (synopsis "Generate shell completion scripts for your clap::Command")
    (description
     "This package provides Generate shell completion scripts for your clap::Command.")
    (license (list license:expat license:asl2.0))))

(define-public rust-clap-complete-3
  (package
    (name "rust-clap-complete")
    (version "3.2.5")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "clap_complete" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1n3whjkznszrxif1hzvql7hav7agq85j456fmwjwwi9cjq52wyiz"))))
    (build-system cargo-build-system)
    (arguments
     (list #:cargo-inputs
           `(("rust-clap" ,rust-clap-3)
             ("rust-clap-lex" ,rust-clap-lex-0.2)
             ("rust-is-executable" ,rust-is-executable-1)
             ("rust-os-str-bytes" ,rust-os-str-bytes-6)
             ("rust-pathdiff" ,rust-pathdiff-0.2)
             ("rust-shlex" ,rust-shlex-1)
             ("rust-unicode-xid" ,rust-unicode-xid-0.2))
           #:cargo-development-inputs
           `(("rust-clap" ,rust-clap-3)
             ("rust-pretty-assertions" ,rust-pretty-assertions-1)
             ("rust-snapbox" ,rust-snapbox-0.2)
             ("rust-trycmd" ,rust-trycmd-0.13))))
    (home-page "https://github.com/clap-rs/clap/tree/master/clap_complete")
    (synopsis "Generate shell completion scripts for Clap CLIs")
    (description
     "This package provides generation of shell completion scripts
for programs written with Clap.")
    (license (list license:expat license:asl2.0))))

(define-public rust-clap-complete-command-0.6
  (package
    (name "rust-clap-complete-command")
    (version "0.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clap_complete_command" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0qhv99j7msqyw7j17hswqwpqbdvqawy8l7ip6rnnh5930n61k3ns"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-carapace-spec-clap" ,rust-carapace-spec-clap-1)
                       ("rust-clap" ,rust-clap-4)
                       ("rust-clap-complete" ,rust-clap-complete-4)
                       ("rust-clap-complete-fig" ,rust-clap-complete-fig-4)
                       ("rust-clap-complete-nushell" ,rust-clap-complete-nushell-4))
       #:cargo-development-inputs (("rust-clap" ,rust-clap-4))))
    (home-page "https://github.com/nihaals/clap-complete-command")
    (synopsis
     "Reduces boilerplate for adding a shell completion command to Clap")
    (description "This package reduces boilerplate for adding a shell completion
command to Clap.")
    (license license:expat)))

(define-public rust-clap-complete-command-0.5
  (package
    (inherit rust-clap-complete-command-0.6)
    (name "rust-clap-complete-command")
    (version "0.5.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "clap_complete_command" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0gcsj6ls8y0jpjp5172gdqwx5zj6gm4wdgrqysglr3d73qvrad0q"))))
    (arguments
     `(#:cargo-inputs
       (("rust-carapace-spec-clap" ,rust-carapace-spec-clap-0.1)
        ("rust-clap" ,rust-clap-4)
        ("rust-clap-complete" ,rust-clap-complete-4)
        ("rust-clap-complete-fig" ,rust-clap-complete-fig-4)
        ("rust-clap-complete-nushell" ,rust-clap-complete-nushell-0.1))
       #:cargo-development-inputs (("rust-clap" ,rust-clap-4))))))

(define-public rust-clap-complete-fig-4
  (package
    (name "rust-clap-complete-fig")
    (version "4.5.2")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "clap_complete_fig" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0sy88ybw33ba7qj02caxr9jv03wq1f8rdbrbqw81i5gkiwn1156l"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-clap" ,rust-clap-4)
        ("rust-clap-complete" ,rust-clap-complete-4))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-4)
        ("rust-snapbox" ,rust-snapbox-0.6))))
    (home-page "https://github.com/clap-rs/clap/tree/master/clap_complete_fig")
    (synopsis "Generator library used with clap for Fig completion scripts")
    (description
     "This package provides a generator library used with clap for Fig
completion scripts.")
    (license (list license:expat license:asl2.0))))

(define-public rust-clap-complete-fig-3
  (package
    (name "rust-clap-complete-fig")
    (version "3.2.4")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "clap_complete_fig" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1fb4965w8wyrcwq35ywgx4mzfsv2cqba73mdlvmp6ii1q70b8dzd"))))
    (build-system cargo-build-system)
    (arguments
     (list #:cargo-inputs
           `(("rust-clap" ,rust-clap-3)
             ("rust-clap-complete" ,rust-clap-complete-3))
           #:cargo-development-inputs
           `(("rust-snapbox" ,rust-snapbox-0.2))))
    (home-page "https://github.com/clap-rs/clap/tree/master/clap_complete_fig")
    (synopsis "Generate Fig completion scripts for Clap CLIs")
    (description
     "This package provides a generator library for Rust used
with Clap to generate Fig completion scripts.")
    (license (list license:expat license:asl2.0))))

(define-public rust-clap-complete-nushell-4
  (package
    (name "rust-clap-complete-nushell")
    (version "4.5.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clap_complete_nushell" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "12miqxh9g7q37w11bgv55b32s0hdf6avf0lhagzc5psp6icv3a66"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-clap" ,rust-clap-4)
                       ("rust-clap-complete" ,rust-clap-complete-4)
                       ("rust-completest" ,rust-completest-0.4)
                       ("rust-completest-nu" ,rust-completest-nu-0.4))
       #:cargo-development-inputs (("rust-clap" ,rust-clap-4)
                                   ("rust-snapbox" ,rust-snapbox-0.6))))
    (home-page
     "https://github.com/clap-rs/clap/tree/master/clap_complete_nushell")
    (synopsis "Generator library used with clap for Nushell completion scripts")
    (description
     "This package provides a generator library used with clap for Nushell
completion scripts.")
    (license (list license:expat license:asl2.0))))

(define-public rust-clap-complete-nushell-0.1
  (package
    (inherit rust-clap-complete-nushell-4)
    (name "rust-clap-complete-nushell")
    (version "0.1.10")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "clap_complete_nushell" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0b15s7d9xpqjr1fpj8lmcv6nhgbhxvm0rzbh3cavv0xawvsl3yn7"))))
    (arguments
     `(#:cargo-inputs
       (("rust-clap" ,rust-clap-4)
        ("rust-clap-complete" ,rust-clap-complete-4))
       #:cargo-development-inputs (("rust-snapbox" ,rust-snapbox-0.4))))))

(define-public rust-clap-derive-4
  (package
    (name "rust-clap-derive")
    (version "4.5.18")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clap_derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ardb26bvcpg72q9myr7yir3a8c83gx7vxk1cccabsd9n73s1ija"))))
    (build-system cargo-build-system)
    (arguments
     (list #:cargo-inputs
           `(("rust-heck" ,rust-heck-0.5)
             ("rust-proc-macro2" ,rust-proc-macro2-1)
             ("rust-quote" ,rust-quote-1)
             ("rust-syn" ,rust-syn-2))))
    (home-page "https://clap.rs/")
    (synopsis "Procedural macro crate for Clap")
    (description
     "This package provides the procedural macro crate for Clap.")
    (license (list license:expat license:asl2.0))))

(define-public rust-clap-derive-3
  (package
    (inherit rust-clap-derive-4)
    (name "rust-clap-derive")
    (version "3.2.25")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clap_derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "025hh66cyjk5xhhq8s1qw5wkxvrm8hnv5xwwksax7dy8pnw72qxf"))))
    (arguments
     (list #:cargo-inputs
           `(("rust-heck" ,rust-heck-0.4)
             ("rust-proc-macro-error" ,rust-proc-macro-error-1)
             ("rust-proc-macro2" ,rust-proc-macro2-1)
             ("rust-quote" ,rust-quote-1)
             ("rust-syn" ,rust-syn-1))))))

(define-public rust-clap-lex-0.7
  (package
    (name "rust-clap-lex")
    (version "0.7.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clap_lex" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "19nwfls5db269js5n822vkc8dw0wjq2h1wf0hgr06ld2g52d2spl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs (("rust-automod" ,rust-automod-1))))
    (home-page "https://github.com/clap-rs/clap/tree/master/clap_lex")
    (synopsis "Command line parser for Clap")
    (description
     "This package provides a parser for command line options.  As opposed
to a declarative parser, @code{rust-clap-lex} processes arguments as a
stream of tokens.")
    ;; The user can choose either license.
    (license (list license:expat license:asl2.0))))

(define-public rust-clap-lex-0.6
  (package
    (inherit rust-clap-lex-0.7)
    (name "rust-clap-lex")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clap_lex" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1l8bragdvim7mva9flvd159dskn2bdkpl0jqrr41wnjfn8pcfbvh"))))))

(define-public rust-clap-lex-0.5
  (package
    (inherit rust-clap-lex-0.6)
    (name "rust-clap-lex")
    (version "0.5.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "clap_lex" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0qgrlq509vr49wq91jh50f9pm5f8lxmv1rcbklxnsg4nprxcaz6d"))))))

(define-public rust-clap-lex-0.3
  (package
    (inherit rust-clap-lex-0.5)
    (name "rust-clap-lex")
    (version "0.3.3")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "clap_lex" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0ip688faib67iqqy96i0qss77virr42sib1afj63a7yb99x6ngq3"))))
    (arguments
     `(#:cargo-inputs (("rust-os-str-bytes" ,rust-os-str-bytes-6))))))

(define-public rust-clap-lex-0.2
  (package
    (inherit rust-clap-lex-0.3)
    (name "rust-clap-lex")
    (version "0.2.4")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "clap_lex" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1ib1a9v55ybnaws11l63az0jgz5xiy24jkdgsmyl7grcm3sz4l18"))))
    (build-system cargo-build-system)
    (arguments
     (list #:cargo-inputs `(("rust-os-str-bytes" ,rust-os-str-bytes-6))))))

(define-public rust-clap-mangen-0.2
  (package
    (name "rust-clap-mangen")
    (version "0.2.24")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "clap_mangen" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1psbhrshcyz4ydxgjny338l4ijs4ys1ppg893iqshksxvjzrrbpv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-clap" ,rust-clap-4)
        ("rust-roff" ,rust-roff-0.2))
       #:cargo-development-inputs
       (("rust-automod" ,rust-automod-1)
        ("rust-clap" ,rust-clap-4)
        ("rust-snapbox" ,rust-snapbox-0.6))))
    (home-page "https://github.com/clap-rs/clap/tree/master/clap_mangen")
    (synopsis "Manpage generator for clap")
    (description "This package provides a manpage generator for clap.")
    (license (list license:expat license:asl2.0))))

(define-public rust-clap-utilities-0.2
  (package
    (name "rust-clap-utilities")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clap-utilities" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "163p99zc3wp02khfrqvn176c5bbprv03l8jrbrh16lgngs0gzg0m"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-clap" ,rust-clap-4)
                       ("rust-clap-complete" ,rust-clap-complete-4)
                       ("rust-pipe-trait" ,rust-pipe-trait-0.4)
                       ("rust-thiserror" ,rust-thiserror-1))))
    (home-page "https://github.com/KSXGitHub/clap-utilities.git")
    (synopsis "Small utilities related to clap")
    (description "This package provides small utilities related to clap.")
    (license license:expat)))

(define-public rust-clap-verbosity-flag-2
  (package
    (name "rust-clap-verbosity-flag")
    (version "2.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clap-verbosity-flag" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "15f419hg1xskf7pwzk5n27cpn05n0ccbd6sbji906ymi47576zxm"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-clap" ,rust-clap-4)
                       ("rust-log" ,rust-log-0.4))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-4)
        ("rust-env-logger" ,rust-env-logger-0.10)
        ("rust-tracing" ,rust-tracing-0.1)
        ("rust-tracing-log" ,rust-tracing-log-0.2)
        ("rust-tracing-subscriber" ,rust-tracing-subscriber-0.3))))
    (home-page "https://github.com/clap-rs/clap-verbosity-flag")
    (synopsis "Easily add a `--verbose` flag to CLIs using Clap")
    (description
     "This package provides a way to add a `--verbose` flag to CLIs using
Clap.")
    (license (list license:expat license:asl2.0))))

(define-public rust-claxon-0.4
  (package
    (name "rust-claxon")
    (version "0.4.3")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "claxon" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1206mxvw833ysg10029apcsjjwly8zmsvksgza5cm7ma4ikzbysb"))))
    (build-system cargo-build-system)
    (arguments
     (list #:skip-build? #t)) ; Cut the dependency graph.
    (home-page "https://github.com/ruuda/claxon#readme")
    (synopsis "FLAC decoding library")
    (description "This package provides a FLAC decoding library.")
    (license license:asl2.0)))

(define-public rust-clearscreen-2
  (package
    (name "rust-clearscreen")
    (version "2.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clearscreen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "15799yi8azfkn86m1i1kgb7xxk7k321gf8zx5vk08rjq38pz5wvj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-nix" ,rust-nix-0.26)
                       ("rust-terminfo" ,rust-terminfo-0.8)
                       ("rust-thiserror" ,rust-thiserror-1)
                       ("rust-which" ,rust-which-4)
                       ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/watchexec/clearscreen")
    (synopsis "Cross-platform terminal screen clearing")
    (description "This crate provides cross-platform terminal screen clearing.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-clearscreen-1
  (package
    (inherit rust-clearscreen-2)
    (name "rust-clearscreen")
    (version "1.0.11")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clearscreen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "05xk23szs0s2ybf7gvhhaqs0bmj7dv58zivv2059rxh3saysspg5"))))
    (arguments
     `(#:cargo-inputs (("rust-nix" ,rust-nix-0.24)
                       ("rust-terminfo" ,rust-terminfo-0.7)
                       ("rust-thiserror" ,rust-thiserror-1)
                       ("rust-which" ,rust-which-4)
                       ("rust-winapi" ,rust-winapi-0.3))))))

(define-public rust-cli-clipboard-0.4
  (package
    (name "rust-cli-clipboard")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cli-clipboard" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0g9y1w3ln5wn202mwxwhsilhifwww2p34fan99w5k8ia98fpq204"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f  ; Not all files included
       #:cargo-inputs (("rust-clipboard-win" ,rust-clipboard-win-4)
                       ("rust-objc" ,rust-objc-0.2)
                       ("rust-objc-foundation" ,rust-objc-foundation-0.1)
                       ("rust-objc-id" ,rust-objc-id-0.1)
                       ("rust-wl-clipboard-rs" ,rust-wl-clipboard-rs-0.7)
                       ("rust-x11-clipboard" ,rust-x11-clipboard-0.7))))
    (home-page "https://github.com/actuallyallie/cli-clipboard")
    (synopsis
     "Library for getting and setting the contents of the OS-level clipboard")
    (description
     "@code{cli-clipboard} is a library for getting and setting the contents of
the OS-level clipboard.")
    (license (list license:expat license:asl2.0))))

(define-public rust-clicolors-control-1
  (package
    (name "rust-clicolors-control")
    (version "1.0.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "clicolors-control" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "07klix8nbpwk0cg1k4h0kkiijm1jxvrzndqdkr7dqr6xvkjjw24h"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-atty" ,rust-atty-0.2)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/mitsuhiko/clicolors-control")
    (synopsis "Common utility library to control CLI colorization")
    (description
     "This package provides a common utility library to control CLI
colorization.")
    (license license:expat)))

(define-public rust-clippy-0.0.302
  (package
    (name "rust-clippy")
    (version "0.0.302")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clippy" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1562x3sq9mgmc8j39gd34wqm7ybrdvpmj7cc1n450gwsawayw4fr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-term" ,rust-term-0.5))))
    (home-page "https://github.com/rust-lang/rust-clippy")
    (synopsis
     "Lints to avoid common pitfalls in Rust")
    (description
     "This package provides a bunch of helpful lints to avoid common
pitfalls in Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-clircle-0.4
  (package
    (name "rust-clircle")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clircle" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0056l1bf2zmd7xs13xp8gxw9j9dngw4im0m8ijyifkrmsnz7rs68"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-cfg-if" ,rust-cfg-if-1)
                       ("rust-libc" ,rust-libc-0.2)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs (("rust-nix" ,rust-nix-0.24)
                                   ("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/niklasmohrin/clircle")
    (synopsis "Detect IO circles in your CLI apps arguments")
    (description
     "Clircle provides a cross-platform API to detect read or write cycles
from your user-supplied arguments.  You can get the important identifiers of
a file (from a path) and for all three stdio streams, if they are piped from
or to a file as well.")
    (license (list license:expat license:asl2.0))))

(define-public rust-close-fds-0.3
  (package
    (name "rust-close-fds")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "close_fds" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1vd2i1gkvfcgdlzgrkgivhx3ky0zs98g8q3mwmwrxmg97pridi1v"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-cfg-if" ,rust-cfg-if-1)
                       ("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/cptpcrd/close_fds")
    (synopsis "Library that makes it easy to close all open file descriptors")
    (description
     "This package provides a library that makes it easy to close all open file
descriptors.")
    (license license:expat)))

(define-public rust-cloud-file-0.2
  (package
    (name "rust-cloud-file")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cloud-file" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1xvqmizskv88c9mgb78y2aclkbmq1bhlvsnk20xkx6x2wnlwyd51"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-bytecount" ,rust-bytecount-0.6)
                       ("rust-bytes" ,rust-bytes-1)
                       ("rust-futures" ,rust-futures-0.3)
                       ("rust-futures-util" ,rust-futures-util-0.3)
                       ("rust-object-store" ,rust-object-store-0.11)
                       ("rust-thiserror" ,rust-thiserror-1)
                       ("rust-tokio" ,rust-tokio-1)
                       ("rust-url" ,rust-url-2))))
    (home-page "https://github.com/CarlKCarlK/cloud-file")
    (synopsis "Simple reading of cloud files in Rust")
    (description
     "This package is for simple reading of cloud files in Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cloudabi-0.1
  (package
    (name "rust-cloudabi")
    (version "0.1.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cloudabi" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0rv4yf5jlldfkynzrw687s00f4x12ypw7axv71vawhy6h4i52i23"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1))))
    (home-page "https://cloudabi.org/")
    (synopsis "Low level interface to CloudABI")
    (description "This package provides a low level interface to CloudABI.  It
contains all syscalls and related types.")
    (license license:bsd-2)))

(define-public rust-cloudabi-0.0.3
  (package
    (inherit rust-cloudabi-0.1)
    (name "rust-cloudabi")
    (version "0.0.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cloudabi" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0kxcg83jlihy0phnd2g8c2c303px3l2p3pkjz357ll6llnd5pz6x"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1))))))

(define-public rust-clru-0.6
  (package
    (name "rust-clru")
    (version "0.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "clru" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "01xq2vm3pfkja6crsh5r7idzyhy0dhjd8dz2y1zn00rf62kiy6dq"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/marmeladema/clru-rs")
    (synopsis "LRU cache implementation")
    (description "An LRU cache implementation with constant time operations and
weighted semantic.")
    (license license:expat)))

(define-public rust-cmake-0.1
  (package
    (name "rust-cmake")
    (version "0.1.50")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cmake" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0c3i3548mqbizpgbff94jjgkcd2p6q9fxjjh89zzf5dqcfaph753"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-cc" ,rust-cc-1))))
    (native-inputs (list cmake-minimal))
    (home-page "https://github.com/alexcrichton/cmake-rs")
    (synopsis "Rust build dependency for running cmake")
    (description
     "This package provides a build dependency for running @code{cmake} to build
a native library.  The CMake executable is assumed to be @code{cmake} unless the
CMAKE environmental variable is set.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-cobs-0.2
  (package
    (name "rust-cobs")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cobs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "05gd16mws4yd63h8jr3p08in8y8w21rpjp5jb55hzl9bgalh5fk7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs (("rust-quickcheck" ,rust-quickcheck-0.5))))
    (home-page "https://github.com/jamesmunns/cobs.rs")
    (synopsis
     "Implementation of the Consistent Overhead Byte Stuffing (COBS) algorithm")
    (description
     "This is an implementation of the @acronym{Consistent Overhead Byte
Stuffing, COBS} algorithm.  COBS is an algorithm for transforming a message into
an encoding where a specific value (the \"sentinel\" value) is not used.  This
value can then be used to mark frame boundaries in a serial communication channel.")
    (license (list license:expat license:asl2.0))))

(define-public rust-codegenrs-3
  (package
    (name "rust-codegenrs")
    (version "3.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "codegenrs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0hjr5pp099aipm2apcd65a2fp2z6qsixnapsj3rbjgdiyixxzndx"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-clap" ,rust-clap-4)
        ("rust-derive-more" ,rust-derive-more-0.99)
        ("rust-difference" ,rust-difference-2)
        ("rust-normalize-line-endings" ,rust-normalize-line-endings-0.3))))
    (home-page "https://github.com/crate-ci/codegenrs")
    (synopsis "Moving code-gen out of build.rs")
    (description "Moving code-gen out of build.rs.")
    (license (list license:expat license:asl2.0))))

(define-public rust-codegenrs-2
  (package
    (inherit rust-codegenrs-3)
    (name "rust-codegenrs")
    (version "2.0.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "codegenrs" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1mld8n8r4ns433gxs2jbndrzqjrxv7v0pwc66pf9a2v2mrgvbv6p"))))
    (arguments
     `(#:cargo-inputs
       (("rust-clap" ,rust-clap-3)
        ("rust-derive-more" ,rust-derive-more-0.99)
        ("rust-difference" ,rust-difference-2)
        ("rust-normalize-line-endings" ,rust-normalize-line-endings-0.3))))))

(define-public rust-codespan-reporting-0.11
  (package
    (name "rust-codespan-reporting")
    (version "0.11.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "codespan-reporting" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0vkfay0aqk73d33kh79k1kqxx06ka22894xhqi89crnc6c6jff1m"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1)
        ("rust-termcolor" ,rust-termcolor-1)
        ("rust-unicode-width" ,rust-unicode-width-0.1))
       #:cargo-development-inputs
       (("rust-anyhow" ,rust-anyhow-1)
        ("rust-insta" ,rust-insta-1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-peg" ,rust-peg-0.6)
        ("rust-rustyline" ,rust-rustyline-6)
        ("rust-structopt" ,rust-structopt-0.3)
        ("rust-unindent" ,rust-unindent-0.1))))
    (home-page "https://github.com/brendanzab/codespan")
    (synopsis "Beautiful diagnostic reporting for text-based programming languages")
    (description
     "Languages like Rust and Elm already support beautiful error
reporting output, but it can take a significant amount work to
implement this for new programming languages! The
@code{codespan-reporting} crate aims to make beautiful error
diagnostics easy and relatively painless for everyone!")
    (license license:asl2.0)))

(define-public rust-codspeed-2
  (package
    (name "rust-codspeed")
    (version "2.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "codspeed" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "15yf7gnb4s1fdvprdpn41yfydxpnv2clyd7lar0ia76zz6fhw2j5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-colored" ,rust-colored-2)
                       ("rust-libc" ,rust-libc-0.2)
                       ("rust-serde-json" ,rust-serde-json-1))
       #:cargo-development-inputs (("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://codspeed.io")
    (synopsis "Core instrumentation library for CodSpeed")
    (description "Core instrumentation library for @code{CodSpeed}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-codspeed-bencher-compat-2
  (package
    (name "rust-codspeed-bencher-compat")
    (version "2.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "codspeed-bencher-compat" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0n0m440c021s1pqb2k5w41a0l3pq5fwpwk489948kddm67pgwnh2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-bencher" ,rust-bencher-0.1)
                       ("rust-codspeed" ,rust-codspeed-2))))
    (home-page "https://codspeed.io")
    (synopsis "Bencher compatibility layer for CodSpeed")
    (description "Bencher compatibility layer for @code{CodSpeed}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-codspeed-criterion-compat-2
  (package
    (name "rust-codspeed-criterion-compat")
    (version "2.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "codspeed-criterion-compat" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1dmhwap6q50a99rsixm2fyghnpr8axwzr8mw558mlcfn2vlrvbh2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-async-std" ,rust-async-std-1)
                       ("rust-codspeed" ,rust-codspeed-2)
                       ("rust-colored" ,rust-colored-2)
                       ("rust-criterion" ,rust-criterion-0.5)
                       ("rust-futures" ,rust-futures-0.3)
                       ("rust-smol" ,rust-smol-1)
                       ("rust-tokio" ,rust-tokio-1))))
    (home-page "https://codspeed.io")
    (synopsis "Criterion.rs compatibility layer for CodSpeed")
    (description "Criterion.rs compatibility layer for @code{CodSpeed}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-coitrees-0.2
  (package
    (name "rust-coitrees")
    (version "0.2.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "coitrees" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1l2ybr8n02vm08wq9mrix7r07bgwm85i6fyachlm8d626w9w9d3f"))))
    (build-system cargo-build-system)
    (arguments
     ;; Check phase fails with:
     ;; no function or associated item named `with_name` found for struct
     ;; `Arg` in the current scope
     `(#:tests? #false
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-3))))
    (home-page "https://github.com/dcjones/coitrees")
    (synopsis "Data structure for overlap queries on sets of intervals")
    (description
     "This package provides a very fast data structure for overlap queries on
sets of intervals.")
    (license license:expat)))

(define-public rust-color-backtrace-0.6
  (package
    (name "rust-color-backtrace")
    (version "0.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "color-backtrace" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "183y2b0b4q14zq1nr2mc9sxld9xnvq28531qkwvp21hc4w5dh3qm"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-backtrace" ,rust-backtrace-0.3)
                       ("rust-regex" ,rust-regex-1)
                       ("rust-termcolor" ,rust-termcolor-1))))
    (home-page "https://github.com/athre0z/color-backtrace")
    (synopsis "Colorful panic backtraces")
    (description "This package provides colorful panic backtraces.")
    (license (list license:expat license:asl2.0))))

(define-public rust-color-backtrace-0.5
  (package
    (inherit rust-color-backtrace-0.6)
    (name "rust-color-backtrace")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "color-backtrace" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "11fn3snykx90w3nznzrcf4r164zmhk790asx0kzryf4r7i308v6d"))
       (snippet
        #~(begin (use-modules (guix build utils))
                 ;; https://github.com/eyre-rs/eyre/pull/175
                 ;; gimli-symbolize was deprecated in backtrace in ~2022
                 ;; and was folded into backtrace's std feature set.
                 (substitute* "Cargo.toml"
                   ((".*gimli-symbolize.*") ""))))))
    (arguments
     `(#:cargo-inputs (("rust-atty" ,rust-atty-0.2)
                       ("rust-backtrace" ,rust-backtrace-0.3)
                       ("rust-regex" ,rust-regex-1)
                       ("rust-termcolor" ,rust-termcolor-1))))))

(define-public rust-color-eyre-0.6
  (package
    (name "rust-color-eyre")
    (version "0.6.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "color-eyre" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1m9shifr9sdw0drszzyhvaq5jysrsiki44bl7m1gfdzj8rg6y52m"))
       (snippet
        #~(begin (use-modules (guix build utils))
                 ;; https://github.com/eyre-rs/eyre/pull/175
                 ;; gimli-symbolize was deprecated in backtrace in ~2022
                 ;; and was folded into backtrace's std feature set.
                 (substitute* "Cargo.toml"
                   ((".*gimli-symbolize.*") ""))))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags '("--release" "--"
                            "--skip=test_error_backwards_compatibility"
                            "--skip=test_panic_backwards_compatibility")
       #:cargo-inputs (("rust-backtrace" ,rust-backtrace-0.3)
                       ("rust-color-spantrace" ,rust-color-spantrace-0.2)
                       ("rust-eyre" ,rust-eyre-0.6)
                       ("rust-indenter" ,rust-indenter-0.3)
                       ("rust-once-cell" ,rust-once-cell-1)
                       ("rust-owo-colors" ,rust-owo-colors-3)
                       ("rust-tracing-error" ,rust-tracing-error-0.2)
                       ("rust-url" ,rust-url-2))
       #:cargo-development-inputs
       (("rust-ansi-parser" ,rust-ansi-parser-0.8)
        ("rust-pretty-assertions" ,rust-pretty-assertions-1)
        ("rust-thiserror" ,rust-thiserror-1)
        ("rust-tracing" ,rust-tracing-0.1)
        ("rust-tracing-subscriber" ,rust-tracing-subscriber-0.3)
        ("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.3))))
    (home-page "https://github.com/eyre-rs/eyre")
    (synopsis "Error report handler for panics")
    (description
     "An error report handler for panics and eyre::Reports for colorful, consistent,
and well formatted error reports for all kinds of errors.")
    (license (list license:expat license:asl2.0))))

(define-public rust-color-eyre-0.5
  (package
    (inherit rust-color-eyre-0.6)
    (name "rust-color-eyre")
    (version "0.5.11")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "color-eyre" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1dspj58bk57f9hiqlvbz25rik92i4a95iwa2dl4pg8g8grlqa60z"))
       (snippet
        #~(begin (use-modules (guix build utils))
                 ;; https://github.com/eyre-rs/eyre/pull/175
                 ;; gimli-symbolize was deprecated in backtrace in ~2022
                 ;; and was folded into backtrace's std feature set.
                 (substitute* "Cargo.toml"
                   ((".*gimli-symbolize.*") ""))))))
    (arguments
     `(#:cargo-test-flags '("--"
                            "--skip=test_error_backwards_compatibility"
                            "--skip=test_panic_backwards_compatibility")
       #:cargo-inputs (("rust-backtrace" ,rust-backtrace-0.3)
                       ("rust-color-spantrace" ,rust-color-spantrace-0.1)
                       ("rust-eyre" ,rust-eyre-0.6)
                       ("rust-indenter" ,rust-indenter-0.3)
                       ("rust-once-cell" ,rust-once-cell-1)
                       ("rust-owo-colors" ,rust-owo-colors-1)
                       ("rust-tracing-error" ,rust-tracing-error-0.1)
                       ("rust-url" ,rust-url-2))
       #:cargo-development-inputs
       (("rust-ansi-parser" ,rust-ansi-parser-0.6)
        ("rust-pretty-assertions" ,rust-pretty-assertions-0.6)
        ("rust-thiserror" ,rust-thiserror-1)
        ("rust-tracing" ,rust-tracing-0.1)
        ("rust-tracing-subscriber" ,rust-tracing-subscriber-0.2)
        ("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.3))))))

(define-public rust-color-print-0.3
  (package
    (name "rust-color-print")
    (version "0.3.6")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "color-print" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1h58sxz6nmx7p5q6cp529gnjgpclaks72mkshws8k27k1z347r8y"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-color-print-proc-macro" ,rust-color-print-proc-macro-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-terminfo" ,rust-terminfo-0.7))))
    (home-page "https://gitlab.com/yolenoyer/color-print")
    (synopsis "Colorize and stylize strings at compile-time")
    (description
     "Colorize and stylize strings at compile-time, by using an HTML-like syntax.")
    (license (list license:expat license:asl2.0))))

(define-public rust-color-print-proc-macro-0.3
  (package
    (name "rust-color-print-proc-macro")
    (version "0.3.6")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "color-print-proc-macro" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "14yvvhlfsl1zskxl28f4jvwdimkdd8dxgzbgq2kirjzkqn01mzvp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-nom" ,rust-nom-7)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-2))))
    (home-page "https://gitlab.com/yolenoyer/color-print")
    (synopsis "Implementation for the package color-print")
    (description "Implementation for the package color-print.")
    (license (list license:expat license:asl2.0))))

(define-public rust-color-quant-1
  (package
    (name "rust-color-quant")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "color_quant" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "12q1n427h2bbmmm1mnglr57jaz2dj9apk0plcxw7nwqiai7qjyrx"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/PistonDevelopers/color_quant.git")
    (synopsis "Color quantization library to reduce n colors to 256 colors")
    (description
     "This package is a color quantization library to reduce n colors to 256
colors.")
    (license license:expat)))

(define-public rust-color-spantrace-0.2
  (package
    (name "rust-color-spantrace")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "color-spantrace" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1hkjgaqixrishwiq3lxxy1d4c3mvlv6avcj3ifwy50p3lyrf2syd"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags '("--release" "--" "--skip=test_backwards_compatibility")
       #:cargo-inputs (("rust-once-cell" ,rust-once-cell-1)
                       ("rust-owo-colors" ,rust-owo-colors-3)
                       ("rust-tracing-core" ,rust-tracing-core-0.1)
                       ("rust-tracing-error" ,rust-tracing-error-0.2))
       #:cargo-development-inputs
       (("rust-ansi-parser" ,rust-ansi-parser-0.8)
        ("rust-tracing" ,rust-tracing-0.1)
        ("rust-tracing-subscriber" ,rust-tracing-subscriber-0.3))))
    (home-page "https://github.com/eyre-rs/eyre")
    (synopsis
     "Pretty printer for tracing_error::SpanTrace based on color-backtrace")
    (description
     "This package provides a pretty printer for tracing_error::@code{SpanTrace}
based on color-backtrace.")
    (license (list license:expat license:asl2.0))))

(define-public rust-color-spantrace-0.1
  (package
    (inherit rust-color-spantrace-0.2)
    (name "rust-color-spantrace")
    (version "0.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "color-spantrace" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1lb2li71zvpxp80nck98gcqbqm3dnmp43pnlvm52z9x8livy9vmn"))))
    (arguments
     `(#:cargo-inputs (("rust-once-cell" ,rust-once-cell-1)
                       ("rust-owo-colors" ,rust-owo-colors-1)
                       ("rust-tracing-core" ,rust-tracing-core-0.1)
                       ("rust-tracing-error" ,rust-tracing-error-0.1))
       #:cargo-development-inputs
       (("rust-ansi-parser" ,rust-ansi-parser-0.6)
        ("rust-tracing" ,rust-tracing-0.1)
        ("rust-tracing-subscriber" ,rust-tracing-subscriber-0.2))))))

(define-public rust-colorchoice-1
  (package
    (name "rust-colorchoice")
    (version "1.0.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "colorchoice" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1ix7w85kwvyybwi2jdkl3yva2r2bvdcc3ka2grjfzfgrapqimgxc"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/rust-cli/anstyle")
    (synopsis "Global override of color control")
    (description "Global override of color control")
    (license (list license:expat license:asl2.0))))

(define-public rust-colored-2
  (package
    (name "rust-colored")
    (version "2.1.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "colored" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1f4h9p64snrnz4x432iza15p4diqjcgpmpvhi956d6r1rq61bwnb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f
       #:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-windows-sys" ,rust-windows-sys-0.48))
       #:cargo-development-inputs
       (("rust-ansi-term" ,rust-ansi-term-0.12)
        ("rust-rspec" ,rust-rspec-1.0.0-beta.3))))
    (home-page "https://github.com/mackwic/colored")
    (synopsis "Add colors in your terminal")
    (description
     "The most simple way to add colors in your terminal.")
    (license license:mpl2.0)))

(define-public rust-colored-1
  (package
    (inherit rust-colored-2)
    (name "rust-colored")
    (version "1.9.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "colored" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32 "0mc302pm2x0vpmc3ni35w0666858pmqlqzbipyz42cw2j4f78pss"))))
    (arguments
     `(#:tests? #f      ; Tests expect a real terminal.
       #:cargo-inputs (("rust-is-terminal" ,rust-is-terminal-0.4)
                       ("rust-lazy-static" ,rust-lazy-static-1)
                       ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs (("rust-ansi-term" ,rust-ansi-term-0.12)
                                   ("rust-rspec" ,rust-rspec-1.0.0-beta.3))))))

(define-public rust-colorz-1
  (package
    (name "rust-colorz")
    (version "1.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "colorz" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0yq6wvrajh73b9hwjr03brc2znhr1x1nym6bd5ry68c8g72kgsvc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f  ;  `#![feature]` may not be used on the stable release channel
       #:cargo-inputs (("rust-supports-color" ,rust-supports-color-3))))
    (home-page "https://github.com/RustyYato/colorz")
    (synopsis "terminal text-coloring library")
    (description "This package provides a terminal text-coloring library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-combine-4
  (package
    (name "rust-combine")
    (version "4.6.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "combine" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1m7s43cpi36vihmlda217xxgsdni3pbwgwfsa9zimdghhjfnxv9m"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bytes" ,rust-bytes-1)
        ("rust-bytes" ,rust-bytes-0.5)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-io" ,rust-futures-io-0.3)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-pin-project-lite" ,rust-pin-project-lite-0.2)
        ("rust-regex" ,rust-regex-1)
        ("rust-tokio" ,rust-tokio-1)
        ("rust-tokio" ,rust-tokio-0.3)
        ("rust-tokio" ,rust-tokio-0.2)
        ("rust-tokio-util" ,rust-tokio-util-0.7))
       #:cargo-development-inputs
       (("rust-async-std" ,rust-async-std-1)
        ("rust-bytes" ,rust-bytes-1)
        ("rust-bytes" ,rust-bytes-0.5)
        ("rust-criterion" ,rust-criterion-0.3)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-partial-io" ,rust-partial-io-0.3)
        ("rust-quick-error" ,rust-quick-error-1)
        ("rust-quickcheck" ,rust-quickcheck-0.6)
        ("rust-tokio" ,rust-tokio-1)
        ("rust-tokio" ,rust-tokio-0.3)
        ("rust-tokio" ,rust-tokio-0.2))))
    (home-page "https://github.com/Marwes/combine")
    (synopsis "Parser combinators on arbitrary streams with zero-copy support")
    (description
     "This package is an implementation of parser combinators for Rust,
inspired by the Haskell library Parsec.  As in Parsec the parsers are LL(1) by
default but they can opt-in to arbitrary lookahead using the attempt
combinator.")
    (license license:expat)))

(define-public rust-combine-3
  (package
    (inherit rust-combine-4)
    (name "rust-combine")
    (version "3.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "combine" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1006sbl3ybiky3d5q28p0lyph37hk7sipls1rkhikv11lfxacgfs"))))
    (arguments
     `(#:cargo-test-flags
       '("--release" "--"
         "--skip=parser::Parser::boxed")
       #:cargo-inputs
       (("rust-ascii" ,rust-ascii-0.9)
        ("rust-byteorder" ,rust-byteorder-1)
        ("rust-combine-regex-1" ,rust-combine-regex-1-1)
        ("rust-either" ,rust-either-1)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-regex" ,rust-regex-0.2)
        ("rust-unreachable" ,rust-unreachable-1))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1)
        ("rust-bytes" ,rust-bytes-0.4)
        ("rust-futures" ,rust-futures-0.1)
        ("rust-partial-io" ,rust-partial-io-0.3)
        ("rust-quick-error" ,rust-quick-error-1)
        ("rust-quickcheck" ,rust-quickcheck-0.6)
        ("rust-tokio-codec" ,rust-tokio-codec-0.1)
        ("rust-tokio-io" ,rust-tokio-io-0.1))))))

(define-public rust-combine-regex-1-1
  (package
    (name "rust-combine-regex-1")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "combine-regex-1" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1bzir63nvrg98i8g6b7crhgq5qbj4vq9f4y6d279af537djvh5ns"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-regex" ,rust-regex-1))))
    (home-page "https://github.com/Marwes/combine")
    (synopsis "Re-export of regex 1.0 letting combine use both 0.2 and 1.0")
    (description
     "This package is a re-export of regex 1.0 letting combine use both 0.2
and 1.0.")
    (license (list license:expat license:asl2.0))))

(define-public rust-comfy-table-7
  (package
    (name "rust-comfy-table")
    (version "7.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "comfy-table" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1nd4ns4vimypk554vqjww3iq14mdjbaawn5q1jl6w9j3nvknbw94"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-ansi-str" ,rust-ansi-str-0.8)
        ("rust-console" ,rust-console-0.15)
        ("rust-crossterm" ,rust-crossterm-0.28)
        ("rust-strum" ,rust-strum-0.26)
        ("rust-strum-macros" ,rust-strum-macros-0.26)
        ("rust-unicode-width" ,rust-unicode-width-0.2))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.5)
        ("rust-pretty-assertions" ,rust-pretty-assertions-1)
        ("rust-proptest" ,rust-proptest-1)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-rstest" ,rust-rstest-0.23))))
    (home-page "https://github.com/nukesor/comfy-table")
    (synopsis "Library for building tables with automatic content wrapping")
    (description
     "Comfy-tables is an utility for building tables with automatic content
wrapping.")
    (license license:expat)))

(define-public rust-comfy-table-6
  (package
    (inherit rust-comfy-table-7)
    (name "rust-comfy-table")
    (version "6.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "comfy-table" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1fmqjhry6xa6a9kr0769wiw06694n60kxs5c6nfvzqv8h9w9v5by"))))
    (arguments
     `(#:cargo-inputs (("rust-console" ,rust-console-0.15)
                       ("rust-crossterm" ,rust-crossterm-0.26)
                       ("rust-strum" ,rust-strum-0.24)
                       ("rust-strum-macros" ,rust-strum-macros-0.24)
                       ("rust-unicode-width" ,rust-unicode-width-0.1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.5)
        ("rust-pretty-assertions" ,rust-pretty-assertions-1)
        ("rust-proptest" ,rust-proptest-1)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-rstest" ,rust-rstest-0.17))))))

(define-public rust-comfy-table-4
  (package
    (inherit rust-comfy-table-7)
    (name "rust-comfy-table")
    (version "4.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "comfy-table" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1wzk894p2s725cpdip5968ydb50zczsl34040j6zs8klhqz5ms8i"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-crossterm" ,rust-crossterm-0.20)
        ("rust-strum" ,rust-strum-0.21)
        ("rust-strum-macros" ,rust-strum-macros-0.21)
        ("rust-unicode-width" ,rust-unicode-width-0.1))))))

(define-public rust-command-group-2
  (package
    (name "rust-command-group")
    (version "2.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "command-group" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "05lr58pzkpw9rnl3ssi6pv72b9vvjc6z0208ng57djqf1xmxz02h"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-async-trait" ,rust-async-trait-0.1)
                       ("rust-nix" ,rust-nix-0.26)
                       ("rust-tokio" ,rust-tokio-1)
                       ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs (("rust-tokio" ,rust-tokio-1))))
    (home-page "https://github.com/watchexec/command-group")
    (synopsis "Extension to Command to spawn in a process group")
    (description "This package provides an extension to Command to spawn in a
process group.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-command-group-1
  (package
    (inherit rust-command-group-2)
    (name "rust-command-group")
    (version "1.0.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "command-group" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0b7d9gy9dhw4jqx5x8njzmaifgxqw0nywjry7bgmjjlv81psia7p"))))
    (arguments
     `(#:cargo-inputs (("rust-async-trait" ,rust-async-trait-0.1)
                       ("rust-nix" ,rust-nix-0.22)
                       ("rust-tokio" ,rust-tokio-1)
                       ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs (("rust-tokio" ,rust-tokio-1))))))

(define-public rust-compact-str-0.8
  (package
    (name "rust-compact-str")
    (version "0.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "compact_str" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0cmgp61hw4fwaakhilwznfgncw2p4wkbvz6dw3i7ibbckh3c8y9v"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-arbitrary" ,rust-arbitrary-1)
                       ("rust-borsh" ,rust-borsh-1)
                       ("rust-bytes" ,rust-bytes-1)
                       ("rust-castaway" ,rust-castaway-0.2)
                       ("rust-cfg-if" ,rust-cfg-if-1)
                       ("rust-diesel" ,rust-diesel-2)
                       ("rust-itoa" ,rust-itoa-1)
                       ("rust-markup" ,rust-markup-0.13)
                       ("rust-proptest" ,rust-proptest-1)
                       ("rust-quickcheck" ,rust-quickcheck-1)
                       ("rust-rkyv" ,rust-rkyv-0.7)
                       ("rust-rustversion" ,rust-rustversion-1)
                       ("rust-ryu" ,rust-ryu-1)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-smallvec" ,rust-smallvec-1)
                       ("rust-sqlx" ,rust-sqlx-0.7)
                       ("rust-static-assertions" ,rust-static-assertions-1))
       #:cargo-development-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-proptest" ,rust-proptest-1)
        ("rust-quickcheck" ,rust-quickcheck-1)
        ("rust-quickcheck-macros" ,rust-quickcheck-macros-1)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-rkyv" ,rust-rkyv-0.7)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-test-case" ,rust-test-case-3)
        ("rust-test-strategy" ,rust-test-strategy-0.3))))
    (home-page "https://github.com/ParkMyCar/compact_str")
    (synopsis "String type that stores strings on the stack, when possible")
    (description
     "This package provides a memory-efficient string type that transparently
stores strings on the stack, when possible.")
    (license license:expat)))

(define-public rust-compact-str-0.7
  (package
    (inherit rust-compact-str-0.8)
    (name "rust-compact-str")
    (version "0.7.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "compact_str" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0gvvfc2c6pg1rwr2w36ra4674w3lzwg97vq2v6k791w30169qszq"))
              (snippet
               #~(begin (use-modules (guix build utils))
                        (substitute* "Cargo.toml"
                          (("1\\.0\\.\\*") "1.0.0"))))))
    (arguments
     `(#:cargo-inputs
       (("rust-arbitrary" ,rust-arbitrary-1)
        ("rust-bytes" ,rust-bytes-1)
        ("rust-castaway" ,rust-castaway-0.2)
        ("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-itoa" ,rust-itoa-1)
        ("rust-markup" ,rust-markup-0.13)
        ("rust-proptest" ,rust-proptest-1)
        ("rust-quickcheck" ,rust-quickcheck-1)
        ("rust-rkyv" ,rust-rkyv-0.7)
        ("rust-ryu" ,rust-ryu-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-smallvec" ,rust-smallvec-1)
        ("rust-static-assertions" ,rust-static-assertions-1))
       #:cargo-development-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-proptest" ,rust-proptest-1)
        ("rust-quickcheck" ,rust-quickcheck-1)
        ("rust-quickcheck-macros" ,rust-quickcheck-macros-1)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-rkyv" ,rust-rkyv-0.7)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-test-case" ,rust-test-case-2)
        ("rust-test-strategy" ,rust-test-strategy-0.2))))))

;; This package requires features which are unavailable
;; on the stable releases of Rust.
(define-public rust-compiler-builtins-0.1
  (package
    (name "rust-compiler-builtins")
    (version "0.1.84")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "compiler_builtins" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "040bzrhwyqm75yp94vdyfyljg3d25y3d3lb9vipx02p9lqf2r6wq"))))
    (build-system cargo-build-system)
    (arguments
     (list #:skip-build? #t
           #:cargo-inputs
           `(("rust-rustc-std-workspace-core"
              ,rust-rustc-std-workspace-core-1)
             ("rust-cc" ,rust-cc-1))))
    (home-page "https://github.com/rust-lang/compiler-builtins")
    (synopsis "Compiler intrinsics used by the Rust compiler")
    (description
     "This package provides compiler intrinsics used by the Rust compiler.  This
package is primarily useful when building the @code{core} crate yourself and you
need compiler-rt intrinsics.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-compiler-error-0.1
  (package
    (name "rust-compiler-error")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "compiler_error" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0irh7c0gznk2k6mj3cmqw7x4pg59lppmy1y8d6k5xc926rnmz5zg"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t))
    (home-page "https://github.com/lu-zero/compiler_error")
    (synopsis "Triggerable compiler error")
    (description "This package provides a triggerable compiler error for Rust.")
    (license license:expat)))

(define-public rust-compiletest-rs-0.11
  (package
    (name "rust-compiletest-rs")
    (version "0.11.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "compiletest_rs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0k60xaazc2ar1ycp1xiyj2am3rjdl9ww1w2kmmyablpw0n8zwl7i"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-diff" ,rust-diff-0.1)
                       ("rust-filetime" ,rust-filetime-0.2)
                       ("rust-getopts" ,rust-getopts-0.2)
                       ("rust-lazy-static" ,rust-lazy-static-1)
                       ("rust-libc" ,rust-libc-0.2)
                       ("rust-log" ,rust-log-0.4)
                       ("rust-miow" ,rust-miow-0.6)
                       ("rust-regex" ,rust-regex-1)
                       ("rust-rustfix" ,rust-rustfix-0.8)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-serde-derive" ,rust-serde-derive-1)
                       ("rust-serde-json" ,rust-serde-json-1)
                       ("rust-tempfile" ,rust-tempfile-3)
                       ("rust-tester" ,rust-tester-0.9)
                       ("rust-windows-sys" ,rust-windows-sys-0.59))))
    (home-page "https://github.com/Manishearth/compiletest-rs")
    (synopsis "Extraction of the compiletest utility from the Rust compiler")
    (description
     "This package provides an extraction of the compiletest utility from the
Rust compiler.")
    (license (list license:expat license:asl2.0))))

(define-public rust-compiletest-rs-0.10
  (package
    (inherit rust-compiletest-rs-0.11)
    (name "rust-compiletest-rs")
    (version "0.10.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "compiletest_rs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1mn0v8qax92pl9kdf2csah79jyigzvndg8mil6rpn97rpkhzw9bj"))))
    (arguments
     `(#:cargo-inputs
       (("rust-diff" ,rust-diff-0.1)
        ("rust-filetime" ,rust-filetime-0.2)
        ("rust-getopts" ,rust-getopts-0.2)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-miow" ,rust-miow-0.3)
        ("rust-regex" ,rust-regex-1)
        ("rust-rustfix" ,rust-rustfix-0.6)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-tempfile" ,rust-tempfile-3)
        ("rust-tester" ,rust-tester-0.9)
        ("rust-winapi" ,rust-winapi-0.3))))))

(define-public rust-compiletest-rs-0.9
  (package
    (inherit rust-compiletest-rs-0.10)
    (name "rust-compiletest-rs")
    (version "0.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "compiletest_rs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0wmk12mb8xskdv5mf3p33l2w4w76bcxjx3zlwn94zslaf6xrnj3h"))))))

(define-public rust-compiletest-rs-0.3
  (package
    (inherit rust-compiletest-rs-0.10)
    (name "rust-compiletest-rs")
    (version "0.3.26")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "compiletest_rs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0ipskgfs86cd3gy6hqb0qm2m0jdngqvh4s3rc1k8pbgb0ib9gn6p"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-diff" ,rust-diff-0.1)
        ("rust-filetime" ,rust-filetime-0.2)
        ("rust-getopts" ,rust-getopts-0.2)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-miow" ,rust-miow-0.3)
        ("rust-regex" ,rust-regex-1)
        ("rust-rustfix" ,rust-rustfix-0.4)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-tempfile" ,rust-tempfile-3)
        ("rust-tester" ,rust-tester-0.6)
        ("rust-winapi" ,rust-winapi-0.3))))))

(define-public rust-compiletest-rs-0.2
  (package
    (inherit rust-compiletest-rs-0.3)
    (name "rust-compiletest-rs")
    (version "0.2.10")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "compiletest_rs" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0njz4shbhl1pvb6ngpi1wpz2gr5lf2dcha22lpdk995pzrwd6h97"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-log" ,rust-log-0.3)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3)
        ("rust-tempdir" ,rust-tempdir-0.3))))))

(define-public rust-completest-0.4
  (package
    (name "rust-completest")
    (version "0.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "completest" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1nsxyiz1dnwy2pk5n17lbhiijgcy9rc4g5sr1w2als0kwvzy23a1"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/assert-rs/completest")
    (synopsis "Run completions for your program")
    (description
     "This package provides running completions for your program.")
    (license (list license:expat license:asl2.0))))

(define-public rust-completest-nu-0.4
  (package
    (name "rust-completest-nu")
    (version "0.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "completest-nu" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "08vcq18m92xlsfyaikks1ql3ipj42gqa2psnr9hmmnlcnkr1pk7z"))
       (snippet
        #~(begin (use-modules (guix build utils))
                 (substitute* "Cargo.toml"
                   ;; Allow any version of nushell we have packaged:
                   (("0\\.88\\.1") "*")
                   ;; Why this version of reedline specifically?
                   ;; Make sure it matches the version used by nushell.
                   (("0\\.27\\.1") "*"))))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t     ; Incompatible with the current version of nushell.
       #:cargo-inputs (("rust-completest" ,rust-completest-0.4)
                       ("rust-dunce" ,rust-dunce-1)
                       ("rust-nu-cli" ,rust-nu-cli-0.101)
                       ("rust-nu-cmd-lang" ,rust-nu-cmd-lang-0.101)
                       ("rust-nu-command" ,rust-nu-command-0.101)
                       ("rust-nu-parser" ,rust-nu-parser-0.101)
                       ("rust-nu-protocol" ,rust-nu-protocol-0.101)
                       ("rust-nu-test-support" ,rust-nu-test-support-0.101)
                       ("rust-reedline" ,rust-reedline-0.38))))
    (native-inputs (list pkg-config))
    (inputs (list openssl))
    (home-page "https://github.com/assert-rs/completest")
    (synopsis "Run completions for your program")
    (description "This package provides run completions for your program.")
    (license (list license:expat license:asl2.0))))

(define-public rust-completest-pty-0.5
  (package
    (name "rust-completest-pty")
    (version "0.5.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "completest-pty" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "04s30kz6rvi4d7grx8my5siwmfiv6sm09ib152yj5ccxk4mg5lpv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-completest" ,rust-completest-0.4)
                       ("rust-ptyprocess" ,rust-ptyprocess-0.4)
                       ("rust-vt100" ,rust-vt100-0.15))))
    (home-page "https://github.com/assert-rs/completest")
    (synopsis "Run completions for your program")
    (description
     "This package provides running completions for your program.")
    (license (list license:expat license:asl2.0))))

(define-public rust-compound-duration-1
  (package
    (name "rust-compound-duration")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "compound_duration" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0rb5kasd7044xxb73wz2qqxv6iwawp9gipvqhya8yybafh7a679r"))))
    (build-system cargo-build-system)
    (home-page "https://docs.rs/compound_duration/latest/compound_duration/")
    (synopsis "Convert seconds to compound duration")
    (description
     "Convert seconds to compound duration, such as: week, days, hours,
minutes, seconds.")
    (license license:bsd-3)))

(define-public rust-comrak-0.26
  (package
    (name "rust-comrak")
    (version "0.26.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "comrak" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1a87w6c0xkfml7rg1v34rhlcknr811s11mi9xsjgazf58dwbcnir"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-arbitrary" ,rust-arbitrary-1)
                       ("rust-caseless" ,rust-caseless-0.2)
                       ("rust-clap" ,rust-clap-4)
                       ("rust-derive-builder" ,rust-derive-builder-0.20)
                       ("rust-emojis" ,rust-emojis-0.6)
                       ("rust-entities" ,rust-entities-1)
                       ("rust-memchr" ,rust-memchr-2)
                       ("rust-once-cell" ,rust-once-cell-1)
                       ("rust-regex" ,rust-regex-1)
                       ("rust-shell-words" ,rust-shell-words-1)
                       ("rust-slug" ,rust-slug-0.1)
                       ("rust-syntect" ,rust-syntect-5)
                       ("rust-typed-arena" ,rust-typed-arena-2)
                       ("rust-unicode-categories" ,rust-unicode-categories-0.1)
                       ("rust-xdg" ,rust-xdg-2))
       #:cargo-development-inputs (("rust-ntest" ,rust-ntest-0.9)
                                   ("rust-toml" ,rust-toml-0.7))))
    (home-page "https://github.com/kivikakk/comrak")
    (synopsis "GitHub flavoured Markdown parser and formatter")
    (description
     "This package provides a 100% CommonMark-compatible GitHub flavoured
Markdown parser and formatter written in Rust.")
    (license license:bsd-2)))

(define-public rust-comrak-0.18
  (package
    (inherit rust-comrak-0.26)
    (name "rust-comrak")
    (version "0.18.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "comrak" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "157838s5bpjihg4a563hpbqr6a6080570g25pqi6026abdlsaaj8"))))
    (arguments
     `(#:cargo-inputs (("rust-arbitrary" ,rust-arbitrary-1)
                       ("rust-clap" ,rust-clap-4)
                       ("rust-emojis" ,rust-emojis-0.5)
                       ("rust-entities" ,rust-entities-1)
                       ("rust-memchr" ,rust-memchr-2)
                       ("rust-once-cell" ,rust-once-cell-1)
                       ("rust-regex" ,rust-regex-1)
                       ("rust-shell-words" ,rust-shell-words-1)
                       ("rust-slug" ,rust-slug-0.1)
                       ("rust-syntect" ,rust-syntect-5)
                       ("rust-typed-arena" ,rust-typed-arena-2)
                       ("rust-unicode-categories" ,rust-unicode-categories-0.1)
                       ("rust-xdg" ,rust-xdg-2))
       #:cargo-development-inputs (("rust-ntest" ,rust-ntest-0.9)
                                   ("rust-propfuzz" ,rust-propfuzz-0.0.1))))))

(define-public rust-concat-idents-1
  (package
    (name "rust-concat-idents")
    (version "1.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "concat-idents" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0bqdl6vml2ksyz6hc4xlpw3iqaagxs7xn0xinwa51ms80a390vsb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/DzenanJupic/concat-idents")
    (synopsis "Concatenate multiple identifiers and use them everywhere")
    (description
     "This package allows concatenating multiple identifiers and using them
everywhere.")
    (license (list license:expat license:asl2.0))))

(define-public rust-concat-string-1
  (package
    (name "rust-concat-string")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "concat-string" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "02c6hfxsvs1ff2j58f3qzr526w1yg8d2nf6yyjv81ixgbz5vwfbl"))))
    (build-system cargo-build-system)
    (arguments
     (list #:tests? #f))    ; Tests don't run with current versions of rust.
    (home-page "https://github.com/FaultyRAM/concat-string")
    (synopsis
     "Provides macros for concatenating string slices into owned strings")
    (description
     "This package provides macros for concatenating string slices into
owned strings.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-concolor-0.0.11
  (package
    (name "rust-concolor")
    (version "0.0.11")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "concolor" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "05ja8yy5ar34k2cplk0qp1d8qabxzj16mb8jn8790fivwwb6r39i"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; cannot find function `set` in crate `concolor`
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-concolor-query" ,rust-concolor-query-0.1)
        ("rust-is-terminal" ,rust-is-terminal-0.4))))
    (home-page "https://github.com/rust-cli/concolor")
    (synopsis "Control console coloring across all dependencies")
    (description "Concolor is a terminal styling library that can be used to:
@itemize
@item Detect interactive @samp{stdout} or @samp{stderr}
@item Detect terminal capabilities via @samp{TERM}
@item Support @url{https://bixense.com/clicolors/, CLICOLOR} and
@url{https://no-color.org/, NO_COLOR}.
@end itemize")
    (license (list license:expat license:asl2.0))))

(define-public rust-concolor-0.0.8
  (package
    (inherit rust-concolor-0.0.11)
    (name "rust-concolor")
    (version "0.0.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "concolor" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1bs03868bywgz2f8x4h41akvxpxiax9b036hrpf0mwhx7db6flh1"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-atty" ,rust-atty-0.2)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-concolor-query" ,rust-concolor-query-0.0.5))))))

(define-public rust-concolor-control-0.0.7
  (package
    (inherit rust-concolor-0.0.8)
    (name "rust-concolor-control")
    (version "0.0.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "concolor-control" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1nplakbdb9sbd3h62d9zkan0xm1w0c7cbl3rk0iqgn405yf1213i"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-atty" ,rust-atty-0.2)
        ("rust-bitflags" ,rust-bitflags-1)
        ("rust-concolor-query" ,rust-concolor-query-0.0.4))))))

(define-public rust-concolor-override-1
  (package
    (name "rust-concolor-override")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "concolor-override" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "140yb63zrbdvxvy3zaqvldgrjh5rm9qijy14w0imk7g3i1995920"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-colorchoice" ,rust-colorchoice-1))))
    (home-page "https://github.com/rust-cli/concolor")
    (synopsis "Global override of color control")
    (description "Global override of color control.")
    (license (list license:expat license:asl2.0))))

(define-public rust-concolor-query-0.3
  (package
    (name "rust-concolor-query")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "concolor-query" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ks4g514kx31nnv3bxa7cj5xgg6vwkljn8a001njxjnpqd91vlc8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-windows-sys" ,rust-windows-sys-0.45))))
    (home-page "https://github.com/rust-cli/concolor")
    (synopsis "Look up colored console capabilities")
    (description "@code{concolor-query} can be used to query a terminal
capabilities, for example to find out about its colored console abilities.")
    (license (list license:expat license:asl2.0))))

(define-public rust-concolor-query-0.1
  (package
    (inherit rust-concolor-query-0.3)
    (name "rust-concolor-query")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "concolor-query" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "05ykng7pqhm7840yh07r27p90flwrrmwlk32wxbgdp6mncs0gac2"))))
    (arguments '())))

(define-public rust-concolor-query-0.0.5
  (package
    (inherit rust-concolor-query-0.1)
    (name "rust-concolor-query")
    (version "0.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "concolor-query" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0jcll1lnnkbdr6xcgppf6dr0ra9rxcp78xr1zlrvba03zkk7yhfn"))))
    (arguments `(#:skip-build? #t))))

(define-public rust-concolor-query-0.0.4
  (package
    (inherit rust-concolor-query-0.0.5)
    (name "rust-concolor-query")
    (version "0.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "concolor-query" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1isbqpyiwblp0rglnaqzai5hav23095s82mwgi09v3xcck4rq5dd"))))))

(define-public rust-concurrent-queue-2
  (package
    (name "rust-concurrent-queue")
    (version "2.5.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "concurrent-queue" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0wrr3mzq2ijdkxwndhf79k952cp4zkz35ray8hvsxl96xrx1k82c"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-crossbeam-utils" ,rust-crossbeam-utils-0.8)
        ("rust-loom" ,rust-loom-0.7)
        ("rust-portable-atomic" ,rust-portable-atomic-1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.5)
        ("rust-easy-parallel" ,rust-easy-parallel-3)
        ("rust-fastrand" ,rust-fastrand-2)
        ("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.3))))
    (home-page "https://github.com/smol-rs/concurrent-queue")
    (synopsis "Concurrent multi-producer multi-consumer queue")
    (description
     "This package provides a concurrent multi-producer multi-consumer
queue.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-concurrent-queue-1
  (package
    (inherit rust-concurrent-queue-2)
    (name "rust-concurrent-queue")
    (version "1.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "concurrent-queue" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "176v15an6f686c9m5br57al23d7z3xzm3542walnwsdm9aj80ixg"))))
    (arguments
     `(#:cargo-inputs
       (("rust-cache-padded" ,rust-cache-padded-1))
       #:cargo-development-inputs
       (("rust-easy-parallel" ,rust-easy-parallel-3)
        ("rust-fastrand" ,rust-fastrand-1))))))

(define-public rust-condtype-1
  (package
    (name "rust-condtype")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "condtype" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1by78npyhkc30jccc7kirvwip1fj0jhi2bwfmcw44dqz81xa1w5s"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs (("rust-cfg-if" ,rust-cfg-if-1)
                                   ("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/nvzqz/condtype")
    (synopsis "Choose types at compile-time via boolean constants")
    (description "Choose types at compile-time via boolean constants.")
    (license (list license:expat license:asl2.0))))

(define-public rust-config-0.14
  (package
    (name "rust-config")
    (version "0.14.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "config" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1pyzr665pq6xcq3f6j1670v5xxk465n2bbkzn9hzycradlcqymv8"))))
    (build-system cargo-build-system)
    (arguments
     (list #:cargo-test-flags
           '(list "--" "--skip=value::tests::test_i64")
           #:cargo-inputs
           (list rust-async-trait-0.1
                 rust-convert-case-0.6
                 rust-indexmap-2
                 rust-json5-0.4
                 rust-nom-7
                 rust-pathdiff-0.2
                 rust-ron-0.8
                 rust-rust-ini-0.20
                 rust-serde-1
                 rust-serde-json-1
                 rust-toml-0.8
                 rust-yaml-rust2-0.8)
           #:cargo-development-inputs
           (list rust-chrono-0.4
                 rust-float-cmp-0.9
                 rust-futures-0.3
                 rust-glob-0.3
                 rust-log-0.4
                 rust-notify-6
                 rust-reqwest-0.11
                 rust-serde-derive-1
                 rust-temp-env-0.3
                 rust-tokio-1
                 rust-warp-0.3)))
    (native-inputs (list pkg-config))
    (inputs (list openssl))
    (home-page "https://github.com/mehcode/config-rs")
    (synopsis "Layered configuration system for Rust applications")
    (description
     "This package provides a layered configuration system for Rust
applications.")
    (license (list license:expat license:asl2.0))))

(define-public rust-config-0.13
  (package
    (inherit rust-config-0.14)
    (name "rust-config")
    (version "0.13.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "config" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1jjag1x3rl77zjykbrykzhd5fsiv8vy40y4lxkj46xicjw8qwwr3"))
       (modules '((guix build utils)))
       (snippet
        '(begin (substitute* "Cargo.toml"
                  (("\"= ?([[:digit:]]+(\\.[[:digit:]]+)*)" _ version)
                   (string-append "\"^" version)))))))
    (arguments
     `(#:cargo-inputs (("rust-async-trait" ,rust-async-trait-0.1)
                       ("rust-indexmap" ,rust-indexmap-1)
                       ("rust-json5" ,rust-json5-0.4)
                       ("rust-lazy-static" ,rust-lazy-static-1)
                       ("rust-nom" ,rust-nom-7)
                       ("rust-pathdiff" ,rust-pathdiff-0.2)
                       ("rust-ron" ,rust-ron-0.7)
                       ("rust-rust-ini" ,rust-rust-ini-0.18)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-serde-json" ,rust-serde-json-1)
                       ("rust-toml" ,rust-toml-0.5)
                       ("rust-yaml-rust" ,rust-yaml-rust-0.4))
       #:cargo-development-inputs (("rust-chrono" ,rust-chrono-0.4)
                                   ("rust-float-cmp" ,rust-float-cmp-0.9)
                                   ("rust-futures" ,rust-futures-0.3)
                                   ("rust-glob" ,rust-glob-0.3)
                                   ("rust-notify" ,rust-notify-4)
                                   ("rust-reqwest" ,rust-reqwest-0.11)
                                   ("rust-serde-derive" ,rust-serde-derive-1)
                                   ("rust-temp-env" ,rust-temp-env-0.2)
                                   ("rust-tokio" ,rust-tokio-1)
                                   ("rust-warp" ,rust-warp-0.3))))))

(define-public rust-config-0.11
  (package
    (inherit rust-config-0.13)
    (name "rust-config")
    (version "0.11.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "config" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0sdkxv77m65frsn3bx0r3v7asxar3gy3hmghcfk6h4rbijars6qv"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-nom" ,rust-nom-5)
        ("rust-rust-ini" ,rust-rust-ini-0.13)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-hjson" ,rust-serde-hjson-0.9)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-toml" ,rust-toml-0.5)
        ("rust-yaml-rust" ,rust-yaml-rust-0.4))))))

(define-public rust-config-0.10
  (package
    (inherit rust-config-0.11)
    (name "rust-config")
    (version "0.10.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "config" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1qrcp7nm24xzp418xnqf0i26qahw93w31nk5vs6m7ng18ghpdc0r"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-nom" ,rust-nom-5)
        ("rust-rust-ini" ,rust-rust-ini-0.13)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-hjson" ,rust-serde-hjson-0.9)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-toml" ,rust-toml-0.5)
        ("rust-yaml-rust" ,rust-yaml-rust-0.4))))))

(define-public rust-config-file-0.2
  (package
    (name "rust-config-file")
    (version "0.2.3")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "config-file" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1yys2088y6lnc959k1k78y0amjkp6a00pjybsk3x50872lnfflfz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-serde" ,rust-serde-1)
                       ("rust-serde-xml-rs" ,rust-serde-xml-rs-0.5)
                       ("rust-serde-json" ,rust-serde-json-1)
                       ("rust-serde-yaml" ,rust-serde-yaml-0.8)
                       ("rust-thiserror" ,rust-thiserror-1)
                       ("rust-toml" ,rust-toml-0.5))))
    (home-page "https://github.com/Keruspe/config-file")
    (synopsis "Read and parse configuration files")
    (description "This package provides ability to read and parse
configuration files.")
    (license license:bsd-2)))

(define-public rust-configparser-3
  (package
    (name "rust-configparser")
    (version "3.1.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "configparser" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "16v47b7lknb35ragwhj9gzgwfpxs34vn2b97hhaky30ry1r34zp5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-indexmap" ,rust-indexmap-2)
        ("rust-tokio" ,rust-tokio-1))
       #:cargo-development-inputs (("rust-tokio" ,rust-tokio-1))))
    (home-page "https://github.com/QEDK/configparser-rs")
    (synopsis "Simple parsing utility for INI and ini-style syntax")
    (description
     "This package provides a simple configuration parsing utility with no
dependencies that allows you to parse INI and ini-style syntax.  You can use
this to write Rust programs which can be customized by end users easily.")
    (license (list license:expat license:lgpl3+))))

(define-public rust-console-0.15
  (package
    (name "rust-console")
    (version "0.15.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "console" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1sz4nl9nz8pkmapqni6py7jxzi7nzqjxzb3ya4kxvmkb0zy867qf"))
       (snippet
        #~(begin (use-modules (guix build utils))
                 (substitute* "Cargo.toml"
                   ;; break-dead-code was removed from proptest in 1.3.0.
                   ((".*break-dead-code.*") ""))))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-encode-unicode" ,rust-encode-unicode-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-unicode-width" ,rust-unicode-width-0.1)
        ("rust-windows-sys" ,rust-windows-sys-0.52))
       #:cargo-development-inputs
       (("rust-proptest" ,rust-proptest-1)
        ("rust-regex" ,rust-regex-1))))
    (home-page "https://github.com/mitsuhiko/console")
    (synopsis "Terminal and console abstraction for Rust")
    (description
     "This package provides a terminal and console abstraction for Rust.")
    (license license:expat)))

(define-public rust-console-0.14
  (package
    (inherit rust-console-0.15)
    (name "rust-console")
    (version "0.14.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "console" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0i8z1bdbv8is1lamd81jdsf4pa1ww2jl3h0yjdshc5mabd2fd4rr"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-encode-unicode" ,rust-encode-unicode-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-regex" ,rust-regex-1)
        ("rust-terminal-size" ,rust-terminal-size-0.1)
        ("rust-unicode-width" ,rust-unicode-width-0.1)
        ("rust-winapi" ,rust-winapi-0.3)
        ("rust-winapi-util" ,rust-winapi-util-0.1))))))

(define-public rust-console-0.13
  (package
    (inherit rust-console-0.14)
    (name "rust-console")
    (version "0.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "console" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "022ai0jbbawngrx396qppwgzk4pk3v2fdwckzamvz6h154jsn2m5"))))
    (arguments
     `(#:cargo-inputs
       (("rust-encode-unicode" ,rust-encode-unicode-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-regex" ,rust-regex-1)
        ("rust-terminal-size" ,rust-terminal-size-0.1)
        ("rust-unicode-width" ,rust-unicode-width-0.1)
        ("rust-winapi" ,rust-winapi-0.3)
        ("rust-winapi-util" ,rust-winapi-util-0.1))))))

(define-public rust-console-0.11
  (package
    (inherit rust-console-0.13)
    (name "rust-console")
    (version "0.11.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "console" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0nmwkbb1j1zjb2z4akk83rqgnbv7j3dla4nxv0ibk9xvavk982cc"))))
    (arguments
     `(#:cargo-inputs
       (("rust-encode-unicode" ,rust-encode-unicode-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-regex" ,rust-regex-1)
        ("rust-terminal-size" ,rust-terminal-size-0.1)
        ("rust-termios" ,rust-termios-0.3)
        ("rust-unicode-width" ,rust-unicode-width-0.1)
        ("rust-winapi" ,rust-winapi-0.3)
        ("rust-winapi-util" ,rust-winapi-util-0.1))))))

(define-public rust-console-0.7
  (package
    (name "rust-console")
    (version "0.7.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "console" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0a4n2syzik9lh02v2i4wdazvm05d99bib7dw0lqvz8mq2hn7r9cc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-atty" ,rust-atty-0.2)
        ("rust-clicolors-control" ,rust-clicolors-control-1)
        ("rust-encode-unicode" ,rust-encode-unicode-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-parking-lot" ,rust-parking-lot-0.8)
        ("rust-regex" ,rust-regex-1)
        ("rust-termios" ,rust-termios-0.3)
        ("rust-unicode-width" ,rust-unicode-width-0.1)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/mitsuhiko/console")
    (synopsis "Terminal and console abstraction for Rust")
    (description
     "This package provides a terminal and console abstraction for Rust.")
    (license license:expat)))

(define-public rust-console-error-panic-hook-0.1
  (package
    (name "rust-console-error-panic-hook")
    (version "0.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "console_error_panic_hook" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "04d2narcrzk9bnddz17rr2l819l82pr0h6d98s2w9q236n87dndq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2))))
    (home-page "https://github.com/rustwasm/console_error_panic_hook")
    (synopsis "Logs panics to console.error")
    (description
     "This package provides a panic hook for @code{wasm32-unknown-unknown}
that logs panics to @code{console.error}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-console-log-1
  (package
    (name "rust-console-log")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "console_log" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "03rwzvpg384y68j6hxm4h1bhzi7xcc5jdari8hxlvgzdwi0fv2my"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-log" ,rust-log-0.4)
                       ("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2)
                       ("rust-web-sys" ,rust-web-sys-0.3))))
    (home-page "https://github.com/iamcodemaker/console_log")
    (synopsis "Route Rust log messages to the browser's console")
    (description
     "This package provides a logging facility that routes Rust log messages to
the browser's console.")
    (license (list license:expat license:asl2.0))))

(define-public rust-console-log-0.2
  (package
    (inherit rust-console-log-1)
    (name "rust-console-log")
    (version "0.2.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "console_log" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "150li8pznpfpn4q0f7g9jwq2hnd5wik0w8378zaa1wffc5ckf6jh"))))
    (arguments
     `(#:cargo-inputs
       (("rust-log" ,rust-log-0.4)
        ("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2)
        ("rust-web-sys" ,rust-web-sys-0.3))))))

(define-public rust-const-cstr-0.3
  (package
    (name "rust-const-cstr")
    (version "0.3.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "const-cstr" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "19ij6m8s16d0i7vma535l7w4x8bcanjcxs7c6n7sci86ydghnggd"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/cybergeek94/const-cstr")
    (synopsis "Create static C-compatible strings from Rust string literals")
    (description
     "This crate lets you create static C-compatible strings from Rust string
literals.")
    (license (list license:expat license:asl2.0))))

(define-public rust-const-fn-0.4
  (package
    (name "rust-const-fn")
    (version "0.4.9")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "const_fn" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0df9fv9jhnh9b4ni3s2fbfcvq77iia4lbb89fklwawbgv2vdrp7v"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/taiki-e/const_fn")
    (synopsis "Generate const functions with conditional compilations")
    (description "This package provides an attribute for easy generation of
const functions with conditional compilations.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-const-format-0.2
  (package
    (name "rust-const-format")
    (version "0.2.32")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "const_format" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0wvns8mzqwkyciwr00p2g5g4ak7zz8m473di85srj11xmz3i98p3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags
       '("--release" "--features=__test")
       #:cargo-inputs
       (("rust-const-format-proc-macros" ,rust-const-format-proc-macros-0.2)
        ("rust-konst" ,rust-konst-0.2))
       #:cargo-development-inputs (("rust-arrayvec" ,rust-arrayvec-0.5)
                                   ("rust-fastrand" ,rust-fastrand-1))))
    (home-page "https://github.com/rodrimati1992/const_format_crates/")
    (synopsis "Compile-time string formatting")
    (description "This package provides compile-time string formatting.")
    (license license:zlib)))

(define-public rust-const-format-proc-macros-0.2
  (package
    (name "rust-const-format-proc-macros")
    (version "0.2.32")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "const_format_proc_macros" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0015dzbjbd773nn6096dwqv11fm8m3gy4a4a56cz5x10zl4gzxn7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-syn" ,rust-syn-1)
                       ("rust-unicode-xid" ,rust-unicode-xid-0.2))
       #:cargo-development-inputs (("rust-fastrand" ,rust-fastrand-1))))
    (home-page "https://github.com/rodrimati1992/const_format_crates/")
    (synopsis "Implementation detail of the @code{const_format} crate")
    (description "Implementation detail of the @code{const_format} crate.")
    (license license:zlib)))

(define-public rust-const-oid-0.9
  (package
    (name "rust-const-oid")
    (version "0.9.6")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "const-oid" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1y0jnqaq7p2wvspnx7qj76m7hjcqpz73qzvr9l2p9n2s51vr6if2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-arbitrary" ,rust-arbitrary-1))
       #:cargo-development-inputs (("rust-hex-literal" ,rust-hex-literal-0.3))))
    (home-page "https://github.com/RustCrypto/formats/tree/master/const-oid")
    (synopsis "Implementation of the ISO/IEC Object Identifier (OID)")
    (description
     "This package is a const-friendly implementation of the ISO/IEC Object
Identifier (OID) standard as defined in ITU X.660, with support for BER/DER
encoding/decoding as well as heapless no_std (i.e., embedded) support.")
    ;; The user can choose either license.
    (license (list license:asl2.0 license:expat))))

(define-public rust-const-oid-0.7
  (package
    (inherit rust-const-oid-0.9)
    (name "rust-const-oid")
    (version "0.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "const-oid" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1wwl3cncd8p2fa54vzmghflh4nh9ml02xfbv38nf5ziifh28riz4"))))
    (arguments
     `(#:cargo-development-inputs (("rust-hex-literal" ,rust-hex-literal-0.3))))))

(define-public rust-const-oid-0.6
  (package
    (inherit rust-const-oid-0.9)
    (name "rust-const-oid")
    (version "0.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "const-oid" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "12vv7csqqjj0x1l5mf51lgqiw76k5c3mb1yzfhfcqysks2j2lvwx"))))
    (arguments `(#:skip-build? #t))))

(define-public rust-const-panic-0.2
  (package
    (name "rust-const-panic")
    (version "0.2.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "const_panic" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "16w72mnzjqgwfhlq8cqm6xhd2n6lc1wan08987izv1pcxhwz4lb0"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags
       '("--release" "--features=test")
       #:cargo-inputs
       (("rust-const-panic-proc-macros" ,rust-const-panic-proc-macros-0.2)
        ("rust-typewit" ,rust-typewit-1))
       #:cargo-development-inputs (("rust-arrayvec" ,rust-arrayvec-0.7)
                                   ("rust-rand" ,rust-rand-0.8))))
    (home-page "https://github.com/rodrimati1992/const_panic/")
    (synopsis "Const panic with formatting")
    (description "This package provides const panic with formatting.")
    (license license:zlib)))

(define-public rust-const-panic-proc-macros-0.2
  (package
    (name "rust-const-panic-proc-macros")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "const_panic_proc_macros" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1addx3a8vi02cdak3ygrqivv02jj73251h85x49aic78yznrhlrr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-syn" ,rust-syn-1)
                       ("rust-unicode-xid" ,rust-unicode-xid-0.2))))
    (home-page "https://github.com/rodrimati1992/const_panic/")
    (synopsis "Implementation detail of the `const_panic` crate")
    (description "Implementation detail of the `const_panic` crate.")
    (license license:zlib)))

(define-public rust-const-random-0.1
  (package
    (name "rust-const-random")
    (version "0.1.18")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "const-random" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0n8kqz3y82ks8znvz1mxn3a9hadca3amzf33gmi6dc3lzs103q47"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; proc macro panicked
       #:cargo-inputs
       (("rust-const-random-macro" ,rust-const-random-macro-0.1))))
    (home-page "https://github.com/tkaitchuck/constrandom")
    (synopsis "Compile time random number generation")
    (description "This package provides compile time random number
generation.")
    (license (list license:expat license:asl2.0))))

(define-public rust-const-random-macro-0.1
  (package
    (name "rust-const-random-macro")
    (version "0.1.16")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "const-random-macro" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "03iram4ijjjq9j5a7hbnmdngj8935wbsd0f5bm8yw2hblbr3kn7r"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-getrandom" ,rust-getrandom-0.2)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-tiny-keccak" ,rust-tiny-keccak-2))))
    (home-page "https://github.com/tkaitchuck/constrandom")
    (synopsis "Procedural macro used by const-random")
    (description "This package provides the procedural macro used by
@code{rust-const-random}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-const-sha1-0.2
  (package
    (name "rust-const-sha1")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "const-sha1" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "179cgi2m3wj5g80j49pggs95xalc6y1ivvbrv4m82alc3r2vcn7v"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/rylev/const-sha1")
    (synopsis "SHA1 implementation for use in const contexts")
    (description
     "This package provides a sha1 implementation for use in const contexts.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-const-str-0.5
  (package
    (name "rust-const-str")
    (version "0.5.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "const-str" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1agvan36a2fgks5w47kk8idym54rdk504p6q2nj8gf9v136cq61n"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-const-str-proc-macro" ,rust-const-str-proc-macro-0.5))
       #:cargo-development-inputs (("rust-heck" ,rust-heck-0.4)
                                   ("rust-http" ,rust-http-1)
                                   ("rust-regex" ,rust-regex-1))))
    (home-page "https://github.com/Nugine/const-str")
    (synopsis "Compile-time string operations")
    (description "This package provides compile-time string operations.")
    (license license:expat)))

(define-public rust-const-str-proc-macro-0.5
  (package
    (name "rust-const-str-proc-macro")
    (version "0.5.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "const-str-proc-macro" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1gw4kzrrgrsgggi765xkq0svqdjw6rqp97nyyvp3a96dghbhfc1x"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-heck" ,rust-heck-0.4)
                       ("rust-http" ,rust-http-1)
                       ("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-regex" ,rust-regex-1)
                       ("rust-syn" ,rust-syn-2))))
    (home-page "https://github.com/Nugine/const-str")
    (synopsis "Compile-time string operations")
    (description "This package provides compile-time string operations.")
    (license license:expat)))

(define-public rust-constant-time-eq-0.3
  (package
    (name "rust-constant-time-eq")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "constant_time_eq" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "19nwwczii762pwlsm7bpizgjg8hkg1kqi32b2g4rglijklsbhx3w"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-count-instructions" ,rust-count-instructions-0.1)
        ("rust-criterion" ,rust-criterion-0.5))))
    (home-page "https://github.com/cesarb/constant_time_eq")
    (synopsis
     "Compares two equal-sized byte strings in constant time")
    (description
     "This package compares two equal-sized byte strings in constant time.
It is inspired by the Linux kernel's @code{crypto_memneq}.")
    (license (list license:cc0 license:expat-0 license:asl2.0))))

(define-public rust-constant-time-eq-0.2
  (package
    (inherit rust-constant-time-eq-0.3)
    (name "rust-constant-time-eq")
    (version "0.2.5")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "constant_time_eq" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0sy7bs12dfa2d5hw7759b0mvjqcs85giajg4qyg39xq8a1s8wh8k"))))
    (arguments
     `(#:cargo-development-inputs (("rust-criterion" ,rust-criterion-0.4))))))

(define-public rust-constant-time-eq-0.1
  (package
    (inherit rust-constant-time-eq-0.2)
    (name "rust-constant-time-eq")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "constant_time_eq" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1g3vp04qzmk6cpzrd19yci6a95m7ap6wy7wkwgiy2pjklklrfl14"))))
    (home-page "https://github.com/cesarb/constant_time_eq")
    (license license:cc0)))

(define-public rust-content-inspector-0.2
  (package
    (name "rust-content-inspector")
    (version "0.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "content_inspector" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0f1gwv4axxw9wck4a4jxlkm7xjjakb3616isll2k0s4chmpadgdp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-memchr" ,rust-memchr-2))))
    (home-page "https://github.com/sharkdp/content_inspector")
    (synopsis "Fast inspection of binary buffers to guess the encoding")
    (description
     "This package is a simple library for fast inspection of binary buffers
to guess the type of content.")
    (license (list license:expat license:asl2.0))))

(define-public rust-conv-0.3
  (package
    (name "rust-conv")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "conv" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "168j1npqrif1yqxbgbk0pdrx9shzhs5ylc5a4xw49b6hbxi11zvq"))
        (modules '((guix build utils)))
        (snippet
         '(begin (substitute* "Cargo.toml"
                   (("0.2.21.*") "0.2.21\"\n"))
                 #t))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-custom-derive" ,rust-custom-derive-0.1))
       #:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.2)
        ("rust-winapi" ,rust-winapi-0.2))))
    (home-page "https://github.com/DanielKeep/rust-conv")
    (synopsis "Conversion traits with more specific semantics")
    (description
     "This crate provides a number of conversion traits with more specific
semantics than those provided by @code{as} or @code{From}/@code{Into}.")
    (license license:expat)))

(define-public rust-convert-case-0.6
  (package
    (name "rust-convert-case")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "convert_case" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1jn1pq6fp3rri88zyw6jlhwwgf6qiyc08d6gjv0qypgkl862n67c"))
       (modules '((guix build utils)))
       (snippet
        '(begin (substitute* "Cargo.toml"
                  (("\"~([[:digit:]]+(\\.[[:digit:]]+)*)" _ version)
                   (string-append "\"^" version)))))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags
       (list "--release" "--"
             "--skip=case::Case::PseudoRandom"
             "--skip=case::Case::Random"
             "--skip=pattern::Pattern::PseudoRandom")
       #:cargo-inputs
       (("rust-rand" ,rust-rand-0.7)
        ("rust-unicode-segmentation" ,rust-unicode-segmentation-1))
       #:cargo-development-inputs
       (("rust-strum" ,rust-strum-0.18)
        ("rust-strum-macros" ,rust-strum-macros-0.18))))
    (home-page "https://github.com/rutrum/convert-case")
    (synopsis "Convert strings into any case")
    (description "Convert strings into any case.")
    (license license:expat)))

(define-public rust-convert-case-0.4
  (package
    (inherit rust-convert-case-0.6)
    (name "rust-convert-case")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "convert_case" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "03jaf1wrsyqzcaah9jf8l1iznvdw5mlsca2qghhzr9w27sddaib2"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-rand" ,rust-rand-0.7))))))

(define-public rust-coolor-0.8
  (package
    (name "rust-coolor")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "coolor" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1sjrs0k2ng69hilqrrkfayr2rjpwa6b6krp11y3da64zj10kxklm"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t     ; Cut the dependency chain.
       #:cargo-inputs (("rust-crossterm" ,rust-crossterm-0.23))))
    (home-page "https://github.com/Canop/coolor")
    (synopsis "Conversion between color formats")
    (description "Conversion between color formats.")
    (license license:expat)))

(define-public rust-coolor-0.5
  (package
    (inherit rust-coolor-0.8)
    (name "rust-coolor")
    (version "0.5.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "coolor" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "11pvplrm51xjr0mmhwrjaif6vd7p2xpmdbwd0rbx2kr4iq4c4smd"))))
    (arguments
     `(#:cargo-inputs
       (("rust-crossterm" ,rust-crossterm-0.25))
       #:cargo-development-inputs
       (("rust-crossterm" ,rust-crossterm-0.25)
        ("rust-rand" ,rust-rand-0.8))))))

(define-public rust-copyless-0.1
  (package
    (name "rust-copyless")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "copyless" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0dmmxsq3m0i6g9s2kj96n777qhmm7vjgv4r7agc2v6w6bl7rdpx2"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/kvark/copyless")
    (synopsis "Ways to eliminate @code{memcpy} calls")
    (description
     "This package provides ways to eliminate @code{memcpy} calls when using
the standard library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-copypasta-0.10
  (package
    (name "rust-copypasta")
    (version "0.10.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "copypasta" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0n58sfbahs49ar0qivz1sqz1ixhh1ifgp5bzifjkvabwhqi59f6y"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-clipboard-win" ,rust-clipboard-win-3)
                       ("rust-objc" ,rust-objc-0.2)
                       ("rust-objc-foundation" ,rust-objc-foundation-0.1)
                       ("rust-objc-id" ,rust-objc-id-0.1)
                       ("rust-smithay-clipboard" ,rust-smithay-clipboard-0.7)
                       ("rust-x11-clipboard" ,rust-x11-clipboard-0.9))))
    (home-page "https://github.com/alacritty/copypasta")
    (synopsis "Get and set the contents of the OS-level clipboard")
    (description
     "Copypasta is a cross-platform library for getting and setting the
contents of the OS-level clipboard.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cordic-0.1
  (package
    (name "rust-cordic")
    (version "0.1.5")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cordic" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32 "1l0jfhm6kynv61bp9ncmi25bdib40d9pfcajl1gwkidqq1va3l0f"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-fixed" ,rust-fixed-1))))
    (home-page "https://github.com/sebcrozet/cordic")
    (synopsis "Special functions for fixed-point numbers using the CORDIC method")
    (description "This package provides special functions for fixed-point
numbers using the CORDIC method.")
    (license license:bsd-3)))

(define-public rust-core-affinity-0.8
  (package
    (name "rust-core-affinity")
    (version "0.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "core_affinity" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0113rfzyvjpl1camxnrf92pn9vakhn9zqvgir0wgrqawcgsr4a32"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-libc" ,rust-libc-0.2)
                       ("rust-num-cpus" ,rust-num-cpus-1)
                       ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/Elzair/core_affinity_rs")
    (synopsis "Manage CPU affinities")
    (description "This package manages CPU affinities.")
    (license (list license:expat license:asl2.0))))

(define-public rust-core-affinity-0.5
  (package
    (inherit rust-core-affinity-0.8)
    (name "rust-core-affinity")
    (version "0.5.10")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "core_affinity" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "07qpwyxps4gp3gci2p6c5h4cmcql7551bp91qgbv0ky3bh8h72kz"))))
    (arguments
     `(#:cargo-inputs
       (("rust-kernel32-sys" ,rust-kernel32-sys-0.2)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-winapi" ,rust-winapi-0.2))))))

(define-public rust-core-arch-0.1
  (package
    (name "rust-core-arch")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "core_arch" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "04vdvr9vj0f1cv2p54nsszmrrk9w1js4c0z4i0bdlajl1lydslim"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-development-inputs
       (("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.2))))
    (home-page "https://github.com/rust-lang/stdarch")
    (synopsis
     "Rust's core library architecture-specific intrinsics")
    (description
     "@code{core::arch} - Rust's core library architecture-specific
intrinsics.")
    (license (list license:expat license:asl2.0))))

(define-public rust-core-error-0.0.0
  (package
    (name "rust-core-error")
    (version "0.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "core-error" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "13wvc7lcpi7f6rr0racns4l52gzpix4xhih6qns30hmn5sbv5kgg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-version-check" ,rust-version-check-0.9))))
    (home-page "https://github.com/core-error/core-error")
    (synopsis "std::error::Error for libcore")
    (description "std::error::Error for libcore.")
    (license (list license:expat license:asl2.0))))

(define-public rust-core-extensions-1
  (package
    (name "rust-core-extensions")
    (version "1.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "core_extensions" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1vn0jsn8nbi76i2jjadim31piscf0hv8640ng9z608cpgk01viwj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f  ; tests must be run with the "__test" feature
       #:cargo-inputs
       (("rust-core-extensions-proc-macros" ,rust-core-extensions-proc-macros-1)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.4)
        ("rust-static-assertions" ,rust-static-assertions-1))))
    (home-page "https://github.com/rodrimati1992/core_extensions")
    (synopsis
     "Extensions for core/std library types, and other miscellaneous features")
    (description
     "Extensions for core/std library types, and other miscellaneous features.")
    (license (list license:expat license:asl2.0))))

(define-public rust-core-extensions-0.1
  (package
    (inherit rust-core-extensions-1)
    (name "rust-core-extensions")
    (version "0.1.20")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "core_extensions" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1nhgd5rlgp679qm4g3x806ywwhm6qr1y2j3y90wzjgyqllf7w49s"))))
    (arguments
     `(#:skip-build? #t ; failed to resolve: could not find `export` in `_serde`
       #:cargo-inputs
       (("rust-rustc-version" ,rust-rustc-version-0.2)
        ("rust-serde" ,rust-serde-1)
        ("rust-typenum" ,rust-typenum-1))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.4))))))

(define-public rust-core-extensions-proc-macros-1
  (package
    (name "rust-core-extensions-proc-macros")
    (version "1.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "core_extensions_proc_macros" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "19k11haw8s00zxxignjmw0ian0q85r9grhbvr153nvlbs8cv5wv9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1))))
    (home-page "https://github.com/rodrimati1992/core_extensions")
    (synopsis "Implementation detail of the @code{core_extensions} crate")
    (description "Implementation detail of the @code{core_extensions} crate.")
    (license (list license:expat license:asl2.0))))

(define-public rust-core-maths-0.1
  (package
    (name "rust-core-maths")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "core_maths" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "18q9fwy80lk1lccam375skmsslryik00zkhsl850pidqrh2jbc73"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-libm" ,rust-libm-0.2))))
    (home-page "https://github.com/robertbastian/core_maths")
    (synopsis "Extension trait for full float functionality in `#[no_std]`")
    (description
     "This package provides an extension trait for full float functionality in
`#[no_std]` backed by `libm`.")
    (license license:expat)))

(define-public rust-core2-0.4
  (package
    (name "rust-core2")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "core2" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "01f5xv0kf3ds3xm7byg78hycbanb8zlpvsfv4j47y46n3bpsg6xl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-memchr" ,rust-memchr-2))))
    (home-page "https://github.com/bbqsrc/core2")
    (synopsis "Bare essentials of @code{std::io} for use in @code{no_std}")
    (description
      "This package provides the bare essentials of @code{std::io} for use
in @code{no_std}.  Alloc support is optional.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-core2-0.3
  (package
    (inherit rust-core2-0.4)
    (name "rust-core2")
    (version "0.3.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "core2" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32 "1wzzy5iazdk5caadxvjfwrd312rbg7a55a1zpmsdrhk3kfpa77r3"))))
    (arguments `(#:cargo-inputs (("rust-memchr" ,rust-memchr-2))))))

(define-public rust-count-instructions-0.1
  (package
    (name "rust-count-instructions")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "count_instructions" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0ps0254pvx3nmnxs2v60kv7fqayh82r3jqypb4l3ql3i7s3rzr1n"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-rustix" ,rust-rustix-0.38))))
    (home-page "https://github.com/cesarb/count_instructions")
    (synopsis "Counts the instructions executed within a single function")
    (description "Counts the instructions executed within a single function.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cov-mark-2
  (package
    (name "rust-cov-mark")
    (version "2.0.0-pre.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cov-mark" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0jj4yz70k31ax1n3s7iyjv1k5yzrm4hkibrazqciycyrdgvxhj0d"))))
    (arguments `(#:skip-build? #t))
    (build-system cargo-build-system)
    (home-page "https://github.com/matklad/cov-mark")
    (synopsis "Manual coverage marks")
    (description "This package provides a Manual coverage marks.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cov-mark-1
  (package
    (inherit rust-cov-mark-2)
    (name "rust-cov-mark")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cov-mark" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1wv75ylrai556m388a40d50fxiyacmvm6qqz6va6qf1q04z3vylz"))))
    (arguments `())))

(define-public rust-coverage-helper-0.2
  (package
    (name "rust-coverage-helper")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "coverage-helper" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0knim97n8v0yhn82rm4dvn0gds4fbwzx6f2yjdsiwgdv2wbmax41"))
       (modules '((guix build utils)))
       (snippet '(begin
                   (substitute* "Cargo.toml"
                     ;; cfg_attr(coverage_nightly) breaks some cargo versions
                     ;; See issue: https://github.com/taiki-e/cargo-llvm-cov/issues/370
                     (("\\[lints.rust\\]" all)
                      (string-append all "\n"
                       "unexpected_cfgs = { level = \"warn\", "
                       "check-cfg = ['cfg(coverage_nightly)'] }")))))))
    (build-system cargo-build-system)
    (home-page "https://github.com/taiki-e/coverage-helper")
    (synopsis "Helper for cargo-llvm-cov")
    (description
     "Helper for
@url{https://github.com/taiki-e/cargo-llvm-cov/issues/123, cargo-llvm-cov}.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-cpp-demangle-0.4
  (package
    (name "rust-cpp-demangle")
    (version "0.4.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "cpp_demangle" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1ikd484ja34z3mbc1r1zj3y6ymxv3sc5y1n7wrr63xn7vy5zjxic"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-afl" ,rust-afl-0.12)
        ("rust-cfg-if" ,rust-cfg-if-1))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-4)
        ("rust-diff" ,rust-diff-0.1))))
    (home-page "https://github.com/gimli-rs/cpp_demangle")
    (synopsis "Demangle C++ symbols")
    (description
     "This package provides a crate for demangling C++ symbols.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cpp-demangle-0.3
  (package
    (inherit rust-cpp-demangle-0.4)
    (name "rust-cpp-demangle")
    (version "0.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cpp_demangle" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "03vi33qz8x7lll0xd3acd3jp39nvzv174wg424qsb1nkm8z9bapf"))))
    (arguments
     `(#:cargo-inputs (("rust-afl" ,rust-afl-0.11)
                       ("rust-cfg-if" ,rust-cfg-if-1))
       #:cargo-development-inputs (("rust-clap" ,rust-clap-2)
                                   ("rust-diff" ,rust-diff-0.1))))))

(define-public rust-cpufeatures-0.2
  (package
    (name "rust-cpufeatures")
    (version "0.2.16")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cpufeatures" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1hy466fkhxjbb16i7na95wz8yr14d0kd578pwzj5lbkz14jh5f0n"))))
    (build-system cargo-build-system)
    (arguments `(#:cargo-inputs (("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/RustCrypto/utils")
    (synopsis "Alternative to the @code{is_x86_feature_detected!} macro")
    (description
     "Cpufeatures is a lightweight and efficient no-std compatible alternative
to the @code{is_x86_feature_detected!} macro.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cpuid-bool-0.2
  (package
    (name "rust-cpuid-bool")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cpuid-bool" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1fpzag3g655p1lr08jgf5n89snjc2ycqx30mm0w3irc9fc3mvcnw"))))
    (build-system cargo-build-system)
    (arguments
     ;; error: This crate works only on x86 and x86-64 targets.
     (list #:skip-build? (not (target-x86?))))
    (home-page "https://github.com/RustCrypto/utils/tree/master/cpufeatures")
    (synopsis "Replaced by the `cpufeatures` crate")
    (description "This package has been replaced by the `cpufeatures` crate.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crabgrind-0.1
  (package
    (name "rust-crabgrind")
    (version "0.1.11")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crabgrind" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "06rn7ymna8i2d9sf8krshpffd5wzmk18gfrd5041bvclj71rxsfr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags '("--release" "--"
                            "--skip=tests::count_errors"
                            "--skip=tests::non_simd_call"
                            "--skip=tests::test_run_mode_under_valgrind"
                            "--skip=tests::wrong_monitor_command")
       #:cargo-inputs (("rust-cc" ,rust-cc-1))))
    (inputs (list valgrind))
    (home-page "https://github.com/2dav/crabgrind")
    (synopsis "Rust bindings to \"Valgrind Client Request\" interface")
    (description
     "This package provides Rust bindings to \"Valgrind Client Request\" interface.")
    (license license:expat)))

(define-public rust-crates-index-0.19
  (package
    (name "rust-crates-index")
    (version "0.19.13")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crates-index" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1v8x1yb8hx9p1n16p1nz7bmak9b3xj2cfh8dbfyshswx427b7jn3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f  ; Tests need to have network access to the cargo repository.
       #:cargo-test-flags
       '("--release" "--"
         ;; These tests want network access.
         "--skip=bare_index::test::bare_iterator"
         "--skip=bare_index::test::clones_bare_index"
         "--skip=bare_index::test::opens_bare_index"
         "--skip=bare_index::test::reads_replaced_source"
         "--skip=bare_index::test::test_can_parse_all"
         "--skip=bare_index::test::test_cargo_default_updates"
         "--skip=bare_index::test::test_dependencies"
         "--skip=mem_usage")
       #:cargo-inputs (("rust-git2" ,rust-git2-0.17)
                       ("rust-hex" ,rust-hex-0.4)
                       ("rust-home" ,rust-home-0.5)
                       ("rust-http" ,rust-http-0.2)
                       ("rust-memchr" ,rust-memchr-2)
                       ("rust-rayon" ,rust-rayon-1)
                       ("rust-rustc-hash" ,rust-rustc-hash-1)
                       ("rust-semver" ,rust-semver-1)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-serde-derive" ,rust-serde-derive-1)
                       ("rust-serde-json" ,rust-serde-json-1)
                       ("rust-smol-str" ,rust-smol-str-0.2)
                       ("rust-toml" ,rust-toml-0.7))
       #:cargo-development-inputs (("rust-cap" ,rust-cap-0.1)
                                   ("rust-tempfile" ,rust-tempfile-3))))
    (native-inputs (list pkg-config))
    (inputs (list openssl libgit2-1.6 zlib))
    (home-page "https://crates.io/crates/crates-index")
    (synopsis "Retrieving and interacting with the crates.io index")
    (description
     "Library for retrieving and interacting with the crates.io index.")
    (license license:asl2.0)))

(define-public rust-crates-index-0.18
  (package
    (inherit rust-crates-index-0.19)
    (name "rust-crates-index")
    (version "0.18.10")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "crates-index" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1x7f7xfvqzlacji88iaz9n4k7wip72sk4gfvxvccli0cbf2yqirl"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-git2" ,rust-git2-0.15)
        ("rust-hex" ,rust-hex-0.4)
        ("rust-home" ,rust-home-0.5)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-rustc-hash" ,rust-rustc-hash-1)
        ("rust-semver" ,rust-semver-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-smartstring" ,rust-smartstring-1))))))

(define-public rust-crates-index-0.17
  (package
    (inherit rust-crates-index-0.18)
    (name "rust-crates-index")
    (version "0.17.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "crates-index" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0izrm8m4wic5kp5y4p3f3d50lrlbamp3wizlgr4hm56rimfazm4a"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-git2" ,rust-git2-0.13)
        ("rust-glob" ,rust-glob-0.3)
        ("rust-hex" ,rust-hex-0.4)
        ("rust-home" ,rust-home-0.5)
        ("rust-memchr" ,rust-memchr-2)
        ("rust-semver" ,rust-semver-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-smartstring" ,rust-smartstring-0.2))))))

(define-public rust-crates-index-0.13
  (package
    (inherit rust-crates-index-0.17)
    (name "rust-crates-index")
    (version "0.13.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crates-index" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1n7pp6mk59hw3nqlh8irxc9pp0g5ziw7bprqsw2lxvg13cvdp76s"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-error-chain" ,rust-error-chain-0.12)
        ("rust-git2" ,rust-git2-0.9)
        ("rust-glob" ,rust-glob-0.3)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1))
       #:cargo-development-inputs
       (("rust-tempdir" ,rust-tempdir-0.3))))))

(define-public rust-crates-io-0.40
  (package
    (name "rust-crates-io")
    (version "0.40.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crates-io" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1hzi7k6vcx1mdns3wmpdw16k8hv67rlg41axpqm252vjfw93y7sw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-curl" ,rust-curl-0.4)
                       ("rust-percent-encoding" ,rust-percent-encoding-2)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-serde-json" ,rust-serde-json-1)
                       ("rust-thiserror" ,rust-thiserror-1)
                       ("rust-url" ,rust-url-2))))
    (native-inputs (list pkg-config))
    (inputs (list curl openssl zlib))
    (home-page "https://github.com/rust-lang/cargo")
    (synopsis "Helpers for interacting with @url{crates.io}")
    (description "This package provides helpers for interacting with
@url{crates.io}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crc-3
  (package
    (name "rust-crc")
    (version "3.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crc" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1zkx87a5x06xfd6xm5956w4vmdfs0wcxpsn7iwj5jbp2rcapmv46"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-crc-catalog" ,rust-crc-catalog-2))))
    (home-page "https://github.com/mrhooray/crc-rs.git")
    (synopsis "Rust implementation of CRC(16, 32, 64)")
    (description "This package provides a Rust implementation of CRC(16, 32,
64) with support for various standards.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crc-2
  (package
    (inherit rust-crc-3)
    (name "rust-crc")
    (version "2.1.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "crc" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32 "08qfahmly0n5j27g1vkqx9s6mxhm8k4dsp61ykskazyabdlrmz29"))))
    (arguments
     `(#:cargo-inputs (("rust-crc-catalog" ,rust-crc-catalog-1))))))

(define-public rust-crc-1
  (package
    (inherit rust-crc-2)
    (name "rust-crc")
    (version "1.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crc" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1sqal6gm6lbj7f45iv3rw2s9w3pvvha8v970y51s7k7mwy6m8qyn"))))
    (arguments
     `(#:cargo-inputs
       (("rust-build-const" ,rust-build-const-0.2))))))

(define-public rust-crc-any-2
  (package
    (name "rust-crc-any")
    (version "2.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crc-any" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0wzs26q5cf29fhfnrkrjsr8dpai0rlm4im8b53by8rbrbzzwjbm6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-debug-helper" ,rust-debug-helper-0.3)
        ("rust-heapless" ,rust-heapless-0.8))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1))))
    (home-page "https://magiclen.org/crc-any")
    (synopsis "Compute CRC values")
    (description "This package provides a crate to compute CRC values by
providing the length of bits, expression, reflection, an initial value and a
final xor value.  It has many built-in CRC functions.")
    (license license:expat)))

(define-public rust-crc-catalog-2
  (package
    (name "rust-crc-catalog")
    (version "2.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crc-catalog" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1xg7sz82w3nxp1jfn425fvn1clvbzb3zgblmxsyqpys0dckp9lqr"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/akhilles/crc-catalog.git")
    (synopsis "Catalog of CRC algorithms expressed as simple Rust structs")
    (description
     "This package contains a catalog of CRC algorithms (generated from
http://reveng.sourceforge.net/crc-catalogue) expressed as simple Rust structs.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crc-catalog-1
  (package
    (inherit rust-crc-catalog-2)
    (name "rust-crc-catalog")
    (version "1.1.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "crc-catalog" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32 "00qlxgzg15fnyx6nwviibz94rjw803l2avi2k3shjfx0dnsyvbnc"))))))

(define-public rust-crc32fast-1
  (package
    (name "rust-crc32fast")
    (version "1.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crc32fast" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
          "1czp7vif73b8xslr3c9yxysmh9ws2r8824qda7j47ffs9pcnjxx9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-cfg-if" ,rust-cfg-if-1))
       #:cargo-development-inputs (("rust-bencher" ,rust-bencher-0.1)
                                   ("rust-quickcheck" ,rust-quickcheck-1)
                                   ("rust-rand" ,rust-rand-0.8))))
    (home-page "https://github.com/srijs/rust-crc32fast")
    (synopsis "Fast, SIMD-accelerated CRC32 (IEEE) checksum computation")
    (description "Fast, SIMD-accelerated CRC32 (IEEE) checksum computation.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crc64-2
  (package
    (name "rust-crc64")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crc64" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1wwqdss36dmhz4fd0wynlaig463l4dwvr21db1fvf6aypapy61r7"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/badboy/crc64-rs")
    (synopsis "Rust CRC64 checksum implementation")
    (description
     "This package provides a CRC64 checksum implementation in Rust.")
    (license license:bsd-3)))

(define-public rust-critical-section-1
  (package
    (name "rust-critical-section")
    (version "1.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "critical-section" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0hi289hs8kiyqmhwzsrlqrba559av3bzg71f4bs5mz28cf4hjh7n"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/rust-embedded/critical-section")
    (synopsis "Critical section abstraction")
    (description "This package provides a critical section abstraction.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crossbeam-0.8
  (package
    (name "rust-crossbeam")
    (version "0.8.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1a5c7yacnk723x0hfycdbl91ks2nxhwbwy46b8y5vyy0gxzcsdqi"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-crossbeam-channel" ,rust-crossbeam-channel-0.5)
        ("rust-crossbeam-deque" ,rust-crossbeam-deque-0.8)
        ("rust-crossbeam-epoch" ,rust-crossbeam-epoch-0.9)
        ("rust-crossbeam-queue" ,rust-crossbeam-queue-0.3)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.8))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.8))))
    (home-page "https://github.com/crossbeam-rs/crossbeam")
    (synopsis "Tools for concurrent programming in Rust")
    (description "This package provides tools for concurrent programming.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crossbeam-0.7
  (package
    (inherit rust-crossbeam-0.8)
    (name "rust-crossbeam")
    (version "0.7.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "13kzn2d49n2qn5q42y2dj48kyv6aln2d9smq8x9n675l3zzknck9"))))
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-crossbeam-channel" ,rust-crossbeam-channel-0.4)
        ("rust-crossbeam-deque" ,rust-crossbeam-deque-0.7)
        ("rust-crossbeam-epoch" ,rust-crossbeam-epoch-0.8)
        ("rust-crossbeam-queue" ,rust-crossbeam-queue-0.2)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.7))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.6))))))

(define-public rust-crossbeam-channel-0.5
  (package
    (name "rust-crossbeam-channel")
    (version "0.5.13")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-channel" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1wkx45r34v7g3wyi3lg2wz536lrrrab4h4hh741shfhr8rlhsj1k"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags '("--release" "--" "--skip=select2::main")
       #:cargo-inputs (("rust-crossbeam-utils" ,rust-crossbeam-utils-0.8))
       #:cargo-development-inputs (("rust-num-cpus" ,rust-num-cpus-1)
                                   ("rust-rand" ,rust-rand-0.8)
                                   ("rust-signal-hook" ,rust-signal-hook-0.3))))
    (home-page
     "https://github.com/crossbeam-rs/crossbeam/tree/master/crossbeam-channel")
    (synopsis "Multi-producer multi-consumer channels for message passing")
    (description
     "This package provides multi-producer multi-consumer channels for
message passing.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crossbeam-channel-0.4
  (package
    (inherit rust-crossbeam-channel-0.5)
    (name "rust-crossbeam-channel")
    (version "0.4.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "crossbeam-channel" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "11zvmp8p94vaqp4xyhzymw8xndnpwq12x5qgvxkway7lprygwlxi"))))
    (arguments
     `(#:cargo-inputs
        (("rust-crossbeam-utils" ,rust-crossbeam-utils-0.7)
         ("rust-maybe-uninit" ,rust-maybe-uninit-2))
        #:cargo-development-inputs
        (("rust-num-cpus" ,rust-num-cpus-1)
         ("rust-rand" ,rust-rand-0.6)
         ("rust-signal-hook" ,rust-signal-hook-0.1))))))

(define-public rust-crossbeam-channel-0.3
  (package
    (inherit rust-crossbeam-channel-0.4)
    (name "rust-crossbeam-channel")
    (version "0.3.9")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-channel" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1ylyzb1m9qbvd1nd3vy38x9073wdmcy295ncjs7wf7ap476pzv68"))))
    (arguments
     `(#:cargo-inputs
       (("rust-crossbeam-utils" ,rust-crossbeam-utils-0.6))
       #:cargo-development-inputs
       (("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-rand" ,rust-rand-0.6)
        ("rust-signal-hook" ,rust-signal-hook-0.1))))))

(define-public rust-crossbeam-deque-0.8
  (package
    (name "rust-crossbeam-deque")
    (version "0.8.5")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "crossbeam-deque" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "03bp38ljx4wj6vvy4fbhx41q8f585zyqix6pncz1mkz93z08qgv1"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-crossbeam-epoch" ,rust-crossbeam-epoch-0.9)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.8))
       #:cargo-development-inputs (("rust-rand" ,rust-rand-0.8))))
    (home-page
     "https://github.com/crossbeam-rs/crossbeam/tree/master/crossbeam-deque")
    (synopsis "Concurrent work-stealing deque")
    (description "This package provides a concurrent work-stealing deque.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crossbeam-deque-0.7
  (package
    (inherit rust-crossbeam-deque-0.8)
    (name "rust-crossbeam-deque")
    (version "0.7.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-deque" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1v99xcdjk4zixvxnq7pssip670mlyhw1ma3qc88ca11jxnfz43y2"))))
    (arguments
     `(#:cargo-inputs
       (("rust-crossbeam-epoch" ,rust-crossbeam-epoch-0.8)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.7)
        ("rust-maybe-uninit" ,rust-maybe-uninit-2))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.6))))))

(define-public rust-crossbeam-epoch-0.9
  (package
    (name "rust-crossbeam-epoch")
    (version "0.9.18")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-epoch" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "03j2np8llwf376m3fxqx859mgp9f83hj1w34153c7a9c7i5ar0jv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-crossbeam-utils" ,rust-crossbeam-utils-0.8)
        ("rust-loom" ,rust-loom-0.7))
       #:cargo-development-inputs (("rust-rand" ,rust-rand-0.8))))
    (home-page
     "https://github.com/crossbeam-rs/crossbeam/tree/master/crossbeam-epoch")
    (synopsis "Epoch-based garbage collection")
    (description "This package provides an Epoch-based garbage collection.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crossbeam-epoch-0.8
  (package
    (inherit rust-crossbeam-epoch-0.9)
    (name "rust-crossbeam-epoch")
    (version "0.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-epoch" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1knsf0zz7rgzxn0nwz5gajjcrivxpw3zrdcp946gdhdgr9sd53h5"))))
    (arguments
     `(#:cargo-inputs
       (("rust-autocfg" ,rust-autocfg-1)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.7)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-maybe-uninit" ,rust-maybe-uninit-2)
        ("rust-memoffset" ,rust-memoffset-0.5)
        ("rust-scopeguard" ,rust-scopeguard-1))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.6))))))

(define-public rust-crossbeam-queue-0.3
  (package
    (name "rust-crossbeam-queue")
    (version "0.3.11")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-queue" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0d8y8y3z48r9javzj67v3p2yfswd278myz1j9vzc4sp7snslc0yz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-crossbeam-utils" ,rust-crossbeam-utils-0.8))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.8))))
    (home-page
     "https://github.com/crossbeam-rs/crossbeam/tree/master/crossbeam-utils")
    (synopsis "Concurrent queues in Rust")
    (description
     "This crate provides concurrent queues that can be shared among threads.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crossbeam-queue-0.2
  (package
    (inherit rust-crossbeam-queue-0.3)
    (name "rust-crossbeam-queue")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-queue" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0w15z68nz3ac4f2s4djhwha8vmlwsh9dlfrmsl4x84y2ah5acjvp"))))
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.7)
        ("rust-maybe-uninit" ,rust-maybe-uninit-2))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.6))))))

(define-public rust-crossbeam-queue-0.1
  (package
    (inherit rust-crossbeam-queue-0.2)
    (name "rust-crossbeam-queue")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-queue" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0jsa9dbxnwqcxfws09vaschf92d4imlbbikmcn4ka8z7rzb9r5vw"))))
    (arguments
     `(#:cargo-inputs
       (("rust-crossbeam-utils" ,rust-crossbeam-utils-0.6))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.6))))))

(define-public rust-crossbeam-utils-0.8
  (package
    (name "rust-crossbeam-utils")
    (version "0.8.20")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-utils" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "100fksq5mm1n7zj242cclkw6yf7a4a8ix3lvpfkhxvdhbda9kv12"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-loom" ,rust-loom-0.7))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.8))))
    (home-page
     "https://github.com/crossbeam-rs/crossbeam/tree/master/crossbeam-utils")
    (synopsis "Utilities for concurrent programming")
    (description
     "This crate provides miscellaneous tools for concurrent programming.")
    (license (list license:expat license:asl2.0))))

(define-public rust-crossbeam-utils-0.7
  (package
    (inherit rust-crossbeam-utils-0.8)
    (name "rust-crossbeam-utils")
    (version "0.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-utils" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1a31wbrda1320gj2a6az1lin2d34xfc3xf88da4c17qy5lxcgiy3"))))
    (arguments
     `(#:cargo-inputs
       (("rust-autocfg" ,rust-autocfg-1)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-lazy-static" ,rust-lazy-static-1))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.6))))))

(define-public rust-crossbeam-utils-0.6
  (package
    (inherit rust-crossbeam-utils-0.7)
    (name "rust-crossbeam-utils")
    (version "0.6.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossbeam-utils" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1rk0r9n04bmq4a3g2q5qhvvlmrmx780gc6h9lmc94mwndslkz5q4"))))
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-lazy-static" ,rust-lazy-static-1))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.6))))))

(define-public rust-crossfont-0.8
  (package
    (name "rust-crossfont")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossfont" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1g490ap42qm1258222azy70mmd6b16dk8lza0142bjgk438jhkn4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cocoa" ,rust-cocoa-0.25)
        ("rust-core-foundation" ,rust-core-foundation-0.9)
        ("rust-core-foundation-sys" ,rust-core-foundation-sys-0.8)
        ("rust-core-graphics" ,rust-core-graphics-0.23)
        ("rust-core-text" ,rust-core-text-20)
        ("rust-dwrote" ,rust-dwrote-0.11)
        ("rust-foreign-types" ,rust-foreign-types-0.5)
        ("rust-freetype-rs" ,rust-freetype-rs-0.36)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-objc" ,rust-objc-0.2)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-pkg-config" ,rust-pkg-config-0.3)
        ("rust-winapi" ,rust-winapi-0.3)
        ("rust-yeslogic-fontconfig-sys" ,rust-yeslogic-fontconfig-sys-5))))
    (inputs
     (list expat fontconfig freetype))
    (native-inputs
     (list pkg-config))
    (home-page "https://github.com/alacritty/crossfont")
    (synopsis "Native font loading and rasterization")
    (description
     "Crossfont is a cross-platform Rust library for loading fonts and
rasterizing glyphs, using native font engines whenever possible.")
    (license license:asl2.0)))

(define-public rust-crossfont-0.7
  (package
    (inherit rust-crossfont-0.8)
    (name "rust-crossfont")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossfont" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0g09b9rq51v3xdnswmvwpgv3yp2b75lqvx3mv1l864fddqq6b778"))))
    (arguments
     `(#:cargo-inputs (("rust-cocoa" ,rust-cocoa-0.25)
                       ("rust-core-foundation" ,rust-core-foundation-0.9)
                       ("rust-core-foundation-sys" ,rust-core-foundation-sys-0.8)
                       ("rust-core-graphics" ,rust-core-graphics-0.23)
                       ("rust-core-text" ,rust-core-text-20)
                       ("rust-dwrote" ,rust-dwrote-0.11)
                       ("rust-foreign-types" ,rust-foreign-types-0.5)
                       ("rust-freetype-rs" ,rust-freetype-rs-0.26)
                       ("rust-libc" ,rust-libc-0.2)
                       ("rust-log" ,rust-log-0.4)
                       ("rust-objc" ,rust-objc-0.2)
                       ("rust-once-cell" ,rust-once-cell-1)
                       ("rust-pkg-config" ,rust-pkg-config-0.3)
                       ("rust-servo-fontconfig" ,rust-servo-fontconfig-0.5)
                       ("rust-winapi" ,rust-winapi-0.3))))))

(define-public rust-crossfont-0.5
  (package
    (inherit rust-crossfont-0.7)
    (name "rust-crossfont")
    (version "0.5.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "crossfont" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0icwpj9plf7bs0k34x86c58bwqyx2j3ji98aaahsncga6vfkmz91"))))
    (arguments
     `(#:cargo-build-flags '("--features" "force_system_fontconfig")
       #:cargo-inputs
       (("rust-cocoa" ,rust-cocoa-0.24)
        ("rust-core-foundation" ,rust-core-foundation-0.9)
        ("rust-core-foundation-sys" ,rust-core-foundation-sys-0.8)
        ("rust-core-graphics" ,rust-core-graphics-0.22)
        ("rust-core-text" ,rust-core-text-19)
        ("rust-dwrote" ,rust-dwrote-0.11)
        ("rust-foreign-types" ,rust-foreign-types-0.5)
        ("rust-freetype-rs" ,rust-freetype-rs-0.26)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-objc" ,rust-objc-0.2)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-pkg-config" ,rust-pkg-config-0.3)
        ("rust-servo-fontconfig" ,rust-servo-fontconfig-0.5)
        ("rust-winapi" ,rust-winapi-0.3))))))

(define-public rust-crossterm-0.28
  (package
    (name "rust-crossterm")
    (version "0.28.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossterm" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1im9vs6fvkql0sr378dfr4wdm1rrkrvr22v4i8byz05k1dd9b7c2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-bitflags" ,rust-bitflags-2)
                       ("rust-crossterm-winapi" ,rust-crossterm-winapi-0.9)
                       ("rust-filedescriptor" ,rust-filedescriptor-0.8)
                       ("rust-futures-core" ,rust-futures-core-0.3)
                       ("rust-libc" ,rust-libc-0.2)
                       ("rust-mio" ,rust-mio-1)
                       ("rust-parking-lot" ,rust-parking-lot-0.12)
                       ("rust-rustix" ,rust-rustix-0.38)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-signal-hook" ,rust-signal-hook-0.3)
                       ("rust-signal-hook-mio" ,rust-signal-hook-mio-0.2)
                       ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs (("rust-async-std" ,rust-async-std-1)
                                   ("rust-futures" ,rust-futures-0.3)
                                   ("rust-futures-timer" ,rust-futures-timer-3)
                                   ("rust-serde-json" ,rust-serde-json-1)
                                   ("rust-serial-test" ,rust-serial-test-2)
                                   ("rust-temp-env" ,rust-temp-env-0.3)
                                   ("rust-tokio" ,rust-tokio-1))))
    (home-page "https://github.com/crossterm-rs/crossterm")
    (synopsis "Crossplatform terminal library for manipulating terminals")
    (description
     "This package provides a crossplatform terminal library for manipulating
terminals.")
    (license license:expat)))

(define-public rust-crossterm-0.27
  (package
    (inherit rust-crossterm-0.28)
    (name "rust-crossterm")
    (version "0.27.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossterm" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1pr413ki440xgddlmkrc4j1bfx1h8rpmll87zn8ykja1bm2gwxpl"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-2)
        ("rust-crossterm-winapi" ,rust-crossterm-winapi-0.9)
        ("rust-filedescriptor" ,rust-filedescriptor-0.8)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-mio" ,rust-mio-0.8)
        ("rust-parking-lot" ,rust-parking-lot-0.12)
        ("rust-serde" ,rust-serde-1)
        ("rust-signal-hook" ,rust-signal-hook-0.3)
        ("rust-signal-hook-mio" ,rust-signal-hook-mio-0.2)
        ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs
       (("rust-async-std" ,rust-async-std-1)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-futures-timer" ,rust-futures-timer-3)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serial-test" ,rust-serial-test-2)
        ("rust-tokio" ,rust-tokio-1))))))

(define-public rust-crossterm-0.26
  (package
    (inherit rust-crossterm-0.27)
    (name "rust-crossterm")
    (version "0.26.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossterm" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "04rxvmbf3scywy0m7rhg586lf833vpb33czijxi80fakadkxlk58"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-crossterm-winapi" ,rust-crossterm-winapi-0.9)
        ("rust-filedescriptor" ,rust-filedescriptor-0.8)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-mio" ,rust-mio-0.8)
        ("rust-parking-lot" ,rust-parking-lot-0.12)
        ("rust-serde" ,rust-serde-1)
        ("rust-signal-hook" ,rust-signal-hook-0.3)
        ("rust-signal-hook-mio" ,rust-signal-hook-mio-0.2)
        ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs
       (("rust-async-std" ,rust-async-std-1)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-futures-timer" ,rust-futures-timer-3)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-tokio" ,rust-tokio-1))))))

(define-public rust-crossterm-0.25
  (package
    (inherit rust-crossterm-0.26)
    (name "rust-crossterm")
    (version "0.25.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "crossterm" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32 "0rsbkkhdf61aipc06b7vpl4cw3wnxz0miizp0ms3a5rcpq7nqkp6"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-crossterm-winapi" ,rust-crossterm-winapi-0.9)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-mio" ,rust-mio-0.8)
        ("rust-parking-lot" ,rust-parking-lot-0.12)
        ("rust-serde" ,rust-serde-1)
        ("rust-signal-hook" ,rust-signal-hook-0.3)
        ("rust-signal-hook-mio" ,rust-signal-hook-mio-0.2)
        ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs
       (("rust-async-std" ,rust-async-std-1)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-futures-timer" ,rust-futures-timer-3)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-tokio" ,rust-tokio-1))))))

(define-public rust-crossterm-0.23
  (package
    (inherit rust-crossterm-0.25)
    (name "rust-crossterm")
    (version "0.23.2")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "crossterm" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "05ygjddfp70961ij7cbvrrwz88r09hghdpcqbf50z4c1yyj2w452"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-crossterm-winapi" ,rust-crossterm-winapi-0.9)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-mio" ,rust-mio-0.8)
        ("rust-parking-lot" ,rust-parking-lot-0.12)
        ("rust-serde" ,rust-serde-1)
        ("rust-signal-hook" ,rust-signal-hook-0.3)
        ("rust-signal-hook-mio" ,rust-signal-hook-mio-0.2)
        ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs
       (("rust-async-std" ,rust-async-std-1)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-futures-timer" ,rust-futures-timer-3)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-tokio" ,rust-tokio-1))))))

(define-public rust-crossterm-0.20
  (package
    (inherit rust-crossterm-0.25)
    (name "rust-crossterm")
    (version "0.20.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossterm" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0z8zkk2mfiirbr3slfv564n685yiahr2aj3gdk6k3qymkmmdxsy0"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-crossterm-winapi" ,rust-crossterm-winapi-0.8)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-mio" ,rust-mio-0.7)
        ("rust-parking-lot" ,rust-parking-lot-0.11)
        ("rust-serde" ,rust-serde-1)
        ("rust-signal-hook" ,rust-signal-hook-0.3)
        ("rust-signal-hook-mio" ,rust-signal-hook-mio-0.2)
        ("rust-winapi" ,rust-winapi-0.3))))))

(define-public rust-crossterm-0.19
  (package
    (inherit rust-crossterm-0.20)
    (name "rust-crossterm")
    (version "0.19.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossterm" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1348lqf8vy3lb2s5icsl3rxs4a4vrpfw5z2j6lplnhnz600w2dkw"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-crossterm-winapi" ,rust-crossterm-winapi-0.7)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-mio" ,rust-mio-0.7)
        ("rust-parking-lot" ,rust-parking-lot-0.11)
        ("rust-serde" ,rust-serde-1)
        ("rust-signal-hook" ,rust-signal-hook-0.1)
        ("rust-winapi" ,rust-winapi-0.3))))))

(define-public rust-crossterm-winapi-0.9
  (package
    (name "rust-crossterm-winapi")
    (version "0.9.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "crossterm_winapi" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32 "0axbfb2ykbwbpf1hmxwpawwfs8wvmkcka5m561l7yp36ldi7rpdc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/crossterm-rs/crossterm-winapi")
    (synopsis "Basic simple abstractions around common WinAPI calls")
    (description
     "This package is a WinAPI wrapper that provides some basic simple
abstractions around common WinAPI calls.")
    (license license:expat)))

(define-public rust-crossterm-winapi-0.8
  (package
    (inherit rust-crossterm-winapi-0.9)
    (name "rust-crossterm-winapi")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossterm_winapi" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "01q57jwnlicqxa2igg5nig3916kf5w6sqgbxk40q6hr2frh6cs9s"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-winapi" ,rust-winapi-0.3))))))

(define-public rust-crossterm-winapi-0.7
  (package
    (inherit rust-crossterm-winapi-0.8)
    (name "rust-crossterm-winapi")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crossterm_winapi" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1fa047zz228qyqbcjdss64j0n01p4adr29yh9w24lgjdrr59da0d"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-winapi" ,rust-winapi-0.3))))))

(define-public rust-crosstermion-0.14
  (package
    (name "rust-crosstermion")
    (version "0.14.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crosstermion" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1i7caxqlz174zj6pll85vp4avhhzzy00vfdivry3v5hq3phgzf1v"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-ansiterm" ,rust-ansiterm-0.12)
        ("rust-async-channel" ,rust-async-channel-2)
        ("rust-crossterm" ,rust-crossterm-0.27)
        ("rust-futures-channel" ,rust-futures-channel-0.3)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-futures-lite" ,rust-futures-lite-2)
        ("rust-ratatui" ,rust-ratatui-0.26)
        ("rust-tui-react" ,rust-tui-react-0.23))))
    (home-page "https://github.com/Byron/tui-crates")
    (synopsis
      "Unification of crossterm and termion behind a common facade")
    (description
      "The unification of crossterm and termion behind a common facade for use with
feature flags.")
    (license license:expat)))

(define-public rust-crosstermion-0.13
  (package
    (inherit rust-crosstermion-0.14)
    (name "rust-crosstermion")
    (version "0.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crosstermion" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1q877s6rfm4n4amsg79ihxi583lhmlnq57hj9sg1ph2ddyw1a120"))))
    (arguments
     `(#:cargo-inputs (("rust-ansiterm" ,rust-ansiterm-0.12)
                       ("rust-async-channel" ,rust-async-channel-2)
                       ("rust-crossterm" ,rust-crossterm-0.27)
                       ("rust-futures-channel" ,rust-futures-channel-0.3)
                       ("rust-futures-core" ,rust-futures-core-0.3)
                       ("rust-futures-lite" ,rust-futures-lite-2)
                       ("rust-ratatui" ,rust-ratatui-0.25)
                       ("rust-tui-react" ,rust-tui-react-0.22))))
    (license license:expat)))

(define-public rust-crosstermion-0.11
  (package
    (inherit rust-crosstermion-0.13)
    (name "rust-crosstermion")
    (version "0.11.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crosstermion" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0jbpxv2h08a1rvpw42iq59l2y0xbqvzpdq09043i8ihdc9nz8bhm"))))
    (arguments
     `(#:cargo-inputs (("rust-ansi-term" ,rust-ansi-term-0.12)
                       ("rust-async-channel" ,rust-async-channel-1)
                       ("rust-crossterm" ,rust-crossterm-0.26)
                       ("rust-futures-channel" ,rust-futures-channel-0.3)
                       ("rust-futures-core" ,rust-futures-core-0.3)
                       ("rust-futures-lite" ,rust-futures-lite-1)
                       ("rust-ratatui" ,rust-ratatui-0.20)
                       ("rust-termion" ,rust-termion-2)
                       ("rust-tui-react" ,rust-tui-react-0.20))))))

(define-public rust-crunchy-0.2
  (package
    (name "rust-crunchy")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "crunchy" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1dx9mypwd5mpfbbajm78xcrg5lirqk7934ik980mmaffg3hdm0bs"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://docs.rs/crate/crunchy/0.2.2/source/")
    (synopsis "Deterministically unroll constant loops")
    (description
     "The Crunchy unroller deterministically unrolls constant loops, for
number ``crunching``.")
    (license license:expat)))

(define-public rust-csscolorparser-0.6
  (package
    (name "rust-csscolorparser")
    (version "0.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "csscolorparser" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1gxh11hajx96mf5sd0az6mfsxdryfqvcfcphny3yfbfscqq7sapb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-cint" ,rust-cint-0.3)
                       ("rust-lab" ,rust-lab-0.11)
                       ("rust-phf" ,rust-phf-0.11)
                       ("rust-rgb" ,rust-rgb-0.8)
                       ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs (("rust-serde-test" ,rust-serde-test-1))))
    (home-page "https://github.com/mazznoer/csscolorparser-rs")
    (synopsis "CSS color parser library")
    (description "This crate is a CSS color parser library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cssparser-0.34
  (package
    (name "rust-cssparser")
    (version "0.34.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cssparser" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1qx3hha392szcl812l6hp0d4029gg8x62cl4nf0byqgdv0f6vimp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f  ; Not all files included in the tarball.
       #:cargo-inputs (("rust-cssparser-macros" ,rust-cssparser-macros-0.6)
                       ("rust-dtoa-short" ,rust-dtoa-short-0.3)
                       ("rust-itoa" ,rust-itoa-1)
                       ("rust-phf" ,rust-phf-0.11)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-smallvec" ,rust-smallvec-1))
       #:cargo-development-inputs (("rust-difference" ,rust-difference-2)
                                   ("rust-encoding-rs" ,rust-encoding-rs-0.8)
                                   ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/servo/rust-cssparser")
    (synopsis "Rust implementation of CSS Syntax Level 3")
    (description
     "This package contains a Rust implementation of CSS Syntax Level 3.")
    (license license:mpl2.0)))

(define-public rust-cssparser-0.33
  (package
    (inherit rust-cssparser-0.34)
    (name "rust-cssparser")
    (version "0.33.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cssparser" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "07i8k47fmym7kzs95qfhg6zrh4yyf2vl4460rmdyvyx06vck9scv"))))
    (arguments
     `(#:tests? #f  ; Not all files included in the tarball.
       #:cargo-inputs (("rust-cssparser-macros" ,rust-cssparser-macros-0.6)
                       ("rust-dtoa-short" ,rust-dtoa-short-0.3)
                       ("rust-itoa" ,rust-itoa-1)
                       ("rust-phf" ,rust-phf-0.8)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-smallvec" ,rust-smallvec-1))
       #:cargo-development-inputs (("rust-difference" ,rust-difference-2)
                                   ("rust-encoding-rs" ,rust-encoding-rs-0.8)
                                   ("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-cssparser-0.31
  (package
    (inherit rust-cssparser-0.33)
    (name "rust-cssparser")
    (version "0.31.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cssparser" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1gnmn2wjvhvkj98ygcd5jdwi0wxsigvd7j0yq0zfgfsz7vwz8gav"))))
    (arguments
     `(#:tests? #f  ; Not all files included in the tarball.
       #:cargo-inputs (("rust-cssparser-macros" ,rust-cssparser-macros-0.6)
                       ("rust-dtoa-short" ,rust-dtoa-short-0.3)
                       ("rust-itoa" ,rust-itoa-1)
                       ("rust-phf" ,rust-phf-0.8)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-smallvec" ,rust-smallvec-1))
       #:cargo-development-inputs (("rust-difference" ,rust-difference-2)
                                   ("rust-encoding-rs" ,rust-encoding-rs-0.8)
                                   ("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-cssparser-0.29
  (package
    (inherit rust-cssparser-0.33)
    (name "rust-cssparser")
    (version "0.29.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cssparser" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1yp0zl5cmw9x95np9a51153fdb1ng8fgzwyssg7hr5dmki0h6ggr"))))
    (arguments
     `(#:tests? #f  ; Not all files included in the tarball.
       #:cargo-inputs
       (("rust-cssparser-macros" ,rust-cssparser-macros-0.6)
        ("rust-dtoa-short" ,rust-dtoa-short-0.3)
        ("rust-itoa" ,rust-itoa-1)
        ("rust-matches" ,rust-matches-0.1)
        ("rust-phf" ,rust-phf-0.10)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-smallvec" ,rust-smallvec-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-difference" ,rust-difference-2)
        ("rust-encoding-rs" ,rust-encoding-rs-0.8)
        ("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-cssparser-0.28
  (package
    (inherit rust-cssparser-0.29)
    (name "rust-cssparser")
    (version "0.28.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cssparser" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1h924c5g2rwlmgk8hllciyky3ih3z9vf04xz3xsp3cv1jyd5kf0x"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cssparser-macros" ,rust-cssparser-macros-0.6)
        ("rust-dtoa-short" ,rust-dtoa-short-0.3)
        ("rust-itoa" ,rust-itoa-0.4)
        ("rust-matches" ,rust-matches-0.1)
        ("rust-phf" ,rust-phf-0.8)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-smallvec" ,rust-smallvec-1)
        ("rust-syn" ,rust-syn-1))))))

(define-public rust-cssparser-0.27
  (package
    (inherit rust-cssparser-0.28)
    (name "rust-cssparser")
    (version "0.27.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cssparser" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "02nbm690rmkaz1ca0383qq7mc1g066w3s85f17pdihnda79njjvm"))))
    (arguments
     `(#:tests? #f  ; Not all files included in the tarball.
       #:cargo-inputs
       (("rust-cssparser-macros" ,rust-cssparser-macros-0.6)
        ("rust-dtoa-short" ,rust-dtoa-short-0.3)
        ("rust-itoa" ,rust-itoa-0.4)
        ("rust-matches" ,rust-matches-0.1)
        ("rust-phf" ,rust-phf-0.8)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-smallvec" ,rust-smallvec-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-difference" ,rust-difference-2)
        ("rust-encoding-rs" ,rust-encoding-rs-0.8)
        ("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-cssparser-macros-0.6
  (package
    (name "rust-cssparser-macros")
    (version "0.6.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cssparser-macros" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32 "0cfkzj60avrnskdmaf7f8zw6pp3di4ylplk455zrzaf19ax8id8k"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags '("--release" "--"
                            "--skip=match_byte")
       #:cargo-inputs (("rust-quote" ,rust-quote-1)
                       ("rust-syn" ,rust-syn-2))))
    (home-page "https://github.com/servo/rust-cssparser")
    (synopsis "Procedural macros for cssparser")
    (description
     "This package provides the procedural macros for rust-cssparser.")
    (license license:mpl2.0)))

(define-public rust-cstr-0.2
  (package
    (name "rust-cstr")
    (version "0.2.12")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cstr" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0dj6ll9ry27kn4k0vvhlvbhn9dyyr9haxnd06bxaqnmfr01kjlk8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1))
       #:cargo-development-inputs (("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://github.com/upsuper/cstr")
    (synopsis "Macro for building static CStr reference")
    (description
     "This package provides the macro for building static CStr reference.")
    (license license:expat)))

(define-public rust-cstr-core-0.2
  (package
    (name "rust-cstr-core")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cstr_core" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1fymp34mv7bix8m35pw3qs30b7879wmaym03ihfbzdl84plwa1r8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cty" ,rust-cty-0.2)
        ("rust-memchr" ,rust-memchr-2))))
    (home-page "https://github.com/Amanieu/cstr_core")
    (synopsis "Implementation of CStr and CString for no_std environments")
    (description
     "This crates implements CStr and CString for no_std environments.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-csv-1
  (package
    (name "rust-csv")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "csv" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1zjrlycvn44fxd9m8nwy8x33r9ncgk0k3wvy4fnvb9rpsks4ymxc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-csv-core" ,rust-csv-core-0.1)
                       ("rust-itoa" ,rust-itoa-1)
                       ("rust-ryu" ,rust-ryu-1)
                       ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs (("rust-bstr" ,rust-bstr-1)
                                   ("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/BurntSushi/rust-csv")
    (synopsis "Fast CSV parsing with support for serde")
    (description "Fast CSV parsing with support for serde.")
    (license (list license:unlicense license:expat))))

(define-public rust-csv-0.14
  (package
    (inherit rust-csv-1)
    (name "rust-csv")
    (version "0.14.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "csv" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1g0qvr9fj25fq1fy0p758glrb30yz7x46h18hsysaqyaswaihv16"))))
    (arguments
     `(#:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-0.5)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3))
       #:cargo-development-inputs
       (("rust-regex" ,rust-regex-0.1))))))

(define-public rust-csv-async-1
  (package
    (name "rust-csv-async")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "csv-async" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1w60k4pqm1lnbv0mbz1d1ypmkx487r0q36hyrrh84jkzs2qfazyk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; Errors in the test suite code.
       #:cargo-inputs (("rust-cfg-if" ,rust-cfg-if-1)
                       ("rust-csv-core" ,rust-csv-core-0.1)
                       ("rust-futures" ,rust-futures-0.3)
                       ("rust-itoa" ,rust-itoa-1)
                       ("rust-ryu" ,rust-ryu-1)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-tokio" ,rust-tokio-1)
                       ("rust-tokio-stream" ,rust-tokio-stream-0.1))
       #:cargo-development-inputs (("rust-async-std" ,rust-async-std-1)
                                   ("rust-bstr" ,rust-bstr-1)
                                   ("rust-chrono" ,rust-chrono-0.4)
                                   ("rust-indoc" ,rust-indoc-2)
                                   ("rust-serde" ,rust-serde-1)
                                   ("rust-tokio" ,rust-tokio-1))))
    (home-page "https://github.com/gwierzchowski/csv-async")
    (synopsis "CSV parsing for async")
    (description "This package provides CSV parsing for async.")
    (license license:expat)))

(define-public rust-csv-core-0.1
  (package
    (name "rust-csv-core")
    (version "0.1.11")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "csv-core" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0w7s7qa60xb054rqddpyg53xq2b29sf3rbhcl8sbdx02g4yjpyjy"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-memchr" ,rust-memchr-2))
       #:cargo-development-inputs (("rust-arrayvec" ,rust-arrayvec-0.5))))
    (home-page "https://github.com/BurntSushi/rust-csv")
    (synopsis "Bare bones CSV parsing with no_std support")
    (description "Bare bones CSV parsing with no_std support.")
    (license (list license:unlicense license:expat))))

(define-public rust-csv-index-0.1
  (package
    (name "rust-csv-index")
    (version "0.1.6")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "csv-index" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "01048y84y0bakqm0x4y1svjv6lzc753b9q598xp7xgcqrdgi6x7j"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1)
        ("rust-csv" ,rust-csv-1))))
    (home-page "https://github.com/BurntSushi/rust-csv")
    (synopsis "On disk CSV indexing data structures")
    (description "On disk CSV indexing data structures.")
    (license (list license:unlicense license:expat))))

(define-public rust-ct-codecs-1
  (package
    (name "rust-ct-codecs")
    (version "1.1.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "ct-codecs" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1pvmrkk95jadmhhd5mn88mq2dfnq0yng8mk3pfd5l6dq0i2fpdzk"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/jedisct1/rust-ct-codecs")
    (synopsis
     "Constant-time hex and base64 codecs from libsodium reimplemented in Rust")
    (description
     "This package provides constant-time hex and base64 codecs from libsodium
reimplemented in Rust")
    (license license:expat)))

(define-public rust-ct-logs-0.8
  (package
    (name "rust-ct-logs")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ct-logs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1j5as2h789c2gazq3drl5i58xk8zzx6sxd1wdr19x3d6dwc1da61"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-sct" ,rust-sct-0.6))))
    (home-page "https://github.com/ctz/ct-logs")
    (synopsis "Google's list of Certificate Transparency logs")
    (description
     "This package contains Google's list of Certificate Transparency logs for
use with sct crate.")
    (license (list license:asl2.0 license:isc license:expat))))

(define-public rust-ctor-0.2
  (package
    (name "rust-ctor")
    (version "0.2.8")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "ctor" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "17yxfh3qkj9l6a1rmb8crw8189f1rw4a5m5c2xdy8gigh9j93d7d"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-2))
       #:cargo-development-inputs
       (("rust-libc-print" ,rust-libc-print-0.1))))
    (home-page "https://github.com/mmastrac/rust-ctor")
    (synopsis "Rust's __attribute__((constructor))")
    (description
     "This package provides an @code{__attribute__((constructor))} for Rust.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-ctor-0.1
  (package
    (inherit rust-ctor-0.2)
    (name "rust-ctor")
    (version "0.1.26")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "ctor" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32 "15m0wqhv12p25xkxz5dxvg23r7a6bkh7p8zi1cdhgswjhdl028vd"))))
    (arguments
     (list #:cargo-inputs
           `(("rust-syn" ,rust-syn-1)
             ("rust-quote" ,rust-quote-1))
           #:cargo-development-inputs
           `(("rust-libc-print" ,rust-libc-print-0.1))))))

(define-public rust-ctrlc-3
  (package
    (name "rust-ctrlc")
    (version "3.4.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ctrlc" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1lqdhyl8csq8l2011g4w3wjps84w2cmwfn7jhx79ngrgm45apvlh"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-nix" ,rust-nix-0.29)
        ("rust-windows-sys" ,rust-windows-sys-0.59))
       #:cargo-development-inputs
       (("rust-signal-hook" ,rust-signal-hook-0.3)
        ("rust-windows-sys" ,rust-windows-sys-0.59))))
    (home-page "https://github.com/Detegr/rust-ctrlc")
    (synopsis "Easy Ctrl-C handler for Rust projects")
    (description
     "This package provides an easy Ctrl-C handler for Rust projects.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cty-0.2
  (package
    (name "rust-cty")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cty" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1qvkdnkxmd7g6fwhmv26zxqi0l7b9cd4d7h1knylvjyh43bc04vk"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/japaric/cty")
    (synopsis "Type aliases to C types")
    (description "This package provides type aliases to C types like c_int for
use with bindgen.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cuda-std-0.2
  (package
    (name "rust-cuda-std")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cuda_std" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "174237dj152dvndvykcn17nz2d0kdzsyyxnb6fsdz3i7xa8lfcgn"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; Test suite can't find attribute 'kernel'.
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-cuda-std-macros" ,rust-cuda-std-macros-0.2)
        ("rust-half" ,rust-half-1)
        ("rust-paste" ,rust-paste-1)
        ("rust-vek" ,rust-vek-0.15))))
    (home-page "https://github.com/Rust-GPU/Rust-CUDA")
    (synopsis "Standard library for CUDA with rustc_codegen_nvvm")
    (description "Standard library for CUDA with rustc_codegen_nvvm.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cuda-std-macros-0.2
  (package
    (name "rust-cuda-std-macros")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cuda_std_macros" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0hlakxn9pz8233pwsh44j8gzqzf078a3lnnq3v2cadmb4c4l1mlz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/Rust-GPU/Rust-CUDA")
    (synopsis "Macros for cuda_std")
    (description "This package provides macros for cuda_std.")
    (license (list license:expat license:asl2.0))))

(define-public rust-culpa-1
  (package
    (name "rust-culpa")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "culpa" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1lqzzl88vs3h6ljpj6gi8wgkwyqm9gp6dmsnbbzv873v67lvzq2s"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-culpa-macros" ,rust-culpa-macros-1))))
    (home-page "https://github.com/Nullus157/culpa")
    (synopsis "library for error-handling syntax in Rust")
    (description
     "This package provides a library for error-handling syntax in Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-culpa-macros-1
  (package
    (name "rust-culpa-macros")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "culpa-macros" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0ya207axxrjixibdnqfk0h9f96b2b1xmxdw9rwfwglv6f1qy2d0j"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-syn" ,rust-syn-2))))
    (home-page "https://github.com/Nullus157/culpa")
    (synopsis "Internal implementation details of `culpa`")
    (description
     "This package provides internal implementation details of `culpa`.")
    (license (list license:expat license:asl2.0))))

(define-public rust-curl-0.4
  (package
    (name "rust-curl")
    (version "0.4.46")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "curl" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1dk7xi1fv57ak5wsgzig702czv3ssrgyk120b7qhy2dsdvfn288y"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #false                  ;require internet access
       #:cargo-inputs
       (("rust-curl-sys" ,rust-curl-sys-0.4)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-openssl-probe" ,rust-openssl-probe-0.1)
        ("rust-openssl-sys" ,rust-openssl-sys-0.9)
        ("rust-schannel" ,rust-schannel-0.1)
        ("rust-socket2" ,rust-socket2-0.5)
        ("rust-windows-sys" ,rust-windows-sys-0.52))
       #:cargo-development-inputs
       (("rust-anyhow" ,rust-anyhow-1)
        ("rust-mio" ,rust-mio-0.6)
        ("rust-mio-extras" ,rust-mio-extras-2))))
    (native-inputs
     (list pkg-config))
    (inputs
     (list curl nghttp2 openssl zlib))
    (home-page "https://github.com/alexcrichton/curl-rust")
    (synopsis "Rust bindings to libcurl for making HTTP requests")
    (description
     "This package provides Rust bindings to @code{libcurl} for making HTTP
requests.")
    (license license:expat)))

(define-public rust-curl-sys-0.4
  (package
    (name "rust-curl-sys")
    (version "0.4.78+curl-8.11.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "curl-sys" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1bqyh8rlwhwj937d1md5chpg56ch8mncyldf26b7iiy5861pdv4f"))
        (modules '((guix build utils)))
        (snippet
         '(begin (delete-file-recursively "curl")))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cc" ,rust-cc-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libnghttp2-sys" ,rust-libnghttp2-sys-0.1)
        ("rust-libz-sys" ,rust-libz-sys-1)
        ("rust-openssl-sys" ,rust-openssl-sys-0.9)
        ("rust-pkg-config" ,rust-pkg-config-0.3)
        ("rust-rustls-ffi" ,rust-rustls-ffi-0.14)
        ("rust-vcpkg" ,rust-vcpkg-0.2)
        ("rust-windows-sys" ,rust-windows-sys-0.52))))
    (native-inputs
     (list pkg-config))
    (inputs
     (list curl nghttp2 openssl zlib))
    (home-page "https://github.com/alexcrichton/curl-rust")
    (synopsis "Native bindings to the libcurl library")
    (description
     "This package provides native bindings to the @code{libcurl} library.")
    (license license:expat)))

(define-public rust-cust-0.2
  (package
    (name "rust-cust")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cust" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1jb7l9qq65jc9rqwwygaxg4b304nn3i8igic905cbbrnw1ns8iz9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t ; Could not find a cuda installation
       #:cargo-inputs (("rust-bitflags" ,rust-bitflags-1)
                       ("rust-cust-derive" ,rust-cust-derive-0.1)
                       ("rust-cust-raw" ,rust-cust-raw-0.11)
                       ("rust-find-cuda-helper" ,rust-find-cuda-helper-0.2)
                       ("rust-vek" ,rust-vek-0.15))
       #:cargo-development-inputs (("rust-image" ,rust-image-0.23))))
    (home-page "https://github.com/Rust-GPU/Rust-CUDA")
    (synopsis "High level bindings to the CUDA Driver API")
    (description "High level bindings to the CUDA Driver API.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cust-core-0.1
  (package
    (name "rust-cust-core")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cust_core" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "01jzjwywsngqm8d1vxk3zr9klvidab6iis1myg5r1y5q5ik7k7q3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; use of undeclared crate or module `cust`
       #:cargo-inputs
       (("rust-cust-derive" ,rust-cust-derive-0.2)
        ("rust-glam" ,rust-glam-0.20)
        ("rust-half" ,rust-half-1)
        ("rust-mint" ,rust-mint-0.5)
        ("rust-num-complex" ,rust-num-complex-0.4)
        ("rust-vek" ,rust-vek-0.15))))
    (home-page "https://github.com/Rust-GPU/Rust-CUDA")
    (synopsis "Core library for cust that can be shared across CPU and GPU")
    (description "This package provides the core library for cust that can be
shared across CPU and GPU.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cust-derive-0.2
  (package
    (name "rust-cust-derive")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cust_derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0rigqx5d1941cbpbd76i455ifh4yzz6fcga2na9fv6k2zsavr8z8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/Rust-GPU/Rust-CUDA")
    (synopsis "Macros for cust")
    (description "This package provides macros for cust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cust-derive-0.1
  (package
    (inherit rust-cust-derive-0.2)
    (name "rust-cust-derive")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cust_derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ckxjfdlwhmdyf5s2v10cslpb6wri9xl8nk3qirz8rsn5x1hn61v"))))
    (arguments
     `(#:cargo-inputs (("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-syn" ,rust-syn-1))))))

(define-public rust-cust-raw-0.11
  (package
    (name "rust-cust-raw")
    (version "0.11.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "cust_raw" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1y1b82gf0fmaqxhvzjd3cxgd54vvbj3vji68pcl9ijqjvrm0vx7v"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t ; Could not find a cuda installation
       #:cargo-inputs (("rust-find-cuda-helper" ,rust-find-cuda-helper-0.2))))
    (home-page "https://github.com/Rust-GPU/Rust-CUDA")
    (synopsis "Low level bindings to the CUDA Driver API")
    (description "Low level bindings to the CUDA Driver API.")
    (license (list license:expat license:asl2.0))))

(define-public rust-custom-derive-0.1
  (package
    (name "rust-custom-derive")
    (version "0.1.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "custom_derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1f81bavw1wnykwh21hh4yyzigs6zl6f6pkk9p3car8kq95yfb2pg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-development-inputs
       (("rust-rustc-serialize" ,rust-rustc-serialize-0.3))))
    (home-page
     "https://github.com/DanielKeep/rust-custom-derive/tree/custom_derive-master")
    (synopsis "Custom derivation macro for Rust")
    (description
     "This crate provides a macro that enables the use of custom @code{derive}
attributes.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-cvt-0.1
  (package
    (name "rust-cvt")
    (version "0.1.2")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "cvt" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1wdwg2rbjl86bcrymscl34pw31kyv1ada19jazpkjbdzgzvrpbnj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-cfg-if" ,rust-cfg-if-1))))
    (home-page "https://github.com/marmistrz/cvt")
    (synopsis "Expose the cvt function from Rust libstd")
    (description "Expose the cvt function from Rust libstd.")
    (license license:asl2.0)))

(define-public rust-cxx-1
  (package
    (name "rust-cxx")
    (version "1.0.107")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cxx" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1gpz9si4nn236rqbmrsxd0dl4ksdfwrf1rdyncyznmlxg2hqpsdv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f  ; Cannot compile cxx-test-suite.
       #:cargo-inputs
       (("rust-cc" ,rust-cc-1)
        ("rust-cxxbridge-flags" ,rust-cxxbridge-flags-1)
        ("rust-cxxbridge-macro" ,rust-cxxbridge-macro-1)
        ("rust-link-cplusplus" ,rust-link-cplusplus-1))
       #:cargo-development-inputs
       (("rust-cxx-build" ,rust-cxx-build-1)
        ("rust-cxx-gen" ,rust-cxx-gen-0.7)
        ("rust-cxx-test-suite" ,rust-cxx-test-suite-0.0.0)
        ("rust-rustversion" ,rust-rustversion-1)
        ("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://cxx.rs")
    (synopsis "Safe interop between Rust and C++")
    (description "This package provides a safe interop between Rust and C++.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cxx-build-1
  (package
    (name "rust-cxx-build")
    (version "1.0.107")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cxx-build" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "18sy8llakggzyahmr7c25l16i63hd2agpb8x3f2a8ga3p3v21kn4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cc" ,rust-cc-1)
        ("rust-codespan-reporting" ,rust-codespan-reporting-0.11)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-scratch" ,rust-scratch-1)
        ("rust-syn" ,rust-syn-2))
       #:cargo-development-inputs
       (("rust-cxx" ,rust-cxx-1)
        ("rust-cxx-gen" ,rust-cxx-gen-0.7)
        ("rust-pkg-config" ,rust-pkg-config-0.3))))
    (home-page "https://cxx.rs")
    (synopsis "C++ code generator")
    (description
     "This package provides a C++ code generator for integrating the @code{cxx}
crate into a Cargo build.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cxx-gen-0.7
  (package
    (name "rust-cxx-gen")
    (version "0.7.107")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cxx-gen" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1lv2fs3s51lqipbpzrv2dmhm0mwcw5205sq7x3cmcb3skia64l6b"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-codespan-reporting" ,rust-codespan-reporting-0.11)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-2))))
    (home-page "https://cxx.rs")
    (synopsis "C++ code generator")
    (description
     "This package provides a C++ code generator for integrating the @code{cxx}
crate into higher level tools.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cxx-test-suite-0.0.0
  (package
    (name "rust-cxx-test-suite")
    (version "0.0.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cxx-test-suite" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1pkf4ay1210g9wqyqhkgvlcsv4i6kgdcmgnh19mrymylznv7pcal"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t)) ; Not meant to be built independently.
    (home-page "https://github.com/dtolnay/cxx")
    (synopsis "Test suite of the cxx crate")
    (description "This package provides the test suite of the cxx crate.")
    (license (list license:expat license:asl2.0))))

(define-public rust-cxxbridge-flags-1
  (package
    (name "rust-cxxbridge-flags")
    (version "1.0.107")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cxxbridge-flags" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "18hxm7dp8k58zsxniaspg11nw0ymwzpk1viw8zzy56123ng8v210"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/dtolnay/cxx")
    (synopsis "Compiler configuration of the `cxx` crate")
    (description "This package provides a compiler configuration of the `cxx`
crate (implementation detail).")
    (license (list license:expat license:asl2.0))))

(define-public rust-cxxbridge-macro-1
  (package
    (name "rust-cxxbridge-macro")
    (version "1.0.107")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "cxxbridge-macro" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "116d3i750nknl6jw9vmvyxrndrmwn5gm7zzxzx6rw4jqvmq6m89g"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-clang-ast" ,rust-clang-ast-0.1)
        ("rust-flate2" ,rust-flate2-1)
        ("rust-memmap" ,rust-memmap-0.7)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-syn" ,rust-syn-2))
       #:cargo-development-inputs
       (("rust-cxx" ,rust-cxx-1))))
    (home-page "https://cxx.rs")
    (synopsis "Implementation detail of the `cxx` crate")
    (description
     "This package provides an implementation detail of the @code{cxx} crate.")
    (license (list license:expat license:asl2.0))))

(define-public rust-daemonize-0.5
  (package
    (name "rust-daemonize")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "daemonize" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0vhikx85f85r46xghsb4avsv6ww8mz9lipqvsia7m21wrfmgv2xb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/knsd/daemonize")
    (synopsis "Library to enable code to run as a daemon process")
    (description
     "Daemonize is a Rust Library for writing system daemonis on Unix-like systems.")
    (license (list license:expat license:asl2.0))))

(define-public rust-darling-0.20
  (package
    (name "rust-darling")
    (version "0.20.10")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "darling" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1299h2z88qn71mizhh05j26yr3ik0wnqmw11ijds89l8i9nbhqvg"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-darling-core" ,rust-darling-core-0.20)
        ("rust-darling-macro" ,rust-darling-macro-0.20))
       #:cargo-development-inputs (("rust-proc-macro2" ,rust-proc-macro2-1)
                                   ("rust-quote" ,rust-quote-1)
                                   ("rust-rustversion" ,rust-rustversion-1)
                                   ("rust-syn" ,rust-syn-2)
                                   ("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://github.com/TedDriggs/darling")
    (synopsis "Proc-macro library for reading attributes in custom derives")
    (description
     "This package provides a proc-macro library for reading attributes
into structs when implementing custom derives.")
    (license license:expat)))

(define-public rust-darling-0.14
  (package
    (inherit rust-darling-0.20)
    (name "rust-darling")
    (version "0.14.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "darling" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0l1qrn805bsxa0iy7x8bmdwr8c10hlw0yiqs8ckv7lbz86rhqxbv"))))
    (arguments
     `(#:cargo-inputs
       (("rust-darling-core" ,rust-darling-core-0.14)
        ("rust-darling-macro" ,rust-darling-macro-0.14))
       #:cargo-development-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-rustversion" ,rust-rustversion-1)
        ("rust-syn" ,rust-syn-1)
        ("rust-trybuild" ,rust-trybuild-1))))))

(define-public rust-darling-0.13
  (package
    (inherit rust-darling-0.14)
    (name "rust-darling")
    (version "0.13.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "darling" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0g25pad4mhq7315mw9n4wpg8j3mwyhwvr541kgdl0aar1j2ra7d0"))))
    (arguments
     `(#:cargo-inputs (("rust-darling-core" ,rust-darling-core-0.13)
                       ("rust-darling-macro" ,rust-darling-macro-0.13))
       #:cargo-development-inputs (("rust-proc-macro2" ,rust-proc-macro2-1)
                                   ("rust-quote" ,rust-quote-1)
                                   ("rust-syn" ,rust-syn-1))))))

(define-public rust-darling-0.12
  (package
    (inherit rust-darling-0.13)
    (name "rust-darling")
    (version "0.12.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "darling" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0g4bkxpwl6i5jav5qqzny39yd5a1fdlh5l0mj020njza6ksl6b2z"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-darling-core" ,rust-darling-core-0.12)
        ("rust-darling-macro" ,rust-darling-macro-0.12))
       #:cargo-development-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))))

(define-public rust-darling-0.10
  (package
    (inherit rust-darling-0.12)
    (name "rust-darling")
    (version "0.10.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "darling" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0n7qsp6854wm3y1q1lvylhv15zvc87ibbac1nyfmcdbyv1snww0d"))))
    (arguments
     `(#:cargo-inputs
       (("rust-darling-core" ,rust-darling-core-0.10)
        ("rust-darling-macro" ,rust-darling-macro-0.10))
       #:cargo-development-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))))

(define-public rust-darling-0.9
  (package
    (inherit rust-darling-0.10)
    (name "rust-darling")
    (version "0.9.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "darling" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1mnksf0i47pb7sxvi1iqfwmqy9iny0x8w56ilybpb431b46cpyzw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-darling-core" ,rust-darling-core-0.9)
        ("rust-darling-macro" ,rust-darling-macro-0.9))
       #:cargo-development-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-syn" ,rust-syn-0.15))))))

(define-public rust-darling-core-0.20
  (package
    (name "rust-darling-core")
    (version "0.20.10")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "darling_core" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1rgr9nci61ahnim93yh3xy6fkfayh7sk4447hahawah3m1hkh4wm"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-fnv" ,rust-fnv-1)
        ("rust-ident-case" ,rust-ident-case-1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-strsim" ,rust-strsim-0.11)
        ("rust-syn" ,rust-syn-2))))
    (home-page "https://github.com/TedDriggs/darling")
    (synopsis "Helper crate for @code{rust-darling}")
    (description
     "Helper crate for @code{rust-darling}, a proc-macro library for
reading attributes into structs when implementing custom derives.")
    (license license:expat)))

(define-public rust-darling-core-0.14
  (package
    (inherit rust-darling-core-0.20)
    (name "rust-darling-core")
    (version "0.14.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "darling_core" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1w4b2ndxmkwghwq84yphk8x15jnpivm08w596g12ry5pwsk1r70h"))))
    (arguments
     `(#:cargo-inputs
       (("rust-fnv" ,rust-fnv-1)
        ("rust-ident-case" ,rust-ident-case-1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-strsim" ,rust-strsim-0.10)
        ("rust-syn" ,rust-syn-1))))))

(define-public rust-darling-core-0.13
  (package
    (inherit rust-darling-core-0.14)
    (name "rust-darling-core")
    (version "0.13.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "darling_core" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "046n83f9jpszlngpjxkqi39ayzxf5a35q673c69jr1dn0ylnb7c5"))))
    (arguments
     `(#:cargo-inputs (("rust-fnv" ,rust-fnv-1)
                       ("rust-ident-case" ,rust-ident-case-1)
                       ("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-strsim" ,rust-strsim-0.10)
                       ("rust-syn" ,rust-syn-1))))))

(define-public rust-darling-core-0.12
  (package
    (inherit rust-darling-core-0.13)
    (name "rust-darling-core")
    (version "0.12.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "darling_core" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0dpscl87s75h6yhrmzdsapx86lc4y16m554xg4hiq2l3hrdlb4cf"))))))

(define-public rust-darling-core-0.10
  (package
    (inherit rust-darling-core-0.12)
    (name "rust-darling-core")
    (version "0.10.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "darling_core" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "16sija1jv0l754x4aa6b6fy01d1kf8m0r4id3flqipm45np61jgh"))))
    (arguments
     `(#:cargo-inputs
       (("rust-fnv" ,rust-fnv-1)
        ("rust-ident-case" ,rust-ident-case-1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-strsim" ,rust-strsim-0.9)
        ("rust-syn" ,rust-syn-1))))))

(define-public rust-darling-core-0.9
  (package
    (inherit rust-darling-core-0.10)
    (name "rust-darling-core")
    (version "0.9.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "darling_core" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0b201dx4m58l5ac7gmbjvbf4z2xipnk5d4pqa7mz7gy3f21h3z3a"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-fnv" ,rust-fnv-1)
        ("rust-ident-case" ,rust-ident-case-1)
        ("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-strsim" ,rust-strsim-0.7)
        ("rust-syn" ,rust-syn-0.15))))))

(define-public rust-darling-macro-0.20
  (package
    (name "rust-darling-macro")
    (version "0.20.10")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "darling_macro" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "01kq3ibbn47czijj39h3vxyw0c2ksd0jvc097smcrk7n2jjs4dnk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-darling-core" ,rust-darling-core-0.20)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-2))))
    (home-page "https://github.com/TedDriggs/darling")
    (synopsis "Helper crate for @code{rust-darling}")
    (description
     "This package provides internal support for @code{rust-darling},
a proc-macro library for reading attributes into structs when implementing
custom derives.")
    (license license:expat)))

(define-public rust-darling-macro-0.14
  (package
    (inherit rust-darling-macro-0.20)
    (name "rust-darling-macro")
    (version "0.14.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "darling_macro" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32 "13mlyd5w275c815k0ijf6g4c446hs8b3m2h4an5isqgpr7dv9am4"))))
    (arguments
     `(#:cargo-inputs
       (("rust-darling-core" ,rust-darling-core-0.14)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))))

(define-public rust-darling-macro-0.13
  (package
    (inherit rust-darling-macro-0.14)
    (name "rust-darling-macro")
    (version "0.13.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "darling_macro" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0d8q8ibmsb1yzby6vwgh2wx892jqqfv9clwhpm19rprvz1wjd5ww"))))
    (arguments
     `(#:cargo-inputs (("rust-darling-core" ,rust-darling-core-0.13)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-syn" ,rust-syn-1))))))

(define-public rust-darling-macro-0.12
  (package
    (inherit rust-darling-macro-0.13)
    (name "rust-darling-macro")
    (version "0.12.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "darling_macro" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0nn9mxl7gs827rx5s6lbjvvghipxjdg2qpdjyxk7yym3vvqard99"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-darling-core" ,rust-darling-core-0.12)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))))

(define-public rust-darling-macro-0.10
  (package
    (inherit rust-darling-macro-0.12)
    (name "rust-darling-macro")
    (version "0.10.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "darling_macro" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0wlv31cxkrjijz5gv13hvk55c9lmd781aj12c8n84sa9mksa5dfr"))))
    (arguments
     `(#:cargo-inputs
       (("rust-darling-core" ,rust-darling-core-0.10)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))))

(define-public rust-darling-macro-0.9
  (package
    (inherit rust-darling-macro-0.10)
    (name "rust-darling-macro")
    (version "0.9.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "darling_macro" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1lcq9418w0vmvncg4a3n9k64zjvqz0048aviqi0rmlpiqv0xmn66"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-darling-core" ,rust-darling-core-0.9)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-syn" ,rust-syn-0.15))))))

(define-public rust-dary-heap-0.3
  (package
    (name "rust-dary-heap")
    (version "0.3.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dary_heap" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0a5p4qfayfmkda4rb31zyc5sia11n0q0cq6scznm9x5r32fcvlh4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.8)
        ("rust-rand-xorshift" ,rust-rand-xorshift-0.3)
        ("rust-serde-test" ,rust-serde-test-1))))
    (home-page "https://github.com/hanmertens/dary_heap")
    (synopsis "D-ary heap")
    (description "This package provides a d-ary heap.")
    (license (list license:expat license:asl2.0))))

(define-public rust-dashmap-6
  (package
    (name "rust-dashmap")
    (version "6.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dashmap" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1kvnw859xvrqyd1lk89na6797yvl5bri4wi9j0viz2a4j54wqhah"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-arbitrary" ,rust-arbitrary-1)
        ("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.8)
        ("rust-hashbrown" ,rust-hashbrown-0.14)
        ("rust-lock-api" ,rust-lock-api-0.4)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-parking-lot-core" ,rust-parking-lot-core-0.9)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-typesize" ,rust-typesize-0.1))))
    (home-page "https://github.com/xacrimon/dashmap")
    (synopsis "Blazing fast concurrent HashMap for Rust")
    (description
     "This package provides Blazing fast concurrent @code{HashMap} for Rust.")
    (license license:expat)))

(define-public rust-dashmap-5
  (package
    (inherit rust-dashmap-6)
    (name "rust-dashmap")
    (version "5.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dashmap" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0miqnlxi501vfbv6mw5jbmzgnj0wjrch3p4abvpd59s9v30lg1wp"))))
    (arguments
     `(#:cargo-inputs
       (("rust-arbitrary" ,rust-arbitrary-1)
        ("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-hashbrown" ,rust-hashbrown-0.14)
        ("rust-lock-api" ,rust-lock-api-0.4)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-parking-lot-core" ,rust-parking-lot-core-0.9)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-serde" ,rust-serde-1))))))

(define-public rust-dashmap-4
  (package
    (inherit rust-dashmap-5)
    (name "rust-dashmap")
    (version "4.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dashmap" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1773x18k5m2zw1iyibs8l3wl1p1aijdbrc0w844xys06inr46yp7"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-rayon" ,rust-rayon-1)
        ("rust-serde" ,rust-serde-1))))))

(define-public rust-data-encoding-2
  (package
    (name "rust-data-encoding")
    (version "2.6.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "data-encoding" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1qnn68n4vragxaxlkqcb1r28d3hhj43wch67lm4rpxlw89wnjmp8"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/ia0/data-encoding")
    (synopsis "Efficient and customizable data-encoding functions")
    (description
     "This library provides encodings for many different common cases, including
hexadecimal, base32, and base64.")
    (license license:expat)))

(define-public rust-data-encoding-macro-0.1
  (package
    (name "rust-data-encoding-macro")
    (version "0.1.15")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "data-encoding-macro" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0fg6abipcn5h8qa09r5ki5dv3vhq4qaxn1ipsvb7c8k2p9n9nmgi"))))
    (build-system cargo-build-system)
    (arguments
     (list #:cargo-inputs (list rust-data-encoding-2
                                rust-data-encoding-macro-internal-0.1)))
    (home-page "https://github.com/ia0/data-encoding")
    (synopsis "Macros for data-encoding")
    (description "This package provides macros for data-encoding.")
    (license license:expat)))

(define-public rust-data-encoding-macro-internal-0.1
  (package
    (name "rust-data-encoding-macro-internal")
    (version "0.1.13")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "data-encoding-macro-internal" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0gyk580bjsjdy10n06f4gqh5kkqy296ndvcg21ychfzm1967ab9k"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-data-encoding" ,rust-data-encoding-2)
                       ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/ia0/data-encoding")
    (synopsis "Internal library for data-encoding-macro")
    (description
     "This package provides an internal library for data-encoding-macro.")
    (license license:expat)))

(define-public rust-data-url-0.3
  (package
    (name "rust-data-url")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "data-url" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0ahclz72myi350cs1xcsxdh1v0iljpfj4ghcy2fy46mpfhf7laaw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs (("rust-serde" ,rust-serde-1)
                                   ("rust-serde-json" ,rust-serde-json-1)
                                   ("rust-tester" ,rust-tester-0.9))))
    (home-page "https://github.com/servo/rust-url")
    (synopsis "Processing of data: URL according to WHATWG's Fetch Standard")
    (description
     "Processing of data: URL according to WHATWG's Fetch Standard.")
    (license (list license:expat license:asl2.0))))

(define-public rust-databake-0.1
  (package
    (name "rust-databake")
    (version "0.1.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "databake" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0kb0lnhka1fklrii3qaj40zcrbclfn8fyvy0r1whd3yaxkxzn13a"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags '("--"
                            "--skip=src/lib.rs - (line 27)"
                            "--skip=src/lib.rs - (line 46)")
       #:cargo-inputs (("rust-databake-derive" ,rust-databake-derive-0.1)
                       ("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1))))
    (home-page "https://github.com/unicode-org/icu4x")
    (synopsis
     "Trait that lets structs represent themselves as (const) Rust expressions")
    (description
     "This package provides a trait that lets structs represent themselves as
(const) Rust expressions.")
    (license license:unicode)))

(define-public rust-databake-derive-0.1
  (package
    (name "rust-databake-derive")
    (version "0.1.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "databake-derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0yymbr1z93k7lg0pl5mw9mjhw8fpsfykg7bmkvmir9h1wmfjfy20"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; use of undeclared crate or module `databake`
       #:cargo-inputs (("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-syn" ,rust-syn-2)
                       ("rust-synstructure" ,rust-synstructure-0.13))))
    (home-page "https://github.com/unicode-org/icu4x")
    (synopsis "Custom derive for the databake crate")
    (description "This package provides Custom derive for the databake crate.")
    (license license:unicode)))

(define-public rust-dateparser-0.1
  (package
    (name "rust-dateparser")
    (version "0.1.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dateparser" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1i00pd2spxsz1d89n0ssf79q1w8ijx0p0rybx5d9z8lpzqhjmqf9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-anyhow" ,rust-anyhow-1)
                       ("rust-chrono" ,rust-chrono-0.4)
                       ("rust-lazy-static" ,rust-lazy-static-1)
                       ("rust-regex" ,rust-regex-1))
       #:cargo-development-inputs (("rust-chrono-tz" ,rust-chrono-tz-0.6)
                                   ("rust-criterion" ,rust-criterion-0.3))))
    (home-page "https://github.com/waltzofpearls/dateparser")
    (synopsis "Parse dates in string formats that are commonly used")
    (description
     "This package parses dates in string formats that are commonly used.")
    (license license:expat)))

(define-public rust-datetime-0.5
  (package
    (name "rust-datetime")
    (version "0.5.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "datetime" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1g2lhc2ay46njrnnyc0729ibyzkpv3r3d4g0h3gzwmrygykzghs4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
        (("rust-iso8601" ,rust-iso8601-0.3)
         ("rust-libc" ,rust-libc-0.2)
         ("rust-locale" ,rust-locale-0.2)
         ("rust-num-traits" ,rust-num-traits-0.2)
         ("rust-pad" ,rust-pad-0.1)
         ("rust-redox-syscall" ,rust-redox-syscall-0.1)
         ("rust-winapi" ,rust-winapi-0.3))
        #:cargo-development-inputs
        (("rust-regex" ,rust-regex-0.1)
         ("rust-rustc-serialize" ,rust-rustc-serialize-0.3))))
    (home-page "https://github.com/rust-datetime/datetime")
    (synopsis "Library for date and time formatting and arithmetic")
    (description "This package provides a library for date and time formatting
and arithmetic.")
    (license license:expat)))

(define-public rust-dbl-0.3
  (package
    (name "rust-dbl")
    (version "0.3.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "dbl" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32 "1ng33ncai537xlxfy9r4v24parm9mf7zwiwkixq7d0qmj6kka9xx"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-generic-array" ,rust-generic-array-0.14))))
    (home-page "https://docs.rs/dbl")
    (synopsis "Double operation in Galois Field")
    (description
     "This package provides double and inverse double over Galois Field -
GF(2^n).  This trait is implemented for 64, 128 and 256 bit block
sizes.  Big-endian order is used.  WARNING: Block must be aligned!")
    (license (list license:expat license:asl2.0))))

(define-public rust-dbus-0.9
  (package
    (name "rust-dbus")
    (version "0.9.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dbus" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "06vdv4aarjs4w6byg9nqajr67c8qvlhk3153ic2i65pvp63ikchv"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f          ;it needs display and sockets and launches daemons
       #:cargo-inputs
       (("rust-futures-channel" ,rust-futures-channel-0.3)
        ("rust-futures-executor" ,rust-futures-executor-0.3)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libdbus-sys" ,rust-libdbus-sys-0.2))
       #:cargo-development-inputs
       (("rust-tempfile" ,rust-tempfile-3))))
    (native-inputs
     (list pkg-config))
    (inputs
     (list dbus))
    (home-page "https://github.com/diwic/dbus-rs")
    (synopsis "Rust bindings to D-Bus")
    (description "This package provides Rust bindings to D-Bus.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-dbus-crossroads-0.5
  (package
    (name "rust-dbus-crossroads")
    (version "0.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dbus-crossroads" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1q3dyywazr3hppm052fa8q2366q66ml789r42jjlnm47f51q6k1s"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f  ; use of undeclared crate or module `dbus_tokio`
       #:cargo-inputs (("rust-dbus" ,rust-dbus-0.9))
       #:cargo-development-inputs (("rust-tokio", rust-tokio-1))))
    (native-inputs (list pkg-config))
    (inputs (list dbus-glib))
    (home-page "https://github.com/diwic/dbus-rs/")
    (synopsis "Framework for writing D-Bus method handlers")
    (description "Framework for writing D-Bus method handlers in Rust.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-dbus-tokio-0.7
  (package
    (name "rust-dbus-tokio")
    (version "0.7.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dbus-tokio" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "04xd3z2dnjv4d45kj3wqnwbnwllrp1zsg8v3q0qp2rxwb7a8hxh0"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f ;tests require X11 $DISPLAY
       #:cargo-inputs (("rust-dbus" ,rust-dbus-0.9)
                       ("rust-dbus-crossroads" ,rust-dbus-crossroads-0.5)
                       ("rust-libc" ,rust-libc-0.2)
                       ("rust-tokio" ,rust-tokio-1))
       #:cargo-development-inputs (("rust-dbus-tree" ,rust-dbus-tree-0.9)
                                   ("rust-futures" ,rust-futures-0.3)
                                   ("rust-tokio" ,rust-tokio-1))))
    (native-inputs (list pkg-config))
    (inputs (list dbus))
    (home-page "https://github.com/diwic/dbus-rs")
    (synopsis "Access to D-Bus when using Rust's @code{Tokio} async framework")
    (description
     "Access to D-Bus when using Rust's @code{Tokio} async framework.")
    (license license:expat)))

(define-public rust-dbus-tree-0.9
  (package
    (name "rust-dbus-tree")
    (version "0.9.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dbus-tree" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "027mnjc99ss8nab588aga9l8aag2pjvzkcfx35g5fm4fmscfcmpl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:install-source? #f     ; README is missing.
       #:cargo-inputs (("rust-dbus" ,rust-dbus-0.9))))
    (native-inputs
     (list pkg-config))
    (inputs
     (list dbus))
    (home-page "https://github.com/diwic/dbus-rs")
    (synopsis "Framework for writing D-Bus method handlers (legacy)")
    (description
     "This crate is a framework for writing D-Bus method handlers (legacy).")
    (license (list license:asl2.0 license:expat))))

(define-public rust-dconf-rs-0.3
  (package
    (name "rust-dconf-rs")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dconf_rs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "12swi0npq88kbdwnc3n324dzknir674agrh13h305876h654cikh"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/kylecorry31/dconf_rs")
    (synopsis "Rust API for interacting with dconf")
    (description
     "This package provides a Rust API for interacting with dconf.")
    (license license:expat)))

(define-public rust-debug-helper-0.3
  (package
    (name "rust-debug-helper")
    (version "0.3.13")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "debug-helper" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0bhnpzpgmg8dkdr27g2b49slf6ca79m4idcb01z2krs0qkifhy7m"))))
    (build-system cargo-build-system)
    (home-page "https://magiclen.org/debug-helper")
    (synopsis "Declarative macros to implement the Debug trait manually")
    (description "This crate provides declarative macros to help you implement
the Debug trait manually.")
    (license license:expat)))

(define-public rust-debug-unreachable-0.1
  (package
    (name "rust-debug-unreachable")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "debug_unreachable" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1cx4vh1d0bxdpb8l9lyiv03az4527lykxy39s4a958swf2n2w0ws"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-unreachable" ,rust-unreachable-0.1))))
    (home-page "https://github.com/reem/rust-debug-unreachable.git")
    (synopsis
     "unreachable!() in debug, std::intrinsics::unreachable() in release")
    (description
     "unreachable!() in debug, std::intrinsics::unreachable() in release.")
    (license license:expat)))

(define-public rust-debugger-test-0.1
  (package
    (name "rust-debugger-test")
    (version "0.1.5")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "debugger_test" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "182j5sk71yhbn7f5qkx509bdcjz83n1nshpfgfa8dfrgb5gvanyr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-anyhow" ,rust-anyhow-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
        #:cargo-development-inputs
        (("rust-debugger-test-parser" ,rust-debugger-test-parser-0.1)
         ("rust-regex" ,rust-regex-1))))
    (home-page "https://github.com/microsoft/rust_debugger_test")
    (synopsis "Proc macro for writing tests with a debugger")
    (description
     "This package provides a proc macro for writing tests that launch a
debugger and run commands while verifying the output.")
    (license (list license:expat license:asl2.0))))

(define-public rust-debugger-test-parser-0.1
  (package
    (name "rust-debugger-test-parser")
    (version "0.1.3")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "debugger_test_parser" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0xcyxw0si7j4h701aksdd08j8jmrzc58833g66wm4xvp592kdrgb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-anyhow" ,rust-anyhow-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-regex" ,rust-regex-1))))
    (home-page
     "https://github.com/microsoft/rust_debugger_test/debugger_test_parser")
    (synopsis "Library for parsing debugger output")
    (description
     "This package provides a library for parsing the output of a debugger and
verifying the contents.")
    (license (list license:expat license:asl2.0))))

(define-public rust-debugid-0.8
  (package
    (name "rust-debugid")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "debugid" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "13f15dfvn07fa7087pmacixqqv0lmj4hv93biw4ldr48ypk55xdy"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1)
        ("rust-uuid" ,rust-uuid-1))
       #:cargo-development-inputs
       (("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://sentry.io/")
    (synopsis "Common reusable types for implementing the sentry.io protocol")
    (description
     "Common reusable types for implementing the sentry.io protocol.")
    (license license:asl2.0)))

(define-public rust-decimal-2
  (package
    (name "rust-decimal")
    (version "2.1.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "decimal" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0k8ij9brz6kdk7j4hq916s85qrplpy3ixs9v9h1ibsxsj5zbg2js"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-ord-subset" ,rust-ord-subset-3)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3)
        ("rust-serde" ,rust-serde-1)
        ("rust-cc" ,rust-cc-1))
       #:cargo-development-inputs
       (("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/alkis/decimal")
    (synopsis "Decimal floating point arithmetic for Rust")
    (description
     "Decimal floating point arithmetic for Rust.")
    (license license:asl2.0)))

(define-public rust-defer-0.2
  (package
    (name "rust-defer")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "defer" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1s7qig25n27rajvsn013sb8k6bgdv67936yz5dwb37yzr1qp234k"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/andrewhickman/defer/")
    (synopsis
     "Utility to defer execution of code")
    (description
     "Utility to defer execution of code, inspired by Go's defer statement.")
    (license (list license:expat license:asl2.0))))

(define-public rust-defer-0.1
  (package
    (inherit rust-defer-0.2)
    (name "rust-defer")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "defer" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1pmcz4av2wvw8zrccmac86dsyy34qlwacdhajp1qjpjx6jk0axk4"))))
    (license (list license:expat license:asl2.0))))

(define-public rust-defer-drop-1
  (package
    (name "rust-defer-drop")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "defer-drop" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0mswjjksrr6fvsgxvp64mzwkjkzjmpwjfaw4n76jhsvalsgyq4zn"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-crossbeam-channel" ,rust-crossbeam-channel-0.5)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/Lucretiel/defer-drop")
    (synopsis "Defer dropping large types to a background thread")
    (description
     "This package provides a defer dropping large types to a background
thread.")
    (license license:mpl2.0)))

(define-public rust-defmac-0.2
  (package
    (name "rust-defmac")
    (version "0.2.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "defmac" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "14cqfvc0f1pkd6gdhjxa2wv3iibqprc0n203ims8lvg96752ynfm"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/bluss/defmac")
    (synopsis "Macro to define lambda-like macros inline")
    (description "A macro to define lambda-like macros inline.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-defmac-0.1
  (package
    (inherit rust-defmac-0.2)
    (name "rust-defmac")
    (version "0.1.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "defmac" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "17giv0n0n1r64z0dahfvkjy3ys517jxyhs8sd9lmgvcljpjyryxa"))))))

(define-public rust-defmt-0.3
  (package
    (name "rust-defmt")
    (version "0.3.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "defmt" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1q79ryg6q1i2nfhs5wcrc018y8sblvsjlryl45qqi2v6c8id57d9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags '("--release" "--features=unstable-test")
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-defmt-macros" ,rust-defmt-macros-0.3))
       #:cargo-development-inputs
       (("rust-rustc-version" ,rust-rustc-version-0.4)
        ("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://knurling.ferrous-systems.com/")
    (synopsis "Logging framework for resource-constrained devices")
    (description
     "This package provides an efficient logging framework that targets
resource-constrained devices, like micro-controllers.")
    (license (list license:expat license:asl2.0))))

(define-public rust-defmt-macros-0.3
  (package
    (name "rust-defmt-macros")
    (version "0.3.9")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "defmt-macros" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1jrdbwcifbbsx0zmab3cqachai5fj16ralpjplz9pxzixw4z7ag3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-defmt-parser" ,rust-defmt-parser-0.3)
        ("rust-proc-macro-error" ,rust-proc-macro-error-1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-2))
       #:cargo-development-inputs
       (("rust-maplit" ,rust-maplit-1)
        ("rust-pretty-assertions" ,rust-pretty-assertions-1)
        ("rust-rstest" ,rust-rstest-0.19))))
    (home-page "https://github.com/knurling-rs/defmt")
    (synopsis "Macros for rust-defmt")
    (description "This package provides macros for rust-defmt crate")
    (license (list license:expat license:asl2.0))))

(define-public rust-defmt-parser-0.3
  (package
    (name "rust-defmt-parser")
    (version "0.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "defmt-parser" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "03zpg0i6vlalw7m976z66n70s041rvwii8qn3grxgs1hwgpmyjpz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-thiserror" ,rust-thiserror-1))
       #:cargo-development-inputs (("rust-rstest" ,rust-rstest-0.17))))
    (home-page "https://github.com/knurling-rs/defmt")
    (synopsis "Parsing library for defmt format strings")
    (description "This package is a parsing library for defmt format
strings.")
    (license (list license:expat license:asl2.0))))

;; TODO: Unbundle dejavu font
(define-public rust-dejavu-2
  (package
    (name "rust-dejavu")
    (version "2.37.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dejavu" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1hgv2cc9gnk8q8j2zl4hk2vf2jhf9mfcqsm31m4nv065zfspayq1"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/brayniac/dejavu")
    (synopsis "Provides the DejaVu font family for embedding")
    (description
     "This package provides the @code{DejaVu} font family for embedding.")
    (license (list license:expat license:asl2.0))))

(define-public rust-demo-hack-0.0.5
  (package
    (name "rust-demo-hack")
    (version "0.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "demo-hack" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0m0114p1g0zzrdph5bg03i8m8p70vrwn3whs191jrbjcrmh5lmnp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-demo-hack-impl" ,rust-demo-hack-impl-0.0.5)
        ("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5))))
    (home-page "https://github.com/dtolnay/proc-macro-hack")
    (synopsis "Demo of proc-macro-hack")
    (description "Demo of proc-macro-hack.")
    (license (list license:expat license:asl2.0))))

(define-public rust-demo-hack-0.0.4
  (package
    (inherit rust-demo-hack-0.0.5)
    (name "rust-demo-hack")
    (version "0.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "demo-hack" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1mrcvy5ilnqv68qxgzp2g0zmwix7s8ic3lxj69yd18x3izcr7kb3"))))
    (arguments
     `(#:cargo-inputs (("rust-demo-hack-impl" ,rust-demo-hack-impl-0.0.4)
                       ("rust-proc-macro-hack" ,rust-proc-macro-hack-0.4))))))

(define-public rust-demo-hack-impl-0.0.5
  (package
    (name "rust-demo-hack-impl")
    (version "0.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "demo-hack-impl" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1f1fdl60xjas9wlmcl9v6f56vgm3mzwr019kcifav5464rx3w3ld"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro-hack" ,rust-proc-macro-hack-0.5)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-syn" ,rust-syn-0.15))))
    (home-page "https://github.com/dtolnay/proc-macro-hack")
    (synopsis "Demo of proc-macro-hack")
    (description "Demo of proc-macro-hack.")
    (license (list license:expat license:asl2.0))))

(define-public rust-demo-hack-impl-0.0.4
  (package
    (inherit rust-demo-hack-impl-0.0.5)
    (name "rust-demo-hack-impl")
    (version "0.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "demo-hack-impl" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1wb267k9g40z8p458q1g8nrq3x8cq13s2wnvx5fy9rd011f8qy7h"))))
    (arguments
     `(#:cargo-inputs (("rust-proc-macro-hack" ,rust-proc-macro-hack-0.4))))))

(define-public rust-deranged-0.3
  (package
    (name "rust-deranged")
    (version "0.3.11")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "deranged" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1d1ibqqnr5qdrpw8rclwrf1myn3wf0dygl04idf4j2s49ah6yaxl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-num-traits" ,rust-num-traits-0.2)
                       ("rust-powerfmt" ,rust-powerfmt-0.2)
                       ("rust-quickcheck" ,rust-quickcheck-1)
                       ("rust-rand" ,rust-rand-0.8)
                       ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs (("rust-rand" ,rust-rand-0.8)
                                   ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/jhpratt/deranged")
    (synopsis "Ranged integers")
    (description "Ranged integers.")
    (license (list license:expat license:asl2.0))))

(define-public rust-derivative-2
  (package
    (name "rust-derivative")
    (version "2.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derivative" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "02vpb81wisk2zh1d5f44szzxamzinqgq2k8ydrfjj2wwkrgdvhzw"))
       (modules '((guix build utils)))
       (snippet
        '(begin
           (substitute* "Cargo.toml"
             (("version = \"([[:digit:]]+(\\.[[:digit:]]+)*), <.*\"" _ version)
              (string-append "version = \"^" version "\"")))))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; Tests expect a very narrow range for trybuild.
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://github.com/mcarton/rust-derivative")
    (synopsis "Set of alternative @code{derive} attributes for Rust")
    (description
     "This package provides a set of alternative @code{derive} attributes for
Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-derive-arbitrary-1
  (package
    (name "rust-derive-arbitrary")
    (version "1.4.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "derive_arbitrary" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "000839h4mbgs65x1f8540kbjk2ifw68c4d8r5b9f7q0jv4d2qm1h"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-2))))
    (home-page "https://github.com/rust-fuzz/arbitrary")
    (synopsis "Derives arbitrary traits")
    (description "This crate implements support for automatically deriving the
@code{Arbitrary} trait.  Don't depend on this crate directly, though.
Instead, enable the @code{derive} feature of the @code{arbitrary} crate.")
    (license (list license:expat license:asl2.0))))

(define-public rust-derive-arbitrary-0.4
  (package
    (inherit rust-derive-arbitrary-1)
    (name "rust-derive-arbitrary")
    (version "0.4.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive_arbitrary" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1rp0z4k0j5ip0bx6dssg97l4q6bakhf6lm5h1lpr3p3kwjsi585i"))))
    (arguments
     `(#:cargo-inputs (("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-syn" ,rust-syn-1))))))

(define-public rust-derive-builder-0.20
  (package
    (name "rust-derive-builder")
    (version "0.20.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive_builder" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0is9z7v3kznziqsxa5jqji3ja6ay9wzravppzhcaczwbx84znzah"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-derive-builder-macro" ,rust-derive-builder-macro-0.20))
       #:cargo-development-inputs (("rust-rustversion" ,rust-rustversion-1)
                                   ("rust-serde" ,rust-serde-1)
                                   ("rust-serde-json" ,rust-serde-json-1)
                                   ("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://github.com/colin-kiegel/rust-derive-builder")
    (synopsis "Builder pattern for arbitrary structs")
    (description "Rust macro to automatically implement the builder pattern
for arbitrary structs.")
    (license (list license:expat license:asl2.0))))

(define-public rust-derive-builder-0.13
  (package
    (inherit rust-derive-builder-0.20)
    (name "rust-derive-builder")
    (version "0.13.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "derive_builder" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1irqx6bz74kx48ivdwqp2xl1ibr8dbdwgh6573r8g00d82gicncg"))))
    (arguments
     `(#:cargo-inputs
       (("rust-derive-builder-macro" ,rust-derive-builder-macro-0.13))
       #:cargo-development-inputs
       (("rust-pretty-assertions" ,rust-pretty-assertions-0.6)
        ("rust-rustversion" ,rust-rustversion-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-trybuild" ,rust-trybuild-1))))))

(define-public rust-derive-builder-0.12
  (package
    (inherit rust-derive-builder-0.13)
    (name "rust-derive-builder")
    (version "0.12.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "derive_builder" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1y4p569zcvpmly5s5hmjp9h83drxvdp6kj6bb61h225mhj3pfrwd"))))
    (arguments
     `(#:cargo-inputs
       (("rust-derive-builder-macro" ,rust-derive-builder-macro-0.12))
       #:cargo-development-inputs
       (("rust-pretty-assertions" ,rust-pretty-assertions-0.6)
        ("rust-rustversion" ,rust-rustversion-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-trybuild" ,rust-trybuild-1))))))

(define-public rust-derive-builder-0.11
  (package
    (inherit rust-derive-builder-0.12)
    (name "rust-derive-builder")
    (version "0.11.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive_builder" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "18q4jx8zvg2pkx2d1nmlklx8m48bwrghyg8rdg1irdwkw5xxyynh"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-derive-builder-macro" ,rust-derive-builder-macro-0.11))))))

(define-public rust-derive-builder-0.10
  (package
    (inherit rust-derive-builder-0.11)
    (name "rust-derive-builder")
    (version "0.10.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive_builder" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0c2v6vi0lih3fwwgwx92pspcmkrjz8wxfqwhmr01060ipvg04cni"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-derive-builder-macro" ,rust-derive-builder-macro-0.10))))))

(define-public rust-derive-builder-0.9
  (package
    (inherit rust-derive-builder-0.10)
    (name "rust-derive-builder")
    (version "0.9.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "derive_builder" version))
        (file-name
          (string-append name "-" version ".tar.gz"))
        (sha256
          (base32
            "1h4f8vnggmpyw27fznl3cpyjrzz1nw5xrxx6ca3zcb3z54hqcrd2"))))
    (arguments
      `(#:cargo-inputs
        (("rust-compiletest-rs" ,rust-compiletest-rs-0.3)
         ("rust-darling" ,rust-darling-0.10)
         ("rust-derive-builder-core" ,rust-derive-builder-core-0.9)
         ("rust-env-logger" ,rust-env-logger-0.5)
         ("rust-log" ,rust-log-0.4)
         ("rust-proc-macro2" ,rust-proc-macro2-1)
         ("rust-quote" ,rust-quote-1)
         ("rust-skeptic" ,rust-skeptic-0.13)
         ("rust-syn" ,rust-syn-1))
        #:cargo-development-inputs
        (("rust-pretty-assertions" ,rust-pretty-assertions-0.6))))))

(define-public rust-derive-builder-core-0.20
  (package
    (name "rust-derive-builder-core")
    (version "0.20.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive_builder_core" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1s640r6q46c2iiz25sgvxw3lk6b6v5y8hwylng7kas2d09xwynrd"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-darling" ,rust-darling-0.20)
                       ("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-syn" ,rust-syn-2))))
    (home-page "https://github.com/colin-kiegel/rust-derive-builder")
    (synopsis "Internal helper library for @code{rust-derive-builder}")
    (description
     "Internal helper library for @code{rust-derive-builder}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-derive-builder-core-0.13
  (package
    (inherit rust-derive-builder-core-0.20)
    (name "rust-derive-builder-core")
    (version "0.13.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "derive_builder_core" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1381dgjq6jhirww088dff8b00v2d99illvnan0l0kvz7qdy33v54"))))
    (arguments
     `(#:cargo-inputs (("rust-darling" ,rust-darling-0.14)
                       ("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-pretty-assertions" ,rust-pretty-assertions-1))))))

(define-public rust-derive-builder-core-0.12
  (package
    (inherit rust-derive-builder-core-0.13)
    (name "rust-derive-builder-core")
    (version "0.12.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "derive_builder_core" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "03vvmw3mfg370swq0dh2h5kcjjb8va2m4asqgp9wfyy4l08xq6y1"))))
    (arguments
     `(#:cargo-inputs (("rust-darling" ,rust-darling-0.14)
                       ("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-pretty-assertions" ,rust-pretty-assertions-0.6))))))

(define-public rust-derive-builder-core-0.11
  (package
    (inherit rust-derive-builder-core-0.12)
    (name "rust-derive-builder-core")
    (version "0.11.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive_builder_core" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1i5gmf5lglbg7agj1khc6k9swf1clfs5fg6w0icw1w91m77x948z"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-darling" ,rust-darling-0.14)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))))

(define-public rust-derive-builder-core-0.10
  (package
    (inherit rust-derive-builder-core-0.11)
    (name "rust-derive-builder-core")
    (version "0.10.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive_builder_core" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1r9ngcrfcvqv5l5p86bzg9v863bjf5nlmippin1fv1v1iy2idrk6"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-darling" ,rust-darling-0.12)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))))

(define-public rust-derive-builder-core-0.9
  (package
    (inherit rust-derive-builder-core-0.10)
    (name "rust-derive-builder-core")
    (version "0.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive_builder_core" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1vwb8nwls4lhd2yiyj87kmwws4mmfqfrjcr0pk09b11c6wzfm497"))))
    (arguments
     `(#:cargo-test-flags
       (list "--release" "--"
             "--skip=block::test::block_invalid_token_trees")
       #:cargo-inputs
       (("rust-darling" ,rust-darling-0.10)
        ("rust-log" ,rust-log-0.4)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-pretty-assertions" ,rust-pretty-assertions-0.6))))))

(define-public rust-derive-builder-macro-0.20
  (package
    (name "rust-derive-builder-macro")
    (version "0.20.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive_builder_macro" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0g1zznpqrmvjlp2w7p0jzsjvpmw5rvdag0rfyypjhnadpzib0qxb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-derive-builder-core" ,rust-derive-builder-core-0.20)
                       ("rust-syn" ,rust-syn-2))))
    (home-page "https://github.com/colin-kiegel/rust-derive-builder")
    (synopsis "Automatically implement the builder pattern for arbitrary structs")
    (description
     "This crate provides a Rust macro to automatically implement the builder
pattern for arbitrary structs.")
    (license (list license:expat license:asl2.0))))

(define-public rust-derive-builder-macro-0.13
  (package
    (inherit rust-derive-builder-macro-0.20)
    (name "rust-derive-builder-macro")
    (version "0.13.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "derive_builder_macro" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "09q17rzgf8bsj8n1bhlf4f93nmqg8va6321ppcd07f1mzg1nh0w7"))))
    (arguments
     `(#:cargo-inputs (("rust-derive-builder-core" ,rust-derive-builder-core-0.13)
                       ("rust-syn" ,rust-syn-1))))))

(define-public rust-derive-builder-macro-0.12
  (package
    (inherit rust-derive-builder-macro-0.13)
    (name "rust-derive-builder-macro")
    (version "0.12.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "derive_builder_macro" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "17p71qzh7x1q2yxzz3xrg73zw3xl0h479b7ybyjm0s1rg9fa7kgb"))))
    (arguments
     `(#:cargo-inputs (("rust-derive-builder-core" ,rust-derive-builder-core-0.12)
                       ("rust-syn" ,rust-syn-1))))))

(define-public rust-derive-builder-macro-0.11
  (package
    (inherit rust-derive-builder-macro-0.12)
    (name "rust-derive-builder-macro")
    (version "0.11.2")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "derive_builder_macro" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0s6xfgsybd9wbk39hbgqjcn7d1l36a33q6v7d0x5y17d5fvi80wg"))))
    (arguments
     `(#:cargo-inputs (("rust-derive-builder-core" ,rust-derive-builder-core-0.11)
                       ("rust-syn" ,rust-syn-1))))))

(define-public rust-derive-builder-macro-0.10
  (package
    (inherit rust-derive-builder-macro-0.11)
    (name "rust-derive-builder-macro")
    (version "0.10.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive_builder_macro" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0wwdm4cgd4vlvabj5xsjjr4vvkqhnd3fi9wp3v5mlb09jp74maaq"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-derive-builder-core" ,rust-derive-builder-core-0.10)
        ("rust-syn" ,rust-syn-1))))))

(define-public rust-derive-error-chain-0.10
  (package
    (name "rust-derive-error-chain")
    (version "0.10.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive-error-chain" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0jnybrpiq5jzx69xq74cwxply36js02z14y9sym8sf2iwsnsk71w"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-quote" ,rust-quote-0.3)
        ("rust-syn" ,rust-syn-0.11))))
    (home-page "https://github.com/Arnavion/derive-error-chain")
    (synopsis "Macros 1.1 implementation of error-chain")
    (description "This package provides a Macros 1.1 implementation of
error-chain.")
    (license (list license:expat license:asl2.0))))

(define-public rust-derive-more-0.99
  (package
    (name "rust-derive-more")
    (version "0.99.18")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive_more" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1kmz7bsjn9jh04nplqdr6bjyi90qkqjlxb8lm5zzvnp46y0qfcsz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-convert-case" ,rust-convert-case-0.4)
        ("rust-peg" ,rust-peg-0.5)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-rustc-version" ,rust-rustc-version-0.4)
        ("rust-syn" ,rust-syn-2))))
    (home-page "https://github.com/JelteF/derive_more")
    (synopsis "Adds derive macros for more traits")
    (description
     "Rust has lots of builtin traits that are implemented for its basic
types, such as @code{Add}, @code{Not}, @code{From} or @code{Display}.
However, when wrapping these types inside your own structs or enums you lose
the implementations of these traits and are required to recreate them.  This is
especially annoying when your own structures are very simple, such as when
using the commonly advised newtype pattern (e.g. @code{MyInt(i32)}).

This library tries to remove these annoyances and the corresponding
boilerplate code.  It does this by allowing you to derive lots of commonly used
traits for both structs and enums.")
    (license license:expat)))

(define-public rust-derive-more-0.15
  (package
    (inherit rust-derive-more-0.99)
    (name "rust-derive-more")
    (version "0.15.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive_more" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1zks5bn7hmqfz927spmridk9bvy7ly4f38vls331x4hc4hq1653s"))))
    (arguments
     `(#:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-regex" ,rust-regex-1)
        ("rust-rustc-version" ,rust-rustc-version-0.2)
        ("rust-syn" ,rust-syn-0.15))))))

(define-public rust-derive-more-0.14
  (package
    (inherit rust-derive-more-0.99)
    (name "rust-derive-more-1")
    (version "0.14.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive_more" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0fgq5ziyg0gwr5j7pghfrxgzqzmmadknivpigrsniliy0334m53d"))))
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-rustc-version" ,rust-rustc-version-0.2)
        ("rust-syn" ,rust-syn-0.15))))))

(define-public rust-derive-new-0.7
  (package
    (name "rust-derive-new")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive-new" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1k5y4lrj182n86zjb3q0rkajgfqazamjzinsi7prw616yi88vp1c"))))
    (build-system cargo-build-system)
    (arguments
     (list #:cargo-inputs (list rust-proc-macro2-1
                                rust-quote-1
                                rust-syn-2)))
    (home-page "https://github.com/nrc/derive-new")
    (synopsis "Simple constructor functions for structs and enums")
    (description "`#[derive(new)]` implements simple constructor functions for
structs and enums.")
    (license license:expat)))

(define-public rust-derive-new-0.6
  (package
    (inherit rust-derive-new-0.7)
    (name "rust-derive-new")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive-new" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1b8jv6jx0b8jgkz9kmz0ciqmnf74xkk0mmvkb5z1c87932kdwl6i"))))
    (arguments
     (list #:cargo-inputs (list rust-proc-macro2-1
                                rust-quote-1
                                rust-syn-2)))))

(define-public rust-derive-new-0.5
  (package
    (inherit rust-derive-new-0.6)
    (name "rust-derive-new")
    (version "0.5.9")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive-new" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0d9m5kcj1rdmdjqfgj7rxxhdzx0as7p4rp1mjx5j6w5dl2f3461l"))))
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))))

(define-public rust-derive-utils-0.14
  (package
    (name "rust-derive-utils")
    (version "0.14.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive_utils" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1sh7d2xsr32h1m9qpzn5nh3dfm2lz1xgrfklsnjlv72mp3s55wb5"))
       (modules '((guix build utils)))
       (snippet
        '(begin
           (substitute* "Cargo.toml"
             (("\\[lib\\]" all)
              (string-append "[dev-dependencies]" "\n"
                             "trybuild = \"1\"" "\n"
                             "\n" all)))))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-syn" ,rust-syn-2))
       #:cargo-development-inputs (("rust-rustversion" ,rust-rustversion-1)
                                   ("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://github.com/taiki-e/derive_utils")
    (synopsis "Macro helper for easily writing derives macros for enum")
    (description "This crate provides a procedural macro helper for easily
writing derives macros for enums.")
    (license (list license:expat license:asl2.0))))

(define-public rust-derive-utils-0.11
  (package
    (inherit rust-derive-utils-0.14)
    (name "rust-derive-utils")
    (version "0.11.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive_utils" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1gx7giwn8x427d5f8c92n9h0hhcqdsasvz7i8iq2rqffvhalqask"))))
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-rustversion" ,rust-rustversion-1)
        ("rust-trybuild" ,rust-trybuild-1))))))

(define-public rust-derive-visitor-0.4
  (package
    (name "rust-derive-visitor")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive-visitor" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "17nacybndh0n2ayf0vchcrm5n4k6bmx605ijvax7qw5rhggnawfl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-derive-visitor-macros" ,rust-derive-visitor-macros-0.4))))
    (home-page "https://github.com/nikis05/derive-visitor")
    (synopsis "Derive visitor pattern for arbitrary data structures")
    (description "Derive visitor pattern for arbitrary data structures.")
    (license license:expat)))

(define-public rust-derive-visitor-macros-0.4
  (package
    (name "rust-derive-visitor-macros")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive-visitor-macros" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1xnyz3vxp2ph0y0h7zmlbvij440m6w2gbwx5n4bfmbzcbyl3jys2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-convert-case" ,rust-convert-case-0.4)
                       ("rust-itertools" ,rust-itertools-0.10)
                       ("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/nikis05/derive-visitor")
    (synopsis "Macros for derive-visitor package")
    (description "Macros for derive-visitor package.")
    (license license:expat)))

(define-public rust-derive-where-1
  (package
    (name "rust-derive-where")
    (version "1.2.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "derive-where" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "09cx25r1zb8xrsgd9cj9j5zmg30n7lnvcmspqymyn9d887673mk2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-2))
       #:cargo-development-inputs
       (("rust-pretty-assertions" ,rust-pretty-assertions-1)
        ("rust-rustversion" ,rust-rustversion-1)
        ("rust-trybuild" ,rust-trybuild-1)
        ("rust-zeroize" ,rust-zeroize-1))))
    (home-page "https://github.com/ModProg/derive-where")
    (synopsis "Deriving with custom trait bounds")
    (description "Deriving with custom trait bounds.")
    (license (list license:expat license:asl2.0))))

(define-public rust-descape-2
  (package
    (name "rust-descape")
    (version "2.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "descape" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0c56nbjgnba9s4lmfq2b89mrifkzwfc48hh7n5iwk06z12wi64bw"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/balt-dev/descape")
    (synopsis "Adds a single extension trait for &str to unescape any backslashes")
    (description
     "This package adds a single extension trait for &str to unescape any
backslashes.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-deser-hjson-1
  (package
    (name "rust-deser-hjson")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "deser-hjson" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1bacgp2zhyxj6m7hh00sl65b8bripw5nb80jwcniplglzscspq9h"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t     ; Cut the dependency chain.
       #:cargo-inputs (("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/Canop/deser-hjson")
    (synopsis "Hjson deserializer for Serde")
    (description "This package provides an Hjson deserializer for Serde.")
    (license license:expat)))

(define-public rust-detect-desktop-environment-1
  (package
    (name "rust-detect-desktop-environment")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "detect-desktop-environment" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1crybsn50nax07zz2sxyi88nfq05yyqicqqa6ni03j8swfxs29yg"))))
    (build-system cargo-build-system)
    (arguments
     (list #:cargo-test-flags
           ''("--release" "--"
              "--skip=DesktopEnvironment::from_freedesktop"
              "--skip=DesktopEnvironment::from_xdg_name")))
    (home-page "https://github.com/demurgos/detect-desktop-environment")
    (synopsis "Autodetect the desktop environment")
    (description "This package provides autodetect for the desktop environment.")
    (license license:expat)))

(define-public rust-detect-desktop-environment-0.2
  (package
    (inherit rust-detect-desktop-environment-1)
    (name "rust-detect-desktop-environment")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "detect-desktop-environment" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0408nmfgb54wqigjpqxwcxy5jp4ni1fjvynqdgpa84svvmhavn11"))))
    (arguments '())))

(define-public rust-detone-1
  (package
    (name "rust-detone")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "detone" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "052mnp8qjp71ypcv0ixvlw7isn1yv79qn05jrcfi9j2r70clq47p"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs (("rust-unic-normal" ,rust-unic-normal-0.9))))
    (home-page "https://docs.rs/detone/")
    (synopsis "Decompose Vietnamese tone marks")
    (description "Decompose Vietnamese tone marks.")
    (license (list license:expat license:asl2.0))))

(define-public rust-deunicode-1
  (package
    (name "rust-deunicode")
    (version "1.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "deunicode" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "006gnml4jy3m03yqma8qvx7kl9i2bw667za9f7yc6k9ckv64959k"))))
    (build-system cargo-build-system)
    (home-page "https://lib.rs/crates/deunicode")
    (synopsis "Convert Unicode strings to pure ASCII")
    (description
     "This package converts Unicode strings to pure ASCII by intelligently
transliterating them.  It supports Emoji and Chinese.")
    (license license:bsd-3)))

(define-public rust-deunicode-0.4
  (package
    (inherit rust-deunicode-1)
    (name "rust-deunicode")
    (version "0.4.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "deunicode" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "133m63d7x3y3kpf8hrdkjpqma9l74bv59rpmpb8rqgn2i6zz3nvi"))))
    (arguments `(#:cargo-inputs (("rust-deunicode" ,rust-deunicode-1))))))

(define-public rust-devise-0.4
  (package
    (name "rust-devise")
    (version "0.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "devise" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "07b5dza9dl5p15q32xng8pgmmhf7kbjpng2y46njqykp9h60pngi"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-devise-codegen" ,rust-devise-codegen-0.4)
                       ("rust-devise-core" ,rust-devise-core-0.4))))
    (home-page "https://github.com/SergioBenitez/Devise")
    (synopsis "Library for devising derives and other procedural macros")
    (description
     "This package provides a library for devising derives and other
procedural macros.")
    (license (list license:expat license:asl2.0))))

(define-public rust-devise-0.3
  (package
    (inherit rust-devise-0.4)
    (name "rust-devise")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "devise" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "15dmibnykic2a1ndi66shyvxmpfysnhf05lg2iv8871g0w5miish"))))
    (arguments
     `(#:cargo-inputs (("rust-devise-codegen" ,rust-devise-codegen-0.3)
                       ("rust-devise-core" ,rust-devise-core-0.3))))))

(define-public rust-devise-0.2
  (package
    (inherit rust-devise-0.4)
    (name "rust-devise")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "devise" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "09p52f54givb0g9l7clj11z755vldk8758y2lwm5mp3sa156qwfx"))))
    (arguments
     `(#:cargo-inputs (("rust-devise-codegen" ,rust-devise-codegen-0.2)
                       ("rust-devise-core" ,rust-devise-core-0.2))
       #:phases (modify-phases %standard-phases
                  ;; Enable using nightly/dev features
                  (add-after 'unpack 'enable-unstable-features
                    (lambda _
                      (setenv "RUSTC_BOOTSTRAP" "1"))))))))

(define-public rust-devise-codegen-0.4
  (package
    (name "rust-devise-codegen")
    (version "0.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "devise_codegen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0ryq9xibibjf82xhr26civsw7bg6id8j4j9kl9qaa5xyv208dcki"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-devise-core" ,rust-devise-core-0.4)
                       ("rust-quote" ,rust-quote-1))))
    (home-page "https://github.com/SergioBenitez/Devise")
    (synopsis "Library for devising derives and other procedural macros")
    (description
     "This package provides a library for devising derives and other
procedural macros.")
    (license (list license:expat license:asl2.0))))

(define-public rust-devise-codegen-0.3
  (package
    (inherit rust-devise-codegen-0.4)
    (name "rust-devise-codegen")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "devise_codegen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1cp7nnfwvjp6wfq11n0ffjjrwfa1wbsb58g1bz3ha6z5lvkp6g0j"))))
    (arguments
     `(#:cargo-inputs (("rust-devise-core" ,rust-devise-core-0.3)
                       ("rust-quote" ,rust-quote-1))))))

(define-public rust-devise-codegen-0.2
  (package
    (inherit rust-devise-codegen-0.4)
    (name "rust-devise-codegen")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "devise_codegen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0lxbixni2v6snx2mkgi0kyq5dv8v6c5s57b6wc47q4hqs6884yza"))))
    (arguments
     `(#:cargo-inputs (("rust-devise-core" ,rust-devise-core-0.2)
                       ("rust-quote" ,rust-quote-0.6))
       #:phases (modify-phases %standard-phases
                  ;; Enable using nightly/dev features
                  (add-after 'unpack 'enable-unstable-features
                    (lambda _
                      (setenv "RUSTC_BOOTSTRAP" "1"))))))))

(define-public rust-devise-core-0.4
  (package
    (name "rust-devise-core")
    (version "0.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "devise_core" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1xwa9dp1i66zwfywgvz4189gxzpbpanagmf4wgr03gvsrx1aaddh"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-2)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-proc-macro2-diagnostics" ,rust-proc-macro2-diagnostics-0.10)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-2))))
    (home-page "https://github.com/SergioBenitez/Devise")
    (synopsis "Library for devising derives and other procedural macros")
    (description
     "This package provides a library for devising derives and other
procedural macros.")
    (license (list license:expat license:asl2.0))))

(define-public rust-devise-core-0.3
  (package
    (inherit rust-devise-core-0.4)
    (name "rust-devise-core")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "devise_core" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1l00qiih4z14ai0c3s16nlvw0kv4p07ygi6a0ms0knc78xpz87l4"))))
    (arguments
     `(#:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-proc-macro2-diagnostics" ,rust-proc-macro2-diagnostics-0.9)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))))

(define-public rust-devise-core-0.2
  (package
    (inherit rust-devise-core-0.4)
    (name "rust-devise-core")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "devise_core" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0wr3jdzzibpafz73hcca83wnzdgjinvm7axmxnyfkbasbnfkw1fi"))))
    (arguments
     `(#:cargo-inputs (("rust-bitflags" ,rust-bitflags-1)
                       ("rust-proc-macro2" ,rust-proc-macro2-0.4)
                       ("rust-quote" ,rust-quote-0.6)
                       ("rust-syn" ,rust-syn-0.15))
       #:phases (modify-phases %standard-phases
                  ;; Enable using nightly/dev features
                  (add-after 'unpack 'enable-unstable-features
                    (lambda _
                      (setenv "RUSTC_BOOTSTRAP" "1"))))))))

(define-public rust-dhcp4r-0.2
  (package
    (name "rust-dhcp4r")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dhcp4r" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0paq13i9iz5545f5aw8ijxflw20fvb3k8s4m3inr5q19q5rirpbc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-enum-primitive-derive" ,rust-enum-primitive-derive-0.2)
        ("rust-nom" ,rust-nom-6)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-time" ,rust-time-0.2))))
    (home-page "https://github.com/krolaw/dhcp4r")
    (synopsis "IPv4 DHCP library with working server example")
    (description
     "This package provides a library for IPv4 DHCP including a working server
example.")
    (license license:bsd-3)))

(define-public rust-dhcproto-0.9
  (package
    (name "rust-dhcproto")
    (version "0.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dhcproto" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1hsbl77lxvxa94ihn2vna1sx2icrkch427w24a883xymhm9h9vnw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags '("--release" "--"
                            "--skip=v6::options::tests::test_range_binsearch")
       #:cargo-inputs (("rust-dhcproto-macros" ,rust-dhcproto-macros-0.1)
                       ("rust-hex" ,rust-hex-0.4)
                       ("rust-ipnet" ,rust-ipnet-2)
                       ("rust-rand" ,rust-rand-0.8)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-thiserror" ,rust-thiserror-1)
                       ("rust-trust-dns-proto" ,rust-trust-dns-proto-0.22)
                       ("rust-url" ,rust-url-2))
       #:cargo-development-inputs (("rust-criterion" ,rust-criterion-0.3)
                                   ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/bluecatengineering/dhcproto")
    (synopsis "DHCP parser and encoder for DHCPv4/DHCPv6")
    (description
     "This package provides a DHCP parser and encoder for DHCPv4/DHCPv6.
@code{dhcproto} aims to be a functionally complete DHCP implementation.")
    (license license:expat)))

(define-public rust-dhcproto-macros-0.1
  (package
    (name "rust-dhcproto-macros")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dhcproto-macros" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0w61gvnm17frkm6mk8q4xkwd1iji946lj5f175w585h4hvxkx6d7"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/bluecatengineering/dhcproto")
    (synopsis "Macro library for generating option types for dhcproto")
    (description
     "This package provides a macro library for generating option types for
dhcproto.")
    (license license:expat)))

(define-public rust-dialoguer-0.11
  (package
    (name "rust-dialoguer")
    (version "0.11.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dialoguer" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1pl0744wwr97kp8qnaybzgrfwk66qakzq0i1qrxl03vpbn0cx2v5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; unresolved import `dialoguer::History`
       #:cargo-inputs (("rust-console" ,rust-console-0.15)
                       ("rust-fuzzy-matcher" ,rust-fuzzy-matcher-0.3)
                       ("rust-shell-words" ,rust-shell-words-1)
                       ("rust-tempfile" ,rust-tempfile-3)
                       ("rust-thiserror" ,rust-thiserror-1)
                       ("rust-zeroize" ,rust-zeroize-1))))
    (home-page "https://github.com/console-rs/dialoguer")
    (synopsis "Command line prompting library")
    (description "This package provides a command line prompting library.")
    (license license:expat)))

(define-public rust-dialoguer-0.10
  (package
    (inherit rust-dialoguer-0.11)
    (name "rust-dialoguer")
    (version "0.10.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dialoguer" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "11rgzrhi677w9gf1r3ip2x361svdkjkr2m5dsfca9fcljacg5ijr"))))
    (arguments
     `(#:cargo-inputs (("rust-console" ,rust-console-0.15)
                       ("rust-fuzzy-matcher" ,rust-fuzzy-matcher-0.3)
                       ("rust-shell-words" ,rust-shell-words-1)
                       ("rust-tempfile" ,rust-tempfile-3)
                       ("rust-zeroize" ,rust-zeroize-1))))))

(define-public rust-diff-0.1
  (package
    (name "rust-diff")
    (version "0.1.13")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "diff" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1j0nzjxci2zqx63hdcihkp0a4dkdmzxd7my4m7zk6cjyfy34j9an"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3)
        ("rust-quickcheck" ,rust-quickcheck-1)
        ("rust-speculate" ,rust-speculate-0.1))))
    (home-page "https://github.com/utkarshkukreti/diff.rs")
    (synopsis "LCS based slice and string diffing implementation")
    (description
     "An LCS based slice and string diffing implementation.")
    (license (list license:expat license:asl2.0))))

(define-public rust-difference-2
  (package
    (name "rust-difference")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "difference" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1621wx4k8h452p6xzmzzvm7mz87kxh4yqz0kzxfjj9xmjxlbyk2j"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-getopts" ,rust-getopts-0.2))
       #:cargo-development-inputs
       (("rust-quickcheck" ,rust-quickcheck-0.8)
        ("rust-term" ,rust-term-0.5))))
    (home-page "https://github.com/johannhof/difference.rs")
    (synopsis "Rust text diffing and assertion library")
    (description
     "This package provides a Rust text diffing and assertion library.")
    (license license:expat)))

(define-public rust-difference-1
  (package
    (inherit rust-difference-2)
    (name "rust-difference")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "difference" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1a5v0b73z7vywbclll32wjsfkdgh6wn9prnq91z0d3lag4clsc5k"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-getopts" ,rust-getopts-0.2))
       #:cargo-development-inputs
       (("rust-term" ,rust-term-0.2))))))

(define-public rust-difflib-0.4
  (package
    (name "rust-difflib")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "difflib" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1s7byq4d7jgf2hcp2lcqxi2piqwl8xqlharfbi8kf90n8csy7131"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/DimaKudosh/difflib")
    (synopsis "Compare word sequences in Rust")
    (description
     "This crate provides all necessary tools for comparing word sequences.")
    (license license:expat)))

(define-public rust-diffs-0.5
  (package
    (name "rust-diffs")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "diffs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "01f8bp77kgahgvr3s2igmnmsxynjklq830lmp2wp2jyph6bnq4gz"))))
    (build-system cargo-build-system)
    (arguments
     (list #:tests? #f))    ; unresolved imports `myers`, `Diff`, `Replace`
    (home-page "https://nest.pijul.com/pijul/diffs")
    (synopsis "Diff algorithms, also called longest common subsequence")
    (description
     "This package provides a number of diff algorithms, also called longest
common subsequence.  The diff algorithms include Myer's diff and Patience
diff.")
    (license (list license:expat license:asl2.0))))

(define-public rust-dircpy-0.3
  (package
    (name "rust-dircpy")
    (version "0.3.19")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dircpy" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "070k84wvc4d364rglwvhjk7psj938nmxh98rs58rspvza6q231d8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t     ; Cut the dependency chain.
       #:cargo-inputs (("rust-jwalk" ,rust-jwalk-0.8)
                       ("rust-log" ,rust-log-0.4)
                       ("rust-walkdir" ,rust-walkdir-2))))
    (home-page "https://github.com/woelper/dircpy/")
    (synopsis "Copy directories recursively with flexible options")
    (description "Copy directories recursively with flexible options.")
    (license license:expat)))

(define-public rust-directories-5
  (package
    (name "rust-directories")
    (version "5.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "directories" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0dba6xzk79s1clqzxh2qlgzk3lmvvks1lzzjhhi3hd70hhxifjcs"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-dirs-sys" ,rust-dirs-sys-0.4))
       #:cargo-development-inputs
       (("rust-bencher" ,rust-bencher-0.1))))
    (home-page "https://github.com/dirs-dev/directories-rs")
    (synopsis "Library for standard locations of data directories")
    (description
     "This package provides a tiny mid-level library that provides
platform-specific standard locations of directories for config,
cache and other data on Linux, Windows and macOS by leveraging the
mechanisms defined by the XDG base/user directory specifications
on Linux, the Known Folder API on Windows, and the Standard
Directory guidelines on macOS.")
    (license (list license:expat license:asl2.0))))

(define-public rust-directories-4
  (package
    (inherit rust-directories-5)
    (name "rust-directories")
    (version "4.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "directories" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "045jbj5y2f1fmjs9rfcw95y0vjydb2rqqhz1sdnqhdmxv96ms77m"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-dirs-sys" ,rust-dirs-sys-0.3))))))

(define-public rust-directories-3
  (package
    (inherit rust-directories-4)
    (name "rust-directories")
    (version "3.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "directories" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1mz1khca62zd48kphdy5hn4f8r55ywkyn23pjdbkj4h32zzh15p6"))))
    (arguments
     `(#:cargo-inputs (("rust-dirs-sys" ,rust-dirs-sys-0.3))
       #:cargo-development-inputs (("rust-bencher" ,rust-bencher-0.1))))))

(define-public rust-directories-next-2
  (package
    (name "rust-directories-next")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "directories-next" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1g1vq8d8mv0vp0l317gh9y46ipqg2fxjnbc7lnjhwqbsv4qf37ik"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-dirs-sys-next" ,rust-dirs-sys-next-0.1))))
    (home-page "https://github.com/xdg-rs/dirs/tree/master/directories")
    (synopsis "Mid-level library for standard locations of data directories")
    (description
     "This package provides a tiny mid-level library that provides
platform-specific standard locations of directories for config, cache and
other data.")
    (license (list license:expat license:asl2.0))))

(define-public rust-dirs-5
  (package
    (name "rust-dirs")
    (version "5.0.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "dirs" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0992xk5vx75b2x91nw9ssb51mpl8x73j9rxmpi96cryn0ffmmi24"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-dirs-sys" ,rust-dirs-sys-0.4))))
    (home-page "https://github.com/soc/dirs-rs")
    (synopsis "Abstractions for standard locations for various platforms")
    (description
     "This package is a tiny low-level library that provides platform-specific
standard locations of directories for config, cache and other data.")
    (license (list license:expat license:asl2.0))))

(define-public rust-dirs-4
  (package
    (inherit rust-dirs-5)
    (name "rust-dirs")
    (version "4.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dirs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0n8020zl4f0frfnzvgb9agvk4a14i1kjz4daqnxkgslndwmaffna"))))
    (arguments
     `(#:cargo-inputs
       (("rust-dirs-sys" ,rust-dirs-sys-0.3))))))

(define-public rust-dirs-3
  (package
    (inherit rust-dirs-4)
    (name "rust-dirs")
    (version "3.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dirs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "028kqy0vrbfgrk1yc1flq2fqh8snyg17qlygawm0r79w211s1fih"))))))

(define-public rust-dirs-2
  (package
    (inherit rust-dirs-3)
    (name "rust-dirs")
    (version "2.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dirs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1qymhyq7w7wlf1dirq6gsnabdyzg6yi2yyxkx6c4ldlkbjdaibhk"))))
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-dirs-sys" ,rust-dirs-sys-0.3))))))

(define-public rust-dirs-1
  (package
    (inherit rust-dirs-2)
    (name "rust-dirs")
    (version "1.0.5")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "dirs" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "009rrhzj9pxyncmm2vhlj70npg0cgggv2hjbbkiwdl9vccq8kmrz"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-redox-users" ,rust-redox-users-0.3)
        ("rust-winapi" ,rust-winapi-0.3))))))

(define-public rust-dirs-next-2
  (package
    (name "rust-dirs-next")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dirs-next" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1q9kr151h9681wwp6is18750ssghz6j9j7qm7qi1ngcwy7mzi35r"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-dirs-sys-next" ,rust-dirs-sys-next-0.1))))
    (home-page "https://github.com/xdg-rs/dirs")
    (synopsis "Abstractions for standard locations for various platforms")
    (description
     "This package provides a tiny low-level library that provides
platform-specific standard locations of directories for config, cache and
other data.")
    (license (list license:expat license:asl2.0))))

(define-public rust-dirs-next-1
  (package
    (inherit rust-dirs-next-2)
    (name "rust-dirs-next")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dirs-next" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1dl2dqzsrcb7qigfiwpdpakhdkpz0629pvylbj2ylyrkh1dfcdng"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-dirs-sys" ,rust-dirs-sys-next-0.1))))
    (home-page "https://github.com/xdg-rs/dirs")
    (license (list license:expat license:asl2.0))))

(define-public rust-dirs-sys-0.4
  (package
    (name "rust-dirs-sys")
    (version "0.4.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "dirs-sys" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "071jy0pvaad9lsa6mzawxrh7cmr7hsmsdxwzm7jzldfkrfjha3sj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-option-ext" ,rust-option-ext-0.2)
        ("rust-redox-users" ,rust-redox-users-0.4)
        ("rust-windows-sys" ,rust-windows-sys-0.48))))
    (home-page "https://github.com/dirs-dev/dirs-sys-rs")
    (synopsis
     "System-level helper functions for the dirs and directories crates")
    (description
     "This package provides system-level helper functions for the @code{dirs}
and @code{directories} crates.")
    (license (list license:expat license:asl2.0))))

(define-public rust-dirs-sys-0.3
  (package
    (inherit rust-dirs-sys-0.4)
    (name "rust-dirs-sys")
    (version "0.3.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dirs-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "19md1cnkazham8a6kh22v12d8hh3raqahfk6yb043vrjr68is78v"))))
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-redox-users" ,rust-redox-users-0.4)
        ("rust-winapi" ,rust-winapi-0.3))))))

(define-public rust-dirs-sys-next-0.1
  (package
    (name "rust-dirs-sys-next")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dirs-sys-next" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0kavhavdxv4phzj4l0psvh55hszwnr0rcz8sxbvx20pyqi2a3gaf"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-redox-users" ,rust-redox-users-0.4)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/xdg-rs/dirs/tree/master/dirs-sys")
    (synopsis "Shared code for dirs-next and directories-next")
    (description
     "This package only exists to facilitate code sharing between
dirs-next and directories-next.")
    (license (list license:expat license:asl2.0))))

(define-public rust-discard-1
  (package
    (name "rust-discard")
    (version "1.0.4")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "discard" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1h67ni5bxvg95s91wgicily4ix7lcw7cq0a5gy9njrybaibhyb91"))))
    (build-system cargo-build-system)
    (arguments '(#:skip-build? #t))
    (home-page "https://github.com/Pauan/rust-discard")
    (synopsis "Allow for intentionally leaking memory")
    (description "There are situations where you need to intentionally leak some
memory but not other memory.  This package provides a discard trait which allows
for intentionally leaking memory")
    (license license:expat)))

(define-public rust-displaydoc-0.2
  (package
    (name "rust-displaydoc")
    (version "0.2.5")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "displaydoc" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                 "1q0alair462j21iiqwrr21iabkfnb13d6x5w95lkdg21q2xrqdlp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-2))
       #:cargo-development-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-pretty-assertions" ,rust-pretty-assertions-0.6)
        ("rust-rustversion" ,rust-rustversion-1)
        ("rust-static-assertions" ,rust-static-assertions-1)
        ("rust-thiserror" ,rust-thiserror-1)
        ("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://github.com/yaahc/displaydoc")
    (synopsis
     "Derive macro for implementing the display Trait via a doc comment")
    (description
     "This package provides a derive macro for implementing the display Trait
via a doc comment and string interpolation.")
    (license (list license:expat license:asl2.0))))

(define-public rust-dissimilar-1
  (package
    (name "rust-dissimilar")
    (version "1.0.9")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dissimilar" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0bcn4s99ghigd3yadpd7i3gljv5z2hkr07ijvvxvsxmz3yfygy2r"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/dtolnay/dissimilar")
    (synopsis "Diff library with semantic cleanup")
    (description
     "This package provides a diff library with semantic cleanup, based on
Google's diff-match-patch.")
    (license (list license:expat license:asl2.0))))

(define-public rust-divan-0.1
  (package
    (name "rust-divan")
    (version "0.1.17")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "divan" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1i5qvk7h9fcrr89cxkmadpgm03sv7askplyqh8vb0a8b0a9k2n70"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-cfg-if" ,rust-cfg-if-1)
                       ("rust-clap" ,rust-clap-4)
                       ("rust-condtype" ,rust-condtype-1)
                       ("rust-divan-macros" ,rust-divan-macros-0.1)
                       ("rust-libc" ,rust-libc-0.2)
                       ("rust-regex-lite" ,rust-regex-lite-0.1))
       #:cargo-development-inputs (("rust-mimalloc" ,rust-mimalloc-0.1))))
    (inputs (list mimalloc))
    (home-page "https://github.com/nvzqz/divan")
    (synopsis "Statistically-comfy benchmarking library")
    (description "Statistically-comfy benchmarking library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-divan-macros-0.1
  (package
    (name "rust-divan-macros")
    (version "0.1.17")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "divan-macros" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0z5n3f4m5c7flqnr6vg9qz51j9mjb1s2afcsfnqf7x9nwsc1vicd"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-syn" ,rust-syn-2))))
    (home-page "https://github.com/nvzqz/divan")
    (synopsis "Macros for Divan, a statistically-comfy benchmarking library")
    (description "This package provides macros for Divan, a statistically-comfy
benchmarking library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-dlib-0.5
  (package
    (name "rust-dlib")
    (version "0.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dlib" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "04m4zzybx804394dnqs1blz241xcy480bdwf3w9p4k6c3l46031k"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f                      ;FIXME: Several macros are not found.
       #:cargo-inputs
       (("rust-libloading" ,rust-libloading-0.8))))
    (home-page "https://github.com/vberger/dlib")
    (synopsis "Helper macros for manually loading optional system libraries")
    (description
     "This package provides helper macros for handling manually loading optional
system libraries.")
    (license license:expat)))

(define-public rust-dlib-0.4
  (package
    (inherit rust-dlib-0.5)
    (name "rust-dlib")
    (version "0.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dlib" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0xlsf3lrz9hd7q3ff6lp5mw4kn3nbryn746kd07i93r6wg8ia7xi"))))
    (arguments
     `(#:cargo-inputs
       (("rust-libloading" ,rust-libloading-0.6))))
    (inputs
     (list rust-libloading-0.6))))

(define-public rust-dlv-list-0.5
  (package
    (name "rust-dlv-list")
    (version "0.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dlv-list" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0pqvrinxzdz7bpy4a3p450h8krns3bd0mc3w0qqvm03l2kskj824"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-const-random" ,rust-const-random-0.1)
                       ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-coverage-helper" ,rust-coverage-helper-0.2)
        ("rust-serde-test" ,rust-serde-test-1))))
    (home-page "https://github.com/sgodwincs/dlv-list-rs")
    (synopsis "Semi-doubly linked list implemented using a vector")
    (description
     "This package provides a semi-doubly linked list implemented using a vector.")
    (license (list license:expat license:asl2.0))))

(define-public rust-dlv-list-0.3
  (package
    (name "rust-dlv-list")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dlv-list" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0mqj5rdkcjksw3kvjj0nga6rzcpppx0kimjwi527yhifz6kw5206"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/sgodwincs/dlv-list-rs")
    (synopsis "Semi-doubly linked list implemented using a vector")
    (description
     "This crate provides semi-doubly linked lists implemented using
a vector.")
    (license license:expat)))

(define-public rust-dlv-list-0.2
  (package
    (inherit rust-dlv-list-0.3)
    (name "rust-dlv-list")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dlv-list" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "06r1nskj3x56p5wqz2bgl6q3rpyymrb0k0zpbvk8c6qcd4mkzpv8"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-rand" ,rust-rand-0.8))))))

(define-public rust-dns-lookup-2
  (package
    (name "rust-dns-lookup")
    (version "2.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dns-lookup" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1z74n2zij2gahycabm0gkmkyx574h76gwk7sz93yqpr3qa3n0xp5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags '("--release" "--"
                            ;; Tries to access the network
                            "--skip=nameinfo::test_getnameinfo"
                            "--skip=src/lib.rs - (line 36)")
       #:cargo-inputs (("rust-cfg-if" ,rust-cfg-if-1)
                       ("rust-libc" ,rust-libc-0.2)
                       ("rust-socket2" ,rust-socket2-0.5)
                       ("rust-windows-sys" ,rust-windows-sys-0.48))))
    (home-page "https://github.com/keeperofdakeys/dns-lookup/")
    (synopsis "DNS resolution interface")
    (description
     "This package provides a simple DNS resolving interface, much like Rust's
unstable API.  It includes @code{getaddrinfo} and @code{getnameinfo} wrappers
for libc variants.")
    (license (list license:expat license:asl2.0))))

(define-public rust-dns-parser-0.8
  (package
    (name "rust-dns-parser")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dns-parser" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1spv0psvxc31qg9xnqf0gmjclyiim7vp23r2b1gzf1ix8zlkply4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-byteorder" ,rust-byteorder-1)
        ("rust-quick-error" ,rust-quick-error-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1))
       #:cargo-development-inputs
       (("rust-matches" ,rust-matches-0.1))))
    (home-page "https://github.com/tailhook/dns-parser")
    (synopsis "DNS protocol parser library")
    (description "This package provide a DNS protocol parser library.  It does
not support network, only raw protocol parser.")
    (license (list license:expat license:asl2.0))))

(define-public rust-dns-sd-0.1
  (package
    (name "rust-dns-sd")
    (version "0.1.3")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "dns-sd" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32 "11r0jymjshfnn3sh2nqjhrikk4r5rr1g36sip9iqy8i0xafm0j6p"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2))
       #:cargo-development-inputs
       (("rust-pkg-config" ,rust-pkg-config-0.3))))
    (inputs (list avahi))
    (native-inputs (list pkg-config))
    (home-page "https://github.com/plietar/rust-dns-sd")
    (synopsis "Rust binding for DNS-SD")
    (description "Rust bindings for DNS Service Discovery (DNS-SD).")
    (license license:expat)))

(define-public rust-doc-comment-0.3
  (package
    (name "rust-doc-comment")
    (version "0.3.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "doc-comment" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "043sprsf3wl926zmck1bm7gw0jq50mb76lkpk49vasfr6ax1p97y"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/GuillaumeGomez/doc-comment")
    (synopsis "Macro to generate doc comments")
    (description "This package provides a way to generate doc comments
from macros.")
    (license license:expat)))

(define-public rust-dockworker-0.5
  (package
    (name "rust-dockworker")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dockworker" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1grdrc54l50ji3b1x25gx63qcjpsapjrw95fvh5p83za0k81ai8v"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags
       '("--release" "--" ; Tests require network access.
         "--skip=docker::tests::test_api"
         "--skip=docker::tests::test_events"
         "--skip=docker::tests::test_networks"
         "--skip=docker::tests::test_ping"
         "--skip=docker::tests::test_system_info"
         "--skip=docker::tests::test_version")
       #:cargo-inputs
       (("rust-async-stream" ,rust-async-stream-0.3)
        ("rust-async-trait" ,rust-async-trait-0.1)
        ("rust-base64" ,rust-base64-0.21)
        ("rust-byteorder" ,rust-byteorder-1)
        ("rust-bytes" ,rust-bytes-1)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-dirs" ,rust-dirs-5)
        ("rust-futures" ,rust-futures-0.3)
        ("rust-http" ,rust-http-0.2)
        ("rust-hyper" ,rust-hyper-0.14)
        ("rust-hyper-rustls" ,rust-hyper-rustls-0.24)
        ("rust-hyper-tls" ,rust-hyper-tls-0.5)
        ("rust-hyperlocal" ,rust-hyperlocal-0.8)
        ("rust-log" ,rust-log-0.4)
        ("rust-named-pipe" ,rust-named-pipe-0.4)
        ("rust-native-tls" ,rust-native-tls-0.2)
        ("rust-nix" ,rust-nix-0.26)
        ("rust-openssl" ,rust-openssl-0.10)
        ("rust-rustls" ,rust-rustls-0.21)
        ("rust-rustls-pemfile" ,rust-rustls-pemfile-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-tar" ,rust-tar-0.4)
        ("rust-thiserror" ,rust-thiserror-1)
        ("rust-tokio" ,rust-tokio-1)
        ("rust-tokio-stream" ,rust-tokio-stream-0.1)
        ("rust-tokio-util" ,rust-tokio-util-0.7)
        ("rust-url" ,rust-url-2))
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.8)
        ("rust-reqwest" ,rust-reqwest-0.11))))
    (native-inputs (list pkg-config))
    (inputs (list openssl))
    (home-page "https://github.com/Idein/dockworker")
    (synopsis "Docker daemon API client (a fork of Faraday's boondock)")
    (description
     "This package provides a Rust library for talking to the Docker daemon.
This project is a fork of Faraday's boondock.")
    (license license:asl2.0)))

(define-public rust-k8s-openapi-0.22
  (package
    (name "rust-k8s-openapi")
    (version "0.22.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "k8s-openapi" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0mcpy1gdxpqayc74i3x3ayh3q5bl6dzvsgmw91jq1r9sjkxill0r"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-base64" ,rust-base64-0.22)
                       ("rust-chrono" ,rust-chrono-0.4)
                       ("rust-schemars" ,rust-schemars-0.8)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-serde-value" ,rust-serde-value-0.7)
                       ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/Arnavion/k8s-openapi")
    (synopsis "Bindings for the Kubernetes client API")
    (description
     "This package provides Bindings for the Kubernetes client API.")
    (license license:asl2.0)))

(define-public rust-compose-spec-macros-0.1
  (package
    (name "rust-compose-spec-macros")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "compose_spec_macros" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0z4r9n38h5346ksfilkaxa76zzivdhvj9axq8yjm6wv9nhl1pf25"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-syn" ,rust-syn-2))))
    (home-page "https://github.com/k9withabone/compose_spec_rs")
    (synopsis "Procedural macros for use in the compose_spec crate")
    (description
     "This package provides Procedural macros for use in the compose_spec crate.")
    (license license:mpl2.0)))

(define-public rust-compose-spec-0.2
  (package
    (name "rust-compose-spec")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "compose_spec" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "17h8g1mrwk8yphqxfhdgyvn5hpagmm5p3p8p6yxh23hl3d6zdshi"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-compose-spec-macros" ,rust-compose-spec-macros-0.1)
                       ("rust-indexmap" ,rust-indexmap-2)
                       ("rust-ipnet" ,rust-ipnet-2)
                       ("rust-itoa" ,rust-itoa-1)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-serde-yaml" ,rust-serde-yaml-0.9)
                       ("rust-thiserror" ,rust-thiserror-1)
                       ("rust-url" ,rust-url-2))))
    (home-page "https://github.com/k9withabone/compose_spec_rs")
    (synopsis "Types for (de)serializing from/to the compose-spec")
    (description
     "This package provides types for (de)serializing from/to compose-spec, a
container description format.")
    (license license:mpl2.0)))

(define-public rust-docmatic-0.1
  (package
    (name "rust-docmatic")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "docmatic" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1hx85n266lxswqxrbbinqlhi1qcnjgd4cc7v42abg72kmz7fnn4d"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-which" ,rust-which-2))))
    (home-page "https://github.com/assert-rs/docmatic")
    (synopsis "Test Rust examples in your documentation")
    (description "Test Rust examples in your documentation.")
    (license license:expat)))

(define-public rust-docopt-1
  (package
    (name "rust-docopt")
    (version "1.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "docopt" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "07x5g52n6fzilxhk5220caznkvdnzzvahlzrzkmgj8y88sc12gvz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-strsim" ,rust-strsim-0.10))))
    (home-page "https://github.com/docopt/docopt.rs")
    (synopsis "Command line argument parsing")
    (description "This package provides command line argument parsing.")
    (license (list license:expat license:unlicense))))

(define-public rust-docopt-0.7
  (package
    (inherit rust-docopt-1)
    (name "rust-docopt")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "docopt" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1n6gbhsks2w9y0b4bwqyawh4ghbkka09w6pjcrq9i1sd51pflcmb"))))
    (arguments
     `(#:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-0.2)
        ("rust-regex" ,rust-regex-0.2)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3)
        ("rust-strsim" ,rust-strsim-0.6))))))

(define-public rust-docopt-0.6
  (package
    (inherit rust-docopt-0.7)
    (name "rust-docopt")
    (version "0.6.86")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "docopt" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1nf4f4zf5yk0d0l4kl7hkii4na22fhn0l2hgfb46yzv08l2g6zja"))))
    (arguments
     `(#:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-0.2)
        ("rust-regex" ,rust-regex-0.1)
        ("rust-rustc-serialize" ,rust-rustc-serialize-0.3)
        ("rust-strsim" ,rust-strsim-0.5))))))

(define-public rust-doctest-file-1
  (package
    (name "rust-doctest-file")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "doctest-file" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0qkmnrsx2kszm58wxyry63bs35msj9chdb6jlh54a8cdwaiizj5a"))))
    (build-system cargo-build-system)
    (arguments `(#:tests? #f))  ; Tests are incorrectly written.
    (home-page "https://codeberg.org/Goat7658/doctest-file/")
    (synopsis "Procedural macro that sources doctests from dedicated files")
    (description
     "This package provides a procedural macro that sources doctests from
dedicated files into Rustdoc documentation with support for hiding lines.")
    (license license:bsd-0)))

(define-public rust-document-features-0.2
  (package
    (name "rust-document-features")
    (version "0.2.10")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "document-features" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32 "182h528pjyv4ppil2pd2nir46qrb393x5kvm4y51yhnjmgm6jsfb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags
       '("--release" "--"
         "--skip=self_doc"
         "--skip=self_doc_with_custom_label")
       #:cargo-inputs (("rust-litrs" ,rust-litrs-0.4))))
    (home-page "https://slint-ui.com")
    (synopsis "Extract documentation for feature flags from Cargo.toml")
    (description "Extract documentation for the feature flags from comments in
@code{Cargo.toml}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-documented-0.6
  (package
    (name "rust-documented")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "documented" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1zc7akchjkwnsl0hnzygwad58sfnvrvkcl7w117679cnbg9zxbgy"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-documented-macros" ,rust-documented-macros-0.6)
                       ("rust-phf" ,rust-phf-0.11)
                       ("rust-thiserror" ,rust-thiserror-1))))
    (home-page "https://github.com/cyqsimon/documented")
    (synopsis
     "Derive and attribute macros for accessing your type's documentation at runtime")
    (description
     "This package provides macros to derive and attribute macros for accessing
your type's documentation at runtime.")
    (license license:expat)))

(define-public rust-documented-macros-0.6
  (package
    (name "rust-documented-macros")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "documented-macros" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0qwclr8ymp5n5fyb6sri9dl36va3ana50clkgwmf7110lva5jdlp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; use of undeclared crate or module `documented`
       #:cargo-inputs (("rust-convert-case" ,rust-convert-case-0.6)
                       ("rust-optfield" ,rust-optfield-0.3)
                       ("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-syn" ,rust-syn-2))))
    (home-page "https://github.com/cyqsimon/documented")
    (synopsis "Derive and attribute macros for `documented`")
    (description
     "This package provides derive and attribute macros for `documented`.")
    (license license:expat)))

(define-public rust-dogged-0.2
  (package
    (name "rust-dogged")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dogged" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0yk5l6qqidl5y935x15gi9kkd6niim1wb64r1l7kdzl9jw8dyf16"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-development-inputs
       (("rust-rand" ,rust-rand-0.3))))
    (home-page "https://github.com/nikomatsakis/dogged")
    (synopsis "Persistent vector, similar to Clojure")
    (description "This package experimental persistent collections in Rust.
Based on a digit-indexed trie, as in Clojure.  Supports @code{push()},
@code{get()}, and @code{get_mut()} as its primitive operations for now.  All
O(1)-in-practice, if not in theory, but obviously not as fast as a
non-persistent vector.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-dot-writer-0.1
  (package
    (name "rust-dot-writer")
    (version "0.1.3")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "dot-writer" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0yjv36hr3klzq4bpzkkqp64s8479ssabr7zkdxn4163ybsyi26rx"))))
    (build-system cargo-build-system)
    (home-page "https://bitbucket.org/DrGabble/dot-writer")
    (synopsis "Library for writing the Graphviz DOT graph language")
    (description
     "This package provides a library for writing the Graphviz DOT graph language.")
    (license license:expat)))

(define-public rust-dotenv-0.15
  (package
    (name "rust-dotenv")
    (version "0.15.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dotenv" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "13ysjx7n2bqxxqydvnnbdwgik7i8n6h5c1qhr9g11x6cxnnhpjbp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-clap" ,rust-clap-2))
       #:cargo-development-inputs
       (("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/dotenv-rs/dotenv")
    (synopsis "@code{dotenv} implementation for Rust")
    (description "This package provides a @code{dotenv} implementation for
Rust.")
    (license license:expat)))

(define-public rust-dotenv-0.13
  (package
    (inherit rust-dotenv-0.15)
    (name "rust-dotenv")
    (version "0.13.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "dotenv" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "11jdifvvwbn60gf5iq2awyq9fik1d9xk7rhch332nwwnkhks3l60"))))
    (arguments
      `(#:skip-build? #t
        #:cargo-inputs
        (("rust-clap" ,rust-clap-2)
         ("rust-failure" ,rust-failure-0.1)
         ("rust-lazy-static" ,rust-lazy-static-1)
         ("rust-regex" ,rust-regex-1))
        #:cargo-development-inputs
        (("rust-tempdir" ,rust-tempdir-0.3))))))

(define-public rust-dotenv-0.10
  (package
    (inherit rust-dotenv-0.15)
    (name "rust-dotenv")
    (version "0.10.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dotenv" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1ww0wfnilz4cy789fni06gckm45xsb9fplrih26l4qyi4jxy5w6n"))))
    (arguments
     `(#:cargo-inputs
       (("rust-derive-error-chain" ,rust-derive-error-chain-0.10)
        ("rust-error-chain" ,rust-error-chain-0.10)
        ("rust-regex" ,rust-regex-0.2)
        ("rust-syn" ,rust-syn-0.11))))))

(define-public rust-dotenvy-0.15
  (package
    (name "rust-dotenvy")
    (version "0.15.7")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "dotenvy" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "16s3n973n5aqym02692i1npb079n5mb0fwql42ikmwn8wnrrbbqs"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags
       ;; Not all files included.
       '("--release" "--"
         "--skip=dotenv"
         "--skip=dotenv_iter"
         "--skip=dotenv_override"
         "--skip=from_filename"
         "--skip=from_filename_override")
       #:cargo-inputs
       (("rust-clap" ,rust-clap-3))
       #:cargo-development-inputs
       (("rust-once-cell" ,rust-once-cell-1)
        ("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/allan2/dotenvy")
    (synopsis "Fork of the dotenv crate")
    (description "This package provides a fork of the dotenv crate.")
    (license license:expat)))

(define-public rust-downcast-0.11
  (package
    (name "rust-downcast")
    (version "0.11.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "downcast" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1wa78ahlc57wmqyq2ncr80l7plrkgz57xsg7kfzgpcnqac8gld8l"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/fkoep/downcast-rs")
    (synopsis
     "Trait for downcasting trait objects back to their original types")
    (description
     "This package provides a trait, and utilities, for downcasting trait
objects back to their original types.  The same as the rust-downcast-rs crate.")
    (license license:expat)))

(define-public rust-downcast-rs-1
  (package
    (name "rust-downcast-rs")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "downcast-rs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1lmrq383d1yszp7mg5i7i56b17x2lnn3kb91jwsq0zykvg2jbcvm"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/marcianx/downcast-rs")
    (synopsis "Trait object downcasting support using only safe Rust")
    (description
     "Trait object downcasting support using only safe Rust.  It supports type
parameters, associated types, and type constraints.")
    (license (list license:expat license:asl2.0))))

(define-public rust-dpc-pariter-0.4
  (package
    (name "rust-dpc-pariter")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dpc-pariter" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0s546d43yyiw55jz3yw4nyxgzmnc4f0gamzkfi6m7kyw2xlf2anl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-crossbeam" ,rust-crossbeam-0.8)
                       ("rust-crossbeam-channel" ,rust-crossbeam-channel-0.5)
                       ("rust-num-cpus" ,rust-num-cpus-1))))
    (home-page "https://github.com/dpc/pariter")
    (synopsis "Parallel iterator processing")
    (description "This is a package for parallel iterator processing.")
    (license (list license:mpl2.0 license:expat license:asl2.0))))

(define-public rust-draw-state-0.8
  (package
    (name "rust-draw-state")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "draw_state" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0lfng4fz9x7bwsmzv9r20ply10w0iid6vfcrhx292s6hw8vrbkrk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1)
        ("rust-bitflags" ,rust-bitflags-1))))
    (home-page "https://github.com/gfx-rs/draw_state")
    (synopsis "Graphics state blocks for gfx-rs")
    (description "Graphics state blocks for gfx-rs.")
    (license license:asl2.0)))

(define-public rust-dtoa-1
  (package
    (name "rust-dtoa")
    (version "1.0.9")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dtoa" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0lv6zzgrd3hfh83n9jqhzz8645729hv1wclag8zw4dbmx3w2pfyw"))))
    (build-system cargo-build-system)
    (arguments
     (list #:cargo-inputs (list rust-no-panic-0.1)))
    (home-page "https://github.com/dtolnay/dtoa")
    (synopsis "Fast functions for printing floating-point primitives")
    (description "This crate provides fast functions for printing
floating-point primitives to an @code{io::Write}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-dtoa-0.4
  (package
    (inherit rust-dtoa-1)
    (name "rust-dtoa")
    (version "0.4.8")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "dtoa" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1c5j0wz118dhrczx6spc5za7dnbfxablr4adyahg9aknrsc9i2an"))))
    (arguments '())))

(define-public rust-dtoa-short-0.3
  (package
    (name "rust-dtoa-short")
    (version "0.3.5")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "dtoa-short" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "11rwnkgql5jilsmwxpx6hjzkgyrbdmx1d71s0jyrjqm5nski25fd"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-dtoa" ,rust-dtoa-1))
       #:cargo-development-inputs (("rust-float-cmp" ,rust-float-cmp-0.4))))
    (home-page "https://github.com/upsuper/dtoa-short")
    (synopsis "Serialize float number and truncate to certain precision")
    (description
     "Serialize float number and truncate to certain precision in Rust.")
    (license license:mpl2.0)))

(define-public rust-dtparse-2
  (package
    (name "rust-dtparse")
    (version "2.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dtparse" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1mqz4164mc4xyq73c22wf900v8cn4sy63nalrkr5mlr614y41yr3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-chrono" ,rust-chrono-0.4)
                       ("rust-lazy-static" ,rust-lazy-static-1)
                       ("rust-num-traits" ,rust-num-traits-0.2)
                       ("rust-rust-decimal" ,rust-rust-decimal-1))
       #:cargo-development-inputs (("rust-base64" ,rust-base64-0.21))))
    (home-page "https://github.com/bspeice/dtparse.git")
    (synopsis "Dateutil-compatible timestamp parser for Rust")
    (description
     "This package provides a @code{dateutil}-compatible timestamp parser for
Rust.")
    (license license:asl2.0)))

(define-public rust-duct-0.13
  (package
    (name "rust-duct")
    (version "0.13.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "duct" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "174jk13rlvfgypha4f3l27mzzyc0ci7zginh5hjn6jr2s4c5gaz4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags
       '("--"
         "--skip=test::test_capture_both"
         "--skip=test::test_pipe"
         "--skip=test::test_sh"
         "--skip=test::test_stderr"
         "--skip=test::test_swapping"
         "--skip=src/lib.rs - ReaderHandle (line 1929)")
       #:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-os-pipe" ,rust-os-pipe-1)
        ("rust-shared-child" ,rust-shared-child-1))
       #:cargo-development-inputs (("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/oconnor663/duct.rs")
    (synopsis "Library for running child processes")
    (description "A library for running child processes.")
    (license license:expat)))

(define-public rust-duplicate-1
  (package
    (name "rust-duplicate")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "duplicate" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1jrh28a3g9xw0w9v21y92d4k08lgr1ffg8mjhw2h67h6r5mfcy6y"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags
       '("--"
         "--skip=errors::basic_expansion_errors"
         "--skip=errors::highlight_expansion_errors"
         "--skip=errors::hint_expansion_errors"
         "--skip=module_disambiguation::test_expansions"
         "--skip=no_features::test_edition_2021"
         "--skip=no_features::test_expansions")
       #:cargo-inputs (("rust-heck" ,rust-heck-0.4)
                       ("rust-proc-macro-error" ,rust-proc-macro-error-1))
       #:cargo-development-inputs
       (("rust-doc-comment" ,rust-doc-comment-0.3)
        ("rust-duplicate-macrotest" ,rust-duplicate-macrotest-1)
        ("rust-regex" ,rust-regex-1)
        ("rust-rustversion" ,rust-rustversion-1)
        ("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/Emoun/duplicate")
    (synopsis
     "Provides macros for duplication of code with variable substitution")
    (description
     "This package provides macros for duplication of code with variable
substitution.")
    (license (list license:expat license:asl2.0))))

(define-public rust-duplicate-macrotest-1
  (package
    (name "rust-duplicate-macrotest")
    (version "1.0.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "duplicate_macrotest" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "15p4d596vknjx5vba86pa08aci7grl7nsxqp92gqxfj5mh5nwz9a"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-diff" ,rust-diff-0.1)
                       ("rust-glob" ,rust-glob-0.3)
                       ("rust-rand" ,rust-rand-0.8)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-serde-json" ,rust-serde-json-1)
                       ("rust-toml" ,rust-toml-0.8))))
    (home-page "https://github.com/emoun/duplicate_macrotest")
    (synopsis
     "Fork of the macrotest crate specifically to test the duplicate crate")
    (description
     "This package provides a fork of the macrotest crate specifically to test
the duplicate crate.")
    (license (list license:expat license:asl2.0))))

(define-public rust-dwrote-0.11
  (package
    (name "rust-dwrote")
    (version "0.11.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dwrote" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1z85pyzac4zpap94czx7nkn1hys64n95ddlnpar34djsa84jf63h"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-winapi" ,rust-winapi-0.3)
        ("rust-wio" ,rust-wio-0.2))))
    (home-page "https://github.com/servo/dwrote-rs")
    (synopsis "Lightweight binding to DirectWrite")
    (description
     "This package provides lightweight binding to DirectWrite.")
    (license license:mpl2.0)))

(define-public rust-dyn-clone-1
  (package
    (name "rust-dyn-clone")
    (version "1.0.17")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "dyn-clone" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "09cig7dgg6jnqa10p4233nd8wllbjf4ffsw7wj0m4lwa5w3z0vhd"))))
    (arguments
     `(#:cargo-development-inputs (("rust-rustversion" ,rust-rustversion-1)
                                   ("rust-trybuild" ,rust-trybuild-1))))
    (build-system cargo-build-system)
    (home-page "https://crates.io/crates/dyn-clone")
    (synopsis "Clone trait that is object-safe")
    (description "This package provides a clone trait that is object-safe.")
    (license (list license:expat license:asl2.0))))

(define-public rust-easy-cast-0.5
  (package
    (name "rust-easy-cast")
    (version "0.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "easy-cast" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1mjhjxibj228bzs817rwaqdicxmln6dqqffabrjn5j1fd4v2g1bj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-libm" ,rust-libm-0.2))))
    (home-page "https://github.com/kas-gui/easy-cast")
    (synopsis "Type conversions which are expected to succeed")
    (description "This library is written to make numeric type conversions
easy.")
    (license license:asl2.0)))

(define-public rust-easy-cast-0.4
  (package
    (inherit rust-easy-cast-0.5)
    (name "rust-easy-cast")
    (version "0.4.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "easy-cast" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "13ilmaplp2s4vw1vjh4pwbzk7jdxrn0kpf0rk5sli0s1ikp05lab"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-libm" ,rust-libm-0.2))))))

(define-public rust-easy-parallel-3
  (package
    (name "rust-easy-parallel")
    (version "3.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "easy-parallel" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0g12xq122hy170pprldvgmpml0zz1mn9n4hq5c6ly3pnmsqbkyra"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/stjepang/easy-parallel")
    (synopsis "Run closures in parallel")
    (description
     "This crate provides a simple primitive for spawning threads in bulk and
waiting for them to complete.  Threads are allowed to borrow local variables
from the main thread.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-ecb-0.1
  (package
    (name "rust-ecb")
    (version "0.1.2")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "ecb" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1iw1i0mwkvg3599mlw24iibid6i6zv3a3jhghm2j3v0sbfbzm2qs"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cipher" ,rust-cipher-0.4))
       #:cargo-development-inputs
       (("rust-aes" ,rust-aes-0.8)
        ("rust-cipher" ,rust-cipher-0.4)
        ("rust-hex-literal" ,rust-hex-literal-0.3))))
    (home-page "https://github.com/magic-akari/ecb")
    (synopsis "Electronic Codebook (ECB) block cipher mode of operation")
    (description "Electronic Codebook (ECB) block cipher mode of operation")
    (license license:expat)))

(define-public rust-edit-0.1
  (package
    (name "rust-edit")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "edit" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "02dan6bg9pcj42ny48g8fq9f76w30c826n4gihy1d1s7fq78cr7k"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-shell-words" ,rust-shell-words-1)
                       ("rust-tempfile" ,rust-tempfile-3)
                       ("rust-which" ,rust-which-4))))
    (home-page "https://github.com/milkey-mouse/edit")
    (synopsis "Open a file in the default text editor")
    (description
     "This package provides functions to open a file in the default text editor.")
    (license license:cc0)))

(define-public rust-edit-distance-2
  (package
    (name "rust-edit-distance")
    (version "2.1.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "edit-distance" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "15vkx4haqr6ldgpmamb38h30v57clpx6klfzanhhk303ggl9gx73"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs (("rust-quickcheck" ,rust-quickcheck-1))))
    (home-page "https://github.com/febeling/edit-distance")
    (synopsis "Levenshtein edit distance between strings")
    (description
     "Levenshtein edit distance between strings, a measure for similarity.")
    (license license:asl2.0)))

(define-public rust-editdistancek-1
  (package
    (name "rust-editdistancek")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "editdistancek" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "04r6lfq9sfz3wqhqm6fzfcqbj8w16y8bh0x6kzkgkimislixy0iy"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs (("rust-criterion" ,rust-criterion-0.5)
                                   ("rust-levenshtein" ,rust-levenshtein-1)
                                   ("rust-quickcheck" ,rust-quickcheck-1)
                                   ("rust-rand" ,rust-rand-0.8)
                                   ("rust-triple-accel" ,rust-triple-accel-0.4))))
    (home-page "https://github.com/nkkarpov/editdistancek")
    (synopsis "Fast algorithm for computing edit distance")
    (description
     "This crate provides fast algorithm for computing edit distance.")
    (license license:expat)))

(define-public rust-ego-tree-0.6
  (package
    (name "rust-ego-tree")
    (version "0.6.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ego-tree" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0hincmpradjn146d4as5yj9c8k5l97wvxfyhf3qzra84mhabp80j"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/programble/ego-tree")
    (synopsis "Vec-backed ID-tree")
    (description "Ego Tree provides a vec-backed ID-tree.")
    (license license:isc)))

(define-public rust-either-1
  (package
    (name "rust-either")
    (version "1.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "either" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1w2c1mybrd7vljyxk77y9f4w9dyjrmp3yp82mk7bcm8848fazcb0"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs (("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/rayon-rs/either")
    (synopsis
     "Enum @code{Either} with variants @code{Left} and @code{Right}")
    (description
     "The enum @code{Either} with variants @code{Left} and
@code{Right} is a general purpose sum type with two cases.")
    (license (list license:expat license:asl2.0))))

(define-public rust-elain-0.3
  (package
    (name "rust-elain")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "elain" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0ym7gc1wbr1ynvjhcxifjadk51bbmg5qdsf2q7r0bvvyapgrp8vb"))))
    (build-system cargo-build-system)
    (home-page "https://docs.rs/elain/latest/elain/")
    (synopsis "Set a type's minimum alignment with const generics")
    (description "Set a type's minimum alignment with const generics.")
    (license (list license:expat license:asl2.0))))

(define-public rust-elf-0.0.10
  (package
    (name "rust-elf")
    (version "0.0.10")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "elf" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1xcpf7jdmrl7rdmd6009grahvgp3k695h5x4cadrpr70vcaxwha8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-byteorder" ,rust-byteorder-0.5))))
    (home-page "https://github.com/cole14/rust-elf/")
    (synopsis "Library for parsing ELF files")
    (description
     "This package provides a pure-Rust library for parsing ELF files.")
    (license (list license:expat license:asl2.0))))

(define-public rust-emacs-0.19
  (package
    (name "rust-emacs")
    (version "0.19.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "emacs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "133ip19m1nq8krf04klh1jpm833wpw6kdy2jksgylbw4xcp3yxws"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-anyhow" ,rust-anyhow-1)
        ("rust-ctor" ,rust-ctor-0.1)
        ("rust-emacs-macros" ,rust-emacs-macros-0.17)
        ("rust-emacs-module" ,rust-emacs-module-0.18)
        ("rust-failure-derive" ,rust-failure-derive-0.1)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-thiserror" ,rust-thiserror-1))))
    (inputs
     (list clang))
    (home-page "https://github.com/ubolonton/emacs-module-rs")
    (synopsis "Library for creating Emacs's dynamic modules")
    (description
     "This crate provides a Rust library for creating Emacs' dynamic modules.")
    (license license:bsd-3)))

(define-public rust-emacs-0.18
  (package
    (inherit rust-emacs-0.19)
    (name "rust-emacs")
    (version "0.18.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "emacs" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32 "0r860i73b2680i2fhdl2l1wwvvmf2zksncpckgkksdcx310ak5v7"))))
    (arguments
     `(#:cargo-inputs
       (("rust-anyhow" ,rust-anyhow-1)
        ("rust-ctor" ,rust-ctor-0.1)
        ("rust-emacs-macros" ,rust-emacs-macros-0.17)
        ("rust-emacs-module" ,rust-emacs-module-0.18)
        ("rust-failure" ,rust-failure-0.1)
        ("rust-failure-derive" ,rust-failure-derive-0.1)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-thiserror" ,rust-thiserror-1))))))

(define-public rust-emacs-0.11
  (package (inherit rust-emacs-0.18)
    (name "rust-emacs")
    (version "0.11.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "emacs" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1xn6nr8m3p24irlmv3i7c9n95yb10qc6aikwqv99qlmhbky5x0z7"))))
    (arguments
     `(#:cargo-inputs
       (("rust-ctor" ,rust-ctor-0.1)
        ("rust-emacs-macros" ,rust-emacs-macros-0.11)
        ("rust-emacs-module" ,rust-emacs-module-0.10)
        ("rust-failure" ,rust-failure-0.1)
        ("rust-failure-derive" ,rust-failure-derive-0.1)
        ("rust-lazy-static" ,rust-lazy-static-1))))))

(define-public rust-emacs-macros-0.17
  (package
    (name "rust-emacs-macros")
    (version "0.17.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "emacs-macros" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0qg1dcn5acbirq617qq2fgg9adswif2dnr292s3qnq62wzgnyrb9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-darling" ,rust-darling-0.10)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/ubolonton/emacs-module-rs")
    (synopsis "Proc macros for Emacs modules")
    (description "This package provides proc macros for Emacs modules.")
    (license license:bsd-3)))

(define-public rust-emacs-macros-0.11
  (package (inherit rust-emacs-macros-0.17)
    (name "rust-emacs-macros")
    (version "0.11.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "emacs-macros" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0390y8vafxdi334hhgrzvcqjq3n5ckcmvilqcfp8vajjq8irrly6"))))
    (arguments
     `(#:cargo-inputs
       (("rust-darling" ,rust-darling-0.9)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-syn" ,rust-syn-0.15))))))

(define-public rust-emacs-module-0.18
  (package
    (name "rust-emacs-module")
    (version "0.18.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "emacs_module" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1ypjyyv2ca3vza4sia91ckxamgfk63yd8frkvg3d4ph4fk4pn1mk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bindgen" ,rust-bindgen-0.59))))
    (inputs
     (list clang))
    (home-page "https://github.com/ubolonton/emacs-module-rs")
    (synopsis "Raw FFI for emacs-module")
    (description "This module provides a high-level binding to emacs-module:
Emacs' support for dynamic modules.")
    (license license:bsd-3)))

(define-public rust-emacs-module-0.10
  (package
    (inherit rust-emacs-module-0.18)
    (name "rust-emacs-module")
    (version "0.10.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "emacs_module" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1gf9lz735xbkyir53dyv362drfx3nin5an5cx39kd8q8kjjwix5g"))
        (modules '((guix build utils)))
        (snippet
         ;; Force a newer version of bindgen.
         '(begin (substitute* "Cargo.toml"
                   (("0\\.48\\.1") "0.59"))))))
    (arguments
     `(#:cargo-inputs
       (("rust-bindgen" ,rust-bindgen-0.59))))))

(define-public rust-emacs-org-link-parser-0.1
  (package
    (name "rust-emacs-org-link-parser")
    (version "0.1.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "emacs-org-link-parser" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0vvkl6wbgr1pc6abii2yra0saw0cca1wqm5sxflcmz1w47wrj7gx"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags       ; Skip the doctests.
       '("--release" "--lib" "--bins" "--tests")))
    (home-page "https://github.com/lily-mosquitoes/emacs-org-link-parser")
    (synopsis "Library for parsing Emacs Org-mode hyperlinks from a string")
    (description "Library for parsing Emacs Org-mode hyperlinks from a string.")
    (license license:gpl3+)))

(define-public rust-email-0.0.20
  (package
    (name "rust-email")
    (version "0.0.20")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "email" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1r12byj69x6bkq0qn1zvi103n1pg5k3w8zym2dgich82pd8rlm4i"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-base64" ,rust-base64-0.9)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-encoding" ,rust-encoding-0.2)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-rand" ,rust-rand-0.4)
        ("rust-time" ,rust-time-0.1)
        ("rust-version-check" ,rust-version-check-0.1))))
    (home-page "https://github.com/niax/rust-email")
    (synopsis "Implementation of RFC 5322 email messages")
    (description
     "This crate provides an implementation of RFC 5322 email messages.")
    (license license:expat)))

(define-public rust-embedded-io-0.6
  (package
    (name "rust-embedded-io")
    (version "0.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "embedded-io" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0v901xykajh3zffn6x4cnn4fhgfw3c8qpjwbsk6gai3gaccg3l7d"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-defmt" ,rust-defmt-0.3))))
    (home-page "https://github.com/rust-embedded/embedded-hal")
    (synopsis "Embedded IO traits")
    (description "This package provides embedded IO traits.")
    (license (list license:expat license:asl2.0))))

(define-public rust-embedded-io-0.4
  (package
    (inherit rust-embedded-io-0.6)
    (name "rust-embedded-io")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "embedded-io" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1v9wrc5nsgaaady7i3ya394sik5251j0iq5rls7mrx7fv696h6pg"))))
    (arguments
     `(#:cargo-inputs (("rust-defmt" ,rust-defmt-0.3)
                       ("rust-futures" ,rust-futures-0.3)
                       ("rust-log" ,rust-log-0.4)
                       ("rust-tokio" ,rust-tokio-1))))))

(define-public rust-eml-parser-0.1
  (package
    (name "rust-eml-parser")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "eml-parser" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0bhgx1i952g2v7w0icnqkylvhfiyb2am2mbw89v8zq0jz0aqvnx7"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags '("--"
                            "--skip=parser::tests::test_parse_phishing_emails"
                            "--skip=parser::tests::test_parse_rfc2047")
       #:cargo-inputs (("rust-regex" ,rust-regex-1)
                       ("rust-rfc2047-decoder" ,rust-rfc2047-decoder-1))))
    (home-page "https://github.com/aeshirey/EmlParser/")
    (synopsis "Library for parsing .eml files.")
    (description "This package provides a library for parsing .eml files.")
    (license license:asl2.0)))

(define-public rust-emojis-0.6
  (package
    (name "rust-emojis")
    (version "0.6.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "emojis" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1x02bixi1f8kjk8g5qsrwpwznpya65yh5gy8p8wja7qq3zgz3qcr"))))
    (build-system cargo-build-system)
    (arguments
     (list #:cargo-inputs
           (list rust-phf-0.11
                 rust-serde-1)
           #:cargo-development-inputs
           (list rust-serde-json-1
                 rust-toml-0.5)))
    (home-page "https://github.com/rossmacarthur/emojis")
    (synopsis "Lookup emoji in O(1) time")
    (description
     "Lookup emoji in O(1) time, access metadata and @code{GitHub} shortcodes,
iterate over all emoji, and more.")
    (license (list license:expat license:asl2.0))))

(define-public rust-emojis-0.5
  (package
    (inherit rust-emojis-0.6)
    (name "rust-emojis")
    (version "0.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "emojis" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0pdrhzlx53ksb41dx3qjl6qg9nj711vj28r8d92pv0lij5sbq1rl"))))
    (arguments
     `(#:cargo-inputs (("rust-phf" ,rust-phf-0.11))))))

(define-public rust-empfindung-0.2
  (package
    (name "rust-empfindung")
    (version "0.2.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "empfindung" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1pxh4r196qfv1y1qlp9fn210sj75whaqa61fdasjd9ml6bn9bw4a"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-lab" ,rust-lab-0.11)
        ("rust-rgb" ,rust-rgb-0.8))
       #:cargo-development-inputs
       (("rust-approx" ,rust-approx-0.5)
        ("rust-criterion" ,rust-criterion-0.3)
        ("rust-lab" ,rust-lab-0.11)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-rand-xoshiro" ,rust-rand-xoshiro-0.6)
        ("rust-rgb" ,rust-rgb-0.8))))
    (home-page "https://github.com/mina86/empfindung")
    (synopsis "Rust implementation of the CIEDE2000 colour difference")
    (description
     "Empfindung is a pure-Rust implementation of the CIEDE2000 colour
difference.")
    (license license:expat)))

(define-public rust-ena-0.14
  (package
    (name "rust-ena")
    (version "0.14.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ena" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1m9a5hqk6qn5sqnrc40b55yr97drkfdzd0jj863ksqff8gfqn91x"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-dogged" ,rust-dogged-0.2)
        ("rust-log" ,rust-log-0.4))))
    (home-page "https://github.com/rust-lang/ena")
    (synopsis "Union-find, congruence closure, and other unification code")
    (description "This package provides an implementation of union-find /
congruence-closure in Rust.  It was extracted from rustc for independent
experimentation.")
    (license (list license:expat license:asl2.0))))

(define-public rust-ena-0.13
  (package
    (inherit rust-ena-0.14)
    (name "rust-ena")
    (version "0.13.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ena" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0dkggq0qwv140y2kjfd4spp77zi3v7vnpm4bfy7s7r4cla7xqi49"))))))

(define-public rust-encode-unicode-0.3
  (package
    (name "rust-encode-unicode")
    (version "0.3.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "encode_unicode" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "07w3vzrhxh9lpjgsg2y5bwzfar2aq35mdznvcp3zjl0ssj7d4mx3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-ascii" ,rust-ascii-1)
        ("rust-clippy" ,rust-clippy-0.0.302))
       #:cargo-development-inputs
       (("rust-lazy-static" ,rust-lazy-static-1))))
    (home-page "https://github.com/tormol/encode_unicode")
    (synopsis
     "UTF-8 and UTF-16 support for char, u8 and u16")
    (description
     "UTF-8 and UTF-16 character types, iterators and related methods for
char, u8 and u16.")
    (license (list license:expat license:asl2.0))))

(define-public rust-encoding-0.2
  (package
    (name "rust-encoding")
    (version "0.2.33")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "encoding" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1v1ndmkarh9z3n5hk53da4z56hgk9wa5kcsm7cnx345raqw983bb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-encoding-index-japanese"
         ,rust-encoding-index-japanese-1.20141219)
        ("rust-encoding-index-korean"
         ,rust-encoding-index-korean-1.20141219)
        ("rust-encoding-index-simpchinese"
         ,rust-encoding-index-simpchinese-1.20141219)
        ("rust-encoding-index-singlebyte"
         ,rust-encoding-index-singlebyte-1.20141219)
        ("rust-encoding-index-tradchinese"
         ,rust-encoding-index-tradchinese-1.20141219))
       #:cargo-development-inputs
       (("rust-getopts" ,rust-getopts-0.2))))
    (home-page
     "https://github.com/lifthrasiir/rust-encoding")
    (synopsis "Character encoding support for Rust")
    (description
     "Character encoding support for Rust.")
    (license license:expat)))

(define-public rust-encoding-index-japanese-1.20141219
  (package
    (name "rust-encoding-index-japanese")
    (version "1.20141219.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "encoding-index-japanese" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "148c1lmd640p1d7fzk0nv7892mbyavvwddgqvcsm78798bzv5s04"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-encoding-index-tests" ,rust-encoding-index-tests-0.1))))
    (home-page "https://github.com/lifthrasiir/rust-encoding")
    (synopsis "Index tables for Japanese character encodings")
    (description
     "Index tables for Japanese character encodings.")
    (license license:cc0)))

(define-public rust-encoding-index-korean-1.20141219
  (package
    (name "rust-encoding-index-korean")
    (version "1.20141219.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "encoding-index-korean" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "10cxabp5ppygbq4y6y680856zl9zjvq7ahpiw8zj3fmwwsw3zhsd"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-encoding-index-tests" ,rust-encoding-index-tests-0.1))))
    (home-page "https://github.com/lifthrasiir/rust-encoding")
    (synopsis "Index tables for Korean character encodings")
    (description
     "Index tables for Korean character encodings.")
    (license license:cc0)))

(define-public rust-encoding-index-simpchinese-1.20141219
  (package
    (name "rust-encoding-index-simpchinese")
    (version "1.20141219.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "encoding-index-simpchinese" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1xria2i7mc5dqdrpqxasdbxv1qx46jjbm53if3y1i4cvj2a72ynq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-encoding-index-tests" ,rust-encoding-index-tests-0.1))))
    (home-page "https://github.com/lifthrasiir/rust-encoding")
    (synopsis "Index tables for simplified Chinese character encodings")
    (description
     "Index tables for simplified Chinese character encodings.")
    (license license:cc0)))

(define-public rust-encoding-index-singlebyte-1.20141219
  (package
    (name "rust-encoding-index-singlebyte")
    (version "1.20141219.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "encoding-index-singlebyte" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0jp85bz2pprzvg9m95w4q0vibh67b6w3bx35lafay95jzyndal9k"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-encoding-index-tests" ,rust-encoding-index-tests-0.1))))
    (home-page "https://github.com/lifthrasiir/rust-encoding")
    (synopsis "Index tables for various single-byte character encodings")
    (description
     "Index tables for various single-byte character encodings.")
    (license license:cc0)))

(define-public rust-encoding-index-tests-0.1
  (package
    (name "rust-encoding-index-tests")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "encoding_index_tests" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0s85y091gl17ixass49bzaivng7w8p82p6nyvz2r3my9w4mxhim2"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/lifthrasiir/rust-encoding")
    (synopsis
     "Macros used to test index tables for character encodings")
    (description
     "Helper macros used to test index tables for character
encodings.")
    (license license:cc0)))

(define-public rust-encoding-index-tradchinese-1.20141219
  (package
    (name "rust-encoding-index-tradchinese")
    (version "1.20141219.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "encoding-index-tradchinese" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "060ci4iz6xfvzk38syfbjvs7pix5hch3mvxkksswmqwcd3aj03px"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-encoding-index-tests" ,rust-encoding-index-tests-0.1))))
    (home-page "https://github.com/lifthrasiir/rust-encoding")
    (synopsis "Index tables for traditional Chinese character encodings")
    (description
     "Index tables for traditional Chinese character encodings.")
    (license license:cc0)))

(define-public rust-encoding-rs-0.8
  (package
    (name "rust-encoding-rs")
    (version "0.8.35")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "encoding_rs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1wv64xdrr9v37rqqdjsyb8l8wzlcbab80ryxhrszvnj59wy0y0vm"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-any-all-workaround" ,rust-any-all-workaround-0.1)
        ("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-bincode" ,rust-bincode-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://docs.rs/encoding_rs/")
    (synopsis "Gecko-oriented implementation of the Encoding Standard")
    (description
     "This package provides a Gecko-oriented implementation of the Encoding
Standard.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-encoding-rs-io-0.1
  (package
    (name "rust-encoding-rs-io")
    (version "0.1.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "encoding_rs_io" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "10ra4l688cdadd8h1lsbahld1zbywnnqv68366mbhamn3xjwbhqw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-encoding-rs" ,rust-encoding-rs-0.8))))
    (home-page "https://github.com/BurntSushi/encoding_rs_io")
    (synopsis "Streaming transcoding for encoding_rs")
    (description
     "Streaming transcoding for encoding_rs.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-endi-1
  (package
    (name "rust-endi")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "endi" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1gxp388g2zzbncp3rdn60wxkr49xbhhx94nl9p4a6c41w4ma7n53"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/zeenix/endi")
    (synopsis "Simple endian-handling library")
    (description "This package provides a simple endian-handling library.")
    (license license:expat)))

(define-public rust-endian-type-0.1
  (package
    (name "rust-endian-type")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "endian-type" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0bbh88zaig1jfqrm7w3gx0pz81kw2jakk3055vbgapw3dmk08ky3"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/Lolirofle/endian-type")
    (synopsis "Type safe wrappers for types with a defined byte order")
    (description
     "This crates provides type safe wrappers for types with a defined byte
order.")
    (license license:expat)))

(define-public rust-enquote-1
  (package
    (name "rust-enquote")
    (version "1.1.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "enquote" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0clrjghlfkkb7sndabs5wch0fz2nif6nj4b117s8kqxx3nqnrhq6"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-thiserror" ,rust-thiserror-1))))
    (home-page "https://github.com/reujab/enquote")
    (synopsis "Rust library that quotes, unquotes, and unescapes strings")
    (description "This package provides a Rust library quotes, unquotes, and
unescapes strings.")
    (license license:unlicense)))

(define-public rust-entities-1
  (package
    (name "rust-entities")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "entities" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1jnpr0zvj97wm9pnh7fnl74rzaar39hhg65p03cm08bqqgj0lcmm"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/p-jackson/entities")
    (synopsis "Raw data needed to convert to and from HTML entities")
    (description "This package provides the raw data needed to convert to and
from HTML entities.")
    (license license:expat)))

(define-public rust-enum-as-inner-0.6
  (package
    (name "rust-enum-as-inner")
    (version "0.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "enum-as-inner" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1g3cywc65d9w974l2xy86ij13njss3qjc7b0kfbzbws9qrjs5rm1"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-heck" ,rust-heck-0.5)
                       ("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-syn" ,rust-syn-2))))
    (home-page "https://github.com/bluejekyll/enum-as-inner")
    (synopsis "Proc-macro for deriving inner field accessor functions on enums")
    (description "This package provides a proc-macro for deriving inner field
accessor functions on enums.")
    (license (list license:expat license:asl2.0))))

(define-public rust-enum-as-inner-0.5
  (package
    (inherit rust-enum-as-inner-0.6)
    (name "rust-enum-as-inner")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "enum-as-inner" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "05m1frlkgrikja714zxb97i00rhj36zlifiwiby7ymkx0jx0nwn9"))))
    (arguments
     `(#:cargo-inputs
       (("rust-heck" ,rust-heck-0.4)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))))

(define-public rust-enum-as-inner-0.3
  (package
    (inherit rust-enum-as-inner-0.5)
    (name "rust-enum-as-inner")
    (version "0.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "enum-as-inner" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1m2l8zh0yd7i95qkyha86ca8m0bnhfimv38dr3n4p41yh6di03ap"))))
    (arguments
     `(#:cargo-inputs
       (("rust-heck" ,rust-heck-0.4)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))))

(define-public rust-enum-as-inner-0.2
  (package
    (inherit rust-enum-as-inner-0.3)
    (name "rust-enum-as-inner")
    (version "0.2.1")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "enum-as-inner" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0zg3h7k3g1z7a9ayqy63sk302d4dg5g2h274ddv80mj4jxn2cn1x"))))
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-0.4)
        ("rust-quote" ,rust-quote-0.6)
        ("rust-syn" ,rust-syn-0.15))))))

(define-public rust-enum-derive-0.1
  (package
    (name "rust-enum-derive")
    (version "0.1.7")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "enum_derive" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "05n8mdca3y2c8pvl1isncj52fa80wplvx28lxvwqmpzfr6lc4sj0"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs
       (("rust-custom-derive" ,rust-custom-derive-0.1))))
    (home-page "https://github.com/DanielKeep/rust-custom-derive")
    (synopsis "Macros for deriving additional functionality for enums")
    (description
     "This crate provides macros for deriving additional functionality for enums.")
    (license (list license:expat license:asl2.0))))

(define-public rust-enum-dispatch-0.3
  (package
    (name "rust-enum-dispatch")
    (version "0.3.13")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "enum_dispatch" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1kby2jz173ggg7wk41vjsskmkdyx7749ll8lhqhv6mb5qqmww65a"))
              (modules '((guix build utils)))
              (snippet
               '(begin (substitute* "Cargo.toml"
                         (("\"= ?([[:digit:]]+(\\.[[:digit:]]+)*)" _ version)
                          (string-append "\"^" version)))))))
    (build-system cargo-build-system)
    (arguments
     (list
       #:tests? #f  ; `#![feature]` may not be used on the stable release channel
       #:cargo-inputs
       `(("rust-once-cell" ,rust-once-cell-1)
         ("rust-proc-macro2" ,rust-proc-macro2-1)
         ("rust-quote" ,rust-quote-1)
         ("rust-syn" ,rust-syn-2))
       #:cargo-development-inputs
       `(("rust-custom-derive" ,rust-custom-derive-0.1)
         ("rust-enum-derive" ,rust-enum-derive-0.1)
         ("rust-rand" ,rust-rand-0.5)
         ("rust-serde" ,rust-serde-1)
         ("rust-serde-json" ,rust-serde-json-1)
         ("rust-smol" ,rust-smol-1))))
    (home-page "https://gitlab.com/antonok/enum_dispatch")
    (synopsis "Faster alternative to dynamically dispatched method calls")
    (description
     "This crate transforms your trait objects into concrete compound types,
increasing their method call speed up to 10x.")
    (license (list license:expat license:asl2.0))))

(define-public rust-enum-map-0.6
  (package
    (name "rust-enum-map")
    (version "0.6.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "enum-map" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "166yh44izfz871f4avl10cp0l161shhsawfcl1q6slv3siamqn93"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-array-macro" ,rust-array-macro-1)
        ("rust-enum-map-derive" ,rust-enum-map-derive-0.4)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-bincode" ,rust-bincode-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-test" ,rust-serde-test-1))))
    (home-page "https://gitlab.com/KonradBorowski/enum-map")
    (synopsis "Map with C-like enum keys represented internally as an array")
    (description
     "This package provides a map with C-like enum keys represented internally
as an array.")
    (license (list license:expat license:asl2.0))))

(define-public rust-enum-map-derive-0.4
  (package
    (name "rust-enum-map-derive")
    (version "0.4.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "enum-map-derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0mg43p1x90cz604zddk9qzss077v2id04qmmbpa1i7jc637m1i75"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://gitlab.com/KonradBorowski/enum-map")
    (synopsis "Macros 1.1 implementation of #[derive(Enum)]")
    (description "This package provides a macros 1.1 implementation of
@code{#[derive(Enum)]}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-enum-primitive-0.1
  (package
    (name "rust-enum-primitive")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "enum_primitive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "100ip2p3w1rq0clca2ai5shhvpxfipnsjncj0f9ralad5w4m2idy"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-num-traits" ,rust-num-traits-0.1))))
    (home-page "https://github.com/andersk/enum_primitive-rs")
    (synopsis "Macro to generate @code{num::FromPrimitive} instances for enum")
    (description
     "This package provides a macro to generate @code{num::FromPrimitive}
instances for enum.")
    (license license:expat)))

(define-public rust-enum-primitive-derive-0.2
  (package
    (name "rust-enum-primitive-derive")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "enum-primitive-derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "03ibjjx8dc4akpq8ck24qda5ix4jybz9jagfxykd0s6vxb2vjxf3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://gitlab.com/cardoe/enum-primitive-derive")
    (synopsis "Reimplementation of enum_primitive using a #[derive] macro")
    (description
     "This package provides a custom derive using procedural macros to
implement enum_primitive.")
    (license license:expat)))

(define-public rust-enumber-0.3
  (package
    (name "rust-enumber")
    (version "0.3.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "enumber" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1gxxqms1zpadyy1whq0ms1vwymz19mq197gfq53dhxnx14cig50f"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-2))))
    (home-page "https://github.com/kinnison/enumber/")
    (synopsis "Provide useful impls on numerical enums")
    (description "This package provides useful impls on numerical enums.")
    (license license:bsd-3)))

(define-public rust-enumflags2-0.7
  (package
    (name "rust-enumflags2")
    (version "0.7.10")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "enumflags2" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0g8kmhaqxq44v76wh971biljrgaqbjc8fbyw2d1z3wsnb5zxncnj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-enumflags2-derive" ,rust-enumflags2-derive-0.7)
        ("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/meithecatte/enumflags2")
    (synopsis "Enum-based bit flags")
    (description "This package provides enum-based bit flags.")
    (license (list license:expat license:asl2.0))))

(define-public rust-enumflags2-0.6
  (package
    (inherit rust-enumflags2-0.7)
    (name "rust-enumflags2")
    (version "0.6.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "enumflags2" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "182xd6cxxmadx1axnz6x73d12pzgwkc712zq2lxd4z1k48lxij43"))))
    (arguments
     `(#:cargo-inputs
       (("rust-enumflags2-derive" ,rust-enumflags2-derive-0.6)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.3))))))

(define-public rust-enumflags2-derive-0.7
  (package
    (name "rust-enumflags2-derive")
    (version "0.7.10")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "enumflags2_derive" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1s29iqx3gj5l5s19a22lpn0nljhp5l9smqac99126n2qhfhlh3fy"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-2))))
    (home-page "https://github.com/meithecatte/enumflags2")
    (synopsis "Internal crate for enumflags2")
    (description
     "This package provides internal implementations for enumflags2.")
    (license (list license:expat license:asl2.0))))

(define-public rust-enumflags2-derive-0.6
  (package
    (inherit rust-enumflags2-derive-0.7)
    (name "rust-enumflags2-derive")
    (version "0.6.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "enumflags2_derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1kkcwi4n76bi1c16ms00dyk4d393gdf29kpr4k9zsn5z7m7fjvll"))))
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))))

(define-public rust-enum-ordinalize-4
  (package
    (name "rust-enum-ordinalize")
    (version "4.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "enum-ordinalize" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1max64z9giii61qcwl56rndd7pakaylkaij5zqbbbvjl9vxdr87y"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-enum-ordinalize-derive" ,rust-enum-ordinalize-derive-4))))
    (home-page "https://magiclen.org/enum-ordinalize")
    (synopsis "Construction of enums from an ordinal value")
    (description
     "This library enables enums to not only obtain the ordinal values of their
variants but also allows for the construction of enums from an ordinal value.")
    (license license:expat)))

(define-public rust-enum-ordinalize-derive-4
  (package
    (name "rust-enum-ordinalize-derive")
    (version "4.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "enum-ordinalize-derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1zy53fabazimwv5cl0366k834ybixzl84lxj9mfavbnlfn532a0d"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-syn" ,rust-syn-2))))
    (home-page "https://magiclen.org/enum-ordinalize")
    (synopsis "Macro that enables construction of enums from an ordinal value")
    (description
     "This crate provides a procedural macro that enables enums to not only
obtain the ordinal values of their variants but also allows for the
construction of enums from an ordinal value.")
    (license license:expat)))

(define-public rust-enumset-1
  (package
    (name "rust-enumset")
    (version "1.1.5")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "enumset" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
          (base32 "14vjn774rvvs2ac2ykdld3bq8w657wy2f6hcbzpmqxjqjl24nynh"))))
    (build-system cargo-build-system)
    (arguments
      `(#:cargo-inputs
        (("rust-enumset-derive" ,rust-enumset-derive-0.10)
         ("rust-serde" ,rust-serde-1))
        #:cargo-development-inputs
        (("rust-bincode" ,rust-bincode-1)
         ("rust-serde-derive" ,rust-serde-derive-1)
         ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/Lymia/enumset")
    (synopsis "Library for creating compact sets of enums")
    (description "This package provides a Rust library for creating
compact sets of enums.")
    (license (list license:expat license:asl2.0))))

(define-public rust-enumset-derive-0.10
  (package
    (name "rust-enumset-derive")
    (version "0.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "enumset_derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0hp25sx7p60ms4xkdkz7x36byd96dhpq7hdxcr4k332x6i6b5hsr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-darling" ,rust-darling-0.20)
                       ("rust-proc-macro-crate" ,rust-proc-macro-crate-3)
                       ("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-syn" ,rust-syn-2))))
    (home-page "https://github.com/Lymia/enumset")
    (synopsis "Internal helper crate for enumset")
    (description
     "This package provides an internal helper crate for @code{rust-enumset}.
It is not a public API.")
    (license (list license:expat license:asl2.0))))

(define-public rust-env-filter-0.1
  (package
    (name "rust-env-filter")
    (version "0.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "env_filter" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1l4p6f845cylripc3zkxa0lklk8rn2q86fqm522p6l2cknjhavhq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-log" ,rust-log-0.4)
                       ("rust-regex" ,rust-regex-1))
       #:cargo-development-inputs (("rust-snapbox" ,rust-snapbox-0.6))))
    (home-page "https://github.com/rust-cli/env_logger")
    (synopsis "Filter log events using environment variables")
    (description "Filter log events using environment variables.")
    (license (list license:expat license:asl2.0))))

(define-public rust-env-home-0.1
  (package
    (name "rust-env-home")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "env_home" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1zn08mk95rjh97831rky1n944k024qrwjhbcgb0xv9zhrh94xy67"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/notpeter/env-home")
    (synopsis "Get the user home directory in a cross-platform way")
    (description
     "This package gets the user home directory in a cross-platform way.")
    (license (list license:expat license:asl2.0))))

(define-public rust-env-logger-0.11
  (package
    (name "rust-env-logger")
    (version "0.11.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "env_logger" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1q30cqb2dfs3qrs0s30qdmqwi7n2gz4pniwd8a9gvhygwgcf7bnw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-anstream" ,rust-anstream-0.6)
                       ("rust-anstyle" ,rust-anstyle-1)
                       ("rust-env-filter" ,rust-env-filter-0.1)
                       ("rust-humantime" ,rust-humantime-2)
                       ("rust-log" ,rust-log-0.4))))
    (home-page "https://github.com/rust-cli/env_logger")
    (synopsis "Logging implementation for @code{log}")
    (description
     "This package provides a logging implementation for @code{log} which
is configured via an environment variable.")
    (license (list license:expat license:asl2.0))))

(define-public rust-env-logger-0.10
  (package
    (inherit rust-env-logger-0.11)
    (name "rust-env-logger")
    (version "0.10.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "env_logger" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1005v71kay9kbz1d5907l0y7vh9qn2fqsp2yfgb8bjvin6m0bm2c"))))
    (arguments
     `(#:cargo-inputs
       (("rust-humantime" ,rust-humantime-2)
        ("rust-is-terminal" ,rust-is-terminal-0.4)
        ("rust-log" ,rust-log-0.4)
        ("rust-regex" ,rust-regex-1)
        ("rust-termcolor" ,rust-termcolor-1))))))

(define-public rust-env-logger-0.9
  (package
    (inherit rust-env-logger-0.10)
    (name "rust-env-logger")
    (version "0.9.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "env_logger" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1rq0kqpa8my6i1qcyhfqrn1g9xr5fbkwwbd42nqvlzn9qibncbm1"))))
    (arguments
     `(#:cargo-inputs
       (("rust-atty" ,rust-atty-0.2)
        ("rust-humantime" ,rust-humantime-2)
        ("rust-log" ,rust-log-0.4)
        ("rust-regex" ,rust-regex-1)
        ("rust-termcolor" ,rust-termcolor-1))))))

(define-public rust-env-logger-0.8
  (package
    (inherit rust-env-logger-0.9)
    (name "rust-env-logger")
    (version "0.8.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "env_logger" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1qzw8g11dbdfi7ixm44ldykwcqsxqkh8vx5cgpd88zmclgz8g4d1"))))
    (arguments
     `(#:cargo-inputs
       (("rust-atty" ,rust-atty-0.2)
        ("rust-humantime" ,rust-humantime-2)
        ("rust-log" ,rust-log-0.4)
        ("rust-regex" ,rust-regex-1)
        ("rust-termcolor" ,rust-termcolor-1))))))

(define-public rust-env-logger-0.7
  (package
    (inherit rust-env-logger-0.8)
    (name "rust-env-logger")
    (version "0.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "env_logger" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0djx8h8xfib43g5w94r1m1mkky5spcw4wblzgnhiyg5vnfxknls4"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-atty" ,rust-atty-0.2)
        ("rust-humantime" ,rust-humantime-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-regex" ,rust-regex-1)
        ("rust-termcolor" ,rust-termcolor-1))))))

(define-public rust-env-logger-0.6
  (package
    (inherit rust-env-logger-0.7)
    (name "rust-env-logger")
    (version "0.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "env_logger" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1lx2s5nk96xx4i3m4zc4ghqgi8kb07dsnyiv8jk2clhax42dxz5a"))))
    (arguments
     `(#:cargo-inputs
       (("rust-atty" ,rust-atty-0.2)
        ("rust-humantime" ,rust-humantime-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-regex" ,rust-regex-1)
        ("rust-termcolor" ,rust-termcolor-1))))))

(define-public rust-env-logger-0.5
  (package
    (inherit rust-env-logger-0.7)
    (name "rust-env-logger")
    (version "0.5.13")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "env_logger" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0f0c4i4c65jh8lci0afl5yg74ac0lbnpxcp81chj114zwg9a9c0m"))))
    (arguments
     `(#:cargo-inputs
       (("rust-atty" ,rust-atty-0.2)
        ("rust-humantime" ,rust-humantime-1)
        ("rust-log" ,rust-log-0.4)
        ("rust-regex" ,rust-regex-1)
        ("rust-termcolor" ,rust-termcolor-1))))))

(define-public rust-env-logger-0.4
  (package
    (inherit rust-env-logger-0.7)
    (name "rust-env-logger")
    (version "0.4.3")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "env_logger" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0nydz2lidsvx9gs0v2zcz68rzqx8in7fzmiprgsrhqh17vkj3prx"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-log" ,rust-log-0.3)
        ("rust-regex" ,rust-regex-0.2))))))

(define-public rust-env-logger-0.3
  (package
    (inherit rust-env-logger-0.7)
    (name "rust-env-logger")
    (version "0.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "env_logger" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0bvcjgkw4s3k1rd7glpflgc8s9a393zjd6jfdgvs8gjvwj0dgaqm"))))
    (arguments
     `(#:skip-build? #t     ; Cannot find dependent crates.
       #:cargo-inputs
       (("rust-regex" ,rust-regex-0.1)
        ("rust-log" ,rust-log-0.3))))))

(define-public rust-env-proxy-0.4
  (package
    (name "rust-env-proxy")
    (version "0.4.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "env_proxy" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1qabqhgybx1jzh6dmpx7kssciw312i8aa6al7fj0d12k32z1jl1s"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-log" ,rust-log-0.4) ("rust-url" ,rust-url-2))))
    (home-page "https://github.com/inejge/env_proxy")
    (synopsis "Proxy URL from the environment variables")
    (description
     "This package provides a way to determinate proxy parameters for a URL
from the environment.")
    (license (list license:expat license:asl2.0))))

(define-public rust-environment-0.1
  (package
    (name "rust-environment")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "environment" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1vh32mcxf3z8xaibwv751zj14d08nh7iwk1vqdj90rkq17i18jqz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f)) ;; 3/6 tests fail due to missing file
    (home-page "https://github.com/Freyskeyd/environment")
    (synopsis "Helper to deal with environment variables")
    (description "This package provides helper to deal with environment
variables.")
    (license (list license:expat license:asl2.0))))

(define-public rust-envy-0.4
  (package
    (name "rust-envy")
    (version "0.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "envy" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0rar459p7pl19v6pbx98q3hi2hxfl8q1ndxxw5d4zd9cgway0irz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/softprops/envy")
    (synopsis "Deserialize environment variables into Rust structs")
    (description
     "This package provides access to typesafe config structs
deserialized from environment variables.")
     (license license:expat)))

(define-public rust-equivalent-1
  (package
    (name "rust-equivalent")
    (version "1.0.1")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "equivalent" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1malmx5f4lkfvqasz319lq6gb3ddg19yzf9s8cykfsgzdmyq0hsl"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/cuviper/equivalent")
    (synopsis "Traits for key comparison in maps")
    (description "Traits for key comparison in maps.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-erased-serde-0.4
  (package
    (name "rust-erased-serde")
    (version "0.4.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "erased-serde" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "13dirfj9972nvk05b20w3xyn3xp1j6qyfp9avhksnkxbcnfkiqi4"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-serde" ,rust-serde-1)
                       ("rust-typeid" ,rust-typeid-1))
       #:cargo-development-inputs (("rust-rustversion" ,rust-rustversion-1)
                                   ("rust-serde-cbor" ,rust-serde-cbor-0.11)
                                   ("rust-serde-derive" ,rust-serde-derive-1)
                                   ("rust-serde-json" ,rust-serde-json-1)
                                   ("rust-trybuild" ,rust-trybuild-1))))
    (home-page "https://github.com/dtolnay/erased-serde")
    (synopsis "Type-erased Serialize and Serializer traits")
    (description
     "Type-erased Serialize and Serializer traits.")
    (license (list license:expat license:asl2.0))))

(define-public rust-erased-serde-0.3
  (package
    (inherit rust-erased-serde-0.4)
    (name "rust-erased-serde")
    (version "0.3.31")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "erased-serde" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0v5jyid1v8irf2n2875iwhm80cw8x75gfkdh7qvzxrymz5s8j4vc"))))
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-rustversion" ,rust-rustversion-1)
        ("rust-serde-cbor" ,rust-serde-cbor-0.11)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-trybuild" ,rust-trybuild-1))))))

(define-public rust-errno-0.3
  (package
    (name "rust-errno")
    (version "0.3.10")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "errno" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0pgblicz1kjz9wa9m0sghkhh2zw1fhq1mxzj7ndjm746kg5m5n1k"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-windows-sys" ,rust-windows-sys-0.52))))
    (home-page "https://github.com/lambda-fairy/rust-errno")
    (synopsis "Cross-platform interface to the @code{errno} variable")
    (description
     "This package provides a cross-platform interface to the
@code{errno} variable.")
    (license (list license:expat license:asl2.0))))

(define-public rust-errno-0.2
  (package
    (inherit rust-errno-0.3)
    (name "rust-errno")
    (version "0.2.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "errno" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "18cnqgk8r6lq1n5cfy3bryiyz9zkqr10dxj49sa3fkzfamih8fgn"))))
    (arguments
     (list #:skip-build? #t
           #:cargo-inputs
           `(("rust-errno-dragonfly" ,rust-errno-dragonfly-0.1)
             ("rust-libc" ,rust-libc-0.2)
             ("rust-winapi" ,rust-winapi-0.3))))))

(define-public rust-errno-dragonfly-0.1
  (package
    (name "rust-errno-dragonfly")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "errno-dragonfly" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1grrmcm6q8512hkq5yzch3yv8wafflc2apbmsaabiyk44yqz2s5a"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cc" ,rust-cc-1)
        ("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/mneumann/errno-dragonfly-rs")
    (synopsis "Exposes errno functionality to stable Rust on DragonFlyBSD")
    (description
     "Exposes errno functionality to stable Rust on DragonFlyBSD.")
    (license license:expat)))

(define-public rust-error-chain-0.12
  (package
    (name "rust-error-chain")
    (version "0.12.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "error-chain" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1z6y5isg0il93jp287sv7pn10i4wrkik2cpyk376wl61rawhcbrd"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-backtrace" ,rust-backtrace-0.3)
        ("rust-version-check" ,rust-version-check-0.9))))
    (home-page "https://github.com/rust-lang-nursery/error-chain")
    (synopsis "Yet another error boilerplate library")
    (description
     "Yet another error boilerplate library.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-error-chain-0.11
  (package
    (inherit rust-error-chain-0.12)
    (name "rust-error-chain")
    (version "0.11.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "error-chain" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1wykkr0naizbkwxjwia1rch8xhwvgij9khqvjzs07mrmqifislgz"))))
    (arguments
     `(#:tests? #f      ; Not all test files included.
       #:cargo-inputs
       (("rust-backtrace" ,rust-backtrace-0.3))))))

(define-public rust-error-chain-0.10
  (package
    (inherit rust-error-chain-0.11)
    (name "rust-error-chain")
    (version "0.10.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "error-chain" version))
        (file-name
         (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1y1gyj9g5c3k1nzkvxrgry8v9k86kcc585mczrm3qz019s35shyr"))))
    (arguments
     `(#:cargo-inputs
       (("rust-backtrace" ,rust-backtrace-0.3))))))

(define-public rust-error-code-3
  (package
    (name "rust-error-code")
    (version "3.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "error-code" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0bx9hw3pahzqym8jvb0ln4qsabnysgn98mikyh2afhk9rif31nd5"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/DoumanAsh/error-code")
    (synopsis "Alternative @code{Error} for Rust")
    (description
     "This package provides a simplified @code{Error} which works in
@code{no_std} environment.")
    (license license:boost1.0)))

(define-public rust-error-code-2
  (package
    (inherit rust-error-code-3)
    (name "rust-error-code")
    (version "2.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "error-code" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "08baxlf8qz01lgjsdbfhs193r9y1nlc566s5xvzyf4dzwy8qkwb4"))))
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-str-buf" ,rust-str-buf-1))))))

(define-public rust-escape8259-0.5
  (package
    (name "rust-escape8259")
    (version "0.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "escape8259" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1in2zrdak794x8v11lkrrgyqxjjqbijvg0yfn2paay0rb9xxv4jn"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-rustversion" ,rust-rustversion-1))))
    (home-page "https://github.com/ericseppanen/escape8259")
    (synopsis "RFC8259-compliant string escaping and un-escaping")
    (description "RFC8259-compliant string escaping and un-escaping.")
    (license license:expat)))

(define-public rust-escaper-0.1
  (package
    (name "rust-escaper")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "escaper" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0rhn3ipb5c3zns4wakclilfqzbmax6pwx7l367dipfj9fdxvjgm5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-entities" ,rust-entities-1))
       #:cargo-development-inputs
       (("rust-num" ,rust-num-0.4)
        ("rust-rand" ,rust-rand-0.8))))
    (home-page "https://github.com/dignifiedquire/rust-escaper")
    (synopsis "Library for HTML entity encoding and decoding")
    (description "This package provides a library for HTML entity encoding and
decoding.")
    (license (list license:asl2.0 license:expat license:mpl2.0))))

(define-public rust-escargot-0.5
  (package
    (name "rust-escargot")
    (version "0.5.13")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "escargot" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32 "127drlrdvp235l528cirryvnfg0jmldzssccxwpkid8ng8car8q5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags
       '("--"
         ;; Not all files included.
         "--skip=src/build.rs - build::CargoBuild::run (line 283)"
         "--skip=src/run.rs - run::CargoRun (line 23)"
         "--skip=src/run.rs - run::CargoRun::command (line 116)"
         "--skip=src/run.rs - run::CargoRun::path (line 65)")
       #:cargo-inputs
       (("rust-log" ,rust-log-0.4)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1))
       #:cargo-development-inputs
       (("rust-automod" ,rust-automod-1)
        ("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/crate-ci/escargot")
    (synopsis "Cargo API written in Paris")
    (description "Cargo API written in Paris.")
    (license (list license:expat license:asl2.0))))

(define-public rust-etcetera-0.8
  (package
    (name "rust-etcetera")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "etcetera" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0hxrsn75dirbjhwgkdkh0pnpqrnq17ypyhjpjaypgax1hd91nv8k"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-cfg-if" ,rust-cfg-if-1)
                       ("rust-home" ,rust-home-0.5)
                       ("rust-windows-sys" ,rust-windows-sys-0.48))))
    (home-page "https://github.com/lunacookies/etcetera")
    (synopsis
     "Library for obtaining configuration, data, cache, & other directories")
    (description
     "This is a Rust library that allows you to determine the locations of
configuration, data, cache & other files for your application.  Existing Rust
libraries generally do not give you a choice in terms of which standards/conventions
they follow.  Etcetera, on the other hand, gives you the choice.")
    (license (list license:expat license:asl2.0))))

(define-public rust-etherparse-0.13
  (package
    (name "rust-etherparse")
    (version "0.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "etherparse" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "146rcbnhlpcbl6c6csfhvz0227wbiwhk13md6acq8211b7m94wl2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-arrayvec" ,rust-arrayvec-0.7))
       #:cargo-development-inputs (("rust-assert-matches" ,rust-assert-matches-1)
                                   ("rust-proptest" ,rust-proptest-1))))
    (home-page "https://github.com/JulianSchmid/etherparse")
    (synopsis "Library for parsing & writing a bunch of packet based protocols")
    (description
     "This package provides a library for parsing & writing a bunch of packet
based protocols (@code{EthernetII}, IPv4, IPv6, UDP, TCP ...).")
    (license (list license:expat license:asl2.0))))

(define-public rust-etherparse-0.9
  (package
    (inherit rust-etherparse-0.13)
    (name "rust-etherparse")
    (version "0.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "etherparse" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "01s86nj0k663mgxpj3r7y5wr50l5c3aq0pm4rpzyb7hz50i0k8ig"))))
    (arguments
     `(#:cargo-inputs (("rust-byteorder" ,rust-byteorder-1))
       #:cargo-development-inputs (("rust-assert-matches" ,rust-assert-matches-1)
                                   ("rust-proptest" ,rust-proptest-0.9))))))

(define-public rust-ethnum-1
  (package
    (name "rust-ethnum")
    (version "1.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ethnum" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0b68ngvisb0d40vc6h30zlhghbb3mc8wlxjbf8gnmavk1dca435r"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-ethnum-intrinsics" ,rust-ethnum-intrinsics-1)
                       ("rust-serde" ,rust-serde-1))))
    (home-page "https://github.com/nlordell/ethnum-rs")
    (synopsis "256-bit integer implementation")
    (description "This package contains a 256-bit integer implementation.")
    (license (list license:expat license:asl2.0))))

(define-public rust-ethnum-intrinsics-1
  (package
    (name "rust-ethnum-intrinsics")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ethnum-intrinsics" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1qvb1r3vmnk5nplz6x1014rn6b9nfnig2qmlj8hi3jpq75j8cgh9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t     ; error: unterminated attribute group
       #:cargo-inputs (("rust-cc" ,rust-cc-1))))
    (inputs (list clang))
    (home-page "https://github.com/nlordell/ethnum-rs")
    (synopsis "LLVM generated 256-bit integer intrinsics")
    (description
     "This package contains LLVM generated 256-bit integer intrinsics.")
    (license (list license:expat license:asl2.0))))

(define-public rust-ethtool-0.2
  (package
    (name "rust-ethtool")
    (version "0.2.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ethtool" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0nivim6pzfvrnmyb0p7qv39q54vraa0z6jy0ims7gp0panih93hx"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags '("--release" "--"
                            "--skip=test_dump_link_modes")
       #:cargo-inputs (("rust-anyhow" ,rust-anyhow-1)
                       ("rust-async-std" ,rust-async-std-1)
                       ("rust-byteorder" ,rust-byteorder-1)
                       ("rust-futures" ,rust-futures-0.3)
                       ("rust-genetlink" ,rust-genetlink-0.2)
                       ("rust-log" ,rust-log-0.4)
                       ("rust-netlink-packet-core" ,rust-netlink-packet-core-0.7)
                       ("rust-netlink-packet-generic" ,rust-netlink-packet-generic-0.3)
                       ("rust-netlink-packet-utils" ,rust-netlink-packet-utils-0.5)
                       ("rust-netlink-proto" ,rust-netlink-proto-0.11)
                       ("rust-netlink-sys" ,rust-netlink-sys-0.8)
                       ("rust-thiserror" ,rust-thiserror-1)
                       ("rust-tokio" ,rust-tokio-1))
       #:cargo-development-inputs (("rust-env-logger" ,rust-env-logger-0.9)
                                   ("rust-tokio" ,rust-tokio-1))))
    (home-page "https://docs.rs/ethtool/latest/ethtool/")
    (synopsis "Linux Ethtool Communication Library")
    (description "Linux Ethtool Communication Library.")
    (license license:expat)))

(define-public rust-eui48-1
  (package
    (name "rust-eui48")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "eui48" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "00cpf25kc3mxhqnahm0bw9xl19gr2pzc5g84dvkc4mwdbsn1hx48"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-regex" ,rust-regex-1)
                       ("rust-rustc-serialize" ,rust-rustc-serialize-0.3)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-serde-json" ,rust-serde-json-1))
       #:cargo-development-inputs (("rust-bincode" ,rust-bincode-1))))
    (home-page "https://github.com/abaumhauer/eui48")
    (synopsis "Library to generate and parse IEEE EUI-48 and EUI-64")
    (description
     "This package provides a library to generate and parse IEEE EUI-48
and EUI-64, also known as MAC-48 media access control addresses.  The
IEEE claims trademarks on the names EUI-48 and EUI-64, in which EUI is an
abbreviation for Extended Unique Identifier.")
    (license (list license:expat license:asl2.0))))

(define-public rust-evdev-0.12
  (package
    (name "rust-evdev")
    (version "0.12.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "evdev" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "19qh6r1z4v8ja6qqigjbg9vckbhlycc6wkqgzfz9fcln7almaq5b"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bitvec" ,rust-bitvec-1)
        ("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-futures-core" ,rust-futures-core-0.3)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-nix" ,rust-nix-0.23)
        ("rust-paste" ,rust-paste-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-thiserror" ,rust-thiserror-1)
        ("rust-tokio" ,rust-tokio-1))
       #:cargo-development-inputs
       (("rust-itertools" ,rust-itertools-0.10)
        ("rust-tokio" ,rust-tokio-1))))
    (home-page "https://github.com/emberian/evdev")
    (synopsis "Rust interface to Linux event devices")
    (description "This package provides evdev interface for Linux.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-evdev-rs-0.6
  (package
    (name "rust-evdev-rs")
    (version "0.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "evdev-rs" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1fkdw23kjjn8an3xjpi2g74yhdfkv89ngsrkjd2cxz5n1xwxa4lq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags
       '("--release" "--"
         "--skip=context_change_file"
         "--skip=context_create_with_file"
         "--skip=context_create_with_path"
         "--skip=context_grab"
         "--skip=context_set_file"
         "--skip=device_get_absinfo"
         "--skip=device_get_value"
         "--skip=device_has_property"
         "--skip=device_has_syn")
       #:cargo-inputs (("rust-bitflags" ,rust-bitflags-1)
                       ("rust-evdev-sys" ,rust-evdev-sys-0.2)
                       ("rust-libc" ,rust-libc-0.2)
                       ("rust-log" ,rust-log-0.4)
                       ("rust-serde" ,rust-serde-1))))
    (native-inputs (list pkg-config))
    (inputs (list libevdev))
    (home-page "https://github.com/ndesh26/evdev-rs")
    (synopsis "Bindings to libevdev")
    (description
     "This package provides bindings to libevdev for interacting with evdev
devices.  It moves the common tasks when dealing with evdev devices into
a library and provides a library interface to the callers, thus avoiding
erroneous ioctls, etc.")
    (license (list license:expat license:asl2.0))))

(define-public rust-evdev-sys-0.2
  (package
    (name "rust-evdev-sys")
    (version "0.2.5")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "evdev-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0vgax74wjsm22nrx6ikh8m7bj3nggf83s961i5qd85bvahmx9shl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-cc" ,rust-cc-1)
                       ("rust-libc" ,rust-libc-0.2)
                       ("rust-pkg-config" ,rust-pkg-config-0.3))))
    (home-page "https://github.com/ndesh26/evdev-rs")
    (synopsis "Raw bindings to libevdev")
    (description
     "This package provides Raw bindings to libevdev.  High level Rust
bindings are available in the @code{evdev} crate.")
    (license (list license:expat license:asl2.0))))

(define-public rust-event-listener-5
  (package
    (name "rust-event-listener")
    (version "5.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "event-listener" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1fkm6q4hjn61wl52xyqyyxai0x9w0ngrzi0wf1qsf8vhsadvwck0"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-concurrent-queue" ,rust-concurrent-queue-2)
                       ("rust-loom" ,rust-loom-0.7)
                       ("rust-parking" ,rust-parking-2)
                       ("rust-pin-project-lite" ,rust-pin-project-lite-0.2)
                       ("rust-portable-atomic" ,rust-portable-atomic-1)
                       ("rust-portable-atomic-util" ,rust-portable-atomic-util-0.2))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.5)
        ("rust-futures-lite" ,rust-futures-lite-2)
        ("rust-waker-fn" ,rust-waker-fn-1)
        ("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.3))))
    (home-page "https://github.com/smol-rs/event-listener")
    (synopsis "Notify async tasks or threads")
    (description
     "This is a synchronization primitive similar to @code{eventcounts}.
You can use this crate to turn non-blocking data structures into async or
blocking data structures.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-event-listener-4
  (package
    (inherit rust-event-listener-5)
    (name "rust-event-listener")
    (version "4.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "event-listener" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0vk4smw1vf871vi76af1zn7w69jg3zmpjddpby2qq91bkg21bck7"))))
    (arguments
     `(#:cargo-inputs
       (("rust-concurrent-queue" ,rust-concurrent-queue-2)
        ("rust-parking" ,rust-parking-2)
        ("rust-pin-project-lite" ,rust-pin-project-lite-0.2)
        ("rust-portable-atomic" ,rust-portable-atomic-1)
        ("rust-portable-atomic-util" ,rust-portable-atomic-util-0.1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.5)
        ("rust-futures-lite" ,rust-futures-lite-2)
        ("rust-waker-fn" ,rust-waker-fn-1)
        ("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.3))))))

(define-public rust-event-listener-3
  (package
    (inherit rust-event-listener-4)
    (name "rust-event-listener")
    (version "3.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "event-listener" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1hihkg6ihvb6p9yi7nq11di8mhd5y0iqv81ij6h0rf0fvsy7ff6r"))))
    (arguments
     `(#:cargo-inputs
       (("rust-concurrent-queue" ,rust-concurrent-queue-2)
        ("rust-parking" ,rust-parking-2)
        ("rust-pin-project-lite" ,rust-pin-project-lite-0.2)
        ("rust-portable-atomic" ,rust-portable-atomic-1)
        ("rust-portable-atomic-util" ,rust-portable-atomic-util-0.1))
       #:cargo-development-inputs
       (("rust-criterion" ,rust-criterion-0.4)
        ("rust-futures-lite" ,rust-futures-lite-2)
        ("rust-waker-fn" ,rust-waker-fn-1)
        ("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.3))))))

(define-public rust-event-listener-2
  (package
    (inherit rust-event-listener-4)
    (name "rust-event-listener")
    (version "2.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "event-listener" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1q4w3pndc518crld6zsqvvpy9lkzwahp2zgza9kbzmmqh9gif1h2"))))
    (arguments
     `(#:cargo-development-inputs
       (("rust-futures" ,rust-futures-0.3)
        ("rust-waker-fn" ,rust-waker-fn-1))))))

(define-public rust-event-listener-strategy-0.5
  (package
    (name "rust-event-listener-strategy")
    (version "0.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "event-listener-strategy" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ch5gf6knllyq12jkb5zdfag573dh44307q4pwwi2g37sc6lwgiw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-event-listener" ,rust-event-listener-5)
                       ("rust-pin-project-lite" ,rust-pin-project-lite-0.2))
       #:cargo-development-inputs
       (("rust-futures-lite" ,rust-futures-lite-2)
        ("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.3))))
    (home-page "https://github.com/smol-rs/event-listener")
    (synopsis "Block or poll on event_listener")
    (description "This package provides block and poll on event_listener.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-event-listener-strategy-0.4
  (package
    (inherit rust-event-listener-strategy-0.5)
    (name "rust-event-listener-strategy")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "event-listener-strategy" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1lwprdjqp2ibbxhgm9khw7s7y7k4xiqj5i5yprqiks6mnrq4v3lm"))))
    (arguments
     `(#:cargo-inputs (("rust-event-listener" ,rust-event-listener-4)
                       ("rust-pin-project-lite" ,rust-pin-project-lite-0.2))
       #:cargo-development-inputs
       (("rust-futures-lite" ,rust-futures-lite-2)
        ("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.3))))))

(define-public rust-event-listener-strategy-0.1
  (package
    (inherit rust-event-listener-strategy-0.4)
    (name "rust-event-listener-strategy")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "event-listener-strategy" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1z99km9lwya36bxhvrz4rsl3nhqhhlnnx7a2gdz4nzpa6177pj8m"))))
    (arguments
     `(#:cargo-inputs (("rust-event-listener" ,rust-event-listener-3)
                       ("rust-pin-project-lite" ,rust-pin-project-lite-0.2))
       #:cargo-development-inputs (("rust-futures-lite" ,rust-futures-lite-1))))))

(define-public rust-exacl-0.12
  (package
    (name "rust-exacl")
    (version "0.12.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "exacl" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1n26751wih2pq4dwij9fnb661w33hgn53wh9bnwdmkfy37g15gi2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags
       '("--"
         "--skip=acl::acl_tests::test_write_acl_posix"
         "--skip=acl::acl_tests::test_write_default_acl"
         "--skip=qualifier::qualifier_tests::test_group_named"
         "--skip=qualifier::qualifier_tests::test_user_named"
         "--skip=unix::unix_tests::test_gid_to_name"
         "--skip=unix::unix_tests::test_name_to_gid"
         "--skip=unix::unix_tests::test_name_to_uid"
         "--skip=unix::unix_tests::test_uid_to_name")
       #:cargo-inputs (("rust-bindgen" ,rust-bindgen-0.69)
                       ("rust-bitflags" ,rust-bitflags-2)
                       ("rust-log" ,rust-log-0.4)
                       ("rust-scopeguard" ,rust-scopeguard-1)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-uuid" ,rust-uuid-1))
       #:cargo-development-inputs (("rust-clap" ,rust-clap-4)
                                   ("rust-ctor" ,rust-ctor-0.2)
                                   ("rust-env-logger" ,rust-env-logger-0.11)
                                   ("rust-serde-json" ,rust-serde-json-1)
                                   ("rust-tempfile" ,rust-tempfile-3))))
    (inputs (list acl))
    (home-page "https://github.com/byllyfish/exacl")
    (synopsis "Manipulate file system (ACL) on macOS, Linux, and FreeBSD")
    (description
     "This package provides functions to manipulate file system access control
lists (ACL) on @code{macOS}, Linux, and @code{FreeBSD}.")
    (license license:expat)))

(define-public rust-exacl-0.11
  (package
    (inherit rust-exacl-0.12)
    (name "rust-exacl")
    (version "0.11.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "exacl" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "17vd67mhppnw1kbb053c4bygilbdviz53zrzm4z1cxr73hn1b5f6"))))
    (arguments
     `(#:cargo-test-flags
       '("--release" "--"
         "--skip=acl::acl_tests::test_write_acl_posix"
         "--skip=acl::acl_tests::test_write_default_acl"
         "--skip=qualifier::qualifier_tests::test_group_named"
         "--skip=qualifier::qualifier_tests::test_user_named"
         "--skip=unix::unix_tests::test_gid_to_name"
         "--skip=unix::unix_tests::test_name_to_gid"
         "--skip=unix::unix_tests::test_name_to_uid"
         "--skip=unix::unix_tests::test_uid_to_name")
       #:cargo-inputs (("rust-bindgen" ,rust-bindgen-0.68)
                       ("rust-bitflags" ,rust-bitflags-2)
                       ("rust-log" ,rust-log-0.4)
                       ("rust-scopeguard" ,rust-scopeguard-1)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-uuid" ,rust-uuid-1))
       #:cargo-development-inputs (("rust-clap" ,rust-clap-4)
                                   ("rust-ctor" ,rust-ctor-0.2)
                                   ("rust-env-logger" ,rust-env-logger-0.10)
                                   ("rust-serde-json" ,rust-serde-json-1)
                                   ("rust-tempfile" ,rust-tempfile-3))))))

(define-public rust-executable-path-1
  (package
    (name "rust-executable-path")
    (version "1.0.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "executable-path" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0y0lhhrx9f9q1f81am3b20f8znixjcvqfg7kx220pjg3i5nmmg1y"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/casey/rust-executable-path")
    (synopsis "Get the path of a binary target's executable")
    (description "Get the path of a binary target's executable.")
    (license license:cc0)))

(define-public rust-executors-0.9
  (package
    (name "rust-executors")
    (version "0.9.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "executors" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0z8gn5vcr0x1db1bvahhmby9mpr1jgzd4qfvm25mja5js3agk51a"))))
    (build-system cargo-build-system)
    (arguments
     ;; TODO: build needs metrics_printer
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-arr-macro" ,rust-arr-macro-0.1)
        ("rust-async-task" ,rust-async-task-4)
        ("rust-core-affinity" ,rust-core-affinity-0.5)
        ("rust-crossbeam-channel" ,rust-crossbeam-channel-0.5)
        ("rust-crossbeam-deque" ,rust-crossbeam-deque-0.8)
        ("rust-crossbeam-utils" ,rust-crossbeam-utils-0.8)
        ("rust-log" ,rust-log-0.4)
        ("rust-metrics" ,rust-metrics-0.14)
        ("rust-num-cpus" ,rust-num-cpus-1)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-synchronoise" ,rust-synchronoise-1)
        ("rust-threadpool" ,rust-threadpool-1))))
    (home-page "https://github.com/Bathtor/rust-executors")
    (synopsis "Collection of high-performance task executors")
    (description
     "This package provides a collection of high-performance task executors.")
    (license license:expat)))

(define-public rust-exhaustigen-0.1
  (package
    (name "rust-exhaustigen")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "exhaustigen" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1djym5wjcib78fxspkkal0vdq8dd1vlllk6f6858m5haf53zg23x"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/graydon/exhaustigen-rs")
    (synopsis "Exhaustive test generator")
    (description "This package provides an exhaustive test generator.")
    (license (list license:expat license:asl2.0))))

(define-public rust-exitcode-1
  (package
    (name "rust-exitcode")
    (version "1.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "exitcode" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "14x1pgwx86x1gfc5zqgj04akr9pzg14w75d9cblc49vhnij3g1fy"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/benwilber/exitcode")
    (synopsis "Preferred system exit codes as defined by @file{sysexits.h}")
    (description "This package provides preferred system exit codes as defined
by @file{sysexits.h}.")
    (license license:asl2.0)))

(define-public rust-expat-sys-2
  (package
    (name "rust-expat-sys")
    (version "2.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "expat-sys" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1yj5pqynds776ay8wg9mhi3hvna4fv7vf244yr1864r0i5r1k3v5"))
        (modules '((guix build utils)))
        (snippet
         '(begin (delete-file-recursively "expat") #t))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cmake" ,rust-cmake-0.1)
        ("rust-pkg-config" ,rust-pkg-config-0.3))))
    (native-inputs
     (list pkg-config))
    (inputs
     (list expat))
    (home-page "http://www.libexpat.org/")
    (synopsis "XML parser library written in C")
    (description "XML parser library written in C")
    (license license:expat)))

(define-public rust-expect-test-1
  (package
    (name "rust-expect-test")
    (version "1.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "expect-test" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1c5c081ykm4k5rlsam9jw56w4wgs2h7r4aj78zxlis1i8kzl7bv3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-dissimilar" ,rust-dissimilar-1)
        ("rust-once-cell" ,rust-once-cell-1))))
    (home-page "https://github.com/rust-analyzer/expect-test")
    (synopsis "Minimalistic snapshot testing library")
    (description
     "This package provides a minimalistic snapshot testing library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-expectest-0.12
  (package
    (name "rust-expectest")
    (version "0.12.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "expectest" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0y290ak3q5l8l8ajg00mqx1lx9f1pagk6ckmplzibf5ach5pr0bq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-num-traits" ,rust-num-traits-0.2))))
    (home-page "https://github.com/zummenix/expectest")
    (synopsis "Matchers and matcher functions for unit testing")
    (description "This crate provides matchers and matcher functions for unit
testing.")
    (license (list license:expat license:asl2.0))))

(define-public rust-expectrl-0.7
  (package
    (name "rust-expectrl")
    (version "0.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "expectrl" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0ykiqkh2r3ky1244r4j0x49hqawdrfdh1mai6fdapz2kb6989rzd"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-test-flags
       '("--release" "--"
         ;; These tests don't do well in the build environment
         "--skip=bash_control_chars"
         "--skip=python"
         "--skip=send")
         #:cargo-inputs
       (("rust-async-io" ,rust-async-io-1)
        ("rust-blocking" ,rust-blocking-1)
        ("rust-conpty" ,rust-conpty-0.5)
        ("rust-crossbeam-channel" ,rust-crossbeam-channel-0.5)
        ("rust-futures-lite" ,rust-futures-lite-1)
        ("rust-futures-timer" ,rust-futures-timer-3)
        ("rust-nix" ,rust-nix-0.26)
        ("rust-polling" ,rust-polling-2)
        ("rust-ptyprocess" ,rust-ptyprocess-0.4)
        ("rust-regex" ,rust-regex-1))))
    (home-page "https://github.com/zhiburt/expectrl")
    (synopsis "Tool for automating terminal applications in Unix")
    (description
     "This package provides a tool for automating terminal applications in Unix
like Don libes expect.")
    (license license:expat)))

(define-public rust-extract-map-0.1
  (package
    (name "rust-extract-map")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "extract_map" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0s695n5yzs7wwyvaphkkscr8lfv7h94xsczg49a9qa37nnd51xxb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-gat-lending-iterator" ,rust-gat-lending-iterator-0.1)
        ("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/GnomedDev/extract_map")
    (synopsis "HashMap for memory efficient storage of value types")
    (description
     "This package provides a @code{HashMap} for memory efficient storage of value
types which contain their own keys.")
    (license license:expat)))

(define-public rust-extreme-666
  (package
    (name "rust-extreme")
    (version "666.666.666666")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "extreme" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1yrig1ky9a6xpcl5nqnkk9wyis7k7wjzb8bbr4n810apfhq5nq0n"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/spacejam/extreme")
    (synopsis "Extremely boring async function runner")
    (description
     "This package provides an extremely boring async function runner.")
    (license license:gpl3)))

(define-public rust-eyeball-0.8
  (package
    (name "rust-eyeball")
    (version "0.8.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "eyeball" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0grqzyxfc1nygfa4r9hr9sj6hncpjxpaj29w5lrxcq9xz7mx0fyr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-criterion" ,rust-criterion-0.5)
                       ("rust-futures-core" ,rust-futures-core-0.3)
                       ("rust-readlock" ,rust-readlock-0.1)
                       ("rust-readlock-tokio" ,rust-readlock-tokio-0.1)
                       ("rust-tokio" ,rust-tokio-1)
                       ("rust-tokio-util" ,rust-tokio-util-0.7)
                       ("rust-tracing" ,rust-tracing-0.1))
       #:cargo-development-inputs
       (("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-stream-assert" ,rust-stream-assert-0.1)
        ("rust-tokio" ,rust-tokio-1))))
    (home-page "https://github.com/jplatte/eyeball")
    (synopsis "Add observability to your Rust types")
    (description "Add observability to your Rust types!")
    (license license:mpl2.0)))

(define-public rust-eyeball-im-0.4
  (package
    (name "rust-eyeball-im")
    (version "0.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "eyeball-im" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1m1vz8f8nv1za8pvn4c00r71wrnc2i2qnq0jaj9ii7fmyvcwh9lk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-futures-core" ,rust-futures-core-0.3)
                       ("rust-imbl" ,rust-imbl-2)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-tokio" ,rust-tokio-1)
                       ("rust-tokio-util" ,rust-tokio-util-0.7)
                       ("rust-tracing" ,rust-tracing-0.1))
       #:cargo-development-inputs
       (("rust-serde-json" ,rust-serde-json-1)
        ("rust-stream-assert" ,rust-stream-assert-0.1))))
    (home-page "https://github.com/jplatte/eyeball")
    (synopsis "Observable collections based on the `im` crate")
    (description "Observable collections based on the `im` crate.")
    (license license:mpl2.0)))

(define-public rust-eyeball-im-util-0.5
  (package
    (name "rust-eyeball-im-util")
    (version "0.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "eyeball-im-util" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0q4r3qi46s8mnvn2y9pk322y4qdl4j81pa53q7xg4c9zncma5zn0"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-arrayvec" ,rust-arrayvec-0.7)
                       ("rust-eyeball-im" ,rust-eyeball-im-0.4)
                       ("rust-futures-core" ,rust-futures-core-0.3)
                       ("rust-imbl" ,rust-imbl-2)
                       ("rust-pin-project-lite" ,rust-pin-project-lite-0.2)
                       ("rust-smallvec" ,rust-smallvec-1))
       #:cargo-development-inputs
       (("rust-eyeball" ,rust-eyeball-0.8)
        ("rust-futures-util" ,rust-futures-util-0.3)
        ("rust-stream-assert" ,rust-stream-assert-0.1)
        ("rust-tokio" ,rust-tokio-1))))
    (home-page "https://github.com/jplatte/eyeball")
    (synopsis "Helpful utilities for `eyeball-im`")
    (description "Helpful utilities for `eyeball-im`.")
    (license license:mpl2.0)))

(define-public rust-eyre-0.6
  (package
    (name "rust-eyre")
    (version "0.6.12")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "eyre" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1v1a3vb9gs5zkwp4jzkcfnpg0gvyp4ifydzx37f4qy14kzcibnbw"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-indenter" ,rust-indenter-0.3)
                       ("rust-once-cell" ,rust-once-cell-1)
                       ("rust-pyo3" ,rust-pyo3-0.20))
       #:cargo-development-inputs (("rust-anyhow" ,rust-anyhow-1)
                                   ("rust-backtrace" ,rust-backtrace-0.3)
                                   ("rust-futures" ,rust-futures-0.3)
                                   ("rust-pyo3" ,rust-pyo3-0.20)
                                   ("rust-rustversion" ,rust-rustversion-1)
                                   ("rust-syn" ,rust-syn-2)
                                   ("rust-thiserror" ,rust-thiserror-1)
                                   ("rust-trybuild" ,rust-trybuild-1))))
    (native-inputs (list python))
    (home-page "https://github.com/eyre-rs/eyre")
    (synopsis "Trait object based error handling type")
    (description
     "This library provides @code{eyre::Report}, a trait object based error
handling type for easy idiomatic error handling and reporting in Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-faccess-0.2
  (package
    (name "rust-faccess")
    (version "0.2.4")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "faccess" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32 "1m967rz9qknzbqh7l8hga91s32y3p041mbk8w81skmh2b116dbjr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f                  ; Not all files included.
       #:cargo-inputs
       (("rust-bitflags" ,rust-bitflags-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/Freaky/faccess")
    (synopsis "Simple file accessibility checks")
    (description "Simple file accessibility checks in rust.")
    (license license:expat)))

(define-public rust-failure-0.1
  (package
    (name "rust-failure")
    (version "0.1.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "failure" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "11jg1wmbkijrs6bk9fqnbrm9zf0850whnqpgnxyswbn0dk8rnbnk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-backtrace" ,rust-backtrace-0.3)
        ("rust-failure-derive" ,rust-failure-derive-0.1))))
    (home-page "https://rust-lang-nursery.github.io/failure/")
    (synopsis "Experimental error handling abstraction")
    (description
     "Experimental error handling abstraction.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-failure-derive-0.1
  (package
    (name "rust-failure-derive")
    (version "0.1.8")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "failure_derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1936adqqk080439kx2bjf1bds7h89sg6wcif4jw0syndcv3s6kda"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1)
        ("rust-synstructure" ,rust-synstructure-0.12))
       #:cargo-development-inputs
       (("rust-failure" ,rust-failure-0.1))))
    (home-page "https://rust-lang-nursery.github.io/failure/")
    (synopsis "Derives for the failure crate")
    (description "Derives for the failure crate.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-fake-simd-0.1
  (package
    (name "rust-fake-simd")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fake-simd" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1vfylvk4va2ivqx85603lyqqp0zk52cgbs4n5nfbbbqx577qm2p8"))))
    (build-system cargo-build-system)
    (arguments `(#:skip-build? #t))
    (home-page "https://github.com/RustCrypto/utils")
    (synopsis "Crate for mimicking simd crate on stable Rust")
    (description
     "Crate for mimicking simd crate on stable Rust.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-fakeit-1
  (package
    (name "rust-fakeit")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fakeit" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "057155zak9jx127jv5mlaw4kvpsj795fxmzsgg3j9mh5yxz6c9kr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-libmath" ,rust-libmath-0.2)
                       ("rust-rand" ,rust-rand-0.6)
                       ("rust-simplerand" ,rust-simplerand-1)
                       ("rust-uuid" ,rust-uuid-0.8))))
    (home-page "https://github.com/PumpkinSeed/fakeit")
    (synopsis "Fake data generator")
    (description "Fake data generator library with 130+ functions.")
    (license license:expat)))

(define-public rust-fallible-collections-0.5
  (package
    (name "rust-fallible-collections")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fallible_collections" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0x6zmjkmr5ps2riylrrdvnds85qd3i31jmcjvghs76s19p8qaglb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-hashbrown" ,rust-hashbrown-0.14))))
    (home-page "https://github.com/vcombey/fallible_collections")
    (synopsis "Fallible collections implementation in Rust")
    (description "This library extends the Rust standard collections to return
a result when an allocation error occurs, ala
@url{https://github.com/rust-lang/rfcs/blob/master/text/2116-alloc-me-maybe.md,
RFC 2116}.  The API currently proposes a fallible interface for @code{Vec},
@code{Box}, @code{Arc}, @code{Btree} and @code{Rc}, as well as a
@code{TryClone} trait which is implemented for primitive Rust traits and a
fallible format macro.")
    (license (list license:expat license:asl2.0))))

(define-public rust-fallible-collections-0.4
  (package
    (inherit rust-fallible-collections-0.5)
    (name "rust-fallible-collections")
    (version "0.4.9")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fallible_collections" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1zf6ir26qbdwlywv9m266n19p6yzqqmi968qy8njc58aiiv6k358"))))
    (arguments
     `(#:cargo-inputs (("rust-hashbrown" ,rust-hashbrown-0.13))))))

(define-public rust-fallible-iterator-0.3
  (package
    (name "rust-fallible-iterator")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fallible-iterator" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0ja6l56yka5vn4y4pk6hn88z0bpny7a8k1919aqjzp0j1yhy9k1a"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/sfackler/rust-fallible-iterator")
    (synopsis "Fallible iterator traits")
    (description "If the @code{std} or @code{alloc} features are enabled, this
crate provides implementations for @code{Box}, @code{Vec}, @code{BTreeMap}, and
@code{BTreeSet}.  If the @code{std} feature is enabled, this crate additionally
provides implementations for @code{HashMap} and @code{HashSet}.")
    (license (list license:expat license:asl2.0))))

(define-public rust-fallible-iterator-0.2
  (package
    (inherit rust-fallible-iterator-0.3)
    (name "rust-fallible-iterator")
    (version "0.2.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fallible-iterator" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32 "1xq759lsr8gqss7hva42azn3whgrbrs2sd9xpn92c5ickxm1fhs4"))))))

(define-public rust-fallible-streaming-iterator-0.1
  (package
    (name "rust-fallible-streaming-iterator")
    (version "0.1.9")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fallible-streaming-iterator" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0nj6j26p71bjy8h42x6jahx1hn0ng6mc2miwpgwnp8vnwqf4jq3k"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/sfackler/fallible-streaming-iterator")
    (synopsis "Fallible streaming iteration")
    (description "Fallible streaming iteration")
    (license (list license:expat license:asl2.0))))

(define-public rust-fancy-regex-0.14
  (package
    (name "rust-fancy-regex")
    (version "0.14.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fancy-regex" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "162j2qx2ikgl79grq12mawyflwkirnjzrvxh11a1xbmwjidcn93f"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-bit-set" ,rust-bit-set-0.8)
                       ("rust-regex-automata" ,rust-regex-automata-0.4)
                       ("rust-regex-syntax" ,rust-regex-syntax-0.8))
       #:cargo-development-inputs (("rust-criterion" ,rust-criterion-0.5)
                                   ("rust-matches" ,rust-matches-0.1)
                                   ("rust-quickcheck" ,rust-quickcheck-1)
                                   ("rust-regex" ,rust-regex-1))))
    (home-page "https://github.com/fancy-regex/fancy-regex")
    (synopsis "Implementation of regexes with a rich set of features")
    (description
     "This package is a Rust library for compiling and matching regular
expressions.  It uses a hybrid regex implementation designed to support
a relatively rich set of features.  In particular, it uses backtracking to
implement features such as look-around and backtracking, which are not
supported in purely NFA-based implementations.")
    (license license:expat)))

(define-public rust-fancy-regex-0.13
  (package
    (inherit rust-fancy-regex-0.14)
    (name "rust-fancy-regex")
    (version "0.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fancy-regex" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1wjbqjsdj8fkq6z2i9llq25iaqzd9f208vxnwg8mdbr2ba1lc7jk"))))
    (arguments
     `(#:cargo-inputs (("rust-bit-set" ,rust-bit-set-0.5)
                       ("rust-regex-automata" ,rust-regex-automata-0.4)
                       ("rust-regex-syntax" ,rust-regex-syntax-0.8))
       #:cargo-development-inputs (("rust-criterion" ,rust-criterion-0.5)
                                   ("rust-matches" ,rust-matches-0.1)
                                   ("rust-quickcheck" ,rust-quickcheck-1)
                                   ("rust-regex" ,rust-regex-1))))))

(define-public rust-fancy-regex-0.11
  (package
    (inherit rust-fancy-regex-0.13)
    (name "rust-fancy-regex")
    (version "0.11.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fancy-regex" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "18j0mmzfycibhxhhhfja00dxd1vf8x5c28lbry224574h037qpxr"))))
    (arguments
     `(#:cargo-inputs (("rust-bit-set" ,rust-bit-set-0.5)
                       ("rust-regex" ,rust-regex-1))
       #:cargo-development-inputs (("rust-criterion" ,rust-criterion-0.3)
                                   ("rust-matches" ,rust-matches-0.1)
                                   ("rust-quickcheck" ,rust-quickcheck-1))))))

(define-public rust-fancy-regex-0.10
  (package
    (inherit rust-fancy-regex-0.14)
    (name "rust-fancy-regex")
    (version "0.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fancy-regex" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0rn7wfihsk877h3kwzzm99ykflfkhg039l4synm9algs8qnsny06"))
       (modules '((guix build utils)))
       (snippet
        '(begin (substitute* "Cargo.toml"
                  (("\"= ?([[:digit:]]+(\\.[[:digit:]]+)*)" _ version)
                   (string-append "\"^" version)))))))
    (arguments
     (list #:cargo-inputs
           (list rust-bit-set-0.5
                 rust-regex-1)
           #:cargo-development-inputs
           (list rust-bitflags-1
                 rust-criterion-0.3
                 rust-half-1
                 rust-matches-0.1
                 rust-quickcheck-1)))))

(define-public rust-fancy-regex-0.7
  (package
    (inherit rust-fancy-regex-0.11)
    (name "rust-fancy-regex")
    (version "0.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fancy-regex" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1krwc8mbj8zv4ahvh3lqkmfxf38cg79ya02by19fn4jil1h8aswx"))))
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-bit-set" ,rust-bit-set-0.5)
        ("rust-regex" ,rust-regex-1))))))

(define-public rust-fast-chemail-0.9
  (package
    (name "rust-fast-chemail")
    (version "0.9.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fast_chemail" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1r79x2i7bhk8y4nv7q245dlifxryszmby4k3psm2qk321p9kjnj9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-ascii-utils" ,rust-ascii-utils-0.9))))
    (home-page "https://gitlab.com/fast_chemail/fast_chemail-rs")
    (synopsis "Check email address")
    (description "Fast Chemail is a library used to validate the email as it
is defined in the HTML specification.")
    (license license:mpl2.0)))

(define-public rust-fast-float-0.2
  (package
    (name "rust-fast-float")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fast-float" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0g7kfll3xyh99kc7r352lhljnwvgayxxa6saifb6725inikmyxlm"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-development-inputs (("rust-fastrand" ,rust-fastrand-1)
                                   ("rust-hexf-parse" ,rust-hexf-parse-0.1)
                                   ("rust-lexical-core" ,rust-lexical-core-0.7)
                                   ("rust-num-bigint" ,rust-num-bigint-0.3)
                                   ("rust-ryu" ,rust-ryu-1))))
    (home-page "https://github.com/aldanor/fast-float-rust")
    (synopsis "Fast floating-point number parser")
    (description "This package provides a fast floating-point number parser.")
    (license (list license:expat license:asl2.0))))

(define-public rust-faster-hex-0.9
  (package
    (name "rust-faster-hex")
    (version "0.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "faster-hex" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "10wi4vqbdpkamw4qvra1ijp4as2j7j1zc66g4rdr6h0xv8gb38m2"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs (("rust-bytes" ,rust-bytes-1)
                                   ("rust-criterion" ,rust-criterion-0.3)
                                   ("rust-hex" ,rust-hex-0.3)
                                   ("rust-proptest" ,rust-proptest-1)
                                   ("rust-rustc-hex" ,rust-rustc-hex-1)
                                   ("rust-serde" ,rust-serde-1)
                                   ("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/NervosFoundation/faster-hex")
    (synopsis "Fast hex encoding")
    (description "Fast hex encoding.")
    (license license:expat)))

(define-public rust-faster-hex-0.8
  (package
    (inherit rust-faster-hex-0.9)
    (name "rust-faster-hex")
    (version "0.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "faster-hex" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "12ikld53h5d682rn1j85d77n90pq4vy5mncwdaqhm0hgjgxpp7r3"))))
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-bytes" ,rust-bytes-1)
        ("rust-criterion" ,rust-criterion-0.3)
        ("rust-hex" ,rust-hex-0.3)
        ("rust-proptest" ,rust-proptest-1)
        ("rust-rustc-hex" ,rust-rustc-hex-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1))))))

(define-public rust-fasthash-0.4
  (package
    (name "rust-fasthash")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fasthash" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "03v9g4ajw0zk9pv2ranq65xcly1b68hg0qzc2y8y1ajfdfa168h3"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-cfg-if" ,rust-cfg-if-0.1)
                       ("rust-fasthash-sys" ,rust-fasthash-sys-0.3)
                       ("rust-num-traits" ,rust-num-traits-0.2)
                       ("rust-seahash" ,rust-seahash-3)
                       ("rust-xoroshiro128" ,rust-xoroshiro128-0.3))))
    (home-page "https://github.com/flier/rust-fasthash")
    (synopsis "Suite of non-cryptographic hash functions for Rust")
    (description
     "This package provides a suite of non-cryptographic hash functions for
Rust.")
    (license license:asl2.0)))

(define-public rust-fasthash-sys-0.3
  (package
    (name "rust-fasthash-sys")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fasthash-sys" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1y18v8yya5pnzgfji9lwnrz5jl7q8q2xj2a0sg6ibrz2pwd99pmn"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-bindgen" ,rust-bindgen-0.37)
                       ("rust-gcc" ,rust-gcc-0.3))))
    (home-page "https://github.com/flier/rust-fasthash")
    (synopsis "Suite of non-cryptographic hash functions for Rust")
    (description
     "This package provides a suite of non-cryptographic hash functions for
Rust.")
    (license license:asl2.0)))

(define-public rust-fastq-0.6
  (package
    (name "rust-fastq")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fastq" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "177jsfabnk3zl5zml6qvidzjpk53dp62rqjbdhbhr8cg7ms59p60"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-build-flags '("-vv")
       #:phases
       (modify-phases %standard-phases
         ;; This is needed for the parasail-sys package.
         (add-after 'unpack 'set-shell-for-configure-script
           (lambda _
             (setenv "SHELL" (which "sh"))
             (setenv "CONFIG_SHELL" (which "sh")))))
       #:cargo-inputs
       (("rust-flate2" ,rust-flate2-1)
        ("rust-lz4" ,rust-lz4-1)
        ("rust-memchr" ,rust-memchr-2))
       #:cargo-development-inputs
       (("rust-bio" ,rust-bio-0.33)
        ("rust-parasailors" ,rust-parasailors-0.3))))
    (inputs
     (list zlib))
    (native-inputs
     (list libtool))
    (home-page "https://github.com/aseyboldt/fastq-rs")
    (synopsis "Parser for fastq files")
    (description "This package provides a parser for fastq files.")
    (license license:expat)))

(define-public rust-fastrand-2
  (package
    (name "rust-fastrand")
    (version "2.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fastrand" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ghiahsw1jd68df895cy5h3gzwk30hndidn3b682zmshpgmrx41p"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-getrandom" ,rust-getrandom-0.2))
       #:cargo-development-inputs
       (("rust-getrandom" ,rust-getrandom-0.2)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.3)
        ("rust-wyhash" ,rust-wyhash-0.5))))
    (home-page "https://github.com/smol-rs/fastrand")
    (synopsis "Simple and fast random number generator")
    (description
     "This package provides a simple and fast random number generator.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-fastrand-1
  (package
    (inherit rust-fastrand-2)
    (name "rust-fastrand")
    (version "1.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fastrand" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1gh12m56265ihdbzh46bhh0jf74i197wm51jg1cw75q7ggi96475"))))
    (arguments
     `(#:cargo-inputs
       (("rust-instant" ,rust-instant-0.1))
       #:cargo-development-inputs
       (("rust-getrandom" ,rust-getrandom-0.2)
        ("rust-instant" ,rust-instant-0.1)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-wasm-bindgen-test" ,rust-wasm-bindgen-test-0.3)
        ("rust-wyhash" ,rust-wyhash-0.5))))))

(define-public rust-fd-lock-4
  (package
    (name "rust-fd-lock")
    (version "4.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fd-lock" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0ixrsd19k2cpl773p9hd0yk3hac684d9aphbxy0jq9q64bd6hmvy"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-cfg-if" ,rust-cfg-if-1)
                       ("rust-rustix" ,rust-rustix-0.38)
                       ("rust-windows-sys" ,rust-windows-sys-0.52))
       #:cargo-development-inputs (("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/yoshuawuyts/fd-lock")
    (synopsis "Advisory lock on a file")
    (description "Fd-lock provides an advisory lock on a file using a file
descriptor to it.")
    (license (list license:expat license:asl2.0))))

(define-public rust-fd-lock-3
  (package
    (inherit rust-fd-lock-4)
    (name "rust-fd-lock")
    (version "3.0.13")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fd-lock" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1df1jdncda67g65hrnmd2zsl7q5hdn8cm84chdalxndsx7akw0zg"))))
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-rustix" ,rust-rustix-0.38)
        ("rust-windows-sys" ,rust-windows-sys-0.48))
       #:cargo-development-inputs (("rust-tempfile" ,rust-tempfile-3))))))

(define-public rust-fdlimit-0.1
  (package
    (name "rust-fdlimit")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fdlimit" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0g30d6gqkrwy8ylwdy7pqm443iq0p5dmnpz4ks41pirl7dclm98d"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-libc" ,rust-libc-0.2))))
    (home-page "https://github.com/paritytech/fdlimit")
    (synopsis "Utility crate for raising file descriptors limit")
    (description "This package provides a Rust library to raise file
descriptors limit.")
    (license license:asl2.0)))

(define-public rust-feature-probe-0.1
  (package
    (name "rust-feature-probe")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "feature-probe" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1nhif9zpr2f17gagf0qb0v914wc3jr9sfjzvnpi7b7pcs73ksnl3"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/tov/feature-probe-rs")
    (arguments
     `(#:tests? #f))        ; Tests don't compile
    (synopsis "Probe for rustc features from build.rs")
    (description "To support multiple versions of Rust, it's often necessary
to conditionally compile parts of our libraries or programs.  It's possible to
allow users to specify what features to enable, but detection is better,
because users get all the features that their version of Rust supports.  And
while we could check the rustc version, it's better to probe for individual
features.  This package probes for rustc features from build.rs.")
    (license (list license:expat license:asl2.0))))

(define-public rust-feed-rs-0.6
  (package
    (name "rust-feed-rs")
    (version "0.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "feed-rs" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1a1ain6r9k8bx7cz9pxqh3hdqbn8cqdkrbx78c8rxb7vqngyg53z"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-mime" ,rust-mime-0.3)
        ("rust-quick-xml" ,rust-quick-xml-0.20)
        ("rust-regex" ,rust-regex-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-siphasher" ,rust-siphasher-0.3)
        ("rust-url" ,rust-url-2)
        ("rust-uuid" ,rust-uuid-0.8))))
    (home-page "https://github.com/feed-rs/feed-rs")
    (synopsis "Unified feed parser")
    (description "This package provides a unified feed parser that handles
Atom, RSS 2.0, RSS 1.0, RSS 0.x and JSON Feed")
    (license license:expat)))

(define-public rust-feedbin-api-0.1
  (package
    (name "rust-feedbin-api")
    (version "0.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "feedbin_api" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "170xf3cgsqgqpnafpdmzzw9yvzc51r22lgr4f4hcrmidxlxpmlkp"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f ;tests use the network
       #:cargo-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-failure" ,rust-failure-0.1)
        ("rust-reqwest" ,rust-reqwest-0.11)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-url" ,rust-url-2))
       #:cargo-development-inputs
       (("rust-dotenv" ,rust-dotenv-0.15)
        ("rust-rand" ,rust-rand-0.8)
        ("rust-tokio" ,rust-tokio-1))))
    (native-inputs
     (list pkg-config))
    (inputs
     (list openssl))
    (home-page "https://gitlab.com/news-flash/feedbin_api")
    (synopsis  "Rust implementation of the Feedbin REST API")
    (description
     "This package provides a Rust implementation of the Feedbin REST API.")
    (license license:unlicense)))

(define-public rust-feedly-api-0.4
  (package
    (name "rust-feedly-api")
    (version "0.4.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "feedly_api" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1knad1bghc8hhfcyl35fcnhrk01vklamq07630rdk0pg6ax04swi"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f ;tests open external connections
       #:cargo-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-failure" ,rust-failure-0.1)
        ("rust-log" ,rust-log-0.4)
        ("rust-percent-encoding"
         ,rust-percent-encoding-2)
        ("rust-reqwest" ,rust-reqwest-0.11)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-url" ,rust-url-2))
       #:cargo-development-inputs
       (("rust-dotenv" ,rust-dotenv-0.15)
        ("rust-tokio" ,rust-tokio-1))))
    (native-inputs
     (list pkg-config))
    (inputs
     (list openssl))
    (home-page "https://gitlab.com/news-flash/feedly_api")
    (synopsis "Rust implementation of the feedly REST API")
    (description
     "This package provides a Rust implementation of the feedly REST API.")
    ;; No copyright headers in the source code.  LICENSE indicates gpl3.
    (license license:gpl3)))

(define-public rust-femme-2
  (package
    (name "rust-femme")
    (version "2.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "femme" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1vqk8sjnc4qw51a816kppwirf2dkj6rfdnjjsm92kap3b8g8f16c"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-js-sys" ,rust-js-sys-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2)
        ("rust-web-sys" ,rust-web-sys-0.3))
       #:cargo-development-inputs
       (("rust-kv-log-macro" ,rust-kv-log-macro-1))))
    (home-page "https://github.com/lrlna/femme")
    (synopsis "Pretty-printer and @code{ndjson} logger for @code{log} crate")
    (description
     "This package provides a pretty-printer and @code{ndjson} logger for
@code{log} crate.")
    (license (list license:expat license:asl2.0))))

(define-public rust-femme-1
  (package
    (inherit rust-femme-2)
    (name "rust-femme")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "femme" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0spf66m22dvnz6x077znybk906lh4p5z30nh8c37mad2c3dc56jd"))))
    (arguments
     `(#:tests? #false
       #:cargo-inputs
       (("rust-async-log" ,rust-async-log-1)
        ("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-console" ,rust-console-0.7)
        ("rust-js-sys" ,rust-js-sys-0.3)
        ("rust-log" ,rust-log-0.4)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-wasm-bindgen" ,rust-wasm-bindgen-0.2)
        ("rust-web-sys" ,rust-web-sys-0.3))))))

(define-public rust-fern-0.6
  (package
    (name "rust-fern")
    (version "0.6.2")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fern" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "1vpinainw32498p0zydmxc24yd3r6479pmhdfb429mfbji3c3w6r"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-chrono" ,rust-chrono-0.4)
        ("rust-colored" ,rust-colored-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-log" ,rust-log-0.4)
        ("rust-reopen" ,rust-reopen-0.3)
        ("rust-reopen" ,rust-reopen-1)
        ("rust-syslog" ,rust-syslog-3)
        ("rust-syslog" ,rust-syslog-4)
        ("rust-syslog" ,rust-syslog-6))
       #:cargo-development-inputs
       (("rust-clap" ,rust-clap-2)
        ("rust-humantime" ,rust-humantime-2)
        ("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/daboross/fern")
    (synopsis "Simple, efficient logging")
    (description
     "This package provides a simple, efficient logging system for Rust.")
    (license license:expat)))

(define-public rust-fetch-data-0.2
  (package
    (name "rust-fetch-data")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fetch-data" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1wjjb3l37kdvvq3pv93cxlxxr2pc7kx0ssk2gqispw5bhggnlyda"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs (("rust-anyinput" ,rust-anyinput-0.1)
                       ("rust-base16ct" ,rust-base16ct-0.2)
                       ("rust-ctor" ,rust-ctor-0.2)
                       ("rust-directories" ,rust-directories-5)
                       ("rust-getrandom" ,rust-getrandom-0.2)
                       ("rust-sha2" ,rust-sha2-0.10)
                       ("rust-temp-testdir" ,rust-temp-testdir-0.2)
                       ("rust-thiserror" ,rust-thiserror-1)
                       ("rust-ureq" ,rust-ureq-2))))
    (home-page "https://github.com/CarlKCarlK/fetch-data")
    (synopsis "Fetch data files from a URL")
    (description
     "This package lets you fetch data files from a URL, but only if needed.
It verifies contents via SHA256 and provides some Python Pooch
compatibility.")
    (license (list license:expat license:asl2.0))))

(define-public rust-fetch-unroll-0.3
  (package
    (name "rust-fetch-unroll")
    (version "0.3.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "fetch_unroll" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1l3cf8fhcrw354hdmjf03f5v4bxgn2wkjna8n0fn8bgplh8b3666"))))
    (build-system cargo-build-system)
    (arguments
     (list #:tests? #f  ; Tries to connect to github.com
           #:cargo-inputs `(("rust-libflate" ,rust-libflate-1)
                            ("rust-tar" ,rust-tar-0.4)
                            ("rust-ureq" ,rust-ureq-2))))
    (home-page "https://github.com/katyo/fetch_unroll")
    (synopsis "Simple utilities for fetching and unrolling .tar.gz archives")
    (description
     "Simple utilities for fetching and unrolling .tar.gz archives.")
    (license license:asl2.0)))

(define-public rust-fever-api-0.2
  (package
    (name "rust-fever-api")
    (version "0.2.11")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fever_api" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0pv4g241pc0bfwy9gjwsmrdv7mplzbifxr5mxf0k82yxawg55anc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f ;tests use the network
       #:cargo-inputs
       (("rust-failure" ,rust-failure-0.1)
        ("rust-log" ,rust-log-0.4)
        ("rust-md5" ,rust-md5-0.7)
        ("rust-reqwest" ,rust-reqwest-0.11)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-url" ,rust-url-2))
       #:cargo-development-inputs
       (("rust-dotenv" ,rust-dotenv-0.15)
        ("rust-tokio" ,rust-tokio-1))))
    (native-inputs
     (list pkg-config))
    (inputs
     (list openssl))
    (home-page "https://gitlab.com/news-flash/fever_api")
    (synopsis "Rust implementation of the Fever API")
    (description
     "This package provides a Rust implementation of the Fever API.")
    ;; No copyright headers in the source code.  LICENSE indicates gpl3.
    (license license:gpl3)))

(define-public rust-ff-0.13
  (package
    (name "rust-ff")
    (version "0.13.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "ff" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0jcl8yhcs5kbfxfpnrhpkkvnk7s666vly6sgawg3nri9nx215m6y"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bitvec" ,rust-bitvec-1)
        ("rust-byteorder" ,rust-byteorder-1)
        ("rust-ff-derive" ,rust-ff-derive-0.13)
        ("rust-rand-core" ,rust-rand-core-0.6)
        ("rust-subtle" ,rust-subtle-2))
       #:cargo-development-inputs
       (("rust-blake2b-simd" ,rust-blake2b-simd-1)
        ("rust-rand" ,rust-rand-0.8))))
    (home-page "https://github.com/zkcrypto/ff")
    (synopsis "Library for building and interfacing with finite fields")
    (description "This package provides a rust library for building and
interfacing with finite fields.")
    (license (list license:expat license:asl2.0))))

(define-public rust-ff-0.12
  (package
    (inherit rust-ff-0.13)
    (name "rust-ff")
    (version "0.12.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ff" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0q3imz4m3dj2cy182i20wa8kbclgj13ddfngqb2miicc6cjzq4yh"))))
    (arguments
     `(#:cargo-inputs (("rust-bitvec" ,rust-bitvec-1)
                       ("rust-byteorder" ,rust-byteorder-1)
                       ("rust-ff-derive" ,rust-ff-derive-0.12)
                       ("rust-rand-core" ,rust-rand-core-0.6)
                       ("rust-subtle" ,rust-subtle-2))
       #:cargo-development-inputs (("rust-rand" ,rust-rand-0.8))))))

(define-public rust-ff-derive-0.13
  (package
    (name "rust-ff-derive")
    (version "0.13.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "ff_derive" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0jnq13qqmnvgh1xmjzdgynwgbbkf64qibqf5a5hjiva5pq24gxg9"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-addchain" ,rust-addchain-0.2)
        ("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-num-bigint" ,rust-num-bigint-0.3)
        ("rust-num-integer" ,rust-num-integer-0.1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))))
    (home-page "https://github.com/zkcrypto/ff")
    (synopsis
     "Procedural macro library used to build custom prime field implementations")
    (description
     "This package provides a procedural macro library used to build custom
prime field implementations in rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-ff-derive-0.12
  (package
    (inherit rust-ff-derive-0.13)
    (name "rust-ff-derive")
    (version "0.12.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "ff_derive" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0jvqilpzzbw3j3sh1sf0914n2l4v020iifmgvglnc7wgfjh6znqp"))))
    (arguments
     `(#:cargo-inputs (("rust-addchain" ,rust-addchain-0.2)
                       ("rust-cfg-if" ,rust-cfg-if-1)
                       ("rust-num-bigint" ,rust-num-bigint-0.3)
                       ("rust-num-integer" ,rust-num-integer-0.1)
                       ("rust-num-traits" ,rust-num-traits-0.2)
                       ("rust-proc-macro2" ,rust-proc-macro2-1)
                       ("rust-quote" ,rust-quote-1)
                       ("rust-syn" ,rust-syn-1))))))

(define-public rust-field-offset-0.3
  (package
    (name "rust-field-offset")
    (version "0.3.6")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "field-offset" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0zq5sssaa2ckmcmxxbly8qgz3sxpb8g1lwv90sdh1z74qif2gqiq"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-memoffset" ,rust-memoffset-0.9)
        ("rust-rustc-version" ,rust-rustc-version-0.4))))
    (home-page "https://github.com/Diggsey/rust-field-offset")
    (synopsis "Safe pointer-to-member implementation")
    (description "This package provides safe pointer-to-member implementation.")
    (license (list license:expat license:asl2.0))))

(define-public rust-figment-0.10
  (package
    (name "rust-figment")
    (version "0.10.19")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "figment" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ww9sxdzjj2i80w7bq0kllnymjyrfb1cdx2h70ap5wqcdga1rc4c"))))
    (build-system cargo-build-system)
    (arguments
     `(#:tests? #f      ; unresolved import `crate::providers::Toml`
       #:cargo-inputs (("rust-atomic" ,rust-atomic-0.6)
                       ("rust-parking-lot" ,rust-parking-lot-0.12)
                       ("rust-pear" ,rust-pear-0.2)
                       ("rust-serde" ,rust-serde-1)
                       ("rust-serde-json" ,rust-serde-json-1)
                       ("rust-serde-yaml" ,rust-serde-yaml-0.9)
                       ("rust-tempfile" ,rust-tempfile-3)
                       ("rust-toml" ,rust-toml-0.8)
                       ("rust-uncased" ,rust-uncased-0.9)
                       ("rust-version-check" ,rust-version-check-0.9))
       #:cargo-development-inputs (("rust-clap" ,rust-clap-4)
                                   ("rust-parking-lot" ,rust-parking-lot-0.12)
                                   ("rust-serde" ,rust-serde-1)
                                   ("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/SergioBenitez/Figment")
    (synopsis "Configuration library")
    (description "This package provides an opinionated configuration library.")
    (license (list license:expat license:asl2.0))))

(define-public rust-file-diff-1
  (package
    (name "rust-file-diff")
    (version "1.0.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "file_diff" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "19a34rvbqg3b2my6ykax5n1qi2ahwbjacn9y2ji3h9gkp04ak9ri"))))
    (build-system cargo-build-system)
    (home-page "https://github.com/ethanpailes/file_diff-rs")
    (synopsis "Atomic utility for diffing files in testing")
    (description "An atomic utility for diffing files in testing.")
    (license license:bsd-3)))

(define-public rust-file-id-0.2
  (package
    (name "rust-file-id")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "file-id" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0dmylm34z6g8cg3b60sc6bk9v5wv9930vyx9wgcdpjpgpfwh9jbb"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-serde" ,rust-serde-1)
                       ("rust-windows-sys" ,rust-windows-sys-0.52))
       #:cargo-development-inputs (("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/notify-rs/notify")
    (synopsis
     "Utility for reading inode numbers (Linux, MacOS) and file IDs (Windows)")
    (description
     "This package provides a utility for reading inode numbers (Linux,
@code{MacOS}) and file IDs (Windows).")
    (license (list license:expat license:asl2.0))))

(define-public rust-filedescriptor-0.8
  (package
    (name "rust-filedescriptor")
    (version "0.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "filedescriptor" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0vplyh0cw35kzq7smmp2ablq0zsknk5rkvvrywqsqfrchmjxk6bi"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-libc" ,rust-libc-0.2)
        ("rust-thiserror" ,rust-thiserror-1)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/wez/wezterm")
    (synopsis "More ergonomic wrappers around RawFd and RawHandle")
    (description
     "More ergonomic wrappers around @code{RawFd} and @code{RawHandle}.")
    (license license:expat)))

(define-public rust-filename-0.1
  (package
    (name "rust-filename")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "filename" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1s7byy8c939qrm6hsjqq0vicfv6rkxb3yrhslg7zkggyxw1xzr33"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-libc" ,rust-libc-0.2)
                       ("rust-winapi" ,rust-winapi-0.3))
       #:cargo-development-inputs (("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/flier/rust-filename")
    (synopsis "Get filename from a raw file descriptor")
    (description
     "This package provides a way to get the filename from a raw file descriptor.")
    (license license:expat)))

(define-public rust-filesize-0.2
  (package
    (name "rust-filesize")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "filesize" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0hvx4dfnara3a2dnhb9ci5bmm1m8s44h9l61s5djwkjx87i43mqj"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/Freaky/rust-filesize")
    (synopsis "Find the physical space used by a file")
    (description
     "@code{filesize} abstracts platform-specific methods of determining the
real space used by files, taking into account file system compression and
sparse files.")
    (license license:expat)))

(define-public rust-filetime-0.2
  (package
    (name "rust-filetime")
    (version "0.2.25")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "filetime" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "11l5zr86n5sr6g6k6sqldswk0jzklm0q95rzikxcns0yk0p55h1m"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-libredox" ,rust-libredox-0.1)
        ("rust-windows-sys" ,rust-windows-sys-0.59))
       #:cargo-development-inputs
       (("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/alexcrichton/filetime")
    (synopsis "Platform-agnostic accessors of timestamps in File metadata")
    (description
     "This library contains a helper library for inspecting and setting the
various timestamps of files in Rust.  This library takes into account
cross-platform differences in terms of where the timestamps are located, what
they are called, and how to convert them into a platform-independent
representation.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-filetime-0.1
  (package
    (inherit rust-filetime-0.2)
    (name "rust-filetime")
    (version "0.1.15")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "filetime" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "03xishfxzpr4nfz4g3r218d6b6g94rxsqw9pw96m6wa8wgrm6iki"))))
    (build-system cargo-build-system)
    (arguments
     `(#:skip-build? #t
       #:cargo-inputs
       (("rust-cfg-if" ,rust-cfg-if-0.1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-redox-syscall" ,rust-redox-syscall-0.1))))))

(define-public rust-filetime-creation-0.1
  (package
    (name "rust-filetime-creation")
    (version "0.1.7")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "filetime_creation" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "10vk0zwwr91qypkkrhshvlw2zgjfyxhy29d5p15b8wrv5493n9sd"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-cfg-if" ,rust-cfg-if-1)
                       ("rust-filetime" ,rust-filetime-0.2)
                       ("rust-windows-sys" ,rust-windows-sys-0.52))
       #:cargo-development-inputs (("rust-tempfile" ,rust-tempfile-3))))
    (home-page "https://github.com/czy-29/filetime_creation")
    (synopsis "Enhanced version of filetime")
    (description
     "This package provides an enhanced version of filetime, which can set file
creation time on Windows before Rust 1.75.")
    (license (list license:expat license:asl2.0))))

(define-public rust-filetreelist-0.5
  (package
    (name "rust-filetreelist")
    (version "0.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "filetreelist" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "0j7s58lxg28kq39156n17qbf1iygkn7bxgi2xs99wz706syymyg8"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-thiserror" ,rust-thiserror-1))
       #:cargo-development-inputs
       (("rust-pretty-assertions" ,rust-pretty-assertions-1))))
    (home-page "https://github.com/extrawurst/gitui")
    (synopsis "Filetree abstraction")
    (description
     "Filetree abstraction based on a sorted path list, supports key based
navigation events, folding, scrolling and more.")
    (license license:expat)))

(define-public rust-find-crate-0.6
  (package
    (name "rust-find-crate")
    (version "0.6.3")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "find-crate" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1ljpkh11gj7940xwz47xjhsvfbl93c2q0ql7l2v0w77amjx8paar"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-toml" ,rust-toml-0.5))
       #:cargo-development-inputs (("rust-proc-macro2" ,rust-proc-macro2-1)
                                   ("rust-quote" ,rust-quote-1)
                                   ("rust-semver" ,rust-semver-0.11))))
    (home-page "https://github.com/taiki-e/find-crate")
    (synopsis "Find the crate name from the current @code{Cargo.toml}")
    (description
     "This package provides finding the crate name from the current
@code{Cargo.toml}.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-find-cuda-helper-0.2
  (package
    (name "rust-find-cuda-helper")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "find_cuda_helper" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "1bdxg8bmcqvnxb43y6bn2xnhszyi9bm0kndagp3iml1xb5ffdygr"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-glob" ,rust-glob-0.3))))
    (home-page "https://github.com/Rust-GPU/Rust-CUDA")
    (synopsis "Helper crate for searching for CUDA libraries")
    (description "Helper crate for searching for CUDA libraries.")
    (license (list license:expat license:asl2.0))))

(define-public rust-findshlibs-0.10
  (package
    (name "rust-findshlibs")
    (version "0.10.2")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "findshlibs" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "0r3zy2r12rxzwqgz53830bk38r6b7rl8kq2br9n81q7ps2ffbfa0"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-cc" ,rust-cc-1)
        ("rust-lazy-static" ,rust-lazy-static-1)
        ("rust-libc" ,rust-libc-0.2)
        ("rust-winapi" ,rust-winapi-0.3))))
    (home-page "https://github.com/gimli-rs/findshlibs")
    (synopsis "Find the set of shared libraries loaded in the current process")
    (description
     "Find the set of shared libraries loaded in the current process with a
cross platform API.")
    (license (list license:asl2.0
                   license:expat))))

(define-public rust-finl-unicode-1
  (package
    (name "rust-finl-unicode")
    (version "1.3.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "finl_unicode" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32 "0qy1rwjxkqbl6g8ngm2p33y83r4mbfk3l22075yv6vlh4nsp1jcl"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-bstr" ,rust-bstr-1)
        ("rust-criterion" ,rust-criterion-0.5)
        ("rust-unicode-categories" ,rust-unicode-categories-0.1)
        ("rust-unicode-segmentation" ,rust-unicode-segmentation-1))))
    (home-page "https://github.com/dahosek/finl_unicode")
    (synopsis "Unicode handling library")
    (description "This package provides a library for handling Unicode
functionality for finl.")
    (license (list license:expat license:asl2.0))))

(define-public rust-fixed-1
  (package
    (name "rust-fixed")
    (version "1.28.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fixed" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32 "0nn85j5x8yzx10q49jdzia4yp6pnasnxpnwh0p9aqr7qkfwf1il5"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-arbitrary" ,rust-arbitrary-1)
        ("rust-az" ,rust-az-1)
        ("rust-borsh" ,rust-borsh-1)
        ("rust-bytemuck" ,rust-bytemuck-1)
        ("rust-half" ,rust-half-1)
        ("rust-num-traits" ,rust-num-traits-0.2)
        ("rust-serde" ,rust-serde-1)
        ("rust-typenum" ,rust-typenum-1))))
    (home-page "https://gitlab.com/tspiteri/fixed")
    (synopsis "Rust fixed-point numbers")
    (description "This package provides fixed-point numbers in Rust.")
    (license (list license:expat license:asl2.0))))

(define-public rust-fixedbitset-0.4
  (package
    (name "rust-fixedbitset")
    (version "0.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "fixedbitset" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32 "101v41amgv5n9h4hcghvrbfk5vrncx1jwm35rn5szv4rk55i7rqc"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs (("rust-serde-json" ,rust-serde-json-1))))
    (home-page "https://github.com/bluss/fixedbitset")
    (synopsis "Simple bitset collection")
    (description "FixedBitSet is a simple bitset collection.")
    (license (list license:expat license:asl2.0))))

(define-public rust-fixedbitset-0.2
  (package
    (inherit rust-fixedbitset-0.4)
    (name "rust-fixedbitset")
    (version "0.2.0")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fixedbitset" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0kg03p777wc0dajd9pvlcnsyrwa8dhqwf0sd9r4dw0p82rs39arp"))))))

(define-public rust-fixedbitset-0.1
  (package
    (inherit rust-fixedbitset-0.2)
    (name "rust-fixedbitset")
    (version "0.1.9")
    (source
      (origin
        (method url-fetch)
        (uri (crate-uri "fixedbitset" version))
        (file-name (string-append name "-" version ".tar.gz"))
        (sha256
         (base32
          "0czam11mi80dbyhf4rd4lz0ihcf7vkfchrdcrn45wbs0h40dxm46"))))))

(define-public rust-flagset-0.4
  (package
    (name "rust-flagset")
    (version "0.4.6")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "flagset" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1v46bj0v8zqw6nnj16vhsmssxm04zj8xv50hnyjjcy1hz32ixsmk"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-serde" ,rust-serde-1))
       #:cargo-development-inputs
       (("rust-serde-json" ,rust-serde-json-1)
        ("rust-serde-repr" ,rust-serde-repr-0.1))))
    (home-page "https://github.com/enarx/flagset")
    (synopsis
     "Data types and a macro for generating enumeration-based bit flags")
    (description "This package provides data types and a macro for generating
enumeration-based bit flags in rust.")
    (license license:asl2.0)))

(define-public rust-flaky-test-0.2
  (package
    (name "rust-flaky-test")
    (version "0.2.2")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "flaky_test" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1nn8hddhl2vaxgfn0j87yrngr9bzlxlncgdd9vy53xyp4cgslv04"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-flaky-test-impl" ,rust-flaky-test-impl-0.2)
        ("rust-future-utils" ,rust-futures-util-0.3))))
    (home-page "https://github.com/denoland/flaky_test")
    (synopsis "Attribute macro for running a flaky test multiple times")
    (description "This package provides an attribute macro for running a flaky
test multiple times.")
    (license license:expat)))

(define-public rust-flaky-test-impl-0.2
  (package
    (name "rust-flaky-test-impl")
    (version "0.2.2")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "flaky_test_impl" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1glshs6wa5n229d4abqzijssy4nslyaiw3xlwpd2ymghq84mkqw5"))))
    (build-system cargo-build-system)
    (arguments
     ;; Tests fail with
     ;; 3 | use flaky_test::flaky_test;
     ;;   |     ^^^^^^^^^^ use of undeclared crate or module `flaky_test`
     `(#:tests? #f
       #:cargo-inputs
       (("rust-proc-macro2" ,rust-proc-macro2-1)
        ("rust-quote" ,rust-quote-1)
        ("rust-syn" ,rust-syn-1))
       #:cargo-development-inputs
       (("rust-flaky-test" ,rust-flaky-test-0.2))))
    (home-page "https://github.com/denoland/flaky_test")
    (synopsis "Implementation details of the @code{flaky_test} macro")
    (description "This package provides mplementation details of the
@code{flaky_test} macro.")
    (license license:expat)))

(define-public rust-flame-0.2
  (package
    (name "rust-flame")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (crate-uri "flame" version))
       (file-name
        (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "0c5bmhyimzxch3pmh0w3z9n57saasgix4bmbbksr9vp1c5j71hhz"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-lazy-static" ,rust-lazy-static-0.2)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-derive" ,rust-serde-derive-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-thread-id" ,rust-thread-id-3))))
    (home-page "https://github.com/llogiq/flame")
    (synopsis "Profiling and flamegraph library")
    (description "A profiling and flamegraph library.")
    (license (list license:asl2.0 license:expat))))

(define-public rust-flamer-0.4
  (package
    (name "rust-flamer")
    (version "0.4.0")
    (source (origin
              (method url-fetch)
              (uri (crate-uri "flamer" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1avszq3fn4ix7p6wjfdkli6fjyxccks1qhzja92a6kpxakd35drn"))))
    (build-system cargo-build-system)
    (arguments
     `(#:cargo-inputs
       (("rust-flame" ,rust-flame-0.2)