/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.wrapper;

import java.io.Closeable;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExclusiveFileAccessManager {
    public static final String LOCK_FILE_SUFFIX = ".lck";
    private final int timeoutMs;
    private final int pollIntervalMs;

    public ExclusiveFileAccessManager(int timeoutMs, int pollIntervalMs) {
        this.timeoutMs = timeoutMs;
        this.pollIntervalMs = pollIntervalMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public <T> T access(File exclusiveFile, Callable<T> task) throws Exception {
        File lockFile = new File(exclusiveFile.getParentFile(), exclusiveFile.getName() + LOCK_FILE_SUFFIX);
        lockFile.getParentFile().mkdirs();
        RandomAccessFile randomAccessFile = null;
        FileChannel channel = null;
        long startAt = System.currentTimeMillis();
        FileLock lock = null;
        while (lock == null && System.currentTimeMillis() < startAt + (long)this.timeoutMs) {
            randomAccessFile = new RandomAccessFile(lockFile, "rw");
            channel = randomAccessFile.getChannel();
            lock = channel.tryLock();
            if (lock != null) continue;
            ExclusiveFileAccessManager.maybeCloseQuietly(channel);
            ExclusiveFileAccessManager.maybeCloseQuietly(randomAccessFile);
            Thread.sleep(this.pollIntervalMs);
        }
        if (lock == null) {
            throw new RuntimeException("Timeout of " + this.timeoutMs + " reached waiting for exclusive access to file: " + exclusiveFile.getAbsolutePath());
        }
        T t = task.call();
        lock.release();
        ExclusiveFileAccessManager.maybeCloseQuietly(channel);
        channel = null;
        ExclusiveFileAccessManager.maybeCloseQuietly(randomAccessFile);
        randomAccessFile = null;
        ExclusiveFileAccessManager.maybeCloseQuietly(channel);
        ExclusiveFileAccessManager.maybeCloseQuietly(randomAccessFile);
        return t;
        {
            catch (Throwable throwable) {
                try {
                    lock.release();
                    ExclusiveFileAccessManager.maybeCloseQuietly(channel);
                    channel = null;
                    ExclusiveFileAccessManager.maybeCloseQuietly(randomAccessFile);
                    randomAccessFile = null;
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    ExclusiveFileAccessManager.maybeCloseQuietly(channel);
                    ExclusiveFileAccessManager.maybeCloseQuietly(randomAccessFile);
                    throw throwable2;
                }
            }
        }
    }

    private static void maybeCloseQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

