/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.codehaus.groovy.tools.stubgenerator

/**
 * GROOVY-4504: Groovy compilation results in warnings in generated code
 *
 * @author Guillaume Laforge
 */
class RedundantCastInStubTest extends StringSourcesStubTestCase {

    @Override
    Map<String, String> provideSources() {
        [
                'Dummy.java': '''
                    public class Dummy {}
                ''',
                
                'some/ClassWithPrimitiveBoolean.groovy': '''
                    package some

                    class ClassWithPrimitiveBoolean {
                        boolean method() { return true }
                    }
                '''
        ]
    }

    @Override
    void verifyStubs() {
        // there shouldn't be a redundant cast like (boolean)false in the generated stub
        // otherwise a warning is emitted by the javac compiler
        assert !stubJavaSourceFor('some.ClassWithPrimitiveBoolean').contains('(boolean)false')
    }
}
