/*
 * CLOUD API
 *
 *  IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
)

// DatacenterPut struct for DatacenterPut
type DatacenterPut struct {
	Properties *DatacenterPropertiesPut `json:"properties"`
	Entities   *DataCenterEntities      `json:"entities,omitempty"`
}

// NewDatacenterPut instantiates a new DatacenterPut object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDatacenterPut(properties DatacenterPropertiesPut) *DatacenterPut {
	this := DatacenterPut{}

	this.Properties = &properties

	return &this
}

// NewDatacenterPutWithDefaults instantiates a new DatacenterPut object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDatacenterPutWithDefaults() *DatacenterPut {
	this := DatacenterPut{}
	return &this
}

// GetProperties returns the Properties field value
// If the value is explicit nil, nil is returned
func (o *DatacenterPut) GetProperties() *DatacenterPropertiesPut {
	if o == nil {
		return nil
	}

	return o.Properties

}

// GetPropertiesOk returns a tuple with the Properties field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *DatacenterPut) GetPropertiesOk() (*DatacenterPropertiesPut, bool) {
	if o == nil {
		return nil, false
	}

	return o.Properties, true
}

// SetProperties sets field value
func (o *DatacenterPut) SetProperties(v DatacenterPropertiesPut) {

	o.Properties = &v

}

// HasProperties returns a boolean if a field has been set.
func (o *DatacenterPut) HasProperties() bool {
	if o != nil && o.Properties != nil {
		return true
	}

	return false
}

// GetEntities returns the Entities field value
// If the value is explicit nil, nil is returned
func (o *DatacenterPut) GetEntities() *DataCenterEntities {
	if o == nil {
		return nil
	}

	return o.Entities

}

// GetEntitiesOk returns a tuple with the Entities field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *DatacenterPut) GetEntitiesOk() (*DataCenterEntities, bool) {
	if o == nil {
		return nil, false
	}

	return o.Entities, true
}

// SetEntities sets field value
func (o *DatacenterPut) SetEntities(v DataCenterEntities) {

	o.Entities = &v

}

// HasEntities returns a boolean if a field has been set.
func (o *DatacenterPut) HasEntities() bool {
	if o != nil && o.Entities != nil {
		return true
	}

	return false
}

func (o DatacenterPut) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Properties != nil {
		toSerialize["properties"] = o.Properties
	}

	if o.Entities != nil {
		toSerialize["entities"] = o.Entities
	}

	return json.Marshal(toSerialize)
}

type NullableDatacenterPut struct {
	value *DatacenterPut
	isSet bool
}

func (v NullableDatacenterPut) Get() *DatacenterPut {
	return v.value
}

func (v *NullableDatacenterPut) Set(val *DatacenterPut) {
	v.value = val
	v.isSet = true
}

func (v NullableDatacenterPut) IsSet() bool {
	return v.isSet
}

func (v *NullableDatacenterPut) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDatacenterPut(val *DatacenterPut) *NullableDatacenterPut {
	return &NullableDatacenterPut{value: val, isSet: true}
}

func (v NullableDatacenterPut) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDatacenterPut) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
