// Code generated by smithy-go-codegen DO NOT EDIT.

package lookoutequipment

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/lookoutequipment/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves information about a specific machine learning model version.
func (c *Client) DescribeModelVersion(ctx context.Context, params *DescribeModelVersionInput, optFns ...func(*Options)) (*DescribeModelVersionOutput, error) {
	if params == nil {
		params = &DescribeModelVersionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeModelVersion", params, optFns, c.addOperationDescribeModelVersionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeModelVersionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeModelVersionInput struct {

	// The name of the machine learning model that this version belongs to.
	//
	// This member is required.
	ModelName *string

	// The version of the machine learning model.
	//
	// This member is required.
	ModelVersion *int64

	noSmithyDocumentSerde
}

type DescribeModelVersionOutput struct {

	// Indicates whether the model version was promoted to be the active version after
	// retraining or if there was an error with or cancellation of the retraining.
	AutoPromotionResult types.AutoPromotionResult

	// Indicates the reason for the AutoPromotionResult . For example, a model might
	// not be promoted if its performance was worse than the active version, if there
	// was an error during training, or if the retraining scheduler was using MANUAL
	// promote mode. The model will be promoted in MANAGED promote mode if the
	// performance is better than the previous model.
	AutoPromotionResultReason *string

	// Indicates the time and date at which the machine learning model version was
	// created.
	CreatedAt *time.Time

	// The configuration is the TargetSamplingRate , which is the sampling rate of the
	// data after post processing by Amazon Lookout for Equipment. For example, if you
	// provide data that has been collected at a 1 second level and you want the system
	// to resample the data at a 1 minute rate before training, the TargetSamplingRate
	// is 1 minute. When providing a value for the TargetSamplingRate , you must attach
	// the prefix "PT" to the rate you want. The value for a 1 second rate is therefore
	// PT1S, the value for a 15 minute rate is PT15M, and the value for a 1 hour rate
	// is PT1H
	DataPreProcessingConfiguration *types.DataPreProcessingConfiguration

	// The Amazon Resource Name (ARN) of the dataset used to train the model version.
	DatasetArn *string

	// The name of the dataset used to train the model version.
	DatasetName *string

	// The date on which the data in the evaluation set began being gathered. If you
	// imported the version, this is the date that the evaluation set data in the
	// source version finished being gathered.
	EvaluationDataEndTime *time.Time

	// The date on which the data in the evaluation set began being gathered. If you
	// imported the version, this is the date that the evaluation set data in the
	// source version began being gathered.
	EvaluationDataStartTime *time.Time

	// The failure message if the training of the model version failed.
	FailedReason *string

	// The date and time when the import job completed. This field appears if the
	// model version was imported.
	ImportJobEndTime *time.Time

	// The date and time when the import job began. This field appears if the model
	// version was imported.
	ImportJobStartTime *time.Time

	// The size in bytes of the imported data. This field appears if the model version
	// was imported.
	ImportedDataSizeInBytes *int64

	// Contains the configuration information for the S3 location being used to hold
	// label data.
	LabelsInputConfiguration *types.LabelsInputConfiguration

	// Indicates the last time the machine learning model version was updated.
	LastUpdatedTime *time.Time

	// The Amazon Resource Name (ARN) of the parent machine learning model that this
	// version belong to.
	ModelArn *string

	// Shows an aggregated summary, in JSON format, of the model's performance within
	// the evaluation time range. These metrics are created when evaluating the model.
	ModelMetrics *string

	// The name of the machine learning model that this version belongs to.
	ModelName *string

	// The version of the machine learning model.
	ModelVersion *int64

	// The Amazon Resource Name (ARN) of the model version.
	ModelVersionArn *string

	// Indicates that the asset associated with this sensor has been shut off. As long
	// as this condition is met, Lookout for Equipment will not use data from this
	// asset for training, evaluation, or inference.
	OffCondition *string

	// If the model version was retrained, this field shows a summary of the
	// performance of the prior model on the new training range. You can use the
	// information in this JSON-formatted object to compare the new model version and
	// the prior model version.
	PriorModelMetrics *string

	// Indicates the number of days of data used in the most recent scheduled
	// retraining run.
	RetrainingAvailableDataInDays *int32

	// The Amazon Resource Name (ARN) of the role that was used to train the model
	// version.
	RoleArn *string

	// The schema of the data used to train the model version.
	Schema *string

	// The identifier of the KMS key key used to encrypt model version data by Amazon
	// Lookout for Equipment.
	ServerSideKmsKeyId *string

	// If model version was imported, then this field is the arn of the source model
	// version.
	SourceModelVersionArn *string

	// Indicates whether this model version was created by training or by importing.
	SourceType types.ModelVersionSourceType

	// The current status of the model version.
	Status types.ModelVersionStatus

	// The date on which the training data finished being gathered. If you imported
	// the version, this is the date that the training data in the source version
	// finished being gathered.
	TrainingDataEndTime *time.Time

	// The date on which the training data began being gathered. If you imported the
	// version, this is the date that the training data in the source version began
	// being gathered.
	TrainingDataStartTime *time.Time

	// The time when the training of the version completed.
	TrainingExecutionEndTime *time.Time

	// The time when the training of the version began.
	TrainingExecutionStartTime *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeModelVersionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpDescribeModelVersion{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpDescribeModelVersion{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeModelVersion"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDescribeModelVersionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeModelVersion(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeModelVersion(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeModelVersion",
	}
}
