// Code generated by smithy-go-codegen DO NOT EDIT.

package sesv2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/sesv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves a list of email addresses that are on the suppression list for your
// account.
func (c *Client) ListSuppressedDestinations(ctx context.Context, params *ListSuppressedDestinationsInput, optFns ...func(*Options)) (*ListSuppressedDestinationsOutput, error) {
	if params == nil {
		params = &ListSuppressedDestinationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListSuppressedDestinations", params, optFns, c.addOperationListSuppressedDestinationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListSuppressedDestinationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// A request to obtain a list of email destinations that are on the suppression
// list for your account.
type ListSuppressedDestinationsInput struct {

	// Used to filter the list of suppressed email destinations so that it only
	// includes addresses that were added to the list before a specific date.
	EndDate *time.Time

	// A token returned from a previous call to ListSuppressedDestinations to indicate
	// the position in the list of suppressed email addresses.
	NextToken *string

	// The number of results to show in a single call to ListSuppressedDestinations. If
	// the number of results is larger than the number you specified in this parameter,
	// then the response includes a NextToken element, which you can use to obtain
	// additional results.
	PageSize *int32

	// The factors that caused the email address to be added to .
	Reasons []types.SuppressionListReason

	// Used to filter the list of suppressed email destinations so that it only
	// includes addresses that were added to the list after a specific date.
	StartDate *time.Time

	noSmithyDocumentSerde
}

// A list of suppressed email addresses.
type ListSuppressedDestinationsOutput struct {

	// A token that indicates that there are additional email addresses on the
	// suppression list for your account. To view additional suppressed addresses,
	// issue another request to ListSuppressedDestinations, and pass this token in the
	// NextToken parameter.
	NextToken *string

	// A list of summaries, each containing a summary for a suppressed email
	// destination.
	SuppressedDestinationSummaries []types.SuppressedDestinationSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListSuppressedDestinationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListSuppressedDestinations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListSuppressedDestinations{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListSuppressedDestinations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListSuppressedDestinationsAPIClient is a client that implements the
// ListSuppressedDestinations operation.
type ListSuppressedDestinationsAPIClient interface {
	ListSuppressedDestinations(context.Context, *ListSuppressedDestinationsInput, ...func(*Options)) (*ListSuppressedDestinationsOutput, error)
}

var _ ListSuppressedDestinationsAPIClient = (*Client)(nil)

// ListSuppressedDestinationsPaginatorOptions is the paginator options for
// ListSuppressedDestinations
type ListSuppressedDestinationsPaginatorOptions struct {
	// The number of results to show in a single call to ListSuppressedDestinations. If
	// the number of results is larger than the number you specified in this parameter,
	// then the response includes a NextToken element, which you can use to obtain
	// additional results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListSuppressedDestinationsPaginator is a paginator for
// ListSuppressedDestinations
type ListSuppressedDestinationsPaginator struct {
	options   ListSuppressedDestinationsPaginatorOptions
	client    ListSuppressedDestinationsAPIClient
	params    *ListSuppressedDestinationsInput
	nextToken *string
	firstPage bool
}

// NewListSuppressedDestinationsPaginator returns a new
// ListSuppressedDestinationsPaginator
func NewListSuppressedDestinationsPaginator(client ListSuppressedDestinationsAPIClient, params *ListSuppressedDestinationsInput, optFns ...func(*ListSuppressedDestinationsPaginatorOptions)) *ListSuppressedDestinationsPaginator {
	if params == nil {
		params = &ListSuppressedDestinationsInput{}
	}

	options := ListSuppressedDestinationsPaginatorOptions{}
	if params.PageSize != nil {
		options.Limit = *params.PageSize
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListSuppressedDestinationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListSuppressedDestinationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListSuppressedDestinations page.
func (p *ListSuppressedDestinationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListSuppressedDestinationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.PageSize = limit

	result, err := p.client.ListSuppressedDestinations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListSuppressedDestinations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "ses",
		OperationName: "ListSuppressedDestinations",
	}
}
