// Code generated by smithy-go-codegen DO NOT EDIT.

package gamelift

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/gamelift/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a multiplayer game session for players in a specific fleet location.
// This operation prompts an available server process to start a game session and
// retrieves connection information for the new game session. As an alternative,
// consider using the GameLift game session placement feature with with
// StartGameSessionPlacement, which uses FleetIQ algorithms and queues to optimize
// the placement process. When creating a game session, you specify exactly where
// you want to place it and provide a set of game session configuration settings.
// The fleet must be in ACTIVE status before a game session can be created in it.
// This operation can be used in the following ways:
//
// * To create a game session on
// an instance in a fleet's home Region, provide a fleet or alias ID along with
// your game session configuration.
//
// * To create a game session on an instance in a
// fleet's remote location, provide a fleet or alias ID and a location name, along
// with your game session configuration.
//
// If successful, a workflow is initiated to
// start a new game session. A GameSession object is returned containing the game
// session configuration and status. When the status is ACTIVE, game session
// connection information is provided and player sessions can be created for the
// game session. By default, newly created game sessions are open to new players.
// You can restrict new player access by using UpdateGameSession to change the game
// session's player session creation policy. Game session logs are retained for all
// active game sessions for 14 days. To access the logs, call GetGameSessionLogUrl
// to download the log files. Available in Amazon GameLift Local. Learn more Start
// a game session
// (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)
// Related actions CreateGameSession | DescribeGameSessions |
// DescribeGameSessionDetails | SearchGameSessions | UpdateGameSession |
// GetGameSessionLogUrl | StartGameSessionPlacement | DescribeGameSessionPlacement
// | StopGameSessionPlacement | All APIs by task
// (https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets)
func (c *Client) CreateGameSession(ctx context.Context, params *CreateGameSessionInput, optFns ...func(*Options)) (*CreateGameSessionOutput, error) {
	if params == nil {
		params = &CreateGameSessionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateGameSession", params, optFns, c.addOperationCreateGameSessionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateGameSessionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Represents the input for a request operation.
type CreateGameSessionInput struct {

	// The maximum number of players that can be connected simultaneously to the game
	// session.
	//
	// This member is required.
	MaximumPlayerSessionCount *int32

	// A unique identifier for the alias associated with the fleet to create a game
	// session in. You can use either the alias ID or ARN value. Each request must
	// reference either a fleet ID or alias ID, but not both.
	AliasId *string

	// A unique identifier for a player or entity creating the game session. This
	// parameter is required when requesting a new game session on a fleet with a
	// resource creation limit policy. This type of policy limits the number of
	// concurrent active game sessions that one player can create within a certain time
	// span. GameLift uses the CreatorId to evaluate the new request against the
	// policy.
	CreatorId *string

	// A unique identifier for the fleet to create a game session in. You can use
	// either the fleet ID or ARN value. Each request must reference either a fleet ID
	// or alias ID, but not both.
	FleetId *string

	// A set of custom properties for a game session, formatted as key:value pairs.
	// These properties are passed to a game server process in the GameSession object
	// with a request to start a new game session (see Start a Game Session
	// (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	GameProperties []types.GameProperty

	// A set of custom game session properties, formatted as a single string value.
	// This data is passed to a game server process in the GameSession object with a
	// request to start a new game session (see Start a Game Session
	// (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	GameSessionData *string

	// This parameter is no longer preferred. Please use IdempotencyToken instead.
	// Custom string that uniquely identifies a request for a new game session. Maximum
	// token length is 48 characters. If provided, this string is included in the new
	// game session's ID.
	GameSessionId *string

	// Custom string that uniquely identifies the new game session request. This is
	// useful for ensuring that game session requests with the same idempotency token
	// are processed only once. Subsequent requests with the same string return the
	// original GameSession object, with an updated status. Maximum token length is 48
	// characters. If provided, this string is included in the new game session's ID. A
	// game session ARN has the following format: arn:aws:gamelift:::gamesession//.
	// Idempotency tokens remain in use for 30 days after a game session has ended;
	// game session objects are retained for this time period and then deleted.
	IdempotencyToken *string

	// A fleet's remote location to place the new game session in. If this parameter is
	// not set, the new game session is placed in the fleet's home Region. Specify a
	// remote location with an Amazon Web Services Region code such as us-west-2.
	Location *string

	// A descriptive label that is associated with a game session. Session names do not
	// need to be unique.
	Name *string

	noSmithyDocumentSerde
}

// Represents the returned data in response to a request operation.
type CreateGameSessionOutput struct {

	// Object that describes the newly created game session record.
	GameSession *types.GameSession

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateGameSessionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateGameSession{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateGameSession{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateGameSessionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateGameSession(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateGameSession(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "gamelift",
		OperationName: "CreateGameSession",
	}
}
