// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A gateway is an Backup Gateway appliance that runs on the customer's network to
// provide seamless connectivity to backup storage in the Amazon Web Services
// Cloud.
type Gateway struct {

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to
	// return a list of gateways for your account and Amazon Web Services Region.
	GatewayArn *string

	// The display name of the gateway.
	GatewayDisplayName *string

	// The type of the gateway.
	GatewayType GatewayType

	// The hypervisor ID of the gateway.
	HypervisorId *string

	// The last time Backup gateway communicated with the gateway, in Unix format and
	// UTC time.
	LastSeenTime *time.Time

	noSmithyDocumentSerde
}

// The details of gateway.
type GatewayDetails struct {

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation to
	// return a list of gateways for your account and Amazon Web Services Region.
	GatewayArn *string

	// The display name of the gateway.
	GatewayDisplayName *string

	// The type of the gateway type.
	GatewayType GatewayType

	// The hypervisor ID of the gateway.
	HypervisorId *string

	// Details showing the last time Backup gateway communicated with the cloud, in
	// Unix format and UTC time.
	LastSeenTime *time.Time

	// Returns your gateway's weekly maintenance start time including the day and time
	// of the week. Note that values are in terms of the gateway's time zone. Can be
	// weekly or monthly.
	MaintenanceStartTime *MaintenanceStartTime

	// Details showing the next update availability time of the gateway.
	NextUpdateAvailabilityTime *time.Time

	// The DNS name for the virtual private cloud (VPC) endpoint the gateway uses to
	// connect to the cloud for backup gateway.
	VpcEndpoint *string

	noSmithyDocumentSerde
}

// Represents the hypervisor's permissions to which the gateway will connect. A
// hypervisor is hardware, software, or firmware that creates and manages virtual
// machines, and allocates resources to them.
type Hypervisor struct {

	// The server host of the hypervisor. This can be either an IP address or a
	// fully-qualified domain name (FQDN).
	Host *string

	// The Amazon Resource Name (ARN) of the hypervisor.
	HypervisorArn *string

	// The Amazon Resource Name (ARN) of the Key Management Service used to encrypt the
	// hypervisor.
	KmsKeyArn *string

	// The name of the hypervisor.
	Name *string

	// The state of the hypervisor.
	State HypervisorState

	noSmithyDocumentSerde
}

// This is your gateway's weekly maintenance start time including the day and time
// of the week. Note that values are in terms of the gateway's time zone. Can be
// weekly or monthly.
type MaintenanceStartTime struct {

	// The hour component of the maintenance start time represented as hh, where hh is
	// the hour (0 to 23). The hour of the day is in the time zone of the gateway.
	//
	// This member is required.
	HourOfDay *int32

	// The minute component of the maintenance start time represented as mm, where mm
	// is the minute (0 to 59). The minute of the hour is in the time zone of the
	// gateway.
	//
	// This member is required.
	MinuteOfHour *int32

	// The day of the month component of the maintenance start time represented as an
	// ordinal number from 1 to 28, where 1 represents the first day of the month and
	// 28 represents the last day of the month.
	DayOfMonth *int32

	// An ordinal number between 0 and 6 that represents the day of the week, where 0
	// represents Sunday and 6 represents Saturday. The day of week is in the time zone
	// of the gateway.
	DayOfWeek *int32

	noSmithyDocumentSerde
}

// A key-value pair you can use to manage, filter, and search for your resources.
// Allowed characters include UTF-8 letters, numbers, spaces, and the following
// characters: + - = . _ : /.
type Tag struct {

	// The key part of a tag's key-value pair. The key can't start with aws:.
	//
	// This member is required.
	Key *string

	// The value part of a tag's key-value pair.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// A virtual machine that is on a hypervisor.
type VirtualMachine struct {

	// The host name of the virtual machine.
	HostName *string

	// The ID of the virtual machine's hypervisor.
	HypervisorId *string

	// The most recent date a virtual machine was backed up, in Unix format and UTC
	// time.
	LastBackupDate *time.Time

	// The name of the virtual machine.
	Name *string

	// The path of the virtual machine.
	Path *string

	// The Amazon Resource Name (ARN) of the virtual machine. For example,
	// arn:aws:backup-gateway:us-west-1:0000000000000:vm/vm-0000ABCDEFGIJKL.
	ResourceArn *string

	noSmithyDocumentSerde
}

// Your VirtualMachine objects, ordered by their Amazon Resource Names (ARNs).
type VirtualMachineDetails struct {

	// The host name of the virtual machine.
	HostName *string

	// The ID of the virtual machine's hypervisor.
	HypervisorId *string

	// The most recent date a virtual machine was backed up, in Unix format and UTC
	// time.
	LastBackupDate *time.Time

	// The name of the virtual machine.
	Name *string

	// The path of the virtual machine.
	Path *string

	// The Amazon Resource Name (ARN) of the virtual machine. For example,
	// arn:aws:backup-gateway:us-west-1:0000000000000:vm/vm-0000ABCDEFGIJKL.
	ResourceArn *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
