/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */

import { AmountString, ScopeType } from "@gnu-taler/taler-util";
import * as tests from "@gnu-taler/web-util/testing";
import { BalanceView as TestedComponent } from "./BalancePage.js";

export default {
  title: "balance",
};

export const EmptyBalance = tests.createExample(TestedComponent, {
  balances: [],
  goToWalletManualWithdraw: {},
});

export const SomeCoins = tests.createExample(TestedComponent, {
  balances: [
    {
      flags: [],
      available: "USD:10.5" as AmountString,
      
      pendingIncoming: "USD:0" as AmountString,
      pendingOutgoing: "USD:0" as AmountString,
      
      scopeInfo: {
        currency: "TESTKUDOS",
        type: ScopeType.Auditor,
        url: "asd",
      },
    },
  ],
  addAction: {},
  goToWalletManualWithdraw: {},
});

export const SomeCoinsInTreeCurrencies = tests.createExample(TestedComponent, {
  balances: [
    {
      flags: [],
      available: "EUR:1" as AmountString,
      
      pendingIncoming: "USD:0" as AmountString,
      pendingOutgoing: "USD:0" as AmountString,
      
      scopeInfo: {
        currency: "TESTKUDOS",
        type: ScopeType.Auditor,
        url: "asd",
      },
    },
    {
      flags: [],
      available: "TESTKUDOS:2000" as AmountString,
      
      pendingIncoming: "USD:0" as AmountString,
      pendingOutgoing: "USD:0" as AmountString,
      
      scopeInfo: {
        currency: "TESTKUDOS",
        type: ScopeType.Auditor,
        url: "asd",
      },
    },
    {
      flags: [],
      available: "JPY:4" as AmountString,
      
      pendingIncoming: "EUR:15" as AmountString,
      pendingOutgoing: "EUR:0" as AmountString,
      
      scopeInfo: {
        currency: "TESTKUDOS",
        type: ScopeType.Auditor,
        url: "asd",
      },
    },
  ],
  goToWalletManualWithdraw: {},
  addAction: {},
});

export const NoCoinsInTreeCurrencies = tests.createExample(TestedComponent, {
  balances: [
    {
      flags: [],
      available: "EUR:3" as AmountString,
      
      pendingIncoming: "USD:0" as AmountString,
      pendingOutgoing: "USD:0" as AmountString,
      
      scopeInfo: {
        currency: "TESTKUDOS",
        type: ScopeType.Auditor,
        url: "asd",
      },
    },
    {
      flags: [],
      available: "USD:2" as AmountString,
      
      pendingIncoming: "USD:0" as AmountString,
      pendingOutgoing: "USD:0" as AmountString,
      
      scopeInfo: {
        currency: "TESTKUDOS",
        type: ScopeType.Auditor,
        url: "asd",
      },
    },
    {
      flags: [],
      available: "ARS:1" as AmountString,
      
      pendingIncoming: "EUR:15" as AmountString,
      pendingOutgoing: "EUR:0" as AmountString,
      
      scopeInfo: {
        currency: "TESTKUDOS",
        type: ScopeType.Auditor,
        url: "asd",
      },
    },
  ],
  goToWalletManualWithdraw: {},
  addAction: {},
});

export const SomeCoinsInFiveCurrencies = tests.createExample(TestedComponent, {
  balances: [
    {
      flags: [],
      available: "USD:0" as AmountString,
      
      pendingIncoming: "USD:0" as AmountString,
      pendingOutgoing: "USD:0" as AmountString,
      
      scopeInfo: {
        currency: "TESTKUDOS",
        type: ScopeType.Auditor,
        url: "asd",
      },
    },
    {
      flags: [],
      available: "ARS:13451" as AmountString,
      
      pendingIncoming: "USD:0" as AmountString,
      pendingOutgoing: "USD:0" as AmountString,
      
      scopeInfo: {
        currency: "TESTKUDOS",
        type: ScopeType.Auditor,
        url: "asd",
      },
    },
    {
      flags: [],
      available: "EUR:202.02" as AmountString,
      
      pendingIncoming: "EUR:0" as AmountString,
      pendingOutgoing: "EUR:0" as AmountString,
      
      scopeInfo: {
        currency: "TESTKUDOS",
        type: ScopeType.Auditor,
        url: "asd",
      },
    },
    {
      flags: [],
      available: "JPY:0" as AmountString,
      
      pendingIncoming: "EUR:0" as AmountString,
      pendingOutgoing: "EUR:0" as AmountString,
      
      scopeInfo: {
        currency: "TESTKUDOS",
        type: ScopeType.Auditor,
        url: "asd",
      },
    },
    {
      flags: [],
      available: "JPY:51223233" as AmountString,
      
      pendingIncoming: "EUR:0" as AmountString,
      pendingOutgoing: "EUR:0" as AmountString,
      
      scopeInfo: {
        currency: "TESTKUDOS",
        type: ScopeType.Auditor,
        url: "asd",
      },
    },
    {
      flags: [],
      available: "DEMOKUDOS:6" as AmountString,
      
      pendingIncoming: "USD:0" as AmountString,
      pendingOutgoing: "USD:0" as AmountString,
      
      scopeInfo: {
        currency: "TESTKUDOS",
        type: ScopeType.Auditor,
        url: "asd",
      },
    },
    {
      flags: [],
      available: "TESTKUDOS:6" as AmountString,
      
      pendingIncoming: "USD:5" as AmountString,
      pendingOutgoing: "USD:0" as AmountString,
      
      scopeInfo: {
        currency: "TESTKUDOS",
        type: ScopeType.Auditor,
        url: "asd",
      },
    },
  ],
  goToWalletManualWithdraw: {},
  addAction: {},
});
