/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_lookup_inventory_products_filtered.h
 * @brief Lookup inventory product details for templates (filtered)
 * @author Bohdan Potuzhnyi
 */
#ifndef PG_LOOKUP_INVENTORY_PRODUCTS_FILTERED_H
#define PG_LOOKUP_INVENTORY_PRODUCTS_FILTERED_H

#include "taler_merchantdb_plugin.h"

/**
 * Lookup inventory details for a subset of products.
 *
 * @param cls closure
 * @param instance_id instance to lookup products for
 * @param product_ids product IDs to include (can be NULL/empty)
 * @param num_product_ids number of entries in @a product_ids
 * @param categories category IDs to include (can be NULL/empty)
 * @param num_categories number of entries in @a categories
 * @param cb function to call on all products found
 * @param cb_cls closure for @a cb
 * @return database result code
 */
enum GNUNET_DB_QueryStatus
TMH_PG_lookup_inventory_products_filtered (
  void *cls,
  const char *instance_id,
  const char *const *product_ids,
  size_t num_product_ids,
  const uint64_t *categories,
  size_t num_categories,
  TALER_MERCHANTDB_InventoryProductCallback cb,
  void *cb_cls);

#endif  /* PG_LOOKUP_INVENTORY_PRODUCTS_FILTERED_H */
