/* -*- mode:c -*-
 *
 * Copyright 2021 The Chromium OS Authors. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

/* Intel ADL-P-RVP-NPCX board-specific configuration */

#include "baseboard/intelrvp/adlrvp_ioex_gpio.inc"

/* Power sequencing interrupts */
GPIO_INT(ALL_SYS_PWRGD,		PIN(7, 0), GPIO_INT_BOTH, power_signal_interrupt)
GPIO_INT(RSMRST_PWRGD,		PIN(3, 7), GPIO_INT_BOTH, power_signal_interrupt)
GPIO_INT(PCH_SLP_S0_N,		PIN(A, 1), GPIO_INT_BOTH, power_signal_interrupt)
GPIO_INT(VCCPDSW_3P3,		PIN(4, 5), GPIO_INT_BOTH, power_signal_interrupt)
/* TODO: GPIO_INT(VCCST_PWRGD_MECC,	PIN(7, 1), GPIO_INT_BOTH, power_signal_interrupt) */
GPIO_INT(PM_SLP_SUS_EC_N, 	PIN(8, 6), GPIO_INT_BOTH, power_signal_interrupt)
#ifndef CONFIG_HOSTCMD_ESPI_VW_SLP_S3
GPIO_INT(PM_SLP_S3_N,		PIN(B, 0), GPIO_INT_BOTH, power_signal_interrupt)
#else
GPIO(PM_SLP_S3_N,		PIN(B, 0), GPIO_INPUT)
#endif
#ifndef CONFIG_HOSTCMD_ESPI_VW_SLP_S4
GPIO_INT(PM_SLP_S4_N,		PIN(A, 5), GPIO_INT_BOTH, power_signal_interrupt)
#else
GPIO(PM_SLP_S4_N,		PIN(A, 5), GPIO_INPUT)
#endif

/* Button interrupts */
GPIO_INT(VOLUME_UP,		PIN(6, 1), GPIO_INT_BOTH | GPIO_PULL_UP, button_interrupt)
GPIO_INT(VOL_DN_EC,		PIN(0, 3), GPIO_INT_BOTH | GPIO_PULL_UP, button_interrupt)
GPIO_INT(SMC_LID,		PIN(0, 1), GPIO_INT_BOTH | GPIO_PULL_UP, lid_interrupt)
GPIO_INT(MECH_PWR_BTN_ODL,	PIN(0, 0), GPIO_INT_BOTH, power_button_interrupt)

/* DC Jack presence coming from +VADP_OUT */
GPIO_INT(STD_ADP_PRSNT, 	PIN(0, 2), GPIO_INT_BOTH, board_dc_jack_interrupt) /* DC_JACK_PRESENT */

GPIO_INT(BC_ACOK,		PIN(C, 6), GPIO_INT_BOTH, extpower_interrupt) /* AC Present */

/* USB-C interrupts */
GPIO_INT(USBC_TCPC_ALRT_P0,	PIN(4, 0), GPIO_INT_BOTH, tcpc_alert_event)
GPIO_INT(USBC_TCPC_ALRT_P1,	PIN(6, 2), GPIO_INT_BOTH, tcpc_alert_event)
#if defined(HAS_TASK_PD_C2)
GPIO_INT(USBC_TCPC_ALRT_P2,	PIN(6, 3), GPIO_INT_BOTH, tcpc_alert_event)
GPIO_INT(USBC_TCPC_ALRT_P3,	PIN(6, 7), GPIO_INT_BOTH, tcpc_alert_event)
#else
GPIO(USBC_TCPC_ALRT_P2,		PIN(6, 3), GPIO_INPUT)
GPIO(USBC_TCPC_ALRT_P3,		PIN(6, 7), GPIO_INPUT)
#endif

GPIO_INT(USBC_TCPC_PPC_ALRT_P0, PIN(F, 0), GPIO_INT_BOTH, ppc_interrupt)
GPIO_INT(USBC_TCPC_PPC_ALRT_P1, PIN(F, 1), GPIO_INT_BOTH, ppc_interrupt)
#if defined(HAS_TASK_PD_C2)
GPIO_INT(USBC_TCPC_PPC_ALRT_P2, PIN(F, 2), GPIO_INT_BOTH, ppc_interrupt)
GPIO_INT(USBC_TCPC_PPC_ALRT_P3, PIN(F, 3), GPIO_INT_BOTH, ppc_interrupt)
#else
GPIO(USBC_TCPC_PPC_ALRT_P2,	PIN(F, 2), GPIO_INPUT)
GPIO(USBC_TCPC_PPC_ALRT_P3,	PIN(F, 3), GPIO_INPUT)
#endif

/* Host communication GPIOs */
GPIO(SMC_WAKE_SCI_N_MECC,	PIN(A, 4), GPIO_ODR_HIGH)
GPIO(EC_PCH_MKBP_INT_ODL,	PIN(F, 5), GPIO_ODR_HIGH)
#ifndef CONFIG_HOSTCMD_ESPI
GPIO(LPC_ESPI_RST_N,		PIN(5, 4), GPIO_INPUT | GPIO_SEL_1P8V)
GPIO(PLT_RST_L, 		PIN(A, 2), GPIO_INPUT | GPIO_SEL_1P8V) /* PCH_PLTRST_L */
#endif

/* Sensor Interrupts */
GPIO_INT(SLATE_MODE_INDICATION,	PIN(E, 5), GPIO_INT_BOTH | GPIO_SEL_1P8V, gmr_tablet_switch_isr)
GPIO(PROCHOT_EC_N,		PIN(A, 7), GPIO_INPUT)

/* Power sequencing GPIOs */
GPIO(SYS_RST_ODL,		PIN(C, 5), GPIO_ODR_HIGH)
/* GPIOD3 (Rework: CPU_TACHO_FAN is swapped with PM_RSMRST_N) */
GPIO(PM_RSMRST_N,		PIN(D, 3), GPIO_OUT_LOW)
GPIO(PM_PWRBTN_N,		PIN(9, 7), GPIO_ODR_HIGH)
GPIO(EC_SPI_OE_MECC,		PIN(6, 0), GPIO_OUT_LOW)
GPIO(EC_DS3,			PIN(C, 4), GPIO_OUT_LOW)
UNIMPLEMENTED(EN_PP5000)

/* PCH_PWROK_EC is an input, as it's driven by the Silego chip on RVP */
GPIO(PCH_PWROK_EC,	PIN(A, 0), GPIO_INPUT)
GPIO(SYS_PWROK,		PIN(9, 3), GPIO_OUT_LOW)
GPIO(EC_DSW_PWROK,	PIN(9, 5), GPIO_OUT_LOW)

/* H1 pins */
GPIO_INT(EC_FLASH_WP_ODL,	PIN(9, 4), GPIO_INT_BOTH, switch_interrupt)
GPIO(EC_H1_PACKET_MODE,		PIN(E, 2), GPIO_OUT_LOW)
GPIO(EC_ENTERING_RW,		PIN(D, 4), GPIO_OUT_LOW)

/* Case Closed Debug Mode */
GPIO_INT(CCD_MODE_ODL,		PIN(F, 4), GPIO_INT_BOTH, board_connect_c0_sbu)

/* Battery present */
GPIO(BAT_DET,		PIN(7, 6), GPIO_INPUT)

/* EDP */
GPIO(EDP_BKLT_EN_MECC,	PIN(E, 1), GPIO_OUT_HIGH)

/* LED */
GPIO(LED_1_L,		PIN(B, 6), GPIO_OUT_HIGH)
GPIO(LED_2_L,		PIN(B, 7), GPIO_OUT_HIGH)

/* FAN control pins */
GPIO(THERM_SEN_MECC,	PIN(C, 0), GPIO_OUT_LOW)

/*
 * I2C pins should be configure as inputs until I2C module is
 * initialized. This will avoid driving the lines unintentionally.
 */
GPIO(SMB_BS_CLK,		PIN(B, 3), GPIO_INPUT)	/* I2C7_SCL0 */
GPIO(SMB_BS_DATA,		PIN(B, 2), GPIO_INPUT)	/* I2C7_SDA0 */
GPIO(USBC_TCPC_I2C_CLK_P0,	PIN(B, 5), GPIO_INPUT)	/* I2C0_SCL0 */
GPIO(USBC_TCPC_I2C_DATA_P0,	PIN(B, 4), GPIO_INPUT)	/* I2C0_SDA0 */
GPIO(USBC_TCPC_I2C_CLK_P2,	PIN(9, 2), GPIO_INPUT)	/* I2C2_SCL0 */
GPIO(USBC_TCPC_I2C_DATA_P2,	PIN(9, 1), GPIO_INPUT)	/* I2C2_SDA0 */
GPIO(USBC_TCPC_I2C_CLK_P1,	PIN(9, 0), GPIO_INPUT)	/* I2C1_SCL0 */
GPIO(USBC_TCPC_I2C_DATA_P1,	PIN(8, 7), GPIO_INPUT)	/* I2C1_SCL0 */
GPIO(USBC_TCPC_I2C_CLK_P3,	PIN(D, 1), GPIO_INPUT)	/* I2C3_SCL0 */
GPIO(USBC_TCPC_I2C_DATA_P3,	PIN(D, 0), GPIO_INPUT)	/* I2C3_SCL0 */

/* Unused pins */
GPIO(SML1_CLK_MECC,		PIN(3, 3), GPIO_INPUT)
GPIO(SML1_DATA_MECC,		PIN(3, 6), GPIO_INPUT)
GPIO(SMB_PCH_CLK,		PIN(C, 2), GPIO_INPUT)
GPIO(SMB_PCH_DATA,		PIN(C, 1), GPIO_INPUT)
GPIO(I3C_0_SCL,			PIN(E, 4), GPIO_INPUT)
GPIO(I3C_0_SDA,			PIN(E, 3), GPIO_INPUT)
GPIO(CPU_CAT_ERR_MECC,		PIN(3, 4), GPIO_INPUT)
GPIO(TP29,			PIN(5, 0), GPIO_INPUT)
GPIO(TP28,			PIN(5, 6), GPIO_INPUT)
GPIO(ESPI_ALERT0_N,		PIN(5, 7), GPIO_INPUT | GPIO_SEL_1P8V)
GPIO(BATT_DISABLE_EC,		PIN(6, 6), GPIO_INPUT)
GPIO(TP33,			PIN(7, 2), GPIO_INPUT)
GPIO(TP26,			PIN(7, 3), GPIO_INPUT)
GPIO(SLP_S0_CS_N,		PIN(7, 4), GPIO_INPUT)
GPIO(EC_PECI,			PIN(8, 1), GPIO_INPUT)
GPIO(CPU_C10_GATE_MECC,		PIN(9, 6), GPIO_INPUT)
GPIO(SMB_PCH_ALRT,		PIN(A, 3), GPIO_INPUT)
GPIO(SMC_SDOWN_MECC,		PIN(B, 1), GPIO_INPUT)
GPIO(STD_ADPT_CNTRL_GPIO,	PIN(C, 3), GPIO_INPUT)
GPIO(SML1_ALERT,		PIN(C, 7), GPIO_INPUT)
GPIO(SMC_ONOFF_N,		PIN(D, 2), GPIO_INPUT) /* Power button interrupt without H1 */
GPIO(SUSWARN,			PIN(D, 5), GPIO_INPUT)
GPIO(TP_GPIOD6_EC,		PIN(D, 6), GPIO_INPUT)
GPIO(TP_GPIOD7_EC,		PIN(D, 7), GPIO_INPUT)
GPIO(ME_G3_TO_M3_EC,		PIN(E, 0), GPIO_INPUT)

/* Alternate pins for I2C */
ALTERNATE(PIN_MASK(8, BIT(7)), GPIO_ALT_FUNC_DEFAULT, MODULE_I2C, GPIO_FLAG_NONE)
ALTERNATE(PIN_MASK(9, BIT(0) | BIT(1) | BIT(2)), GPIO_ALT_FUNC_DEFAULT, MODULE_I2C, GPIO_FLAG_NONE)
ALTERNATE(PIN_MASK(B, BIT(2) | BIT(3) | BIT(4) | BIT(5)), GPIO_ALT_FUNC_DEFAULT, MODULE_I2C, GPIO_FLAG_NONE)
ALTERNATE(PIN_MASK(D, BIT(0) | BIT(1)), GPIO_ALT_FUNC_DEFAULT, MODULE_I2C, GPIO_FLAG_NONE)

/* Alternate pins for UART */
ALTERNATE(PIN_MASK(6, BIT(4) | BIT(5)), GPIO_ALT_FUNC_DEFAULT, MODULE_UART, GPIO_PULL_UP)

/* Alternate pins for ADC */
/* VR_TMP/V_1P05 - GPIO44, SKIN_THERM_IN_EC - GPIO43, AMBIENT_TEMP - GPIO42, DDR_TEMP/EC_5V - GPIO41 */
ALTERNATE(PIN_MASK(4, BIT(1) | BIT(2) | BIT(3) | BIT(4)), GPIO_ALT_FUNC_DEFAULT, MODULE_ADC, GPIO_FLAG_NONE)

/* Alternate pins for FAN */
ALTERNATE(PIN_MASK(8, BIT(0)), GPIO_ALT_FUNC_DEFAULT, MODULE_PWM, GPIO_FLAG_NONE)	/* CPU_FAN_MECC GPIO80/PWM3_LED3 */
/* GPIOA6 (Rework: CPU_TACHO_FAN is swapped with PM_RSMRST_N) */
ALTERNATE(PIN_MASK(A, BIT(6)), GPIO_ALT_FUNC_DEFAULT, MODULE_PWM, GPIO_FLAG_NONE)

/* Keyboard pins */
ALTERNATE(PIN_MASK(3, 0x03), 0, MODULE_KEYBOARD_SCAN, GPIO_INPUT)		/* KSI_00-01 */
GPIO(EC_KSO_02_INV, PIN(1, 7), GPIO_OUT_LOW)
ALTERNATE(PIN_MASK(2, 0xFC), 0, MODULE_KEYBOARD_SCAN, GPIO_INPUT)		/* KSI_02-07 */
ALTERNATE(PIN_MASK(2, 0x03), 0, MODULE_KEYBOARD_SCAN, GPIO_ODR_HIGH)		/* KSO_00-01 */
ALTERNATE(PIN_MASK(1, 0xFF), 0, MODULE_KEYBOARD_SCAN, GPIO_ODR_HIGH)		/* KSO_02-09 */
ALTERNATE(PIN_MASK(0, 0xF0), 0, MODULE_KEYBOARD_SCAN, GPIO_ODR_HIGH)		/* KSO_10-13 */
ALTERNATE(PIN_MASK(8, 0x0C), 0, MODULE_KEYBOARD_SCAN, GPIO_ODR_HIGH)		/* KSO_14-15 */
