/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import java.awt.event.MouseEvent;
import java.util.Enumeration;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTagText;
import rene.util.xml.XmlTree;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.expression.Expression;
import rene.zirkel.objects.ConstructionObject;

public class ObjectConstructor {
    protected boolean Dragging = false;

    public void mousePressed(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
    }

    public void mouseReleased(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
    }

    public void mouseDragged(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
    }

    public void mouseMoved(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas, boolean bl) {
        if (bl && (this.waitForPoint() || this.waitForLastPoint())) {
            zirkelCanvas.indicateCreatePoint(mouseEvent.getX(), mouseEvent.getY(), false);
            return;
        }
        if (this.waitForPoint()) {
            zirkelCanvas.indicateCreatePoint(mouseEvent.getX(), mouseEvent.getY(), false);
        }
        if (this.waitForLastPoint()) {
            if (zirkelCanvas.isPreview()) {
                zirkelCanvas.movePreview(mouseEvent);
            } else {
                zirkelCanvas.prepareForPreview(mouseEvent);
                this.finishConstruction(mouseEvent, zirkelCanvas);
                return;
            }
        }
    }

    public void finishConstruction(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
    }

    public boolean waitForLastPoint() {
        return false;
    }

    public boolean waitForPoint() {
        return true;
    }

    public void reset(ZirkelCanvas zirkelCanvas) {
        zirkelCanvas.validate();
        zirkelCanvas.clearSelected();
    }

    public void resetFirstTime(ZirkelCanvas zirkelCanvas) {
        this.reset(zirkelCanvas);
    }

    public void invalidate(ZirkelCanvas zirkelCanvas) {
    }

    public void showStatus(ZirkelCanvas zirkelCanvas) {
    }

    public boolean construct(XmlTree xmlTree, Construction construction) throws ConstructionException {
        return false;
    }

    public boolean testTree(XmlTree xmlTree, String string) {
        return xmlTree.getTag().name().equals(string);
    }

    public void setName(XmlTag xmlTag, ConstructionObject constructionObject) {
        if (xmlTag.hasParam("name")) {
            constructionObject.setName(xmlTag.getValue("name"));
        }
        if (xmlTag.hasParam("alias")) {
            constructionObject.setAlias(xmlTag.getValue("alias"));
        }
    }

    public void set(XmlTree xmlTree, ConstructionObject constructionObject) throws ConstructionException {
        int n;
        XmlTag xmlTag = xmlTree.getTag();
        if (xmlTag.hasParam("n")) {
            try {
                constructionObject.setNCount(new Integer(xmlTag.getValue("n")));
                constructionObject.setGotNCount(true);
            }
            catch (Exception exception) {
                throw new ConstructionException("Illegal count!");
            }
        }
        if (xmlTag.hasParam("hidden")) {
            if (xmlTag.getValue("hidden").equals("super")) {
                constructionObject.setSuperHidden(true);
            } else {
                constructionObject.setHidden(true);
            }
        }
        if (xmlTag.hasTrueParam("showvalue")) {
            constructionObject.setShowValue(true);
        }
        if (xmlTag.hasTrueParam("showname")) {
            constructionObject.setShowName(true);
        }
        if (xmlTag.hasTrueParam("background")) {
            constructionObject.setBack(true);
        } else {
            constructionObject.setBack(false);
        }
        if (xmlTag.hasTrueParam("parameter")) {
            constructionObject.setParameter();
        }
        if (xmlTag.hasTrueParam("mainparameter")) {
            constructionObject.setMainParameter();
        }
        if (xmlTag.hasTrueParam("target")) {
            constructionObject.setTarget(true);
        }
        if (xmlTag.hasTrueParam("break")) {
            constructionObject.setBreak(true);
        }
        if (xmlTag.hasTrueParam("hidebreak")) {
            constructionObject.setHideBreak(true);
        }
        if (xmlTag.hasTrueParam("solid")) {
            constructionObject.setSolid(true);
        }
        if (xmlTag.hasTrueParam("bold")) {
            constructionObject.setBold(true);
        }
        if (xmlTag.hasTrueParam("large")) {
            constructionObject.setLarge(true);
        }
        if (xmlTag.hasParam("xoffset") || xmlTag.hasParam("yoffset")) {
            int n2 = 0;
            n = 0;
            try {
                if (xmlTag.hasParam("xoffset")) {
                    n2 = Integer.parseInt(xmlTag.getValue("xoffset"));
                }
                if (xmlTag.hasParam("yoffset")) {
                    n = Integer.parseInt(xmlTag.getValue("yoffset"));
                }
                constructionObject.setOffset(n2, n);
            }
            catch (Exception exception) {
                throw new ConstructionException("Illegal offset value");
            }
        }
        if (xmlTag.hasTrueParam("keepclose")) {
            constructionObject.setKeepClose(true);
        }
        if (xmlTag.hasParam("xcoffset") || xmlTag.hasParam("ycoffset")) {
            double d2 = 0.0;
            double d3 = 0.0;
            try {
                if (xmlTag.hasParam("xcoffset")) {
                    d2 = new Double(xmlTag.getValue("xcoffset"));
                }
                if (xmlTag.hasParam("ycoffset")) {
                    d3 = new Double(xmlTag.getValue("ycoffset"));
                }
                constructionObject.setcOffset(d2, d3);
            }
            catch (Exception exception) {
                throw new ConstructionException("Illegal offset value");
            }
        }
        if (xmlTag.hasParam("color")) {
            try {
                String string = xmlTag.getValue("color");
                n = -1;
                for (int i = 0; i < ZirkelFrame.ColorStrings.length; ++i) {
                    if (!string.equals(ZirkelFrame.ColorStrings[i])) continue;
                    constructionObject.setColor(i);
                    n = i;
                    break;
                }
                if (n < 0) {
                    n = Integer.parseInt(string);
                    if (n < 0 || n >= ZirkelFrame.Colors.length) {
                        throw new Exception("");
                    }
                    constructionObject.setColor(n);
                }
            }
            catch (Exception exception) {
                throw new ConstructionException("Illegal color index (1-" + (ZirkelFrame.Colors.length - 1) + ")");
            }
        }
        if (xmlTag.hasParam("type")) {
            String string = xmlTag.getValue("type");
            if (string.equals("thick")) {
                constructionObject.setColorType(1);
            }
            if (string.equals("thin")) {
                constructionObject.setColorType(2);
            }
            if (string.equals("invisible")) {
                constructionObject.setColorType(3);
            }
        }
        if (xmlTag.hasParam("unit")) {
            constructionObject.setUnit(xmlTag.getValue("unit"));
        } else {
            constructionObject.setUnit("");
        }
        Enumeration enumeration = xmlTree.getContent();
        while (enumeration.hasMoreElements()) {
            xmlTree = (XmlTree)enumeration.nextElement();
            if (!(xmlTree.getTag() instanceof XmlTagText)) continue;
            constructionObject.setText(((XmlTagText)xmlTree.getTag()).getContent(), true);
        }
    }

    public void setConditionals(XmlTree xmlTree, Construction construction, ConstructionObject constructionObject) {
        constructionObject.clearConditionals();
        int n = 0;
        XmlTag xmlTag = xmlTree.getTag();
        while (xmlTag.hasParam("ctag" + n) && xmlTag.hasParam("cexpr" + n)) {
            String string = xmlTag.getValue("ctag" + n);
            String string2 = xmlTag.getValue("cexpr" + n);
            Expression expression = new Expression(string2, construction, constructionObject);
            constructionObject.addConditional(string, expression);
            ++n;
        }
    }

    public String getTag() {
        return "???";
    }

    public void construct(Construction construction, String string, String[] stringArray, int n) throws ConstructionException {
        throw new ConstructionException("");
    }

    public void pause(boolean bl) {
    }

    public boolean useSmartBoard() {
        return true;
    }
}

