/*
 *            Copyright 2009-2020 The VOTCA Development Team
 *                       (http://www.votca.org)
 *
 *      Licensed under the Apache License, Version 2.0 (the "License")
 *
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *              http://www.apache.org/licenses/LICENSe-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#include "gauss_legendre_quadrature.h"

// Gauss-Legendre quadrature points and adapted weights as exported from
// https://keisan.casio.com/exec/system/1329114617
// with 50 digits

namespace votca {
namespace xtp {

void Gauss_Legendre_Quadrature_Base::FillPoints() {

  Eigen::VectorXd points_8(8);
  points_8 << -0.96028985649753623168356086856947299042823523430145,
      -0.79666647741362673959155393647583043683717173161597,
      -0.52553240991632898581773904918924634904196424312039,
      -0.18343464249564980493947614236018398066675781291297,
      0.18343464249564980493947614236018398066675781291297,
      0.52553240991632898581773904918924634904196424312039,
      0.79666647741362673959155393647583043683717173161597,
      0.96028985649753623168356086856947299042823523430145;
  map_points_[8] = points_8;

  Eigen::VectorXd points_10(10);
  points_10 << -0.97390652851717172007796401208445205342826994669238,
      -0.86506336668898451073209668842349304852754301496533,
      -0.67940956829902440623432736511487357576929471183481,
      -0.43339539412924719079926594316578416220007183765625,
      -0.14887433898163121088482600112971998461756485942069,
      0.14887433898163121088482600112971998461756485942069,
      0.43339539412924719079926594316578416220007183765625,
      0.67940956829902440623432736511487357576929471183481,
      0.86506336668898451073209668842349304852754301496533,
      0.97390652851717172007796401208445205342826994669238;
  map_points_[10] = points_10;

  Eigen::VectorXd points_12(12);
  points_12 << -0.98156063424671925069054909014928082296015519981373,
      -0.9041172563704748566784658661190961925375967092133,
      -0.76990267419430468703689383321281807598492575001893,
      -0.58731795428661744729670241894053428036909851404805,
      -0.36783149899818019375269153664371756125636014133541,
      -0.12523340851146891547244136946385312998339691630544,
      0.12523340851146891547244136946385312998339691630544,
      0.36783149899818019375269153664371756125636014133541,
      0.58731795428661744729670241894053428036909851404805,
      0.76990267419430468703689383321281807598492575001893,
      0.9041172563704748566784658661190961925375967092133,
      0.98156063424671925069054909014928082296015519981373;
  map_points_[12] = points_12;

  Eigen::VectorXd points_14(14);
  points_14 << -0.98628380869681233884159726670405280167609140723923,
      -0.92843488366357351733639113937787426447703921040984,
      -0.82720131506976499318979474265039496103970110147508,
      -0.68729290481168547014801980301933413753840121274717,
      -0.51524863635815409196529071855118866230888528256931,
      -0.31911236892788976043567182416847546683426120353384,
      -0.10805494870734366206624465021983474761195160547424,
      0.10805494870734366206624465021983474761195160547424,
      0.31911236892788976043567182416847546683426120353384,
      0.51524863635815409196529071855118866230888528256931,
      0.68729290481168547014801980301933413753840121274717,
      0.82720131506976499318979474265039496103970110147508,
      0.92843488366357351733639113937787426447703921040984,
      0.98628380869681233884159726670405280167609140723923;
  map_points_[14] = points_14;

  Eigen::VectorXd points_16(16);
  points_16 << -0.98940093499164993259615417345033262742627407165765,
      -0.94457502307323257607798841553460834509113927259107,
      -0.86563120238783174388046789771239313238733538484753,
      -0.7554044083550030338951011948474422683538136564575,
      -0.61787624440264374844667176404879101899188221776566,
      -0.45801677765722738634241944298357757354003161303552,
      -0.2816035507792589132304605014604961064860694907706,
      -0.09501250983763744018531933542495806313035305568907,
      0.09501250983763744018531933542495806313035305568907,
      0.2816035507792589132304605014604961064860694907706,
      0.4580167776572273863424194429835775735400316130355,
      0.6178762444026437484466717640487910189918822177657,
      0.7554044083550030338951011948474422683538136564575,
      0.86563120238783174388046789771239313238733538484753,
      0.94457502307323257607798841553460834509113927259107,
      0.98940093499164993259615417345033262742627407165765;
  map_points_[16] = points_16;

  Eigen::VectorXd points_18(18);
  points_18 << -0.99156516842093094673001600470615077025257893684544,
      -0.95582394957139775518119589292977630997284413481131,
      -0.8926024664975557392060605911271455154078952713523,
      -0.80370495897252311568241745501459079710329892161192,
      -0.69168704306035320787489108128884838945227057281751,
      -0.55977083107394753460787154852532913692762648577071,
      -0.41175116146284264603593179383305163707898968212003,
      -0.2518862256915055095889728548779112301628617656596,
      -0.08477501304173530124226185293578381173331738690609,
      0.08477501304173530124226185293578381173331738690609,
      0.2518862256915055095889728548779112301628617656596,
      0.41175116146284264603593179383305163707898968212003,
      0.5597708310739475346078715485253291369276264857707,
      0.69168704306035320787489108128884838945227057281751,
      0.80370495897252311568241745501459079710329892161192,
      0.8926024664975557392060605911271455154078952713523,
      0.95582394957139775518119589292977630997284413481131,
      0.99156516842093094673001600470615077025257893684544;
  map_points_[18] = points_18;

  Eigen::VectorXd points_20(20);
  points_20 << -0.99312859918509492478612238847132027822264713090166,
      -0.96397192727791379126766613119727722191206032780619,
      -0.91223442825132590586775244120329811304918479742369,
      -0.83911697182221882339452906170152068532962936506564,
      -0.74633190646015079261430507035564159031073067956918,
      -0.63605368072651502545283669622628593674338911679937,
      -0.51086700195082709800436405095525099842549132920243,
      -0.37370608871541956067254817702492723739574632170568,
      -0.22778585114164507808049619536857462474308893768293,
      -0.0765265211334973337546404093988382110047962668135,
      0.0765265211334973337546404093988382110047962668135,
      0.22778585114164507808049619536857462474308893768293,
      0.3737060887154195606725481770249272373957463217057,
      0.5108670019508270980043640509552509984254913292024,
      0.63605368072651502545283669622628593674338911679937,
      0.74633190646015079261430507035564159031073067956918,
      0.83911697182221882339452906170152068532962936506564,
      0.91223442825132590586775244120329811304918479742369,
      0.96397192727791379126766613119727722191206032780619,
      0.99312859918509492478612238847132027822264713090166;
  map_points_[20] = points_20;

  Eigen::VectorXd points_40(40);
  points_40 << -0.99823770971055920034962270242058649233577038159505,
      -0.99072623869945700645305435222137215496222208135109,
      -0.97725994998377426266337028371290380697866793203799,
      -0.95791681921379165580454099945275928509488349060275,
      -0.93281280827867653336085216684520571643475357528269,
      -0.90209880696887429672825333086849310358448808105767,
      -0.8659595032122595038207818083546199635705465530111,
      -0.82461223083331166319632023066609877390724038424299,
      -0.77830565142651938769497154550649484802069131612689,
      -0.72731825518992710328099645175493054855737867353333,
      -0.67195668461417954837935451496149410997032598138385,
      -0.61255388966798023795261245023069487738012378168315,
      -0.54946712509512820207593130552951797023397510159565,
      -0.48307580168617871290856657424482300459902239553311,
      -0.41377920437160500152487974580371368297409962405292,
      -0.34199409082575847300749248117919431006695362002733,
      -0.26815218500725368114118434480859618342480437323625,
      -0.19269758070137109971551685206514989481409202110521,
      -0.11608407067525520848345128440802411376872853085422,
      -0.03877241750605082193319344402462329467936463438314,
      0.03877241750605082193319344402462329467936463438314,
      0.11608407067525520848345128440802411376872853085422,
      0.19269758070137109971551685206514989481409202110521,
      0.2681521850072536811411843448085961834248043732362,
      0.34199409082575847300749248117919431006695362002733,
      0.41377920437160500152487974580371368297409962405292,
      0.48307580168617871290856657424482300459902239553311,
      0.54946712509512820207593130552951797023397510159565,
      0.61255388966798023795261245023069487738012378168315,
      0.67195668461417954837935451496149410997032598138385,
      0.72731825518992710328099645175493054855737867353333,
      0.77830565142651938769497154550649484802069131612689,
      0.82461223083331166319632023066609877390724038424299,
      0.8659595032122595038207818083546199635705465530111,
      0.90209880696887429672825333086849310358448808105767,
      0.93281280827867653336085216684520571643475357528269,
      0.95791681921379165580454099945275928509488349060275,
      0.97725994998377426266337028371290380697866793203799,
      0.99072623869945700645305435222137215496222208135109,
      0.99823770971055920034962270242058649233577038159505;
  map_points_[40] = points_40;

  Eigen::VectorXd points_100(100);
  points_100 << -0.9997137267734412336782284693423006767183495273084,
      -0.99849195063959581840016335918634916230485485042057,
      -0.99629513473312514918613173224113103543643128814043,
      -0.99312493703744345965200989284878347073177145886652,
      -0.98898439524299174800441874580773663183933363710695,
      -0.9838775407060570154961001555110081673443670168508,
      -0.97780935848691828855378108842920192863523449426625,
      -0.97078577576370633193089785789750538855055719947821,
      -0.96281365425581552729365932603016638643733150673041,
      -0.95390078292549174284933693089435764464522145101467,
      -0.9440558701362559779627747064152187467397203733821,
      -0.93328853504307954592433366813086250408354607429702,
      -0.9216092981453339526669513284819874591245827977322,
      -0.90902957098252969046712633778914606444327728958459,
      -0.89556164497072698669852102243022776984818176899772,
      -0.88121867938501841557331682542780558244549441102126,
      -0.86601468849716462341073996967624296638031483930559,
      -0.84996452787959128429336259142010465407379077950067,
      -0.83308387988840082354291583384475567990749483030996,
      -0.8153892383391762543939887586492580053825503765137,
      -0.79689789239031447638957288218324598288952685596429,
      -0.7776279096494954756275513868344901065385397999361,
      -0.75759811851970717603566796443840077231310897190004,
      -0.73682808980202070551242771482010100284327844624712,
      -0.7153381175730564464599671227043659640843978385956,
      -0.6931491993558019659486479416754372655870000179307,
      -0.67028301560314101580258701432322661366980568402882,
      -0.6467619085141292798326303044586304350197337842485,
      -0.6226088602037077716041908451723122446538177322898,
      -0.59784747024717872126480654514934063639489919232049,
      -0.57250193262138119131687044352572544896003394967556,
      -0.5465970120650941674679942571817499039562417759375,
      -0.52015801988176305664681574945520853076893769042009,
      -0.49321078920819093356930879344933399099072332535856,
      -0.46578164977335804224921662339575458161165111021221,
      -0.4378974021720315131089780436221959621257017634841,
      -0.4095852916783015425288684000571577014953643891648,
      -0.38087298162462995676336254886958740374970726512371,
      -0.35178852637242172097234382954897056524931809638907,
      -0.3223603439005291517224765823983254274021916230231,
      -0.29261718803847196473755588823549438456153898917258,
      -0.2625881203715034791689293362549821411320226945355,
      -0.23230248184497396964950996320796411069750977150714,
      -0.20178986409573599723604885953039646294369200355905,
      -0.17108008053860327488753237470708980746585972511807,
      -0.14020313723611397320751460468240551661687300626336,
      -0.10918920358006111500342600657938488688489962996916,
      -0.07806858281343663669481737120155257397635002744853,
      -0.04687168242159163161492391293384830953706539908602,
      -0.015628984421543082872216699997429340147756182855562,
      0.01562898442154308287221669999742934014775618285556,
      0.04687168242159163161492391293384830953706539908602,
      0.07806858281343663669481737120155257397635002744853,
      0.10918920358006111500342600657938488688489962996916,
      0.14020313723611397320751460468240551661687300626336,
      0.17108008053860327488753237470708980746585972511807,
      0.20178986409573599723604885953039646294369200355905,
      0.23230248184497396964950996320796411069750977150714,
      0.26258812037150347916892933625498214113202269453552,
      0.29261718803847196473755588823549438456153898917258,
      0.32236034390052915172247658239832542740219162302309,
      0.35178852637242172097234382954897056524931809638907,
      0.38087298162462995676336254886958740374970726512371,
      0.4095852916783015425288684000571577014953643891648,
      0.4378974021720315131089780436221959621257017634841,
      0.4657816497733580422492166233957545816116511102122,
      0.49321078920819093356930879344933399099072332535856,
      0.52015801988176305664681574945520853076893769042009,
      0.54659701206509416746799425718174990395624177593753,
      0.57250193262138119131687044352572544896003394967556,
      0.59784747024717872126480654514934063639489919232049,
      0.62260886020370777160419084517231224465381773228982,
      0.64676190851412927983263030445863043501973378424853,
      0.67028301560314101580258701432322661366980568402882,
      0.69314919935580196594864794167543726558700001793073,
      0.71533811757305644645996712270436596408439783859563,
      0.73682808980202070551242771482010100284327844624712,
      0.75759811851970717603566796443840077231310897190004,
      0.77762790964949547562755138683449010653853979993608,
      0.79689789239031447638957288218324598288952685596429,
      0.8153892383391762543939887586492580053825503765137,
      0.83308387988840082354291583384475567990749483030996,
      0.84996452787959128429336259142010465407379077950067,
      0.86601468849716462341073996967624296638031483930559,
      0.88121867938501841557331682542780558244549441102126,
      0.89556164497072698669852102243022776984818176899772,
      0.90902957098252969046712633778914606444327728958459,
      0.9216092981453339526669513284819874591245827977322,
      0.93328853504307954592433366813086250408354607429702,
      0.9440558701362559779627747064152187467397203733821,
      0.95390078292549174284933693089435764464522145101467,
      0.96281365425581552729365932603016638643733150673041,
      0.97078577576370633193089785789750538855055719947821,
      0.97780935848691828855378108842920192863523449426625,
      0.9838775407060570154961001555110081673443670168508,
      0.98898439524299174800441874580773663183933363710695,
      0.99312493703744345965200989284878347073177145886652,
      0.99629513473312514918613173224113103543643128814043,
      0.99849195063959581840016335918634916230485485042057,
      0.9997137267734412336782284693423006767183495273084;
  map_points_[100] = points_100;
}

void Gauss_Legendre_Quadrature_Base::FillAdaptedWeights() {
  Eigen::VectorXd AdaptedWeights_8(8);
  AdaptedWeights_8 << 0.10122853629037625915253135430996219011539409105169,
      0.22238103445337447054435599442624088443013087005125,
      0.31370664587788728733796220198660131326032899900273,
      0.36268378337836198296515044927719561219414603989433,
      0.3626837833783619829651504492771956121941460398943,
      0.3137066458778872873379622019866013132603289990027,
      0.2223810344533744705443559944262408844301308700512,
      0.10122853629037625915253135430996219011539409105169;
  map_AdaptedWeights_[8] = AdaptedWeights_8;

  Eigen::VectorXd AdaptedWeights_10(10);
  AdaptedWeights_10 << 0.066671344308688137593568809893331792857864834320158,
      0.14945134915058059314577633965769733240255663966943,
      0.21908636251598204399553493422816319245877187052268,
      0.2692667193099963550912269215694693528597599384609,
      0.29552422471475287017389299465133832942104671702685,
      0.2955242247147528701738929946513383294210467170269,
      0.2692667193099963550912269215694693528597599384609,
      0.2190863625159820439955349342281631924587718705227,
      0.14945134915058059314577633965769733240255663966943,
      0.06667134430868813759356880989333179285786483432016;
  map_AdaptedWeights_[10] = AdaptedWeights_10;

  Eigen::VectorXd AdaptedWeights_12(12);
  AdaptedWeights_12 << 0.04717533638651182719461596148501706031702907399485,
      0.10693932599531843096025471819399622421457017347033,
      0.16007832854334622633465252954335907187201173049086,
      0.2031674267230659217490644558097983765065181472746,
      0.2334925365383548087608498989248780562594099721998,
      0.24914704581340278500056243604295121083046090256962,
      0.2491470458134027850005624360429512108304609025696,
      0.2334925365383548087608498989248780562594099721998,
      0.2031674267230659217490644558097983765065181472746,
      0.1600783285433462263346525295433590718720117304909,
      0.1069393259953184309602547181939962242145701734703,
      0.04717533638651182719461596148501706031702907399485;
  map_AdaptedWeights_[12] = AdaptedWeights_12;

  Eigen::VectorXd AdaptedWeights_14(14);
  AdaptedWeights_14 << 0.035119460331751863031832876138191780619705609277127,
      0.08015808715976020980563327706285430958369778539459,
      0.1215185706879031846894148090724766259566693456901,
      0.15720316715819353456960193862384215660566803733732,
      0.1855383974779378137417165901251570362489226029373,
      0.20519846372129560396592406566121805571033906130942,
      0.21526385346315779019587644331626003527499755805413,
      0.2152638534631577901958764433162600352749975580541,
      0.2051984637212956039659240656612180557103390613094,
      0.1855383974779378137417165901251570362489226029373,
      0.1572031671581935345696019386238421566056680373373,
      0.12151857068790318468941480907247662595666934569008,
      0.08015808715976020980563327706285430958369778539459,
      0.0351194603317518630318328761381917806197056092771;
  map_AdaptedWeights_[14] = AdaptedWeights_14;

  Eigen::VectorXd AdaptedWeights_16(16);
  AdaptedWeights_16 << 0.02715245941175409485178057245601810351226737556676,
      0.06225352393864789286284383699437769427498650835291,
      0.09515851168249278480992510760224622635526350318371,
      0.1246289712555338720524762821920164201448868592222,
      0.14959598881657673208150173054747854897049106820784,
      0.16915651939500253818931207903035996221163947341603,
      0.1826034150449235888667636679692199393835562236546,
      0.1894506104550684962853967232082831051469089883959,
      0.1894506104550684962853967232082831051469089883959,
      0.18260341504492358886676366796921993938355622365465,
      0.16915651939500253818931207903035996221163947341603,
      0.1495959888165767320815017305474785489704910682078,
      0.1246289712555338720524762821920164201448868592222,
      0.0951585116824927848099251076022462263552635031837,
      0.0622535239386478928628438369943776942749865083529,
      0.02715245941175409485178057245601810351226737556676;
  map_AdaptedWeights_[16] = AdaptedWeights_16;

  Eigen::VectorXd AdaptedWeights_18(18);
  AdaptedWeights_18 << 0.02161601352648331031334271026645246938768523147559,
      0.04971454889496979645333494620263864168086624612891,
      0.076425730254889056529129677616636525605317906208358,
      0.10094204410628716556281398492483460706280113888768,
      0.12255520671147846018451912680020155522816389733344,
      0.14064291467065065120473130375194722809550241033097,
      0.15468467512626524492541800383637477219321839626735,
      0.16427648374583272298605377646592759041233895399735,
      0.1691423829631435918406564701349866103341058193703,
      0.1691423829631435918406564701349866103341058193703,
      0.16427648374583272298605377646592759041233895399735,
      0.1546846751262652449254180038363747721932183962674,
      0.140642914670650651204731303751947228095502410331,
      0.1225552067114784601845191268002015552281638973334,
      0.10094204410628716556281398492483460706280113888768,
      0.07642573025488905652912967761663652560531790620836,
      0.0497145488949697964533349462026386416808662461289,
      0.02161601352648331031334271026645246938768523147559;
  map_AdaptedWeights_[18] = AdaptedWeights_18;

  Eigen::VectorXd AdaptedWeights_20(20);
  AdaptedWeights_20 << 0.01761400713915211831186196235185281636214310554334,
      0.04060142980038694133103995227493210987909063998995,
      0.06267204833410906356950653518704160635160107657844,
      0.08327674157670474872475814322204620610017782858316,
      0.10193011981724043503675013548034987616669165602339,
      0.11819453196151841731237737771138228700504121954897,
      0.13168863844917662689849449974816313491611051114698,
      0.14209610931838205132929832506716493303451541339202,
      0.1491729864726037467878287370019694366926799040814,
      0.1527533871307258506980843319550975934919486451124,
      0.15275338713072585069808433195509759349194864511238,
      0.14917298647260374678782873700196943669267990408137,
      0.14209610931838205132929832506716493303451541339202,
      0.131688638449176626898494499748163134916110511147,
      0.11819453196151841731237737771138228700504121954897,
      0.10193011981724043503675013548034987616669165602339,
      0.0832767415767047487247581432220462061001778285832,
      0.06267204833410906356950653518704160635160107657844,
      0.04060142980038694133103995227493210987909063999,
      0.017614007139152118311861962351852816362143105543337;
  map_AdaptedWeights_[20] = AdaptedWeights_20;

  Eigen::VectorXd AdaptedWeights_40(40);
  AdaptedWeights_40 << 0.00452127709853319125847173287818533272783111019971,
      0.0104982845311528136147421710672796523767926213158,
      0.01642105838190788871286348488236392729234229334696,
      0.02224584919416695726150432418420857320703319667935,
      0.02793700698002340109848915750772107730255086205077,
      0.033460195282547847392678183086410848977241786653764,
      0.03878216797447201763997203129044616225345921123203,
      0.04387090818567327199167468604171549581100683717024,
      0.04869580763507223206143416044814638806784302737712,
      0.05322784698393682435499647977226050455532117182201,
      0.05743976909939155136661773091042598560010483585445,
      0.06130624249292893916653799640839859590259376351117,
      0.06480401345660103807455452956675273003269296420849,
      0.06791204581523390382569010823192398598419723837929,
      0.0706116473912867796954836308552868323595591039956,
      0.0728865823958040590605106834425178358575590809858,
      0.07472316905796826420018933626132467319120293442036,
      0.07611036190062624237155807592249482301255955384507,
      0.07703981816424796558830753428381024852443975416394,
      0.07750594797842481126372396295832632696366865278811,
      0.07750594797842481126372396295832632696366865278811,
      0.07703981816424796558830753428381024852443975416394,
      0.07611036190062624237155807592249482301255955384507,
      0.07472316905796826420018933626132467319120293442036,
      0.0728865823958040590605106834425178358575590809858,
      0.07061164739128677969548363085528683235955910399559,
      0.06791204581523390382569010823192398598419723837929,
      0.06480401345660103807455452956675273003269296420849,
      0.06130624249292893916653799640839859590259376351117,
      0.0574397690993915513666177309104259856001048358545,
      0.053227846983936824354996479772260504555321171822,
      0.0486958076350722320614341604481463880678430273771,
      0.0438709081856732719916746860417154958110068371702,
      0.03878216797447201763997203129044616225345921123203,
      0.03346019528254784739267818308641084897724178665376,
      0.0279370069800234010984891575077210773025508620508,
      0.0222458491941669572615043241842085732070331966794,
      0.016421058381907888712863484882363927292342293346958,
      0.0104982845311528136147421710672796523767926213158,
      0.00452127709853319125847173287818533272783111019971;
  map_AdaptedWeights_[40] = AdaptedWeights_40;

  Eigen::VectorXd AdaptedWeights_100(100);
  AdaptedWeights_100 << 7.34634490505671730406320658330336390670473562483e-4,
      0.001709392653518105239529358371491195243731385491463,
      0.002683925371553482419439590429001120081931114951,
      0.00365596120132637518234245872752519569920656740515,
      0.0046244500634221193510957890829784766503524952949,
      0.00558842800386551515721194634843921073131869400808,
      0.00654694845084532276415210333149526369993836336648,
      0.00749907325546471157882874401639778316358347894815,
      0.0084438714696689714026208349023010019346444598841,
      0.0093804196536944579514182376608121187307870432387,
      0.0103078025748689695857821017278353779760583438414,
      0.0112251140231859771172215733663335847772264195644,
      0.01213145766297949740774479244874817073696312331126,
      0.01302594789297154228555858375890179013496473584175,
      0.01390771070371877268795414910800463779518081214312,
      0.0147758845274413017688799875203542571693887431146,
      0.01562962107754600272393686595379192555246997980994,
      0.0164680861761452126431049800882107808211676616038,
      0.01729046056832358243934419836674167481162350856517,
      0.01809594072212811666439075142049303134757874495839,
      0.01888373961337490455294116588154323429711127634742,
      0.019653087494435305865381470245444065555269599491251,
      0.02040323264620943276683885165758377060570969930262,
      0.02113344211252764154267230044096968163532972887451,
      0.0218430024162473863139537413043980247653489998232,
      0.02253122025633627270179697093167396234015893534871,
      0.02319742318525412162248885418272728845115448573609,
      0.0238409602659682059625604119022834321447074490926,
      0.024461202707957052719975023349772890646295732397804,
      0.02505754448157958970376422562092326422383855852793,
      0.02562940291020811607564200986215087092697767002027,
      0.02617621923954567634230874175730188501127513119069,
      0.02669745918357096266038466418633635063465575039001,
      0.027192613446576880136491567802170692266987896012,
      0.02766119822079238829420415587042645529240035866422,
      0.02810275565910117331764833018699455045141809940021,
      0.028516854322395097990936762864457873259842725484,
      0.028903089601125203134876228134515265315607868055261,
      0.02926108411063827662011902349564095444308419504535,
      0.0295904880599126425117545106788365851728062850714,
      0.029890979593332830916836806668595827658091414260799,
      0.0301622651051691449190686816104792326571023257827,
      0.030404079526454820016507859818825176605607248310117,
      0.0306161865839804484964594432620531928530860237891,
      0.03079837903115259042771390303055976009497083447037,
      0.03095047885049098823406346347074792738298717776694,
      0.031072337427566516587810170242918034845915436348,
      0.0311638356962099067838183212171866533438363686839,
      0.03122488425484935773237649864809813488180274068218,
      0.03125542345386335694764247438619802878783383672609,
      0.03125542345386335694764247438619802878783383672609,
      0.0312248842548493577323764986480981348818027406822,
      0.03116383569620990678381832121718665334383636868393,
      0.03107233742756651658781017024291803484591543634796,
      0.0309504788504909882340634634707479273829871777669,
      0.0307983790311525904277139030305597600949708344704,
      0.03061618658398044849645944326205319285308602378906,
      0.0304040795264548200165078598188251766056072483101,
      0.03016226510516914491906868161047923265710232578271,
      0.0298909795933328309168368066685958276580914142608,
      0.0295904880599126425117545106788365851728062850714,
      0.0292610841106382766201190234956409544430841950453,
      0.02890308960112520313487622813451526531560786805526,
      0.02851685432239509799093676286445787325984272548397,
      0.0281027556591011733176483301869945504514180994002,
      0.02766119822079238829420415587042645529240035866422,
      0.027192613446576880136491567802170692266987896012,
      0.02669745918357096266038466418633635063465575039001,
      0.0261762192395456763423087417573018850112751311907,
      0.02562940291020811607564200986215087092697767002027,
      0.02505754448157958970376422562092326422383855852793,
      0.0244612027079570527199750233497728906462957323978,
      0.0238409602659682059625604119022834321447074490926,
      0.0231974231852541216224888541827272884511544857361,
      0.0225312202563362727017969709316739623401589353487,
      0.0218430024162473863139537413043980247653489998232,
      0.0211334421125276415426723004409696816353297288745,
      0.02040323264620943276683885165758377060570969930262,
      0.01965308749443530586538147024544406555526959949125,
      0.01888373961337490455294116588154323429711127634742,
      0.01809594072212811666439075142049303134757874495839,
      0.0172904605683235824393441983667416748116235085652,
      0.0164680861761452126431049800882107808211676616038,
      0.0156296210775460027239368659537919255524699798099,
      0.0147758845274413017688799875203542571693887431146,
      0.01390771070371877268795414910800463779518081214312,
      0.01302594789297154228555858375890179013496473584175,
      0.01213145766297949740774479244874817073696312331126,
      0.01122511402318597711722157336633358477722641956438,
      0.0103078025748689695857821017278353779760583438414,
      0.00938041965369445795141823766081211873078704323867,
      0.0084438714696689714026208349023010019346444598841,
      0.0074990732554647115788287440163977831635834789481,
      0.00654694845084532276415210333149526369993836336648,
      0.0055884280038655151572119463484392107313186940081,
      0.00462445006342211935109578908297847665035249529489,
      0.00365596120132637518234245872752519569920656740515,
      0.002683925371553482419439590429001120081931114951,
      0.00170939265351810523952935837149119524373138549146,
      7.34634490505671730406320658330336390670473562483E-4;
  map_AdaptedWeights_[100] = AdaptedWeights_100;
}
}  // namespace xtp
}  // namespace votca
