---
myst:
  html_meta:
    keywords: LaTeX, R, Quarto, statistiques
---

# Quels sont les trucs et réglages pour LaTeX ?

Les réglages de base dans la chaîne `Quarto` vers LaTeX sont tout à fait
corrects mais on peut être amené à les personnaliser.

## Amélioration de l'en-tête

Un grand nombre de réglages sont directement pris en charge en `yaml` (pour être
précis, ces commandes sont gérées par `pandoc`, voir la
[documentation](https://pandoc.org/MANUAL.html#variables-for-latex) pour une
liste complète) comme par exemple :

```yaml
pdf-engine: lualatex     # Choix du moteur utilisé
keep-tex: true           # Conserver les fichiers .tex après compilation
number-sections: true    # Numérotation des sections
toc: true                # Table des matières
lof: true                # Liste des figures
lot: true                # Liste des tableaux
fig-cap-location: bottom # Emplacement des légendes des figures
tbl-cap-location: top    # Emplacement des légendes des tableaux
classoption: [french]    #  Langue du document
papersize: a4            # Format du papier
bibliography: stat.bib   # Choix du fichier de bibliographie
cite-method: biblatex    # Méthode de citation 
```

Pour d'autres choix, il faut entrer son code LaTeX comme :

```yaml
include-in-header:
   text: |
    \definecolor{maison}{HTML}{27484b}
    \usepackage[locale = FR, per-mode = symbol]{siunitx}
    \usepackage{hyperref}
    \usepackage[abbreviations,nonumberlist, automake]{glossaries-extra}
    \usepackage{glossaries-babel}
    \setabbreviationstyle{long-short-sc}
    \makeglossaries
```

Attention au package <ctanpkg:hyperref> : même s'il est déjà chargé par `Quarto`
avec des options correctes, pour créer un glossaire par exemple, il faut le
charger avant le package `glossaries-extra`.

Si vos réglages sont longs et complexes, il peut être préférable de les placer
dans un fichier `.tex` et de les appeler dans l'en-tête `yaml` avec :
 
 ```yaml
format:
  pdf:
    include-in-header:
      file: reglages.tex
``` 

## Usage dans le texte

Il est parfaitement possible d'incorporer directement du code LaTeX dans le
texte de votre document `Quarto` écrit en `Markdown` :

```markdown
## Tests

Nous allons utiliser un $\chi^2$  ou autre\dots.
```
