---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, structures, 
              composition des mathématiques, ponctuation, points de suspension,
              trois petits points, points de suite
---

# Comment obtenir des points de suspension mathématiques ?

## Avec les commandes de base

Des [points de suspension](wpfr:Points_de_suspension) peuvent être nécessaires
dans des formules. Et pas uniquement en version horizontale. De base, 
LaTeX en fournit déjà plusieurs :

- `\dots` pour des points de suspension positionnés sur la ligne de base ;
- `\cdots` pour des points de suspension avec un `c`entrage vertical 
  dans la ligne de texte. Ils sont donc plus hauts que ceux obtenus 
  avec `\dots`) ;
- `\vdots` pour des points de suspension `v`erticaux ;
- `\ddots` pour des points de suspension en `d`iagonale. 

Voici un exemple les reprenant tous.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Observez bien la différence entre $\dots$ et $\cdots$ ! Cette dernière 
version se trouve souvent dans les tableaux et matrices.
\[
  \begin{array}{ccc}
    x_{11} & \cdots & x_{1p} \\
    \vdots & \ddots & \vdots \\
    x_{n1} & \cdots & x_{np}
  \end{array}
\]
\end{document}
```


## Avec l'extension <ctanpkg:graphicx>

En utilisant l'extension <ctanpkg:graphicx> (ou <ctanpkg:graphics>), 
vous pouvez inverser la diagonale suivie par `\ddots`, pour écrire 
les [matrices antisymétriques](wpfr:Matrice_antisymétrique), de cette façon :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{graphics}

\begin{document}
\Large $a \reflectbox{$\ddots$} z$
\end{document}
```

Cette méthode fonctionne, mais elle n'est pas recommandée pour obtenir 
le résultat souhaité (la suite de cette page précise ce point). Pour répondre
aux besoins plus pointus, il existe au moins trois extensions, 
listées ci-après.


## Avec l'extension <ctanpkg:mathtools>

L'extension <ctanpkg:mathtools> (ou <ctanpkg:amsmath>) fournit une panoplie
de points de suspension nommé en fonction de leur usage :

- `\dotsb` pour une utilisation entre des paires d'opérateurs `b`inaires ;
- `\dotsc` pour une utilisation entre des paires de virgules (`c`*omma*) ;
- `\dotsi` pour une utilisation avec des `i`ntégrales ;
- `\dotsm` pour une utilisation dans une `m`ultiplication ;
- `\dotso` pour les autres cas (`o`*ther*).

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
Soit la série $A_1, A_2, \dotsc$, on peut en faire la somme 
$A_1+A_2 +\dotsb $, le produit $A_1 A_2 \dotsm $, mais aussi l'intégrer 
comme ceci :
\[  \int_{A_1}\int_{A_2}\dotsi  \]
\end{document}
```


## Avec l'extension <ctanpkg:yhmath>

L'extension <ctanpkg:yhmath>, de Yannis Haralambous, définit une commande 
`\adots`, qui est l'analogue de `\ddots`, mais inclinée vers l'avant plutôt que
vers l'arrière. L'extension est fournie avec une police de caractères 
plutôt intéressante qui étend la police standard *Computer Modern* `cmex` ; 
la [documentation](texdoc:yhmath) de l'extension détaille ce point.


## Avec l'extension <ctanpkg:mathdots> 

L'extension <ctanpkg:mathdots> est spécialisée dans les points de suspension. 
En plus de corriger le comportement des `\ddots` et `\vdots` de TeX et LaTeX
 lorsque la taille de caractère change (voir les tableaux comparatifs 
 ci-dessous), elle fournit des points de suspension en "diagonale inverse",
 avec `\iddots` (qui fait donc le même travail que `\adots` 
 de <ctanpkg:yhmath>, mais en y apportant ses corrections).


::::{tab-set}

:::{tab-item} Sans <ctanpkg:mathdots>
```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}
  % 
  \usepackage{xcolor} % Pour le gris de l'exemple

  \def\dott#1{$#1$}
  \def\dotts#1{$2^{#1}\quad 2^{2^{#1}}$}
  \renewcommand\arraystretch{1.4}

\begin{document}
\begin{tabular}{c|cccc}
  \multicolumn{1}{c}{\textbf{Commande}}%
    & \textbf{Large}          & \textbf{normal}   
    & \textbf{scriptsize}     & \textbf{en exposant}              \\
  \hline
  \verb$\ddots$      & \Large\dott{\ddots}    & \dott{\ddots}   
    & \scriptsize\dott{\ddots}      & \dotts{\ddots}              \\
  \verb$\vdots$      & \Large\dott{\vdots}    & \dott{\vdots}    
    & \scriptsize\dott{\vdots}      & \dotts{\vdots}              \\
  \color{black!30!white}\verb$\iddots$ 
    & \multicolumn{4}{c}{\color{black!30!white}Non disponible}    \\
  \verb$\dddot{X}$   & \Large\dott{\dddot{X}} & \dott{\dddot{X}} 
    & \scriptsize\dott{\dddot{X}}   & \dotts{\dddot{X}}           \\
  \verb$\ddddot{X}$  & \Large\dott{\ddddot{X}}& \dott{\ddddot{X}}
    & \scriptsize\dott{\ddddot{X}}  & \dotts{\ddddot{X}}
\end{tabular}
\end{document}
```
:::

:::{tab-item} Avec <ctanpkg:mathdots>

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}
  \usepackage{mathdots}
  %

  \def\dott#1{$#1$}
  \def\dotts#1{$2^{#1}\quad 2^{2^{#1}}$}
  \renewcommand\arraystretch{1.4}

\begin{document}
\begin{tabular}{c|cccc}
  \multicolumn{1}{c}{\textbf{Commande}}%
    & \textbf{Large}          & \textbf{normal}   
    & \textbf{scriptsize}     & \textbf{en exposant}              \\
  \hline
  \verb$\ddots$      & \Large\dott{\ddots}    & \dott{\ddots}   
    & \scriptsize\dott{\ddots}      & \dotts{\ddots}              \\
  \verb$\vdots$      & \Large\dott{\vdots}    & \dott{\vdots}    
    & \scriptsize\dott{\vdots}      & \dotts{\vdots}              \\
  \verb$\iddots$     & \Large\dott{\iddots}   & \dott{\iddots}  
    & \scriptsize\dott{\iddots}     & \dotts{\iddots}             \\
  \verb$\dddot{X}$   & \Large\dott{\dddot{X}} & \dott{\dddot{X}} 
    & \scriptsize\dott{\dddot{X}}   & \dotts{\dddot{X}}           \\
  \verb$\ddddot{X}$  & \Large\dott{\ddddot{X}}& \dott{\ddddot{X}}
    & \scriptsize\dott{\ddddot{X}}  & \dotts{\ddddot{X}}
\end{tabular}
\end{document}
```
:::

::::

Les commandes `\dddot` et `\ddddot` sont fournies par <ctanpkg:amsmath> 
et corrigées par <ctanpkg:mathdots>. Il vous faut donc charger 
les deux extensions dans l'ordre suivant pour éviter tout problème :

```{noedit}
\usepackage{amsmath}
\usepackage{mathdots}
```


:::{sources}
- [Ellipses](faquk:FAQ-mathlips)
:::