---
myst:
  html_meta:
    keywords: LaTeX, composition, tableaux, tabulations, erreurs, accents, tabbing,
              composition des tableaux, tabulations
---

# Comment utiliser des accents dans un environnement `tabbing` ?

:::{todo} Ajouter des exemples compilés.
:::

Afin d'obtenir des [tabulations](/3_composition/tableaux/tabulations/start), 
vous construisez un environnement `tabbing`. Mais voici que vous avez besoin 
d'un signe [diacritique](wpfr:Diacritique) (accent ou cédille), 
avec une commande comme `\'{e}`. Là, l'accent disparaît parce qu'il a été 
interprété comme une commande de l'environnement `tabbing`. En effet, 
les commandes `\'` et ```` \` ```` sont redéfinies par l'environnement 
`tabbing`.

En fait, à l'origine, pour taper des caractères accentués dans cet environnement, 
vous deviez utiliser la commande `\a`, autrement dit `\a'{e}` au lieu de `\'{e}`. 
De même, il fallait utiliser `\a` pour `\` et `\a=` pour `\=`. 
Toute cette procédure s'avèrait lourde et sujette aux erreurs. 

Depuis 2018, ce problème n'en est plus véritablement un : la question 
"[](/2_programmation/encodage/pourquoi_m_embeter_avec_inputenc_et_fontenc)"
indique que la première solution ci-dessous est implicitement appliquée
par LaTeX, ce dernier chargeant `\usepackage[utf8]{inputenc}`. Ceci permet
une saisie naturelle des lettres accentuées. Les solutions citées ici ont donc
une valeur historique.


## Par saisie directe

L'alternative la plus simple est d'employer un encodage 
contenant les caractères diacritiques et d'utiliser un fichier de définition 
d'encodage approprié dans l'extension <ctanpkg:inputenc>, ce qui évite 
les saisies d'accent comme `\'{e}`. Par exemple, saisissez :

```{noedit}
  \usepackage[latin1]{inputenc}
  ...
  \begin{tabbing}
  ...
  ... \> voilà  \> ...
```


## Avec l'extension <ctanpkg:Tabbing>

L'extension <ctanpkg:Tabbing> (avec un `T` majuscule) fournit un environnement
`Tabbing` qui duplique `tabbing`, à ceci près que toutes les commandes 
à caractère unique sont remplacées par des commandes avec des noms plus longs.
Ainsi `\>` devient `\TAB>`, `\=` devient `\TAB=` et ainsi de suite. 
L'exemple trivial ci-dessus deviendrait donc :

```{noedit}
\usepackage{Tabbing}
...
\begin{Tabbing}
  ...
  ... \TAB> voil\`a \TAB> ...
```


:::{sources}
[Accents misbehave in tabbing](faquk:FAQ-tabacc)
:::