# 2022-05-03 Triage Log

Performance overall improved in the last week, but some of this is due to fixing
regressions from prior weeks. This week also brings an average of 4% improvement
in memory usage across all profiles due to
[#95171](https://github.com/rust-lang/rust/pull/95171) bumping the LLVM/clang
used on x86_64-unknown-linux-gnu to compile C and C++ code linked into rustc.

Triage done by **@simulacrum**.
Revision range: [1c988cfa0b7f4d3bc5b1cb40dc5002f5adbfb9ad..468492c2af3993f18b1fe98052200575c4a2e678](https://perf.rust-lang.org/?start=1c988cfa0b7f4d3bc5b1cb40dc5002f5adbfb9ad&end=468492c2af3993f18b1fe98052200575c4a2e678&absolute=false&stat=instructions%3Au)

**Summary**:
|            | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:----------:|:------------------------------:|:--------------------------------:|:-------------------------------:|:---------------------------------:|:------------------------:|
| count      | 13                             | 1                                | 78                              | 29                                | 91                       |
| mean       | 0.8%                           | 0.3%                             | -0.9%                           | -0.8%                             | -0.7%                    |
| max        | 1.5%                           | 0.3%                             | -2.7%                           | -2.1%                             | -2.7%                    |


4 Regressions, 3 Improvements, 1 Mixed; 1 of them in rollups
52 artifact comparisons made in total

#### Regressions

Rollup of 8 pull requests [#96428](https://github.com/rust-lang/rust/pull/96428)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3d237ab52920924694f6fc3e47ee8588514bfa70&end=082e4ca49770ebc9cb0ee616f3726a67471be8cb&stat=instructions:u)
|            | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:----------:|:------------------------------:|:--------------------------------:|:-------------------------------:|:---------------------------------:|:------------------------:|
| count      | 7                              | 2                                | 1                               | 0                                 | 8                        |
| mean       | 1.3%                           | 0.3%                             | -0.4%                           | N/A                               | 1.1%                     |
| max        | 1.8%                           | 0.3%                             | -0.4%                           | N/A                               | 1.8%                     |

Looks likely to be related to the new [`impl Default for
AssertUnwindSafe`](https://github.com/rust-lang/rust/pull/95949), though
detailed query pages do not reflect the regressions. Marking the regression as
triaged, because it's unlikely we would want to revert the impl at this point.
However, it's probably the case that impls for public standard library types may
want to avoid being rolled up, as they can influence downstream performance
across both rustdoc and regular compilation.

Enforce Copy bounds for repeat elements while considering lifetimes [#95819](https://github.com/rust-lang/rust/pull/95819)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1c8966e5e9dc099b55206f34af81242d03bdb413&end=a707f401074bc769bab4efb2bfdde7f6c5a4068d&stat=instructions:u)
|            | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:----------:|:------------------------------:|:--------------------------------:|:-------------------------------:|:---------------------------------:|:------------------------:|
| count      | 2                              | 0                                | 0                               | 0                                 | 2                        |
| mean       | 0.8%                           | N/A                              | N/A                             | N/A                               | 0.8%                     |
| max        | 1.0%                           | N/A                              | N/A                             | N/A                               | 1.0%                     |

Incremental-only regressions in a single benchmark. Looks likely to be a
somewhat real change, but not one we can do much about: the extra enforcement
naturally adds dependency edges which require re-computing.

Handle generic bounds in a uniform way in HIR [#93803](https://github.com/rust-lang/rust/pull/93803)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=76d4862fdd131b6f79dc0a31857f888d26bcdb27&end=d201c812d40932509b2b5307c0b20c1ce78d21da&stat=instructions:u)
|            | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:----------:|:------------------------------:|:--------------------------------:|:-------------------------------:|:---------------------------------:|:------------------------:|
| count      | 11                             | 4                                | 0                               | 0                                 | 11                       |
| mean       | 0.3%                           | 0.3%                             | N/A                             | N/A                               | 0.3%                     |
| max        | 0.5%                           | 0.3%                             | N/A                             | N/A                               | 0.5%                     |

A regression primarily to diesel (quite common this week), but relatively slight
and with a relatively good tradeoff to code maintenance. Earlier PR runs had
some slight improvements which were used as a justification for regresions on
benchmarks; this doesn't seem to be the case anymore, so asked for an updated
justification on the regression.

Inline core::panic::Location methods [#96348](https://github.com/rust-lang/rust/pull/96348)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d201c812d40932509b2b5307c0b20c1ce78d21da&end=579d26876ddc5426be32cca1a026b6fd7fc5be24&stat=instructions:u)
|            | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:----------:|:------------------------------:|:--------------------------------:|:-------------------------------:|:---------------------------------:|:------------------------:|
| count      | 0                              | 11                               | 0                               | 0                                 | 0                        |
| mean       | N/A                            | 0.5%                             | N/A                             | N/A                               | N/A                      |
| max        | N/A                            | 0.8%                             | N/A                             | N/A                               | N/A                      |

Secondary-only regressions, most likely due to slightly different codegen in
relatively hot code (e.g., due to increased or decreased register pressure). Not
likely to be an important change.

#### Improvements

Fix incremental perf regression unsafety checking [#96425](https://github.com/rust-lang/rust/pull/96425)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=082e4ca49770ebc9cb0ee616f3726a67471be8cb&end=a7197189cd0e3a86d1b661d1dceb8bdff021d0b8&stat=instructions:u)
|            | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:----------:|:------------------------------:|:--------------------------------:|:-------------------------------:|:---------------------------------:|:------------------------:|
| count      | 0                              | 0                                | 48                              | 0                                 | 48                       |
| mean       | N/A                            | N/A                              | -1.2%                           | N/A                               | -1.2%                    |
| max        | N/A                            | N/A                              | -2.8%                           | N/A                               | -2.8%                    |

Reduce duplication of RPO calculation of mir [#96500](https://github.com/rust-lang/rust/pull/96500)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0c8e520b3e0d9fbdafb8311f1b18a1f847531051&end=9a98c63b30bd8419be662b8fb3f3b22ba33d72c5&stat=instructions:u)
|            | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:----------:|:------------------------------:|:--------------------------------:|:-------------------------------:|:---------------------------------:|:------------------------:|
| count      | 0                              | 0                                | 43                              | 17                                | 43                       |
| mean       | N/A                            | N/A                              | -0.5%                           | -0.7%                             | -0.5%                    |
| max        | N/A                            | N/A                              | -0.9%                           | -1.4%                             | -0.9%                    |

Move Derefer before Retag [#96549](https://github.com/rust-lang/rust/pull/96549)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=508e0584e384556b7e66f57b62e4feeba864b6da&end=6eda7642bd284d3d2bc6a1d57b68e2ef2b65e062&stat=instructions:u)
|            | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:----------:|:------------------------------:|:--------------------------------:|:-------------------------------:|:---------------------------------:|:------------------------:|
| count      | 0                              | 0                                | 20                              | 18                                | 20                       |
| mean       | N/A                            | N/A                              | -0.4%                           | -0.4%                             | -0.4%                    |
| max        | N/A                            | N/A                              | -0.4%                           | -0.6%                             | -0.4%                    |


#### Mixed

Inline `__iterator_get_unchecked` for some iterator adapters. [#92566](https://github.com/rust-lang/rust/pull/92566)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=bed05e996e37e44b1a3980b84754af621fd3c4ce&end=3d0ac7ea23888438752957eeeb5aa2b73b4fda72&stat=instructions:u)
|            | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:----------:|:------------------------------:|:--------------------------------:|:-------------------------------:|:---------------------------------:|:------------------------:|
| count      | 1                              | 2                                | 3                               | 1                                 | 4                        |
| mean       | 0.2%                           | 0.3%                             | -0.4%                           | -0.2%                             | -0.2%                    |
| max        | 0.2%                           | 0.3%                             | -0.4%                           | -0.2%                             | -0.4%                    |

Update LLVM used for building rustc in CI for x64 [#95171](https://github.com/rust-lang/rust/pull/95171)
[(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b2c2a32870e15af02eb89de434c36535439dbf5a&end=1388b38c52d1ca9fbc80bf42fa007504fb0b1b41)
|            | Regressions 😿 <br />(primary) | Regressions 😿 <br />(secondary) | Improvements 🎉 <br />(primary) | Improvements 🎉 <br />(secondary) | All 😿 🎉 <br />(primary) |
|:----------:|:------------------------------:|:--------------------------------:|:-------------------------------:|:---------------------------------:|:------------------------:|
| count      | 0                              | 0                                | 1                               | 0                                 | 1                        |
| mean       | N/A                            | N/A                              | -0.5%                           | N/A                               | -0.5%                    |
| max        | N/A                            | N/A                              | -0.5%                           | N/A                               | -0.5%                    |

A solid improvement in memory usage, with a rough average of 4% less memory used
across many check, debug, and opt builds, presumably due to better
optimizations when compiling C and C++ code linked into rustc.

