# 2022-03-30 Triage Log

A mixed week: some minor regressions, but things overall improved for instruction counts.

Max RSS has gone up slightly over the past
[month](https://perf.rust-lang.org/?start=2022-03-01&end=2022-03-30&kind=percentfromfirst&stat=max-rss),
on the order of 0.5% regression according to benchmark summary. pnkfelix is
following up on that with rustc-perf team on
[zulip](https://rust-lang.zulipchat.com/#narrow/stream/247081-t-compiler.2Fperformance/topic/max-rss.20over.202022-03/near/277194155)

Triage done by **@pnkfelix**.
Revision range: [3ea44938e21f0de8ae7d4f6399a8a30f97867c70..3e7514670db841a7f0d7656f3b13b1c8b2c11599](https://perf.rust-lang.org/?start=3ea44938e21f0de8ae7d4f6399a8a30f97867c70&end=3e7514670db841a7f0d7656f3b13b1c8b2c11599&absolute=false&stat=instructions%3Au)

4 Regressions, 5 Improvements, 4 Mixed; 3 of them in rollups
63 comparisons made in total

#### Regressions

Rollup of 5 pull requests [#95250](https://github.com/rust-lang/rust/pull/95250)
- Arithmetic mean of relevant regressions: 2.2%
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=9f4dc0b4db892271cd0dada6e072775b5b5d6b1e&end=37b55c8a0cafdb60b9168da34f904acc70157df8&stat=instructions:u): 11.1% on `full` builds of `cargo-0.60.0 doc`
- [Already triaged](https://github.com/rust-lang/rust/pull/95250#issuecomment-1077821698) by oli-obk.
- it is solely in rustdoc, and oli-obk has a plan to address it in the long term.

Properly track `ImplObligations` [#91030](https://github.com/rust-lang/rust/pull/91030)
- Arithmetic mean of relevant regressions: 1.9%
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=600a80dedf71ce02e778e59f4884866c3030c819&end=d2df372bca13bb60979c909660e69f2451630e81&stat=instructions:u): 3.8% on `full` builds of `projection-caching check`
- [triaged](https://github.com/rust-lang/rust/pull/91030#issuecomment-1083360210); this was anticipated.
- The only primary regression was to diesel doc, and the regressions are justified by the improvement to the diagnostics.

Separate const prop lints from optimizations [#94934](https://github.com/rust-lang/rust/pull/94934)
- Arithmetic mean of relevant regressions: 1.2%
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=4b133a7e27c32e822e9ff774e4436f184f5a9752&end=63b8f01bb5ca277e7df8d7efe094ed4244c1790c&stat=instructions:u): 2.1% on `incr-full` builds of `unicode_normalization opt`
- [Already triaged](https://github.com/rust-lang/rust/pull/94934#issuecomment-1078950067) by oli-obk.
- In short: this was expected, becaused we are doing const-prop twice now.
- (The end-goal is stop optimizations from changing diagnostics. This PR is a step towards that goal.)

Rollup of 4 pull requests [#95448](https://github.com/rust-lang/rust/pull/95448)
- Arithmetic mean of relevant regressions: 1.5%
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=5e1d19d30723c287f049662474021f2b9a9894ce&end=9c06e1ba47e1077725a950e0b5d1870a89c8b536&stat=instructions:u): 2.5% on `incr-patched: io error 6144` builds of `issue-46449 debug`
- [triaged](https://github.com/rust-lang/rust/pull/95448#issuecomment-1083461959)
- The only primary benchmark impacted by this was `unicode-normalization-0.1.19`, and that only saw a 0.50% regression on incr-patched: println and a 0.36% regression on full build. We can ignore that.
- The only secondary benchmark impacted was issue-46449, which is trying to catch regression of quadratic blowup, not minor regressions.

#### Improvements

Introduce `TtParser` [#95159](https://github.com/rust-lang/rust/pull/95159)
- Arithmetic mean of relevant regressions: 0.3%
- Arithmetic mean of relevant improvements: -1.9%
- Arithmetic mean of all relevant changes: -1.7%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=5f37001055c29982f4c27ee9edd90449c8e07774&end=a4a5e79814fb4d1568fb0ea5ca50f810b071ae12&stat=instructions:u): -6.2% on `incr-unchanged` builds of `deep-vector check`


Overlap inherent impls [#95082](https://github.com/rust-lang/rust/pull/95082)
- Arithmetic mean of relevant improvements: -1.0%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=8a0c55046c7092d9e019dad03729e8d32e38df72&end=e70e211e99b3b7a4c3d75ff56598662530828f65&stat=instructions:u): -2.0% on `full` builds of `diesel-1.4.8 check`


resolve: Do not build expensive suggestions if they are not actually used [#95255](https://github.com/rust-lang/rust/pull/95255)
- Arithmetic mean of relevant improvements: -0.6%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=e70e211e99b3b7a4c3d75ff56598662530828f65&end=903427b2e807cb1292388940b3f44f3b061cfebf&stat=instructions:u): -2.1% on `full` builds of `projection-caching doc`


Fix perf issue for auto trait selection [#95333](https://github.com/rust-lang/rust/pull/95333)
- Arithmetic mean of relevant improvements: -3.1%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=62523045ec681ee8c2ecb8d395fbcaccf336284b&end=3badf5c51c33f15c3934ea0e91d27f60c8605024&stat=instructions:u): -10.1% on `full` builds of `cargo-0.60.0 doc`


Remove header field from clean::Function [#95096](https://github.com/rust-lang/rust/pull/95096)
- Arithmetic mean of relevant regressions: 0.3%
- Arithmetic mean of relevant improvements: -0.9%
- Arithmetic mean of all relevant changes: -0.8%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=e2301ca54320659835467072f37201591db959b5&end=11909e3588319235e28e99294e17cca11db1d7e2&stat=instructions:u): -1.4% on `full` builds of `await-call-tree doc`


#### Mixed

Change Thir to lazily create constants [#94876](https://github.com/rust-lang/rust/pull/94876)
- Arithmetic mean of relevant regressions: 1.6%
- Arithmetic mean of relevant improvements: -1.0%
- Arithmetic mean of all relevant changes: -0.3%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=d2df372bca13bb60979c909660e69f2451630e81&end=8d8135f003b35c3e109d013b2bed9ee9496da615&stat=instructions:u): -2.8% on `full` builds of `keccak check`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=d2df372bca13bb60979c909660e69f2451630e81&end=8d8135f003b35c3e109d013b2bed9ee9496da615&stat=instructions:u): 3.5% on `full` builds of `tuple-stress check`
- [Triaged](https://github.com/rust-lang/rust/pull/94876#issuecomment-1083486520).
- The changes to the primary benchmarks are almost universally green here.
- The secondary benchmarks are more of a mixed bag, but I think we can accept a 3.5% regression on tuple-stress given the overall benefits.

More macro expansion optimizations [#95259](https://github.com/rust-lang/rust/pull/95259)
- Arithmetic mean of relevant improvements: -1.5%
- Arithmetic mean of all relevant changes: -1.1%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=4ce257ff198d23bdf14e956fbf2fe0fed297201f&end=8a0c55046c7092d9e019dad03729e8d32e38df72&stat=instructions:u): -2.0% on `incr-unchanged` builds of `diesel check`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=4ce257ff198d23bdf14e956fbf2fe0fed297201f&end=8a0c55046c7092d9e019dad03729e8d32e38df72&stat=instructions:u): 0.4% on `incr-full` builds of `unicode-normalization-0.1.19 opt`
- [Already triaged](https://github.com/rust-lang/rust/pull/95259#issuecomment-1079476641) by nnethercote
- The perf wins clearly outweigh the losses here.

Rollup of 5 pull requests [#95382](https://github.com/rust-lang/rust/pull/95382)
- Arithmetic mean of relevant regressions: 2.2%
- Arithmetic mean of relevant improvements: -0.4%
- Arithmetic mean of all relevant changes: 1.2%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=ab0c2e18dceb7140626a158affb983ae81039bd0&end=62523045ec681ee8c2ecb8d395fbcaccf336284b&stat=instructions:u): -0.4% on `incr-unchanged` builds of `deeply-nested-multi check`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=ab0c2e18dceb7140626a158affb983ae81039bd0&end=62523045ec681ee8c2ecb8d395fbcaccf336284b&stat=instructions:u): 3.2% on `full` builds of `await-call-tree check`
- [Left comment](https://github.com/rust-lang/rust/pull/95382#issuecomment-1083505358)
- Changes to the primary benchmarks seem like a wash and probably ignorable (0.33% worse for unicode-normalization-0.1.19, 0.33% better for ripgrep-13.0.0).
- Re secondary benchmarks: 3% worse for await-call-tree (on six scenarios), which is more concerning. I assume PR #95120 is cause.
- Leaving as untriaged.

Lazy type-alias-impl-trait take two [#94081](https://github.com/rust-lang/rust/pull/94081)
- Arithmetic mean of relevant regressions: 0.5%
- Arithmetic mean of relevant improvements: -0.5%
- Arithmetic mean of all relevant changes: -0.3%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=1446d17b8f4bd3ff8dbfb129a7674165e06f9f4c&end=f132bcf3bdf6d3ff9be7d02e8d0088b99007cd5e&stat=instructions:u): -1.0% on `incr-full` builds of `wg-grammar check`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=1446d17b8f4bd3ff8dbfb129a7674165e06f9f4c&end=f132bcf3bdf6d3ff9be7d02e8d0088b99007cd5e&stat=instructions:u): 0.8% on `full` builds of `projection-caching check`
- [triaged](https://github.com/rust-lang/rust/pull/94081#issuecomment-1083519743)
- The actual performance changes indicate this ended up a win overall, based on the amount of green.

#### Untriaged Pull Requests

- [#95448 Rollup of 4 pull requests](https://github.com/rust-lang/rust/pull/95448)
- [#95382 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/95382)
- [#95250 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/95250)
- [#94876 Change Thir to lazily create constants](https://github.com/rust-lang/rust/pull/94876)
- [#94824 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/94824)
- [#94814 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/94814)
- [#94402 Revert "Auto merge of #92419 - erikdesjardins:coldland, r=nagisa"](https://github.com/rust-lang/rust/pull/94402)
- [#94333 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/94333)
- [#94295 Always evaluate all cfg predicate in all() and any()](https://github.com/rust-lang/rust/pull/94295)
- [#94130 Use undef for (some) partially-uninit constants](https://github.com/rust-lang/rust/pull/94130)
- [#94103 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/94103)
- [#94081 Lazy type-alias-impl-trait take two](https://github.com/rust-lang/rust/pull/94081)
- [#94072 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/94072)
- [#93670 Apply noundef attribute to &T, &mut T, Box<T>, bool](https://github.com/rust-lang/rust/pull/93670)
- [#93505 safely `transmute<&List<Ty<'tcx>>, &List<GenericArg<'tcx>>>`](https://github.com/rust-lang/rust/pull/93505)
- [#93466 Make dead code check a query.](https://github.com/rust-lang/rust/pull/93466)
- [#93312 Return an indexmap in `all_local_trait_impls` query](https://github.com/rust-lang/rust/pull/93312)
- [#93298 make `find_similar_impl_candidates` even fuzzier](https://github.com/rust-lang/rust/pull/93298)
- [#93288 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/93288)
- [#93154 debuginfo: Make sure that type names for closure and generator environments are unique in debuginfo.](https://github.com/rust-lang/rust/pull/93154)
- [#93148 Overhaul interning.](https://github.com/rust-lang/rust/pull/93148)
- [#93138 Rollup of 17 pull requests](https://github.com/rust-lang/rust/pull/93138)
- [#93095 Store a `Symbol` instead of an `Ident` in `AssocItem`](https://github.com/rust-lang/rust/pull/93095)
- [#92911 Guard against unwinding in cleanup code](https://github.com/rust-lang/rust/pull/92911)
- [#92896 Update some rustc dependencies to deduplicate them](https://github.com/rust-lang/rust/pull/92896)
- [#92844 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/92844)
- [#92816 Remove deprecated LLVM-style inline assembly](https://github.com/rust-lang/rust/pull/92816)
- [#92805 partially revertish `lazily "compute" anon const default substs`](https://github.com/rust-lang/rust/pull/92805)
- [#92535 Allow unwinding from OOM hooks](https://github.com/rust-lang/rust/pull/92535)
- [#92534 Hash `Ident` spans in all HIR structures](https://github.com/rust-lang/rust/pull/92534)

#### Nags requiring follow up

TODO: Nags

