# 2022-02-16 Triage Log

Only one outright regression this week. We had some very cool work from cjgillot
to prevent queries from doing expensive clones, by just forcing them all to be
`Copy`! Also, nnethercote's overhaul of interning yielded massive improvements
across many crates. Also, a slew of benchmarks were unexpectedly improved
[quite a lot][] by some changes to way we invoke the linker when building LLVM itself.

[quite a lot]: https://perf.rust-lang.org/compare.html?start=8d163e66211c529465868a22686f46c5956342a4&end=6655109f58b7d0f4cae7e04eab476e389c9b9a0f

Triage done by **@pnkfelix**.
Revision range: [775e480722c7aba6ff4ff3ccec8c1f4639ae7889..a240ccd81c74c105b6f5fe84c46f8d36edb7e306](https://perf.rust-lang.org/?start=775e480722c7aba6ff4ff3ccec8c1f4639ae7889&end=a240ccd81c74c105b6f5fe84c46f8d36edb7e306&absolute=false&stat=instructions%3Au)

2 Regressions, 2 Improvements, 4 Mixed; 0 of them in rollups
47 comparisons made in total

#### Regressions

Inherit lifetimes for async fn instead of duplicating them. [#91403](https://github.com/rust-lang/rust/issues/91403)
- Average relevant regression: 1.7%
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=5d8767cb229b097fedb1dd4bd9420d463c37774f&end=3cfa4def7c87d571bd46d92fed608edf8fad236e&stat=instructions:u): 2.0% on `full` builds of `issue-88862 check`
- This regression was predicted by a rust-timer build when PR was first proposed, ...
- ... but there was no follow-up on those results at that time; left comment on PR.

Apply noundef attribute to &T, &mut T, Box<T>, bool [#93670](https://github.com/rust-lang/rust/issues/93670)
- Average relevant regression: 0.7%
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=3cfa4def7c87d571bd46d92fed608edf8fad236e&end=5c30d6568383916ce97cdf20ceb61a8b9e5bb5a8&stat=instructions:u): 1.1% on `full` builds of `regression-31157 debug`
- PR author [says](https://github.com/rust-lang/rust/pull/93670#issuecomment-1038347581) that Cachegrind indicates this is due to overhead of inserting attribute itself.
- PR author also says there is related work in LLVM 14 that may help ease the performance impact here, so stay tuned for when that lands in PR [#93577](https://github.com/rust-lang/rust/pull/93577)

#### Improvements

Ensure that queries only return Copy types. [#93511](https://github.com/rust-lang/rust/issues/93511)
- Average relevant improvement: -2.3%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=5d6ee0db96aada145725838379f909bbb8aa2312&end=56cd04af5c389b6ab676ba16f59d9f70bc465090&stat=instructions:u): -6.1% on `incr-unchanged` builds of `externs debug`

bootstrap: tidy up flag handling for llvm build [#93918](https://github.com/rust-lang/rust/issues/93918)
- Average relevant improvement: -1.6%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=8d163e66211c529465868a22686f46c5956342a4&end=6655109f58b7d0f4cae7e04eab476e389c9b9a0f&stat=instructions:u): -5.4% on `full` builds of `helloworld check`

Inline a few trivial conversion functions [#94021](https://github.com/rust-lang/rust/issues/94021)
- Average relevant improvement: -0.5%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=09cb29c64c2a0e15debf2d6fca2bc7c71a682033&end=393fdc10483da930cdbb00eabc3635030d2e776f&stat=instructions:u): -1.1% on `full` builds of `deeply-nested-async check`

#### Mixed

Revert lazy TAIT PR [#93893](https://github.com/rust-lang/rust/issues/93893)
- Average relevant regression: 1.0%
- Average relevant improvement: -1.2%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=78450d2d602b06d9b94349aaf8cece1a4acaf3a8&end=6499c5e7fc173a3f55b7a3bd1e6a50e9edef782d&stat=instructions:u): -1.8% on `full` builds of `deeply-nested-async check`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=78450d2d602b06d9b94349aaf8cece1a4acaf3a8&end=6499c5e7fc173a3f55b7a3bd1e6a50e9edef782d&stat=instructions:u): 1.6% on `full` builds of `wg-grammar check`
- Left comment: we had to revert the TAIT PR, the fallout from it was too high. Marked as triaged.

Implement `tainted_by_errors` in MIR borrowck, use it to skip CTFE [#93691](https://github.com/rust-lang/rust/issues/93691)
- Average relevant regression: 1.7%
- Average relevant improvement: -0.4%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=fc323035ac49b8d834fc2a0f580af8fd45e90b30&end=9cdefd763b910ffd1d42233a8c752ab5fd84ca4d&stat=instructions:u): -0.6% on `incr-unchanged` builds of `keccak check`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=fc323035ac49b8d834fc2a0f580af8fd45e90b30&end=9cdefd763b910ffd1d42233a8c752ab5fd84ca4d&stat=instructions:u): 2.4% on `incr-patched: u8 3072` builds of `issue-46449 debug`
- There were three experiments done for this PR, with distinct commits: [first run](https://github.com/rust-lang/rust/pull/93691#issuecomment-1031790883), [second run](https://github.com/rust-lang/rust/pull/93691#issuecomment-1032982905), [third run](https://github.com/rust-lang/rust/pull/93691#issuecomment-1033577005).
- The second experiment is what landed; the first experiment had smaller max and average values in its summary, but it regressed far more crates overall, while the second experiment regressed only a few crates, each by slightly more than the first experiment.
- In any case, this was expected fallout from this PR.

make `find_similar_impl_candidates` even fuzzier [#93298](https://github.com/rust-lang/rust/issues/93298)
- Average relevant regression: 0.7%
- Average relevant improvement: -0.3%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=b321742c6c27494897a88cd5ac17ac20aa3469a1&end=52dd59ed2154f4158ae37e6994b678a6249a7bb0&stat=instructions:u): -0.3% on `full` builds of `inflate check`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=b321742c6c27494897a88cd5ac17ac20aa3469a1&end=52dd59ed2154f4158ae37e6994b678a6249a7bb0&stat=instructions:u): 0.8% on `full` builds of `keccak check`
- Not clear why this had a performance impact at all, as it should have only affected error reporting.

Overhaul interning. [#93148](https://github.com/rust-lang/rust/issues/93148)
- Average relevant regression: 1.0%
- Average relevant improvement: -1.1%
- Largest improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=6421a499a50adbaa7b5d0234bdd4817d970f0933&end=55697574915ca58c3fcd7b1c854c1c93e002dc85&stat=instructions:u): -4.5% on `full` builds of `projection-caching check`
- Largest regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=6421a499a50adbaa7b5d0234bdd4817d970f0933&end=55697574915ca58c3fcd7b1c854c1c93e002dc85&stat=instructions:u): 1.8% on `full` builds of `match-stress-enum check`
- This was a massive improvement, full stop.

#### Untriaged Pull Requests

- [#93893 Revert lazy TAIT PR](https://github.com/rust-lang/rust/pull/93893)
- [#93670 Apply noundef attribute to &T, &mut T, Box<T>, bool](https://github.com/rust-lang/rust/pull/93670)
- [#93466 Make dead code check a query.](https://github.com/rust-lang/rust/pull/93466)
- [#93312 Return an indexmap in `all_local_trait_impls` query](https://github.com/rust-lang/rust/pull/93312)
- [#93298 make `find_similar_impl_candidates` even fuzzier](https://github.com/rust-lang/rust/pull/93298)
- [#93288 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/93288)
- [#93154 debuginfo: Make sure that type names for closure and generator environments are unique in debuginfo.](https://github.com/rust-lang/rust/pull/93154)
- [#93148 Overhaul interning.](https://github.com/rust-lang/rust/pull/93148)
- [#93138 Rollup of 17 pull requests](https://github.com/rust-lang/rust/pull/93138)
- [#93095 Store a `Symbol` instead of an `Ident` in `AssocItem`](https://github.com/rust-lang/rust/pull/93095)
- [#92896 Update some rustc dependencies to deduplicate them](https://github.com/rust-lang/rust/pull/92896)
- [#92844 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/92844)
- [#92816 Remove deprecated LLVM-style inline assembly](https://github.com/rust-lang/rust/pull/92816)
- [#92805 partially revertish `lazily "compute" anon const default substs`](https://github.com/rust-lang/rust/pull/92805)
- [#92535 Allow unwinding from OOM hooks](https://github.com/rust-lang/rust/pull/92535)
- [#92534 Hash `Ident` spans in all HIR structures](https://github.com/rust-lang/rust/pull/92534)
- [#92356 Add {Add,Sub,Mul,Div,Rem,BitXor,BitOr,BitAnd}{,Assign}<$t> to Saturat…](https://github.com/rust-lang/rust/pull/92356)
- [#92277 rustc_metadata: Stop passing `CrateMetadataRef` by reference (step 1)](https://github.com/rust-lang/rust/pull/92277)
- [#92252 Update pulldown-cmark version to 0.9](https://github.com/rust-lang/rust/pull/92252)
- [#92229 Do not display `~const Drop` in rustdoc](https://github.com/rust-lang/rust/pull/92229)
- [#92227 Rustdoc: use `is_doc_hidden` method on more places](https://github.com/rust-lang/rust/pull/92227)
- [#92149 Fix bad caching of `~const Drop` bounds](https://github.com/rust-lang/rust/pull/92149)
- [#92135 Add `#[inline]` modifier to `TypeId::of`](https://github.com/rust-lang/rust/pull/92135)
- [#92110 Backport LLVM changes to disable deferred inlining](https://github.com/rust-lang/rust/pull/92110)
- [#92106 Rollup of 4 pull requests](https://github.com/rust-lang/rust/pull/92106)
- [#92088 intra-doc: Use an enum to represent URL fragments](https://github.com/rust-lang/rust/pull/92088)
- [#92064 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/92064)
- [#92062 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/92062)
- [#92041 Remove 'speculative evaluation' of predicates](https://github.com/rust-lang/rust/pull/92041)
- [#92007 Lazy type-alias-impl-trait](https://github.com/rust-lang/rust/pull/92007)

#### Nags requiring follow up

TODO: Nags

