# 2021-12-14 Triage Log

This week's report started with 6 regressions; after eliminating truly obvious noise, we are left with just 2 minor regressions. Of the cases that regressed, I think the only interesting one is keccak (regressed by 1.73% in PR #91549). But don't be too depressed: keccak was also improved up to 23% by PR #85013 (!); thanks to @**simulacrum** for that PR.

Triage done by **@pnkfelix**.
Revision range: [e2116acae59654bfab2a9729a024f3e2fd6d4b02..404c8471aba60c2d837fa728e7c729a0f52d5830](https://perf.rust-lang.org/?start=e2116acae59654bfab2a9729a024f3e2fd6d4b02&end=404c8471aba60c2d837fa728e7c729a0f52d5830&absolute=false&stat=instructions%3Au)

2 Regressions, 5 Improvements, 3 Mixed; 1 of them in rollups
48 comparisons made in total

#### Regressions

"Support AVR for inline asm!" [#91224](https://github.com/rust-lang/rust/issues/91224)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=c5c94945096265b6d675b2f55a247c4799de8d87&end=0b6f079e4987ded15c13a15b734e7cfb8176839f&stat=instructions:u) (up to 0.8% on `incr-unchanged` builds of `externs`)
- This regression is solely isolated to variants of the `externs` benchmark.
- It seems like a near certainty that the regression reported here is noise exacerbated by this pathological benchmark.
- Marked as triaged.

"Eliminate ConstnessAnd again" [#91549](https://github.com/rust-lang/rust/issues/91549)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=6bda5b331cfe7e04e1fe348c58a928fc2b650f4f&end=22f8bde876f2fa9c5c4e95be1bce29cc271f2b51&stat=instructions:u) (up to 3.1% on `full` builds of `inflate`)
- This PR went through many rounds of performance evaluation and tuning.
- The only "real" regressions are likely to be `inflate` and `keccak`, and I am suspicious of `inflate` based on its sensitivity in other PR's.
- I'm leaving this PR in this week's report largely just to draw attention to the problem we face in trying to evalute impact of cases like this.

#### Improvements

"Avoid string validation in rustc_serialize, check a marker byte instead" [#91407](https://github.com/rust-lang/rust/issues/91407)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=0b6f079e4987ded15c13a15b734e7cfb8176839f&end=477fd7038c235689913abf9208dfa9371cbacd88&stat=instructions:u) (up to -2.9% on `full` builds of `helloworld`)


"Sync portable-simd to remove autosplats" [#91484](https://github.com/rust-lang/rust/issues/91484)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=477fd7038c235689913abf9208dfa9371cbacd88&end=11fb21fd0e4c42490d42f1baf6bc51516e5dc5f5&stat=instructions:u) (up to -7.8% on `full` builds of `helloworld`)


"replace vec::Drain drop loops with drop_in_place" [#85157](https://github.com/rust-lang/rust/issues/85157)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=3b263ceb5cb89b6d53b5a03b47ec447c3a7f7765&end=0b42deaccc2cbe17a68067aa5fdb76104369e1fd&stat=instructions:u) (up to -1.7% on `full` builds of `match-stress-enum`)


"replace dynamic library module with libloading" [#90716](https://github.com/rust-lang/rust/issues/90716)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=753e569c9c2a4e3ef394ef7abd0802bf57f66bce&end=6bda5b331cfe7e04e1fe348c58a928fc2b650f4f&stat=instructions:u) (up to -0.8% on `incr-unchanged` builds of `externs`)
- Don't get too excited kids, its just `externs`.

"manually implement Hash for DefId" [#91660](https://github.com/rust-lang/rust/issues/91660)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=8f117a77d0880ed59afcc1a19c72ec5c1e44b97c&end=a2d25b4ff71b3d8ec49dc6a384e65e6a3ea33116&stat=instructions:u) (up to -2.3% on `full` builds of `match-stress-enum`)
- `match-stress-enum` and `externs` are both pathological cases, so don't expect your compiles to get 2% faster.
- Nonetheless, this was a fun change. (Check out the dialogue and associated [blog post](https://nnethercote.github.io/2021/12/08/a-brutally-effective-hash-function-in-rust.html).)

#### Mixed

"Replace dominators algorithm with simple Lengauer-Tarjan" [#85013](https://github.com/rust-lang/rust/issues/85013)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=2af5c6562deed1878000e791f2cb21b981a53959&end=c67497a5da33eb3167a33e938920ce04d2b883a5&stat=instructions:u) (up to -23.6% on `full` builds of `keccak`)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=2af5c6562deed1878000e791f2cb21b981a53959&end=c67497a5da33eb3167a33e938920ce04d2b883a5&stat=instructions:u) (up to 0.4% on `incr-unchanged` builds of `helloworld`)


"Rollup of 6 pull requests" [#91799](https://github.com/rust-lang/rust/issues/91799)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=b8dc6aa673317cf72a8abb9c421f573f2b34b47a&end=928783de663bd855a96f14b2d38c1061603587c6&stat=instructions:u) (up to -5.9% on `incr-unchanged` builds of `inflate`)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=b8dc6aa673317cf72a8abb9c421f573f2b34b47a&end=928783de663bd855a96f14b2d38c1061603587c6&stat=instructions:u) (up to 0.8% on `incr-unchanged` builds of `issue-88862`)
- I don't yet now hat's up with the regression here to issue-88862.

"Deduplicate projection sub-obligations" [#90423](https://github.com/rust-lang/rust/issues/90423)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=a0a4c7d1e48c39a73119eb9107d402d60c83293b&end=4c9bdf4cbbf1deab0b5da398d4910558a66b332f&stat=instructions:u) (up to -6.2% on `full` builds of `deeply-nested`)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=a0a4c7d1e48c39a73119eb9107d402d60c83293b&end=4c9bdf4cbbf1deab0b5da398d4910558a66b332f&stat=instructions:u) (up to 0.5% on `full` builds of `regression-31157`)
- This is a targetted fix to address performance regressons that leaked into 1.57. It has been beta-nominated for backport.

#### Untriaged Pull Requests

- [#91902 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/91902)
- [#91841 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/91841)
- [#91799 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/91799)
- [#91776 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/91776)
- [#91766 Allow `memcmp` for more array comparisons](https://github.com/rust-lang/rust/pull/91766)
- [#91760 Rollup of 10 pull requests](https://github.com/rust-lang/rust/pull/91760)
- [#91680 Use spare_capacity_mut instead of invalid unchecked indexing when joining str](https://github.com/rust-lang/rust/pull/91680)
- [#91406 Rollup of 4 pull requests](https://github.com/rust-lang/rust/pull/91406)
- [#91354 Cleanup: Eliminate ConstnessAnd](https://github.com/rust-lang/rust/pull/91354)
- [#91318 Reduce boilerplate around infallible folders](https://github.com/rust-lang/rust/pull/91318)
- [#91288 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/91288)
- [#91269 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/91269)
- [#91255 Implement version of normalize_erasing_regions that allows for normalization failure](https://github.com/rust-lang/rust/pull/91255)
- [#91246 Faster `Layout::array`](https://github.com/rust-lang/rust/pull/91246)
- [#91230 Make `TypeFolder::fold_*` return `Result`](https://github.com/rust-lang/rust/pull/91230)
- [#91224 Support AVR for inline asm!](https://github.com/rust-lang/rust/pull/91224)
- [#91205 Visit `param_env` field in Obligation's `TypeFoldable` impl](https://github.com/rust-lang/rust/pull/91205)
- [#91073 rustdoc: Make two small cleanups](https://github.com/rust-lang/rust/pull/91073)
- [#91042 Use Vec extend instead of repeated pushes on several places](https://github.com/rust-lang/rust/pull/91042)
- [#90883 Rollup of 3 pull requests](https://github.com/rust-lang/rust/pull/90883)
- [#90839 Generate documentation in rustc `rustc_index::newtype_index` macro](https://github.com/rust-lang/rust/pull/90839)
- [#90821 MIRI says `reverse` is UB, so replace it with something LLVM can vectorize](https://github.com/rust-lang/rust/pull/90821)
- [#90788 Mark places as initialized when mutably borrowed](https://github.com/rust-lang/rust/pull/90788)
- [#90769 Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/90769)
- [#90750 rustdoc: Replace where-bounded Clean impl with simple function](https://github.com/rust-lang/rust/pull/90750)
- [#90746 Optimize pattern matching](https://github.com/rust-lang/rust/pull/90746)
- [#90695 Rollup of 4 pull requests](https://github.com/rust-lang/rust/pull/90695)
- [#90684 Change paths for `dist` command to match the components they generate](https://github.com/rust-lang/rust/pull/90684)
- [#90681 Update libc to 0.2.108](https://github.com/rust-lang/rust/pull/90681)
- [#90645 Implement diagnostic for String conversion](https://github.com/rust-lang/rust/pull/90645)
