# 2021-11-30 Triage Log

Overall, many changes this week, but overall an improvement on multiple benchmarks over
the week from a number of pull requests dedicated to optimizations of certain
patterns. We are still seeing a large number of spurious changes due to
[rustc-perf#1105](https://github.com/rust-lang/rustc-perf/issues/1105), which
has yet to be addressed.

Triage done by **@simulacrum**.
Revision range: [22c2d9ddbf356bcdb718e88ca6ee3665e1e42690..1c0287830e0fb3c4007afea2819ba03766da6e9c](https://perf.rust-lang.org/?start=22c2d9ddbf356bcdb718e88ca6ee3665e1e42690&end=1c0287830e0fb3c4007afea2819ba03766da6e9c&absolute=false&stat=instructions%3Au)

4 Regressions, 4 Improvements, 9 Mixed; 5 of them in rollups
41 comparisons made in total

#### Regressions

Mark places as initialized when mutably borrowed [#90788](https://github.com/rust-lang/rust/issues/90788)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=311fa1f14dd8ffbbe83b229a94b17f7f1ecaf33b&end=7b3cd075bbe309031b418650a9c32baf0b4a3276&stat=instructions:u) (up to 0.6% on `full` builds of `match-stress-enum`)
- Fix for a miscompilation, so necessary regression.

Visit `param_env` field in Obligation's `TypeFoldable` impl [#91205](https://github.com/rust-lang/rust/issues/91205)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=a7836bf885e70aaf1a2e0d4669406b183a79acaa&end=1e79d79dac11ce121b972fbaa0db9b0d1756b991&stat=instructions:u) (up to 6.6% on `full` builds of `hyper-2`)
- Fix for incorrect code, regressions unfortunately unavoidable.

#### Improvements

Rollup of 6 pull requests [#91159](https://github.com/rust-lang/rust/issues/91159)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=7b3cd075bbe309031b418650a9c32baf0b4a3276&end=65c55bf931a55e6b1e5ed14ad8623814a7386424&stat=instructions:u) (up to -0.6% on `full` builds of `match-stress-enum`)
- Presumably due to [#91140](https://github.com/rust-lang/rust/pull/91140).
  Otherwise not clear what the cause is, but as a small improvement, unlikely to
  devote significant time to it.

Optimize live point computation [#90491](https://github.com/rust-lang/rust/issues/90491)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=c6a7ca196a707acd65e6cce1d337cd11786c59a5&end=8a48b376d559f26a9b8fc1f1d597acb0bc0a51f9&stat=instructions:u) (up to -29.2% on `full` builds of `issue-58319`)
- Expected per PR benchmarking, benefitting both stress tests and some
  real-world code.

Remove eval_always from upvars. [#90580](https://github.com/rust-lang/rust/issues/90580)
- Small improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=37a49713cb256f4033a3c2fab4810c5a61e89dd9&end=dd549dcab404ec4c7d07b5a83aca5bdd7171138f&stat=instructions:u) (up to -0.7% on `incr-unchanged` builds of `style-servo`)
- Small optimization to query system.

Rollup of 8 pull requests [#91388](https://github.com/rust-lang/rust/issues/91388)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=90912e68ab0b9e7ba4f91ef9654e8b41c203a95d&end=1c0287830e0fb3c4007afea2819ba03766da6e9c&stat=instructions:u) (up to -1.5% on `full` builds of `futures`)
- Unclear cause for the improvement, but as an improvement, unlikely to
  devote significant time to it.

#### Mixed

Avoid generating empty closures for fieldless enum variants [#89881](https://github.com/rust-lang/rust/issues/89881)
- Small improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=22c2d9ddbf356bcdb718e88ca6ee3665e1e42690&end=311fa1f14dd8ffbbe83b229a94b17f7f1ecaf33b&stat=instructions:u) (up to -1.6% on `incr-patched: add static arr item` builds of `coercions`)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=22c2d9ddbf356bcdb718e88ca6ee3665e1e42690&end=311fa1f14dd8ffbbe83b229a94b17f7f1ecaf33b&stat=instructions:u) (up to 0.6% on `incr-unchanged` builds of `clap-rs`)
- Primarily benefits bootstrap time (-5.4 seconds, -0.7%), instruction count
  changes largely real but not avoidable (differences in LLVM decision making).

Remove eval_always for inherent_impls. [#90579](https://github.com/rust-lang/rust/issues/90579)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=982c552c908d179eaa38b6ef152ad3fa30268778&end=c6a7ca196a707acd65e6cce1d337cd11786c59a5&stat=instructions:u) (up to -5.6% on `incr-unchanged` builds of `stm32f4`)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=982c552c908d179eaa38b6ef152ad3fa30268778&end=c6a7ca196a707acd65e6cce1d337cd11786c59a5&stat=instructions:u) (up to 0.2% on `incr-full` builds of `stm32f4`)

Faster `Layout::array` [#91246](https://github.com/rust-lang/rust/issues/91246)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=6d246f0c8d3063fea86abbb65a824362709541ba&end=ccce98535bd51687554be8a209b3a529ef84f7e1&stat=instructions:u) (up to -4.2% on `incr-unchanged` builds of `deep-vector`)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=6d246f0c8d3063fea86abbb65a824362709541ba&end=ccce98535bd51687554be8a209b3a529ef84f7e1&stat=instructions:u) (up to 5.0% on `incr-unchanged` builds of `inflate`)
- Most prominent regression is spurious, and overall this looks like
  improvements outweighing regressions.

Rollup of 7 pull requests [#91269](https://github.com/rust-lang/rust/issues/91269)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=ccce98535bd51687554be8a209b3a529ef84f7e1&end=bbad745a688c933a43d1bd977756bd6fc7f034f2&stat=instructions:u) (up to -5.1% on `incr-unchanged` builds of `inflate`)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=ccce98535bd51687554be8a209b3a529ef84f7e1&end=bbad745a688c933a43d1bd977756bd6fc7f034f2&stat=instructions:u) (up to 18.3% on `incr-unchanged` builds of `clap-rs`)
- Regressions seem potentially real, but may also be related to
  [rustc-perf#1105](https://github.com/rust-lang/rustc-perf/issues/1105).
  Locally this seems to not be the case, though, so it seems probable that the
  regression is real.

Rollup of 6 pull requests [#91288](https://github.com/rust-lang/rust/issues/91288)
- Small improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=5fd3a5c7c175f228afaf5fc6ff00c177b83d8055&end=686e313a9aa14107c8631ffe48fa09110a7692db&stat=instructions:u) (up to -1.0% on `incr-patched: b9b3e592dd cherry picked` builds of `style-servo`)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=5fd3a5c7c175f228afaf5fc6ff00c177b83d8055&end=686e313a9aa14107c8631ffe48fa09110a7692db&stat=instructions:u) (up to 1.7% on `full` builds of `externs`)
- Seems to be a genuine regression. Unclear what the cause is.

Make `TypeFolder::fold_*` return `Result` [#91230](https://github.com/rust-lang/rust/issues/91230)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=58f9efd36de5669ab731ec7ebf565999ff17b159&end=e6d2de9483a27f846f003fc745713339a9122473&stat=instructions:u) (up to -1.0% on `incr-full` builds of `deeply-nested-async`)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=58f9efd36de5669ab731ec7ebf565999ff17b159&end=e6d2de9483a27f846f003fc745713339a9122473&stat=instructions:u) (up to 4.0% on `incr-unchanged` builds of `deep-vector`)
- Regressions seem genuine, but are likely to be shuffling of instruction
  sequences rather than something directly addressable.

Update libc to 0.2.108 [#90681](https://github.com/rust-lang/rust/issues/90681)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=db9d361a4731ca0bb48533fab6297a8fea75696f&end=350158dd6d7ba840666999efa9a19c6ae403eed1&stat=instructions:u) (up to -15.3% on `incr-unchanged` builds of `clap-rs`)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=db9d361a4731ca0bb48533fab6297a8fea75696f&end=350158dd6d7ba840666999efa9a19c6ae403eed1&stat=instructions:u) (up to 3.0% on `incr-unchanged` builds of `deeply-nested-async`)
- Looks like a genuine regression, potentially slightly more work at crate loading time.

Tokenize emoji as if they were valid identifiers  [#88781](https://github.com/rust-lang/rust/issues/88781)
- Small improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=c6eda7d8a7af3ef51311d3106874a7d8de994edc&end=23a436606b118bd2fbb12f64fce21e7f9d355349&stat=instructions:u) (up to -0.8% on `full` builds of `deeply-nested`)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=c6eda7d8a7af3ef51311d3106874a7d8de994edc&end=23a436606b118bd2fbb12f64fce21e7f9d355349&stat=instructions:u) (up to 0.3% on `incr-full` builds of `deeply-nested-async`)
- Genuine regression; more expensive logic in tokenization.

Rollup of 6 pull requests [#91221](https://github.com/rust-lang/rust/issues/91221)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=862962b90e59c5c1e217df74de80d3a81eee42f4&end=37a49713cb256f4033a3c2fab4810c5a61e89dd9&stat=instructions:u) (up to -1.3% on `incr-unchanged` builds of `wg-grammar`)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=862962b90e59c5c1e217df74de80d3a81eee42f4&end=37a49713cb256f4033a3c2fab4810c5a61e89dd9&stat=instructions:u) (up to 0.6% on `full` builds of `ctfe-stress-4`)
- Regression seems genuine, though cause is unclear.

#### Untriaged Pull Requests

[60 untriaged pull requests](https://github.com/rust-lang/rust/issues?q=is%3Amerged+label%3Aperf-regression+-label%3Aperf-regression-triaged+sort%3Acreated-asc).
