# 2021-06-08 Triage Log

Some good improvements, and a few regressions. No large changes.

Triage done by **@simulacrum**.
Revision range: [1160cf864f2a0014e3442367e1b96496bfbeadf4..a50d72158e08e02cfc051b863017bdbd2c45b637](https://perf.rust-lang.org/?start=1160cf864f2a0014e3442367e1b96496bfbeadf4&end=a50d72158e08e02cfc051b863017bdbd2c45b637&absolute=false&stat=instructions%3Au)

3 Regressions, 3 Improvements, 1 Mixed
1 of them in rollups

#### Regressions

Always go through the expn_that_defined query. [#86002](https://github.com/rust-lang/rust/issues/86002)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=ac3e680193a3e11e60b07840ffb1db12793de110&end=6c2dd251bbff03c7a3092d43fb5b637eca0810e3&stat=instructions:u) (up to 1.6% on `incr-patched: println` builds of `webrender-check`)
- Necessary for correctness, regresions largely limited to incremental.

Add variance-related information to lifetime error messages [#85343](https://github.com/rust-lang/rust/issues/85343)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=5b638c1d3751b7ab31cac9739add516bdf39e10a&end=35fff69d043b1c0f5c29894e7f4b0da8b039c131&stat=instructions:u) (up to 4.3% on `full` builds of `wg-grammar-check`)
- Seems to potentially be necessary, but difference from PR run suggests more
  can possibly be done to avoid some of the losses noted on the final merge.

Revert "Merge CrateDisambiguator into StableCrateId" [#85891](https://github.com/rust-lang/rust/issues/85891)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=022720bfccd46400e69def42f4647fe4059ad951&end=2312ff1a850db449b79fd3c4b215395cd2598c25&stat=instructions:u) (up to 4.9% on `full` builds of `html5ever-opt`)
- Reverted due to performance concerns on the original PR ([#85804]), but does
  not seem to have recovered performance. Suggested path is to re-land but with
  measurements the original PR; potentially there are some performance
  improvements that can be done there as well.

[#85804]: https://github.com/rust-lang/rust/pull/85804

#### Improvements

Remove CrateNum::ReservedForIncrCompCache [#85829](https://github.com/rust-lang/rust/issues/85829)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=7f9ab0300cd66f6f616e03ea90b2d71af474bf28&end=625d5a693e4697bcafdd34fd1a38c281acabb8e9&stat=instructions:u) (up to -11.2% on `full` builds of `deeply-nested-async-debug`)
- Unclear what the exact cause of the large improvement is. It may be worth
  investigating, as at first glance the change does not seem like it should have
  such strong effects.

Only compute the trait map once [#85905](https://github.com/rust-lang/rust/issues/85905)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=c4f186f0ea443db4aacdd90a2515632c20ccd3fe&end=d20b9add05d32761abad651f568f1b1831cb8cf6&stat=instructions:u) (up to -1.6% on `incr-unchanged` builds of `cranelift-codegen-check`)

Miscellaneous inlining improvements [#85892](https://github.com/rust-lang/rust/issues/85892)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=7350f655ef7e1b00f287eca6f8c0016a8985900c&end=1e13a9bb33debb931d603278b7f1a706b0d11660&stat=instructions:u) (up to -2.2% on `full` builds of `ctfe-stress-4-check`)

#### Mixed

Rollup of 13 pull requests [#85952](https://github.com/rust-lang/rust/issues/85952)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=016e9b5e33ef1407bffb575ec63d24241912556d&end=a93699f20a433797a4b84787b9652300dd7b2ad2&stat=instructions:u) (up to -4.8% on `full` builds of `html5ever-opt`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=016e9b5e33ef1407bffb575ec63d24241912556d&end=a93699f20a433797a4b84787b9652300dd7b2ad2&stat=instructions:u) (up to 2.9% on `incr-patched: println` builds of `cargo-opt`)
- Predominantly an improvement, some incremental regressions; does not appear
  worthwhile to investigate in depth the exact cause.

#### Nags requiring follow up

* Follow up on regression in [#85343](https://github.com/rust-lang/rust/pull/85343#issuecomment-856819536)
