// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{ffi, AnnotFlag, AnnotType, Color, Rectangle};
use glib::{prelude::*, translate::*};

glib::wrapper! {
    #[doc(alias = "PopplerAnnot")]
    pub struct Annot(Object<ffi::PopplerAnnot>);

    match fn {
        type_ => || ffi::poppler_annot_get_type(),
    }
}

impl Annot {
    pub const NONE: Option<&'static Annot> = None;
}

pub trait AnnotExt: IsA<Annot> + 'static {
    #[doc(alias = "poppler_annot_get_annot_type")]
    #[doc(alias = "get_annot_type")]
    fn annot_type(&self) -> AnnotType {
        unsafe {
            from_glib(ffi::poppler_annot_get_annot_type(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "poppler_annot_get_color")]
    #[doc(alias = "get_color")]
    fn color(&self) -> Option<Color> {
        unsafe { from_glib_full(ffi::poppler_annot_get_color(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "poppler_annot_get_contents")]
    #[doc(alias = "get_contents")]
    fn contents(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::poppler_annot_get_contents(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "poppler_annot_get_flags")]
    #[doc(alias = "get_flags")]
    fn flags(&self) -> AnnotFlag {
        unsafe { from_glib(ffi::poppler_annot_get_flags(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "poppler_annot_get_modified")]
    #[doc(alias = "get_modified")]
    fn modified(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::poppler_annot_get_modified(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "poppler_annot_get_name")]
    #[doc(alias = "get_name")]
    fn name(&self) -> Option<glib::GString> {
        unsafe { from_glib_full(ffi::poppler_annot_get_name(self.as_ref().to_glib_none().0)) }
    }

    #[doc(alias = "poppler_annot_get_page_index")]
    #[doc(alias = "get_page_index")]
    fn page_index(&self) -> i32 {
        unsafe { ffi::poppler_annot_get_page_index(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "poppler_annot_get_rectangle")]
    #[doc(alias = "get_rectangle")]
    fn rectangle(&self) -> Rectangle {
        unsafe {
            let mut poppler_rect = Rectangle::uninitialized();
            ffi::poppler_annot_get_rectangle(
                self.as_ref().to_glib_none().0,
                poppler_rect.to_glib_none_mut().0,
            );
            poppler_rect
        }
    }

    #[cfg(feature = "v24_12")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v24_12")))]
    #[doc(alias = "poppler_annot_set_border_width")]
    fn set_border_width(&self, width: f64) {
        unsafe {
            ffi::poppler_annot_set_border_width(self.as_ref().to_glib_none().0, width);
        }
    }

    #[doc(alias = "poppler_annot_set_color")]
    fn set_color(&self, poppler_color: Option<&Color>) {
        unsafe {
            ffi::poppler_annot_set_color(
                self.as_ref().to_glib_none().0,
                mut_override(poppler_color.to_glib_none().0),
            );
        }
    }

    #[doc(alias = "poppler_annot_set_contents")]
    fn set_contents(&self, contents: &str) {
        unsafe {
            ffi::poppler_annot_set_contents(
                self.as_ref().to_glib_none().0,
                contents.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "poppler_annot_set_flags")]
    fn set_flags(&self, flags: AnnotFlag) {
        unsafe {
            ffi::poppler_annot_set_flags(self.as_ref().to_glib_none().0, flags.into_glib());
        }
    }

    #[doc(alias = "poppler_annot_set_rectangle")]
    fn set_rectangle(&self, poppler_rect: &mut Rectangle) {
        unsafe {
            ffi::poppler_annot_set_rectangle(
                self.as_ref().to_glib_none().0,
                poppler_rect.to_glib_none_mut().0,
            );
        }
    }
}

impl<O: IsA<Annot>> AnnotExt for O {}
