// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

#![cfg(unix)]

use gstreamer_gl_sys::*;
use std::env;
use std::error::Error;
use std::ffi::OsString;
use std::mem::{align_of, size_of};
use std::path::Path;
use std::process::{Command, Stdio};
use std::str;
use tempfile::Builder;

static PACKAGES: &[&str] = &["gstreamer-gl-1.0"];

#[derive(Clone, Debug)]
struct Compiler {
    pub args: Vec<String>,
}

impl Compiler {
    pub fn new() -> Result<Self, Box<dyn Error>> {
        let mut args = get_var("CC", "cc")?;
        args.push("-Wno-deprecated-declarations".to_owned());
        // For _Generic
        args.push("-std=c11".to_owned());
        // For %z support in printf when using MinGW.
        args.push("-D__USE_MINGW_ANSI_STDIO".to_owned());
        args.extend(get_var("CFLAGS", "")?);
        args.extend(get_var("CPPFLAGS", "")?);
        args.extend(pkg_config_cflags(PACKAGES)?);
        Ok(Self { args })
    }

    pub fn compile(&self, src: &Path, out: &Path) -> Result<(), Box<dyn Error>> {
        let mut cmd = self.to_command();
        cmd.arg(src);
        cmd.arg("-o");
        cmd.arg(out);
        let status = cmd.spawn()?.wait()?;
        if !status.success() {
            return Err(format!("compilation command {cmd:?} failed, {status}").into());
        }
        Ok(())
    }

    fn to_command(&self) -> Command {
        let mut cmd = Command::new(&self.args[0]);
        cmd.args(&self.args[1..]);
        cmd
    }
}

fn get_var(name: &str, default: &str) -> Result<Vec<String>, Box<dyn Error>> {
    match env::var(name) {
        Ok(value) => Ok(shell_words::split(&value)?),
        Err(env::VarError::NotPresent) => Ok(shell_words::split(default)?),
        Err(err) => Err(format!("{name} {err}").into()),
    }
}

fn pkg_config_cflags(packages: &[&str]) -> Result<Vec<String>, Box<dyn Error>> {
    if packages.is_empty() {
        return Ok(Vec::new());
    }
    let pkg_config = env::var_os("PKG_CONFIG").unwrap_or_else(|| OsString::from("pkg-config"));
    let mut cmd = Command::new(pkg_config);
    cmd.arg("--cflags");
    cmd.args(packages);
    cmd.stderr(Stdio::inherit());
    let out = cmd.output()?;
    if !out.status.success() {
        let (status, stdout) = (out.status, String::from_utf8_lossy(&out.stdout));
        return Err(format!("command {cmd:?} failed, {status:?}\nstdout: {stdout}").into());
    }
    let stdout = str::from_utf8(&out.stdout)?;
    Ok(shell_words::split(stdout.trim())?)
}

#[derive(Copy, Clone, Debug, Eq, PartialEq)]
struct Layout {
    size: usize,
    alignment: usize,
}

#[derive(Copy, Clone, Debug, Default, Eq, PartialEq)]
struct Results {
    /// Number of successfully completed tests.
    passed: usize,
    /// Total number of failed tests (including those that failed to compile).
    failed: usize,
}

impl Results {
    fn record_passed(&mut self) {
        self.passed += 1;
    }
    fn record_failed(&mut self) {
        self.failed += 1;
    }
    fn summary(&self) -> String {
        format!("{} passed; {} failed", self.passed, self.failed)
    }
    fn expect_total_success(&self) {
        if self.failed == 0 {
            println!("OK: {}", self.summary());
        } else {
            panic!("FAILED: {}", self.summary());
        };
    }
}

#[test]
fn cross_validate_constants_with_c() {
    let mut c_constants: Vec<(String, String)> = Vec::new();

    for l in get_c_output("constant").unwrap().lines() {
        let (name, value) = l.split_once(';').expect("Missing ';' separator");
        c_constants.push((name.to_owned(), value.to_owned()));
    }

    let mut results = Results::default();

    for ((rust_name, rust_value), (c_name, c_value)) in
        RUST_CONSTANTS.iter().zip(c_constants.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {rust_name:?}\nC:    {c_name:?}");
            continue;
        }

        if rust_value != c_value {
            results.record_failed();
            eprintln!(
                "Constant value mismatch for {rust_name}\nRust: {rust_value:?}\nC:    {c_value:?}",
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

#[test]
fn cross_validate_layout_with_c() {
    let mut c_layouts = Vec::new();

    for l in get_c_output("layout").unwrap().lines() {
        let (name, value) = l.split_once(';').expect("Missing first ';' separator");
        let (size, alignment) = value.split_once(';').expect("Missing second ';' separator");
        let size = size.parse().expect("Failed to parse size");
        let alignment = alignment.parse().expect("Failed to parse alignment");
        c_layouts.push((name.to_owned(), Layout { size, alignment }));
    }

    let mut results = Results::default();

    for ((rust_name, rust_layout), (c_name, c_layout)) in RUST_LAYOUTS.iter().zip(c_layouts.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {rust_name:?}\nC:    {c_name:?}");
            continue;
        }

        if rust_layout != c_layout {
            results.record_failed();
            eprintln!("Layout mismatch for {rust_name}\nRust: {rust_layout:?}\nC:    {c_layout:?}",);
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

fn get_c_output(name: &str) -> Result<String, Box<dyn Error>> {
    let tmpdir = Builder::new().prefix("abi").tempdir()?;
    let exe = tmpdir.path().join(name);
    let c_file = Path::new("tests").join(name).with_extension("c");

    let cc = Compiler::new().expect("configured compiler");
    cc.compile(&c_file, &exe)?;

    let mut cmd = Command::new(exe);
    cmd.stderr(Stdio::inherit());
    let out = cmd.output()?;
    if !out.status.success() {
        let (status, stdout) = (out.status, String::from_utf8_lossy(&out.stdout));
        return Err(format!("command {cmd:?} failed, {status:?}\nstdout: {stdout}").into());
    }

    Ok(String::from_utf8(out.stdout)?)
}

const RUST_LAYOUTS: &[(&str, Layout)] = &[
    (
        "GstGLAPI",
        Layout {
            size: size_of::<GstGLAPI>(),
            alignment: align_of::<GstGLAPI>(),
        },
    ),
    (
        "GstGLAllocationParams",
        Layout {
            size: size_of::<GstGLAllocationParams>(),
            alignment: align_of::<GstGLAllocationParams>(),
        },
    ),
    (
        "GstGLAsyncDebug",
        Layout {
            size: size_of::<GstGLAsyncDebug>(),
            alignment: align_of::<GstGLAsyncDebug>(),
        },
    ),
    (
        "GstGLBaseFilter",
        Layout {
            size: size_of::<GstGLBaseFilter>(),
            alignment: align_of::<GstGLBaseFilter>(),
        },
    ),
    (
        "GstGLBaseFilterClass",
        Layout {
            size: size_of::<GstGLBaseFilterClass>(),
            alignment: align_of::<GstGLBaseFilterClass>(),
        },
    ),
    (
        "GstGLBaseMemory",
        Layout {
            size: size_of::<GstGLBaseMemory>(),
            alignment: align_of::<GstGLBaseMemory>(),
        },
    ),
    (
        "GstGLBaseMemoryAllocator",
        Layout {
            size: size_of::<GstGLBaseMemoryAllocator>(),
            alignment: align_of::<GstGLBaseMemoryAllocator>(),
        },
    ),
    (
        "GstGLBaseMemoryAllocatorClass",
        Layout {
            size: size_of::<GstGLBaseMemoryAllocatorClass>(),
            alignment: align_of::<GstGLBaseMemoryAllocatorClass>(),
        },
    ),
    (
        "GstGLBaseMemoryError",
        Layout {
            size: size_of::<GstGLBaseMemoryError>(),
            alignment: align_of::<GstGLBaseMemoryError>(),
        },
    ),
    (
        "GstGLBaseMemoryTransfer",
        Layout {
            size: size_of::<GstGLBaseMemoryTransfer>(),
            alignment: align_of::<GstGLBaseMemoryTransfer>(),
        },
    ),
    (
        "GstGLBaseMixer",
        Layout {
            size: size_of::<GstGLBaseMixer>(),
            alignment: align_of::<GstGLBaseMixer>(),
        },
    ),
    (
        "GstGLBaseMixerClass",
        Layout {
            size: size_of::<GstGLBaseMixerClass>(),
            alignment: align_of::<GstGLBaseMixerClass>(),
        },
    ),
    (
        "GstGLBaseMixerPad",
        Layout {
            size: size_of::<GstGLBaseMixerPad>(),
            alignment: align_of::<GstGLBaseMixerPad>(),
        },
    ),
    (
        "GstGLBaseMixerPadClass",
        Layout {
            size: size_of::<GstGLBaseMixerPadClass>(),
            alignment: align_of::<GstGLBaseMixerPadClass>(),
        },
    ),
    (
        "GstGLBaseSrc",
        Layout {
            size: size_of::<GstGLBaseSrc>(),
            alignment: align_of::<GstGLBaseSrc>(),
        },
    ),
    (
        "GstGLBaseSrcClass",
        Layout {
            size: size_of::<GstGLBaseSrcClass>(),
            alignment: align_of::<GstGLBaseSrcClass>(),
        },
    ),
    (
        "GstGLBuffer",
        Layout {
            size: size_of::<GstGLBuffer>(),
            alignment: align_of::<GstGLBuffer>(),
        },
    ),
    (
        "GstGLBufferAllocationParams",
        Layout {
            size: size_of::<GstGLBufferAllocationParams>(),
            alignment: align_of::<GstGLBufferAllocationParams>(),
        },
    ),
    (
        "GstGLBufferAllocator",
        Layout {
            size: size_of::<GstGLBufferAllocator>(),
            alignment: align_of::<GstGLBufferAllocator>(),
        },
    ),
    (
        "GstGLBufferAllocatorClass",
        Layout {
            size: size_of::<GstGLBufferAllocatorClass>(),
            alignment: align_of::<GstGLBufferAllocatorClass>(),
        },
    ),
    (
        "GstGLBufferPool",
        Layout {
            size: size_of::<GstGLBufferPool>(),
            alignment: align_of::<GstGLBufferPool>(),
        },
    ),
    (
        "GstGLBufferPoolClass",
        Layout {
            size: size_of::<GstGLBufferPoolClass>(),
            alignment: align_of::<GstGLBufferPoolClass>(),
        },
    ),
    (
        "GstGLColorConvert",
        Layout {
            size: size_of::<GstGLColorConvert>(),
            alignment: align_of::<GstGLColorConvert>(),
        },
    ),
    (
        "GstGLColorConvertClass",
        Layout {
            size: size_of::<GstGLColorConvertClass>(),
            alignment: align_of::<GstGLColorConvertClass>(),
        },
    ),
    (
        "GstGLConfigCaveat",
        Layout {
            size: size_of::<GstGLConfigCaveat>(),
            alignment: align_of::<GstGLConfigCaveat>(),
        },
    ),
    (
        "GstGLConfigSurfaceType",
        Layout {
            size: size_of::<GstGLConfigSurfaceType>(),
            alignment: align_of::<GstGLConfigSurfaceType>(),
        },
    ),
    (
        "GstGLContext",
        Layout {
            size: size_of::<GstGLContext>(),
            alignment: align_of::<GstGLContext>(),
        },
    ),
    (
        "GstGLContextClass",
        Layout {
            size: size_of::<GstGLContextClass>(),
            alignment: align_of::<GstGLContextClass>(),
        },
    ),
    (
        "GstGLContextError",
        Layout {
            size: size_of::<GstGLContextError>(),
            alignment: align_of::<GstGLContextError>(),
        },
    ),
    (
        "GstGLDisplay",
        Layout {
            size: size_of::<GstGLDisplay>(),
            alignment: align_of::<GstGLDisplay>(),
        },
    ),
    (
        "GstGLDisplayClass",
        Layout {
            size: size_of::<GstGLDisplayClass>(),
            alignment: align_of::<GstGLDisplayClass>(),
        },
    ),
    (
        "GstGLDisplayType",
        Layout {
            size: size_of::<GstGLDisplayType>(),
            alignment: align_of::<GstGLDisplayType>(),
        },
    ),
    (
        "GstGLDrmFormatFlags",
        Layout {
            size: size_of::<GstGLDrmFormatFlags>(),
            alignment: align_of::<GstGLDrmFormatFlags>(),
        },
    ),
    (
        "GstGLFilter",
        Layout {
            size: size_of::<GstGLFilter>(),
            alignment: align_of::<GstGLFilter>(),
        },
    ),
    (
        "GstGLFilterClass",
        Layout {
            size: size_of::<GstGLFilterClass>(),
            alignment: align_of::<GstGLFilterClass>(),
        },
    ),
    (
        "GstGLFormat",
        Layout {
            size: size_of::<GstGLFormat>(),
            alignment: align_of::<GstGLFormat>(),
        },
    ),
    (
        "GstGLFramebuffer",
        Layout {
            size: size_of::<GstGLFramebuffer>(),
            alignment: align_of::<GstGLFramebuffer>(),
        },
    ),
    (
        "GstGLFramebufferClass",
        Layout {
            size: size_of::<GstGLFramebufferClass>(),
            alignment: align_of::<GstGLFramebufferClass>(),
        },
    ),
    (
        "GstGLMemory",
        Layout {
            size: size_of::<GstGLMemory>(),
            alignment: align_of::<GstGLMemory>(),
        },
    ),
    (
        "GstGLMemoryAllocator",
        Layout {
            size: size_of::<GstGLMemoryAllocator>(),
            alignment: align_of::<GstGLMemoryAllocator>(),
        },
    ),
    (
        "GstGLMemoryAllocatorClass",
        Layout {
            size: size_of::<GstGLMemoryAllocatorClass>(),
            alignment: align_of::<GstGLMemoryAllocatorClass>(),
        },
    ),
    (
        "GstGLMemoryPBO",
        Layout {
            size: size_of::<GstGLMemoryPBO>(),
            alignment: align_of::<GstGLMemoryPBO>(),
        },
    ),
    (
        "GstGLMemoryPBOAllocator",
        Layout {
            size: size_of::<GstGLMemoryPBOAllocator>(),
            alignment: align_of::<GstGLMemoryPBOAllocator>(),
        },
    ),
    (
        "GstGLMemoryPBOAllocatorClass",
        Layout {
            size: size_of::<GstGLMemoryPBOAllocatorClass>(),
            alignment: align_of::<GstGLMemoryPBOAllocatorClass>(),
        },
    ),
    (
        "GstGLMixer",
        Layout {
            size: size_of::<GstGLMixer>(),
            alignment: align_of::<GstGLMixer>(),
        },
    ),
    (
        "GstGLMixerClass",
        Layout {
            size: size_of::<GstGLMixerClass>(),
            alignment: align_of::<GstGLMixerClass>(),
        },
    ),
    (
        "GstGLMixerPad",
        Layout {
            size: size_of::<GstGLMixerPad>(),
            alignment: align_of::<GstGLMixerPad>(),
        },
    ),
    (
        "GstGLMixerPadClass",
        Layout {
            size: size_of::<GstGLMixerPadClass>(),
            alignment: align_of::<GstGLMixerPadClass>(),
        },
    ),
    (
        "GstGLOverlayCompositor",
        Layout {
            size: size_of::<GstGLOverlayCompositor>(),
            alignment: align_of::<GstGLOverlayCompositor>(),
        },
    ),
    (
        "GstGLOverlayCompositorClass",
        Layout {
            size: size_of::<GstGLOverlayCompositorClass>(),
            alignment: align_of::<GstGLOverlayCompositorClass>(),
        },
    ),
    (
        "GstGLPlatform",
        Layout {
            size: size_of::<GstGLPlatform>(),
            alignment: align_of::<GstGLPlatform>(),
        },
    ),
    (
        "GstGLQuery",
        Layout {
            size: size_of::<GstGLQuery>(),
            alignment: align_of::<GstGLQuery>(),
        },
    ),
    (
        "GstGLQueryType",
        Layout {
            size: size_of::<GstGLQueryType>(),
            alignment: align_of::<GstGLQueryType>(),
        },
    ),
    (
        "GstGLRenderbuffer",
        Layout {
            size: size_of::<GstGLRenderbuffer>(),
            alignment: align_of::<GstGLRenderbuffer>(),
        },
    ),
    (
        "GstGLRenderbufferAllocationParams",
        Layout {
            size: size_of::<GstGLRenderbufferAllocationParams>(),
            alignment: align_of::<GstGLRenderbufferAllocationParams>(),
        },
    ),
    (
        "GstGLRenderbufferAllocator",
        Layout {
            size: size_of::<GstGLRenderbufferAllocator>(),
            alignment: align_of::<GstGLRenderbufferAllocator>(),
        },
    ),
    (
        "GstGLRenderbufferAllocatorClass",
        Layout {
            size: size_of::<GstGLRenderbufferAllocatorClass>(),
            alignment: align_of::<GstGLRenderbufferAllocatorClass>(),
        },
    ),
    (
        "GstGLSLError",
        Layout {
            size: size_of::<GstGLSLError>(),
            alignment: align_of::<GstGLSLError>(),
        },
    ),
    (
        "GstGLSLProfile",
        Layout {
            size: size_of::<GstGLSLProfile>(),
            alignment: align_of::<GstGLSLProfile>(),
        },
    ),
    (
        "GstGLSLStage",
        Layout {
            size: size_of::<GstGLSLStage>(),
            alignment: align_of::<GstGLSLStage>(),
        },
    ),
    (
        "GstGLSLStageClass",
        Layout {
            size: size_of::<GstGLSLStageClass>(),
            alignment: align_of::<GstGLSLStageClass>(),
        },
    ),
    (
        "GstGLSLVersion",
        Layout {
            size: size_of::<GstGLSLVersion>(),
            alignment: align_of::<GstGLSLVersion>(),
        },
    ),
    (
        "GstGLShader",
        Layout {
            size: size_of::<GstGLShader>(),
            alignment: align_of::<GstGLShader>(),
        },
    ),
    (
        "GstGLShaderClass",
        Layout {
            size: size_of::<GstGLShaderClass>(),
            alignment: align_of::<GstGLShaderClass>(),
        },
    ),
    (
        "GstGLStereoDownmix",
        Layout {
            size: size_of::<GstGLStereoDownmix>(),
            alignment: align_of::<GstGLStereoDownmix>(),
        },
    ),
    (
        "GstGLSyncMeta",
        Layout {
            size: size_of::<GstGLSyncMeta>(),
            alignment: align_of::<GstGLSyncMeta>(),
        },
    ),
    (
        "GstGLTextureTarget",
        Layout {
            size: size_of::<GstGLTextureTarget>(),
            alignment: align_of::<GstGLTextureTarget>(),
        },
    ),
    (
        "GstGLUpload",
        Layout {
            size: size_of::<GstGLUpload>(),
            alignment: align_of::<GstGLUpload>(),
        },
    ),
    (
        "GstGLUploadClass",
        Layout {
            size: size_of::<GstGLUploadClass>(),
            alignment: align_of::<GstGLUploadClass>(),
        },
    ),
    (
        "GstGLUploadReturn",
        Layout {
            size: size_of::<GstGLUploadReturn>(),
            alignment: align_of::<GstGLUploadReturn>(),
        },
    ),
    (
        "GstGLVideoAllocationParams",
        Layout {
            size: size_of::<GstGLVideoAllocationParams>(),
            alignment: align_of::<GstGLVideoAllocationParams>(),
        },
    ),
    (
        "GstGLViewConvert",
        Layout {
            size: size_of::<GstGLViewConvert>(),
            alignment: align_of::<GstGLViewConvert>(),
        },
    ),
    (
        "GstGLViewConvertClass",
        Layout {
            size: size_of::<GstGLViewConvertClass>(),
            alignment: align_of::<GstGLViewConvertClass>(),
        },
    ),
    (
        "GstGLWindow",
        Layout {
            size: size_of::<GstGLWindow>(),
            alignment: align_of::<GstGLWindow>(),
        },
    ),
    (
        "GstGLWindowClass",
        Layout {
            size: size_of::<GstGLWindowClass>(),
            alignment: align_of::<GstGLWindowClass>(),
        },
    ),
    (
        "GstGLWindowError",
        Layout {
            size: size_of::<GstGLWindowError>(),
            alignment: align_of::<GstGLWindowError>(),
        },
    ),
];

const RUST_CONSTANTS: &[(&str, &str)] = &[
    (
        "GST_BUFFER_POOL_OPTION_GL_SYNC_META",
        "GstBufferPoolOptionGLSyncMeta",
    ),
    (
        "GST_BUFFER_POOL_OPTION_GL_TEXTURE_TARGET_2D",
        "GstBufferPoolOptionGLTextureTarget2D",
    ),
    (
        "GST_BUFFER_POOL_OPTION_GL_TEXTURE_TARGET_EXTERNAL_OES",
        "GstBufferPoolOptionGLTextureTargetExternalOES",
    ),
    (
        "GST_BUFFER_POOL_OPTION_GL_TEXTURE_TARGET_RECTANGLE",
        "GstBufferPoolOptionGLTextureTargetRectangle",
    ),
    ("GST_CAPS_FEATURE_MEMORY_GL_BUFFER", "memory:GLBuffer"),
    ("GST_CAPS_FEATURE_MEMORY_GL_MEMORY", "memory:GLMemory"),
    ("(gint) GST_GLSL_ERROR_COMPILE", "0"),
    ("(gint) GST_GLSL_ERROR_LINK", "1"),
    ("(gint) GST_GLSL_ERROR_PROGRAM", "2"),
    ("(guint) GST_GLSL_PROFILE_ANY", "4294967295"),
    ("(guint) GST_GLSL_PROFILE_COMPATIBILITY", "4"),
    ("(guint) GST_GLSL_PROFILE_CORE", "2"),
    ("(guint) GST_GLSL_PROFILE_ES", "1"),
    ("(guint) GST_GLSL_PROFILE_NONE", "0"),
    ("(gint) GST_GLSL_VERSION_100", "100"),
    ("(gint) GST_GLSL_VERSION_110", "110"),
    ("(gint) GST_GLSL_VERSION_120", "120"),
    ("(gint) GST_GLSL_VERSION_130", "130"),
    ("(gint) GST_GLSL_VERSION_140", "140"),
    ("(gint) GST_GLSL_VERSION_150", "150"),
    ("(gint) GST_GLSL_VERSION_300", "300"),
    ("(gint) GST_GLSL_VERSION_310", "310"),
    ("(gint) GST_GLSL_VERSION_320", "320"),
    ("(gint) GST_GLSL_VERSION_330", "330"),
    ("(gint) GST_GLSL_VERSION_400", "400"),
    ("(gint) GST_GLSL_VERSION_410", "410"),
    ("(gint) GST_GLSL_VERSION_420", "420"),
    ("(gint) GST_GLSL_VERSION_430", "430"),
    ("(gint) GST_GLSL_VERSION_440", "440"),
    ("(gint) GST_GLSL_VERSION_450", "450"),
    ("(gint) GST_GLSL_VERSION_NONE", "0"),
    ("GST_GL_ALLOCATION_PARAMS_ALLOC_FLAG_ALLOC", "1"),
    ("GST_GL_ALLOCATION_PARAMS_ALLOC_FLAG_BUFFER", "16"),
    ("GST_GL_ALLOCATION_PARAMS_ALLOC_FLAG_USER", "65536"),
    ("GST_GL_ALLOCATION_PARAMS_ALLOC_FLAG_VIDEO", "8"),
    ("GST_GL_ALLOCATION_PARAMS_ALLOC_FLAG_WRAP_GPU_HANDLE", "4"),
    ("GST_GL_ALLOCATION_PARAMS_ALLOC_FLAG_WRAP_SYSMEM", "2"),
    ("(gint) GST_GL_ALPHA", "6406"),
    ("(guint) GST_GL_API_ANY", "4294967295"),
    ("(guint) GST_GL_API_GLES1", "32768"),
    ("GST_GL_API_GLES1_NAME", "gles1"),
    ("(guint) GST_GL_API_GLES2", "65536"),
    ("GST_GL_API_GLES2_NAME", "gles2"),
    ("(guint) GST_GL_API_NONE", "0"),
    ("(guint) GST_GL_API_OPENGL", "1"),
    ("(guint) GST_GL_API_OPENGL3", "2"),
    ("GST_GL_API_OPENGL3_NAME", "opengl3"),
    ("GST_GL_API_OPENGL_NAME", "opengl"),
    ("GST_GL_BASE_MEMORY_ALLOCATOR_NAME", "GLBaseMemory"),
    ("(gint) GST_GL_BASE_MEMORY_ERROR_FAILED", "0"),
    ("(gint) GST_GL_BASE_MEMORY_ERROR_OLD_LIBS", "1"),
    ("(gint) GST_GL_BASE_MEMORY_ERROR_RESOURCE_UNAVAILABLE", "2"),
    (
        "(guint) GST_GL_BASE_MEMORY_TRANSFER_NEED_DOWNLOAD",
        "1048576",
    ),
    ("(guint) GST_GL_BASE_MEMORY_TRANSFER_NEED_UPLOAD", "2097152"),
    ("GST_GL_BUFFER_ALLOCATOR_NAME", "GLBuffer"),
    ("(gint) GST_GL_CONFIG_CAVEAT_NONE", "0"),
    ("(gint) GST_GL_CONFIG_CAVEAT_NON_CONFORMANT", "2"),
    ("(gint) GST_GL_CONFIG_CAVEAT_SLOW", "1"),
    ("GST_GL_CONFIG_STRUCTURE_NAME", "gst-gl-context-config"),
    ("(guint) GST_GL_CONFIG_SURFACE_TYPE_NONE", "0"),
    ("(guint) GST_GL_CONFIG_SURFACE_TYPE_PBUFFER", "2"),
    ("(guint) GST_GL_CONFIG_SURFACE_TYPE_PIXMAP", "4"),
    ("(guint) GST_GL_CONFIG_SURFACE_TYPE_WINDOW", "1"),
    ("(gint) GST_GL_CONTEXT_ERROR_CREATE_CONTEXT", "4"),
    ("(gint) GST_GL_CONTEXT_ERROR_FAILED", "0"),
    ("(gint) GST_GL_CONTEXT_ERROR_OLD_LIBS", "3"),
    ("(gint) GST_GL_CONTEXT_ERROR_RESOURCE_UNAVAILABLE", "5"),
    ("(gint) GST_GL_CONTEXT_ERROR_WRONG_API", "2"),
    ("(gint) GST_GL_CONTEXT_ERROR_WRONG_CONFIG", "1"),
    ("GST_GL_CONTEXT_TYPE_CGL", "gst.gl.context.CGL"),
    ("GST_GL_CONTEXT_TYPE_EAGL", "gst.gl.context.EAGL"),
    ("GST_GL_CONTEXT_TYPE_EGL", "gst.gl.context.EGL"),
    ("GST_GL_CONTEXT_TYPE_GLX", "gst.gl.context.GLX"),
    ("GST_GL_CONTEXT_TYPE_WGL", "gst.gl.context.WGL"),
    ("(gint) GST_GL_DEPTH24_STENCIL8", "35056"),
    ("(gint) GST_GL_DEPTH_COMPONENT16", "33189"),
    ("GST_GL_DISPLAY_CONTEXT_TYPE", "gst.gl.GLDisplay"),
    ("(guint) GST_GL_DISPLAY_TYPE_ANDROID", "2048"),
    ("(guint) GST_GL_DISPLAY_TYPE_ANY", "4294967295"),
    ("(guint) GST_GL_DISPLAY_TYPE_COCOA", "4"),
    ("(guint) GST_GL_DISPLAY_TYPE_DISPMANX", "16"),
    ("(guint) GST_GL_DISPLAY_TYPE_EAGL", "512"),
    ("(guint) GST_GL_DISPLAY_TYPE_EGL", "32"),
    ("(guint) GST_GL_DISPLAY_TYPE_EGL_DEVICE", "256"),
    ("(guint) GST_GL_DISPLAY_TYPE_EGL_SURFACELESS", "4096"),
    ("(guint) GST_GL_DISPLAY_TYPE_GBM", "128"),
    ("(guint) GST_GL_DISPLAY_TYPE_NONE", "0"),
    ("(guint) GST_GL_DISPLAY_TYPE_VIV_FB", "64"),
    ("(guint) GST_GL_DISPLAY_TYPE_WAYLAND", "2"),
    ("(guint) GST_GL_DISPLAY_TYPE_WIN32", "8"),
    ("(guint) GST_GL_DISPLAY_TYPE_WINRT", "1024"),
    ("(guint) GST_GL_DISPLAY_TYPE_X11", "1"),
    ("(guint) GST_GL_DRM_FORMAT_DIRECT_IMPORT", "8"),
    ("(guint) GST_GL_DRM_FORMAT_INCLUDE_EMULATED", "4"),
    ("(guint) GST_GL_DRM_FORMAT_INCLUDE_EXTERNAL", "1"),
    ("(guint) GST_GL_DRM_FORMAT_LINEAR_ONLY", "2"),
    ("(gint) GST_GL_LUMINANCE", "6409"),
    ("(gint) GST_GL_LUMINANCE_ALPHA", "6410"),
    ("GST_GL_MEMORY_ALLOCATOR_NAME", "GLMemory"),
    ("GST_GL_MEMORY_PBO_ALLOCATOR_NAME", "GLMemoryPBO"),
    ("(guint) GST_GL_PLATFORM_ANY", "4294967295"),
    ("(guint) GST_GL_PLATFORM_CGL", "8"),
    ("(guint) GST_GL_PLATFORM_EAGL", "16"),
    ("(guint) GST_GL_PLATFORM_EGL", "1"),
    ("(guint) GST_GL_PLATFORM_GLX", "2"),
    ("(guint) GST_GL_PLATFORM_NONE", "0"),
    ("(guint) GST_GL_PLATFORM_WGL", "4"),
    ("(gint) GST_GL_QUERY_NONE", "0"),
    ("(gint) GST_GL_QUERY_TIMESTAMP", "2"),
    ("(gint) GST_GL_QUERY_TIME_ELAPSED", "1"),
    ("(gint) GST_GL_R16", "33322"),
    ("(gint) GST_GL_R8", "33321"),
    ("(gint) GST_GL_RED", "6403"),
    ("GST_GL_RENDERBUFFER_ALLOCATOR_NAME", "GLRenderbuffer"),
    ("(gint) GST_GL_RG", "33319"),
    ("(gint) GST_GL_RG16", "33324"),
    ("(gint) GST_GL_RG8", "33323"),
    ("(gint) GST_GL_RGB", "6407"),
    ("(gint) GST_GL_RGB10_A2", "32857"),
    ("(gint) GST_GL_RGB16", "32852"),
    ("(gint) GST_GL_RGB565", "36194"),
    ("(gint) GST_GL_RGB8", "32849"),
    ("(gint) GST_GL_RGBA", "6408"),
    ("(gint) GST_GL_RGBA16", "32859"),
    ("(gint) GST_GL_RGBA8", "32856"),
    (
        "(gint) GST_GL_STEREO_DOWNMIX_ANAGLYPH_AMBER_BLUE_DUBOIS",
        "2",
    ),
    (
        "(gint) GST_GL_STEREO_DOWNMIX_ANAGLYPH_GREEN_MAGENTA_DUBOIS",
        "0",
    ),
    ("(gint) GST_GL_STEREO_DOWNMIX_ANAGLYPH_RED_CYAN_DUBOIS", "1"),
    ("(gint) GST_GL_TEXTURE_TARGET_2D", "1"),
    ("GST_GL_TEXTURE_TARGET_2D_STR", "2D"),
    ("(gint) GST_GL_TEXTURE_TARGET_EXTERNAL_OES", "3"),
    ("GST_GL_TEXTURE_TARGET_EXTERNAL_OES_STR", "external-oes"),
    ("(gint) GST_GL_TEXTURE_TARGET_NONE", "0"),
    ("(gint) GST_GL_TEXTURE_TARGET_RECTANGLE", "2"),
    ("GST_GL_TEXTURE_TARGET_RECTANGLE_STR", "rectangle"),
    ("(gint) GST_GL_UPLOAD_DONE", "1"),
    ("(gint) GST_GL_UPLOAD_ERROR", "-1"),
    ("(gint) GST_GL_UPLOAD_RECONFIGURE", "-3"),
    ("(gint) GST_GL_UPLOAD_UNSHARED_GL_CONTEXT", "-100"),
    ("(gint) GST_GL_UPLOAD_UNSUPPORTED", "-2"),
    ("(gint) GST_GL_WINDOW_ERROR_FAILED", "0"),
    ("(gint) GST_GL_WINDOW_ERROR_OLD_LIBS", "1"),
    ("(gint) GST_GL_WINDOW_ERROR_RESOURCE_UNAVAILABLE", "2"),
    ("GST_MAP_GL", "131072"),
];
